/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.common;

import com.sun.javafx.iio.common.PushbroomScaler;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SmoothMinifier
implements PushbroomScaler {
    protected int sourceWidth;
    protected int sourceHeight;
    protected int numBands;
    protected int destWidth;
    protected int destHeight;
    protected double scaleY;
    protected ByteBuffer destBuf;
    protected int boxHeight;
    protected byte[][] sourceData;
    protected int[] leftPoints;
    protected int[] rightPoints;
    protected int[] topPoints;
    protected int[] bottomPoints;
    protected int sourceLine;
    protected int sourceDataLine;
    protected int destLine;
    protected int[] tmpBuf;

    SmoothMinifier(int sourceWidth, int sourceHeight, int numBands, int destWidth, int destHeight) {
        if (sourceWidth <= 0 || sourceHeight <= 0 || numBands <= 0 || destWidth <= 0 || destHeight <= 0 || destWidth > sourceWidth || destHeight > sourceHeight) {
            throw new IllegalArgumentException();
        }
        this.sourceWidth = sourceWidth;
        this.sourceHeight = sourceHeight;
        this.numBands = numBands;
        this.destWidth = destWidth;
        this.destHeight = destHeight;
        this.destBuf = ByteBuffer.wrap(new byte[destHeight * destWidth * numBands]);
        double scaleX = (double)sourceWidth / (double)destWidth;
        this.scaleY = (double)sourceHeight / (double)destHeight;
        int boxWidth = (sourceWidth + destWidth - 1) / destWidth;
        this.boxHeight = (sourceHeight + destHeight - 1) / destHeight;
        int boxLeft = boxWidth / 2;
        int boxRight = boxWidth - boxLeft - 1;
        int boxTop = this.boxHeight / 2;
        int boxBottom = this.boxHeight - boxTop - 1;
        this.sourceData = new byte[this.boxHeight][destWidth * numBands];
        this.leftPoints = new int[destWidth];
        this.rightPoints = new int[destWidth];
        for (int dx = 0; dx < destWidth; ++dx) {
            int sx = (int)((double)dx * scaleX);
            this.leftPoints[dx] = sx - boxLeft;
            this.rightPoints[dx] = sx + boxRight;
        }
        this.topPoints = new int[destHeight];
        this.bottomPoints = new int[destHeight];
        for (int dy = 0; dy < destHeight; ++dy) {
            int sy = (int)((double)dy * this.scaleY);
            this.topPoints[dy] = sy - boxTop;
            this.bottomPoints[dy] = sy + boxBottom;
        }
        this.sourceLine = 0;
        this.sourceDataLine = 0;
        this.destLine = 0;
        this.tmpBuf = new int[destWidth * numBands];
    }

    @Override
    public ByteBuffer getDestination() {
        return this.destBuf;
    }

    @Override
    public boolean putSourceScanline(byte[] scanline, int off) {
        if (off < 0) {
            throw new IllegalArgumentException("off < 0!");
        }
        if (this.numBands == 1) {
            int leftSample = scanline[off] & 0xFF;
            int rightSample = scanline[off + this.sourceWidth - 1] & 0xFF;
            for (int i = 0; i < this.destWidth; ++i) {
                int val = 0;
                int rightBound = this.rightPoints[i];
                for (int j = this.leftPoints[i]; j <= rightBound; ++j) {
                    if (j < 0) {
                        val += leftSample;
                        continue;
                    }
                    if (j >= this.sourceWidth) {
                        val += rightSample;
                        continue;
                    }
                    val += scanline[off + j] & 0xFF;
                }
                this.sourceData[this.sourceDataLine][i] = (byte)(val /= rightBound - this.leftPoints[i] + 1);
            }
        } else {
            int rightOff = off + (this.sourceWidth - 1) * this.numBands;
            for (int i = 0; i < this.destWidth; ++i) {
                int leftBound = this.leftPoints[i];
                int rightBound = this.rightPoints[i];
                int numPoints = rightBound - leftBound + 1;
                int iBands = i * this.numBands;
                for (int k = 0; k < this.numBands; ++k) {
                    int leftSample = scanline[off + k] & 0xFF;
                    int rightSample = scanline[rightOff + k] & 0xFF;
                    int val = 0;
                    for (int j = leftBound; j <= rightBound; ++j) {
                        if (j < 0) {
                            val += leftSample;
                            continue;
                        }
                        if (j >= this.sourceWidth) {
                            val += rightSample;
                            continue;
                        }
                        val += scanline[off + j * this.numBands + k] & 0xFF;
                    }
                    this.sourceData[this.sourceDataLine][iBands + k] = (byte)(val /= numPoints);
                }
            }
        }
        if (this.sourceLine == this.bottomPoints[this.destLine] || this.destLine == this.destHeight - 1 && this.sourceLine == this.sourceHeight - 1) {
            assert (this.destBuf.hasArray()) : "destBuf.hasArray() == false => destBuf is direct";
            byte[] dest = this.destBuf.array();
            int destOffset = this.destLine * this.destWidth * this.numBands;
            Arrays.fill(this.tmpBuf, 0);
            for (int y = this.topPoints[this.destLine]; y <= this.bottomPoints[this.destLine]; ++y) {
                int index = 0;
                index = y < 0 ? 0 - this.sourceLine + this.sourceDataLine : (y >= this.sourceHeight ? (this.sourceHeight - 1 - this.sourceLine + this.sourceDataLine) % this.boxHeight : (y - this.sourceLine + this.sourceDataLine) % this.boxHeight);
                if (index < 0) {
                    index += this.boxHeight;
                }
                byte[] b = this.sourceData[index];
                int destLen = b.length;
                for (int x = 0; x < destLen; ++x) {
                    int n = x;
                    this.tmpBuf[n] = this.tmpBuf[n] + (b[x] & 0xFF);
                }
            }
            int sourceLen = this.tmpBuf.length;
            for (int x = 0; x < sourceLen; ++x) {
                dest[destOffset + x] = (byte)(this.tmpBuf[x] / this.boxHeight);
            }
            if (this.destLine < this.destHeight - 1) {
                ++this.destLine;
            }
        }
        if (++this.sourceLine != this.sourceHeight) {
            this.sourceDataLine = (this.sourceDataLine + 1) % this.boxHeight;
        }
        return this.destLine == this.destHeight;
    }
}

