/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.CharToGlyphMapper;
import com.sun.javafx.font.CompositeFontResource;
import com.sun.javafx.font.CompositeGlyphMapper;
import com.sun.javafx.font.CompositeStrike;
import com.sun.javafx.font.Disposer;
import com.sun.javafx.font.FontConfigManager;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.geom.transform.BaseTransform;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class FallbackResource
implements CompositeFontResource {
    private ArrayList<String> linkedFontFiles;
    private ArrayList<String> linkedFontNames;
    private FontResource[] fallbacks;
    private FontResource[] nativeFallbacks;
    private boolean isBold;
    private boolean isItalic;
    private int aaMode;
    private CompositeGlyphMapper mapper;
    Map<FontStrikeDesc, WeakReference<FontStrike>> strikeMap = new ConcurrentHashMap<FontStrikeDesc, WeakReference<FontStrike>>();
    static FallbackResource[] greyFallBackResource = new FallbackResource[4];
    static FallbackResource[] lcdFallBackResource = new FallbackResource[4];

    @Override
    public Map<FontStrikeDesc, WeakReference<FontStrike>> getStrikeMap() {
        return this.strikeMap;
    }

    FallbackResource(boolean bold, boolean italic, int aaMode) {
        this.isBold = bold;
        this.isItalic = italic;
        this.aaMode = aaMode;
    }

    static FallbackResource getFallbackResource(boolean bold, boolean italic, int aaMode) {
        FallbackResource font;
        int index;
        FallbackResource[] arr = aaMode == 0 ? greyFallBackResource : lcdFallBackResource;
        int n = index = bold ? 1 : 0;
        if (italic) {
            index += 2;
        }
        if ((font = arr[index]) == null) {
            arr[index] = font = new FallbackResource(bold, italic, aaMode);
        }
        return font;
    }

    @Override
    public int getDefaultAAMode() {
        return this.aaMode;
    }

    private String throwException() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String getFullName() {
        return this.throwException();
    }

    @Override
    public String getPSName() {
        return this.throwException();
    }

    @Override
    public String getFamilyName() {
        return this.throwException();
    }

    @Override
    public String getStyleName() {
        return this.throwException();
    }

    @Override
    public String getLocaleFullName() {
        return this.throwException();
    }

    @Override
    public String getLocaleFamilyName() {
        return this.throwException();
    }

    @Override
    public String getLocaleStyleName() {
        return this.throwException();
    }

    @Override
    public boolean isBold() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean isItalic() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getFeatures() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String getFileName() {
        return this.throwException();
    }

    @Override
    public Object getPeer() {
        return null;
    }

    @Override
    public void setPeer(Object peer) {
        this.throwException();
    }

    @Override
    public boolean isEmbeddedFont() {
        return false;
    }

    @Override
    public CharToGlyphMapper getGlyphMapper() {
        if (this.mapper == null) {
            this.mapper = new CompositeGlyphMapper(this);
        }
        return this.mapper;
    }

    @Override
    public int getSlotForFont(String fontName) {
        FontResource[] tmp;
        this.getLinkedFonts();
        int i = 0;
        for (String linkedFontName : this.linkedFontNames) {
            if (fontName.equalsIgnoreCase(linkedFontName)) {
                return i;
            }
            ++i;
        }
        if (this.nativeFallbacks != null) {
            for (FontResource nativeFallback : this.nativeFallbacks) {
                if (fontName.equalsIgnoreCase(nativeFallback.getFullName())) {
                    return i;
                }
                ++i;
            }
        }
        if (i >= 126) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("\tToo many font fallbacks!");
            }
            return -1;
        }
        PrismFontFactory factory = PrismFontFactory.getFontFactory();
        FontResource fr = factory.getFontResource(fontName, null, false);
        if (fr == null) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("\t Font name not supported \"" + fontName + "\".");
            }
            return -1;
        }
        if (this.nativeFallbacks == null) {
            tmp = new FontResource[1];
        } else {
            tmp = new FontResource[this.nativeFallbacks.length + 1];
            System.arraycopy(this.nativeFallbacks, 0, tmp, 0, this.nativeFallbacks.length);
        }
        tmp[tmp.length - 1] = fr;
        this.nativeFallbacks = tmp;
        return i;
    }

    private void getLinkedFonts() {
        if (this.fallbacks == null) {
            if (PrismFontFactory.isLinux) {
                FontConfigManager.FcCompFont font = FontConfigManager.getFontConfigFont("sans", this.isBold, this.isItalic);
                this.linkedFontFiles = FontConfigManager.getFileNames(font, false);
                this.linkedFontNames = FontConfigManager.getFontNames(font, false);
                this.fallbacks = new FontResource[this.linkedFontFiles.size()];
            } else {
                ArrayList<String>[] linkedFontInfo = PrismFontFactory.isMacOSX ? PrismFontFactory.getLinkedFonts("Arial Unicode MS", true) : PrismFontFactory.getLinkedFonts("Tahoma", true);
                this.linkedFontFiles = linkedFontInfo[0];
                this.linkedFontNames = linkedFontInfo[1];
                this.fallbacks = new FontResource[this.linkedFontFiles.size()];
            }
        }
    }

    @Override
    public int getNumSlots() {
        this.getLinkedFonts();
        int num = this.linkedFontFiles.size();
        if (this.nativeFallbacks != null) {
            num += this.nativeFallbacks.length;
        }
        return num;
    }

    @Override
    public float[] getGlyphBoundingBox(int glyphCode, float size, float[] retArr) {
        int slot = glyphCode >>> 24;
        int slotglyphCode = glyphCode & 0xFFFFFF;
        FontResource slotResource = this.getSlotResource(slot);
        return slotResource.getGlyphBoundingBox(slotglyphCode, size, retArr);
    }

    @Override
    public float getAdvance(int glyphCode, float size) {
        int slot = glyphCode >>> 24;
        int slotglyphCode = glyphCode & 0xFFFFFF;
        FontResource slotResource = this.getSlotResource(slot);
        return slotResource.getAdvance(slotglyphCode, size);
    }

    @Override
    public synchronized FontResource getSlotResource(int slot) {
        this.getLinkedFonts();
        if (slot >= this.fallbacks.length) {
            if (this.nativeFallbacks == null || (slot -= this.fallbacks.length) >= this.nativeFallbacks.length) {
                return null;
            }
            return this.nativeFallbacks[slot];
        }
        if (this.fallbacks[slot] == null) {
            String file = this.linkedFontFiles.get(slot);
            String name = this.linkedFontNames.get(slot);
            this.fallbacks[slot] = PrismFontFactory.getFontFactory().getFontResource(name, file, false);
        }
        return this.fallbacks[slot];
    }

    @Override
    public FontStrike getStrike(float size, BaseTransform transform) {
        return this.getStrike(size, transform, this.getDefaultAAMode());
    }

    @Override
    public FontStrike getStrike(float size, BaseTransform transform, int aaMode) {
        FontStrikeDesc desc = new FontStrikeDesc(size, transform, aaMode);
        WeakReference<CompositeStrike> ref = this.strikeMap.get(desc);
        CompositeStrike strike = null;
        if (ref != null) {
            strike = (CompositeStrike)ref.get();
        }
        if (strike == null) {
            strike = new CompositeStrike(this, size, transform, aaMode, desc);
            ref = strike.disposer != null ? Disposer.addRecord(strike, strike.disposer) : new WeakReference<CompositeStrike>(strike);
            this.strikeMap.put(desc, ref);
        }
        return strike;
    }
}

