/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.zoom;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.standard.AbstractTool;

public abstract class AreaTracker
extends AbstractTool {
    private Rectangle area;

    protected AreaTracker(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    public Rectangle getArea() {
        return new Rectangle(this.area.x, this.area.y, this.area.width, this.area.height);
    }

    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDown(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
        this.rubberBand(this.getAnchorX(), this.getAnchorY(), this.getAnchorX(), this.getAnchorY());
    }

    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        super.mouseDrag(mouseEvent, n, n2);
        this.eraseRubberBand();
        this.rubberBand(this.getAnchorX(), this.getAnchorY(), n, n2);
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        super.mouseUp(mouseEvent, n, n2);
        this.eraseRubberBand();
    }

    private void rubberBand(int n, int n2, int n3, int n4) {
        this.area = new Rectangle(new Point(n, n2));
        this.area.add(new Point(n3, n4));
        this.drawXORRect(this.area);
    }

    private void eraseRubberBand() {
        this.drawXORRect(this.area);
    }

    private void drawXORRect(Rectangle rectangle) {
        Graphics graphics = this.view().getGraphics();
        graphics.setXORMode(this.view().getBackground());
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

