/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jhotdraw.figures.AttributeFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.BoxHandleKit;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.OffsetLocator;
import org.jhotdraw.standard.TextHolder;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.ColorMap;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class TextAreaFigure
extends AttributeFigure
implements FigureChangeListener,
TextHolder {
    protected boolean fTextIsDirty = true;
    protected transient boolean fSizeIsDirty = true;
    private Rectangle fDisplayBox;
    protected List fParagraphs;
    protected String fText;
    protected Font fFont;
    protected boolean fFontIsDirty = true;
    protected float fFontWidth;
    protected Hashtable attributesMap = new Hashtable();
    protected boolean fIsReadOnly;
    protected Figure fObservedFigure = null;
    protected OffsetLocator fLocator = null;
    static final long serialVersionUID = 4993631445423148845L;

    public TextAreaFigure() {
        this.fParagraphs = CollectionsFactory.current().createList();
        this.fDisplayBox = new Rectangle(0, 0, 30, 15);
        this.fFont = this.createFont();
        this.fText = new String("");
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String string) {
        if (string == null || !string.equals(this.fText)) {
            this.markTextDirty();
            this.fText = string;
            this.changed();
        }
    }

    public Rectangle textDisplayBox() {
        return this.displayBox();
    }

    public Font createFont() {
        return new Font((String)this.getAttribute("FontName"), (int)((Integer)this.getAttribute("FontStyle")), (Integer)this.getAttribute("FontSize"));
    }

    public boolean isReadOnly() {
        return this.fIsReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this.fIsReadOnly = bl;
    }

    public boolean acceptsTyping() {
        return !this.isReadOnly();
    }

    protected void markTextDirty() {
        this.setTextDirty(true);
    }

    protected void setTextDirty(boolean bl) {
        this.fTextIsDirty = bl;
    }

    public boolean isTextDirty() {
        return this.fTextIsDirty;
    }

    protected void markSizeDirty() {
        this.setSizeDirty(true);
    }

    public void setSizeDirty(boolean bl) {
        this.fSizeIsDirty = bl;
    }

    public boolean isSizeDirty() {
        return this.fSizeIsDirty;
    }

    public Font getFont() {
        return this.fFont;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException();
        }
        this.willChange();
        this.fFont = font;
        this.markSizeDirty();
        this.markFontDirty();
        this.attributesMap = new Hashtable(1);
        this.attributesMap.put(TextAttribute.FONT, font);
        this.changed();
    }

    public int overlayColumns() {
        return 0;
    }

    public void basicDisplayBox(Point point, Point point2) {
        Dimension dimension = this.fDisplayBox.getSize();
        this.fDisplayBox = new Rectangle(point);
        this.fDisplayBox.add(point2);
        if (!this.fDisplayBox.getSize().equals(dimension)) {
            this.markSizeDirty();
        }
    }

    public HandleEnumeration handles() {
        List list = CollectionsFactory.current().createList();
        BoxHandleKit.addHandles(this, list);
        return new HandleEnumerator(list);
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    public void moveBy(int n, int n2) {
        this.willChange();
        this.basicMoveBy(n, n2);
        if (this.fLocator != null) {
            this.fLocator.moveBy(n, n2);
        }
        this.changed();
    }

    protected void basicMoveBy(int n, int n2) {
        this.fDisplayBox.translate(n, n2);
    }

    public void drawBackground(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
        this.drawText(graphics, this.displayBox());
    }

    public void drawFrame(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor((Color)this.getAttribute("FrameColor"));
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected float drawText(Graphics graphics, Rectangle rectangle) {
        Object object;
        Object object2;
        float f;
        Object object3;
        Graphics2D graphics2D = null;
        Shape shape = null;
        Color color = null;
        Rectangle2D rectangle2D = null;
        RenderingHints renderingHints = null;
        if (graphics != null) {
            graphics2D = (Graphics2D)graphics;
            renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            color = graphics2D.getColor();
            shape = graphics2D.getClip();
            rectangle2D = shape != null ? rectangle.createIntersection((Rectangle2D)shape) : rectangle;
            graphics2D.setClip(rectangle2D);
            object3 = this.getTextColor();
            if (!ColorMap.isTransparent((Color)object3)) {
                graphics2D.setColor((Color)object3);
            }
            graphics2D.setFont(this.getFont());
        }
        object3 = new FontRenderContext(null, false, false);
        this.prepareText();
        float f2 = (float)rectangle.x + ((Float)this.getAttribute("LeftMargin")).floatValue();
        float f3 = (float)(rectangle.x + rectangle.width) - ((Float)this.getAttribute("RightMargin")).floatValue();
        float f4 = (float)rectangle.y + ((Float)this.getAttribute("TopMargin")).floatValue();
        float[] fArray = new float[40];
        float f5 = f = ((Float)this.getAttribute("TabSize")).floatValue() * this.getFontWidth();
        for (int i = 0; i < 40; ++i) {
            fArray[i] = f5 + f2;
            f5 += f;
        }
        float f6 = f4;
        Iterator iterator = this.fParagraphs.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = new AttributedString((String)object2);
            AttributedCharacterIterator attributedCharacterIterator = ((AttributedString)object).getIterator();
            int[] nArray = new int[((String)object2).length()];
            int n = 0;
            char c = attributedCharacterIterator.first();
            while (c != '\uffff') {
                if (c == '\t') {
                    nArray[n++] = attributedCharacterIterator.getIndex();
                }
                c = attributedCharacterIterator.next();
            }
            nArray[n] = attributedCharacterIterator.getEndIndex() - 1;
            object2 = ((String)object2).replace('\t', ' ');
            object = new AttributedString((String)object2, this.attributesMap);
            attributedCharacterIterator = ((AttributedString)object).getIterator();
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, (FontRenderContext)object3);
            int n2 = 0;
            while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                Object object4;
                boolean bl = false;
                boolean bl2 = false;
                float f7 = 0.0f;
                float f8 = 0.0f;
                float f9 = f2;
                List list = CollectionsFactory.current().createList(1);
                List list2 = CollectionsFactory.current().createList(1);
                while (!bl2) {
                    float f10 = f3 - f9;
                    object4 = lineBreakMeasurer.nextLayout(f10 = Math.max(1.0f, f10), nArray[n2] + 1, bl);
                    if (object4 != null) {
                        list.add(object4);
                        list2.add(new Float(f9));
                        f9 += ((TextLayout)object4).getAdvance();
                        f7 = Math.max(f7, ((TextLayout)object4).getAscent());
                        f8 = Math.max(f8, ((TextLayout)object4).getDescent() + ((TextLayout)object4).getLeading());
                    } else {
                        bl2 = true;
                    }
                    bl = true;
                    if (lineBreakMeasurer.getPosition() == nArray[n2] + 1) {
                        ++n2;
                    }
                    if (lineBreakMeasurer.getPosition() == attributedCharacterIterator.getEndIndex()) {
                        bl2 = true;
                    } else if (f9 >= fArray[fArray.length - 1]) {
                        bl2 = true;
                    }
                    if (bl2) continue;
                    int n3 = 0;
                    while (f9 >= fArray[n3]) {
                        ++n3;
                    }
                    f9 = fArray[n3];
                }
                f6 += f7;
                Iterator iterator2 = list.iterator();
                object4 = list2.iterator();
                while (iterator2.hasNext()) {
                    TextLayout textLayout = (TextLayout)iterator2.next();
                    Float f11 = (Float)object4.next();
                    if (graphics2D == null) continue;
                    textLayout.draw(graphics2D, f11.floatValue(), f6);
                }
                f6 += f8;
            }
        }
        if (graphics2D != null && (double)f6 > rectangle2D.getMaxY() && rectangle2D.getMaxY() == rectangle.getMaxY()) {
            object2 = graphics2D.getStroke();
            object = new float[2];
            object[0] = 2.0f;
            object[1] = 4.0f;
            graphics2D.setStroke(new BasicStroke(1.0f, 2, 0, 1.0f, (float[])object, 0.0f));
            graphics2D.setColor(Color.red);
            graphics2D.drawLine((int)rectangle2D.getMinX() + 1, (int)rectangle2D.getMaxY() - 1, (int)rectangle2D.getMaxX() - 1, (int)rectangle2D.getMaxY() - 1);
            graphics2D.setStroke((Stroke)object2);
        }
        if (graphics2D != null) {
            if (shape != null) {
                graphics2D.setClip(shape);
            }
            graphics2D.setColor(color);
            graphics2D.setRenderingHints(renderingHints);
        }
        return f6;
    }

    protected void prepareText() {
        String string;
        if (!this.isTextDirty()) {
            return;
        }
        this.fParagraphs = CollectionsFactory.current().createList();
        Point point = new Point(-1, -1);
        while ((string = this.getNextParagraph(this.fText, point)) != null) {
            if (string.length() == 0) {
                string = " ";
            }
            this.fParagraphs.add(string);
        }
        this.setTextDirty(false);
    }

    protected String getNextParagraph(String string, Point point) {
        int n = point.y + 1;
        if (n >= string.length()) {
            return null;
        }
        point.x = n;
        int n2 = string.indexOf(10, n);
        if (n2 == -1) {
            n2 = string.length();
        }
        point.y = n2;
        if (string.charAt(n2 - 1) == '\r') {
            return string.substring(n, n2 - 1);
        }
        return string.substring(n, n2);
    }

    public Object getAttribute(String string) {
        return super.getAttribute(string);
    }

    public void setAttribute(String string, Object object) {
        Font font = this.getFont();
        if (string.equals("FontSize")) {
            Integer n = (Integer)object;
            this.setFont(new Font(font.getName(), font.getStyle(), n));
            super.setAttribute(string, object);
        } else if (string.equals("FontStyle")) {
            Integer n = (Integer)object;
            int n2 = font.getStyle();
            n2 = n == 0 ? 0 : (n2 ^= n.intValue());
            this.setFont(new Font(font.getName(), n2, font.getSize()));
            super.setAttribute(string, (Object)new Integer(n2));
        } else if (string.equals("FontName")) {
            String string2 = (String)object;
            this.setFont(new Font(string2, font.getStyle(), font.getSize()));
            super.setAttribute(string, object);
        } else {
            super.setAttribute(string, object);
        }
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fDisplayBox.x);
        storableOutput.writeInt(this.fDisplayBox.y);
        storableOutput.writeInt(this.fDisplayBox.width);
        storableOutput.writeInt(this.fDisplayBox.height);
        storableOutput.writeString(this.fText);
        storableOutput.writeBoolean(this.fIsReadOnly);
        storableOutput.writeStorable(this.fObservedFigure);
        storableOutput.writeStorable(this.fLocator);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.markSizeDirty();
        this.markTextDirty();
        this.markFontDirty();
        this.fDisplayBox.x = storableInput.readInt();
        this.fDisplayBox.y = storableInput.readInt();
        this.fDisplayBox.width = storableInput.readInt();
        this.fDisplayBox.height = storableInput.readInt();
        this.fText = storableInput.readString();
        this.fIsReadOnly = storableInput.readBoolean();
        this.fObservedFigure = (Figure)storableInput.readStorable();
        if (this.fObservedFigure != null) {
            this.fObservedFigure.addFigureChangeListener(this);
        }
        this.fLocator = (OffsetLocator)storableInput.readStorable();
        this.setFont(this.createFont());
    }

    protected void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.fObservedFigure != null) {
            this.fObservedFigure.addFigureChangeListener(this);
        }
        this.markSizeDirty();
        this.markTextDirty();
        this.markFontDirty();
    }

    public void connect(Figure figure) {
        if (this.fObservedFigure != null) {
            this.fObservedFigure.removeFigureChangeListener(this);
        }
        this.fObservedFigure = figure;
        this.fLocator = new OffsetLocator(figure.connectedTextLocator(this));
        this.fObservedFigure.addFigureChangeListener(this);
        this.updateLocation();
    }

    public void disconnect(Figure figure) {
        if (figure != null) {
            figure.removeFigureChangeListener(this);
        }
        this.fLocator = null;
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
    }

    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this.updateLocation();
    }

    protected void updateLocation() {
        if (this.fLocator != null) {
            Point point = this.fLocator.locate(this.fObservedFigure);
            point.x -= this.size().width / 2 + this.fDisplayBox.x;
            point.y -= this.size().height / 2 + this.fDisplayBox.y;
            if (point.x != 0 || point.y != 0) {
                this.willChange();
                this.basicMoveBy(point.x, point.y);
                this.changed();
            }
        }
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRemoved(new FigureChangeEvent(this));
        }
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
    }

    protected float getFontWidth() {
        this.updateFontInfo();
        return this.fFontWidth;
    }

    protected void updateFontInfo() {
        if (!this.isFontDirty()) {
            return;
        }
        this.fFontWidth = (int)this.getFont().getMaxCharBounds(new FontRenderContext(null, false, false)).getWidth();
        this.setFontDirty(false);
    }

    public Color getTextColor() {
        return (Color)this.getAttribute("TextColor");
    }

    public boolean isEmpty() {
        return this.fText.length() == 0;
    }

    protected void markFontDirty() {
        this.setFontDirty(true);
    }

    public boolean isFontDirty() {
        return this.fFontIsDirty;
    }

    public void setFontDirty(boolean bl) {
        this.fFontIsDirty = bl;
    }

    public Figure getRepresentingFigure() {
        return this;
    }

    static {
        TextAreaFigure.initDefaultAttribute("LeftMargin", new Float(5.0f));
        TextAreaFigure.initDefaultAttribute("RightMargin", new Float(5.0f));
        TextAreaFigure.initDefaultAttribute("TopMargin", new Float(5.0f));
        TextAreaFigure.initDefaultAttribute("TabSize", new Float(8.0f));
    }
}

