/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.event.WindowAdapter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.contrib.Desktop;
import org.jhotdraw.contrib.DesktopEvent;
import org.jhotdraw.contrib.DesktopListener;
import org.jhotdraw.contrib.JPanelDesktop;
import org.jhotdraw.figures.GroupCommand;
import org.jhotdraw.figures.UngroupCommand;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.framework.ViewChangeListener;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.standard.AlignCommand;
import org.jhotdraw.standard.BringToFrontCommand;
import org.jhotdraw.standard.BufferedUpdateStrategy;
import org.jhotdraw.standard.ChangeAttributeCommand;
import org.jhotdraw.standard.CopyCommand;
import org.jhotdraw.standard.CutCommand;
import org.jhotdraw.standard.DeleteCommand;
import org.jhotdraw.standard.DuplicateCommand;
import org.jhotdraw.standard.NullTool;
import org.jhotdraw.standard.PasteCommand;
import org.jhotdraw.standard.SelectAllCommand;
import org.jhotdraw.standard.SelectionTool;
import org.jhotdraw.standard.SendToBackCommand;
import org.jhotdraw.standard.SimpleUpdateStrategy;
import org.jhotdraw.standard.StandardDrawing;
import org.jhotdraw.standard.StandardDrawingView;
import org.jhotdraw.standard.ToggleGridCommand;
import org.jhotdraw.standard.ToolButton;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.ColorMap;
import org.jhotdraw.util.CommandMenu;
import org.jhotdraw.util.Iconkit;
import org.jhotdraw.util.PaletteButton;
import org.jhotdraw.util.PaletteListener;
import org.jhotdraw.util.RedoCommand;
import org.jhotdraw.util.SerializationStorageFormat;
import org.jhotdraw.util.StandardStorageFormat;
import org.jhotdraw.util.StandardVersionControlStrategy;
import org.jhotdraw.util.StorageFormat;
import org.jhotdraw.util.StorageFormatManager;
import org.jhotdraw.util.UndoCommand;
import org.jhotdraw.util.UndoManager;
import org.jhotdraw.util.UndoableCommand;
import org.jhotdraw.util.VersionControlStrategy;
import org.jhotdraw.util.VersionManagement;
import org.jhotdraw.util.VersionRequester;

public class DrawApplication
extends JFrame
implements DrawingEditor,
PaletteListener,
VersionRequester {
    private Tool fTool;
    private Iconkit fIconkit;
    private JTextField fStatusLine;
    private DrawingView fView;
    private ToolButton fDefaultToolButton;
    private ToolButton fSelectedToolButton;
    private String fApplicationName;
    private StorageFormatManager fStorageFormatManager;
    private UndoManager myUndoManager;
    protected static String fgUntitled = "untitled";
    private List listeners = CollectionsFactory.current().createList();
    private DesktopListener fDesktopListener;
    private Desktop fDesktop;
    private static final String fgDrawPath = "/org/jhotdraw/";
    public static final String IMAGES = "/org/jhotdraw/images/";
    protected static int winCount = 0;
    public static final int FILE_MENU = 0;
    public static final int EDIT_MENU = 1;
    public static final int ALIGNMENT_MENU = 2;
    public static final int ATTRIBUTES_MENU = 3;
    static /* synthetic */ Class class$org$jhotdraw$util$CommandMenu;
    static /* synthetic */ Class class$org$jhotdraw$application$DrawApplication;

    public DrawApplication() {
        this("JHotDraw");
    }

    public DrawApplication(String string) {
        super(string);
        this.setDefaultCloseOperation(0);
        this.setApplicationName(string);
    }

    protected DrawApplication createApplication() {
        return new DrawApplication();
    }

    public void newView() {
        if (this.view() == null) {
            return;
        }
        DrawApplication drawApplication = this.createApplication();
        drawApplication.open(this.view());
        if (this.view().drawing().getTitle() != null) {
            drawApplication.setDrawingTitle(this.view().drawing().getTitle() + " (View)");
        } else {
            drawApplication.setDrawingTitle(this.getDefaultDrawingTitle() + " (View)");
        }
    }

    public void newWindow(Drawing drawing) {
        DrawApplication drawApplication = this.createApplication();
        if (drawing == null) {
            drawApplication.open();
        } else {
            drawApplication.open(drawApplication.createDrawingView(drawing));
        }
    }

    public final void newWindow() {
        this.newWindow(this.createDrawing());
    }

    public void open() {
        this.open(this.createInitialDrawingView());
    }

    protected void open(final DrawingView drawingView) {
        this.getVersionControlStrategy().assertCompatibleVersion();
        this.setUndoManager(new UndoManager());
        this.setIconkit(this.createIconkit());
        this.getContentPane().setLayout(new BorderLayout());
        this.setStatusLine(this.createStatusLine());
        this.getContentPane().add((Component)this.getStatusLine(), "South");
        this.setTool(new NullTool(this), "");
        this.setView(drawingView);
        JToolBar jToolBar = this.createToolPalette();
        this.createTools(jToolBar);
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.0f);
        jPanel.setAlignmentY(0.0f);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jToolBar, "North");
        this.setDesktopListener(this.createDesktopListener());
        this.setDesktop(this.createDesktop());
        jPanel.add((Component)((Object)this.getDesktop()), "Center");
        this.getContentPane().add((Component)jPanel, "Center");
        JMenuBar jMenuBar = new JMenuBar();
        this.createMenus(jMenuBar);
        this.setJMenuBar(jMenuBar);
        Dimension dimension = this.defaultSize();
        if (dimension.width > jMenuBar.getPreferredSize().width) {
            this.setSize(dimension.width, dimension.height);
        } else {
            this.setSize(jMenuBar.getPreferredSize().width, dimension.height);
        }
        this.addListeners();
        this.setStorageFormatManager(this.createStorageFormatManager());
        this.setVisible(true);
        Runnable runnable = new Runnable(){

            public void run() {
                if (drawingView.isInteractive()) {
                    DrawApplication.this.getDesktop().addToDesktop(drawingView, 0);
                }
                DrawApplication.this.toolDone();
            }
        };
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                System.err.println(interruptedException.getMessage());
                this.exit();
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println(invocationTargetException.getMessage());
                this.exit();
            }
        } else {
            runnable.run();
        }
        this.toolDone();
    }

    protected void addListeners() {
        this.addWindowListener(new WindowAdapter(){});
    }

    protected void createMenus(JMenuBar jMenuBar) {
        this.addMenuIfPossible(jMenuBar, this.createFileMenu());
        this.addMenuIfPossible(jMenuBar, this.createEditMenu());
        this.addMenuIfPossible(jMenuBar, this.createAlignmentMenu());
        this.addMenuIfPossible(jMenuBar, this.createAttributesMenu());
        this.addMenuIfPossible(jMenuBar, this.createDebugMenu());
    }

    protected void addMenuIfPossible(JMenuBar jMenuBar, JMenu jMenu) {
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
    }

    protected JMenu createFileMenu() {
        CommandMenu commandMenu = new CommandMenu("File");
        AbstractCommand abstractCommand = new AbstractCommand("New", this, false){

            public void execute() {
                DrawApplication.this.promptNew();
            }
        };
        commandMenu.add(abstractCommand, new MenuShortcut(110));
        abstractCommand = new AbstractCommand("Open...", this, false){

            public void execute() {
                DrawApplication.this.promptOpen();
            }
        };
        commandMenu.add(abstractCommand, new MenuShortcut(111));
        abstractCommand = new AbstractCommand("Save As...", this, true){

            public void execute() {
                DrawApplication.this.promptSaveAs();
            }
        };
        commandMenu.add(abstractCommand, new MenuShortcut(115));
        commandMenu.addSeparator();
        abstractCommand = new AbstractCommand("Print...", this, true){

            public void execute() {
                DrawApplication.this.print();
            }
        };
        commandMenu.add(abstractCommand, new MenuShortcut(112));
        commandMenu.addSeparator();
        abstractCommand = new AbstractCommand("Exit", this, true){

            public void execute() {
                DrawApplication.this.endApp();
            }
        };
        commandMenu.add(abstractCommand);
        return commandMenu;
    }

    protected JMenu createEditMenu() {
        CommandMenu commandMenu = new CommandMenu("Edit");
        commandMenu.add(new UndoableCommand(new SelectAllCommand("Select All", this)), new MenuShortcut(97));
        commandMenu.addSeparator();
        commandMenu.add(new UndoableCommand(new CutCommand("Cut", this)), new MenuShortcut(120));
        commandMenu.add(new CopyCommand("Copy", this), new MenuShortcut(99));
        commandMenu.add(new UndoableCommand(new PasteCommand("Paste", this)), new MenuShortcut(118));
        commandMenu.addSeparator();
        commandMenu.add(new UndoableCommand(new DuplicateCommand("Duplicate", this)), new MenuShortcut(100));
        commandMenu.add(new UndoableCommand(new DeleteCommand("Delete", this)));
        commandMenu.addSeparator();
        commandMenu.add(new UndoableCommand(new GroupCommand("Group", this)));
        commandMenu.add(new UndoableCommand(new UngroupCommand("Ungroup", this)));
        commandMenu.addSeparator();
        commandMenu.add(new UndoableCommand(new SendToBackCommand("Send to Back", this)));
        commandMenu.add(new UndoableCommand(new BringToFrontCommand("Bring to Front", this)));
        commandMenu.addSeparator();
        commandMenu.add(new UndoCommand("Undo Command", this));
        commandMenu.add(new RedoCommand("Redo Command", this));
        return commandMenu;
    }

    protected JMenu createAlignmentMenu() {
        CommandMenu commandMenu = new CommandMenu("Align");
        commandMenu.addCheckItem(new ToggleGridCommand("Toggle Snap to Grid", (DrawingEditor)this, new Point(4, 4)));
        commandMenu.addSeparator();
        commandMenu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.LEFTS, (DrawingEditor)this)));
        commandMenu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.CENTERS, (DrawingEditor)this)));
        commandMenu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.RIGHTS, (DrawingEditor)this)));
        commandMenu.addSeparator();
        commandMenu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.TOPS, (DrawingEditor)this)));
        commandMenu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.MIDDLES, (DrawingEditor)this)));
        commandMenu.add(new UndoableCommand(new AlignCommand(AlignCommand.Alignment.BOTTOMS, (DrawingEditor)this)));
        return commandMenu;
    }

    protected JMenu createDebugMenu() {
        CommandMenu commandMenu = new CommandMenu("Debug");
        AbstractCommand abstractCommand = new AbstractCommand("Simple Update", this){

            public void execute() {
                this.view().setDisplayUpdate(new SimpleUpdateStrategy());
            }
        };
        commandMenu.add(abstractCommand);
        abstractCommand = new AbstractCommand("Buffered Update", this){

            public void execute() {
                this.view().setDisplayUpdate(new BufferedUpdateStrategy());
            }
        };
        commandMenu.add(abstractCommand);
        return commandMenu;
    }

    protected JMenu createAttributesMenu() {
        JMenu jMenu = new JMenu("Attributes");
        jMenu.add(this.createColorMenu("Fill Color", FigureAttributeConstant.FILL_COLOR));
        jMenu.add(this.createColorMenu("Pen Color", FigureAttributeConstant.FRAME_COLOR));
        jMenu.add(this.createArrowMenu());
        jMenu.addSeparator();
        jMenu.add(this.createFontMenu());
        jMenu.add(this.createFontSizeMenu());
        jMenu.add(this.createFontStyleMenu());
        jMenu.add(this.createColorMenu("Text Color", FigureAttributeConstant.TEXT_COLOR));
        return jMenu;
    }

    protected JMenu createColorMenu(String string, FigureAttributeConstant figureAttributeConstant) {
        CommandMenu commandMenu = new CommandMenu(string);
        for (int i = 0; i < ColorMap.size(); ++i) {
            commandMenu.add(new UndoableCommand(new ChangeAttributeCommand(ColorMap.name(i), figureAttributeConstant, ColorMap.color(i), this)));
        }
        return commandMenu;
    }

    protected JMenu createArrowMenu() {
        FigureAttributeConstant figureAttributeConstant = FigureAttributeConstant.ARROW_MODE;
        CommandMenu commandMenu = new CommandMenu("Arrow");
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand("none", figureAttributeConstant, new Integer(0), this)));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand("at Start", figureAttributeConstant, new Integer(1), this)));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand("at End", figureAttributeConstant, new Integer(2), this)));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand("at Both", figureAttributeConstant, new Integer(3), this)));
        return commandMenu;
    }

    protected JMenu createFontMenu() {
        CommandMenu commandMenu = new CommandMenu("Font");
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            commandMenu.add(new UndoableCommand(new ChangeAttributeCommand(stringArray[i], FigureAttributeConstant.FONT_NAME, stringArray[i], this)));
        }
        return commandMenu;
    }

    protected JMenu createFontStyleMenu() {
        FigureAttributeConstant figureAttributeConstant = FigureAttributeConstant.FONT_STYLE;
        CommandMenu commandMenu = new CommandMenu("Font Style");
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand("Plain", figureAttributeConstant, new Integer(0), this)));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand("Italic", figureAttributeConstant, new Integer(2), this)));
        commandMenu.add(new UndoableCommand(new ChangeAttributeCommand("Bold", figureAttributeConstant, new Integer(1), this)));
        return commandMenu;
    }

    protected JMenu createFontSizeMenu() {
        CommandMenu commandMenu = new CommandMenu("Font Size");
        int[] nArray = new int[]{9, 10, 12, 14, 18, 24, 36, 48, 72};
        for (int i = 0; i < nArray.length; ++i) {
            commandMenu.add(new UndoableCommand(new ChangeAttributeCommand(Integer.toString(nArray[i]), FigureAttributeConstant.FONT_SIZE, new Integer(nArray[i]), this)));
        }
        return commandMenu;
    }

    public JMenu createLookAndFeelMenu() {
        CommandMenu commandMenu = new CommandMenu("Look'n'Feel");
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            final String string = lookAndFeelInfoArray[i].getClassName();
            AbstractCommand abstractCommand = new AbstractCommand(lookAndFeelInfoArray[i].getName(), this){

                public void execute() {
                    DrawApplication.this.newLookAndFeel(string);
                }
            };
            commandMenu.add(abstractCommand);
        }
        return commandMenu;
    }

    protected JToolBar createToolPalette() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBackground(Color.lightGray);
        return jToolBar;
    }

    protected void createTools(JToolBar jToolBar) {
        this.setDefaultTool(this.createDefaultTool());
        jToolBar.add(this.fDefaultToolButton);
    }

    protected Tool createSelectionTool() {
        return new SelectionTool(this);
    }

    protected Tool createDefaultTool() {
        return this.createSelectionTool();
    }

    protected void setDefaultTool(Tool tool) {
        this.fDefaultToolButton = tool != null ? this.createToolButton("/org/jhotdraw/images/SEL", "Selection Tool", tool) : null;
    }

    public Tool getDefaultTool() {
        if (this.fDefaultToolButton != null) {
            return this.fDefaultToolButton.tool();
        }
        return null;
    }

    protected ToolButton createToolButton(String string, String string2, Tool tool) {
        return new ToolButton(this, string, string2, tool);
    }

    protected DrawingView createDrawingView() {
        DrawingView drawingView = this.createDrawingView(this.createDrawing());
        drawingView.drawing().setTitle(this.getDefaultDrawingTitle());
        return drawingView;
    }

    protected DrawingView createDrawingView(Drawing drawing) {
        Dimension dimension = this.getDrawingViewSize();
        StandardDrawingView standardDrawingView = new StandardDrawingView(this, dimension.width, dimension.height);
        standardDrawingView.setDrawing(drawing);
        return standardDrawingView;
    }

    protected DrawingView createInitialDrawingView() {
        return this.createDrawingView();
    }

    protected Dimension getDrawingViewSize() {
        return new Dimension(800, 800);
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    protected Desktop createDesktop() {
        return new JPanelDesktop(this);
    }

    protected void setDesktop(Desktop desktop) {
        desktop.addDesktopListener(this.getDesktopListener());
        this.fDesktop = desktop;
    }

    public Desktop getDesktop() {
        return this.fDesktop;
    }

    public StorageFormatManager createStorageFormatManager() {
        StorageFormatManager storageFormatManager = new StorageFormatManager();
        storageFormatManager.setDefaultStorageFormat(new StandardStorageFormat());
        storageFormatManager.addStorageFormat(storageFormatManager.getDefaultStorageFormat());
        storageFormatManager.addStorageFormat(new SerializationStorageFormat());
        return storageFormatManager;
    }

    protected final void setStorageFormatManager(StorageFormatManager storageFormatManager) {
        this.fStorageFormatManager = storageFormatManager;
    }

    public StorageFormatManager getStorageFormatManager() {
        return this.fStorageFormatManager;
    }

    protected Dimension defaultSize() {
        return new Dimension(600, 450);
    }

    protected JTextField createStatusLine() {
        JTextField jTextField = new JTextField("No Tool", 40);
        jTextField.setBackground(Color.white);
        jTextField.setEditable(false);
        return jTextField;
    }

    private void setStatusLine(JTextField jTextField) {
        this.fStatusLine = jTextField;
    }

    protected JTextField getStatusLine() {
        return this.fStatusLine;
    }

    public void paletteUserSelected(PaletteButton paletteButton) {
        ToolButton toolButton = (ToolButton)paletteButton;
        this.setTool(toolButton.tool(), toolButton.name());
        this.setSelected(toolButton);
    }

    public void paletteUserOver(PaletteButton paletteButton, boolean bl) {
        ToolButton toolButton = (ToolButton)paletteButton;
        if (bl) {
            this.showStatus(toolButton.name());
        } else if (this.fSelectedToolButton != null) {
            this.showStatus(this.fSelectedToolButton.name());
        }
    }

    public Tool tool() {
        return this.fTool;
    }

    public DrawingView view() {
        return this.fView;
    }

    protected void setView(DrawingView drawingView) {
        DrawingView drawingView2 = this.fView;
        this.fView = drawingView;
        this.fireViewSelectionChangedEvent(drawingView2, this.view());
    }

    public DrawingView[] views() {
        return new DrawingView[]{this.view()};
    }

    public void toolDone() {
        System.out.println("ToolDone");
        if (this.fDefaultToolButton != null) {
            this.setTool(this.fDefaultToolButton.tool(), this.fDefaultToolButton.name());
            this.setSelected(this.fDefaultToolButton);
        }
    }

    public void figureSelectionChanged(DrawingView drawingView) {
        this.checkCommandMenus();
    }

    protected void checkCommandMenus() {
        JMenuBar jMenuBar = this.getJMenuBar();
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            JMenu jMenu;
            if (!(class$org$jhotdraw$util$CommandMenu == null ? DrawApplication.class$("org.jhotdraw.util.CommandMenu") : class$org$jhotdraw$util$CommandMenu).isInstance(jMenu = jMenuBar.getMenu(i))) continue;
            this.checkCommandMenu((CommandMenu)jMenu);
        }
    }

    protected void checkCommandMenu(CommandMenu commandMenu) {
        commandMenu.checkEnabled();
        for (int i = 0; i < commandMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem;
            if (!(class$org$jhotdraw$util$CommandMenu == null ? DrawApplication.class$("org.jhotdraw.util.CommandMenu") : class$org$jhotdraw$util$CommandMenu).isInstance(jMenuItem = commandMenu.getItem(i))) continue;
            this.checkCommandMenu((CommandMenu)jMenuItem);
        }
    }

    public void addViewChangeListener(ViewChangeListener viewChangeListener) {
        this.listeners.add(viewChangeListener);
    }

    public void removeViewChangeListener(ViewChangeListener viewChangeListener) {
        this.listeners.remove(viewChangeListener);
    }

    protected void fireViewSelectionChangedEvent(DrawingView drawingView, DrawingView drawingView2) {
        ListIterator listIterator = this.listeners.listIterator(this.listeners.size());
        while (listIterator.hasPrevious()) {
            ViewChangeListener viewChangeListener = (ViewChangeListener)listIterator.previous();
            viewChangeListener.viewSelectionChanged(drawingView, drawingView2);
        }
    }

    protected void fireViewCreatedEvent(DrawingView drawingView) {
        ListIterator listIterator = this.listeners.listIterator(this.listeners.size());
        while (listIterator.hasPrevious()) {
            ViewChangeListener viewChangeListener = (ViewChangeListener)listIterator.previous();
            viewChangeListener.viewCreated(drawingView);
        }
    }

    protected void fireViewDestroyingEvent(DrawingView drawingView) {
        ListIterator listIterator = this.listeners.listIterator(this.listeners.size());
        while (listIterator.hasPrevious()) {
            ViewChangeListener viewChangeListener = (ViewChangeListener)listIterator.previous();
            viewChangeListener.viewDestroying(drawingView);
        }
    }

    public void showStatus(String string) {
        this.getStatusLine().setText(string);
    }

    public void setTool(Tool tool, String string) {
        if (this.tool() != null && this.tool().isActive()) {
            this.tool().deactivate();
        }
        this.fTool = tool;
        if (this.tool() != null) {
            this.showStatus(string);
            this.tool().activate();
        }
    }

    private void setSelected(ToolButton toolButton) {
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.reset();
        }
        this.fSelectedToolButton = toolButton;
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.select();
        }
    }

    public void exit() {
        this.destroy();
        this.dispose();
    }

    protected boolean closeQuery() {
        return true;
    }

    protected void endApp() {
        if (this.closeQuery()) {
            this.exit();
        }
    }

    protected void destroy() {
    }

    public void promptNew() {
        this.newWindow(this.createDrawing());
    }

    public void promptOpen() {
        this.toolDone();
        JFileChooser jFileChooser = this.createOpenFileChooser();
        this.getStorageFormatManager().registerFileFilters(jFileChooser);
        if (jFileChooser.showOpenDialog(this) == 0) {
            StorageFormat storageFormat = this.getStorageFormatManager().findStorageFormat(jFileChooser.getFileFilter());
            if (storageFormat == null) {
                storageFormat = this.getStorageFormatManager().findStorageFormat(jFileChooser.getSelectedFile());
            }
            if (storageFormat != null) {
                this.loadDrawing(storageFormat, jFileChooser.getSelectedFile().getAbsolutePath());
            } else {
                this.showStatus("Not a valid file format: " + jFileChooser.getFileFilter().getDescription());
            }
        }
    }

    public void promptSaveAs() {
        if (this.view() != null) {
            this.toolDone();
            JFileChooser jFileChooser = this.createSaveFileChooser();
            this.getStorageFormatManager().registerFileFilters(jFileChooser);
            if (jFileChooser.showSaveDialog(this) == 0) {
                StorageFormat storageFormat = this.getStorageFormatManager().findStorageFormat(jFileChooser.getFileFilter());
                if (storageFormat == null) {
                    storageFormat = this.getStorageFormatManager().findStorageFormat(jFileChooser.getSelectedFile());
                }
                if (storageFormat != null) {
                    this.saveDrawing(storageFormat, jFileChooser.getSelectedFile().getAbsolutePath());
                } else {
                    this.showStatus("Not a valid file format: " + jFileChooser.getFileFilter().getDescription());
                }
            }
        }
    }

    protected JFileChooser createOpenFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle("Open File...");
        return jFileChooser;
    }

    protected JFileChooser createSaveFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle("Save File...");
        return jFileChooser;
    }

    public void print() {
        this.tool().deactivate();
        PrintJob printJob = this.getToolkit().getPrintJob(this, "Print Drawing", null);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            if (graphics != null) {
                ((StandardDrawingView)this.view()).printAll(graphics);
                graphics.dispose();
            }
            printJob.end();
        }
        this.tool().activate();
    }

    protected void saveDrawing(StorageFormat storageFormat, String string) {
        if (this.view() == null) {
            return;
        }
        try {
            String string2 = storageFormat.store(string, this.view().drawing());
            this.view().drawing().setTitle(string2);
            this.setDrawingTitle(string2);
        }
        catch (IOException iOException) {
            this.showStatus(iOException.toString());
        }
    }

    protected void loadDrawing(StorageFormat storageFormat, String string) {
        try {
            Drawing drawing = storageFormat.restore(string);
            if (drawing != null) {
                drawing.setTitle(string);
                this.newWindow(drawing);
            } else {
                this.showStatus("Unknown file type: could not open file '" + string + "'");
            }
        }
        catch (IOException iOException) {
            this.showStatus("Error: " + iOException);
            iOException.printStackTrace(System.out);
        }
    }

    private void newLookAndFeel(String string) {
        try {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    protected void setDrawingTitle(String string) {
        if (this.getDefaultDrawingTitle().equals(string)) {
            this.setTitle(this.getApplicationName());
        } else {
            this.setTitle(this.getApplicationName() + " - " + string);
        }
    }

    protected String getDrawingTitle() {
        return this.view().drawing().getTitle();
    }

    public void setApplicationName(String string) {
        this.fApplicationName = string;
    }

    public String getApplicationName() {
        return this.fApplicationName;
    }

    protected void setUndoManager(UndoManager undoManager) {
        this.myUndoManager = undoManager;
    }

    public UndoManager getUndoManager() {
        return this.myUndoManager;
    }

    protected VersionControlStrategy getVersionControlStrategy() {
        return new StandardVersionControlStrategy(this);
    }

    public String[] getRequiredVersions() {
        String[] stringArray = new String[]{VersionManagement.getPackageVersion((class$org$jhotdraw$application$DrawApplication == null ? (class$org$jhotdraw$application$DrawApplication = DrawApplication.class$("org.jhotdraw.application.DrawApplication")) : class$org$jhotdraw$application$DrawApplication).getPackage())};
        return stringArray;
    }

    public String getDefaultDrawingTitle() {
        return fgUntitled;
    }

    protected DesktopListener getDesktopListener() {
        return this.fDesktopListener;
    }

    protected void setDesktopListener(DesktopListener desktopListener) {
        this.fDesktopListener = desktopListener;
    }

    protected DesktopListener createDesktopListener() {
        return new DesktopListener(){

            public void drawingViewAdded(DesktopEvent desktopEvent) {
                DrawingView drawingView = desktopEvent.getDrawingView();
                DrawApplication.this.fireViewCreatedEvent(drawingView);
            }

            public void drawingViewRemoved(DesktopEvent desktopEvent) {
                DrawingView drawingView = desktopEvent.getDrawingView();
                DrawApplication.this.getUndoManager().clearUndos(drawingView);
                DrawApplication.this.getUndoManager().clearRedos(drawingView);
                DrawApplication.this.fireViewDestroyingEvent(drawingView);
                DrawApplication.this.checkCommandMenus();
            }

            public void drawingViewSelected(DesktopEvent desktopEvent) {
                DrawingView drawingView = desktopEvent.getDrawingView();
                if (drawingView != null && drawingView.drawing() != null) {
                    drawingView.unfreezeView();
                }
                DrawApplication.this.setView(drawingView);
            }
        };
    }

    protected Iconkit createIconkit() {
        return new Iconkit(this);
    }

    protected void setIconkit(Iconkit iconkit) {
        this.fIconkit = iconkit;
    }

    protected Iconkit getIconkit() {
        return this.fIconkit;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

