/*
 * Decompiled with CFR 0.152.
 */
package bsearch.fx;

import bsearch.app.BehaviorSearch;
import bsearch.fx.MainController;
import java.io.File;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;
import org.nlogo.api.MersenneTwisterFast;

public class RunOptionDialogController {
    @FXML
    AnchorPane anchorPane;
    @FXML
    Button browseButton;
    @FXML
    TextField outputPathTextField;
    @FXML
    Spinner<Integer> searchesNumSpinner;
    @FXML
    Spinner<Integer> startingSearchIDSpinner;
    @FXML
    Spinner<Integer> iniRanSeedSpinner;
    @FXML
    Button newRanSeedButton;
    @FXML
    Spinner<Integer> threadNumSpinner;
    @FXML
    CheckBox briefOutputCheckBox;
    @FXML
    Button startSearchButton;
    @FXML
    Button cancelButton;
    private MainController main;
    private BehaviorSearch.RunOptions runOptions;

    public void ini(BehaviorSearch.RunOptions runOptions, MainController main) {
        this.runOptions = runOptions;
        this.outputPathTextField.setText(runOptions.outputStem);
        this.searchesNumSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 10000, runOptions.numSearches));
        this.startingSearchIDSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 10000, runOptions.firstSearchNumber));
        this.threadNumSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 1024, runOptions.numThreads));
        this.iniRanSeedSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(Integer.MIN_VALUE, Integer.MAX_VALUE, runOptions.randomSeed.intValue()));
        this.briefOutputCheckBox.setSelected(runOptions.briefOutput);
        this.searchesNumSpinner.getValueFactory().setConverter(new myStringConverter((StringConverter<Integer>)this.searchesNumSpinner.getValueFactory().getConverter()));
        this.startingSearchIDSpinner.getValueFactory().setConverter(new myStringConverter((StringConverter<Integer>)this.startingSearchIDSpinner.getValueFactory().getConverter()));
        this.threadNumSpinner.getValueFactory().setConverter(new myStringConverter((StringConverter<Integer>)this.threadNumSpinner.getValueFactory().getConverter()));
        this.iniRanSeedSpinner.getValueFactory().setConverter(new myStringConverter((StringConverter<Integer>)this.iniRanSeedSpinner.getValueFactory().getConverter()));
        this.main = main;
        this.searchesNumSpinner.focusedProperty().addListener((s, ov, nv) -> {
            if (nv.booleanValue()) {
                return;
            }
            this.commitEditorText(this.searchesNumSpinner);
        });
        this.startingSearchIDSpinner.focusedProperty().addListener((s, ov, nv) -> {
            if (nv.booleanValue()) {
                return;
            }
            this.commitEditorText(this.startingSearchIDSpinner);
        });
        this.threadNumSpinner.focusedProperty().addListener((s, ov, nv) -> {
            if (nv.booleanValue()) {
                return;
            }
            this.commitEditorText(this.threadNumSpinner);
        });
        this.iniRanSeedSpinner.focusedProperty().addListener((s, ov, nv) -> {
            if (nv.booleanValue()) {
                return;
            }
            this.commitEditorText(this.iniRanSeedSpinner);
        });
    }

    private Window getMainWindow() {
        if (this.anchorPane != null && this.anchorPane.getScene() != null) {
            return this.anchorPane.getScene().getWindow();
        }
        return null;
    }

    public void browseFile(ActionEvent event) {
        File selectedFile;
        FileChooser fileChooser = new FileChooser();
        File parentFolder = new File(this.outputPathTextField.getText()).getParentFile();
        if (parentFolder != null && parentFolder.exists()) {
            fileChooser.setInitialDirectory(parentFolder);
            fileChooser.setInitialFileName("MySearchOutput");
        }
        if ((selectedFile = fileChooser.showSaveDialog(this.getMainWindow())) != null) {
            this.outputPathTextField.setText(selectedFile.getPath());
        }
    }

    public void newRanSeed(ActionEvent event) {
        this.iniRanSeedSpinner.getValueFactory().setValue((Object)new MersenneTwisterFast().nextInt());
    }

    public void updateOptions(ActionEvent event) {
        this.runOptions.outputStem = this.outputPathTextField.getText();
        this.runOptions.numSearches = (Integer)this.searchesNumSpinner.getValue();
        this.runOptions.firstSearchNumber = (Integer)this.startingSearchIDSpinner.getValue();
        this.runOptions.numThreads = (Integer)this.threadNumSpinner.getValue();
        this.runOptions.randomSeed = (Integer)this.iniRanSeedSpinner.getValue();
        this.runOptions.briefOutput = this.briefOutputCheckBox.isSelected();
        Node source = (Node)event.getSource();
        Stage thisStage = (Stage)source.getScene().getWindow();
        thisStage.close();
        this.main.displayProgressDialog();
    }

    public void cancel(ActionEvent event) {
        Node source = (Node)event.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    private <T> void commitEditorText(Spinner<T> spinner) {
        StringConverter converter;
        if (!spinner.isEditable()) {
            return;
        }
        String text = spinner.getEditor().getText();
        SpinnerValueFactory valueFactory = spinner.getValueFactory();
        if (valueFactory != null && (converter = valueFactory.getConverter()) != null) {
            Object value = converter.fromString(text);
            valueFactory.setValue(value);
        }
    }

    class myStringConverter<Interger>
    extends StringConverter<Integer> {
        StringConverter<Integer> original;

        public myStringConverter(StringConverter<Integer> original) {
            this.original = original;
        }

        public Integer fromString(String value) {
            try {
                return (Integer)this.original.fromString(value);
            }
            catch (NumberFormatException nfe) {
                MainController.handleError("Bad integer: " + value);
                return 0;
            }
        }

        public String toString(Integer value) {
            return this.original.toString((Object)value);
        }
    }
}

