/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.openimaj;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.ds.openimaj.OpenImajDriver;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.video.capture.Device;
import org.openimaj.video.capture.VideoCapture;
import org.openimaj.video.capture.VideoCaptureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenImajDevice
implements WebcamDevice {
    private static final Logger LOG = LoggerFactory.getLogger(OpenImajDriver.class);
    private static final Dimension[] DIMENSIONS = new Dimension[]{new Dimension(176, 144), new Dimension(320, 240), new Dimension(352, 288), new Dimension(640, 400), new Dimension(640, 480), new Dimension(1280, 720)};
    private Device device = null;
    private VideoCapture capture = null;
    private Dimension size = null;
    private volatile boolean open = false;
    private volatile boolean disposed = false;

    public OpenImajDevice(Device device) {
        this.device = device;
    }

    public String getName() {
        return this.device.getNameStr();
    }

    public Dimension[] getResolutions() {
        return DIMENSIONS;
    }

    public Dimension getResolution() {
        return this.size;
    }

    public void setResolution(Dimension size) {
        if (this.open) {
            throw new RuntimeException("Cannot set new size when device is open, please close it first");
        }
        this.size = size;
    }

    public BufferedImage getImage() {
        if (!this.open) {
            throw new RuntimeException("Cannot get image from closed device");
        }
        return ImageUtilities.createBufferedImageForDisplay((MBFImage)this.capture.getNextFrame());
    }

    public void open() {
        if (this.disposed) {
            LOG.warn("Cannot open device because it's already disposed");
            return;
        }
        if (this.open) {
            return;
        }
        try {
            this.capture = new VideoCapture(this.size.width, this.size.height, this.device);
        }
        catch (VideoCaptureException e) {
            throw new WebcamException("Cannot initialize video capture", (Throwable)e);
        }
        this.open = true;
        int i = 0;
        do {
            this.capture.getNextFrame();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (i++ < 3);
        LOG.info("OpenIMAJ webcam device has been initialized");
    }

    public void close() {
        if (!this.open) {
            return;
        }
        this.capture.stopCapture();
        this.open = false;
        LOG.info("OpenIMAJ webcam device has been closed");
    }

    public void dispose() {
        this.disposed = true;
    }

    public boolean isOpen() {
        return this.open;
    }
}

