#include <stdio.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/times.h>
#include <sys/time.h>
#include <unistd.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include "zutil.h"

FILE *fichin[99];

#ifndef F77_NO_UNDER_SCORE
#define datefichier datefichier_
#define timec timec_
#define timeprecisc timeprecisc_
#define etimec etimec_
#define idatec idatec_
#define ctimec ctimec_
#define fflushc fflushc_
#define testtypebin testtypebin_
#define ouvrebin ouvrebin_
#define fermebin fermebin_
#define litduncoup litduncoup_
#define ecritduncoup ecritduncoup_
#define litrecbin litrecbin_
#define litrecbinspeed litrecbinspeed_
#define ecritrecbin ecritrecbin_
#define ecritrecbinspeed ecritrecbinspeed_
#define fnaninf4 fnaninf4_
#define fnaninf8 fnaninf8_
#define fmemcpy fmemcpy_
#define fmalloc fmalloc_
#define fcalloc fcalloc_
#define ffree ffree_
#define frealloc frealloc_
#define zouvrel zouvrel_
#define zouvree zouvree_
#define zferme zferme_
#define zlit zlit_
#define zliti zliti_
#define zecrit zecrit_
#define zlitrec zlitrec_
#define zecritrec zecritrec_
#define zlitrecbin zlitrecbin_
#define zlitrecshortbin zlitrecshortbin_
#define ztesttypebin ztesttypebin_
#define zlitrecvbin zlitrecvbin_
#define zcompress zcompress_
#define zdecompress zdecompress_
#endif

/* 
sur HP compiler avec : cc +O3 -DF77_NO_UNDER_SCORE -c timestuff.c
*/
void datefichier(char *lefichier, int *ladate, int *irc)
{
int ierr;
struct stat buf;

ierr = stat(lefichier, &buf);
*ladate = buf.st_mtime;
*irc=ierr;
}

int timec()
{
  return time( (time_t *)NULL );
}

double timeprecisc()
{
  struct timeval elapsetime;
  struct timezone zone;
  double rc;
  int irc;

  irc = gettimeofday(&elapsetime, &zone);
  rc = elapsetime.tv_sec + ((double)(elapsetime.tv_usec))/1000000.;
  return(rc);
}

double etimec(float *tarray)
{
  clock_t cur_time;
  double rc;
  struct tms cputime;
  long clk=sysconf(_SC_CLK_TCK);
  
  cur_time=times(&cputime);
  tarray[0]=((double)(cputime.tms_utime+cputime.tms_cutime))/(double)clk;
  tarray[1]=((double)(cputime.tms_stime+cputime.tms_cstime))/(double)clk;
  /*    rc=((double)cur_time)/(double)clk;*/
  rc = tarray[0]+tarray[1];
  return(rc);
}

void idatec(int *iarray)
{
  struct tm *et;
  time_t tt=time((time_t *)NULL);
  et=localtime(&tt);
  iarray[0]=et->tm_mon+1;
  iarray[1]=et->tm_mday;
  iarray[2]=et->tm_year;
}

void ctimec(char ret[])
{
  char *ret1;
  time_t timer;
  int i;
  
  timer=time( (time_t *)NULL );
  
  ret1=ctime(&timer);
  for (i=0;i<=7;i++)
    ret[i]=ret1[i+11];
}

void fflushc()
{
  fflush(stdout);
}

void testtypebin(int *ifich, char *inf, int *longueur, int *itype, int *imp)
{
  union revint {
    char c[4];
    int i;
  } ri1, ri2;
  /* itype = 0  --> fichier binaire de la meme architecture
     itype = -1 --> erreur a l'ouverture du fichier
     itype = -2 --> erreur. Mauvaise taille de record dans les 2 sens
     itype = 1  --> fichier binaire d'architecture inversee
  */
  fichin[*ifich]=fopen(inf,"rb");

  if ( fichin[*ifich] == NULL )
    *itype = -1;
  else
    {
    fread(&ri1,sizeof(int),1,fichin[*ifich]);
    if ( ri1.i == *longueur )
      *itype = 0;
    else 
      {
      ri2.c[0]=ri1.c[3];
      ri2.c[1]=ri1.c[2];
      ri2.c[2]=ri1.c[1];
      ri2.c[3]=ri1.c[0];
      if (ri2.i != *longueur )
	*itype = -2;
      else
	{
	  if (abs(*imp) > 0 )
	    {
	      if (*imp > 0)
		printf("*** Le fichier %s vient d'une architecture concurrente :\n",inf);
	      else
		printf("*** File %s comes from an other architecture:\n",inf);
	      printf("*** (linux/sun <---> hp/dec/ibm/silicon)\n");
	    }
	  *itype = 1;
	}
      }
    fclose(fichin[*ifich]);
    }
}

void ouvrebin(int *ifich, char *inf, int *iopt, int *ierr)
{
  if (*iopt == 1)
    fichin[*ifich]=fopen(inf,"w+b");
  else
    fichin[*ifich]=fopen(inf,"rb");
  if (fichin[*ifich] == NULL)
    *ierr = 1;
  else
    *ierr = 0;
}

void fermebin(int *ifich)
{
  int ierr;
  ierr = fclose(fichin[*ifich]);
  /*  if (ierr <= 0)
      printf("*** Erreur  la fermeture du fichier %d \n",*ifich);*/
}

int litduncoup(int *ifich, char *buf, int *longueur)
{
  fread(buf,sizeof(char),*longueur,fichin[*ifich]);
}

int ecritduncoup(int *ifich, char *buf, int *longueur)
{
  fwrite(buf,sizeof(char),*longueur,fichin[*ifich]);
}
/*
pour litrecbin et ecritrecbin,
  iopt = 0 : on inverse tout (entier de taille + buffer)
  iopt = 1 : on inverse juste les entiers de taille (pour garder
             les chaines de caractere inchangees)
  iopt = 2 : on n'inverse rien
*/
int litrecbin(int *ifich, int *buf, int *longueur, int *iopt)
{
  int i, ierr, lonlon;
  union revint {
    char c[4];
    int i;
  } ri1, ri2;

  ierr = fread(&ri1,sizeof(int),1,fichin[*ifich]);
  if (ierr <= 0)
    {
      *longueur = -1;
      return -1;
    }

  if (*iopt == 2)
    *longueur = ri1.i;
  else
    {
      ri2.c[0]=ri1.c[3];
      ri2.c[1]=ri1.c[2];
      ri2.c[2]=ri1.c[1];
      ri2.c[3]=ri1.c[0];
      *longueur = ri2.i;
    }
  fread(buf,sizeof(char),*longueur,fichin[*ifich]);
     
  if (*iopt == 0)
    {
      lonlon = (*longueur)/sizeof(int);
      for (i=0; i<lonlon; i++) 
	{
	  ri1.i=buf[i];
	  ri2.c[0]=ri1.c[3];
	  ri2.c[1]=ri1.c[2];
	  ri2.c[2]=ri1.c[1];
	  ri2.c[3]=ri1.c[0];
	  buf[i] = ri2.i;
	}
    }
  fread(&ri1,sizeof(int),1,fichin[*ifich]);
  return 0;
}

int litrecbinspeed(int *ifich, int *buf, int *longueur)
{
  int i, ierr;

  ierr = fread(&i,sizeof(int),1,fichin[*ifich]);
  if (ierr <= 0)
    {
      *longueur = -1;
      return -1;
    }
  else
    {
      *longueur = i;
      fread(buf,sizeof(char),*longueur,fichin[*ifich]);
      fread(&i,sizeof(int),1,fichin[*ifich]);
    }
  return 0;
}

void ecritrecbin(int *ifich, int *buf, int *longueur, int *iopt)
{
  int i, lonlon;
  union revint {
    char c[4];
    int i;
  } ri1, ri2, ri3;

  lonlon = (*longueur)/sizeof(int);
  if (*iopt == 2)
    {
      fwrite(longueur,sizeof(int),1,fichin[*ifich]);
      fwrite(buf,sizeof(char),*longueur,fichin[*ifich]);
      fwrite(longueur,sizeof(int),1,fichin[*ifich]);
    }
  else
    {
      ri1.i = *longueur ;
      ri3.c[0]=ri1.c[3];
      ri3.c[1]=ri1.c[2];
      ri3.c[2]=ri1.c[1];
      ri3.c[3]=ri1.c[0];
      fwrite(&ri3,sizeof(int),1,fichin[*ifich]);
     
      if (*iopt == 0)
	{
	  for (i=0; i<lonlon; i++) 
	    {
	      ri1.i = buf[i];
	      ri2.c[0]=ri1.c[3];
	      ri2.c[1]=ri1.c[2];
	      ri2.c[2]=ri1.c[1];
	      ri2.c[3]=ri1.c[0];
	      fwrite(&ri2,sizeof(int),1,fichin[*ifich]);
	    }
	}
      else
	fwrite(buf,sizeof(char),*longueur,fichin[*ifich]);
      
      fwrite(&ri3,sizeof(int),1,fichin[*ifich]);
    }
}


void ecritrecbinspeed(int *ifich, int *buf, int *longueur)
{
  fwrite(longueur,sizeof(int),1,fichin[*ifich]);
  fwrite(buf,sizeof(char),*longueur,fichin[*ifich]);
  fwrite(longueur,sizeof(int),1,fichin[*ifich]);
}

/*
Teste si un float est nan ou infini
ie return:
0 - Pas nan ou infini
4 - Plus infini
5 - Moins infini
8 - Plus/moins nan
9 - Nan
*/
/*
fnaninf4(float *x,int *ie)
{
    *ie=0;

    switch (fpclassifyf(*x)) {
    case FP_PLUS_INF: 
	*ie=4;
	break;
    case FP_MINUS_INF: 
	*ie=5;
	break;
    case FP_SNAN: 
	*ie=8;
	break;
    case FP_QNAN: 
	*ie=9;
	break;
    }
    return;
}
*/
/*
Teste si un double est nan ou infini
ie return:
0 - Pas nan ou infini
4 - Plus infini
5 - Moins infini
8 - Plus/moins nan
9 - Nan
*/
/*
fnaninf8(double *x,int *ie )
{
    *ie=0;

    switch (fpclassify(*x)) {
    case FP_PLUS_INF: 
	*ie=4;
	break;
    case FP_MINUS_INF: 
	*ie=5;
	break;
    case FP_SNAN: 
	*ie=8;
	break;
    case FP_QNAN: 
	*ie=9;
	break;
    }
    return;
}
*/
/* Copie de nbytes de in a out */
void fmemcpy(char *out,char *in,int *nbytes)
{
  memcpy(out,in,*nbytes);
}


#define MAX_ALLOC 1024
struct unit_alloc {
  char *x;
  int t_elem;
  int ofset;
  char *y;
};
typedef struct unit_alloc u_alloc;
u_alloc tab_alloc[MAX_ALLOC];
int last_alloc=0;

/* Allocation dynamique pour fortran:
   x- pointeur vers le pointeur de memoire a alouer
   t_elem- taille en bytes de chaque element
   taille-nombre de bytes a allouer
   ofset- Adress relative (en n items) de la memoire alloue
   ie-codes d'erreur: 0-bon, 1-pas de memoire, 2-tableau interne plein
*/
void fmalloc(char *x,int *t_elem,int *taille,int *ofset,int *ie)
{
  char *y;
  
  if (last_alloc>=MAX_ALLOC) {
    *ie=2;
    return;
  }    
  *ie=0;
  y=malloc((*taille+1)*(*t_elem));
  if ( y == (char *)NULL) {
    *ie=1;
    return;
  }
  *ofset=(y-x)/(*t_elem)+1;
  tab_alloc[last_alloc].x=x;
  tab_alloc[last_alloc].t_elem=*t_elem;
  tab_alloc[last_alloc].ofset=*ofset;
  tab_alloc[last_alloc].y=y;
  last_alloc++;
}

/*Allocation de memoire initialize a zero:
  x- pointeur vers le pointeur de la memoire a allouer
  t_elem- taille en bytes de chaque element
  n_elem- nombre d'elements a allouer
  ofset- Adress relative (en n items) de la memoire alloue
  ie- code d'erreur: 0-bon, 1-pas de memoire, 2-Tableau interne plein
  */
void fcalloc(char *x,int *t_elem,int *n_elem,int *ofset,int *ie)
{
  char *y;
  
  if (last_alloc>=MAX_ALLOC)
    {
      *ie=2;
      return;
    }
  *ie=0;
  y=calloc(*n_elem+1,*t_elem);
  if ( y == (char *)NULL)
    {
      *ie=1;
      return;
    }
  *ofset=( y - x )/( *t_elem)+1;
  tab_alloc[last_alloc].x=x;
  tab_alloc[last_alloc].t_elem=*t_elem;
  tab_alloc[last_alloc].ofset=*ofset;
  tab_alloc[last_alloc].y=y;
  last_alloc++;
}

/* Desallocation de memoire
   x- pointeur vers la memoire a liberer
   t_elem- taille en bytes de chaque element
   ofset- Adress relative (en n items) de la memoire alloue
*/
void ffree(char *x,int *t_elem,int *ofset)
{
  int i;
  for (i=0; i<last_alloc; i++) 
    if (tab_alloc[i].x==x && tab_alloc[i].t_elem==*t_elem &&
	tab_alloc[i].ofset==*ofset )
      break;
  if (i<last_alloc)
    free(tab_alloc[i].y);
  else
    fprintf(stderr,"Erreur interne dans ffree (%x,%d,%d)\n",
	    x,*t_elem,*ofset); 
}

/* Reallocation de memoire
   x- pointeur vers le pointeur de memoire a alouer
   t_elem- taille en bytes de chaque element
   taille-nouvelle taille
   ofset- Adress relative (en n items) de la memoire alloue
   ie-codes d'erreur: 0-bon, 1-pas de memoire, 2-Pointeur a realouer non
   trouve'
*/
void frealloc(char *x,int *t_elem,int *taille,int *ofset,int *ie)
{
  int i;
  for (i=0; i<last_alloc; i++) 
    if (tab_alloc[i].x==x && tab_alloc[i].t_elem==*t_elem &&
	tab_alloc[i].ofset==*ofset )
      break;
  if (i<last_alloc) {
    tab_alloc[i].y=realloc(tab_alloc[i].y,(*taille+1)*(*t_elem));
    if (tab_alloc[i].y==(char *)NULL) {
      *ie=1;
      return;
    }
    tab_alloc[i].ofset=(tab_alloc[i].y-x)/(*t_elem)+1;
    *ofset=tab_alloc[i].ofset;
    *ie=0;
  }
  else {
    *ie=2;
  }
}
/*
gzFile fich[99];
*/
/*
Ouverture pour lecture:
ie- code d'erreur donne:
    0 -pas d' erreur
    1 -erreur d'ouverture
    2 -nom trop long
msg- Message d'erreur
*/
/*
zouvrel(int *ifich, char *inf,int *ie,char *msg)
{
    char mode[4], *st;
    int ern, cnt=0;

    *ie=0;

    for ( st=inf; *st!='\0'; st++) {
	cnt++;
	if (cnt >= 2048) {
	    *ie=2;
	    return;
	}
    }
    st--;
    while (*st==' ' || *st=='\t')
	st--;
    *(++st)='\0';

    fich[*ifich]=gzopen(inf,"rb");
    if (fich[*ifich]==NULL) {
	*ie=1;
	strcpy(msg,gzerror(fich[*ifich],&ern));
    }
}
*/
/*
Ouverture pour ecriture:
ie- code d'erreur donne:
    0 -pas d' erreur
    1 -erreur d'ouverture
    2 -nom trop long
msg- Message d'erreur
*/
/*
zouvree(int *ifich, char *inf,char *niv,int *ie,char *msg)
{
    char mode[4], *st;
    int ern, cnt=0;

    mode[0]='w';
    mode[1]='b';
    mode[2]=niv[0];
    mode[3]='\0';

    *ie=0;

    for ( st=inf; *st!='\0'; st++) {
	cnt++;
	if (cnt >= 2048) {
	    *ie=2;
	    return;
	}
    }
    st--;
    while (*st==' ' || *st=='\t')
	st--;
    *(++st)='\0';

    fich[*ifich]=gzopen(inf,mode);
    if (fich[*ifich]==NULL) {
	strcpy(msg,gzerror(fich[*ifich],&ern));
	*ie=1;
    }
}
*/
/*
Fermeture d'un fichier:
ie- code d'erreur donne:
    0 -pas d' erreur
    1 -erreur de fermeture
msg- Message d'erreur
*/
/*
zferme(int *ifich,int *ie,char *msg)
{
    char *err_m;
    int rc, ern;

    *ie=0;

    rc=gzclose(fich[*ifich]);
    if (rc!=0) {
	strcpy(msg,gzerror(fich[*ifich],&ern));
	*ie=1;
    }
    fich[*ifich]=NULL;
}
*/
/*
Fonction generique de lecture d'un registre de n bytes unformated
ifich: numero du fichier
n: longueur des donnees en bytes
buf: buffer de lecture
ierr: codes d'erreur
      0 - Pas d' erreur
      1 - Erreur de lecture
      2 - Premiere taille incorrecte
      3 - Deuxiemem taille incorrecte
msg: message d'erreur
*/
/*
zlit(int *ifich,int *n,char *buf,int *ie,char *msg)
{
    char *err_m;
    int taille, ret, ern;
    
    ret=gzread(fich[*ifich],&taille,sizeof(int));
    if (taille != *n) {
	*ie=2;
	return;
    }
    else if (ret != sizeof(int)) {
	strcpy(msg,gzerror(fich[*ifich],&ern));
    	*ie=1;
 	return;
    }

    ret=gzread(fich[*ifich],buf,*n);
    if (ret != *n) {
	strcpy(msg,gzerror(fich[*ifich],&ern));
    	*ie=1;
 	return;
    }
    ret=gzread(fich[*ifich],&taille,sizeof(int));
    if (taille != *n) {
	*ie=3;
	return;
    }
    else if (ret != sizeof(int)) {
	strcpy(msg,gzerror(fich[*ifich],&ern));
    	*ie=1;
 	return;
    }
    *ie=0;
}
*/
/*
Fonction generique de lecture d'un registre de taille inconue unformated
ifich: numero du fichier
n: longueur des donnees en bytes
buf: buffer de lecture
ierr: codes d'erreur
      0 - Pas d' erreur
      1 - Erreur de lecture
      2 - Tableau trop petit
      3 - Deuxiemem taille incorrecte
msg: message d'erreur
*/
/*
zliti(int *ifich,int *n,char *buf,int *ie,char *msg)
{
    char *err_m;
    int taille, ret, ern;
    
    ret=gzread(fich[*ifich],&taille,sizeof(int));
    if (taille > *n) {
	*ie=2;
	*n=taille;
	return;
    }
    else if (ret != sizeof(int)) {
	strcpy(msg,gzerror(fich[*ifich],&ern));
    	*ie=1;
 	return;
    }
    *n=taille;

    ret=gzread(fich[*ifich],buf,*n);
    if (ret != *n) {
	strcpy(msg,gzerror(fich[*ifich],&ern));
    	*ie=1;
 	return;
    }
    ret=gzread(fich[*ifich],&taille,sizeof(int));
    if (taille != *n) {
	*ie=3;
	return;
    }
    else if (ret != sizeof(int)) {
	strcpy(msg,gzerror(fich[*ifich],&ern));
    	*ie=1;
 	return;
    }
    *ie=0;
}
*/
/*
Fonction generique d'ecriture d'un registre de n bytes unformated
ifich: numero du fichier
n: longueur des donnees en bytes
buf: buffer de lecture
ie: codes d'erreur
      0 - Pas d' erreur
      1 - Erreur de lecture
      2 - Premiere taille incorrecte
      3 - Deuxiemem taille incorrecte
msg: message d'erreur
*/
/*
zecrit(int *ifich,int *n,char *buf,int *ie,char *msg)
{
    int ret, ern;
    char *err_m;

    *ie=0;
    ret=gzwrite(fich[*ifich],n,sizeof(int));
    if (ret != sizeof(int)) {
	strcpy(msg,gzerror(fich[*ifich],&ern));
    	*ie=1;
 	return;
    }
    ret=gzwrite(fich[*ifich],buf,*n);
    if (ret != *n) {
	strcpy(msg,gzerror(fich[*ifich],&ern));
    	*ie=1;
 	return;
    }
    ret=gzwrite(fich[*ifich],n,sizeof(int));
    if (ret != sizeof(int)) {
	strcpy(msg,gzerror(fich[*ifich],&ern));
    	*ie=1;
	return;
    }
}
*/
/* 
Lecture des fichiers diag_mat.
ifich: numero du fichier
ndm: Correspond a npt_diag_mat(nmat_stock,*)
longueur: Correspond a ndg_lig+1
ie: erreurs:
1-Incompatibilite taille/longueur
2-Record corrompu
*/
/*
zlitrec(int *ifich,int *ndm,short *ncol,float *val,int *longueur,int *ie)
{
    int i, taille, ta, ofset, end;
 
    gzread(fich[*ifich],&taille,sizeof(int));
    if (taille != (*longueur)*sizeof(int)) {
	*ie=1;
	return;
    }
    gzread(fich[*ifich],ndm,taille);
    ta=taille;
    gzread(fich[*ifich],&taille,sizeof(int));
    if (ta != taille) {
	*ie=2;
	return;
    }

    ofset=ndm[0]+1;
    end=ndm[*longueur];
    gzread(fich[*ifich],&taille,sizeof(int));
    if (taille != sizeof(short)*(end-ofset+1) ) {
	*ie=1;
	return;
    }
    gzread(fich[*ifich],ncol+ofset,taille);
    ta=taille;
    gzread(fich[*ifich],&taille,sizeof(int));
    if (ta != taille) {
	*ie=2;
	return;
    }

    gzread(fich[*ifich],&taille,sizeof(int));
    if (taille != sizeof(float)*(end-ofset+1) ) {
	*ie=1;
	return;
    }
    gzread(fich[*ifich],val+ofset,taille);
    ta=taille;
    gzread(fich[*ifich],&taille,sizeof(int));
    if (ta != taille) {
	*ie=2;
	return;
    }
}
*/
/* 
Ecriture des fichiers diag_mat.
ifich: numero du fichier
ndm: Correspond a npt_diag_mat(nmat_stock,*)
longueur: Correspond a ndg_lig+1
*/
/*
zecritrec(int *ifich,int *ndm,short *ncol,float *val,int *longueur,int *nnb_mat,
		int *nnb_mat1)
{
    int i, ie, taille, ta, ofset, end;
 
    taille=(*longueur)*sizeof(int);
    gzwrite(fich[*ifich],&taille,sizeof(int));
    gzwrite(fich[*ifich],ndm,taille);
    gzwrite(fich[*ifich],&taille,sizeof(int));

    ofset=ndm[0]+1;
    end=ndm[*longueur];
    taille=(end-ofset+1)*sizeof(short);
    gzwrite(fich[*ifich],&taille,sizeof(int));
    gzwrite(fich[*ifich],ncol+ofset,taille);
    gzwrite(fich[*ifich],&taille,sizeof(int));
    
    taille=(end-ofset+1)*sizeof(float);
    gzwrite(fich[*ifich],&taille,sizeof(int));
    gzwrite(fich[*ifich],val+ofset,taille);
    gzwrite(fich[*ifich],&taille,sizeof(int));

    if (nnb_mat!=0 || nnb_mat1!=0) {
	taille=2*sizeof(int);
	gzwrite(fich[*ifich],&taille,sizeof(int));
	gzwrite(fich[*ifich],nnb_mat,sizeof(int));
	gzwrite(fich[*ifich],nnb_mat1,sizeof(int));
	gzwrite(fich[*ifich],&taille,sizeof(int));
    }
}
*/
/*
zlitrecbin(int *ifich, int *buf, int *longueur, int *iopt,int *ie,
		 char *msg)
{
    int i, ierr, ern;
    union revint {
	char c[4];
	int i;
    } ri1, ri2;

    *ie=0;
    ierr = gzread(fich[*ifich],&ri1,sizeof(int));
    if (ierr <= 0)
    {
	strcpy(msg,gzerror(fich[*ifich],&ern));
	*longueur = -1;
	*ie=1;
	return;
    }
    if (*iopt == 0)
    {
	ri2.c[0]=ri1.c[3];
	ri2.c[1]=ri1.c[2];
	ri2.c[2]=ri1.c[1];
	ri2.c[3]=ri1.c[0];
	*longueur = ri2.i;
    }
    ierr = gzread(fich[*ifich],buf,sizeof(char)*(*longueur));
    if (ierr <= 0)
    {
	strcpy(msg,gzerror(fich[*ifich],&ern));
	*longueur = -1;
	*ie=1;
	return;
    }
     
    if (*iopt == 0)
    {
	for (i=0; i<(*longueur)/sizeof(int); i++) {
	    ri1.i=buf[i];
	    ri2.c[0]=ri1.c[3];
	    ri2.c[1]=ri1.c[2];
	    ri2.c[2]=ri1.c[1];
	    ri2.c[3]=ri1.c[0];
	    buf[i] = ri2.i;
	}
    }
    ierr=gzread(fich[*ifich],&ri1,sizeof(int));
    if (ierr <= 0)
    {
	strcpy(msg,gzerror(fich[*ifich],&ern));
	*longueur = -1;
	*ie=1;
	return;
    }
}
*/
/*
zlitrecshortbin(int *ifich, short int *buf, int *longueur, int *iopt,
		      int *ie,char *msg)
{
    int i, ierr, ern;
    union revint {
	char c[4];
	int i;
    } ri1, ri2;
    union revint2 {
	char cc[2];
	short int ii;
    } ri3, ri4;

    ierr=gzread(fich[*ifich],&ri1,sizeof(int));
    if (ierr <= 0)
    {
	strcpy(msg,gzerror(fich[*ifich],&ern));
	*longueur = -1;
	*ie=1;
	return;
    }
    ri2.c[0]=ri1.c[3];
    ri2.c[1]=ri1.c[2];
    ri2.c[2]=ri1.c[1];
    ri2.c[3]=ri1.c[0];
    if(*longueur < ri2.i)
    {
	printf("Erreur, buffer trop petit ");
	printf("longueur=%d %d", *longueur, ri2.i);
	return -1;
    }
    *longueur = ri2.i;

    ierr = gzread(fich[*ifich],buf,sizeof(char)*(*longueur));
    if (ierr <= 0)
    {
	strcpy(msg,gzerror(fich[*ifich],&ern));
	*longueur = -1;
	*ie=1;
	return;
    }
    
    if (*iopt == 0)
    {
   	for (i=0; i<(*longueur)/sizeof(short int); i++) {
	    ri3.ii=buf[i];
	    ri4.cc[0]=ri3.cc[1];
	    ri4.cc[1]=ri3.cc[0];
	    buf[i] = ri4.ii;
	}
    }
    ierr=gzread(fich[*ifich],&ri1,sizeof(int));
    if (ierr <= 0)
    {
	strcpy(msg,gzerror(fich[*ifich],&ern));
	*longueur = -1;
	*ie=1;
	return;
    }
}
*/
/* Lecture d'un record binaire provenant de la meme architecture ou 
d'une architecture concurrente 
itype = 0  --> fichier binaire de la meme architecture
itype = -1 --> erreur a l'ouverture du fichier
itype = -2 --> erreur. Mauvaise taille de record dans les 2 sens
itype = 1  --> fichier binaire d'architecture inversee
itype = 2  --> nom de fichier trop long
*/
/*
ztesttypebin(char *inf, int *longueur, int *itype,char *msg)
{
    union revint {
	char c[4];
	int i;
    } ri1, ri2;
    gzFile zfp;
 
    char mode[4], *st;
    int ern, rc, cnt=0;

    *itype=0;

    for ( st=inf; *st!='\0'; st++) {
	cnt++;
	if (cnt >= 2048) {
	    *itype=2;
	    return;
	}
    }
    st--;
    while (*st==' ' || *st=='\t')
	st--;
    *(++st)='\0';

    zfp=gzopen(inf,"rb");
    if (zfp==NULL) {
	strcpy(msg,gzerror(zfp,&ern));
	*itype=-1;
    }
    else
    {
	ern=gzread(zfp,&ri1,sizeof(int));
	if (ern!=sizeof(int)) {
	   strcpy(msg,gzerror(zfp,&ern));
	   *itype=-1;
	   gzclose(zfp);
	   return;
	}
	if ( ri1.i == *longueur )
	    *itype = 0;
	else 
	{
	    ri2.c[0]=ri1.c[3];
	    ri2.c[1]=ri1.c[2];
	    ri2.c[2]=ri1.c[1];
	    ri2.c[3]=ri1.c[0];
	    if (ri2.i != *longueur )
		*itype = -2;
	    else 
	    {
		printf("*** Le fichier %s vient d'une architecture concurrente :\n",inf);
		printf("*** (linux/sun <---> hp/dec/ibm/silicon)\n");
		*itype = 1;
	    }
	}
    }

    rc=gzclose(zfp);
    if (rc!=0) {
	strcpy(msg,gzerror(zfp,&ern));
	*itype=-1;
    }
}
*/
/*
ifich : Numero du fichier
buf : Buffer de retour des valeurs
longueur : En entre taille de buf, en sortie place utilize dans buf
invsize : taille de chaque bloc a inverser
ie : Codes de sortie 0 normal, -1 mauvaise taille de bloc, 
                     -2 mauvaise architecture,-3 erreur de lecture,  
                     1 buffer trop petit, 2 tailles du registre et du bloc incompatibles
*/
/*
zlitrecvbin(int *ifich, char *buf, int *longueur, int *invsize, int *ie,
		  char *msg)
{
    int i, ierr, ti, taille_lue, ern;
    char *ipt;
    union revint {
	char c[4];
	int i;
    } ri;
	
    if (sizeof(int)!=4) {
	*ie=-2;
	fprintf(stderr,"Taille des entiers = %d\n",sizeof(int));
	fprintf(stderr,"Cette facilite necessite des entiers a 4 bytes\n");
	return -1;
    }
    if ( (*invsize)%2 != 0) {
	*ie=-1;
	fprintf(stderr,"Taille des blocs a inverser (%d) n'est pas paire\n",
		*invsize);
	return -1;
    }
    ierr=gzread(fich[*ifich],&ri,sizeof(int));
    if (ierr != sizeof(int)) {
	strcpy(msg,gzerror(fich[*ifich],&ern));
	*ie=-3;
	return;
    }
    ti=ri.c[0];
    ri.c[0]=ri.c[3];
    ri.c[3]=ti;
    ti=ri.c[1];
    ri.c[1]=ri.c[2];
    ri.c[2]=ti;
    taille_lue = ri.i;

    if ( taille_lue > *longueur) {
	*ie=1;
	return -1;
    }
    if ( taille_lue % (*invsize) != 0) {
	*ie=2;
	fprintf(stderr,"La taille du registre (%d) ",taille_lue);
	fprintf(stderr,"n'est pas un multiple de la taille du bloc (%d)\n",*invsize);
	return -1;
    }
    *longueur=taille_lue;

    ierr = gzread(fich[*ifich],buf,sizeof(char)*taille_lue);
    if (ierr <= 0) {	
	strcpy(msg,gzerror(fich[*ifich],&ern));
	*longueur=-1;
	*ie=-3;
	return;
    }
     
    for (ipt=buf; ipt<buf+taille_lue; ipt+= (*invsize)) {
	for (i=0; i<(*invsize)/2; i++) {
	    ti=ipt[i];
	    ipt[i]=ipt[(*invsize)-i-1];
	    ipt[(*invsize)-i-1]=ti;
	}
    }

    gzread(fich[*ifich],&ri,sizeof(int));
    if (ierr <= 0) {	
	strcpy(msg,gzerror(fich[*ifich],&ern));
	*ie=-3;
	return;
    }
    *ie=0;
}
*/
/*
zcompres: Compression en-memoire d'un tableau
Parametres:
out:    buffer de sortie
nout:   taille du buffer de sortie
in:     buffer d'entre
nin:    taille du buffer d'entre
ierr:   codes d'erreur:
        0 Erreur
        1 Pas de memoire
        2 Buffer trop petit
*/
/*
zcompress(char *out,int *nout,char *in,int *nin,int *ierr) {
    int ret;
    
    ret=compress((Bytef *)out,(uLongf *)nout,(Bytef *)in, (uLong) *nin);
    if (ret==Z_OK)
	*ierr=0;
    else if (ret==Z_MEM_ERROR)
	*ierr=1;
    else if (ret==Z_BUF_ERROR)
	*ierr=2;
}
*/
/*
zcompres: Decompression en-memoire d'un tableau
Parametres:
out:    buffer de sortie
nout:   taille du buffer de sortie
in:     buffer d'entre
nin:    taille du buffer d'entre
ierr:   codes d'erreur:
        0 Erreur
        1 Pas de memoire
        2 Buffer trop petit
        3 Donnes corrompus
*/
/*
zdecompress(char *out,int *nout,char *in,int *nin,int *ierr) {
    int ret;

    ret=uncompress((Bytef *)out,(uLongf *)nout,(Bytef *)in,(uLong) *nin);
    if (ret==Z_OK)
	*ierr=0;
    else if (ret==Z_MEM_ERROR)
	*ierr=1;
    else if (ret==Z_BUF_ERROR)
	*ierr=2;
    else if (ret==Z_DATA_ERROR)
	*ierr=3;
}
*/

