/*
 * aconn.h
 *
 * Copyright (C) 2002 Thomas Graf <tgr@reeler.org>
 *
 * This file belongs to the nstats package, see COPYING for more information.
 *
 */

#ifndef ACONN_H_
#define ACONN_H_

#include <netinet/in.h>

struct aconn_s {

    char proto[13];                         /* protocol e.g. "tcp" or "udp"  */

    char *sname;                            /* source hostname (if resolved) */
    char *dname;                       /* destination hostname (if resolved) */
    
    char *sip;                                                  /* source ip */
    char *dip;                                             /* destination ip */

    struct sockaddr_in6 src;         /* source address in network byte order */
    struct sockaddr_in6 dst;    /* destination address in network byte order */

    
    unsigned long long bytes;       /* total bytes that went over this conn. */
    unsigned long long bytes_old; /* total bytes after reading the last time */
    unsigned long long r_bytes;                         /* current byte rate */
    time_t t, last_activity;     /* UNIX time of last activity on this conn. */

    int tcp_state;     /* TCP State XXX: rename to state and put UDP into it */

    int to_remove:1;                   /* flag to mark connection as removed */

    struct aconn_s *next;              /* pointer to next connection in list */
};

/*
 * mark all connection as to be removed, aconn_read_tcp() will unmark connection
 * that still exist
 */
void aconn_mark(void);

/*
 * delete all connection marked as being away, should be like this:
 * 1) aconn_mark();
 * 2) aconn_read_tcp();
 * 3) aconn_delete_marked();
 */
void aconn_delete_marked(void);

/*
 * calculate rate for each connection (in fact it's only done every 3 seconds so
 * it shoudl be called every second or so
 */
void aconn_calc_rate(void);

/*
 * read /dev/net/tcp and update connection list
 */
void aconn_read_tcp(const char *file);

/*
 * print connection list on current curses screen
 */
void aconn_print_connections(void);

/*
 * handles input and sets correct modes
 */
int aconn_handle_input(int ch);


/*
 * wonderful merge sort 8-)
 */
void aconn_sort(void);


#endif
