// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteClusterNoContentCode is the HTTP code returned for type DeleteClusterNoContent
const DeleteClusterNoContentCode int = 204

/*
DeleteClusterNoContent Cluster settings deleted and node moved to single mode

swagger:response deleteClusterNoContent
*/
type DeleteClusterNoContent struct {
}

// NewDeleteClusterNoContent creates DeleteClusterNoContent with default headers values
func NewDeleteClusterNoContent() *DeleteClusterNoContent {

	return &DeleteClusterNoContent{}
}

// WriteResponse to the client
func (o *DeleteClusterNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

/*
DeleteClusterDefault General Error

swagger:response deleteClusterDefault
*/
type DeleteClusterDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteClusterDefault creates DeleteClusterDefault with default headers values
func NewDeleteClusterDefault(code int) *DeleteClusterDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteClusterDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete cluster default response
func (o *DeleteClusterDefault) WithStatusCode(code int) *DeleteClusterDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete cluster default response
func (o *DeleteClusterDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete cluster default response
func (o *DeleteClusterDefault) WithConfigurationVersion(configurationVersion string) *DeleteClusterDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete cluster default response
func (o *DeleteClusterDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete cluster default response
func (o *DeleteClusterDefault) WithPayload(payload *models.Error) *DeleteClusterDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete cluster default response
func (o *DeleteClusterDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteClusterDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
