/* custom-pattern.c generated by valac 0.46.3, the Vala compiler
 * generated from custom-pattern.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2014  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>

#define PASANG_TYPE_PATTERN (pasang_pattern_get_type ())
#define PASANG_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_PATTERN, PasangPattern))
#define PASANG_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_PATTERN, PasangPatternClass))
#define PASANG_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_PATTERN))
#define PASANG_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_PATTERN))
#define PASANG_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_PATTERN, PasangPatternClass))

typedef struct _PasangPattern PasangPattern;
typedef struct _PasangPatternClass PasangPatternClass;
typedef struct _PasangPatternPrivate PasangPatternPrivate;

#define PASANG_TYPE_CUSTOM_PATTERN (pasang_custom_pattern_get_type ())
#define PASANG_CUSTOM_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_CUSTOM_PATTERN, PasangCustomPattern))
#define PASANG_CUSTOM_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_CUSTOM_PATTERN, PasangCustomPatternClass))
#define PASANG_IS_CUSTOM_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_CUSTOM_PATTERN))
#define PASANG_IS_CUSTOM_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_CUSTOM_PATTERN))
#define PASANG_CUSTOM_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_CUSTOM_PATTERN, PasangCustomPatternClass))

typedef struct _PasangCustomPattern PasangCustomPattern;
typedef struct _PasangCustomPatternClass PasangCustomPatternClass;
typedef struct _PasangCustomPatternPrivate PasangCustomPatternPrivate;
typedef enum  {
	PASANG_PIECE_NULL = -999,
	PASANG_PIECE_KAS_0 = 0,
	PASANG_PIECE_KAS_1 = 1,
	PASANG_PIECE_BLACK = 2,
	PASANG_PIECE_WHITE = 3,
	PASANG_PIECE_COUNT = 4,
	PASANG_PIECE_BOARD = 4,
	PASANG_PIECE_GUARD = 5,
	PASANG_PIECE_GUIDE = 6,
	PASANG_PIECE_EMPTY = 100
} PasangPiece;

#define PASANG_TYPE_PIECE (pasang_piece_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define PASANG_TYPE_BLANK_PATTERN (pasang_blank_pattern_get_type ())
#define PASANG_BLANK_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_BLANK_PATTERN, PasangBlankPattern))
#define PASANG_BLANK_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_BLANK_PATTERN, PasangBlankPatternClass))
#define PASANG_IS_BLANK_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_BLANK_PATTERN))
#define PASANG_IS_BLANK_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_BLANK_PATTERN))
#define PASANG_BLANK_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_BLANK_PATTERN, PasangBlankPatternClass))

typedef struct _PasangBlankPattern PasangBlankPattern;
typedef struct _PasangBlankPatternClass PasangBlankPatternClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _PasangBlankPatternPrivate PasangBlankPatternPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PasangPattern {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PasangPatternPrivate * priv;
	gchar* name;
	gchar* dots;
	guint8* pixbuf_data;
	gint pixbuf_data_length1;
	gint _pixbuf_data_size_;
	GdkPixbuf* pixbuf;
	gint dot_width;
	GtkRadioButton* button;
};

struct _PasangPatternClass {
	GTypeClass parent_class;
	void (*finalize) (PasangPattern *self);
	void (*background) (PasangPattern* self, gint n, gint x, gint y);
	void (*create_pixbuf) (PasangPattern* self);
};

struct _PasangCustomPattern {
	PasangPattern parent_instance;
	PasangCustomPatternPrivate * priv;
	PasangPiece* board;
	gint board_length1;
	gint _board_size_;
};

struct _PasangCustomPatternClass {
	PasangPatternClass parent_class;
};

struct _PasangBlankPattern {
	PasangCustomPattern parent_instance;
	PasangBlankPatternPrivate * priv;
};

struct _PasangBlankPatternClass {
	PasangCustomPatternClass parent_class;
};

static gpointer pasang_custom_pattern_parent_class = NULL;
static gpointer pasang_blank_pattern_parent_class = NULL;

gpointer pasang_pattern_ref (gpointer instance);
void pasang_pattern_unref (gpointer instance);
GParamSpec* pasang_param_spec_pattern (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void pasang_value_set_pattern (GValue* value,
                               gpointer v_object);
void pasang_value_take_pattern (GValue* value,
                                gpointer v_object);
gpointer pasang_value_get_pattern (const GValue* value);
GType pasang_pattern_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangPattern, pasang_pattern_unref)
GType pasang_custom_pattern_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangCustomPattern, pasang_pattern_unref)
GType pasang_piece_get_type (void) G_GNUC_CONST;
#define PASANG_BOARD_SIZE (13 * 13)
PasangCustomPattern* pasang_custom_pattern_new (void);
PasangCustomPattern* pasang_custom_pattern_construct (GType object_type);
PasangPattern* pasang_pattern_new_empty (const gchar* name);
PasangPattern* pasang_pattern_construct_empty (GType object_type,
                                               const gchar* name);
void pasang_custom_pattern_update (PasangCustomPattern* self);
PasangCustomPattern* pasang_custom_pattern_new_from_text (const gchar* dots);
PasangCustomPattern* pasang_custom_pattern_construct_from_text (GType object_type,
                                                                const gchar* dots);
void pasang_game_compile (const gchar* pattern,
                          PasangPiece** b,
                          gint* b_length1);
PasangCustomPattern* pasang_custom_pattern_new_copy (PasangCustomPattern* original);
PasangCustomPattern* pasang_custom_pattern_construct_copy (GType object_type,
                                                           PasangCustomPattern* original);
gint pasang_custom_pattern_count_whites (PasangCustomPattern* self);
static PasangPiece* _vala_array_dup1 (PasangPiece* self,
                               int length);
static void pasang_custom_pattern_real_background (PasangPattern* base,
                                            gint n,
                                            gint x,
                                            gint y);
static void pasang_custom_pattern_board_to_dots (PasangCustomPattern* self);
#define PASANG_BOARD_WIDTH 13
void pasang_pattern_create_pixbuf (PasangPattern* self);
static void pasang_custom_pattern_real_create_pixbuf (PasangPattern* base);
void pasang_pattern_create_pixbuf_from_board (PasangPattern* self,
                                              PasangPiece** board,
                                              gint* board_length1);
GType pasang_blank_pattern_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangBlankPattern, pasang_pattern_unref)
static void pasang_custom_pattern_finalize (PasangPattern * obj);
PasangBlankPattern* pasang_blank_pattern_new (void);
PasangBlankPattern* pasang_blank_pattern_construct (GType object_type);

PasangCustomPattern*
pasang_custom_pattern_construct (GType object_type)
{
	PasangCustomPattern* self = NULL;
#line 25 "custom-pattern.vala"
	self = (PasangCustomPattern*) pasang_pattern_construct_empty (object_type, "");
#line 188 "custom-pattern.c"
	{
		gint i = 0;
#line 26 "custom-pattern.vala"
		i = 0;
#line 193 "custom-pattern.c"
		{
			gboolean _tmp0_ = FALSE;
#line 26 "custom-pattern.vala"
			_tmp0_ = TRUE;
#line 26 "custom-pattern.vala"
			while (TRUE) {
#line 200 "custom-pattern.c"
				PasangPiece* _tmp2_;
				gint _tmp2__length1;
				PasangPiece* _tmp3_;
				gint _tmp3__length1;
#line 26 "custom-pattern.vala"
				if (!_tmp0_) {
#line 207 "custom-pattern.c"
					gint _tmp1_;
#line 26 "custom-pattern.vala"
					_tmp1_ = i;
#line 26 "custom-pattern.vala"
					i = _tmp1_ + 1;
#line 213 "custom-pattern.c"
				}
#line 26 "custom-pattern.vala"
				_tmp0_ = FALSE;
#line 26 "custom-pattern.vala"
				_tmp2_ = self->board;
#line 26 "custom-pattern.vala"
				_tmp2__length1 = self->board_length1;
#line 26 "custom-pattern.vala"
				if (!(i < _tmp2__length1)) {
#line 26 "custom-pattern.vala"
					break;
#line 225 "custom-pattern.c"
				}
#line 27 "custom-pattern.vala"
				_tmp3_ = self->board;
#line 27 "custom-pattern.vala"
				_tmp3__length1 = self->board_length1;
#line 27 "custom-pattern.vala"
				_tmp3_[i] = PASANG_PIECE_BLACK;
#line 233 "custom-pattern.c"
			}
		}
	}
#line 29 "custom-pattern.vala"
	pasang_custom_pattern_update (self);
#line 24 "custom-pattern.vala"
	return self;
#line 241 "custom-pattern.c"
}

PasangCustomPattern*
pasang_custom_pattern_new (void)
{
#line 24 "custom-pattern.vala"
	return pasang_custom_pattern_construct (PASANG_TYPE_CUSTOM_PATTERN);
#line 249 "custom-pattern.c"
}

PasangCustomPattern*
pasang_custom_pattern_construct_from_text (GType object_type,
                                           const gchar* dots)
{
	PasangCustomPattern* self = NULL;
#line 32 "custom-pattern.vala"
	g_return_val_if_fail (dots != NULL, NULL);
#line 33 "custom-pattern.vala"
	self = (PasangCustomPattern*) pasang_pattern_construct_empty (object_type, "");
#line 34 "custom-pattern.vala"
	pasang_game_compile (dots, &self->board, (gint*) (&self->board_length1));
#line 35 "custom-pattern.vala"
	pasang_custom_pattern_update (self);
#line 32 "custom-pattern.vala"
	return self;
#line 267 "custom-pattern.c"
}

PasangCustomPattern*
pasang_custom_pattern_new_from_text (const gchar* dots)
{
#line 32 "custom-pattern.vala"
	return pasang_custom_pattern_construct_from_text (PASANG_TYPE_CUSTOM_PATTERN, dots);
#line 275 "custom-pattern.c"
}

/**
     * Make a copy that can be used by the pattern selector.
     * In particular, dots must be compilable.
     */
static PasangPiece*
_vala_array_dup1 (PasangPiece* self,
                  int length)
{
#line 45 "custom-pattern.vala"
	return g_memdup (self, length * sizeof (PasangPiece));
#line 288 "custom-pattern.c"
}

PasangCustomPattern*
pasang_custom_pattern_construct_copy (GType object_type,
                                      PasangCustomPattern* original)
{
	PasangCustomPattern* self = NULL;
	PasangPiece* _tmp0_;
	gint _tmp0__length1;
	PasangPiece* _tmp1_;
	gint _tmp1__length1;
#line 42 "custom-pattern.vala"
	g_return_val_if_fail (original != NULL, NULL);
#line 43 "custom-pattern.vala"
	self = (PasangCustomPattern*) pasang_pattern_construct_empty (object_type, "");
#line 44 "custom-pattern.vala"
	_vala_assert (pasang_custom_pattern_count_whites (original) == 60, "original.count_whites () == 60");
#line 45 "custom-pattern.vala"
	_tmp0_ = original->board;
#line 45 "custom-pattern.vala"
	_tmp0__length1 = original->board_length1;
#line 45 "custom-pattern.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 45 "custom-pattern.vala"
	_tmp1__length1 = _tmp0__length1;
#line 45 "custom-pattern.vala"
	self->board = (g_free (self->board), NULL);
#line 45 "custom-pattern.vala"
	self->board = _tmp1_;
#line 45 "custom-pattern.vala"
	self->board_length1 = _tmp1__length1;
#line 45 "custom-pattern.vala"
	self->_board_size_ = self->board_length1;
#line 46 "custom-pattern.vala"
	pasang_custom_pattern_update (self);
#line 42 "custom-pattern.vala"
	return self;
#line 326 "custom-pattern.c"
}

PasangCustomPattern*
pasang_custom_pattern_new_copy (PasangCustomPattern* original)
{
#line 42 "custom-pattern.vala"
	return pasang_custom_pattern_construct_copy (PASANG_TYPE_CUSTOM_PATTERN, original);
#line 334 "custom-pattern.c"
}

static void
pasang_custom_pattern_real_background (PasangPattern* base,
                                       gint n,
                                       gint x,
                                       gint y)
{
	PasangCustomPattern * self;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
#line 49 "custom-pattern.vala"
	self = (PasangCustomPattern*) base;
#line 50 "custom-pattern.vala"
	_tmp0_ = ((PasangPattern*) self)->pixbuf_data;
#line 50 "custom-pattern.vala"
	_tmp0__length1 = ((PasangPattern*) self)->pixbuf_data_length1;
#line 50 "custom-pattern.vala"
	_tmp0_[n + 0] = (guint8) 0;
#line 51 "custom-pattern.vala"
	_tmp1_ = ((PasangPattern*) self)->pixbuf_data;
#line 51 "custom-pattern.vala"
	_tmp1__length1 = ((PasangPattern*) self)->pixbuf_data_length1;
#line 51 "custom-pattern.vala"
	_tmp2_ = ((PasangPattern*) self)->pixbuf_data;
#line 51 "custom-pattern.vala"
	_tmp2__length1 = ((PasangPattern*) self)->pixbuf_data_length1;
#line 51 "custom-pattern.vala"
	_tmp2_[n + 2] = (guint8) (150 - (30 / (3 - ((x + y) % 3))));
#line 51 "custom-pattern.vala"
	_tmp1_[n + 1] = (guint8) (150 - (30 / (3 - ((x + y) % 3))));
#line 53 "custom-pattern.vala"
	_tmp3_ = ((PasangPattern*) self)->pixbuf_data;
#line 53 "custom-pattern.vala"
	_tmp3__length1 = ((PasangPattern*) self)->pixbuf_data_length1;
#line 53 "custom-pattern.vala"
	_tmp3_[n + 3] = (guint8) 255;
#line 378 "custom-pattern.c"
}

/**
     * Construct a textual representation consistent with the contents of board[].
     */
static void
pasang_custom_pattern_board_to_dots (PasangCustomPattern* self)
{
	gchar* _tmp0_;
#line 59 "custom-pattern.vala"
	g_return_if_fail (self != NULL);
#line 60 "custom-pattern.vala"
	_tmp0_ = g_strdup ("");
#line 60 "custom-pattern.vala"
	_g_free0 (((PasangPattern*) self)->dots);
#line 60 "custom-pattern.vala"
	((PasangPattern*) self)->dots = _tmp0_;
#line 396 "custom-pattern.c"
	{
		gint i = 0;
#line 61 "custom-pattern.vala"
		i = 0;
#line 401 "custom-pattern.c"
		{
			gboolean _tmp1_ = FALSE;
#line 61 "custom-pattern.vala"
			_tmp1_ = TRUE;
#line 61 "custom-pattern.vala"
			while (TRUE) {
#line 408 "custom-pattern.c"
				PasangPiece* _tmp3_;
				gint _tmp3__length1;
				gint x = 0;
				gint y = 0;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
#line 61 "custom-pattern.vala"
				if (!_tmp1_) {
#line 418 "custom-pattern.c"
					gint _tmp2_;
#line 61 "custom-pattern.vala"
					_tmp2_ = i;
#line 61 "custom-pattern.vala"
					i = _tmp2_ + 1;
#line 424 "custom-pattern.c"
				}
#line 61 "custom-pattern.vala"
				_tmp1_ = FALSE;
#line 61 "custom-pattern.vala"
				_tmp3_ = self->board;
#line 61 "custom-pattern.vala"
				_tmp3__length1 = self->board_length1;
#line 61 "custom-pattern.vala"
				if (!(i < (_tmp3__length1 / 2))) {
#line 61 "custom-pattern.vala"
					break;
#line 436 "custom-pattern.c"
				}
#line 62 "custom-pattern.vala"
				x = i % PASANG_BOARD_WIDTH;
#line 63 "custom-pattern.vala"
				y = i / PASANG_BOARD_WIDTH;
#line 64 "custom-pattern.vala"
				if (x >= 1) {
#line 64 "custom-pattern.vala"
					_tmp6_ = x <= 11;
#line 446 "custom-pattern.c"
				} else {
#line 64 "custom-pattern.vala"
					_tmp6_ = FALSE;
#line 450 "custom-pattern.c"
				}
#line 64 "custom-pattern.vala"
				if (_tmp6_) {
#line 64 "custom-pattern.vala"
					_tmp5_ = y >= 1;
#line 456 "custom-pattern.c"
				} else {
#line 64 "custom-pattern.vala"
					_tmp5_ = FALSE;
#line 460 "custom-pattern.c"
				}
#line 64 "custom-pattern.vala"
				if (_tmp5_) {
#line 64 "custom-pattern.vala"
					_tmp4_ = y <= 11;
#line 466 "custom-pattern.c"
				} else {
#line 64 "custom-pattern.vala"
					_tmp4_ = FALSE;
#line 470 "custom-pattern.c"
				}
#line 64 "custom-pattern.vala"
				if (_tmp4_) {
#line 474 "custom-pattern.c"
					const gchar* _tmp7_ = NULL;
					PasangPiece* _tmp8_;
					gint _tmp8__length1;
					PasangPiece _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
#line 65 "custom-pattern.vala"
					_tmp8_ = self->board;
#line 65 "custom-pattern.vala"
					_tmp8__length1 = self->board_length1;
#line 65 "custom-pattern.vala"
					_tmp9_ = _tmp8_[i];
#line 65 "custom-pattern.vala"
					if (_tmp9_ == PASANG_PIECE_WHITE) {
#line 65 "custom-pattern.vala"
						_tmp7_ = "P";
#line 491 "custom-pattern.c"
					} else {
#line 65 "custom-pattern.vala"
						_tmp7_ = "H";
#line 495 "custom-pattern.c"
					}
#line 65 "custom-pattern.vala"
					_tmp10_ = ((PasangPattern*) self)->dots;
#line 65 "custom-pattern.vala"
					_tmp11_ = g_strconcat (_tmp10_, _tmp7_, NULL);
#line 65 "custom-pattern.vala"
					_g_free0 (((PasangPattern*) self)->dots);
#line 65 "custom-pattern.vala"
					((PasangPattern*) self)->dots = _tmp11_;
#line 505 "custom-pattern.c"
				}
			}
		}
	}
}

gint
pasang_custom_pattern_count_whites (PasangCustomPattern* self)
{
	gint num_whites = 0;
	PasangPiece* _tmp0_;
	gint _tmp0__length1;
	gint result = 0;
#line 69 "custom-pattern.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 70 "custom-pattern.vala"
	num_whites = 0;
#line 71 "custom-pattern.vala"
	_tmp0_ = self->board;
#line 71 "custom-pattern.vala"
	_tmp0__length1 = self->board_length1;
#line 527 "custom-pattern.c"
	{
		PasangPiece* p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
#line 71 "custom-pattern.vala"
		p_collection = _tmp0_;
#line 71 "custom-pattern.vala"
		p_collection_length1 = _tmp0__length1;
#line 71 "custom-pattern.vala"
		for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
#line 539 "custom-pattern.c"
			PasangPiece p = 0;
#line 71 "custom-pattern.vala"
			p = p_collection[p_it];
#line 543 "custom-pattern.c"
			{
				PasangPiece _tmp1_;
#line 72 "custom-pattern.vala"
				_tmp1_ = p;
#line 72 "custom-pattern.vala"
				if (_tmp1_ == PASANG_PIECE_WHITE) {
#line 550 "custom-pattern.c"
					gint _tmp2_;
#line 72 "custom-pattern.vala"
					_tmp2_ = num_whites;
#line 72 "custom-pattern.vala"
					num_whites = _tmp2_ + 1;
#line 556 "custom-pattern.c"
				}
			}
		}
	}
#line 73 "custom-pattern.vala"
	result = num_whites;
#line 73 "custom-pattern.vala"
	return result;
#line 565 "custom-pattern.c"
}

/**
     * Make this pattern internally consistent (called after changing board[]).
     * (1) Update dots.
     * (2) Update pixbuf_data with the image of the pattern and a meter reading
     *     to indicate the number of whites and blacks. The meter reading is removed
     *     when there are exactly 60 whites and 60 blacks.
     */
void
pasang_custom_pattern_update (PasangCustomPattern* self)
{
#line 83 "custom-pattern.vala"
	g_return_if_fail (self != NULL);
#line 84 "custom-pattern.vala"
	pasang_custom_pattern_board_to_dots (self);
#line 85 "custom-pattern.vala"
	pasang_pattern_create_pixbuf ((PasangPattern*) self);
#line 584 "custom-pattern.c"
}

static void
pasang_custom_pattern_real_create_pixbuf (PasangPattern* base)
{
	PasangCustomPattern * self;
	gint num_whites = 0;
	gboolean _tmp0_ = FALSE;
	gint image_width = 0;
	gint sizeof_pixel = 0;
	GtkRadioButton* _tmp10_;
	GdkPixbuf* _tmp11_;
	GtkImage* _tmp12_;
	GtkImage* _tmp13_;
#line 88 "custom-pattern.vala"
	self = (PasangCustomPattern*) base;
#line 89 "custom-pattern.vala"
	pasang_pattern_create_pixbuf_from_board ((PasangPattern*) self, &self->board, (gint*) (&self->board_length1));
#line 91 "custom-pattern.vala"
	num_whites = pasang_custom_pattern_count_whites (self);
#line 92 "custom-pattern.vala"
	if (PASANG_IS_BLANK_PATTERN (self)) {
#line 92 "custom-pattern.vala"
		_tmp0_ = TRUE;
#line 609 "custom-pattern.c"
	} else {
#line 92 "custom-pattern.vala"
		_tmp0_ = num_whites == 60;
#line 613 "custom-pattern.c"
	}
#line 92 "custom-pattern.vala"
	if (_tmp0_) {
#line 92 "custom-pattern.vala"
		return;
#line 619 "custom-pattern.c"
	}
#line 95 "custom-pattern.vala"
	image_width = PASANG_BOARD_WIDTH * ((PasangPattern*) self)->dot_width;
#line 96 "custom-pattern.vala"
	sizeof_pixel = 4;
#line 625 "custom-pattern.c"
	{
		gint x = 0;
#line 97 "custom-pattern.vala"
		x = ((PasangPattern*) self)->dot_width;
#line 630 "custom-pattern.c"
		{
			gboolean _tmp1_ = FALSE;
#line 97 "custom-pattern.vala"
			_tmp1_ = TRUE;
#line 97 "custom-pattern.vala"
			while (TRUE) {
#line 637 "custom-pattern.c"
				gint _tmp3_ = 0;
				gint col = 0;
#line 97 "custom-pattern.vala"
				if (!_tmp1_) {
#line 642 "custom-pattern.c"
					gint _tmp2_;
#line 97 "custom-pattern.vala"
					_tmp2_ = x;
#line 97 "custom-pattern.vala"
					x = _tmp2_ + 1;
#line 648 "custom-pattern.c"
				}
#line 97 "custom-pattern.vala"
				_tmp1_ = FALSE;
#line 97 "custom-pattern.vala"
				if (!(x < (image_width - ((PasangPattern*) self)->dot_width))) {
#line 97 "custom-pattern.vala"
					break;
#line 656 "custom-pattern.c"
				}
#line 98 "custom-pattern.vala"
				if (((num_whites - 60) + (image_width / 2)) <= x) {
#line 98 "custom-pattern.vala"
					_tmp3_ = 128;
#line 662 "custom-pattern.c"
				} else {
#line 98 "custom-pattern.vala"
					_tmp3_ = 255;
#line 666 "custom-pattern.c"
				}
#line 98 "custom-pattern.vala"
				col = _tmp3_;
#line 670 "custom-pattern.c"
				{
					gint y = 0;
#line 99 "custom-pattern.vala"
					y = 0;
#line 675 "custom-pattern.c"
					{
						gboolean _tmp4_ = FALSE;
#line 99 "custom-pattern.vala"
						_tmp4_ = TRUE;
#line 99 "custom-pattern.vala"
						while (TRUE) {
#line 682 "custom-pattern.c"
							gint n = 0;
							guint8* _tmp6_;
							gint _tmp6__length1;
							guint8* _tmp7_;
							gint _tmp7__length1;
							guint8* _tmp8_;
							gint _tmp8__length1;
							guint8* _tmp9_;
							gint _tmp9__length1;
#line 99 "custom-pattern.vala"
							if (!_tmp4_) {
#line 694 "custom-pattern.c"
								gint _tmp5_;
#line 99 "custom-pattern.vala"
								_tmp5_ = y;
#line 99 "custom-pattern.vala"
								y = _tmp5_ + 1;
#line 700 "custom-pattern.c"
							}
#line 99 "custom-pattern.vala"
							_tmp4_ = FALSE;
#line 99 "custom-pattern.vala"
							if (!(y < (((PasangPattern*) self)->dot_width - 1))) {
#line 99 "custom-pattern.vala"
								break;
#line 708 "custom-pattern.c"
							}
#line 100 "custom-pattern.vala"
							n = ((y * image_width) + x) * sizeof_pixel;
#line 101 "custom-pattern.vala"
							_tmp6_ = ((PasangPattern*) self)->pixbuf_data;
#line 101 "custom-pattern.vala"
							_tmp6__length1 = ((PasangPattern*) self)->pixbuf_data_length1;
#line 101 "custom-pattern.vala"
							_tmp6_[n] = (guint8) col;
#line 102 "custom-pattern.vala"
							_tmp7_ = ((PasangPattern*) self)->pixbuf_data;
#line 102 "custom-pattern.vala"
							_tmp7__length1 = ((PasangPattern*) self)->pixbuf_data_length1;
#line 102 "custom-pattern.vala"
							_tmp8_ = ((PasangPattern*) self)->pixbuf_data;
#line 102 "custom-pattern.vala"
							_tmp8__length1 = ((PasangPattern*) self)->pixbuf_data_length1;
#line 102 "custom-pattern.vala"
							_tmp8_[n + 2] = (guint8) 0;
#line 102 "custom-pattern.vala"
							_tmp7_[n + 1] = (guint8) 0;
#line 103 "custom-pattern.vala"
							_tmp9_ = ((PasangPattern*) self)->pixbuf_data;
#line 103 "custom-pattern.vala"
							_tmp9__length1 = ((PasangPattern*) self)->pixbuf_data_length1;
#line 103 "custom-pattern.vala"
							_tmp9_[n + 3] = (guint8) 255;
#line 736 "custom-pattern.c"
						}
					}
				}
			}
		}
	}
#line 107 "custom-pattern.vala"
	_tmp10_ = ((PasangPattern*) self)->button;
#line 107 "custom-pattern.vala"
	_tmp11_ = ((PasangPattern*) self)->pixbuf;
#line 107 "custom-pattern.vala"
	_tmp12_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp11_);
#line 107 "custom-pattern.vala"
	g_object_ref_sink (_tmp12_);
#line 107 "custom-pattern.vala"
	_tmp13_ = _tmp12_;
#line 107 "custom-pattern.vala"
	gtk_button_set_image ((GtkButton*) _tmp10_, (GtkWidget*) _tmp13_);
#line 107 "custom-pattern.vala"
	_g_object_unref0 (_tmp13_);
#line 757 "custom-pattern.c"
}

static void
pasang_custom_pattern_class_init (PasangCustomPatternClass * klass,
                                  gpointer klass_data)
{
#line 21 "custom-pattern.vala"
	pasang_custom_pattern_parent_class = g_type_class_peek_parent (klass);
#line 21 "custom-pattern.vala"
	((PasangPatternClass *) klass)->finalize = pasang_custom_pattern_finalize;
#line 21 "custom-pattern.vala"
	((PasangPatternClass *) klass)->background = (void (*) (PasangPattern*, gint, gint, gint)) pasang_custom_pattern_real_background;
#line 21 "custom-pattern.vala"
	((PasangPatternClass *) klass)->create_pixbuf = (void (*) (PasangPattern*)) pasang_custom_pattern_real_create_pixbuf;
#line 772 "custom-pattern.c"
}

static void
pasang_custom_pattern_instance_init (PasangCustomPattern * self,
                                     gpointer klass)
{
	PasangPiece* _tmp0_;
#line 22 "custom-pattern.vala"
	_tmp0_ = g_new0 (PasangPiece, PASANG_BOARD_SIZE);
#line 22 "custom-pattern.vala"
	self->board = _tmp0_;
#line 22 "custom-pattern.vala"
	self->board_length1 = PASANG_BOARD_SIZE;
#line 22 "custom-pattern.vala"
	self->_board_size_ = self->board_length1;
#line 788 "custom-pattern.c"
}

static void
pasang_custom_pattern_finalize (PasangPattern * obj)
{
	PasangCustomPattern * self;
#line 21 "custom-pattern.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_CUSTOM_PATTERN, PasangCustomPattern);
#line 22 "custom-pattern.vala"
	self->board = (g_free (self->board), NULL);
#line 21 "custom-pattern.vala"
	PASANG_PATTERN_CLASS (pasang_custom_pattern_parent_class)->finalize (obj);
#line 801 "custom-pattern.c"
}

GType
pasang_custom_pattern_get_type (void)
{
	static volatile gsize pasang_custom_pattern_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_custom_pattern_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangCustomPatternClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_custom_pattern_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangCustomPattern), 0, (GInstanceInitFunc) pasang_custom_pattern_instance_init, NULL };
		GType pasang_custom_pattern_type_id;
		pasang_custom_pattern_type_id = g_type_register_static (PASANG_TYPE_PATTERN, "PasangCustomPattern", &g_define_type_info, 0);
		g_once_init_leave (&pasang_custom_pattern_type_id__volatile, pasang_custom_pattern_type_id);
	}
	return pasang_custom_pattern_type_id__volatile;
}

PasangBlankPattern*
pasang_blank_pattern_construct (GType object_type)
{
	PasangBlankPattern* self = NULL;
#line 112 "custom-pattern.vala"
	self = (PasangBlankPattern*) pasang_custom_pattern_construct (object_type);
#line 112 "custom-pattern.vala"
	return self;
#line 825 "custom-pattern.c"
}

PasangBlankPattern*
pasang_blank_pattern_new (void)
{
#line 112 "custom-pattern.vala"
	return pasang_blank_pattern_construct (PASANG_TYPE_BLANK_PATTERN);
#line 833 "custom-pattern.c"
}

static void
pasang_blank_pattern_class_init (PasangBlankPatternClass * klass,
                                 gpointer klass_data)
{
#line 112 "custom-pattern.vala"
	pasang_blank_pattern_parent_class = g_type_class_peek_parent (klass);
#line 842 "custom-pattern.c"
}

static void
pasang_blank_pattern_instance_init (PasangBlankPattern * self,
                                    gpointer klass)
{
}

GType
pasang_blank_pattern_get_type (void)
{
	static volatile gsize pasang_blank_pattern_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_blank_pattern_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangBlankPatternClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_blank_pattern_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangBlankPattern), 0, (GInstanceInitFunc) pasang_blank_pattern_instance_init, NULL };
		GType pasang_blank_pattern_type_id;
		pasang_blank_pattern_type_id = g_type_register_static (PASANG_TYPE_CUSTOM_PATTERN, "PasangBlankPattern", &g_define_type_info, 0);
		g_once_init_leave (&pasang_blank_pattern_type_id__volatile, pasang_blank_pattern_type_id);
	}
	return pasang_blank_pattern_type_id__volatile;
}

