// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: server/serverpb/status.proto

package serverpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_build "github.com/cockroachdb/cockroach/pkg/build"
import cockroach_gossip "github.com/cockroachdb/cockroach/pkg/gossip"
import cockroach_sql "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_server_diagnosticspb "github.com/cockroachdb/cockroach/pkg/server/diagnosticspb"
import cockroach_server_status "github.com/cockroachdb/cockroach/pkg/server/status"
import cockroach_storage_engine_enginepb1 "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import cockroach_storage1 "github.com/cockroachdb/cockroach/pkg/storage"
import cockroach_storage_storagebase "github.com/cockroachdb/cockroach/pkg/storage/storagebase"
import cockroach_util_log "github.com/cockroachdb/cockroach/pkg/util/log"
import cockroach_util "github.com/cockroachdb/cockroach/pkg/util"
import raftpb "go.etcd.io/etcd/raft/raftpb"

import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import time "time"
import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import context "context"
import grpc "google.golang.org/grpc"

import sortkeys "github.com/gogo/protobuf/sortkeys"
import binary "encoding/binary"
import types "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// Represents the type of file.
// TODO(ridwanmsharif): Add support for log files. They're currently served
// by an endpoint that parses the log messages, which is not what the
// debug zip client wants.
type FileType int32

const (
	FileType_HEAP FileType = 0
)

var FileType_name = map[int32]string{
	0: "HEAP",
}
var FileType_value = map[string]int32{
	"HEAP": 0,
}

func (x FileType) String() string {
	return proto.EnumName(FileType_name, int32(x))
}
func (FileType) EnumDescriptor() ([]byte, []int) { return fileDescriptorStatus, []int{0} }

// We use an enum to allow reporting of client certs and potential others (eg:
// UI).
type CertificateDetails_CertificateType int32

const (
	CertificateDetails_CA        CertificateDetails_CertificateType = 0
	CertificateDetails_NODE      CertificateDetails_CertificateType = 1
	CertificateDetails_CLIENT_CA CertificateDetails_CertificateType = 2
	CertificateDetails_CLIENT    CertificateDetails_CertificateType = 3
	CertificateDetails_UI_CA     CertificateDetails_CertificateType = 4
	CertificateDetails_UI        CertificateDetails_CertificateType = 5
)

var CertificateDetails_CertificateType_name = map[int32]string{
	0: "CA",
	1: "NODE",
	2: "CLIENT_CA",
	3: "CLIENT",
	4: "UI_CA",
	5: "UI",
}
var CertificateDetails_CertificateType_value = map[string]int32{
	"CA":        0,
	"NODE":      1,
	"CLIENT_CA": 2,
	"CLIENT":    3,
	"UI_CA":     4,
	"UI":        5,
}

func (x CertificateDetails_CertificateType) String() string {
	return proto.EnumName(CertificateDetails_CertificateType_name, int32(x))
}
func (CertificateDetails_CertificateType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorStatus, []int{1, 0}
}

type ProfileRequest_Type int32

const (
	ProfileRequest_HEAP ProfileRequest_Type = 0
)

var ProfileRequest_Type_name = map[int32]string{
	0: "HEAP",
}
var ProfileRequest_Type_value = map[string]int32{
	"HEAP": 0,
}

func (x ProfileRequest_Type) String() string {
	return proto.EnumName(ProfileRequest_Type_name, int32(x))
}
func (ProfileRequest_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorStatus, []int{33, 0} }

// Enum for phase of execution.
type ActiveQuery_Phase int32

const (
	ActiveQuery_PREPARING ActiveQuery_Phase = 0
	ActiveQuery_EXECUTING ActiveQuery_Phase = 1
)

var ActiveQuery_Phase_name = map[int32]string{
	0: "PREPARING",
	1: "EXECUTING",
}
var ActiveQuery_Phase_value = map[string]int32{
	"PREPARING": 0,
	"EXECUTING": 1,
}

func (x ActiveQuery_Phase) String() string {
	return proto.EnumName(ActiveQuery_Phase_name, int32(x))
}
func (ActiveQuery_Phase) EnumDescriptor() ([]byte, []int) { return fileDescriptorStatus, []int{40, 0} }

type CertificatesRequest struct {
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *CertificatesRequest) Reset()                    { *m = CertificatesRequest{} }
func (m *CertificatesRequest) String() string            { return proto.CompactTextString(m) }
func (*CertificatesRequest) ProtoMessage()               {}
func (*CertificatesRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{0} }

type CertificateDetails struct {
	Type CertificateDetails_CertificateType `protobuf:"varint,1,opt,name=type,proto3,enum=cockroach.server.serverpb.CertificateDetails_CertificateType" json:"type,omitempty"`
	// "error_message" and "data" are mutually exclusive.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// data is the raw file contents of the certificate. This means PEM-encoded
	// DER data.
	Data   []byte                      `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	Fields []CertificateDetails_Fields `protobuf:"bytes,4,rep,name=fields" json:"fields"`
}

func (m *CertificateDetails) Reset()                    { *m = CertificateDetails{} }
func (m *CertificateDetails) String() string            { return proto.CompactTextString(m) }
func (*CertificateDetails) ProtoMessage()               {}
func (*CertificateDetails) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{1} }

type CertificateDetails_Fields struct {
	Issuer             string   `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	Subject            string   `protobuf:"bytes,2,opt,name=subject,proto3" json:"subject,omitempty"`
	ValidFrom          int64    `protobuf:"varint,3,opt,name=valid_from,json=validFrom,proto3" json:"valid_from,omitempty"`
	ValidUntil         int64    `protobuf:"varint,4,opt,name=valid_until,json=validUntil,proto3" json:"valid_until,omitempty"`
	Addresses          []string `protobuf:"bytes,5,rep,name=addresses" json:"addresses,omitempty"`
	SignatureAlgorithm string   `protobuf:"bytes,6,opt,name=signature_algorithm,json=signatureAlgorithm,proto3" json:"signature_algorithm,omitempty"`
	PublicKey          string   `protobuf:"bytes,7,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	KeyUsage           []string `protobuf:"bytes,8,rep,name=key_usage,json=keyUsage" json:"key_usage,omitempty"`
	ExtendedKeyUsage   []string `protobuf:"bytes,9,rep,name=extended_key_usage,json=extendedKeyUsage" json:"extended_key_usage,omitempty"`
}

func (m *CertificateDetails_Fields) Reset()         { *m = CertificateDetails_Fields{} }
func (m *CertificateDetails_Fields) String() string { return proto.CompactTextString(m) }
func (*CertificateDetails_Fields) ProtoMessage()    {}
func (*CertificateDetails_Fields) Descriptor() ([]byte, []int) {
	return fileDescriptorStatus, []int{1, 0}
}

type CertificatesResponse struct {
	Certificates []CertificateDetails `protobuf:"bytes,1,rep,name=certificates" json:"certificates"`
}

func (m *CertificatesResponse) Reset()                    { *m = CertificatesResponse{} }
func (m *CertificatesResponse) String() string            { return proto.CompactTextString(m) }
func (*CertificatesResponse) ProtoMessage()               {}
func (*CertificatesResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{2} }

// DetailsRequest requests a nodes details.
type DetailsRequest struct {
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// ready specifies whether the client wants to know whether a node is ready to
	// receive traffic. If a node is unready, an error will be returned.
	Ready bool `protobuf:"varint,2,opt,name=ready,proto3" json:"ready,omitempty"`
}

func (m *DetailsRequest) Reset()                    { *m = DetailsRequest{} }
func (m *DetailsRequest) String() string            { return proto.CompactTextString(m) }
func (*DetailsRequest) ProtoMessage()               {}
func (*DetailsRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{3} }

type DetailsResponse struct {
	NodeID    github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	Address   cockroach_util.UnresolvedAddr                       `protobuf:"bytes,2,opt,name=address" json:"address"`
	BuildInfo cockroach_build.Info                                `protobuf:"bytes,3,opt,name=build_info,json=buildInfo" json:"build_info"`
}

func (m *DetailsResponse) Reset()                    { *m = DetailsResponse{} }
func (m *DetailsResponse) String() string            { return proto.CompactTextString(m) }
func (*DetailsResponse) ProtoMessage()               {}
func (*DetailsResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{4} }

type NodesRequest struct {
}

func (m *NodesRequest) Reset()                    { *m = NodesRequest{} }
func (m *NodesRequest) String() string            { return proto.CompactTextString(m) }
func (*NodesRequest) ProtoMessage()               {}
func (*NodesRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{5} }

type NodesResponse struct {
	Nodes []cockroach_server_status.NodeStatus `protobuf:"bytes,1,rep,name=nodes" json:"nodes"`
}

func (m *NodesResponse) Reset()                    { *m = NodesResponse{} }
func (m *NodesResponse) String() string            { return proto.CompactTextString(m) }
func (*NodesResponse) ProtoMessage()               {}
func (*NodesResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{6} }

type NodeRequest struct {
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *NodeRequest) Reset()                    { *m = NodeRequest{} }
func (m *NodeRequest) String() string            { return proto.CompactTextString(m) }
func (*NodeRequest) ProtoMessage()               {}
func (*NodeRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{7} }

// RaftState gives internal details about a Raft group's state.
// Closely mirrors the upstream definitions in github.com/etcd-io/etcd/raft.
type RaftState struct {
	ReplicaID uint64           `protobuf:"varint,1,opt,name=replica_id,json=replicaId,proto3" json:"replica_id,omitempty"`
	HardState raftpb.HardState `protobuf:"bytes,2,opt,name=hard_state,json=hardState" json:"hard_state"`
	// Lead is part of Raft's SoftState.
	Lead uint64 `protobuf:"varint,3,opt,name=lead,proto3" json:"lead,omitempty"`
	// State is part of Raft's SoftState.
	// It's not an enum because this is primarily for ui consumption and there
	// are issues associated with them.
	State          string                        `protobuf:"bytes,4,opt,name=state,proto3" json:"state,omitempty"`
	Applied        uint64                        `protobuf:"varint,5,opt,name=applied,proto3" json:"applied,omitempty"`
	Progress       map[uint64]RaftState_Progress `protobuf:"bytes,6,rep,name=progress" json:"progress" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	LeadTransferee uint64                        `protobuf:"varint,7,opt,name=lead_transferee,json=leadTransferee,proto3" json:"lead_transferee,omitempty"`
}

func (m *RaftState) Reset()                    { *m = RaftState{} }
func (m *RaftState) String() string            { return proto.CompactTextString(m) }
func (*RaftState) ProtoMessage()               {}
func (*RaftState) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{8} }

type RaftState_Progress struct {
	Match           uint64 `protobuf:"varint,1,opt,name=match,proto3" json:"match,omitempty"`
	Next            uint64 `protobuf:"varint,2,opt,name=next,proto3" json:"next,omitempty"`
	State           string `protobuf:"bytes,3,opt,name=state,proto3" json:"state,omitempty"`
	Paused          bool   `protobuf:"varint,4,opt,name=paused,proto3" json:"paused,omitempty"`
	PendingSnapshot uint64 `protobuf:"varint,5,opt,name=pending_snapshot,json=pendingSnapshot,proto3" json:"pending_snapshot,omitempty"`
}

func (m *RaftState_Progress) Reset()                    { *m = RaftState_Progress{} }
func (m *RaftState_Progress) String() string            { return proto.CompactTextString(m) }
func (*RaftState_Progress) ProtoMessage()               {}
func (*RaftState_Progress) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{8, 0} }

type RangeProblems struct {
	Unavailable          bool `protobuf:"varint,1,opt,name=unavailable,proto3" json:"unavailable,omitempty"`
	LeaderNotLeaseHolder bool `protobuf:"varint,2,opt,name=leader_not_lease_holder,json=leaderNotLeaseHolder,proto3" json:"leader_not_lease_holder,omitempty"`
	NoRaftLeader         bool `protobuf:"varint,3,opt,name=no_raft_leader,json=noRaftLeader,proto3" json:"no_raft_leader,omitempty"`
	Underreplicated      bool `protobuf:"varint,4,opt,name=underreplicated,proto3" json:"underreplicated,omitempty"`
	NoLease              bool `protobuf:"varint,5,opt,name=no_lease,json=noLease,proto3" json:"no_lease,omitempty"`
	// Quiescent ranges do not tick by definition, but we track this in
	// two different ways and suspect that they're getting out of sync.
	// If the replica's quiescent flag doesn't agree with the store's
	// list of replicas that are ticking, warn about it.
	QuiescentEqualsTicking bool `protobuf:"varint,6,opt,name=quiescent_equals_ticking,json=quiescentEqualsTicking,proto3" json:"quiescent_equals_ticking,omitempty"`
	// When the raft log is too large, it can be a symptom of other issues.
	RaftLogTooLarge bool `protobuf:"varint,7,opt,name=raft_log_too_large,json=raftLogTooLarge,proto3" json:"raft_log_too_large,omitempty"`
}

func (m *RangeProblems) Reset()                    { *m = RangeProblems{} }
func (m *RangeProblems) String() string            { return proto.CompactTextString(m) }
func (*RangeProblems) ProtoMessage()               {}
func (*RangeProblems) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{9} }

type RangeStatistics struct {
	// Note that queries per second will only be known by the leaseholder.
	// All other replicas will report it as 0.
	QueriesPerSecond float64 `protobuf:"fixed64,1,opt,name=queries_per_second,json=queriesPerSecond,proto3" json:"queries_per_second,omitempty"`
	WritesPerSecond  float64 `protobuf:"fixed64,2,opt,name=writes_per_second,json=writesPerSecond,proto3" json:"writes_per_second,omitempty"`
}

func (m *RangeStatistics) Reset()                    { *m = RangeStatistics{} }
func (m *RangeStatistics) String() string            { return proto.CompactTextString(m) }
func (*RangeStatistics) ProtoMessage()               {}
func (*RangeStatistics) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{10} }

type PrettySpan struct {
	StartKey string `protobuf:"bytes,1,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey   string `protobuf:"bytes,2,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
}

func (m *PrettySpan) Reset()                    { *m = PrettySpan{} }
func (m *PrettySpan) String() string            { return proto.CompactTextString(m) }
func (*PrettySpan) ProtoMessage()               {}
func (*PrettySpan) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{11} }

type CommandQueueMetrics struct {
	WriteCommands   int64 `protobuf:"varint,1,opt,name=write_commands,json=writeCommands,proto3" json:"write_commands,omitempty"`
	ReadCommands    int64 `protobuf:"varint,2,opt,name=read_commands,json=readCommands,proto3" json:"read_commands,omitempty"`
	MaxOverlapsSeen int64 `protobuf:"varint,3,opt,name=max_overlaps_seen,json=maxOverlapsSeen,proto3" json:"max_overlaps_seen,omitempty"`
	TreeSize        int32 `protobuf:"varint,4,opt,name=tree_size,json=treeSize,proto3" json:"tree_size,omitempty"`
}

func (m *CommandQueueMetrics) Reset()                    { *m = CommandQueueMetrics{} }
func (m *CommandQueueMetrics) String() string            { return proto.CompactTextString(m) }
func (*CommandQueueMetrics) ProtoMessage()               {}
func (*CommandQueueMetrics) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{12} }

type RangeInfo struct {
	Span          PrettySpan                                           `protobuf:"bytes,1,opt,name=span" json:"span"`
	RaftState     RaftState                                            `protobuf:"bytes,2,opt,name=raft_state,json=raftState" json:"raft_state"`
	State         cockroach_storage_storagebase.RangeInfo              `protobuf:"bytes,4,opt,name=state" json:"state"`
	SourceNodeID  github_com_cockroachdb_cockroach_pkg_roachpb.NodeID  `protobuf:"varint,5,opt,name=source_node_id,json=sourceNodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"source_node_id,omitempty"`
	SourceStoreID github_com_cockroachdb_cockroach_pkg_roachpb.StoreID `protobuf:"varint,6,opt,name=source_store_id,json=sourceStoreId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.StoreID" json:"source_store_id,omitempty"`
	ErrorMessage  string                                               `protobuf:"bytes,7,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	LeaseHistory  []cockroach_roachpb1.Lease                           `protobuf:"bytes,8,rep,name=lease_history,json=leaseHistory" json:"lease_history"`
	Problems      RangeProblems                                        `protobuf:"bytes,9,opt,name=problems" json:"problems"`
	Stats         RangeStatistics                                      `protobuf:"bytes,10,opt,name=stats" json:"stats"`
	CmdQLocal     CommandQueueMetrics                                  `protobuf:"bytes,11,opt,name=cmd_q_local,json=cmdQLocal" json:"cmd_q_local"`
	CmdQGlobal    CommandQueueMetrics                                  `protobuf:"bytes,12,opt,name=cmd_q_global,json=cmdQGlobal" json:"cmd_q_global"`
	LeaseStatus   cockroach_storage1.LeaseStatus                       `protobuf:"bytes,13,opt,name=lease_status,json=leaseStatus" json:"lease_status"`
	Quiescent     bool                                                 `protobuf:"varint,14,opt,name=quiescent,proto3" json:"quiescent,omitempty"`
	Ticking       bool                                                 `protobuf:"varint,15,opt,name=ticking,proto3" json:"ticking,omitempty"`
}

func (m *RangeInfo) Reset()                    { *m = RangeInfo{} }
func (m *RangeInfo) String() string            { return proto.CompactTextString(m) }
func (*RangeInfo) ProtoMessage()               {}
func (*RangeInfo) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{13} }

type RangesRequest struct {
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId   string                                                 `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	RangeIDs []github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,2,rep,packed,name=range_ids,json=rangeIds,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_ids,omitempty"`
}

func (m *RangesRequest) Reset()                    { *m = RangesRequest{} }
func (m *RangesRequest) String() string            { return proto.CompactTextString(m) }
func (*RangesRequest) ProtoMessage()               {}
func (*RangesRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{14} }

type RangesResponse struct {
	Ranges []RangeInfo `protobuf:"bytes,1,rep,name=ranges" json:"ranges"`
}

func (m *RangesResponse) Reset()                    { *m = RangesResponse{} }
func (m *RangesResponse) String() string            { return proto.CompactTextString(m) }
func (*RangesResponse) ProtoMessage()               {}
func (*RangesResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{15} }

type GossipRequest struct {
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *GossipRequest) Reset()                    { *m = GossipRequest{} }
func (m *GossipRequest) String() string            { return proto.CompactTextString(m) }
func (*GossipRequest) ProtoMessage()               {}
func (*GossipRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{16} }

type TraceEvent struct {
	Time    time.Time `protobuf:"bytes,1,opt,name=time,stdtime" json:"time"`
	Message string    `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *TraceEvent) Reset()                    { *m = TraceEvent{} }
func (m *TraceEvent) String() string            { return proto.CompactTextString(m) }
func (*TraceEvent) ProtoMessage()               {}
func (*TraceEvent) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{17} }

type AllocatorDryRun struct {
	RangeID github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,1,opt,name=range_id,json=rangeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_id,omitempty"`
	Events  []*TraceEvent                                        `protobuf:"bytes,2,rep,name=events" json:"events,omitempty"`
}

func (m *AllocatorDryRun) Reset()                    { *m = AllocatorDryRun{} }
func (m *AllocatorDryRun) String() string            { return proto.CompactTextString(m) }
func (*AllocatorDryRun) ProtoMessage()               {}
func (*AllocatorDryRun) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{18} }

type AllocatorRangeRequest struct {
	RangeId int64 `protobuf:"varint,1,opt,name=range_id,json=rangeId,proto3" json:"range_id,omitempty"`
}

func (m *AllocatorRangeRequest) Reset()                    { *m = AllocatorRangeRequest{} }
func (m *AllocatorRangeRequest) String() string            { return proto.CompactTextString(m) }
func (*AllocatorRangeRequest) ProtoMessage()               {}
func (*AllocatorRangeRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{19} }

type AllocatorRangeResponse struct {
	// The NodeID of the store whose dry run is returned. Only the leaseholder
	// for a given range will do an allocator dry run for it.
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	DryRun *AllocatorDryRun                                    `protobuf:"bytes,2,opt,name=dry_run,json=dryRun" json:"dry_run,omitempty"`
}

func (m *AllocatorRangeResponse) Reset()                    { *m = AllocatorRangeResponse{} }
func (m *AllocatorRangeResponse) String() string            { return proto.CompactTextString(m) }
func (*AllocatorRangeResponse) ProtoMessage()               {}
func (*AllocatorRangeResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{20} }

type AllocatorRequest struct {
	NodeId   string                                                 `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	RangeIDs []github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,2,rep,packed,name=range_ids,json=rangeIds,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_ids,omitempty"`
}

func (m *AllocatorRequest) Reset()                    { *m = AllocatorRequest{} }
func (m *AllocatorRequest) String() string            { return proto.CompactTextString(m) }
func (*AllocatorRequest) ProtoMessage()               {}
func (*AllocatorRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{21} }

type AllocatorResponse struct {
	DryRuns []*AllocatorDryRun `protobuf:"bytes,1,rep,name=dry_runs,json=dryRuns" json:"dry_runs,omitempty"`
}

func (m *AllocatorResponse) Reset()                    { *m = AllocatorResponse{} }
func (m *AllocatorResponse) String() string            { return proto.CompactTextString(m) }
func (*AllocatorResponse) ProtoMessage()               {}
func (*AllocatorResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{22} }

type JSONResponse struct {
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *JSONResponse) Reset()                    { *m = JSONResponse{} }
func (m *JSONResponse) String() string            { return proto.CompactTextString(m) }
func (*JSONResponse) ProtoMessage()               {}
func (*JSONResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{23} }

type LogsRequest struct {
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId    string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	Level     string `protobuf:"bytes,2,opt,name=level,proto3" json:"level,omitempty"`
	StartTime string `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	EndTime   string `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	Max       string `protobuf:"bytes,5,opt,name=max,proto3" json:"max,omitempty"`
	Pattern   string `protobuf:"bytes,6,opt,name=pattern,proto3" json:"pattern,omitempty"`
}

func (m *LogsRequest) Reset()                    { *m = LogsRequest{} }
func (m *LogsRequest) String() string            { return proto.CompactTextString(m) }
func (*LogsRequest) ProtoMessage()               {}
func (*LogsRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{24} }

type LogEntriesResponse struct {
	Entries []cockroach_util_log.Entry `protobuf:"bytes,1,rep,name=entries" json:"entries"`
}

func (m *LogEntriesResponse) Reset()                    { *m = LogEntriesResponse{} }
func (m *LogEntriesResponse) String() string            { return proto.CompactTextString(m) }
func (*LogEntriesResponse) ProtoMessage()               {}
func (*LogEntriesResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{25} }

type LogFilesListRequest struct {
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *LogFilesListRequest) Reset()                    { *m = LogFilesListRequest{} }
func (m *LogFilesListRequest) String() string            { return proto.CompactTextString(m) }
func (*LogFilesListRequest) ProtoMessage()               {}
func (*LogFilesListRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{26} }

type LogFilesListResponse struct {
	Files []cockroach_util_log.FileInfo `protobuf:"bytes,1,rep,name=files" json:"files"`
}

func (m *LogFilesListResponse) Reset()                    { *m = LogFilesListResponse{} }
func (m *LogFilesListResponse) String() string            { return proto.CompactTextString(m) }
func (*LogFilesListResponse) ProtoMessage()               {}
func (*LogFilesListResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{27} }

type LogFileRequest struct {
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	File   string `protobuf:"bytes,2,opt,name=file,proto3" json:"file,omitempty"`
}

func (m *LogFileRequest) Reset()                    { *m = LogFileRequest{} }
func (m *LogFileRequest) String() string            { return proto.CompactTextString(m) }
func (*LogFileRequest) ProtoMessage()               {}
func (*LogFileRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{28} }

type StacksRequest struct {
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *StacksRequest) Reset()                    { *m = StacksRequest{} }
func (m *StacksRequest) String() string            { return proto.CompactTextString(m) }
func (*StacksRequest) ProtoMessage()               {}
func (*StacksRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{29} }

type File struct {
	Name     string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	FileSize int64  `protobuf:"varint,2,opt,name=file_size,json=fileSize,proto3" json:"file_size,omitempty"`
	// Contents may not be populated if only a list of Files are requested.
	Contents []byte `protobuf:"bytes,3,opt,name=contents,proto3" json:"contents,omitempty"`
}

func (m *File) Reset()                    { *m = File{} }
func (m *File) String() string            { return proto.CompactTextString(m) }
func (*File) ProtoMessage()               {}
func (*File) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{30} }

type GetFilesRequest struct {
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// If list_only is true then the contents of the files will not be populated
	// in the response. Only filenames and sizes will be returned.
	ListOnly bool     `protobuf:"varint,2,opt,name=list_only,json=listOnly,proto3" json:"list_only,omitempty"`
	Type     FileType `protobuf:"varint,5,opt,name=type,proto3,enum=cockroach.server.serverpb.FileType" json:"type,omitempty"`
	// Each pattern given is matched with Files of the above type in the node
	// using filepath.Glob(). The patterns only match to filenames and so path
	// separators cannot be used.
	// Example: * will match all files of requested type.
	Patterns []string `protobuf:"bytes,6,rep,name=patterns" json:"patterns,omitempty"`
}

func (m *GetFilesRequest) Reset()                    { *m = GetFilesRequest{} }
func (m *GetFilesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetFilesRequest) ProtoMessage()               {}
func (*GetFilesRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{31} }

type GetFilesResponse struct {
	Files []*File `protobuf:"bytes,1,rep,name=files" json:"files,omitempty"`
}

func (m *GetFilesResponse) Reset()                    { *m = GetFilesResponse{} }
func (m *GetFilesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetFilesResponse) ProtoMessage()               {}
func (*GetFilesResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{32} }

type ProfileRequest struct {
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// The type of profile to retrieve.
	Type ProfileRequest_Type `protobuf:"varint,5,opt,name=type,proto3,enum=cockroach.server.serverpb.ProfileRequest_Type" json:"type,omitempty"`
}

func (m *ProfileRequest) Reset()                    { *m = ProfileRequest{} }
func (m *ProfileRequest) String() string            { return proto.CompactTextString(m) }
func (*ProfileRequest) ProtoMessage()               {}
func (*ProfileRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{33} }

type MetricsRequest struct {
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *MetricsRequest) Reset()                    { *m = MetricsRequest{} }
func (m *MetricsRequest) String() string            { return proto.CompactTextString(m) }
func (*MetricsRequest) ProtoMessage()               {}
func (*MetricsRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{34} }

type RaftRangeNode struct {
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	Range  RangeInfo                                           `protobuf:"bytes,2,opt,name=range" json:"range"`
}

func (m *RaftRangeNode) Reset()                    { *m = RaftRangeNode{} }
func (m *RaftRangeNode) String() string            { return proto.CompactTextString(m) }
func (*RaftRangeNode) ProtoMessage()               {}
func (*RaftRangeNode) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{35} }

type RaftRangeError struct {
	Message string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *RaftRangeError) Reset()                    { *m = RaftRangeError{} }
func (m *RaftRangeError) String() string            { return proto.CompactTextString(m) }
func (*RaftRangeError) ProtoMessage()               {}
func (*RaftRangeError) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{36} }

type RaftRangeStatus struct {
	RangeID github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,1,opt,name=range_id,json=rangeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_id,omitempty"`
	Errors  []RaftRangeError                                     `protobuf:"bytes,2,rep,name=errors" json:"errors"`
	Nodes   []RaftRangeNode                                      `protobuf:"bytes,3,rep,name=nodes" json:"nodes"`
}

func (m *RaftRangeStatus) Reset()                    { *m = RaftRangeStatus{} }
func (m *RaftRangeStatus) String() string            { return proto.CompactTextString(m) }
func (*RaftRangeStatus) ProtoMessage()               {}
func (*RaftRangeStatus) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{37} }

type RaftDebugRequest struct {
	RangeIDs []github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,1,rep,packed,name=range_ids,json=rangeIds,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_ids,omitempty"`
}

func (m *RaftDebugRequest) Reset()                    { *m = RaftDebugRequest{} }
func (m *RaftDebugRequest) String() string            { return proto.CompactTextString(m) }
func (*RaftDebugRequest) ProtoMessage()               {}
func (*RaftDebugRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{38} }

type RaftDebugResponse struct {
	Ranges map[github_com_cockroachdb_cockroach_pkg_roachpb.RangeID]RaftRangeStatus `protobuf:"bytes,1,rep,name=ranges,castkey=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"ranges" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	Errors []RaftRangeError                                                         `protobuf:"bytes,2,rep,name=errors" json:"errors"`
}

func (m *RaftDebugResponse) Reset()                    { *m = RaftDebugResponse{} }
func (m *RaftDebugResponse) String() string            { return proto.CompactTextString(m) }
func (*RaftDebugResponse) ProtoMessage()               {}
func (*RaftDebugResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{39} }

// ActiveQuery represents a query in flight on some Session.
type ActiveQuery struct {
	// ID of the query (uint128 presented as a hexadecimal string).
	ID string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// SQL query string specified by the user.
	Sql string `protobuf:"bytes,2,opt,name=sql,proto3" json:"sql,omitempty"`
	// Start timestamp of this query.
	Start time.Time `protobuf:"bytes,3,opt,name=start,stdtime" json:"start"`
	// True if this query is distributed.
	IsDistributed bool `protobuf:"varint,4,opt,name=is_distributed,json=isDistributed,proto3" json:"is_distributed,omitempty"`
	// phase stores the current phase of execution for this query.
	Phase ActiveQuery_Phase `protobuf:"varint,5,opt,name=phase,proto3,enum=cockroach.server.serverpb.ActiveQuery_Phase" json:"phase,omitempty"`
}

func (m *ActiveQuery) Reset()                    { *m = ActiveQuery{} }
func (m *ActiveQuery) String() string            { return proto.CompactTextString(m) }
func (*ActiveQuery) ProtoMessage()               {}
func (*ActiveQuery) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{40} }

// Request object for ListSessions and ListLocalSessions.
type ListSessionsRequest struct {
	// Username of the user making this request.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
}

func (m *ListSessionsRequest) Reset()                    { *m = ListSessionsRequest{} }
func (m *ListSessionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListSessionsRequest) ProtoMessage()               {}
func (*ListSessionsRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{41} }

// Session represents one SQL session.
type Session struct {
	// ID of node where this session exists.
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	// Username of the user for this session.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	// Connected client's IP address and port.
	ClientAddress string `protobuf:"bytes,3,opt,name=client_address,json=clientAddress,proto3" json:"client_address,omitempty"`
	// Application name specified by the client.
	ApplicationName string `protobuf:"bytes,4,opt,name=application_name,json=applicationName,proto3" json:"application_name,omitempty"`
	// Queries in progress on this session.
	ActiveQueries []ActiveQuery `protobuf:"bytes,5,rep,name=active_queries,json=activeQueries" json:"active_queries"`
	// Timestamp of session's start.
	Start time.Time `protobuf:"bytes,6,opt,name=start,stdtime" json:"start"`
	// ID of the current KV transaction for this session. Nil if the session
	// doesn't currently have a transaction.
	KvTxnID *github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,7,opt,name=kv_txn_id,json=kvTxnId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"kv_txn_id,omitempty"`
	// SQL string of the last query executed on this session.
	LastActiveQuery string `protobuf:"bytes,8,opt,name=last_active_query,json=lastActiveQuery,proto3" json:"last_active_query,omitempty"`
	// ID of the session (uint128 represented as raw bytes).
	ID []byte `protobuf:"bytes,9,opt,name=id,proto3" json:"id,omitempty"`
	// Number of currently allocated bytes in the session memory monitor.
	AllocBytes int64 `protobuf:"varint,10,opt,name=alloc_bytes,json=allocBytes,proto3" json:"alloc_bytes,omitempty"`
	// High water mark of allocated bytes in the session memory monitor.
	MaxAllocBytes int64 `protobuf:"varint,11,opt,name=max_alloc_bytes,json=maxAllocBytes,proto3" json:"max_alloc_bytes,omitempty"`
}

func (m *Session) Reset()                    { *m = Session{} }
func (m *Session) String() string            { return proto.CompactTextString(m) }
func (*Session) ProtoMessage()               {}
func (*Session) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{42} }

// An error wrapper object for ListSessionsResponse.
type ListSessionsError struct {
	// ID of node that was being contacted when this error occurred
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	// Error message.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *ListSessionsError) Reset()                    { *m = ListSessionsError{} }
func (m *ListSessionsError) String() string            { return proto.CompactTextString(m) }
func (*ListSessionsError) ProtoMessage()               {}
func (*ListSessionsError) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{43} }

// Response object for ListSessions and ListLocalSessions.
type ListSessionsResponse struct {
	// A list of sessions on this node or cluster.
	Sessions []Session `protobuf:"bytes,1,rep,name=sessions" json:"sessions"`
	// Any errors that occurred during fan-out calls to other nodes.
	Errors []ListSessionsError `protobuf:"bytes,2,rep,name=errors" json:"errors"`
}

func (m *ListSessionsResponse) Reset()                    { *m = ListSessionsResponse{} }
func (m *ListSessionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListSessionsResponse) ProtoMessage()               {}
func (*ListSessionsResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{44} }

// Request object for issing a query cancel request.
type CancelQueryRequest struct {
	// ID of gateway node for the query to be canceled.
	//
	// TODO(itsbilal): use [(gogoproto.customname) = "NodeID"] below. Need to
	// figure out how to teach grpc-gateway about custom names.
	//
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// ID of query to be canceled (converted to string).
	QueryID string `protobuf:"bytes,2,opt,name=query_id,json=queryId,proto3" json:"query_id,omitempty"`
	// Username of the user making this cancellation request.
	Username string `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
}

func (m *CancelQueryRequest) Reset()                    { *m = CancelQueryRequest{} }
func (m *CancelQueryRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelQueryRequest) ProtoMessage()               {}
func (*CancelQueryRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{45} }

// Response returned by target query's gateway node.
type CancelQueryResponse struct {
	// Whether the cancellation request succeeded and the query was canceled.
	Canceled bool `protobuf:"varint,1,opt,name=canceled,proto3" json:"canceled,omitempty"`
	// Error message (accompanied with canceled = false).
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (m *CancelQueryResponse) Reset()                    { *m = CancelQueryResponse{} }
func (m *CancelQueryResponse) String() string            { return proto.CompactTextString(m) }
func (*CancelQueryResponse) ProtoMessage()               {}
func (*CancelQueryResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{46} }

type CancelSessionRequest struct {
	// TODO(abhimadan): use [(gogoproto.customname) = "NodeID"] below. Need to
	// figure out how to teach grpc-gateway about custom names.
	//
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId    string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	SessionID []byte `protobuf:"bytes,2,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	Username  string `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
}

func (m *CancelSessionRequest) Reset()                    { *m = CancelSessionRequest{} }
func (m *CancelSessionRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelSessionRequest) ProtoMessage()               {}
func (*CancelSessionRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{47} }

type CancelSessionResponse struct {
	Canceled bool   `protobuf:"varint,1,opt,name=canceled,proto3" json:"canceled,omitempty"`
	Error    string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (m *CancelSessionResponse) Reset()                    { *m = CancelSessionResponse{} }
func (m *CancelSessionResponse) String() string            { return proto.CompactTextString(m) }
func (*CancelSessionResponse) ProtoMessage()               {}
func (*CancelSessionResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{48} }

type SpanStatsRequest struct {
	NodeID   string                                            `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	StartKey github_com_cockroachdb_cockroach_pkg_roachpb.RKey `protobuf:"bytes,2,opt,name=start_key,json=startKey,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RKey" json:"start_key,omitempty"`
	EndKey   github_com_cockroachdb_cockroach_pkg_roachpb.RKey `protobuf:"bytes,3,opt,name=end_key,json=endKey,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RKey" json:"end_key,omitempty"`
}

func (m *SpanStatsRequest) Reset()                    { *m = SpanStatsRequest{} }
func (m *SpanStatsRequest) String() string            { return proto.CompactTextString(m) }
func (*SpanStatsRequest) ProtoMessage()               {}
func (*SpanStatsRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{49} }

type SpanStatsResponse struct {
	RangeCount           int32                                        `protobuf:"varint,2,opt,name=range_count,json=rangeCount,proto3" json:"range_count,omitempty"`
	ApproximateDiskBytes uint64                                       `protobuf:"varint,3,opt,name=approximate_disk_bytes,json=approximateDiskBytes,proto3" json:"approximate_disk_bytes,omitempty"`
	TotalStats           cockroach_storage_engine_enginepb1.MVCCStats `protobuf:"bytes,1,opt,name=total_stats,json=totalStats" json:"total_stats"`
}

func (m *SpanStatsResponse) Reset()                    { *m = SpanStatsResponse{} }
func (m *SpanStatsResponse) String() string            { return proto.CompactTextString(m) }
func (*SpanStatsResponse) ProtoMessage()               {}
func (*SpanStatsResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{50} }

type ProblemRangesRequest struct {
	NodeID string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *ProblemRangesRequest) Reset()                    { *m = ProblemRangesRequest{} }
func (m *ProblemRangesRequest) String() string            { return proto.CompactTextString(m) }
func (*ProblemRangesRequest) ProtoMessage()               {}
func (*ProblemRangesRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{51} }

type ProblemRangesResponse struct {
	// NodeID is the node that submitted all the requests.
	NodeID           github_com_cockroachdb_cockroach_pkg_roachpb.NodeID                                        `protobuf:"varint,8,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	ProblemsByNodeID map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]ProblemRangesResponse_NodeProblems `protobuf:"bytes,9,rep,name=problems_by_node_id,json=problemsByNodeId,castkey=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"problems_by_node_id" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ProblemRangesResponse) Reset()                    { *m = ProblemRangesResponse{} }
func (m *ProblemRangesResponse) String() string            { return proto.CompactTextString(m) }
func (*ProblemRangesResponse) ProtoMessage()               {}
func (*ProblemRangesResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{52} }

type ProblemRangesResponse_NodeProblems struct {
	ErrorMessage                     string                                                 `protobuf:"bytes,1,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	UnavailableRangeIDs              []github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,2,rep,packed,name=unavailable_range_ids,json=unavailableRangeIds,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"unavailable_range_ids,omitempty"`
	RaftLeaderNotLeaseHolderRangeIDs []github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,3,rep,packed,name=raft_leader_not_lease_holder_range_ids,json=raftLeaderNotLeaseHolderRangeIds,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"raft_leader_not_lease_holder_range_ids,omitempty"`
	NoRaftLeaderRangeIDs             []github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,4,rep,packed,name=no_raft_leader_range_ids,json=noRaftLeaderRangeIds,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"no_raft_leader_range_ids,omitempty"`
	NoLeaseRangeIDs                  []github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,5,rep,packed,name=no_lease_range_ids,json=noLeaseRangeIds,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"no_lease_range_ids,omitempty"`
	UnderreplicatedRangeIDs          []github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,6,rep,packed,name=underreplicated_range_ids,json=underreplicatedRangeIds,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"underreplicated_range_ids,omitempty"`
	QuiescentEqualsTickingRangeIDs   []github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,7,rep,packed,name=quiescent_equals_ticking_range_ids,json=quiescentEqualsTickingRangeIds,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"quiescent_equals_ticking_range_ids,omitempty"`
	RaftLogTooLargeRangeIDs          []github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,8,rep,packed,name=raft_log_too_large_range_ids,json=raftLogTooLargeRangeIds,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"raft_log_too_large_range_ids,omitempty"`
}

func (m *ProblemRangesResponse_NodeProblems) Reset()         { *m = ProblemRangesResponse_NodeProblems{} }
func (m *ProblemRangesResponse_NodeProblems) String() string { return proto.CompactTextString(m) }
func (*ProblemRangesResponse_NodeProblems) ProtoMessage()    {}
func (*ProblemRangesResponse_NodeProblems) Descriptor() ([]byte, []int) {
	return fileDescriptorStatus, []int{52, 0}
}

type RangeRequest struct {
	RangeId int64 `protobuf:"varint,1,opt,name=range_id,json=rangeId,proto3" json:"range_id,omitempty"`
}

func (m *RangeRequest) Reset()                    { *m = RangeRequest{} }
func (m *RangeRequest) String() string            { return proto.CompactTextString(m) }
func (*RangeRequest) ProtoMessage()               {}
func (*RangeRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{53} }

type RangeResponse struct {
	// NodeID is the node that submitted all the requests.
	NodeID            github_com_cockroachdb_cockroach_pkg_roachpb.NodeID                                `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	RangeID           github_com_cockroachdb_cockroach_pkg_roachpb.RangeID                               `protobuf:"varint,2,opt,name=range_id,json=rangeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_id,omitempty"`
	ResponsesByNodeID map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]RangeResponse_NodeResponse `protobuf:"bytes,3,rep,name=responses_by_node_id,json=responsesByNodeId,castkey=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"responses_by_node_id" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *RangeResponse) Reset()                    { *m = RangeResponse{} }
func (m *RangeResponse) String() string            { return proto.CompactTextString(m) }
func (*RangeResponse) ProtoMessage()               {}
func (*RangeResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{54} }

type RangeResponse_NodeResponse struct {
	Response     bool        `protobuf:"varint,1,opt,name=response,proto3" json:"response,omitempty"`
	ErrorMessage string      `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	Infos        []RangeInfo `protobuf:"bytes,3,rep,name=infos" json:"infos"`
}

func (m *RangeResponse_NodeResponse) Reset()         { *m = RangeResponse_NodeResponse{} }
func (m *RangeResponse_NodeResponse) String() string { return proto.CompactTextString(m) }
func (*RangeResponse_NodeResponse) ProtoMessage()    {}
func (*RangeResponse_NodeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptorStatus, []int{54, 0}
}

type CommandQueueRequest struct {
	RangeId int64 `protobuf:"varint,1,opt,name=range_id,json=rangeId,proto3" json:"range_id,omitempty"`
}

func (m *CommandQueueRequest) Reset()                    { *m = CommandQueueRequest{} }
func (m *CommandQueueRequest) String() string            { return proto.CompactTextString(m) }
func (*CommandQueueRequest) ProtoMessage()               {}
func (*CommandQueueRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{55} }

type CommandQueueResponse struct {
	Snapshot cockroach_storage_storagebase.CommandQueuesSnapshot `protobuf:"bytes,1,opt,name=snapshot" json:"snapshot"`
}

func (m *CommandQueueResponse) Reset()                    { *m = CommandQueueResponse{} }
func (m *CommandQueueResponse) String() string            { return proto.CompactTextString(m) }
func (*CommandQueueResponse) ProtoMessage()               {}
func (*CommandQueueResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{56} }

// DiagnosticsRequest requests a diagnostics report.
type DiagnosticsRequest struct {
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *DiagnosticsRequest) Reset()                    { *m = DiagnosticsRequest{} }
func (m *DiagnosticsRequest) String() string            { return proto.CompactTextString(m) }
func (*DiagnosticsRequest) ProtoMessage()               {}
func (*DiagnosticsRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{57} }

type StoresRequest struct {
	// node_id is a string so that "local" can be used to specify that no
	// forwarding is necessary.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *StoresRequest) Reset()                    { *m = StoresRequest{} }
func (m *StoresRequest) String() string            { return proto.CompactTextString(m) }
func (*StoresRequest) ProtoMessage()               {}
func (*StoresRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{58} }

type StoreDetails struct {
	StoreID github_com_cockroachdb_cockroach_pkg_roachpb.StoreID `protobuf:"varint,1,opt,name=store_id,json=storeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.StoreID" json:"store_id,omitempty"`
	// encryption_status is a serialized
	// ccl/storageccl/engineccl/enginepbccl/stats.go::EncryptionStatus protobuf.
	EncryptionStatus []byte `protobuf:"bytes,2,opt,name=encryption_status,json=encryptionStatus,proto3" json:"encryption_status,omitempty"`
	// Basic file stats when encryption is enabled.
	// Total files/bytes.
	TotalFiles uint64 `protobuf:"varint,3,opt,name=total_files,json=totalFiles,proto3" json:"total_files,omitempty"`
	TotalBytes uint64 `protobuf:"varint,4,opt,name=total_bytes,json=totalBytes,proto3" json:"total_bytes,omitempty"`
	// Files/bytes using the active data key.
	ActiveKeyFiles uint64 `protobuf:"varint,5,opt,name=active_key_files,json=activeKeyFiles,proto3" json:"active_key_files,omitempty"`
	ActiveKeyBytes uint64 `protobuf:"varint,6,opt,name=active_key_bytes,json=activeKeyBytes,proto3" json:"active_key_bytes,omitempty"`
}

func (m *StoreDetails) Reset()                    { *m = StoreDetails{} }
func (m *StoreDetails) String() string            { return proto.CompactTextString(m) }
func (*StoreDetails) ProtoMessage()               {}
func (*StoreDetails) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{59} }

type StoresResponse struct {
	Stores []StoreDetails `protobuf:"bytes,1,rep,name=stores" json:"stores"`
}

func (m *StoresResponse) Reset()                    { *m = StoresResponse{} }
func (m *StoresResponse) String() string            { return proto.CompactTextString(m) }
func (*StoresResponse) ProtoMessage()               {}
func (*StoresResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{60} }

type StatementsRequest struct {
	NodeID string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *StatementsRequest) Reset()                    { *m = StatementsRequest{} }
func (m *StatementsRequest) String() string            { return proto.CompactTextString(m) }
func (*StatementsRequest) ProtoMessage()               {}
func (*StatementsRequest) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{61} }

type StatementsResponse struct {
	Statements []StatementsResponse_CollectedStatementStatistics `protobuf:"bytes,1,rep,name=statements" json:"statements"`
	// Timestamp of the last stats reset.
	LastReset time.Time `protobuf:"bytes,3,opt,name=last_reset,json=lastReset,stdtime" json:"last_reset"`
}

func (m *StatementsResponse) Reset()                    { *m = StatementsResponse{} }
func (m *StatementsResponse) String() string            { return proto.CompactTextString(m) }
func (*StatementsResponse) ProtoMessage()               {}
func (*StatementsResponse) Descriptor() ([]byte, []int) { return fileDescriptorStatus, []int{62} }

type StatementsResponse_ExtendedStatementStatisticsKey struct {
	KeyData cockroach_sql.StatementStatisticsKey                `protobuf:"bytes,1,opt,name=key_data,json=keyData" json:"key_data"`
	NodeID  github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,2,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
}

func (m *StatementsResponse_ExtendedStatementStatisticsKey) Reset() {
	*m = StatementsResponse_ExtendedStatementStatisticsKey{}
}
func (m *StatementsResponse_ExtendedStatementStatisticsKey) String() string {
	return proto.CompactTextString(m)
}
func (*StatementsResponse_ExtendedStatementStatisticsKey) ProtoMessage() {}
func (*StatementsResponse_ExtendedStatementStatisticsKey) Descriptor() ([]byte, []int) {
	return fileDescriptorStatus, []int{62, 0}
}

type StatementsResponse_CollectedStatementStatistics struct {
	Key   StatementsResponse_ExtendedStatementStatisticsKey `protobuf:"bytes,1,opt,name=key" json:"key"`
	Stats cockroach_sql.StatementStatistics                 `protobuf:"bytes,2,opt,name=stats" json:"stats"`
}

func (m *StatementsResponse_CollectedStatementStatistics) Reset() {
	*m = StatementsResponse_CollectedStatementStatistics{}
}
func (m *StatementsResponse_CollectedStatementStatistics) String() string {
	return proto.CompactTextString(m)
}
func (*StatementsResponse_CollectedStatementStatistics) ProtoMessage() {}
func (*StatementsResponse_CollectedStatementStatistics) Descriptor() ([]byte, []int) {
	return fileDescriptorStatus, []int{62, 1}
}

func init() {
	proto.RegisterType((*CertificatesRequest)(nil), "cockroach.server.serverpb.CertificatesRequest")
	proto.RegisterType((*CertificateDetails)(nil), "cockroach.server.serverpb.CertificateDetails")
	proto.RegisterType((*CertificateDetails_Fields)(nil), "cockroach.server.serverpb.CertificateDetails.Fields")
	proto.RegisterType((*CertificatesResponse)(nil), "cockroach.server.serverpb.CertificatesResponse")
	proto.RegisterType((*DetailsRequest)(nil), "cockroach.server.serverpb.DetailsRequest")
	proto.RegisterType((*DetailsResponse)(nil), "cockroach.server.serverpb.DetailsResponse")
	proto.RegisterType((*NodesRequest)(nil), "cockroach.server.serverpb.NodesRequest")
	proto.RegisterType((*NodesResponse)(nil), "cockroach.server.serverpb.NodesResponse")
	proto.RegisterType((*NodeRequest)(nil), "cockroach.server.serverpb.NodeRequest")
	proto.RegisterType((*RaftState)(nil), "cockroach.server.serverpb.RaftState")
	proto.RegisterType((*RaftState_Progress)(nil), "cockroach.server.serverpb.RaftState.Progress")
	proto.RegisterType((*RangeProblems)(nil), "cockroach.server.serverpb.RangeProblems")
	proto.RegisterType((*RangeStatistics)(nil), "cockroach.server.serverpb.RangeStatistics")
	proto.RegisterType((*PrettySpan)(nil), "cockroach.server.serverpb.PrettySpan")
	proto.RegisterType((*CommandQueueMetrics)(nil), "cockroach.server.serverpb.CommandQueueMetrics")
	proto.RegisterType((*RangeInfo)(nil), "cockroach.server.serverpb.RangeInfo")
	proto.RegisterType((*RangesRequest)(nil), "cockroach.server.serverpb.RangesRequest")
	proto.RegisterType((*RangesResponse)(nil), "cockroach.server.serverpb.RangesResponse")
	proto.RegisterType((*GossipRequest)(nil), "cockroach.server.serverpb.GossipRequest")
	proto.RegisterType((*TraceEvent)(nil), "cockroach.server.serverpb.TraceEvent")
	proto.RegisterType((*AllocatorDryRun)(nil), "cockroach.server.serverpb.AllocatorDryRun")
	proto.RegisterType((*AllocatorRangeRequest)(nil), "cockroach.server.serverpb.AllocatorRangeRequest")
	proto.RegisterType((*AllocatorRangeResponse)(nil), "cockroach.server.serverpb.AllocatorRangeResponse")
	proto.RegisterType((*AllocatorRequest)(nil), "cockroach.server.serverpb.AllocatorRequest")
	proto.RegisterType((*AllocatorResponse)(nil), "cockroach.server.serverpb.AllocatorResponse")
	proto.RegisterType((*JSONResponse)(nil), "cockroach.server.serverpb.JSONResponse")
	proto.RegisterType((*LogsRequest)(nil), "cockroach.server.serverpb.LogsRequest")
	proto.RegisterType((*LogEntriesResponse)(nil), "cockroach.server.serverpb.LogEntriesResponse")
	proto.RegisterType((*LogFilesListRequest)(nil), "cockroach.server.serverpb.LogFilesListRequest")
	proto.RegisterType((*LogFilesListResponse)(nil), "cockroach.server.serverpb.LogFilesListResponse")
	proto.RegisterType((*LogFileRequest)(nil), "cockroach.server.serverpb.LogFileRequest")
	proto.RegisterType((*StacksRequest)(nil), "cockroach.server.serverpb.StacksRequest")
	proto.RegisterType((*File)(nil), "cockroach.server.serverpb.File")
	proto.RegisterType((*GetFilesRequest)(nil), "cockroach.server.serverpb.GetFilesRequest")
	proto.RegisterType((*GetFilesResponse)(nil), "cockroach.server.serverpb.GetFilesResponse")
	proto.RegisterType((*ProfileRequest)(nil), "cockroach.server.serverpb.ProfileRequest")
	proto.RegisterType((*MetricsRequest)(nil), "cockroach.server.serverpb.MetricsRequest")
	proto.RegisterType((*RaftRangeNode)(nil), "cockroach.server.serverpb.RaftRangeNode")
	proto.RegisterType((*RaftRangeError)(nil), "cockroach.server.serverpb.RaftRangeError")
	proto.RegisterType((*RaftRangeStatus)(nil), "cockroach.server.serverpb.RaftRangeStatus")
	proto.RegisterType((*RaftDebugRequest)(nil), "cockroach.server.serverpb.RaftDebugRequest")
	proto.RegisterType((*RaftDebugResponse)(nil), "cockroach.server.serverpb.RaftDebugResponse")
	proto.RegisterType((*ActiveQuery)(nil), "cockroach.server.serverpb.ActiveQuery")
	proto.RegisterType((*ListSessionsRequest)(nil), "cockroach.server.serverpb.ListSessionsRequest")
	proto.RegisterType((*Session)(nil), "cockroach.server.serverpb.Session")
	proto.RegisterType((*ListSessionsError)(nil), "cockroach.server.serverpb.ListSessionsError")
	proto.RegisterType((*ListSessionsResponse)(nil), "cockroach.server.serverpb.ListSessionsResponse")
	proto.RegisterType((*CancelQueryRequest)(nil), "cockroach.server.serverpb.CancelQueryRequest")
	proto.RegisterType((*CancelQueryResponse)(nil), "cockroach.server.serverpb.CancelQueryResponse")
	proto.RegisterType((*CancelSessionRequest)(nil), "cockroach.server.serverpb.CancelSessionRequest")
	proto.RegisterType((*CancelSessionResponse)(nil), "cockroach.server.serverpb.CancelSessionResponse")
	proto.RegisterType((*SpanStatsRequest)(nil), "cockroach.server.serverpb.SpanStatsRequest")
	proto.RegisterType((*SpanStatsResponse)(nil), "cockroach.server.serverpb.SpanStatsResponse")
	proto.RegisterType((*ProblemRangesRequest)(nil), "cockroach.server.serverpb.ProblemRangesRequest")
	proto.RegisterType((*ProblemRangesResponse)(nil), "cockroach.server.serverpb.ProblemRangesResponse")
	proto.RegisterType((*ProblemRangesResponse_NodeProblems)(nil), "cockroach.server.serverpb.ProblemRangesResponse.NodeProblems")
	proto.RegisterType((*RangeRequest)(nil), "cockroach.server.serverpb.RangeRequest")
	proto.RegisterType((*RangeResponse)(nil), "cockroach.server.serverpb.RangeResponse")
	proto.RegisterType((*RangeResponse_NodeResponse)(nil), "cockroach.server.serverpb.RangeResponse.NodeResponse")
	proto.RegisterType((*CommandQueueRequest)(nil), "cockroach.server.serverpb.CommandQueueRequest")
	proto.RegisterType((*CommandQueueResponse)(nil), "cockroach.server.serverpb.CommandQueueResponse")
	proto.RegisterType((*DiagnosticsRequest)(nil), "cockroach.server.serverpb.DiagnosticsRequest")
	proto.RegisterType((*StoresRequest)(nil), "cockroach.server.serverpb.StoresRequest")
	proto.RegisterType((*StoreDetails)(nil), "cockroach.server.serverpb.StoreDetails")
	proto.RegisterType((*StoresResponse)(nil), "cockroach.server.serverpb.StoresResponse")
	proto.RegisterType((*StatementsRequest)(nil), "cockroach.server.serverpb.StatementsRequest")
	proto.RegisterType((*StatementsResponse)(nil), "cockroach.server.serverpb.StatementsResponse")
	proto.RegisterType((*StatementsResponse_ExtendedStatementStatisticsKey)(nil), "cockroach.server.serverpb.StatementsResponse.ExtendedStatementStatisticsKey")
	proto.RegisterType((*StatementsResponse_CollectedStatementStatistics)(nil), "cockroach.server.serverpb.StatementsResponse.CollectedStatementStatistics")
	proto.RegisterEnum("cockroach.server.serverpb.FileType", FileType_name, FileType_value)
	proto.RegisterEnum("cockroach.server.serverpb.CertificateDetails_CertificateType", CertificateDetails_CertificateType_name, CertificateDetails_CertificateType_value)
	proto.RegisterEnum("cockroach.server.serverpb.ProfileRequest_Type", ProfileRequest_Type_name, ProfileRequest_Type_value)
	proto.RegisterEnum("cockroach.server.serverpb.ActiveQuery_Phase", ActiveQuery_Phase_name, ActiveQuery_Phase_value)
}
func (this *PrettySpan) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PrettySpan)
	if !ok {
		that2, ok := that.(PrettySpan)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.StartKey != that1.StartKey {
		return false
	}
	if this.EndKey != that1.EndKey {
		return false
	}
	return true
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Status service

type StatusClient interface {
	Certificates(ctx context.Context, in *CertificatesRequest, opts ...grpc.CallOption) (*CertificatesResponse, error)
	Details(ctx context.Context, in *DetailsRequest, opts ...grpc.CallOption) (*DetailsResponse, error)
	Nodes(ctx context.Context, in *NodesRequest, opts ...grpc.CallOption) (*NodesResponse, error)
	Node(ctx context.Context, in *NodeRequest, opts ...grpc.CallOption) (*cockroach_server_status.NodeStatus, error)
	RaftDebug(ctx context.Context, in *RaftDebugRequest, opts ...grpc.CallOption) (*RaftDebugResponse, error)
	Ranges(ctx context.Context, in *RangesRequest, opts ...grpc.CallOption) (*RangesResponse, error)
	Gossip(ctx context.Context, in *GossipRequest, opts ...grpc.CallOption) (*cockroach_gossip.InfoStatus, error)
	Allocator(ctx context.Context, in *AllocatorRequest, opts ...grpc.CallOption) (*AllocatorResponse, error)
	AllocatorRange(ctx context.Context, in *AllocatorRangeRequest, opts ...grpc.CallOption) (*AllocatorRangeResponse, error)
	ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error)
	ListLocalSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error)
	CancelQuery(ctx context.Context, in *CancelQueryRequest, opts ...grpc.CallOption) (*CancelQueryResponse, error)
	CancelSession(ctx context.Context, in *CancelSessionRequest, opts ...grpc.CallOption) (*CancelSessionResponse, error)
	// SpanStats accepts a key span and node ID, and returns a set of stats
	// summed from all ranges on the stores on that node which contain keys
	// in that span. This is designed to compute stats specific to a SQL table:
	// it will be called with the highest/lowest key for a SQL table, and return
	// information about the resources on a node used by that table.
	SpanStats(ctx context.Context, in *SpanStatsRequest, opts ...grpc.CallOption) (*SpanStatsResponse, error)
	Stacks(ctx context.Context, in *StacksRequest, opts ...grpc.CallOption) (*JSONResponse, error)
	Profile(ctx context.Context, in *ProfileRequest, opts ...grpc.CallOption) (*JSONResponse, error)
	Metrics(ctx context.Context, in *MetricsRequest, opts ...grpc.CallOption) (*JSONResponse, error)
	GetFiles(ctx context.Context, in *GetFilesRequest, opts ...grpc.CallOption) (*GetFilesResponse, error)
	LogFilesList(ctx context.Context, in *LogFilesListRequest, opts ...grpc.CallOption) (*LogFilesListResponse, error)
	LogFile(ctx context.Context, in *LogFileRequest, opts ...grpc.CallOption) (*LogEntriesResponse, error)
	Logs(ctx context.Context, in *LogsRequest, opts ...grpc.CallOption) (*LogEntriesResponse, error)
	ProblemRanges(ctx context.Context, in *ProblemRangesRequest, opts ...grpc.CallOption) (*ProblemRangesResponse, error)
	Range(ctx context.Context, in *RangeRequest, opts ...grpc.CallOption) (*RangeResponse, error)
	CommandQueue(ctx context.Context, in *CommandQueueRequest, opts ...grpc.CallOption) (*CommandQueueResponse, error)
	Diagnostics(ctx context.Context, in *DiagnosticsRequest, opts ...grpc.CallOption) (*cockroach_server_diagnosticspb.DiagnosticReport, error)
	Stores(ctx context.Context, in *StoresRequest, opts ...grpc.CallOption) (*StoresResponse, error)
	Statements(ctx context.Context, in *StatementsRequest, opts ...grpc.CallOption) (*StatementsResponse, error)
}

type statusClient struct {
	cc *grpc.ClientConn
}

func NewStatusClient(cc *grpc.ClientConn) StatusClient {
	return &statusClient{cc}
}

func (c *statusClient) Certificates(ctx context.Context, in *CertificatesRequest, opts ...grpc.CallOption) (*CertificatesResponse, error) {
	out := new(CertificatesResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Certificates", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Details(ctx context.Context, in *DetailsRequest, opts ...grpc.CallOption) (*DetailsResponse, error) {
	out := new(DetailsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Details", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Nodes(ctx context.Context, in *NodesRequest, opts ...grpc.CallOption) (*NodesResponse, error) {
	out := new(NodesResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Nodes", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Node(ctx context.Context, in *NodeRequest, opts ...grpc.CallOption) (*cockroach_server_status.NodeStatus, error) {
	out := new(cockroach_server_status.NodeStatus)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Node", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) RaftDebug(ctx context.Context, in *RaftDebugRequest, opts ...grpc.CallOption) (*RaftDebugResponse, error) {
	out := new(RaftDebugResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/RaftDebug", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Ranges(ctx context.Context, in *RangesRequest, opts ...grpc.CallOption) (*RangesResponse, error) {
	out := new(RangesResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Ranges", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Gossip(ctx context.Context, in *GossipRequest, opts ...grpc.CallOption) (*cockroach_gossip.InfoStatus, error) {
	out := new(cockroach_gossip.InfoStatus)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Gossip", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Allocator(ctx context.Context, in *AllocatorRequest, opts ...grpc.CallOption) (*AllocatorResponse, error) {
	out := new(AllocatorResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Allocator", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) AllocatorRange(ctx context.Context, in *AllocatorRangeRequest, opts ...grpc.CallOption) (*AllocatorRangeResponse, error) {
	out := new(AllocatorRangeResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/AllocatorRange", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) ListSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error) {
	out := new(ListSessionsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/ListSessions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) ListLocalSessions(ctx context.Context, in *ListSessionsRequest, opts ...grpc.CallOption) (*ListSessionsResponse, error) {
	out := new(ListSessionsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/ListLocalSessions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) CancelQuery(ctx context.Context, in *CancelQueryRequest, opts ...grpc.CallOption) (*CancelQueryResponse, error) {
	out := new(CancelQueryResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/CancelQuery", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) CancelSession(ctx context.Context, in *CancelSessionRequest, opts ...grpc.CallOption) (*CancelSessionResponse, error) {
	out := new(CancelSessionResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/CancelSession", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) SpanStats(ctx context.Context, in *SpanStatsRequest, opts ...grpc.CallOption) (*SpanStatsResponse, error) {
	out := new(SpanStatsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/SpanStats", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Stacks(ctx context.Context, in *StacksRequest, opts ...grpc.CallOption) (*JSONResponse, error) {
	out := new(JSONResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Stacks", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Profile(ctx context.Context, in *ProfileRequest, opts ...grpc.CallOption) (*JSONResponse, error) {
	out := new(JSONResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Profile", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Metrics(ctx context.Context, in *MetricsRequest, opts ...grpc.CallOption) (*JSONResponse, error) {
	out := new(JSONResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Metrics", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) GetFiles(ctx context.Context, in *GetFilesRequest, opts ...grpc.CallOption) (*GetFilesResponse, error) {
	out := new(GetFilesResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/GetFiles", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) LogFilesList(ctx context.Context, in *LogFilesListRequest, opts ...grpc.CallOption) (*LogFilesListResponse, error) {
	out := new(LogFilesListResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/LogFilesList", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) LogFile(ctx context.Context, in *LogFileRequest, opts ...grpc.CallOption) (*LogEntriesResponse, error) {
	out := new(LogEntriesResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/LogFile", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Logs(ctx context.Context, in *LogsRequest, opts ...grpc.CallOption) (*LogEntriesResponse, error) {
	out := new(LogEntriesResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Logs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) ProblemRanges(ctx context.Context, in *ProblemRangesRequest, opts ...grpc.CallOption) (*ProblemRangesResponse, error) {
	out := new(ProblemRangesResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/ProblemRanges", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Range(ctx context.Context, in *RangeRequest, opts ...grpc.CallOption) (*RangeResponse, error) {
	out := new(RangeResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Range", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) CommandQueue(ctx context.Context, in *CommandQueueRequest, opts ...grpc.CallOption) (*CommandQueueResponse, error) {
	out := new(CommandQueueResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/CommandQueue", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Diagnostics(ctx context.Context, in *DiagnosticsRequest, opts ...grpc.CallOption) (*cockroach_server_diagnosticspb.DiagnosticReport, error) {
	out := new(cockroach_server_diagnosticspb.DiagnosticReport)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Diagnostics", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Stores(ctx context.Context, in *StoresRequest, opts ...grpc.CallOption) (*StoresResponse, error) {
	out := new(StoresResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Stores", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *statusClient) Statements(ctx context.Context, in *StatementsRequest, opts ...grpc.CallOption) (*StatementsResponse, error) {
	out := new(StatementsResponse)
	err := grpc.Invoke(ctx, "/cockroach.server.serverpb.Status/Statements", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Status service

type StatusServer interface {
	Certificates(context.Context, *CertificatesRequest) (*CertificatesResponse, error)
	Details(context.Context, *DetailsRequest) (*DetailsResponse, error)
	Nodes(context.Context, *NodesRequest) (*NodesResponse, error)
	Node(context.Context, *NodeRequest) (*cockroach_server_status.NodeStatus, error)
	RaftDebug(context.Context, *RaftDebugRequest) (*RaftDebugResponse, error)
	Ranges(context.Context, *RangesRequest) (*RangesResponse, error)
	Gossip(context.Context, *GossipRequest) (*cockroach_gossip.InfoStatus, error)
	Allocator(context.Context, *AllocatorRequest) (*AllocatorResponse, error)
	AllocatorRange(context.Context, *AllocatorRangeRequest) (*AllocatorRangeResponse, error)
	ListSessions(context.Context, *ListSessionsRequest) (*ListSessionsResponse, error)
	ListLocalSessions(context.Context, *ListSessionsRequest) (*ListSessionsResponse, error)
	CancelQuery(context.Context, *CancelQueryRequest) (*CancelQueryResponse, error)
	CancelSession(context.Context, *CancelSessionRequest) (*CancelSessionResponse, error)
	// SpanStats accepts a key span and node ID, and returns a set of stats
	// summed from all ranges on the stores on that node which contain keys
	// in that span. This is designed to compute stats specific to a SQL table:
	// it will be called with the highest/lowest key for a SQL table, and return
	// information about the resources on a node used by that table.
	SpanStats(context.Context, *SpanStatsRequest) (*SpanStatsResponse, error)
	Stacks(context.Context, *StacksRequest) (*JSONResponse, error)
	Profile(context.Context, *ProfileRequest) (*JSONResponse, error)
	Metrics(context.Context, *MetricsRequest) (*JSONResponse, error)
	GetFiles(context.Context, *GetFilesRequest) (*GetFilesResponse, error)
	LogFilesList(context.Context, *LogFilesListRequest) (*LogFilesListResponse, error)
	LogFile(context.Context, *LogFileRequest) (*LogEntriesResponse, error)
	Logs(context.Context, *LogsRequest) (*LogEntriesResponse, error)
	ProblemRanges(context.Context, *ProblemRangesRequest) (*ProblemRangesResponse, error)
	Range(context.Context, *RangeRequest) (*RangeResponse, error)
	CommandQueue(context.Context, *CommandQueueRequest) (*CommandQueueResponse, error)
	Diagnostics(context.Context, *DiagnosticsRequest) (*cockroach_server_diagnosticspb.DiagnosticReport, error)
	Stores(context.Context, *StoresRequest) (*StoresResponse, error)
	Statements(context.Context, *StatementsRequest) (*StatementsResponse, error)
}

func RegisterStatusServer(s *grpc.Server, srv StatusServer) {
	s.RegisterService(&_Status_serviceDesc, srv)
}

func _Status_Certificates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CertificatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Certificates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Certificates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Certificates(ctx, req.(*CertificatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Details_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Details(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Details",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Details(ctx, req.(*DetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Nodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Nodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Nodes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Nodes(ctx, req.(*NodesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Node_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Node(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Node",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Node(ctx, req.(*NodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_RaftDebug_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RaftDebugRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).RaftDebug(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/RaftDebug",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).RaftDebug(ctx, req.(*RaftDebugRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Ranges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Ranges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Ranges",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Ranges(ctx, req.(*RangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Gossip_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GossipRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Gossip(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Gossip",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Gossip(ctx, req.(*GossipRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Allocator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AllocatorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Allocator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Allocator",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Allocator(ctx, req.(*AllocatorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_AllocatorRange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AllocatorRangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).AllocatorRange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/AllocatorRange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).AllocatorRange(ctx, req.(*AllocatorRangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_ListSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).ListSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/ListSessions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).ListSessions(ctx, req.(*ListSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_ListLocalSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).ListLocalSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/ListLocalSessions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).ListLocalSessions(ctx, req.(*ListSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_CancelQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).CancelQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/CancelQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).CancelQuery(ctx, req.(*CancelQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_CancelSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).CancelSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/CancelSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).CancelSession(ctx, req.(*CancelSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_SpanStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SpanStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).SpanStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/SpanStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).SpanStats(ctx, req.(*SpanStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Stacks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StacksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Stacks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Stacks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Stacks(ctx, req.(*StacksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Profile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Profile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Profile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Profile(ctx, req.(*ProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Metrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Metrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Metrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Metrics(ctx, req.(*MetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_GetFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).GetFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/GetFiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).GetFiles(ctx, req.(*GetFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_LogFilesList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogFilesListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).LogFilesList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/LogFilesList",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).LogFilesList(ctx, req.(*LogFilesListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_LogFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).LogFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/LogFile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).LogFile(ctx, req.(*LogFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Logs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Logs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Logs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Logs(ctx, req.(*LogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_ProblemRanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProblemRangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).ProblemRanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/ProblemRanges",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).ProblemRanges(ctx, req.(*ProblemRangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Range_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Range(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Range",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Range(ctx, req.(*RangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_CommandQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommandQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).CommandQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/CommandQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).CommandQueue(ctx, req.(*CommandQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Diagnostics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiagnosticsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Diagnostics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Diagnostics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Diagnostics(ctx, req.(*DiagnosticsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Stores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Stores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Stores",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Stores(ctx, req.(*StoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Status_Statements_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StatementsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StatusServer).Statements(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.server.serverpb.Status/Statements",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StatusServer).Statements(ctx, req.(*StatementsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Status_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cockroach.server.serverpb.Status",
	HandlerType: (*StatusServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Certificates",
			Handler:    _Status_Certificates_Handler,
		},
		{
			MethodName: "Details",
			Handler:    _Status_Details_Handler,
		},
		{
			MethodName: "Nodes",
			Handler:    _Status_Nodes_Handler,
		},
		{
			MethodName: "Node",
			Handler:    _Status_Node_Handler,
		},
		{
			MethodName: "RaftDebug",
			Handler:    _Status_RaftDebug_Handler,
		},
		{
			MethodName: "Ranges",
			Handler:    _Status_Ranges_Handler,
		},
		{
			MethodName: "Gossip",
			Handler:    _Status_Gossip_Handler,
		},
		{
			MethodName: "Allocator",
			Handler:    _Status_Allocator_Handler,
		},
		{
			MethodName: "AllocatorRange",
			Handler:    _Status_AllocatorRange_Handler,
		},
		{
			MethodName: "ListSessions",
			Handler:    _Status_ListSessions_Handler,
		},
		{
			MethodName: "ListLocalSessions",
			Handler:    _Status_ListLocalSessions_Handler,
		},
		{
			MethodName: "CancelQuery",
			Handler:    _Status_CancelQuery_Handler,
		},
		{
			MethodName: "CancelSession",
			Handler:    _Status_CancelSession_Handler,
		},
		{
			MethodName: "SpanStats",
			Handler:    _Status_SpanStats_Handler,
		},
		{
			MethodName: "Stacks",
			Handler:    _Status_Stacks_Handler,
		},
		{
			MethodName: "Profile",
			Handler:    _Status_Profile_Handler,
		},
		{
			MethodName: "Metrics",
			Handler:    _Status_Metrics_Handler,
		},
		{
			MethodName: "GetFiles",
			Handler:    _Status_GetFiles_Handler,
		},
		{
			MethodName: "LogFilesList",
			Handler:    _Status_LogFilesList_Handler,
		},
		{
			MethodName: "LogFile",
			Handler:    _Status_LogFile_Handler,
		},
		{
			MethodName: "Logs",
			Handler:    _Status_Logs_Handler,
		},
		{
			MethodName: "ProblemRanges",
			Handler:    _Status_ProblemRanges_Handler,
		},
		{
			MethodName: "Range",
			Handler:    _Status_Range_Handler,
		},
		{
			MethodName: "CommandQueue",
			Handler:    _Status_CommandQueue_Handler,
		},
		{
			MethodName: "Diagnostics",
			Handler:    _Status_Diagnostics_Handler,
		},
		{
			MethodName: "Stores",
			Handler:    _Status_Stores_Handler,
		},
		{
			MethodName: "Statements",
			Handler:    _Status_Statements_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "server/serverpb/status.proto",
}

func (m *CertificatesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CertificatesRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	return i, nil
}

func (m *CertificateDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CertificateDetails) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Type))
	}
	if len(m.ErrorMessage) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.ErrorMessage)))
		i += copy(dAtA[i:], m.ErrorMessage)
	}
	if len(m.Data) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	if len(m.Fields) > 0 {
		for _, msg := range m.Fields {
			dAtA[i] = 0x22
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *CertificateDetails_Fields) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CertificateDetails_Fields) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Issuer) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Issuer)))
		i += copy(dAtA[i:], m.Issuer)
	}
	if len(m.Subject) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Subject)))
		i += copy(dAtA[i:], m.Subject)
	}
	if m.ValidFrom != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.ValidFrom))
	}
	if m.ValidUntil != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.ValidUntil))
	}
	if len(m.Addresses) > 0 {
		for _, s := range m.Addresses {
			dAtA[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.SignatureAlgorithm) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.SignatureAlgorithm)))
		i += copy(dAtA[i:], m.SignatureAlgorithm)
	}
	if len(m.PublicKey) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.PublicKey)))
		i += copy(dAtA[i:], m.PublicKey)
	}
	if len(m.KeyUsage) > 0 {
		for _, s := range m.KeyUsage {
			dAtA[i] = 0x42
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.ExtendedKeyUsage) > 0 {
		for _, s := range m.ExtendedKeyUsage {
			dAtA[i] = 0x4a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *CertificatesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CertificatesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Certificates) > 0 {
		for _, msg := range m.Certificates {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *DetailsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DetailsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	if m.Ready {
		dAtA[i] = 0x10
		i++
		if m.Ready {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *DetailsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DetailsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.NodeID))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.Address.Size()))
	n1, err := m.Address.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x1a
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.BuildInfo.Size()))
	n2, err := m.BuildInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	return i, nil
}

func (m *NodesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodesRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *NodesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Nodes) > 0 {
		for _, msg := range m.Nodes {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *NodeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	return i, nil
}

func (m *RaftState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftState) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ReplicaID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.ReplicaID))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.HardState.Size()))
	n3, err := m.HardState.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if m.Lead != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Lead))
	}
	if len(m.State) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.State)))
		i += copy(dAtA[i:], m.State)
	}
	if m.Applied != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Applied))
	}
	if len(m.Progress) > 0 {
		keysForProgress := make([]uint64, 0, len(m.Progress))
		for k := range m.Progress {
			keysForProgress = append(keysForProgress, uint64(k))
		}
		sortkeys.Uint64s(keysForProgress)
		for _, k := range keysForProgress {
			dAtA[i] = 0x32
			i++
			v := m.Progress[uint64(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovStatus(uint64(msgSize))
			}
			mapSize := 1 + sovStatus(uint64(k)) + msgSize
			i = encodeVarintStatus(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintStatus(dAtA, i, uint64(k))
			dAtA[i] = 0x12
			i++
			i = encodeVarintStatus(dAtA, i, uint64((&v).Size()))
			n4, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n4
		}
	}
	if m.LeadTransferee != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.LeadTransferee))
	}
	return i, nil
}

func (m *RaftState_Progress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftState_Progress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Match != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Match))
	}
	if m.Next != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Next))
	}
	if len(m.State) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.State)))
		i += copy(dAtA[i:], m.State)
	}
	if m.Paused {
		dAtA[i] = 0x20
		i++
		if m.Paused {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.PendingSnapshot != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.PendingSnapshot))
	}
	return i, nil
}

func (m *RangeProblems) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeProblems) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Unavailable {
		dAtA[i] = 0x8
		i++
		if m.Unavailable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.LeaderNotLeaseHolder {
		dAtA[i] = 0x10
		i++
		if m.LeaderNotLeaseHolder {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.NoRaftLeader {
		dAtA[i] = 0x18
		i++
		if m.NoRaftLeader {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Underreplicated {
		dAtA[i] = 0x20
		i++
		if m.Underreplicated {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.NoLease {
		dAtA[i] = 0x28
		i++
		if m.NoLease {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.QuiescentEqualsTicking {
		dAtA[i] = 0x30
		i++
		if m.QuiescentEqualsTicking {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.RaftLogTooLarge {
		dAtA[i] = 0x38
		i++
		if m.RaftLogTooLarge {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RangeStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.QueriesPerSecond != 0 {
		dAtA[i] = 0x9
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.QueriesPerSecond))))
		i += 8
	}
	if m.WritesPerSecond != 0 {
		dAtA[i] = 0x11
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.WritesPerSecond))))
		i += 8
	}
	return i, nil
}

func (m *PrettySpan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrettySpan) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.StartKey) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	return i, nil
}

func (m *CommandQueueMetrics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandQueueMetrics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.WriteCommands != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.WriteCommands))
	}
	if m.ReadCommands != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.ReadCommands))
	}
	if m.MaxOverlapsSeen != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.MaxOverlapsSeen))
	}
	if m.TreeSize != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.TreeSize))
	}
	return i, nil
}

func (m *RangeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.Span.Size()))
	n5, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	dAtA[i] = 0x12
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.RaftState.Size()))
	n6, err := m.RaftState.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	dAtA[i] = 0x22
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.State.Size()))
	n7, err := m.State.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	if m.SourceNodeID != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.SourceNodeID))
	}
	if m.SourceStoreID != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.SourceStoreID))
	}
	if len(m.ErrorMessage) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.ErrorMessage)))
		i += copy(dAtA[i:], m.ErrorMessage)
	}
	if len(m.LeaseHistory) > 0 {
		for _, msg := range m.LeaseHistory {
			dAtA[i] = 0x42
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x4a
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.Problems.Size()))
	n8, err := m.Problems.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	dAtA[i] = 0x52
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.Stats.Size()))
	n9, err := m.Stats.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	dAtA[i] = 0x5a
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.CmdQLocal.Size()))
	n10, err := m.CmdQLocal.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	dAtA[i] = 0x62
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.CmdQGlobal.Size()))
	n11, err := m.CmdQGlobal.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	dAtA[i] = 0x6a
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.LeaseStatus.Size()))
	n12, err := m.LeaseStatus.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	if m.Quiescent {
		dAtA[i] = 0x70
		i++
		if m.Quiescent {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Ticking {
		dAtA[i] = 0x78
		i++
		if m.Ticking {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RangesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangesRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	if len(m.RangeIDs) > 0 {
		dAtA14 := make([]byte, len(m.RangeIDs)*10)
		var j13 int
		for _, num1 := range m.RangeIDs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA14[j13] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j13++
			}
			dAtA14[j13] = uint8(num)
			j13++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(j13))
		i += copy(dAtA[i:], dAtA14[:j13])
	}
	return i, nil
}

func (m *RangesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Ranges) > 0 {
		for _, msg := range m.Ranges {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *GossipRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GossipRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	return i, nil
}

func (m *TraceEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TraceEvent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStatus(dAtA, i, uint64(types.SizeOfStdTime(m.Time)))
	n15, err := types.StdTimeMarshalTo(m.Time, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n15
	if len(m.Message) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	return i, nil
}

func (m *AllocatorDryRun) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AllocatorDryRun) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RangeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.RangeID))
	}
	if len(m.Events) > 0 {
		for _, msg := range m.Events {
			dAtA[i] = 0x12
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AllocatorRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AllocatorRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RangeId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.RangeId))
	}
	return i, nil
}

func (m *AllocatorRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AllocatorRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.NodeID))
	}
	if m.DryRun != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.DryRun.Size()))
		n16, err := m.DryRun.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}

func (m *AllocatorRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AllocatorRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	if len(m.RangeIDs) > 0 {
		dAtA18 := make([]byte, len(m.RangeIDs)*10)
		var j17 int
		for _, num1 := range m.RangeIDs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA18[j17] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j17++
			}
			dAtA18[j17] = uint8(num)
			j17++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(j17))
		i += copy(dAtA[i:], dAtA18[:j17])
	}
	return i, nil
}

func (m *AllocatorResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AllocatorResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.DryRuns) > 0 {
		for _, msg := range m.DryRuns {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *JSONResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JSONResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Data) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *LogsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	if len(m.Level) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Level)))
		i += copy(dAtA[i:], m.Level)
	}
	if len(m.StartTime) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.StartTime)))
		i += copy(dAtA[i:], m.StartTime)
	}
	if len(m.EndTime) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.EndTime)))
		i += copy(dAtA[i:], m.EndTime)
	}
	if len(m.Max) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Max)))
		i += copy(dAtA[i:], m.Max)
	}
	if len(m.Pattern) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Pattern)))
		i += copy(dAtA[i:], m.Pattern)
	}
	return i, nil
}

func (m *LogEntriesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogEntriesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for _, msg := range m.Entries {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *LogFilesListRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogFilesListRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	return i, nil
}

func (m *LogFilesListResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogFilesListResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *LogFileRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LogFileRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	if len(m.File) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.File)))
		i += copy(dAtA[i:], m.File)
	}
	return i, nil
}

func (m *StacksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StacksRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	return i, nil
}

func (m *File) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *File) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.FileSize != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.FileSize))
	}
	if len(m.Contents) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Contents)))
		i += copy(dAtA[i:], m.Contents)
	}
	return i, nil
}

func (m *GetFilesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetFilesRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	if m.ListOnly {
		dAtA[i] = 0x10
		i++
		if m.ListOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Type != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Type))
	}
	if len(m.Patterns) > 0 {
		for _, s := range m.Patterns {
			dAtA[i] = 0x32
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *GetFilesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetFilesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ProfileRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProfileRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	if m.Type != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Type))
	}
	return i, nil
}

func (m *MetricsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	return i, nil
}

func (m *RaftRangeNode) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftRangeNode) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.NodeID))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.Range.Size()))
	n19, err := m.Range.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n19
	return i, nil
}

func (m *RaftRangeError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftRangeError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	return i, nil
}

func (m *RaftRangeStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftRangeStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RangeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.RangeID))
	}
	if len(m.Errors) > 0 {
		for _, msg := range m.Errors {
			dAtA[i] = 0x12
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Nodes) > 0 {
		for _, msg := range m.Nodes {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RaftDebugRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftDebugRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.RangeIDs) > 0 {
		dAtA21 := make([]byte, len(m.RangeIDs)*10)
		var j20 int
		for _, num1 := range m.RangeIDs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA21[j20] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j20++
			}
			dAtA21[j20] = uint8(num)
			j20++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(j20))
		i += copy(dAtA[i:], dAtA21[:j20])
	}
	return i, nil
}

func (m *RaftDebugResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftDebugResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Ranges) > 0 {
		keysForRanges := make([]int64, 0, len(m.Ranges))
		for k := range m.Ranges {
			keysForRanges = append(keysForRanges, int64(k))
		}
		sortkeys.Int64s(keysForRanges)
		for _, k := range keysForRanges {
			dAtA[i] = 0xa
			i++
			v := m.Ranges[github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovStatus(uint64(msgSize))
			}
			mapSize := 1 + sovStatus(uint64(k)) + msgSize
			i = encodeVarintStatus(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintStatus(dAtA, i, uint64(k))
			dAtA[i] = 0x12
			i++
			i = encodeVarintStatus(dAtA, i, uint64((&v).Size()))
			n22, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n22
		}
	}
	if len(m.Errors) > 0 {
		for _, msg := range m.Errors {
			dAtA[i] = 0x12
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ActiveQuery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ActiveQuery) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.ID)))
		i += copy(dAtA[i:], m.ID)
	}
	if len(m.Sql) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Sql)))
		i += copy(dAtA[i:], m.Sql)
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintStatus(dAtA, i, uint64(types.SizeOfStdTime(m.Start)))
	n23, err := types.StdTimeMarshalTo(m.Start, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n23
	if m.IsDistributed {
		dAtA[i] = 0x20
		i++
		if m.IsDistributed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Phase != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.Phase))
	}
	return i, nil
}

func (m *ListSessionsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListSessionsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Username) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Username)))
		i += copy(dAtA[i:], m.Username)
	}
	return i, nil
}

func (m *Session) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Session) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.NodeID))
	}
	if len(m.Username) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Username)))
		i += copy(dAtA[i:], m.Username)
	}
	if len(m.ClientAddress) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.ClientAddress)))
		i += copy(dAtA[i:], m.ClientAddress)
	}
	if len(m.ApplicationName) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.ApplicationName)))
		i += copy(dAtA[i:], m.ApplicationName)
	}
	if len(m.ActiveQueries) > 0 {
		for _, msg := range m.ActiveQueries {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x32
	i++
	i = encodeVarintStatus(dAtA, i, uint64(types.SizeOfStdTime(m.Start)))
	n24, err := types.StdTimeMarshalTo(m.Start, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n24
	if m.KvTxnID != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.KvTxnID.Size()))
		n25, err := m.KvTxnID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if len(m.LastActiveQuery) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.LastActiveQuery)))
		i += copy(dAtA[i:], m.LastActiveQuery)
	}
	if len(m.ID) > 0 {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.ID)))
		i += copy(dAtA[i:], m.ID)
	}
	if m.AllocBytes != 0 {
		dAtA[i] = 0x50
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.AllocBytes))
	}
	if m.MaxAllocBytes != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.MaxAllocBytes))
	}
	return i, nil
}

func (m *ListSessionsError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListSessionsError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.NodeID))
	}
	if len(m.Message) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	return i, nil
}

func (m *ListSessionsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListSessionsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Sessions) > 0 {
		for _, msg := range m.Sessions {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Errors) > 0 {
		for _, msg := range m.Errors {
			dAtA[i] = 0x12
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *CancelQueryRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CancelQueryRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	if len(m.QueryID) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.QueryID)))
		i += copy(dAtA[i:], m.QueryID)
	}
	if len(m.Username) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Username)))
		i += copy(dAtA[i:], m.Username)
	}
	return i, nil
}

func (m *CancelQueryResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CancelQueryResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Canceled {
		dAtA[i] = 0x8
		i++
		if m.Canceled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Error) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Error)))
		i += copy(dAtA[i:], m.Error)
	}
	return i, nil
}

func (m *CancelSessionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CancelSessionRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	if len(m.SessionID) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.SessionID)))
		i += copy(dAtA[i:], m.SessionID)
	}
	if len(m.Username) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Username)))
		i += copy(dAtA[i:], m.Username)
	}
	return i, nil
}

func (m *CancelSessionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CancelSessionResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Canceled {
		dAtA[i] = 0x8
		i++
		if m.Canceled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Error) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.Error)))
		i += copy(dAtA[i:], m.Error)
	}
	return i, nil
}

func (m *SpanStatsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SpanStatsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeID)))
		i += copy(dAtA[i:], m.NodeID)
	}
	if len(m.StartKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	return i, nil
}

func (m *SpanStatsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SpanStatsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.TotalStats.Size()))
	n26, err := m.TotalStats.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n26
	if m.RangeCount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.RangeCount))
	}
	if m.ApproximateDiskBytes != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.ApproximateDiskBytes))
	}
	return i, nil
}

func (m *ProblemRangesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProblemRangesRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeID)))
		i += copy(dAtA[i:], m.NodeID)
	}
	return i, nil
}

func (m *ProblemRangesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProblemRangesResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.NodeID))
	}
	if len(m.ProblemsByNodeID) > 0 {
		keysForProblemsByNodeID := make([]int32, 0, len(m.ProblemsByNodeID))
		for k := range m.ProblemsByNodeID {
			keysForProblemsByNodeID = append(keysForProblemsByNodeID, int32(k))
		}
		sortkeys.Int32s(keysForProblemsByNodeID)
		for _, k := range keysForProblemsByNodeID {
			dAtA[i] = 0x4a
			i++
			v := m.ProblemsByNodeID[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovStatus(uint64(msgSize))
			}
			mapSize := 1 + sovStatus(uint64(k)) + msgSize
			i = encodeVarintStatus(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintStatus(dAtA, i, uint64(k))
			dAtA[i] = 0x12
			i++
			i = encodeVarintStatus(dAtA, i, uint64((&v).Size()))
			n27, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n27
		}
	}
	return i, nil
}

func (m *ProblemRangesResponse_NodeProblems) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProblemRangesResponse_NodeProblems) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ErrorMessage) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.ErrorMessage)))
		i += copy(dAtA[i:], m.ErrorMessage)
	}
	if len(m.UnavailableRangeIDs) > 0 {
		dAtA29 := make([]byte, len(m.UnavailableRangeIDs)*10)
		var j28 int
		for _, num1 := range m.UnavailableRangeIDs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA29[j28] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j28++
			}
			dAtA29[j28] = uint8(num)
			j28++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(j28))
		i += copy(dAtA[i:], dAtA29[:j28])
	}
	if len(m.RaftLeaderNotLeaseHolderRangeIDs) > 0 {
		dAtA31 := make([]byte, len(m.RaftLeaderNotLeaseHolderRangeIDs)*10)
		var j30 int
		for _, num1 := range m.RaftLeaderNotLeaseHolderRangeIDs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA31[j30] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j30++
			}
			dAtA31[j30] = uint8(num)
			j30++
		}
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(j30))
		i += copy(dAtA[i:], dAtA31[:j30])
	}
	if len(m.NoRaftLeaderRangeIDs) > 0 {
		dAtA33 := make([]byte, len(m.NoRaftLeaderRangeIDs)*10)
		var j32 int
		for _, num1 := range m.NoRaftLeaderRangeIDs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA33[j32] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j32++
			}
			dAtA33[j32] = uint8(num)
			j32++
		}
		dAtA[i] = 0x22
		i++
		i = encodeVarintStatus(dAtA, i, uint64(j32))
		i += copy(dAtA[i:], dAtA33[:j32])
	}
	if len(m.NoLeaseRangeIDs) > 0 {
		dAtA35 := make([]byte, len(m.NoLeaseRangeIDs)*10)
		var j34 int
		for _, num1 := range m.NoLeaseRangeIDs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA35[j34] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j34++
			}
			dAtA35[j34] = uint8(num)
			j34++
		}
		dAtA[i] = 0x2a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(j34))
		i += copy(dAtA[i:], dAtA35[:j34])
	}
	if len(m.UnderreplicatedRangeIDs) > 0 {
		dAtA37 := make([]byte, len(m.UnderreplicatedRangeIDs)*10)
		var j36 int
		for _, num1 := range m.UnderreplicatedRangeIDs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA37[j36] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j36++
			}
			dAtA37[j36] = uint8(num)
			j36++
		}
		dAtA[i] = 0x32
		i++
		i = encodeVarintStatus(dAtA, i, uint64(j36))
		i += copy(dAtA[i:], dAtA37[:j36])
	}
	if len(m.QuiescentEqualsTickingRangeIDs) > 0 {
		dAtA39 := make([]byte, len(m.QuiescentEqualsTickingRangeIDs)*10)
		var j38 int
		for _, num1 := range m.QuiescentEqualsTickingRangeIDs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA39[j38] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j38++
			}
			dAtA39[j38] = uint8(num)
			j38++
		}
		dAtA[i] = 0x3a
		i++
		i = encodeVarintStatus(dAtA, i, uint64(j38))
		i += copy(dAtA[i:], dAtA39[:j38])
	}
	if len(m.RaftLogTooLargeRangeIDs) > 0 {
		dAtA41 := make([]byte, len(m.RaftLogTooLargeRangeIDs)*10)
		var j40 int
		for _, num1 := range m.RaftLogTooLargeRangeIDs {
			num := uint64(num1)
			for num >= 1<<7 {
				dAtA41[j40] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j40++
			}
			dAtA41[j40] = uint8(num)
			j40++
		}
		dAtA[i] = 0x42
		i++
		i = encodeVarintStatus(dAtA, i, uint64(j40))
		i += copy(dAtA[i:], dAtA41[:j40])
	}
	return i, nil
}

func (m *RangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RangeId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.RangeId))
	}
	return i, nil
}

func (m *RangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.NodeID))
	}
	if m.RangeID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.RangeID))
	}
	if len(m.ResponsesByNodeID) > 0 {
		keysForResponsesByNodeID := make([]int32, 0, len(m.ResponsesByNodeID))
		for k := range m.ResponsesByNodeID {
			keysForResponsesByNodeID = append(keysForResponsesByNodeID, int32(k))
		}
		sortkeys.Int32s(keysForResponsesByNodeID)
		for _, k := range keysForResponsesByNodeID {
			dAtA[i] = 0x1a
			i++
			v := m.ResponsesByNodeID[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovStatus(uint64(msgSize))
			}
			mapSize := 1 + sovStatus(uint64(k)) + msgSize
			i = encodeVarintStatus(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintStatus(dAtA, i, uint64(k))
			dAtA[i] = 0x12
			i++
			i = encodeVarintStatus(dAtA, i, uint64((&v).Size()))
			n42, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n42
		}
	}
	return i, nil
}

func (m *RangeResponse_NodeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeResponse_NodeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Response {
		dAtA[i] = 0x8
		i++
		if m.Response {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.ErrorMessage) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.ErrorMessage)))
		i += copy(dAtA[i:], m.ErrorMessage)
	}
	if len(m.Infos) > 0 {
		for _, msg := range m.Infos {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *CommandQueueRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandQueueRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RangeId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.RangeId))
	}
	return i, nil
}

func (m *CommandQueueResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommandQueueResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.Snapshot.Size()))
	n43, err := m.Snapshot.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n43
	return i, nil
}

func (m *DiagnosticsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DiagnosticsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	return i, nil
}

func (m *StoresRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoresRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeId)))
		i += copy(dAtA[i:], m.NodeId)
	}
	return i, nil
}

func (m *StoreDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreDetails) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.StoreID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.StoreID))
	}
	if len(m.EncryptionStatus) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.EncryptionStatus)))
		i += copy(dAtA[i:], m.EncryptionStatus)
	}
	if m.TotalFiles != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.TotalFiles))
	}
	if m.TotalBytes != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.TotalBytes))
	}
	if m.ActiveKeyFiles != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.ActiveKeyFiles))
	}
	if m.ActiveKeyBytes != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.ActiveKeyBytes))
	}
	return i, nil
}

func (m *StoresResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoresResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Stores) > 0 {
		for _, msg := range m.Stores {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *StatementsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatementsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStatus(dAtA, i, uint64(len(m.NodeID)))
		i += copy(dAtA[i:], m.NodeID)
	}
	return i, nil
}

func (m *StatementsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatementsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Statements) > 0 {
		for _, msg := range m.Statements {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStatus(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintStatus(dAtA, i, uint64(types.SizeOfStdTime(m.LastReset)))
	n44, err := types.StdTimeMarshalTo(m.LastReset, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n44
	return i, nil
}

func (m *StatementsResponse_ExtendedStatementStatisticsKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatementsResponse_ExtendedStatementStatisticsKey) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.KeyData.Size()))
	n45, err := m.KeyData.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n45
	if m.NodeID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStatus(dAtA, i, uint64(m.NodeID))
	}
	return i, nil
}

func (m *StatementsResponse_CollectedStatementStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatementsResponse_CollectedStatementStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.Key.Size()))
	n46, err := m.Key.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n46
	dAtA[i] = 0x12
	i++
	i = encodeVarintStatus(dAtA, i, uint64(m.Stats.Size()))
	n47, err := m.Stats.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n47
	return i, nil
}

func encodeVarintStatus(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *CertificatesRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *CertificateDetails) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovStatus(uint64(m.Type))
	}
	l = len(m.ErrorMessage)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if len(m.Fields) > 0 {
		for _, e := range m.Fields {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *CertificateDetails_Fields) Size() (n int) {
	var l int
	_ = l
	l = len(m.Issuer)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.Subject)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if m.ValidFrom != 0 {
		n += 1 + sovStatus(uint64(m.ValidFrom))
	}
	if m.ValidUntil != 0 {
		n += 1 + sovStatus(uint64(m.ValidUntil))
	}
	if len(m.Addresses) > 0 {
		for _, s := range m.Addresses {
			l = len(s)
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	l = len(m.SignatureAlgorithm)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.PublicKey)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if len(m.KeyUsage) > 0 {
		for _, s := range m.KeyUsage {
			l = len(s)
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	if len(m.ExtendedKeyUsage) > 0 {
		for _, s := range m.ExtendedKeyUsage {
			l = len(s)
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *CertificatesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Certificates) > 0 {
		for _, e := range m.Certificates {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *DetailsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if m.Ready {
		n += 2
	}
	return n
}

func (m *DetailsResponse) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovStatus(uint64(m.NodeID))
	}
	l = m.Address.Size()
	n += 1 + l + sovStatus(uint64(l))
	l = m.BuildInfo.Size()
	n += 1 + l + sovStatus(uint64(l))
	return n
}

func (m *NodesRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *NodesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Nodes) > 0 {
		for _, e := range m.Nodes {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *NodeRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *RaftState) Size() (n int) {
	var l int
	_ = l
	if m.ReplicaID != 0 {
		n += 1 + sovStatus(uint64(m.ReplicaID))
	}
	l = m.HardState.Size()
	n += 1 + l + sovStatus(uint64(l))
	if m.Lead != 0 {
		n += 1 + sovStatus(uint64(m.Lead))
	}
	l = len(m.State)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if m.Applied != 0 {
		n += 1 + sovStatus(uint64(m.Applied))
	}
	if len(m.Progress) > 0 {
		for k, v := range m.Progress {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + sovStatus(uint64(k)) + 1 + l + sovStatus(uint64(l))
			n += mapEntrySize + 1 + sovStatus(uint64(mapEntrySize))
		}
	}
	if m.LeadTransferee != 0 {
		n += 1 + sovStatus(uint64(m.LeadTransferee))
	}
	return n
}

func (m *RaftState_Progress) Size() (n int) {
	var l int
	_ = l
	if m.Match != 0 {
		n += 1 + sovStatus(uint64(m.Match))
	}
	if m.Next != 0 {
		n += 1 + sovStatus(uint64(m.Next))
	}
	l = len(m.State)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if m.Paused {
		n += 2
	}
	if m.PendingSnapshot != 0 {
		n += 1 + sovStatus(uint64(m.PendingSnapshot))
	}
	return n
}

func (m *RangeProblems) Size() (n int) {
	var l int
	_ = l
	if m.Unavailable {
		n += 2
	}
	if m.LeaderNotLeaseHolder {
		n += 2
	}
	if m.NoRaftLeader {
		n += 2
	}
	if m.Underreplicated {
		n += 2
	}
	if m.NoLease {
		n += 2
	}
	if m.QuiescentEqualsTicking {
		n += 2
	}
	if m.RaftLogTooLarge {
		n += 2
	}
	return n
}

func (m *RangeStatistics) Size() (n int) {
	var l int
	_ = l
	if m.QueriesPerSecond != 0 {
		n += 9
	}
	if m.WritesPerSecond != 0 {
		n += 9
	}
	return n
}

func (m *PrettySpan) Size() (n int) {
	var l int
	_ = l
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *CommandQueueMetrics) Size() (n int) {
	var l int
	_ = l
	if m.WriteCommands != 0 {
		n += 1 + sovStatus(uint64(m.WriteCommands))
	}
	if m.ReadCommands != 0 {
		n += 1 + sovStatus(uint64(m.ReadCommands))
	}
	if m.MaxOverlapsSeen != 0 {
		n += 1 + sovStatus(uint64(m.MaxOverlapsSeen))
	}
	if m.TreeSize != 0 {
		n += 1 + sovStatus(uint64(m.TreeSize))
	}
	return n
}

func (m *RangeInfo) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovStatus(uint64(l))
	l = m.RaftState.Size()
	n += 1 + l + sovStatus(uint64(l))
	l = m.State.Size()
	n += 1 + l + sovStatus(uint64(l))
	if m.SourceNodeID != 0 {
		n += 1 + sovStatus(uint64(m.SourceNodeID))
	}
	if m.SourceStoreID != 0 {
		n += 1 + sovStatus(uint64(m.SourceStoreID))
	}
	l = len(m.ErrorMessage)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if len(m.LeaseHistory) > 0 {
		for _, e := range m.LeaseHistory {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	l = m.Problems.Size()
	n += 1 + l + sovStatus(uint64(l))
	l = m.Stats.Size()
	n += 1 + l + sovStatus(uint64(l))
	l = m.CmdQLocal.Size()
	n += 1 + l + sovStatus(uint64(l))
	l = m.CmdQGlobal.Size()
	n += 1 + l + sovStatus(uint64(l))
	l = m.LeaseStatus.Size()
	n += 1 + l + sovStatus(uint64(l))
	if m.Quiescent {
		n += 2
	}
	if m.Ticking {
		n += 2
	}
	return n
}

func (m *RangesRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if len(m.RangeIDs) > 0 {
		l = 0
		for _, e := range m.RangeIDs {
			l += sovStatus(uint64(e))
		}
		n += 1 + sovStatus(uint64(l)) + l
	}
	return n
}

func (m *RangesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Ranges) > 0 {
		for _, e := range m.Ranges {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *GossipRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *TraceEvent) Size() (n int) {
	var l int
	_ = l
	l = types.SizeOfStdTime(m.Time)
	n += 1 + l + sovStatus(uint64(l))
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *AllocatorDryRun) Size() (n int) {
	var l int
	_ = l
	if m.RangeID != 0 {
		n += 1 + sovStatus(uint64(m.RangeID))
	}
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *AllocatorRangeRequest) Size() (n int) {
	var l int
	_ = l
	if m.RangeId != 0 {
		n += 1 + sovStatus(uint64(m.RangeId))
	}
	return n
}

func (m *AllocatorRangeResponse) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovStatus(uint64(m.NodeID))
	}
	if m.DryRun != nil {
		l = m.DryRun.Size()
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *AllocatorRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if len(m.RangeIDs) > 0 {
		l = 0
		for _, e := range m.RangeIDs {
			l += sovStatus(uint64(e))
		}
		n += 1 + sovStatus(uint64(l)) + l
	}
	return n
}

func (m *AllocatorResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.DryRuns) > 0 {
		for _, e := range m.DryRuns {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *JSONResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *LogsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.Level)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.StartTime)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.EndTime)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.Max)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.Pattern)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *LogEntriesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for _, e := range m.Entries {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *LogFilesListRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *LogFilesListResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *LogFileRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.File)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *StacksRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *File) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if m.FileSize != 0 {
		n += 1 + sovStatus(uint64(m.FileSize))
	}
	l = len(m.Contents)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *GetFilesRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if m.ListOnly {
		n += 2
	}
	if m.Type != 0 {
		n += 1 + sovStatus(uint64(m.Type))
	}
	if len(m.Patterns) > 0 {
		for _, s := range m.Patterns {
			l = len(s)
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *GetFilesResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *ProfileRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovStatus(uint64(m.Type))
	}
	return n
}

func (m *MetricsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *RaftRangeNode) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovStatus(uint64(m.NodeID))
	}
	l = m.Range.Size()
	n += 1 + l + sovStatus(uint64(l))
	return n
}

func (m *RaftRangeError) Size() (n int) {
	var l int
	_ = l
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *RaftRangeStatus) Size() (n int) {
	var l int
	_ = l
	if m.RangeID != 0 {
		n += 1 + sovStatus(uint64(m.RangeID))
	}
	if len(m.Errors) > 0 {
		for _, e := range m.Errors {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	if len(m.Nodes) > 0 {
		for _, e := range m.Nodes {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *RaftDebugRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.RangeIDs) > 0 {
		l = 0
		for _, e := range m.RangeIDs {
			l += sovStatus(uint64(e))
		}
		n += 1 + sovStatus(uint64(l)) + l
	}
	return n
}

func (m *RaftDebugResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Ranges) > 0 {
		for k, v := range m.Ranges {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + sovStatus(uint64(k)) + 1 + l + sovStatus(uint64(l))
			n += mapEntrySize + 1 + sovStatus(uint64(mapEntrySize))
		}
	}
	if len(m.Errors) > 0 {
		for _, e := range m.Errors {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *ActiveQuery) Size() (n int) {
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.Sql)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = types.SizeOfStdTime(m.Start)
	n += 1 + l + sovStatus(uint64(l))
	if m.IsDistributed {
		n += 2
	}
	if m.Phase != 0 {
		n += 1 + sovStatus(uint64(m.Phase))
	}
	return n
}

func (m *ListSessionsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *Session) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovStatus(uint64(m.NodeID))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.ClientAddress)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.ApplicationName)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if len(m.ActiveQueries) > 0 {
		for _, e := range m.ActiveQueries {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	l = types.SizeOfStdTime(m.Start)
	n += 1 + l + sovStatus(uint64(l))
	if m.KvTxnID != nil {
		l = m.KvTxnID.Size()
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.LastActiveQuery)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if m.AllocBytes != 0 {
		n += 1 + sovStatus(uint64(m.AllocBytes))
	}
	if m.MaxAllocBytes != 0 {
		n += 1 + sovStatus(uint64(m.MaxAllocBytes))
	}
	return n
}

func (m *ListSessionsError) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovStatus(uint64(m.NodeID))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *ListSessionsResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Sessions) > 0 {
		for _, e := range m.Sessions {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	if len(m.Errors) > 0 {
		for _, e := range m.Errors {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *CancelQueryRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.QueryID)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *CancelQueryResponse) Size() (n int) {
	var l int
	_ = l
	if m.Canceled {
		n += 2
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *CancelSessionRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *CancelSessionResponse) Size() (n int) {
	var l int
	_ = l
	if m.Canceled {
		n += 2
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *SpanStatsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *SpanStatsResponse) Size() (n int) {
	var l int
	_ = l
	l = m.TotalStats.Size()
	n += 1 + l + sovStatus(uint64(l))
	if m.RangeCount != 0 {
		n += 1 + sovStatus(uint64(m.RangeCount))
	}
	if m.ApproximateDiskBytes != 0 {
		n += 1 + sovStatus(uint64(m.ApproximateDiskBytes))
	}
	return n
}

func (m *ProblemRangesRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *ProblemRangesResponse) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovStatus(uint64(m.NodeID))
	}
	if len(m.ProblemsByNodeID) > 0 {
		for k, v := range m.ProblemsByNodeID {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + sovStatus(uint64(k)) + 1 + l + sovStatus(uint64(l))
			n += mapEntrySize + 1 + sovStatus(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *ProblemRangesResponse_NodeProblems) Size() (n int) {
	var l int
	_ = l
	l = len(m.ErrorMessage)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if len(m.UnavailableRangeIDs) > 0 {
		l = 0
		for _, e := range m.UnavailableRangeIDs {
			l += sovStatus(uint64(e))
		}
		n += 1 + sovStatus(uint64(l)) + l
	}
	if len(m.RaftLeaderNotLeaseHolderRangeIDs) > 0 {
		l = 0
		for _, e := range m.RaftLeaderNotLeaseHolderRangeIDs {
			l += sovStatus(uint64(e))
		}
		n += 1 + sovStatus(uint64(l)) + l
	}
	if len(m.NoRaftLeaderRangeIDs) > 0 {
		l = 0
		for _, e := range m.NoRaftLeaderRangeIDs {
			l += sovStatus(uint64(e))
		}
		n += 1 + sovStatus(uint64(l)) + l
	}
	if len(m.NoLeaseRangeIDs) > 0 {
		l = 0
		for _, e := range m.NoLeaseRangeIDs {
			l += sovStatus(uint64(e))
		}
		n += 1 + sovStatus(uint64(l)) + l
	}
	if len(m.UnderreplicatedRangeIDs) > 0 {
		l = 0
		for _, e := range m.UnderreplicatedRangeIDs {
			l += sovStatus(uint64(e))
		}
		n += 1 + sovStatus(uint64(l)) + l
	}
	if len(m.QuiescentEqualsTickingRangeIDs) > 0 {
		l = 0
		for _, e := range m.QuiescentEqualsTickingRangeIDs {
			l += sovStatus(uint64(e))
		}
		n += 1 + sovStatus(uint64(l)) + l
	}
	if len(m.RaftLogTooLargeRangeIDs) > 0 {
		l = 0
		for _, e := range m.RaftLogTooLargeRangeIDs {
			l += sovStatus(uint64(e))
		}
		n += 1 + sovStatus(uint64(l)) + l
	}
	return n
}

func (m *RangeRequest) Size() (n int) {
	var l int
	_ = l
	if m.RangeId != 0 {
		n += 1 + sovStatus(uint64(m.RangeId))
	}
	return n
}

func (m *RangeResponse) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovStatus(uint64(m.NodeID))
	}
	if m.RangeID != 0 {
		n += 1 + sovStatus(uint64(m.RangeID))
	}
	if len(m.ResponsesByNodeID) > 0 {
		for k, v := range m.ResponsesByNodeID {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + sovStatus(uint64(k)) + 1 + l + sovStatus(uint64(l))
			n += mapEntrySize + 1 + sovStatus(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *RangeResponse_NodeResponse) Size() (n int) {
	var l int
	_ = l
	if m.Response {
		n += 2
	}
	l = len(m.ErrorMessage)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if len(m.Infos) > 0 {
		for _, e := range m.Infos {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *CommandQueueRequest) Size() (n int) {
	var l int
	_ = l
	if m.RangeId != 0 {
		n += 1 + sovStatus(uint64(m.RangeId))
	}
	return n
}

func (m *CommandQueueResponse) Size() (n int) {
	var l int
	_ = l
	l = m.Snapshot.Size()
	n += 1 + l + sovStatus(uint64(l))
	return n
}

func (m *DiagnosticsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *StoresRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeId)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *StoreDetails) Size() (n int) {
	var l int
	_ = l
	if m.StoreID != 0 {
		n += 1 + sovStatus(uint64(m.StoreID))
	}
	l = len(m.EncryptionStatus)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	if m.TotalFiles != 0 {
		n += 1 + sovStatus(uint64(m.TotalFiles))
	}
	if m.TotalBytes != 0 {
		n += 1 + sovStatus(uint64(m.TotalBytes))
	}
	if m.ActiveKeyFiles != 0 {
		n += 1 + sovStatus(uint64(m.ActiveKeyFiles))
	}
	if m.ActiveKeyBytes != 0 {
		n += 1 + sovStatus(uint64(m.ActiveKeyBytes))
	}
	return n
}

func (m *StoresResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Stores) > 0 {
		for _, e := range m.Stores {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	return n
}

func (m *StatementsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovStatus(uint64(l))
	}
	return n
}

func (m *StatementsResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Statements) > 0 {
		for _, e := range m.Statements {
			l = e.Size()
			n += 1 + l + sovStatus(uint64(l))
		}
	}
	l = types.SizeOfStdTime(m.LastReset)
	n += 1 + l + sovStatus(uint64(l))
	return n
}

func (m *StatementsResponse_ExtendedStatementStatisticsKey) Size() (n int) {
	var l int
	_ = l
	l = m.KeyData.Size()
	n += 1 + l + sovStatus(uint64(l))
	if m.NodeID != 0 {
		n += 1 + sovStatus(uint64(m.NodeID))
	}
	return n
}

func (m *StatementsResponse_CollectedStatementStatistics) Size() (n int) {
	var l int
	_ = l
	l = m.Key.Size()
	n += 1 + l + sovStatus(uint64(l))
	l = m.Stats.Size()
	n += 1 + l + sovStatus(uint64(l))
	return n
}

func sovStatus(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozStatus(x uint64) (n int) {
	return sovStatus(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *CertificatesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CertificatesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CertificatesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CertificateDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CertificateDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CertificateDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (CertificateDetails_CertificateType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Fields", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Fields = append(m.Fields, CertificateDetails_Fields{})
			if err := m.Fields[len(m.Fields)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CertificateDetails_Fields) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Fields: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Fields: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Issuer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Issuer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subject = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidFrom", wireType)
			}
			m.ValidFrom = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ValidFrom |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidUntil", wireType)
			}
			m.ValidUntil = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ValidUntil |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addresses", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addresses = append(m.Addresses, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SignatureAlgorithm", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SignatureAlgorithm = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublicKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PublicKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyUsage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KeyUsage = append(m.KeyUsage, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtendedKeyUsage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExtendedKeyUsage = append(m.ExtendedKeyUsage, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CertificatesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CertificatesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CertificatesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Certificates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Certificates = append(m.Certificates, CertificateDetails{})
			if err := m.Certificates[len(m.Certificates)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DetailsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DetailsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DetailsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ready", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ready = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DetailsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DetailsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DetailsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Address.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuildInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.BuildInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nodes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nodes = append(m.Nodes, cockroach_server_status.NodeStatus{})
			if err := m.Nodes[len(m.Nodes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaID", wireType)
			}
			m.ReplicaID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplicaID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HardState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.HardState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lead", wireType)
			}
			m.Lead = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Lead |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.State = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Applied", wireType)
			}
			m.Applied = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Applied |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Progress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Progress == nil {
				m.Progress = make(map[uint64]RaftState_Progress)
			}
			var mapkey uint64
			mapvalue := &RaftState_Progress{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthStatus
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthStatus
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &RaftState_Progress{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipStatus(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthStatus
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Progress[mapkey] = *mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeadTransferee", wireType)
			}
			m.LeadTransferee = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LeadTransferee |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftState_Progress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Progress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Progress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Match", wireType)
			}
			m.Match = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Match |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Next", wireType)
			}
			m.Next = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Next |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.State = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Paused", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Paused = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingSnapshot", wireType)
			}
			m.PendingSnapshot = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PendingSnapshot |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeProblems) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeProblems: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeProblems: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unavailable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Unavailable = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaderNotLeaseHolder", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LeaderNotLeaseHolder = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoRaftLeader", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoRaftLeader = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Underreplicated", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Underreplicated = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoLease", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoLease = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field QuiescentEqualsTicking", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.QuiescentEqualsTicking = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftLogTooLarge", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RaftLogTooLarge = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueriesPerSecond", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.QueriesPerSecond = float64(math.Float64frombits(v))
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field WritesPerSecond", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.WritesPerSecond = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrettySpan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrettySpan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrettySpan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandQueueMetrics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandQueueMetrics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandQueueMetrics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteCommands", wireType)
			}
			m.WriteCommands = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WriteCommands |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadCommands", wireType)
			}
			m.ReadCommands = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReadCommands |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxOverlapsSeen", wireType)
			}
			m.MaxOverlapsSeen = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxOverlapsSeen |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TreeSize", wireType)
			}
			m.TreeSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TreeSize |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RaftState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.State.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceNodeID", wireType)
			}
			m.SourceNodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SourceNodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceStoreID", wireType)
			}
			m.SourceStoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SourceStoreID |= (github_com_cockroachdb_cockroach_pkg_roachpb.StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseHistory", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LeaseHistory = append(m.LeaseHistory, cockroach_roachpb1.Lease{})
			if err := m.LeaseHistory[len(m.LeaseHistory)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Problems", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Problems.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CmdQLocal", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.CmdQLocal.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CmdQGlobal", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.CmdQGlobal.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LeaseStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quiescent", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Quiescent = bool(v != 0)
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ticking", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ticking = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.RangeIDs = append(m.RangeIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStatus
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.RangeIDs = append(m.RangeIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeIDs", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ranges = append(m.Ranges, RangeInfo{})
			if err := m.Ranges[len(m.Ranges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GossipRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GossipRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GossipRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TraceEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TraceEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TraceEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := types.StdTimeUnmarshal(&m.Time, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AllocatorDryRun) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AllocatorDryRun: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AllocatorDryRun: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, &TraceEvent{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AllocatorRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AllocatorRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AllocatorRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeId", wireType)
			}
			m.RangeId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeId |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AllocatorRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AllocatorRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AllocatorRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DryRun", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DryRun == nil {
				m.DryRun = &AllocatorDryRun{}
			}
			if err := m.DryRun.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AllocatorRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AllocatorRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AllocatorRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.RangeIDs = append(m.RangeIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStatus
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.RangeIDs = append(m.RangeIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeIDs", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AllocatorResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AllocatorResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AllocatorResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DryRuns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DryRuns = append(m.DryRuns, &AllocatorDryRun{})
			if err := m.DryRuns[len(m.DryRuns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JSONResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JSONResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JSONResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Level", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Level = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTime = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndTime = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Max", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Max = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pattern", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogEntriesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogEntriesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogEntriesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Entries = append(m.Entries, cockroach_util_log.Entry{})
			if err := m.Entries[len(m.Entries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogFilesListRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogFilesListRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogFilesListRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogFilesListResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogFilesListResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogFilesListResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, cockroach_util_log.FileInfo{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LogFileRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogFileRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogFileRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field File", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.File = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StacksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StacksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StacksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *File) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: File: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: File: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileSize", wireType)
			}
			m.FileSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FileSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Contents", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Contents = append(m.Contents[:0], dAtA[iNdEx:postIndex]...)
			if m.Contents == nil {
				m.Contents = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetFilesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetFilesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetFilesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ListOnly = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (FileType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Patterns", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Patterns = append(m.Patterns, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetFilesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetFilesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetFilesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, &File{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProfileRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProfileRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProfileRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (ProfileRequest_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetricsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftRangeNode) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftRangeNode: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftRangeNode: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Range", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Range.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftRangeError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftRangeError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftRangeError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftRangeStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftRangeStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftRangeStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Errors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Errors = append(m.Errors, RaftRangeError{})
			if err := m.Errors[len(m.Errors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nodes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nodes = append(m.Nodes, RaftRangeNode{})
			if err := m.Nodes[len(m.Nodes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftDebugRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftDebugRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftDebugRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.RangeIDs = append(m.RangeIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStatus
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.RangeIDs = append(m.RangeIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeIDs", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftDebugResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftDebugResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftDebugResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ranges == nil {
				m.Ranges = make(map[github_com_cockroachdb_cockroach_pkg_roachpb.RangeID]RaftRangeStatus)
			}
			var mapkey int64
			mapvalue := &RaftRangeStatus{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthStatus
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthStatus
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &RaftRangeStatus{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipStatus(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthStatus
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Ranges[github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(mapkey)] = *mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Errors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Errors = append(m.Errors, RaftRangeError{})
			if err := m.Errors[len(m.Errors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ActiveQuery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ActiveQuery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ActiveQuery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sql", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sql = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := types.StdTimeUnmarshal(&m.Start, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDistributed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDistributed = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Phase", wireType)
			}
			m.Phase = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Phase |= (ActiveQuery_Phase(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListSessionsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListSessionsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListSessionsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Session) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Session: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Session: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplicationName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApplicationName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveQueries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActiveQueries = append(m.ActiveQueries, ActiveQuery{})
			if err := m.ActiveQueries[len(m.ActiveQueries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := types.StdTimeUnmarshal(&m.Start, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KvTxnID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cockroachdb_cockroach_pkg_util_uuid.UUID
			m.KvTxnID = &v
			if err := m.KvTxnID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastActiveQuery", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastActiveQuery = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = append(m.ID[:0], dAtA[iNdEx:postIndex]...)
			if m.ID == nil {
				m.ID = []byte{}
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllocBytes", wireType)
			}
			m.AllocBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AllocBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxAllocBytes", wireType)
			}
			m.MaxAllocBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxAllocBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListSessionsError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListSessionsError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListSessionsError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListSessionsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListSessionsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListSessionsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sessions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sessions = append(m.Sessions, Session{})
			if err := m.Sessions[len(m.Sessions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Errors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Errors = append(m.Errors, ListSessionsError{})
			if err := m.Errors[len(m.Errors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CancelQueryRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CancelQueryRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CancelQueryRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.QueryID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CancelQueryResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CancelQueryResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CancelQueryResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Canceled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Canceled = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CancelSessionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CancelSessionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CancelSessionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = append(m.SessionID[:0], dAtA[iNdEx:postIndex]...)
			if m.SessionID == nil {
				m.SessionID = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CancelSessionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CancelSessionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CancelSessionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Canceled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Canceled = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SpanStatsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SpanStatsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SpanStatsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SpanStatsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SpanStatsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SpanStatsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TotalStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeCount", wireType)
			}
			m.RangeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeCount |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApproximateDiskBytes", wireType)
			}
			m.ApproximateDiskBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApproximateDiskBytes |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProblemRangesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProblemRangesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProblemRangesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProblemRangesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProblemRangesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProblemRangesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProblemsByNodeID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProblemsByNodeID == nil {
				m.ProblemsByNodeID = make(map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]ProblemRangesResponse_NodeProblems)
			}
			var mapkey int32
			mapvalue := &ProblemRangesResponse_NodeProblems{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthStatus
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthStatus
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &ProblemRangesResponse_NodeProblems{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipStatus(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthStatus
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ProblemsByNodeID[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(mapkey)] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProblemRangesResponse_NodeProblems) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeProblems: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeProblems: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.UnavailableRangeIDs = append(m.UnavailableRangeIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStatus
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.UnavailableRangeIDs = append(m.UnavailableRangeIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field UnavailableRangeIDs", wireType)
			}
		case 3:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.RaftLeaderNotLeaseHolderRangeIDs = append(m.RaftLeaderNotLeaseHolderRangeIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStatus
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.RaftLeaderNotLeaseHolderRangeIDs = append(m.RaftLeaderNotLeaseHolderRangeIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftLeaderNotLeaseHolderRangeIDs", wireType)
			}
		case 4:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.NoRaftLeaderRangeIDs = append(m.NoRaftLeaderRangeIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStatus
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.NoRaftLeaderRangeIDs = append(m.NoRaftLeaderRangeIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field NoRaftLeaderRangeIDs", wireType)
			}
		case 5:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.NoLeaseRangeIDs = append(m.NoLeaseRangeIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStatus
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.NoLeaseRangeIDs = append(m.NoLeaseRangeIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field NoLeaseRangeIDs", wireType)
			}
		case 6:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.UnderreplicatedRangeIDs = append(m.UnderreplicatedRangeIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStatus
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.UnderreplicatedRangeIDs = append(m.UnderreplicatedRangeIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field UnderreplicatedRangeIDs", wireType)
			}
		case 7:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.QuiescentEqualsTickingRangeIDs = append(m.QuiescentEqualsTickingRangeIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStatus
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.QuiescentEqualsTickingRangeIDs = append(m.QuiescentEqualsTickingRangeIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field QuiescentEqualsTickingRangeIDs", wireType)
			}
		case 8:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.RaftLogTooLargeRangeIDs = append(m.RaftLogTooLargeRangeIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStatus
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_roachpb.RangeID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.RaftLogTooLargeRangeIDs = append(m.RaftLogTooLargeRangeIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftLogTooLargeRangeIDs", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeId", wireType)
			}
			m.RangeId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeId |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponsesByNodeID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResponsesByNodeID == nil {
				m.ResponsesByNodeID = make(map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]RangeResponse_NodeResponse)
			}
			var mapkey int32
			mapvalue := &RangeResponse_NodeResponse{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStatus
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthStatus
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthStatus
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &RangeResponse_NodeResponse{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipStatus(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthStatus
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ResponsesByNodeID[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(mapkey)] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeResponse_NodeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Response", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Response = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Infos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Infos = append(m.Infos, RangeInfo{})
			if err := m.Infos[len(m.Infos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandQueueRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandQueueRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandQueueRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeId", wireType)
			}
			m.RangeId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeId |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommandQueueResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommandQueueResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommandQueueResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Snapshot", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Snapshot.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DiagnosticsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DiagnosticsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DiagnosticsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoresRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoresRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoresRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (github_com_cockroachdb_cockroach_pkg_roachpb.StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncryptionStatus", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EncryptionStatus = append(m.EncryptionStatus[:0], dAtA[iNdEx:postIndex]...)
			if m.EncryptionStatus == nil {
				m.EncryptionStatus = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalFiles", wireType)
			}
			m.TotalFiles = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalFiles |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalBytes", wireType)
			}
			m.TotalBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalBytes |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveKeyFiles", wireType)
			}
			m.ActiveKeyFiles = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ActiveKeyFiles |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveKeyBytes", wireType)
			}
			m.ActiveKeyBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ActiveKeyBytes |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoresResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoresResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoresResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stores", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Stores = append(m.Stores, StoreDetails{})
			if err := m.Stores[len(m.Stores)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StatementsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatementsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatementsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StatementsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatementsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatementsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Statements", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Statements = append(m.Statements, StatementsResponse_CollectedStatementStatistics{})
			if err := m.Statements[len(m.Statements)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastReset", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := types.StdTimeUnmarshal(&m.LastReset, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StatementsResponse_ExtendedStatementStatisticsKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExtendedStatementStatisticsKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExtendedStatementStatisticsKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyData", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.KeyData.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StatementsResponse_CollectedStatementStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CollectedStatementStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CollectedStatementStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Key.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStatus
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStatus(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStatus
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipStatus(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowStatus
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStatus
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthStatus
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowStatus
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipStatus(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthStatus = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowStatus   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("server/serverpb/status.proto", fileDescriptorStatus) }

var fileDescriptorStatus = []byte{
	// 4725 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x7b, 0xed, 0x6f, 0x24, 0x57,
	0x56, 0xf7, 0x94, 0xdd, 0xaf, 0xa7, 0xfd, 0xd2, 0xbe, 0xf6, 0xcc, 0xf4, 0xf4, 0x4c, 0xdc, 0x93,
	0x9a, 0x64, 0xe2, 0x99, 0x4c, 0xba, 0x13, 0x6f, 0xf2, 0x3c, 0x43, 0x20, 0x9b, 0xf8, 0x6d, 0x26,
	0xce, 0x38, 0x33, 0x9e, 0xb2, 0x9d, 0x45, 0x11, 0x4a, 0x51, 0xee, 0xba, 0x6e, 0xd7, 0xba, 0xba,
	0xaa, 0x5d, 0x55, 0x6d, 0xdc, 0x1b, 0x65, 0x09, 0x41, 0x8b, 0x58, 0x10, 0xcb, 0xee, 0xf2, 0x22,
	0x24, 0x40, 0x42, 0xfb, 0x01, 0x10, 0x12, 0x68, 0x11, 0x9f, 0xe0, 0xcb, 0x22, 0x84, 0x50, 0x3e,
	0x82, 0xe0, 0x03, 0x2f, 0x92, 0x03, 0x86, 0x0f, 0x20, 0xf1, 0x17, 0xac, 0x84, 0x84, 0xee, 0xb9,
	0xb7, 0xaa, 0x6f, 0x75, 0xf7, 0x54, 0xb7, 0xe3, 0xcc, 0x8a, 0x0f, 0x33, 0x5d, 0xf7, 0xe5, 0x9c,
	0xfb, 0xbb, 0xe7, 0xde, 0x7b, 0xce, 0xb9, 0xe7, 0x1e, 0xc3, 0x35, 0x9f, 0x7a, 0x47, 0xd4, 0xab,
	0xf1, 0x9f, 0xd6, 0x6e, 0xcd, 0x0f, 0x8c, 0xa0, 0xed, 0x57, 0x5b, 0x9e, 0x1b, 0xb8, 0xe4, 0x4a,
	0xdd, 0xad, 0x1f, 0x78, 0xae, 0x51, 0xdf, 0xaf, 0xf2, 0x0e, 0xd5, 0xb0, 0x5f, 0xb9, 0xb8, 0xdb,
	0xb6, 0x6c, 0xb3, 0x66, 0x39, 0x7b, 0x2e, 0xef, 0x5c, 0x9e, 0x6d, 0xb8, 0xbe, 0x6f, 0xb5, 0x6a,
	0xfc, 0x47, 0x54, 0x5e, 0x46, 0xea, 0xd6, 0x6e, 0xcd, 0x68, 0xb5, 0x74, 0xc6, 0x5b, 0xb0, 0x2e,
	0x93, 0xb0, 0xc1, 0x34, 0x02, 0x43, 0xd4, 0xdd, 0x14, 0x60, 0x4c, 0xcb, 0x68, 0x38, 0xae, 0x1f,
	0x58, 0x75, 0x9f, 0x75, 0xe8, 0x96, 0x44, 0xbf, 0x72, 0x08, 0x1a, 0xb1, 0xc6, 0x20, 0x97, 0x55,
	0x3f, 0x70, 0x3d, 0xa3, 0x41, 0x6b, 0xd4, 0x69, 0x58, 0x4e, 0xf8, 0xd3, 0xda, 0xad, 0x35, 0x8f,
	0xea, 0xf5, 0x88, 0x5e, 0xf4, 0xb1, 0xa9, 0xe1, 0x53, 0x3d, 0x46, 0x5f, 0x09, 0xdb, 0xc4, 0xef,
	0xae, 0xe1, 0x53, 0x1c, 0x81, 0x86, 0xc0, 0xdb, 0x81, 0x65, 0xd7, 0x6c, 0xb7, 0xc1, 0xfe, 0x85,
	0x0c, 0xb1, 0xae, 0xed, 0x78, 0xd4, 0x77, 0xed, 0x23, 0x6a, 0xea, 0x86, 0x69, 0x7a, 0xa2, 0xed,
	0x2a, 0x0d, 0xea, 0x66, 0xcd, 0x33, 0xf6, 0x02, 0xfc, 0xaf, 0xb5, 0x8b, 0x3f, 0xa2, 0x71, 0xae,
	0xe1, 0x36, 0x5c, 0xfc, 0xac, 0xb1, 0x2f, 0x51, 0x7b, 0xad, 0xe1, 0xba, 0x0d, 0x9b, 0xd6, 0x8c,
	0x96, 0x55, 0x33, 0x1c, 0xc7, 0x0d, 0x8c, 0xc0, 0x72, 0x9d, 0x08, 0xa1, 0x68, 0xc5, 0xd2, 0x6e,
	0x7b, 0xaf, 0x16, 0x58, 0x4d, 0xea, 0x07, 0x46, 0x53, 0xc8, 0x5c, 0xad, 0xc2, 0xec, 0x0a, 0xf5,
	0x02, 0x6b, 0xcf, 0xaa, 0x1b, 0x01, 0xf5, 0x35, 0x7a, 0xd8, 0xa6, 0x7e, 0x40, 0x2e, 0x43, 0xd6,
	0x71, 0x4d, 0xaa, 0x5b, 0x66, 0x49, 0xb9, 0xae, 0x2c, 0xe4, 0xb5, 0x0c, 0x2b, 0xae, 0x9b, 0xea,
	0xff, 0xa4, 0x80, 0x48, 0x04, 0xab, 0x34, 0x30, 0x2c, 0xdb, 0x27, 0x8f, 0x21, 0x15, 0x74, 0x5a,
	0x14, 0x3b, 0x4f, 0x2d, 0xbe, 0x51, 0x7d, 0xe2, 0x5e, 0xa8, 0xf6, 0x13, 0xcb, 0x55, 0xdb, 0x9d,
	0x16, 0xd5, 0x90, 0x15, 0xb9, 0x01, 0x93, 0xd4, 0xf3, 0x5c, 0x4f, 0x6f, 0x52, 0xdf, 0x37, 0x1a,
	0xb4, 0x34, 0x86, 0x40, 0x26, 0xb0, 0xf2, 0x5d, 0x5e, 0x47, 0x08, 0xa4, 0xd8, 0x9e, 0x28, 0x8d,
	0x5f, 0x57, 0x16, 0x26, 0x34, 0xfc, 0x26, 0x1a, 0x64, 0xf6, 0x2c, 0x6a, 0x9b, 0x7e, 0x29, 0x75,
	0x7d, 0x7c, 0xa1, 0xb0, 0xf8, 0xea, 0xd9, 0xd0, 0xdc, 0x43, 0xda, 0xe5, 0xd4, 0xa7, 0x27, 0x95,
	0x0b, 0x9a, 0xe0, 0x54, 0xfe, 0xb3, 0x31, 0xc8, 0xf0, 0x06, 0x72, 0x09, 0x32, 0x96, 0xef, 0xb7,
	0xa9, 0x17, 0x4a, 0x86, 0x97, 0x48, 0x09, 0xb2, 0x7e, 0x7b, 0xf7, 0xab, 0xb4, 0x1e, 0x08, 0xa4,
	0x61, 0x91, 0x3c, 0x03, 0x70, 0x64, 0xd8, 0x96, 0xa9, 0xef, 0x79, 0x6e, 0x13, 0xa1, 0x8e, 0x6b,
	0x79, 0xac, 0xb9, 0xe7, 0xb9, 0x4d, 0x52, 0x81, 0x02, 0x6f, 0x6e, 0x3b, 0x81, 0x65, 0x97, 0x52,
	0xd8, 0xce, 0x29, 0x76, 0x58, 0x0d, 0xb9, 0x06, 0x79, 0xb6, 0x47, 0xa8, 0xef, 0x53, 0xbf, 0x94,
	0xbe, 0x3e, 0xbe, 0x90, 0xd7, 0xba, 0x15, 0xa4, 0x06, 0xb3, 0xbe, 0xd5, 0x70, 0x8c, 0xa0, 0xed,
	0x51, 0xdd, 0xb0, 0x1b, 0xae, 0x67, 0x05, 0xfb, 0xcd, 0x52, 0x06, 0x31, 0x90, 0xa8, 0x69, 0x29,
	0x6c, 0x61, 0x70, 0x5a, 0xed, 0x5d, 0xdb, 0xaa, 0xeb, 0x07, 0xb4, 0x53, 0xca, 0x62, 0xbf, 0x3c,
	0xaf, 0x79, 0x40, 0x3b, 0xe4, 0x2a, 0xe4, 0x0f, 0x68, 0x47, 0x6f, 0xa3, 0xcc, 0x73, 0x38, 0x5a,
	0xee, 0x80, 0x76, 0x76, 0x50, 0xde, 0x77, 0x80, 0xd0, 0xe3, 0x80, 0x3a, 0x26, 0x35, 0xf5, 0x6e,
	0xaf, 0x3c, 0xf6, 0x2a, 0x86, 0x2d, 0x0f, 0x44, 0x6f, 0xf5, 0x31, 0x4c, 0xf7, 0xac, 0x2d, 0xc9,
	0xc0, 0xd8, 0xca, 0x52, 0xf1, 0x02, 0xc9, 0x41, 0xea, 0xe1, 0xa3, 0xd5, 0xb5, 0xa2, 0x42, 0x26,
	0x21, 0xbf, 0xb2, 0xb1, 0xbe, 0xf6, 0x70, 0x5b, 0x5f, 0x59, 0x2a, 0x8e, 0x11, 0x80, 0x0c, 0x2f,
	0x16, 0xc7, 0x49, 0x1e, 0xd2, 0x3b, 0xeb, 0xac, 0x3a, 0xc5, 0xe8, 0x76, 0xd6, 0x8b, 0x69, 0xd5,
	0x85, 0xb9, 0xf8, 0x7e, 0xf5, 0x5b, 0xae, 0xe3, 0x53, 0xf2, 0x15, 0x98, 0xa8, 0x4b, 0xf5, 0x25,
	0x05, 0x97, 0xfe, 0xa5, 0x33, 0x2d, 0xbd, 0x58, 0xf3, 0x18, 0x23, 0xf5, 0x4d, 0x98, 0x12, 0xcd,
	0xc3, 0xce, 0x06, 0x99, 0x83, 0xb4, 0x47, 0x0d, 0xb3, 0x83, 0xeb, 0x9f, 0xd3, 0x78, 0x41, 0xfd,
	0x2f, 0x05, 0xa6, 0x23, 0x0e, 0x02, 0xed, 0xfb, 0x71, 0x16, 0xe9, 0xe5, 0xa5, 0xd3, 0x93, 0x4a,
	0xe6, 0x21, 0x63, 0xb3, 0xfa, 0xc3, 0x93, 0xca, 0x97, 0x1a, 0x56, 0xb0, 0xdf, 0xde, 0xad, 0xd6,
	0xdd, 0x66, 0x2d, 0x9a, 0x80, 0xb9, 0xdb, 0xfd, 0xae, 0xb5, 0x0e, 0x1a, 0x35, 0xa1, 0x14, 0xab,
	0x9c, 0x2c, 0x42, 0xf1, 0x65, 0xc8, 0x8a, 0xcd, 0x81, 0x38, 0x0a, 0x8b, 0xf3, 0x92, 0x10, 0x98,
	0xee, 0xa9, 0xee, 0x44, 0xba, 0x67, 0xc9, 0x34, 0x3d, 0x31, 0xeb, 0x90, 0x88, 0xbc, 0x0e, 0x80,
	0xea, 0x5a, 0x67, 0xea, 0x1a, 0x77, 0x6b, 0x61, 0xf1, 0xa2, 0xc4, 0x02, 0x1b, 0xab, 0xeb, 0xce,
	0x9e, 0x2b, 0x28, 0xf3, 0x58, 0xc3, 0x2a, 0xd4, 0x29, 0x98, 0x60, 0x68, 0x42, 0x51, 0xa9, 0x9b,
	0x30, 0x29, 0xca, 0x62, 0xe2, 0x6f, 0x42, 0x9a, 0xc1, 0x0c, 0xd7, 0xe7, 0xc6, 0x80, 0xf5, 0xe1,
	0x0a, 0x96, 0x91, 0x6d, 0xe1, 0xa7, 0x18, 0x85, 0xd3, 0xa9, 0x37, 0xa1, 0xc0, 0x9a, 0x86, 0xea,
	0xa9, 0xef, 0xa7, 0x20, 0xaf, 0x19, 0x7b, 0x01, 0xe3, 0xc1, 0xb6, 0x2d, 0x78, 0xb4, 0x65, 0x5b,
	0x75, 0x23, 0xec, 0x99, 0x5a, 0x9e, 0x3c, 0x3d, 0xa9, 0xe4, 0x35, 0x5e, 0xbb, 0xbe, 0xaa, 0xe5,
	0x45, 0x87, 0x75, 0x93, 0xfc, 0x3f, 0x80, 0x7d, 0xc3, 0x33, 0x51, 0xd7, 0x53, 0x21, 0xc4, 0x99,
	0x2a, 0x57, 0xc8, 0xd5, 0xb7, 0x0d, 0xcf, 0x44, 0xa6, 0xe1, 0xec, 0xf7, 0xc3, 0x0a, 0xa6, 0x8c,
	0x6c, 0x6a, 0x98, 0x28, 0xb3, 0x94, 0x86, 0xdf, 0x6c, 0x4f, 0x70, 0x36, 0x29, 0x84, 0xc7, 0x0b,
	0x4c, 0x57, 0x18, 0xad, 0x96, 0x6d, 0x51, 0xb3, 0x94, 0xc6, 0xce, 0x61, 0x91, 0x6c, 0x43, 0xae,
	0xe5, 0xb9, 0x0d, 0x5c, 0xbe, 0x0c, 0xca, 0x68, 0x31, 0x61, 0x0f, 0x47, 0x33, 0xac, 0x6e, 0x0a,
	0xa2, 0x35, 0x27, 0xf0, 0x3a, 0x02, 0x5a, 0xc4, 0x89, 0xbc, 0x00, 0xd3, 0x0c, 0x8d, 0x1e, 0x78,
	0x86, 0xe3, 0xef, 0x51, 0x8f, 0x52, 0x3c, 0xf7, 0x29, 0x6d, 0x8a, 0x55, 0x6f, 0x47, 0xb5, 0xe5,
	0x5f, 0x51, 0x20, 0x17, 0xb2, 0x62, 0xd8, 0x9b, 0x46, 0x50, 0xdf, 0xe7, 0x02, 0xd3, 0x78, 0x81,
	0xcd, 0xd2, 0xa1, 0xc7, 0x5c, 0xc9, 0xa5, 0x34, 0xfc, 0xee, 0xce, 0x72, 0x5c, 0x9e, 0xe5, 0x25,
	0xc8, 0xb4, 0x8c, 0xb6, 0x4f, 0x4d, 0x9c, 0x7c, 0x4e, 0x13, 0x25, 0x72, 0x0b, 0x8a, 0x2d, 0xea,
	0x98, 0x96, 0xd3, 0xd0, 0x7d, 0xc7, 0x68, 0xf9, 0xfb, 0x6e, 0x20, 0xc4, 0x30, 0x2d, 0xea, 0xb7,
	0x44, 0x75, 0xf9, 0xab, 0x30, 0x19, 0x9b, 0x19, 0x29, 0xc2, 0x38, 0xd3, 0x5a, 0x1c, 0x11, 0xfb,
	0x24, 0x2b, 0x90, 0x3e, 0x32, 0xec, 0x76, 0xb8, 0x50, 0x2f, 0x9d, 0x49, 0x5c, 0x1a, 0xa7, 0x7d,
	0x7d, 0xec, 0xae, 0xa2, 0xfe, 0xc5, 0x18, 0x4c, 0x6a, 0x86, 0xd3, 0xa0, 0x9b, 0x9e, 0xbb, 0x6b,
	0xd3, 0xa6, 0x4f, 0xae, 0x43, 0xa1, 0xed, 0x18, 0x47, 0x86, 0x65, 0x1b, 0xbb, 0x36, 0x37, 0x6e,
	0x39, 0x4d, 0xae, 0x22, 0xaf, 0xc1, 0x65, 0x26, 0x41, 0xea, 0xe9, 0x8e, 0x1b, 0xe8, 0xdc, 0x45,
	0xd8, 0x77, 0x6d, 0x93, 0x7a, 0x42, 0x09, 0xcc, 0xf1, 0xe6, 0x87, 0x6e, 0xb0, 0xc1, 0x1a, 0xdf,
	0xc6, 0x36, 0xf2, 0x1c, 0x4c, 0x39, 0xae, 0xce, 0x76, 0x94, 0xce, 0xdb, 0x51, 0x70, 0x39, 0x6d,
	0xc2, 0x71, 0x19, 0xc6, 0x0d, 0xac, 0x23, 0x0b, 0x30, 0xdd, 0x76, 0x4c, 0xea, 0x89, 0x9d, 0x19,
	0x44, 0x82, 0xec, 0xad, 0x26, 0x57, 0x20, 0xe7, 0xb8, 0x7c, 0x78, 0x94, 0x64, 0x4e, 0xcb, 0x3a,
	0x2e, 0x0e, 0x48, 0xee, 0x42, 0xe9, 0xb0, 0x6d, 0x51, 0xbf, 0x4e, 0x9d, 0x40, 0xa7, 0x87, 0x6d,
	0xc3, 0xf6, 0xf5, 0xc0, 0xaa, 0x1f, 0x58, 0x4e, 0x03, 0x6d, 0x44, 0x4e, 0xbb, 0x14, 0xb5, 0xaf,
	0x61, 0xf3, 0x36, 0x6f, 0x25, 0x2f, 0x02, 0xe1, 0x08, 0xdd, 0x86, 0x1e, 0xb8, 0xae, 0x6e, 0x1b,
	0x5e, 0x83, 0xef, 0x9b, 0x9c, 0x36, 0xcd, 0x5a, 0x36, 0xdc, 0xc6, 0xb6, 0xeb, 0x6e, 0xb0, 0x6a,
	0xf5, 0x00, 0xa6, 0x51, 0x76, 0x4c, 0xbc, 0x16, 0xfa, 0x5f, 0xcc, 0x56, 0x1c, 0xb6, 0xa9, 0x67,
	0x51, 0x5f, 0x6f, 0x51, 0x4f, 0xf7, 0x69, 0xdd, 0x75, 0xf8, 0xe1, 0x53, 0xb4, 0xa2, 0x68, 0xd9,
	0xa4, 0xde, 0x16, 0xd6, 0x93, 0xdb, 0x30, 0xf3, 0x33, 0x9e, 0x15, 0xc4, 0x3b, 0x8f, 0x61, 0xe7,
	0x69, 0xde, 0x10, 0xf5, 0x55, 0xdf, 0x06, 0xd8, 0xf4, 0x68, 0x10, 0x74, 0xb6, 0x5a, 0x86, 0xc3,
	0x0c, 0x96, 0x1f, 0x18, 0x5e, 0xa0, 0x87, 0x1b, 0x23, 0xaf, 0xe5, 0xb0, 0x82, 0x59, 0xb3, 0xcb,
	0x90, 0xa5, 0x0e, 0xda, 0x2a, 0x61, 0x95, 0x33, 0xd4, 0x61, 0x06, 0xea, 0xf5, 0xd4, 0x7f, 0xfe,
	0x5e, 0x45, 0x51, 0xff, 0x48, 0x81, 0xd9, 0x15, 0xb7, 0xd9, 0x34, 0x1c, 0xf3, 0x71, 0x9b, 0xb6,
	0xe9, 0xbb, 0x34, 0xf0, 0x18, 0xf6, 0xe7, 0x61, 0x0a, 0x07, 0xd5, 0xeb, 0xbc, 0xd1, 0x47, 0xc6,
	0xe3, 0xda, 0x24, 0xd6, 0x0a, 0x0a, 0x9f, 0xf9, 0x28, 0x4c, 0xc9, 0x77, 0x7b, 0x8d, 0x61, 0xaf,
	0x09, 0x56, 0x19, 0x75, 0xba, 0x0d, 0x33, 0x4d, 0xe3, 0x58, 0x77, 0x8f, 0xa8, 0x67, 0x1b, 0x2d,
	0x5f, 0xf7, 0x29, 0x75, 0x84, 0x17, 0x30, 0xdd, 0x34, 0x8e, 0x1f, 0x89, 0xfa, 0x2d, 0x4a, 0x71,
	0x2e, 0x81, 0x47, 0xa9, 0xee, 0x5b, 0x5f, 0xe3, 0x2a, 0x23, 0xad, 0xe5, 0x58, 0xc5, 0x96, 0xf5,
	0x35, 0xaa, 0xfe, 0x77, 0x96, 0xe9, 0x34, 0xa7, 0x41, 0x99, 0xae, 0x25, 0x6f, 0x42, 0xca, 0x6f,
	0x19, 0x0e, 0x02, 0x2b, 0x2c, 0x3e, 0x9f, 0xb0, 0xed, 0xbb, 0xb2, 0x12, 0x8a, 0x01, 0x09, 0xc9,
	0x3a, 0x00, 0xae, 0xaf, 0xac, 0xe6, 0x9e, 0x1b, 0xe5, 0xf4, 0x84, 0x9a, 0xcf, 0x8b, 0xf4, 0xeb,
	0xaa, 0xac, 0xe5, 0x0a, 0x8b, 0x0b, 0x32, 0x17, 0xee, 0x1a, 0x57, 0x25, 0x17, 0xb9, 0x1a, 0x4d,
	0x22, 0xd4, 0xed, 0x5c, 0x5f, 0x34, 0x61, 0xca, 0x77, 0xdb, 0x5e, 0x9d, 0xea, 0xa1, 0x4e, 0x4f,
	0xa3, 0x71, 0xbc, 0x7f, 0x7a, 0x52, 0x99, 0xd8, 0xc2, 0x96, 0xf3, 0x99, 0xc8, 0x09, 0xbf, 0xcb,
	0xc4, 0x24, 0x87, 0x30, 0x2d, 0x86, 0x63, 0xd8, 0x70, 0xbc, 0x0c, 0x8e, 0xb7, 0x7e, 0x7a, 0x52,
	0x99, 0xe4, 0xe3, 0x6d, 0xb1, 0x16, 0x1c, 0xf0, 0xd5, 0x33, 0x0d, 0x28, 0xe8, 0xb4, 0x49, 0x5f,
	0x62, 0x63, 0xf6, 0xfb, 0xb4, 0xd9, 0x01, 0x3e, 0xed, 0x0a, 0x4c, 0x0a, 0x45, 0x62, 0x31, 0x60,
	0x1d, 0x74, 0xc2, 0x0a, 0x8b, 0x25, 0x49, 0xa8, 0xe1, 0x30, 0x78, 0xc4, 0x43, 0xb7, 0x05, 0x89,
	0xde, 0xe6, 0x34, 0xe4, 0x1d, 0xb4, 0x23, 0xa8, 0xc6, 0x4a, 0xf9, 0xfe, 0x45, 0xe9, 0x5b, 0x5a,
	0x49, 0xed, 0x49, 0xd6, 0x83, 0xab, 0xc1, 0x7b, 0x7c, 0x75, 0xfd, 0x12, 0x20, 0xa3, 0xdb, 0xc3,
	0x18, 0x75, 0x75, 0x80, 0xbc, 0xbe, 0x3e, 0xd9, 0x86, 0x42, 0xbd, 0x69, 0xea, 0x87, 0xba, 0xed,
	0xd6, 0x0d, 0xbb, 0x54, 0x40, 0x6e, 0xd5, 0x24, 0x17, 0xad, 0xff, 0x64, 0x86, 0x7b, 0xaf, 0xde,
	0x34, 0x1f, 0x6f, 0x30, 0x36, 0xe4, 0x3d, 0x98, 0xe0, 0x5c, 0x1b, 0xb6, 0xbb, 0x6b, 0xd8, 0xa5,
	0x89, 0x73, 0xb0, 0x05, 0xc6, 0xf6, 0x3e, 0xf2, 0x21, 0xf7, 0x61, 0x42, 0xbe, 0xf2, 0x95, 0x26,
	0xfb, 0x9c, 0xa9, 0x70, 0x6b, 0xe3, 0x2a, 0xc4, 0x9c, 0x95, 0x82, 0xdd, 0xad, 0x62, 0xee, 0x7b,
	0xa4, 0x61, 0x4b, 0x53, 0xa8, 0x3e, 0xbb, 0x15, 0xcc, 0x15, 0x08, 0xd5, 0xf1, 0x34, 0xd7, 0xdc,
	0xa2, 0xa8, 0xfe, 0xb2, 0x22, 0xec, 0xd1, 0x70, 0xcf, 0xd3, 0x80, 0xbc, 0xc7, 0x7a, 0xea, 0x16,
	0xea, 0xa0, 0xf1, 0x85, 0xf1, 0xe5, 0xd5, 0xd3, 0x93, 0x4a, 0x8e, 0x1f, 0xb4, 0x55, 0xff, 0xcc,
	0xfb, 0x57, 0x10, 0x6a, 0x39, 0x64, 0xbb, 0x6e, 0xfa, 0xea, 0x36, 0x4c, 0x85, 0x60, 0x84, 0x2f,
	0xb7, 0x0c, 0x19, 0x6c, 0x0d, 0x9d, 0xb9, 0xe7, 0x86, 0xed, 0x0b, 0xe9, 0xc4, 0x0b, 0x4a, 0x75,
	0x01, 0x26, 0xef, 0x63, 0x08, 0x60, 0xa8, 0x43, 0xf7, 0xd3, 0x00, 0xdb, 0x9e, 0x51, 0xa7, 0x6b,
	0x47, 0x4c, 0x6a, 0x77, 0x21, 0xc5, 0x6e, 0xb2, 0x42, 0xf9, 0x95, 0xab, 0xfc, 0x9a, 0x5b, 0x0d,
	0xaf, 0xb9, 0xd5, 0xed, 0xf0, 0x9a, 0xbb, 0x9c, 0x63, 0xe3, 0x7d, 0xfb, 0xb3, 0x8a, 0xa2, 0x21,
	0x05, 0x93, 0x77, 0xfc, 0x42, 0x19, 0x16, 0xd5, 0xef, 0x2b, 0x30, 0xbd, 0x64, 0xb3, 0xbd, 0x19,
	0xb8, 0xde, 0xaa, 0xd7, 0xd1, 0xda, 0x0e, 0xf9, 0x00, 0x72, 0xa1, 0x60, 0xb9, 0x05, 0x58, 0x5e,
	0x39, 0x3d, 0xa9, 0x64, 0x85, 0x78, 0x3e, 0xb7, 0x58, 0xb3, 0x42, 0xac, 0xe4, 0x0d, 0xc8, 0x50,
	0x36, 0x21, 0xbe, 0x6a, 0xc9, 0x6a, 0xbc, 0x3b, 0x7d, 0x4d, 0x10, 0xa9, 0x8b, 0x70, 0x31, 0x42,
	0x8c, 0xbc, 0x43, 0x31, 0x5e, 0xe9, 0xc5, 0x1d, 0x0d, 0xa9, 0xfe, 0xb9, 0x02, 0x97, 0x7a, 0x89,
	0x06, 0x5f, 0x4b, 0xc6, 0xbf, 0xc8, 0x6b, 0xc9, 0x0a, 0x64, 0x4d, 0xaf, 0xa3, 0x7b, 0x6d, 0x47,
	0x98, 0x9a, 0x24, 0x35, 0xd2, 0xb3, 0x0c, 0x5a, 0xc6, 0xc4, 0x5f, 0xf5, 0x5b, 0x0a, 0x14, 0xbb,
	0xd8, 0xff, 0x0f, 0x9c, 0x8a, 0xf7, 0x61, 0x46, 0xc2, 0x23, 0xc4, 0xb8, 0x06, 0x39, 0x31, 0xd5,
	0xf0, 0x68, 0x9c, 0x65, 0xae, 0x59, 0x3e, 0x57, 0x5f, 0x55, 0x61, 0xe2, 0x9d, 0xad, 0x47, 0x0f,
	0x23, 0xb6, 0x61, 0xac, 0x43, 0xe9, 0xc6, 0x3a, 0xd4, 0xef, 0x29, 0x50, 0xd8, 0x70, 0x1b, 0x23,
	0xdd, 0x4d, 0x6d, 0x7a, 0x44, 0x6d, 0xb1, 0xe9, 0x79, 0x81, 0x3c, 0x03, 0xc0, 0x5d, 0x27, 0x3c,
	0x4c, 0xdc, 0x79, 0xe7, 0xce, 0x14, 0x3b, 0x40, 0x6c, 0x17, 0x31, 0xe7, 0x09, 0x1b, 0xf9, 0xfd,
	0x85, 0x39, 0x53, 0xd8, 0x54, 0x84, 0xf1, 0xa6, 0x71, 0x8c, 0x06, 0x3a, 0xaf, 0xb1, 0x4f, 0x76,
	0xb0, 0x5a, 0x46, 0x10, 0x50, 0xcf, 0x11, 0xb1, 0x87, 0xb0, 0xa8, 0x3e, 0x02, 0xb2, 0xe1, 0x36,
	0x98, 0xff, 0x6e, 0x49, 0xea, 0xe3, 0xc7, 0x98, 0x67, 0x86, 0x55, 0x42, 0x48, 0x57, 0x7a, 0xef,
	0xa9, 0xb6, 0xdb, 0xa8, 0xca, 0xf7, 0x99, 0xb0, 0xbf, 0x5a, 0x85, 0xd9, 0x0d, 0xb7, 0x71, 0xcf,
	0xb2, 0xa9, 0xbf, 0x61, 0xf9, 0xc1, 0x50, 0xdd, 0xb1, 0x09, 0x73, 0xf1, 0xfe, 0x02, 0xc2, 0x5d,
	0x48, 0xef, 0xb1, 0x4a, 0x01, 0xe0, 0xda, 0x20, 0x00, 0x8c, 0x4a, 0x76, 0x55, 0x90, 0x40, 0x7d,
	0x03, 0xa6, 0x04, 0xc7, 0xa1, 0x92, 0x27, 0x90, 0x62, 0x34, 0x42, 0xf0, 0xf8, 0xcd, 0xd4, 0xde,
	0x56, 0x60, 0xd4, 0x0f, 0x86, 0xc7, 0xdb, 0xb6, 0x20, 0xc5, 0x46, 0xc1, 0x5b, 0x97, 0x21, 0x14,
	0x5e, 0x5e, 0xc3, 0x6f, 0xe6, 0x2c, 0x32, 0x6e, 0xdc, 0x59, 0xe4, 0x9e, 0x67, 0x8e, 0x55, 0x30,
	0x67, 0x91, 0x94, 0x21, 0x57, 0x77, 0x9d, 0x00, 0x75, 0x0b, 0x8f, 0x8e, 0x45, 0x65, 0xf5, 0x77,
	0x14, 0x98, 0xbe, 0x4f, 0x03, 0x14, 0xc8, 0x50, 0xfc, 0x57, 0x21, 0x6f, 0x5b, 0x7e, 0xa0, 0xbb,
	0x8e, 0x1d, 0x46, 0x36, 0x72, 0xac, 0xe2, 0x91, 0x63, 0x77, 0xc8, 0xff, 0x17, 0x71, 0xbf, 0x34,
	0xc6, 0xfd, 0x6e, 0x24, 0x6c, 0x73, 0x36, 0x98, 0x14, 0xdd, 0x2b, 0x43, 0x4e, 0x6c, 0x0f, 0x7e,
	0xcf, 0xcd, 0x6b, 0x51, 0x59, 0x5d, 0x87, 0x62, 0x17, 0x9d, 0x58, 0xaa, 0xd7, 0xe2, 0x4b, 0x55,
	0x19, 0x32, 0x52, 0xb8, 0x4e, 0x3f, 0x0b, 0x53, 0x9b, 0x9e, 0xbb, 0x37, 0xca, 0x3a, 0x2d, 0xc7,
	0xa6, 0x52, 0x4d, 0xf4, 0xa7, 0x65, 0x8e, 0xd5, 0xee, 0xac, 0xd4, 0x22, 0xa4, 0x30, 0xca, 0x95,
	0x83, 0xd4, 0xdb, 0x6b, 0x4b, 0x9b, 0xc5, 0x0b, 0xea, 0x2d, 0x98, 0x12, 0x2e, 0xc6, 0xd0, 0xa5,
	0xfe, 0x63, 0xb4, 0xf7, 0x7b, 0x01, 0x6a, 0x19, 0xa6, 0x3d, 0x9f, 0x6a, 0x98, 0xe8, 0x2d, 0x48,
	0xa3, 0x16, 0x1b, 0xc9, 0xf1, 0xef, 0x71, 0xd7, 0x91, 0x50, 0xbd, 0xcd, 0x3c, 0x02, 0x01, 0x77,
	0x8d, 0x39, 0xb0, 0xb2, 0x6d, 0x55, 0xe2, 0xb6, 0xf5, 0xe3, 0x31, 0x76, 0x3f, 0x14, 0x9d, 0x85,
	0x5f, 0xf4, 0xb4, 0x6d, 0xeb, 0x7d, 0xc8, 0xa0, 0x5f, 0x1d, 0xda, 0xd6, 0x5b, 0x43, 0xee, 0x36,
	0xdd, 0x89, 0x84, 0x4e, 0x0a, 0x27, 0x67, 0xb7, 0x1b, 0x1e, 0xb4, 0x1a, 0x47, 0x3e, 0x0b, 0xa3,
	0xf0, 0x61, 0xd2, 0x8e, 0x47, 0xae, 0xda, 0x50, 0x64, 0xad, 0xab, 0x74, 0xb7, 0xdd, 0x08, 0xf7,
	0x42, 0xcc, 0x42, 0x29, 0x4f, 0xc5, 0x42, 0xfd, 0xc3, 0x18, 0xcc, 0x48, 0xe3, 0x8a, 0xe3, 0xf4,
	0x2d, 0xa5, 0xc7, 0x79, 0xbb, 0x3b, 0x64, 0x52, 0x31, 0x72, 0x3e, 0x8c, 0x88, 0x35, 0xfd, 0x04,
	0x9b, 0xe4, 0x27, 0x9f, 0x7d, 0x4e, 0xa0, 0x02, 0xc5, 0x17, 0xb6, 0x58, 0x65, 0x0a, 0x05, 0x09,
	0x9d, 0x1c, 0x2f, 0x1a, 0xe7, 0xf1, 0xa2, 0xb7, 0xe2, 0xf1, 0xa2, 0xdb, 0xa3, 0x0c, 0xc4, 0x77,
	0xac, 0x1c, 0x2c, 0xfa, 0xc6, 0x18, 0x14, 0x96, 0xea, 0x81, 0x75, 0x44, 0x1f, 0xb7, 0xa9, 0xd7,
	0x21, 0x97, 0x60, 0x2c, 0x3c, 0xd0, 0xcb, 0x99, 0xd3, 0x93, 0xca, 0xd8, 0xfa, 0xaa, 0x36, 0x66,
	0x99, 0x6c, 0x7c, 0xff, 0x30, 0xb4, 0xba, 0xec, 0x93, 0xbc, 0x8e, 0xb7, 0x29, 0x2f, 0x10, 0xa1,
	0xd5, 0xd1, 0x7c, 0x57, 0x4e, 0x42, 0x9e, 0x87, 0x29, 0xcb, 0xd7, 0x4d, 0xcb, 0x0f, 0x3c, 0x6b,
	0xb7, 0xdd, 0x0d, 0x08, 0x4d, 0x5a, 0xfe, 0x6a, 0xb7, 0x92, 0x2c, 0x43, 0xba, 0xb5, 0x1f, 0xc6,
	0x82, 0xa6, 0x16, 0xef, 0x24, 0x79, 0x1f, 0xdd, 0x39, 0x54, 0x37, 0x19, 0x8d, 0xc6, 0x49, 0xd5,
	0xe7, 0x21, 0x8d, 0x65, 0x32, 0x09, 0xf9, 0x4d, 0x6d, 0x6d, 0x73, 0x49, 0x5b, 0x7f, 0x78, 0xbf,
	0x78, 0x81, 0x15, 0xd7, 0x7e, 0x72, 0x6d, 0x65, 0x67, 0x9b, 0x15, 0x15, 0xf5, 0x15, 0x98, 0x65,
	0x26, 0x75, 0x8b, 0xfa, 0xbe, 0xe5, 0x3a, 0x91, 0x92, 0x2b, 0x43, 0xae, 0xed, 0x53, 0x4f, 0x32,
	0x59, 0x51, 0x59, 0xfd, 0xbb, 0x14, 0x64, 0x45, 0xff, 0xa7, 0xaa, 0xe1, 0x64, 0x0c, 0x63, 0x71,
	0x0c, 0x4c, 0x90, 0x75, 0xdb, 0xa2, 0x4e, 0xa0, 0x87, 0xb1, 0x72, 0xee, 0xfc, 0x4c, 0xf2, 0xda,
	0x25, 0x11, 0x0b, 0xbf, 0x05, 0x45, 0x0c, 0xcc, 0xd6, 0xf1, 0x51, 0x4d, 0x47, 0x56, 0xdc, 0x11,
	0x9a, 0x96, 0xea, 0x1f, 0x32, 0x8e, 0x5b, 0x30, 0x65, 0xa0, 0x2c, 0x75, 0x11, 0xda, 0xc2, 0x97,
	0x9a, 0xc2, 0xe2, 0xcd, 0xd1, 0x84, 0x2f, 0x76, 0xf1, 0xa4, 0x11, 0x55, 0x59, 0xd4, 0xef, 0xee,
	0x95, 0xcc, 0xd9, 0xf7, 0xca, 0x07, 0x90, 0x3f, 0x38, 0xd2, 0x83, 0x63, 0x87, 0x09, 0x37, 0xcb,
	0x3c, 0x80, 0xe5, 0xe5, 0x7f, 0x1e, 0x55, 0xa4, 0xfc, 0x8d, 0xb2, 0x6d, 0x99, 0xd5, 0x9d, 0x9d,
	0x75, 0xa6, 0x92, 0xb2, 0x0f, 0x8e, 0xb6, 0x8f, 0x1d, 0xa6, 0x5e, 0x0f, 0xf0, 0x03, 0x03, 0x76,
	0xb6, 0xe1, 0x07, 0xba, 0x34, 0xeb, 0x4e, 0x29, 0xc7, 0x85, 0xc3, 0x1a, 0xfa, 0x4f, 0x47, 0x1e,
	0x41, 0xc8, 0xa7, 0xa3, 0x02, 0x05, 0x83, 0xb9, 0xbf, 0xfa, 0x6e, 0x27, 0xa0, 0x3c, 0xbe, 0x30,
	0xae, 0x01, 0x56, 0x2d, 0xb3, 0x1a, 0x72, 0x13, 0xa6, 0x9b, 0xc6, 0xb1, 0x2e, 0x77, 0x2a, 0xf0,
	0x40, 0x5c, 0xd3, 0x38, 0x5e, 0x8a, 0xfa, 0xa9, 0xdf, 0x54, 0x60, 0x46, 0xde, 0x87, 0xdc, 0x1e,
	0x3d, 0xcd, 0xdd, 0xf5, 0xe4, 0x7b, 0xe4, 0x1f, 0x2a, 0x30, 0x17, 0x3f, 0x13, 0x42, 0xe9, 0xae,
	0x42, 0xce, 0x17, 0x75, 0x42, 0xeb, 0xaa, 0x09, 0x9b, 0x43, 0x90, 0x87, 0xd1, 0x98, 0x90, 0x92,
	0xbc, 0xd3, 0xa3, 0x29, 0x93, 0x4e, 0x77, 0x9f, 0x48, 0xe2, 0xca, 0x52, 0x3d, 0x04, 0xb2, 0x62,
	0x38, 0x75, 0x6a, 0xe3, 0x32, 0x0d, 0x75, 0x91, 0x6e, 0x42, 0x0e, 0x97, 0x99, 0xb5, 0xe0, 0xa4,
	0x97, 0x0b, 0x6c, 0x6b, 0x20, 0x31, 0xdb, 0x1a, 0xd8, 0xd8, 0x73, 0xf2, 0xc6, 0x7b, 0x4e, 0xff,
	0x7d, 0x98, 0x8d, 0x0d, 0x29, 0x64, 0xc3, 0xdc, 0x55, 0xac, 0xa6, 0xa6, 0x88, 0xb3, 0x47, 0x65,
	0x76, 0x77, 0x41, 0xbc, 0xe1, 0xdd, 0x05, 0x0b, 0x6a, 0x07, 0xe6, 0x38, 0x23, 0x31, 0xc1, 0xa1,
	0xe8, 0xef, 0x00, 0x08, 0x21, 0x86, 0xf8, 0x27, 0xf8, 0x23, 0x90, 0x60, 0xb0, 0xbe, 0xaa, 0xe5,
	0x45, 0x87, 0x21, 0x73, 0x58, 0x87, 0x8b, 0x3d, 0x43, 0x7f, 0xee, 0x59, 0xfc, 0x8b, 0x02, 0xc5,
	0xad, 0x96, 0xe1, 0x30, 0x0b, 0x13, 0x69, 0xcf, 0x1b, 0x3d, 0x53, 0x58, 0x86, 0xee, 0xbe, 0x8d,
	0xa6, 0xa3, 0xc9, 0x61, 0x6f, 0x3e, 0x9b, 0xd7, 0x7e, 0x78, 0x52, 0x79, 0xe5, 0x6c, 0x66, 0xf8,
	0x01, 0xed, 0x48, 0xd1, 0xf2, 0x87, 0xdd, 0x68, 0xf9, 0xf8, 0x79, 0x38, 0x8a, 0x20, 0xbb, 0xfa,
	0x03, 0x05, 0x66, 0xa4, 0xd9, 0x09, 0x29, 0x6d, 0x41, 0x21, 0x70, 0x03, 0xc3, 0xe6, 0x39, 0x1e,
	0x22, 0x86, 0x73, 0x67, 0x40, 0x60, 0x8d, 0xe7, 0x63, 0x54, 0xc3, 0xb4, 0x8c, 0xea, 0xbb, 0xef,
	0xad, 0xac, 0x20, 0xab, 0x30, 0x5c, 0x87, 0x6c, 0xb0, 0x86, 0xa9, 0x12, 0xee, 0x4a, 0xd5, 0xdd,
	0xb6, 0xc3, 0x5f, 0xa7, 0xd2, 0x1a, 0x60, 0xd5, 0x0a, 0xab, 0x21, 0xaf, 0xc2, 0x25, 0xa3, 0xd5,
	0xf2, 0xdc, 0x63, 0xab, 0x69, 0x04, 0x94, 0x19, 0xd1, 0x03, 0xa1, 0x51, 0xf8, 0x7b, 0xdd, 0x9c,
	0xd4, 0xba, 0x6a, 0xf9, 0x07, 0x5c, 0xb1, 0xfc, 0x38, 0xcc, 0x89, 0xb8, 0x68, 0x3c, 0x14, 0x37,
	0xca, 0x12, 0xa9, 0xdf, 0x9c, 0x80, 0x8b, 0x3d, 0xd4, 0xfd, 0x91, 0x96, 0xdc, 0x17, 0xad, 0x99,
	0xfe, 0x46, 0x81, 0xd9, 0x30, 0x76, 0xab, 0xef, 0x76, 0xa2, 0x60, 0x7a, 0x1e, 0xd5, 0xc5, 0xbd,
	0xe4, 0x8b, 0x4d, 0x3f, 0xd6, 0x6a, 0x14, 0x17, 0xee, 0xf0, 0xc0, 0x39, 0x77, 0xfb, 0x1e, 0xb1,
	0x15, 0x38, 0x3d, 0xa9, 0x14, 0x7b, 0x9a, 0x57, 0x3f, 0xf9, 0xec, 0xf3, 0xc1, 0x2f, 0xb6, 0x7a,
	0xc6, 0x29, 0xff, 0x20, 0xc7, 0x9f, 0x93, 0xa3, 0xf7, 0xb8, 0xbe, 0xf0, 0xb9, 0x32, 0x20, 0x7c,
	0xfe, 0xf3, 0x0a, 0x5c, 0x94, 0x9e, 0xe8, 0xf4, 0xde, 0x10, 0xd0, 0xa3, 0xd3, 0x93, 0xca, 0xec,
	0x4e, 0xb7, 0xc3, 0xb9, 0x7d, 0xed, 0xd9, 0x76, 0x2f, 0x33, 0xd3, 0x27, 0x7f, 0xa2, 0xc0, 0x4d,
	0xe9, 0x7d, 0xaf, 0xef, 0x79, 0x50, 0x82, 0x35, 0x8e, 0xb0, 0x7e, 0xea, 0xf4, 0xa4, 0x72, 0xbd,
	0xfb, 0xf8, 0x17, 0x7f, 0x30, 0x3c, 0x37, 0xc6, 0xeb, 0x5e, 0x22, 0x67, 0xd3, 0x27, 0xbf, 0xa8,
	0x40, 0x29, 0xfe, 0x26, 0x29, 0x41, 0x4c, 0x21, 0xc4, 0xcd, 0xd3, 0x93, 0xca, 0xdc, 0x43, 0xe9,
	0x85, 0xf2, 0xdc, 0xb0, 0xe6, 0x9c, 0x3e, 0x6e, 0xa6, 0x4f, 0x8e, 0x81, 0x84, 0xaf, 0x99, 0x12,
	0x86, 0x34, 0x62, 0x78, 0x70, 0x7a, 0x52, 0x99, 0x7e, 0xc8, 0xdf, 0x36, 0xcf, 0x3d, 0xfc, 0xb4,
	0x23, 0x33, 0x32, 0x7d, 0xf2, 0xab, 0x0a, 0x5c, 0xe9, 0x79, 0x5b, 0x95, 0x10, 0x64, 0x10, 0xc1,
	0xd6, 0xe9, 0x49, 0xe5, 0xf2, 0x4e, 0xbc, 0xd3, 0xb9, 0x91, 0x5c, 0x6e, 0x0f, 0x62, 0x68, 0xfa,
	0xe4, 0xf7, 0x15, 0x50, 0x9f, 0xf4, 0x7e, 0x2b, 0x41, 0xcb, 0x22, 0xb4, 0xf7, 0x4f, 0x4f, 0x2a,
	0xf3, 0x8f, 0x07, 0xbe, 0xe6, 0x9e, 0x1b, 0xe1, 0xfc, 0x61, 0x02, 0x5f, 0xd3, 0x27, 0xdf, 0x55,
	0xe0, 0x5a, 0xff, 0x73, 0xb1, 0x04, 0x31, 0xd7, 0x95, 0x9e, 0x16, 0x7f, 0x3c, 0x3e, 0xbf, 0xf4,
	0xbc, 0x41, 0x0c, 0x4d, 0xbf, 0xfc, 0x89, 0x12, 0x29, 0xe0, 0xb8, 0xfa, 0x92, 0xef, 0x85, 0x69,
	0x7e, 0x2f, 0xdc, 0x8a, 0xdf, 0x0b, 0xdf, 0x38, 0xb3, 0x9e, 0x94, 0x55, 0x95, 0x74, 0x55, 0x7c,
	0x27, 0x95, 0x53, 0x8a, 0x39, 0xf5, 0x16, 0x4c, 0x8c, 0x1a, 0xa1, 0xff, 0x83, 0xb4, 0x78, 0xf8,
	0xf9, 0x91, 0xe4, 0x0b, 0xc9, 0x61, 0x98, 0xb1, 0xa7, 0x10, 0x86, 0xf9, 0x2b, 0x05, 0xe6, 0x3c,
	0x31, 0x91, 0x98, 0x3d, 0xe2, 0xd1, 0x94, 0x37, 0x87, 0x05, 0x9e, 0xba, 0x41, 0x87, 0x90, 0x49,
	0xdc, 0x10, 0x6d, 0x0a, 0x43, 0x34, 0xd3, 0xdb, 0xfe, 0xb9, 0x2d, 0xd1, 0x8c, 0xd7, 0x3b, 0x52,
	0xf9, 0x3b, 0x0a, 0x37, 0x45, 0xb2, 0xa7, 0x17, 0xf6, 0x0a, 0x3d, 0xbd, 0xb0, 0x3c, 0x5a, 0xe6,
	0xe2, 0x5b, 0x90, 0xb6, 0x9c, 0x3d, 0x37, 0x0c, 0x2a, 0x9d, 0x29, 0xfe, 0x86, 0x84, 0xe5, 0x0f,
	0xe1, 0xd2, 0x60, 0x91, 0x0c, 0xd8, 0xdc, 0x0f, 0xe2, 0x9b, 0xfb, 0xb5, 0x91, 0x85, 0x2e, 0x4f,
	0x3a, 0xbe, 0xa9, 0x53, 0xc5, 0xb4, 0xfa, 0x72, 0x3c, 0x7b, 0x62, 0x84, 0xbd, 0xed, 0xc0, 0x5c,
	0x9c, 0x42, 0xc8, 0xec, 0x3d, 0xc8, 0x45, 0xb9, 0x40, 0xdc, 0x21, 0x7c, 0x75, 0x48, 0x12, 0x81,
	0xcc, 0xc6, 0x0f, 0x13, 0x86, 0xa2, 0xdb, 0x92, 0x28, 0xab, 0x2f, 0x01, 0x59, 0xed, 0xe6, 0x04,
	0x0f, 0x8d, 0xc1, 0x62, 0x60, 0xde, 0xf5, 0x46, 0x48, 0x84, 0xfd, 0xd3, 0x31, 0x98, 0xc0, 0xae,
	0x61, 0x0a, 0xec, 0x07, 0x90, 0x8b, 0xf2, 0x08, 0xf8, 0x21, 0xc5, 0x73, 0x74, 0xde, 0x0c, 0x82,
	0xac, 0x2f, 0x72, 0x07, 0x5e, 0x84, 0x19, 0xea, 0xd4, 0xbd, 0x4e, 0x0b, 0x43, 0x11, 0xe2, 0x51,
	0x1a, 0xfd, 0x7e, 0xad, 0xd8, 0x6d, 0x10, 0xb1, 0xd5, 0x4a, 0xe8, 0x62, 0xf3, 0xa0, 0x39, 0xf7,
	0x70, 0xb9, 0xbb, 0x8c, 0x71, 0xf5, 0x6e, 0x07, 0xee, 0x02, 0xa7, 0xa4, 0x0e, 0xfc, 0xe6, 0xbd,
	0x00, 0x45, 0x71, 0xb3, 0x3f, 0xa0, 0x1d, 0xc1, 0x86, 0x27, 0x69, 0x89, 0x38, 0xc7, 0x03, 0xda,
	0xe1, 0xac, 0xe2, 0x3d, 0x39, 0xbf, 0x4c, 0x4f, 0x4f, 0xee, 0x4c, 0x7f, 0x05, 0xa6, 0x42, 0xe9,
	0x46, 0x4f, 0x65, 0x19, 0x9c, 0x5f, 0x78, 0x21, 0x7e, 0x21, 0xe9, 0x42, 0x2c, 0x49, 0x3b, 0xbc,
	0xc7, 0x72, 0x62, 0xf5, 0x2e, 0xcc, 0x60, 0x22, 0x4a, 0x93, 0x3a, 0x67, 0xbb, 0x45, 0xa9, 0xff,
	0x94, 0x02, 0x22, 0x93, 0x0a, 0x5c, 0x2d, 0x7c, 0x18, 0x13, 0xb5, 0x02, 0xdb, 0x3b, 0x89, 0xd8,
	0x7a, 0x59, 0x54, 0x57, 0x5c, 0xdb, 0xa6, 0xf5, 0x80, 0x9a, 0x51, 0x5b, 0x5f, 0x5e, 0x84, 0x34,
	0x06, 0x59, 0x01, 0xc0, 0x70, 0x8a, 0x47, 0x7d, 0x7a, 0xb6, 0xd8, 0x60, 0x9e, 0xd1, 0x69, 0x8c,
	0xac, 0xfc, 0xd7, 0x0a, 0xcc, 0xaf, 0x89, 0x2c, 0xdc, 0x01, 0xc3, 0xb2, 0x2b, 0xde, 0x3d, 0xc8,
	0xb1, 0x65, 0x8a, 0x5e, 0x12, 0x7b, 0xde, 0x9c, 0x0f, 0xed, 0xea, 0x60, 0xc2, 0xf0, 0x0d, 0xee,
	0x80, 0x76, 0x56, 0x8d, 0xc0, 0x90, 0x4d, 0xd2, 0xd8, 0x17, 0x6c, 0x92, 0xd8, 0x34, 0xae, 0x25,
	0x89, 0x8f, 0x98, 0x5d, 0x05, 0x57, 0x58, 0xdc, 0x38, 0xdb, 0xba, 0x24, 0xcb, 0x47, 0x4c, 0x13,
	0x95, 0xe6, 0x97, 0xc3, 0xbc, 0x17, 0xae, 0x34, 0xd5, 0xe1, 0x72, 0x8a, 0xe5, 0xbb, 0xdc, 0x9e,
	0x83, 0x5c, 0xf8, 0xea, 0xd5, 0x7d, 0x11, 0x5a, 0xfc, 0xcb, 0x67, 0x20, 0x23, 0x4e, 0xe9, 0x6f,
	0x29, 0x30, 0x21, 0x67, 0x33, 0x93, 0xea, 0x68, 0xf9, 0xca, 0xe1, 0x16, 0x2f, 0xd7, 0x46, 0xee,
	0xcf, 0x27, 0xaf, 0xbe, 0xf0, 0xc9, 0xdf, 0xff, 0xc7, 0xaf, 0x8d, 0x3d, 0x4b, 0x2a, 0x35, 0xa1,
	0x41, 0x6a, 0x72, 0xb2, 0x73, 0xed, 0x43, 0xb1, 0xa4, 0x1f, 0x31, 0x4f, 0x38, 0x1b, 0x6a, 0xb6,
	0xa4, 0x58, 0x7c, 0x3c, 0x37, 0xba, 0x7c, 0x7b, 0x94, 0xae, 0x02, 0xcb, 0x4b, 0x88, 0xe5, 0x05,
	0x52, 0x8e, 0xb0, 0x98, 0xbc, 0x47, 0x17, 0xc6, 0xfb, 0x79, 0x92, 0xad, 0xed, 0x53, 0xc3, 0x0e,
	0xf6, 0x89, 0x07, 0x69, 0xcc, 0x25, 0x26, 0x49, 0x3a, 0x42, 0xce, 0x3e, 0x2e, 0x2f, 0x0c, 0xef,
	0x28, 0xa0, 0x5c, 0x42, 0x28, 0x45, 0x32, 0x15, 0x41, 0xc1, 0x37, 0x1b, 0xd2, 0x86, 0x14, 0x3e,
	0xc4, 0xdd, 0x1c, 0xc2, 0x29, 0x1c, 0x71, 0x94, 0x7c, 0x66, 0xf5, 0x3a, 0x0e, 0x56, 0x26, 0xa5,
	0xf8, 0x60, 0x92, 0xf0, 0x3f, 0xe2, 0xb9, 0xcb, 0xf8, 0xe6, 0x42, 0x5e, 0x1c, 0xed, 0x65, 0x86,
	0x03, 0xb8, 0x73, 0x96, 0x67, 0x1c, 0xf5, 0x22, 0x22, 0x99, 0x26, 0x93, 0x11, 0x12, 0xe6, 0x48,
	0x93, 0x8f, 0x15, 0xc8, 0x70, 0xdf, 0x96, 0x0c, 0x4d, 0x1a, 0x8b, 0x84, 0x7d, 0x6b, 0x84, 0x9e,
	0x62, 0xd8, 0x67, 0x71, 0xd8, 0xab, 0xe4, 0x8a, 0x34, 0x2c, 0xeb, 0x20, 0x49, 0xc0, 0x87, 0x0c,
	0xcf, 0x0b, 0x4a, 0x44, 0x10, 0x4b, 0x1d, 0x2a, 0xcb, 0xcf, 0xf7, 0xe2, 0xef, 0x8a, 0x98, 0xd3,
	0x24, 0xa4, 0xde, 0x3f, 0xa8, 0xf8, 0x13, 0xa4, 0xee, 0xa0, 0xdf, 0x51, 0x20, 0x1f, 0x65, 0x63,
	0x24, 0xca, 0xbd, 0x37, 0x07, 0x25, 0x51, 0xee, 0x7d, 0x09, 0x22, 0xea, 0x2d, 0xc4, 0x72, 0x83,
	0x3c, 0x1b, 0x61, 0x31, 0xc2, 0x3e, 0xb8, 0x17, 0x24, 0x4c, 0xdf, 0x53, 0x60, 0x2a, 0x9e, 0xad,
	0x43, 0x5e, 0x1e, 0x69, 0x2c, 0xe9, 0xae, 0x51, 0x7e, 0xe5, 0x0c, 0x14, 0x02, 0xe2, 0x8b, 0x08,
	0xf1, 0x79, 0x72, 0x63, 0x00, 0x44, 0x5c, 0xad, 0xda, 0x87, 0xa1, 0x8b, 0xf7, 0x11, 0xf9, 0x25,
	0x05, 0x26, 0xe4, 0x50, 0x73, 0xa2, 0x1e, 0x1b, 0xf0, 0x5c, 0x94, 0xa8, 0xc7, 0x06, 0x85, 0xd2,
	0xd5, 0x2b, 0x08, 0x6f, 0x96, 0xcc, 0x44, 0xf0, 0xa2, 0xf8, 0xf8, 0x6f, 0x88, 0xa7, 0x00, 0xcc,
	0x0e, 0xfc, 0xd1, 0x21, 0xaa, 0x20, 0xa2, 0x2b, 0xe4, 0x72, 0x84, 0x08, 0xb3, 0x1c, 0x75, 0x19,
	0x57, 0x41, 0x8a, 0x7c, 0x93, 0xc4, 0xbf, 0x4d, 0xe9, 0x0b, 0xca, 0x97, 0xab, 0xa3, 0x76, 0x7f,
	0xb2, 0xa6, 0xc7, 0x5e, 0xfc, 0xa1, 0x46, 0xda, 0x61, 0xbf, 0xab, 0xc0, 0x64, 0x2c, 0x9a, 0x4d,
	0x6a, 0x43, 0x87, 0x8a, 0x87, 0xdc, 0xcb, 0x2f, 0x8f, 0x4e, 0xf0, 0xc4, 0x13, 0x20, 0xd0, 0x09,
	0x71, 0x49, 0xf8, 0x3e, 0x56, 0x20, 0x1f, 0xc5, 0x90, 0x13, 0x4f, 0x65, 0x6f, 0x1c, 0x3d, 0xf1,
	0x54, 0xf6, 0x85, 0xa5, 0xd5, 0x12, 0x62, 0x22, 0x6a, 0x57, 0x1b, 0xfa, 0x2d, 0xc3, 0x79, 0x5d,
	0xb9, 0x4d, 0xbe, 0x8e, 0x16, 0xbb, 0x7e, 0x90, 0xac, 0x0f, 0x63, 0x19, 0x3d, 0xe5, 0x24, 0x2b,
	0x25, 0xa7, 0x75, 0x0d, 0x50, 0x4c, 0x3e, 0x32, 0x92, 0x44, 0xf0, 0x73, 0x0a, 0x64, 0x45, 0xd2,
	0x49, 0xa2, 0x31, 0x8e, 0x27, 0xa6, 0x8c, 0x0e, 0x41, 0x45, 0x08, 0xd7, 0x24, 0x4b, 0xdc, 0xe2,
	0x9c, 0x7a, 0x30, 0x84, 0xd9, 0xf1, 0x49, 0x18, 0xe2, 0xd9, 0x2e, 0xe7, 0xc1, 0xd0, 0xe4, 0x9c,
	0x24, 0x0c, 0xdf, 0x50, 0x20, 0x17, 0x66, 0x06, 0x91, 0x24, 0x57, 0xa3, 0x27, 0xb9, 0xa9, 0xfc,
	0xe2, 0x48, 0x7d, 0x05, 0x92, 0x7e, 0xfb, 0x8c, 0xb7, 0x1f, 0x09, 0xc7, 0xaf, 0x33, 0x7d, 0x27,
	0x25, 0x94, 0x25, 0x6b, 0x97, 0xfe, 0x4c, 0xb5, 0x64, 0xed, 0x32, 0x20, 0x53, 0x4d, 0xbd, 0x81,
	0x98, 0x9e, 0x21, 0x57, 0x25, 0xed, 0xd2, 0xe8, 0x85, 0xc5, 0x7c, 0x36, 0x41, 0x9d, 0xb8, 0x44,
	0xf1, 0xcc, 0xb5, 0xf2, 0x4b, 0xc9, 0x5d, 0x7b, 0xf2, 0xf6, 0xd4, 0xdb, 0x08, 0xe5, 0x39, 0xa2,
	0x26, 0x40, 0xa9, 0x7d, 0xc8, 0x2a, 0x3e, 0x22, 0x5f, 0x87, 0xd4, 0x86, 0xdb, 0xf0, 0x13, 0xfd,
	0x27, 0x29, 0x7d, 0xf1, 0xac, 0x50, 0x06, 0xe9, 0xdc, 0x86, 0x2c, 0x91, 0xef, 0x2a, 0xf8, 0xf7,
	0x43, 0xdd, 0x60, 0x5d, 0xa2, 0x6e, 0x1b, 0xf4, 0xd0, 0x93, 0xa8, 0xdb, 0x06, 0xc6, 0x01, 0xd5,
	0x79, 0x44, 0x55, 0x22, 0x97, 0xe4, 0xd3, 0xc4, 0xfa, 0x89, 0x54, 0x97, 0x8f, 0x20, 0xcd, 0x0d,
	0xf9, 0x0b, 0xc3, 0xa3, 0x30, 0xc3, 0x1d, 0xd9, 0xb8, 0xd9, 0x7e, 0x82, 0x6b, 0x25, 0x1b, 0xeb,
	0xdf, 0x66, 0x97, 0x0e, 0x29, 0x76, 0x42, 0x46, 0x4d, 0x95, 0x1f, 0xe9, 0xd2, 0x31, 0x20, 0xb6,
	0x33, 0x60, 0xc7, 0xf4, 0x82, 0xaa, 0xd5, 0x9b, 0xe6, 0x21, 0x82, 0xf9, 0x4d, 0x05, 0x0a, 0x52,
	0xc0, 0x26, 0xd1, 0x4a, 0xf6, 0x07, 0x76, 0x06, 0xad, 0x56, 0xec, 0x0f, 0xc4, 0x25, 0x1a, 0x8d,
	0xb6, 0x5c, 0x2f, 0x50, 0x6f, 0x22, 0xb8, 0xeb, 0x64, 0xbe, 0x7b, 0x0b, 0xe9, 0x12, 0xc4, 0xcd,
	0x50, 0x86, 0x07, 0x2f, 0x86, 0x18, 0x01, 0x29, 0x7a, 0x94, 0xe8, 0x14, 0xc7, 0x23, 0x21, 0x03,
	0xcd, 0x00, 0xeb, 0x20, 0x41, 0xf8, 0x05, 0x05, 0xa0, 0x7b, 0xa1, 0x25, 0x77, 0x46, 0xbc, 0xf7,
	0x0e, 0x3f, 0x5a, 0xfd, 0xb7, 0x64, 0xf5, 0x2a, 0xc2, 0xb9, 0x48, 0x66, 0x65, 0xab, 0x24, 0x3a,
	0x2d, 0xab, 0x9f, 0xfe, 0xdb, 0xfc, 0x85, 0x4f, 0x4f, 0xe7, 0x95, 0xbf, 0x3d, 0x9d, 0x57, 0xfe,
	0xf1, 0x74, 0x5e, 0xf9, 0xd7, 0xd3, 0x79, 0xe5, 0xdb, 0xff, 0x3e, 0x7f, 0xe1, 0xfd, 0x5c, 0xc8,
	0x73, 0x37, 0x83, 0x31, 0x8b, 0x2f, 0xfd, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x76, 0x2f, 0xfe,
	0xd2, 0x35, 0x40, 0x00, 0x00,
}
