// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: roachpb/metadata.proto

package roachpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_util "github.com/cockroachdb/cockroach/pkg/util"

import bytes "bytes"

import binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Attributes specifies a list of arbitrary strings describing
// node topology, store type, and machine capabilities.
type Attributes struct {
	Attrs []string `protobuf:"bytes,1,rep,name=attrs" json:"attrs,omitempty" yaml:"attrs,flow"`
}

func (m *Attributes) Reset()                    { *m = Attributes{} }
func (*Attributes) ProtoMessage()               {}
func (*Attributes) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{0} }

// ReplicationTarget identifies a node/store pair.
type ReplicationTarget struct {
	NodeID  NodeID  `protobuf:"varint,1,opt,name=node_id,json=nodeId,casttype=NodeID" json:"node_id"`
	StoreID StoreID `protobuf:"varint,2,opt,name=store_id,json=storeId,casttype=StoreID" json:"store_id"`
}

func (m *ReplicationTarget) Reset()                    { *m = ReplicationTarget{} }
func (*ReplicationTarget) ProtoMessage()               {}
func (*ReplicationTarget) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{1} }

// ReplicaDescriptor describes a replica location by node ID
// (corresponds to a host:port via lookup on gossip network) and store
// ID (identifies the device).
type ReplicaDescriptor struct {
	NodeID  NodeID  `protobuf:"varint,1,opt,name=node_id,json=nodeId,casttype=NodeID" json:"node_id"`
	StoreID StoreID `protobuf:"varint,2,opt,name=store_id,json=storeId,casttype=StoreID" json:"store_id"`
	// replica_id uniquely identifies a replica instance. If a range is removed from
	// a store and then re-added to the same store, the new instance will have a
	// higher replica_id.
	ReplicaID ReplicaID `protobuf:"varint,3,opt,name=replica_id,json=replicaId,casttype=ReplicaID" json:"replica_id"`
}

func (m *ReplicaDescriptor) Reset()                    { *m = ReplicaDescriptor{} }
func (*ReplicaDescriptor) ProtoMessage()               {}
func (*ReplicaDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{2} }

// ReplicaIdent uniquely identifies a specific replica.
type ReplicaIdent struct {
	RangeID RangeID           `protobuf:"varint,1,opt,name=range_id,json=rangeId,casttype=RangeID" json:"range_id"`
	Replica ReplicaDescriptor `protobuf:"bytes,2,opt,name=replica" json:"replica"`
}

func (m *ReplicaIdent) Reset()                    { *m = ReplicaIdent{} }
func (m *ReplicaIdent) String() string            { return proto.CompactTextString(m) }
func (*ReplicaIdent) ProtoMessage()               {}
func (*ReplicaIdent) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{3} }

// RangeDescriptor is the value stored in a range metadata key.
// A range is described using an inclusive start key, a non-inclusive end key,
// and a list of replicas where the range is stored.
//
// NOTE: Care must be taken when changing the encoding of this proto
// because it is used as part of conditional put operations.
type RangeDescriptor struct {
	RangeID RangeID `protobuf:"varint,1,opt,name=range_id,json=rangeId,casttype=RangeID" json:"range_id"`
	// start_key is the first key which may be contained by this range.
	StartKey RKey `protobuf:"bytes,2,opt,name=start_key,json=startKey,casttype=RKey" json:"start_key,omitempty"`
	// end_key marks the end of the range's possible keys.  EndKey itself is not
	// contained in this range - it will be contained in the immediately
	// subsequent range.
	EndKey RKey `protobuf:"bytes,3,opt,name=end_key,json=endKey,casttype=RKey" json:"end_key,omitempty"`
	// replicas is the set of nodes/stores on which replicas of this
	// range are stored, the ordering being arbitrary and subject to
	// permutation.
	Replicas []ReplicaDescriptor `protobuf:"bytes,4,rep,name=replicas" json:"replicas"`
	// next_replica_id is a counter used to generate replica IDs.
	NextReplicaID ReplicaID `protobuf:"varint,5,opt,name=next_replica_id,json=nextReplicaId,casttype=ReplicaID" json:"next_replica_id"`
	// generation is incremented on every split and every merge, i.e., whenever
	// the end_key of this range changes. It is initialized to zero when the range
	// is first created.
	//
	// Note that the generation counter is not incremented by versions of
	// Cockroach prior to v2.1. To maintain backwards compatibility with these old
	// versions of Cockroach, we cannot enable the gogoproto.nullable option, as
	// we need to be able to encode this mesage with the generation field unset.
	Generation *int64 `protobuf:"varint,6,opt,name=generation" json:"generation,omitempty"`
}

func (m *RangeDescriptor) Reset()                    { *m = RangeDescriptor{} }
func (*RangeDescriptor) ProtoMessage()               {}
func (*RangeDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{4} }

// Percentiles contains a handful of hard-coded percentiles meant to summarize
// a distribution.
type Percentiles struct {
	P10  float64 `protobuf:"fixed64,1,opt,name=p10" json:"p10"`
	P25  float64 `protobuf:"fixed64,2,opt,name=p25" json:"p25"`
	P50  float64 `protobuf:"fixed64,3,opt,name=p50" json:"p50"`
	P75  float64 `protobuf:"fixed64,4,opt,name=p75" json:"p75"`
	P90  float64 `protobuf:"fixed64,5,opt,name=p90" json:"p90"`
	PMax float64 `protobuf:"fixed64,6,opt,name=pMax" json:"pMax"`
}

func (m *Percentiles) Reset()                    { *m = Percentiles{} }
func (*Percentiles) ProtoMessage()               {}
func (*Percentiles) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{5} }

// StoreCapacity contains capacity information for a storage device.
type StoreCapacity struct {
	// Total capacity of the disk used by the store, including space used by the
	// operating system and other applications.
	Capacity int64 `protobuf:"varint,1,opt,name=capacity" json:"capacity"`
	// Available space remaining on the disk used by the store.
	Available int64 `protobuf:"varint,2,opt,name=available" json:"available"`
	// Amount of disk space used by the data in the CockroachDB store. Note that
	// this is going to be less than (capacity - available), because those two
	// fields consider the entire disk and everything on it, while this only
	// tracks the store's disk usage.
	Used int64 `protobuf:"varint,8,opt,name=used" json:"used"`
	// Amount of logical bytes stored in the store, ignoring RocksDB space
	// overhead. Useful for rebalancing so that moving a replica from one store
	// to another actually removes its bytes from the source store even though
	// RocksDB may not actually reclaim the physical disk space for a while.
	LogicalBytes int64 `protobuf:"varint,9,opt,name=logical_bytes,json=logicalBytes" json:"logical_bytes"`
	RangeCount   int32 `protobuf:"varint,3,opt,name=range_count,json=rangeCount" json:"range_count"`
	LeaseCount   int32 `protobuf:"varint,4,opt,name=lease_count,json=leaseCount" json:"lease_count"`
	// queries_per_second tracks the average number of queries processed per
	// second by replicas in the store. The stat is tracked over the time period
	// defined in storage/replica_stats.go, which as of July 2018 is 30 minutes.
	QueriesPerSecond float64 `protobuf:"fixed64,10,opt,name=queries_per_second,json=queriesPerSecond" json:"queries_per_second"`
	// writes_per_second tracks the average number of keys written per second
	// by ranges in the store. The stat is tracked over the time period defined
	// in storage/replica_stats.go, which as of July 2018 is 30 minutes.
	WritesPerSecond float64 `protobuf:"fixed64,5,opt,name=writes_per_second,json=writesPerSecond" json:"writes_per_second"`
	// bytes_per_replica and writes_per_replica contain percentiles for the
	// number of bytes and writes-per-second to each replica in the store.
	// This information can be used for rebalancing decisions.
	BytesPerReplica  Percentiles `protobuf:"bytes,6,opt,name=bytes_per_replica,json=bytesPerReplica" json:"bytes_per_replica"`
	WritesPerReplica Percentiles `protobuf:"bytes,7,opt,name=writes_per_replica,json=writesPerReplica" json:"writes_per_replica"`
}

func (m *StoreCapacity) Reset()                    { *m = StoreCapacity{} }
func (*StoreCapacity) ProtoMessage()               {}
func (*StoreCapacity) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{6} }

// NodeDescriptor holds details on node physical/network topology.
type NodeDescriptor struct {
	NodeID          NodeID                        `protobuf:"varint,1,opt,name=node_id,json=nodeId,casttype=NodeID" json:"node_id"`
	Address         cockroach_util.UnresolvedAddr `protobuf:"bytes,2,opt,name=address" json:"address"`
	Attrs           Attributes                    `protobuf:"bytes,3,opt,name=attrs" json:"attrs"`
	Locality        Locality                      `protobuf:"bytes,4,opt,name=locality" json:"locality"`
	ServerVersion   Version                       `protobuf:"bytes,5,opt,name=ServerVersion" json:"ServerVersion"`
	BuildTag        string                        `protobuf:"bytes,6,opt,name=build_tag,json=buildTag" json:"build_tag"`
	StartedAt       int64                         `protobuf:"varint,7,opt,name=started_at,json=startedAt" json:"started_at"`
	LocalityAddress []LocalityAddress             `protobuf:"bytes,8,rep,name=locality_address,json=localityAddress" json:"locality_address"`
}

func (m *NodeDescriptor) Reset()                    { *m = NodeDescriptor{} }
func (m *NodeDescriptor) String() string            { return proto.CompactTextString(m) }
func (*NodeDescriptor) ProtoMessage()               {}
func (*NodeDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{7} }

// LocalityAddress holds the private address accessible only from other nodes
// in the corresponding locality.
type LocalityAddress struct {
	Address      cockroach_util.UnresolvedAddr `protobuf:"bytes,1,opt,name=address" json:"address"`
	LocalityTier Tier                          `protobuf:"bytes,2,opt,name=locality_tier,json=localityTier" json:"locality_tier"`
}

func (m *LocalityAddress) Reset()                    { *m = LocalityAddress{} }
func (m *LocalityAddress) String() string            { return proto.CompactTextString(m) }
func (*LocalityAddress) ProtoMessage()               {}
func (*LocalityAddress) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{8} }

// StoreDescriptor holds store information including store attributes, node
// descriptor and store capacity.
type StoreDescriptor struct {
	StoreID  StoreID        `protobuf:"varint,1,opt,name=store_id,json=storeId,casttype=StoreID" json:"store_id"`
	Attrs    Attributes     `protobuf:"bytes,2,opt,name=attrs" json:"attrs"`
	Node     NodeDescriptor `protobuf:"bytes,3,opt,name=node" json:"node"`
	Capacity StoreCapacity  `protobuf:"bytes,4,opt,name=capacity" json:"capacity"`
}

func (m *StoreDescriptor) Reset()                    { *m = StoreDescriptor{} }
func (m *StoreDescriptor) String() string            { return proto.CompactTextString(m) }
func (*StoreDescriptor) ProtoMessage()               {}
func (*StoreDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{9} }

// StoreDeadReplicas holds a storeID and a list of dead replicas on that store.
// Used to let the range lease holder know about corrupted or otherwise
// destroyed replicas that should be transferred to a different store.
type StoreDeadReplicas struct {
	StoreID  StoreID        `protobuf:"varint,1,opt,name=store_id,json=storeId,casttype=StoreID" json:"store_id"`
	Replicas []ReplicaIdent `protobuf:"bytes,2,rep,name=replicas" json:"replicas"`
}

func (m *StoreDeadReplicas) Reset()                    { *m = StoreDeadReplicas{} }
func (m *StoreDeadReplicas) String() string            { return proto.CompactTextString(m) }
func (*StoreDeadReplicas) ProtoMessage()               {}
func (*StoreDeadReplicas) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{10} }

// Locality is an ordered set of key value Tiers that describe a node's
// location. The tier keys should be the same across all nodes.
type Locality struct {
	Tiers []Tier `protobuf:"bytes,1,rep,name=tiers" json:"tiers"`
}

func (m *Locality) Reset()                    { *m = Locality{} }
func (*Locality) ProtoMessage()               {}
func (*Locality) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{11} }

// Tier represents one level of the locality hierarchy.
type Tier struct {
	// Key is the name of tier and should match all other nodes.
	Key string `protobuf:"bytes,1,opt,name=key" json:"key"`
	// Value is node specific value corresponding to the key.
	Value string `protobuf:"bytes,2,opt,name=value" json:"value"`
}

func (m *Tier) Reset()                    { *m = Tier{} }
func (*Tier) ProtoMessage()               {}
func (*Tier) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{12} }

type Version struct {
	// The names "major" and "minor" are reserved in C in
	// some platforms (e.g. FreeBSD).
	Major int32 `protobuf:"varint,1,opt,name=major_val,json=majorVal" json:"major_val"`
	Minor int32 `protobuf:"varint,2,opt,name=minor_val,json=minorVal" json:"minor_val"`
	// Note that patch is a placeholder and will always be zero.
	Patch int32 `protobuf:"varint,3,opt,name=patch" json:"patch"`
	// The unstable version is used to migrate during development.
	// Users of stable, public releases will only use binaries
	// with unstable set to 0.
	Unstable int32 `protobuf:"varint,4,opt,name=unstable" json:"unstable"`
}

func (m *Version) Reset()                    { *m = Version{} }
func (*Version) ProtoMessage()               {}
func (*Version) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{13} }

func init() {
	proto.RegisterType((*Attributes)(nil), "cockroach.roachpb.Attributes")
	proto.RegisterType((*ReplicationTarget)(nil), "cockroach.roachpb.ReplicationTarget")
	proto.RegisterType((*ReplicaDescriptor)(nil), "cockroach.roachpb.ReplicaDescriptor")
	proto.RegisterType((*ReplicaIdent)(nil), "cockroach.roachpb.ReplicaIdent")
	proto.RegisterType((*RangeDescriptor)(nil), "cockroach.roachpb.RangeDescriptor")
	proto.RegisterType((*Percentiles)(nil), "cockroach.roachpb.Percentiles")
	proto.RegisterType((*StoreCapacity)(nil), "cockroach.roachpb.StoreCapacity")
	proto.RegisterType((*NodeDescriptor)(nil), "cockroach.roachpb.NodeDescriptor")
	proto.RegisterType((*LocalityAddress)(nil), "cockroach.roachpb.LocalityAddress")
	proto.RegisterType((*StoreDescriptor)(nil), "cockroach.roachpb.StoreDescriptor")
	proto.RegisterType((*StoreDeadReplicas)(nil), "cockroach.roachpb.StoreDeadReplicas")
	proto.RegisterType((*Locality)(nil), "cockroach.roachpb.Locality")
	proto.RegisterType((*Tier)(nil), "cockroach.roachpb.Tier")
	proto.RegisterType((*Version)(nil), "cockroach.roachpb.Version")
}
func (this *ReplicationTarget) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicationTarget)
	if !ok {
		that2, ok := that.(ReplicationTarget)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NodeID != that1.NodeID {
		return false
	}
	if this.StoreID != that1.StoreID {
		return false
	}
	return true
}
func (this *ReplicaDescriptor) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ReplicaDescriptor)
	if !ok {
		that2, ok := that.(ReplicaDescriptor)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NodeID != that1.NodeID {
		return false
	}
	if this.StoreID != that1.StoreID {
		return false
	}
	if this.ReplicaID != that1.ReplicaID {
		return false
	}
	return true
}
func (this *RangeDescriptor) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RangeDescriptor)
	if !ok {
		that2, ok := that.(RangeDescriptor)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.RangeID != that1.RangeID {
		return false
	}
	if !bytes.Equal(this.StartKey, that1.StartKey) {
		return false
	}
	if !bytes.Equal(this.EndKey, that1.EndKey) {
		return false
	}
	if len(this.Replicas) != len(that1.Replicas) {
		return false
	}
	for i := range this.Replicas {
		if !this.Replicas[i].Equal(&that1.Replicas[i]) {
			return false
		}
	}
	if this.NextReplicaID != that1.NextReplicaID {
		return false
	}
	if this.Generation != nil && that1.Generation != nil {
		if *this.Generation != *that1.Generation {
			return false
		}
	} else if this.Generation != nil {
		return false
	} else if that1.Generation != nil {
		return false
	}
	return true
}
func (m *Attributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Attributes) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Attrs) > 0 {
		for _, s := range m.Attrs {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *ReplicationTarget) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationTarget) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.NodeID))
	dAtA[i] = 0x10
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.StoreID))
	return i, nil
}

func (m *ReplicaDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicaDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.NodeID))
	dAtA[i] = 0x10
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.StoreID))
	dAtA[i] = 0x18
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.ReplicaID))
	return i, nil
}

func (m *ReplicaIdent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicaIdent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.RangeID))
	dAtA[i] = 0x12
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Replica.Size()))
	n1, err := m.Replica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	return i, nil
}

func (m *RangeDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.RangeID))
	if m.StartKey != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMetadata(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if m.EndKey != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMetadata(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if len(m.Replicas) > 0 {
		for _, msg := range m.Replicas {
			dAtA[i] = 0x22
			i++
			i = encodeVarintMetadata(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x28
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.NextReplicaID))
	if m.Generation != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintMetadata(dAtA, i, uint64(*m.Generation))
	}
	return i, nil
}

func (m *Percentiles) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Percentiles) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x9
	i++
	binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.P10))))
	i += 8
	dAtA[i] = 0x11
	i++
	binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.P25))))
	i += 8
	dAtA[i] = 0x19
	i++
	binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.P50))))
	i += 8
	dAtA[i] = 0x21
	i++
	binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.P75))))
	i += 8
	dAtA[i] = 0x29
	i++
	binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.P90))))
	i += 8
	dAtA[i] = 0x31
	i++
	binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.PMax))))
	i += 8
	return i, nil
}

func (m *StoreCapacity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreCapacity) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Capacity))
	dAtA[i] = 0x10
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Available))
	dAtA[i] = 0x18
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.RangeCount))
	dAtA[i] = 0x20
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.LeaseCount))
	dAtA[i] = 0x29
	i++
	binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.WritesPerSecond))))
	i += 8
	dAtA[i] = 0x32
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.BytesPerReplica.Size()))
	n2, err := m.BytesPerReplica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	dAtA[i] = 0x3a
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.WritesPerReplica.Size()))
	n3, err := m.WritesPerReplica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	dAtA[i] = 0x40
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Used))
	dAtA[i] = 0x48
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.LogicalBytes))
	dAtA[i] = 0x51
	i++
	binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.QueriesPerSecond))))
	i += 8
	return i, nil
}

func (m *NodeDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.NodeID))
	dAtA[i] = 0x12
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Address.Size()))
	n4, err := m.Address.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Attrs.Size()))
	n5, err := m.Attrs.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	dAtA[i] = 0x22
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Locality.Size()))
	n6, err := m.Locality.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	dAtA[i] = 0x2a
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.ServerVersion.Size()))
	n7, err := m.ServerVersion.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	dAtA[i] = 0x32
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(len(m.BuildTag)))
	i += copy(dAtA[i:], m.BuildTag)
	dAtA[i] = 0x38
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.StartedAt))
	if len(m.LocalityAddress) > 0 {
		for _, msg := range m.LocalityAddress {
			dAtA[i] = 0x42
			i++
			i = encodeVarintMetadata(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *LocalityAddress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocalityAddress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Address.Size()))
	n8, err := m.Address.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	dAtA[i] = 0x12
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.LocalityTier.Size()))
	n9, err := m.LocalityTier.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	return i, nil
}

func (m *StoreDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.StoreID))
	dAtA[i] = 0x12
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Attrs.Size()))
	n10, err := m.Attrs.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Node.Size()))
	n11, err := m.Node.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	dAtA[i] = 0x22
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Capacity.Size()))
	n12, err := m.Capacity.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	return i, nil
}

func (m *StoreDeadReplicas) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreDeadReplicas) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.StoreID))
	if len(m.Replicas) > 0 {
		for _, msg := range m.Replicas {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMetadata(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Locality) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Locality) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Tiers) > 0 {
		for _, msg := range m.Tiers {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMetadata(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Tier) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tier) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(len(m.Key)))
	i += copy(dAtA[i:], m.Key)
	dAtA[i] = 0x12
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	return i, nil
}

func (m *Version) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Version) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Major))
	dAtA[i] = 0x10
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Minor))
	dAtA[i] = 0x18
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Patch))
	dAtA[i] = 0x20
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Unstable))
	return i, nil
}

func encodeVarintMetadata(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedReplicaDescriptor(r randyMetadata, easy bool) *ReplicaDescriptor {
	this := &ReplicaDescriptor{}
	this.NodeID = NodeID(r.Int31())
	if r.Intn(2) == 0 {
		this.NodeID *= -1
	}
	this.StoreID = StoreID(r.Int31())
	if r.Intn(2) == 0 {
		this.StoreID *= -1
	}
	this.ReplicaID = ReplicaID(r.Int31())
	if r.Intn(2) == 0 {
		this.ReplicaID *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedRangeDescriptor(r randyMetadata, easy bool) *RangeDescriptor {
	this := &RangeDescriptor{}
	this.RangeID = RangeID(r.Int63())
	if r.Intn(2) == 0 {
		this.RangeID *= -1
	}
	if r.Intn(10) != 0 {
		v1 := r.Intn(100)
		this.StartKey = make(RKey, v1)
		for i := 0; i < v1; i++ {
			this.StartKey[i] = byte(r.Intn(256))
		}
	}
	if r.Intn(10) != 0 {
		v2 := r.Intn(100)
		this.EndKey = make(RKey, v2)
		for i := 0; i < v2; i++ {
			this.EndKey[i] = byte(r.Intn(256))
		}
	}
	if r.Intn(10) != 0 {
		v3 := r.Intn(5)
		this.Replicas = make([]ReplicaDescriptor, v3)
		for i := 0; i < v3; i++ {
			v4 := NewPopulatedReplicaDescriptor(r, easy)
			this.Replicas[i] = *v4
		}
	}
	this.NextReplicaID = ReplicaID(r.Int31())
	if r.Intn(2) == 0 {
		this.NextReplicaID *= -1
	}
	if r.Intn(10) != 0 {
		v5 := int64(r.Int63())
		if r.Intn(2) == 0 {
			v5 *= -1
		}
		this.Generation = &v5
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyMetadata interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneMetadata(r randyMetadata) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringMetadata(r randyMetadata) string {
	v6 := r.Intn(100)
	tmps := make([]rune, v6)
	for i := 0; i < v6; i++ {
		tmps[i] = randUTF8RuneMetadata(r)
	}
	return string(tmps)
}
func randUnrecognizedMetadata(r randyMetadata, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldMetadata(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldMetadata(dAtA []byte, r randyMetadata, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateMetadata(dAtA, uint64(key))
		v7 := r.Int63()
		if r.Intn(2) == 0 {
			v7 *= -1
		}
		dAtA = encodeVarintPopulateMetadata(dAtA, uint64(v7))
	case 1:
		dAtA = encodeVarintPopulateMetadata(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateMetadata(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateMetadata(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateMetadata(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateMetadata(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Attributes) Size() (n int) {
	var l int
	_ = l
	if len(m.Attrs) > 0 {
		for _, s := range m.Attrs {
			l = len(s)
			n += 1 + l + sovMetadata(uint64(l))
		}
	}
	return n
}

func (m *ReplicationTarget) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.NodeID))
	n += 1 + sovMetadata(uint64(m.StoreID))
	return n
}

func (m *ReplicaDescriptor) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.NodeID))
	n += 1 + sovMetadata(uint64(m.StoreID))
	n += 1 + sovMetadata(uint64(m.ReplicaID))
	return n
}

func (m *ReplicaIdent) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.RangeID))
	l = m.Replica.Size()
	n += 1 + l + sovMetadata(uint64(l))
	return n
}

func (m *RangeDescriptor) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.RangeID))
	if m.StartKey != nil {
		l = len(m.StartKey)
		n += 1 + l + sovMetadata(uint64(l))
	}
	if m.EndKey != nil {
		l = len(m.EndKey)
		n += 1 + l + sovMetadata(uint64(l))
	}
	if len(m.Replicas) > 0 {
		for _, e := range m.Replicas {
			l = e.Size()
			n += 1 + l + sovMetadata(uint64(l))
		}
	}
	n += 1 + sovMetadata(uint64(m.NextReplicaID))
	if m.Generation != nil {
		n += 1 + sovMetadata(uint64(*m.Generation))
	}
	return n
}

func (m *Percentiles) Size() (n int) {
	var l int
	_ = l
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	return n
}

func (m *StoreCapacity) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.Capacity))
	n += 1 + sovMetadata(uint64(m.Available))
	n += 1 + sovMetadata(uint64(m.RangeCount))
	n += 1 + sovMetadata(uint64(m.LeaseCount))
	n += 9
	l = m.BytesPerReplica.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = m.WritesPerReplica.Size()
	n += 1 + l + sovMetadata(uint64(l))
	n += 1 + sovMetadata(uint64(m.Used))
	n += 1 + sovMetadata(uint64(m.LogicalBytes))
	n += 9
	return n
}

func (m *NodeDescriptor) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.NodeID))
	l = m.Address.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = m.Attrs.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = m.Locality.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = m.ServerVersion.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = len(m.BuildTag)
	n += 1 + l + sovMetadata(uint64(l))
	n += 1 + sovMetadata(uint64(m.StartedAt))
	if len(m.LocalityAddress) > 0 {
		for _, e := range m.LocalityAddress {
			l = e.Size()
			n += 1 + l + sovMetadata(uint64(l))
		}
	}
	return n
}

func (m *LocalityAddress) Size() (n int) {
	var l int
	_ = l
	l = m.Address.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = m.LocalityTier.Size()
	n += 1 + l + sovMetadata(uint64(l))
	return n
}

func (m *StoreDescriptor) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.StoreID))
	l = m.Attrs.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = m.Node.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = m.Capacity.Size()
	n += 1 + l + sovMetadata(uint64(l))
	return n
}

func (m *StoreDeadReplicas) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.StoreID))
	if len(m.Replicas) > 0 {
		for _, e := range m.Replicas {
			l = e.Size()
			n += 1 + l + sovMetadata(uint64(l))
		}
	}
	return n
}

func (m *Locality) Size() (n int) {
	var l int
	_ = l
	if len(m.Tiers) > 0 {
		for _, e := range m.Tiers {
			l = e.Size()
			n += 1 + l + sovMetadata(uint64(l))
		}
	}
	return n
}

func (m *Tier) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	n += 1 + l + sovMetadata(uint64(l))
	l = len(m.Value)
	n += 1 + l + sovMetadata(uint64(l))
	return n
}

func (m *Version) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.Major))
	n += 1 + sovMetadata(uint64(m.Minor))
	n += 1 + sovMetadata(uint64(m.Patch))
	n += 1 + sovMetadata(uint64(m.Unstable))
	return n
}

func sovMetadata(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozMetadata(x uint64) (n int) {
	return sovMetadata(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Attributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Attributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Attributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attrs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attrs = append(m.Attrs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicationTarget) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicationTarget: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicationTarget: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicaDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicaDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicaDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaID", wireType)
			}
			m.ReplicaID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplicaID |= (ReplicaID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicaIdent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicaIdent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicaIdent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Replica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Replicas = append(m.Replicas, ReplicaDescriptor{})
			if err := m.Replicas[len(m.Replicas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextReplicaID", wireType)
			}
			m.NextReplicaID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextReplicaID |= (ReplicaID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Generation", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Generation = &v
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Percentiles) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Percentiles: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Percentiles: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field P10", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.P10 = float64(math.Float64frombits(v))
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field P25", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.P25 = float64(math.Float64frombits(v))
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field P50", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.P50 = float64(math.Float64frombits(v))
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field P75", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.P75 = float64(math.Float64frombits(v))
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field P90", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.P90 = float64(math.Float64frombits(v))
		case 6:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field PMax", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.PMax = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreCapacity) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreCapacity: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreCapacity: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Capacity", wireType)
			}
			m.Capacity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Capacity |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Available", wireType)
			}
			m.Available = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Available |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeCount", wireType)
			}
			m.RangeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeCount |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseCount", wireType)
			}
			m.LeaseCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LeaseCount |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field WritesPerSecond", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.WritesPerSecond = float64(math.Float64frombits(v))
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesPerReplica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.BytesPerReplica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WritesPerReplica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.WritesPerReplica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Used", wireType)
			}
			m.Used = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Used |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogicalBytes", wireType)
			}
			m.LogicalBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LogicalBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueriesPerSecond", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.QueriesPerSecond = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Address.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attrs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Attrs.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locality", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Locality.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerVersion", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ServerVersion.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuildTag", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BuildTag = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedAt", wireType)
			}
			m.StartedAt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartedAt |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalityAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LocalityAddress = append(m.LocalityAddress, LocalityAddress{})
			if err := m.LocalityAddress[len(m.LocalityAddress)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LocalityAddress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocalityAddress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocalityAddress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Address.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalityTier", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LocalityTier.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attrs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Attrs.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Node.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Capacity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Capacity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreDeadReplicas) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreDeadReplicas: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreDeadReplicas: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Replicas = append(m.Replicas, ReplicaIdent{})
			if err := m.Replicas[len(m.Replicas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Locality) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Locality: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Locality: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tiers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tiers = append(m.Tiers, Tier{})
			if err := m.Tiers[len(m.Tiers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tier) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tier: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tier: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Version) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Version: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Version: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Major", wireType)
			}
			m.Major = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Major |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Minor", wireType)
			}
			m.Minor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Minor |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Patch", wireType)
			}
			m.Patch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Patch |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unstable", wireType)
			}
			m.Unstable = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Unstable |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMetadata(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthMetadata
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowMetadata
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipMetadata(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthMetadata = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMetadata   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("roachpb/metadata.proto", fileDescriptorMetadata) }

var fileDescriptorMetadata = []byte{
	// 1162 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x56, 0xcf, 0x6f, 0x1b, 0x45,
	0x14, 0xce, 0xda, 0xeb, 0x78, 0xfd, 0x1a, 0x93, 0x7a, 0x04, 0xc5, 0x32, 0xc2, 0x4e, 0x16, 0x2a,
	0x95, 0x1f, 0x4a, 0xd2, 0x20, 0xab, 0x4a, 0x50, 0x81, 0xb8, 0xa1, 0x52, 0x28, 0xad, 0xa2, 0x4d,
	0xe8, 0x81, 0x8b, 0x35, 0xd9, 0x1d, 0xdc, 0xa5, 0x9b, 0x5d, 0x33, 0x3b, 0x4e, 0xe3, 0x3b, 0x12,
	0x07, 0x84, 0xc4, 0x05, 0x89, 0x63, 0x2e, 0xfd, 0x1f, 0xf8, 0x13, 0x22, 0x4e, 0x1c, 0x38, 0x70,
	0x8a, 0xc0, 0x5c, 0x38, 0x73, 0xcc, 0x09, 0xcd, 0x9b, 0x99, 0xf5, 0xda, 0x75, 0x81, 0x04, 0x89,
	0xdb, 0xf8, 0x7b, 0xdf, 0x37, 0xfb, 0xe6, 0xfd, 0x34, 0x5c, 0xe3, 0x09, 0xf5, 0x1f, 0xf5, 0x0f,
	0x56, 0x0f, 0x99, 0xa0, 0x01, 0x15, 0x74, 0xa5, 0xcf, 0x13, 0x91, 0x90, 0x9a, 0x9f, 0xf8, 0x8f,
	0xd1, 0xb6, 0xa2, 0x19, 0x8d, 0xc6, 0x40, 0x84, 0xd1, 0xea, 0x20, 0xe6, 0x2c, 0x4d, 0xa2, 0x23,
	0x16, 0x74, 0x69, 0x10, 0x70, 0x45, 0x6f, 0xbc, 0xd8, 0x4b, 0x7a, 0x09, 0x1e, 0x57, 0xe5, 0x49,
	0xa1, 0xee, 0xfb, 0x00, 0x5b, 0x42, 0xf0, 0xf0, 0x60, 0x20, 0x58, 0x4a, 0xde, 0x82, 0x12, 0x15,
	0x82, 0xa7, 0x75, 0x6b, 0xa9, 0x78, 0xa3, 0xd2, 0x79, 0xe9, 0xcf, 0xb3, 0x56, 0x6d, 0x48, 0x0f,
	0xa3, 0x4d, 0x17, 0xe1, 0xb7, 0x3f, 0x8b, 0x92, 0x27, 0xae, 0xa7, 0x38, 0x9b, 0xf6, 0xf7, 0x27,
	0xad, 0x39, 0xf7, 0x2b, 0x0b, 0x6a, 0x1e, 0xeb, 0x47, 0xa1, 0x4f, 0x45, 0x98, 0xc4, 0xfb, 0x94,
	0xf7, 0x98, 0x20, 0x37, 0xa1, 0x1c, 0x27, 0x01, 0xeb, 0x86, 0x41, 0xdd, 0x5a, 0xb2, 0x6e, 0x94,
	0x3a, 0xf5, 0xd3, 0xb3, 0xd6, 0xdc, 0xe8, 0xac, 0x35, 0xff, 0x20, 0x09, 0xd8, 0xce, 0xf6, 0x79,
	0x76, 0xf2, 0xe6, 0x25, 0x71, 0x27, 0x20, 0x6d, 0x70, 0x52, 0x91, 0x70, 0xd4, 0x14, 0x50, 0xd3,
	0xd0, 0x9a, 0xf2, 0x9e, 0xc4, 0x51, 0x64, 0x8e, 0x5e, 0x19, 0xb9, 0x3b, 0xc1, 0xa6, 0x23, 0xbd,
	0xf8, 0xe3, 0xa4, 0x65, 0xb9, 0x3f, 0x8e, 0x3d, 0xd9, 0x66, 0xa9, 0xcf, 0xc3, 0xbe, 0x48, 0xf8,
	0xff, 0xe7, 0x09, 0xb9, 0x0d, 0xc0, 0xd5, 0xe7, 0xa5, 0xb0, 0x88, 0xc2, 0xa6, 0x16, 0x56, 0xb4,
	0x63, 0x28, 0x1d, 0xff, 0xf0, 0x2a, 0x5a, 0xb1, 0x13, 0x6c, 0x2e, 0xc8, 0x87, 0xfc, 0x70, 0xd2,
	0xb2, 0xf0, 0x31, 0x5f, 0x5b, 0xb0, 0x60, 0x68, 0x01, 0x8b, 0x85, 0x74, 0x8a, 0xd3, 0xb8, 0x97,
	0x3d, 0xa4, 0x38, 0x76, 0xca, 0x93, 0xb8, 0x72, 0x4a, 0x1f, 0xbd, 0x32, 0x72, 0x77, 0x02, 0xb2,
	0x0d, 0x65, 0xfd, 0x09, 0x7c, 0xca, 0x95, 0xf5, 0xd7, 0x57, 0x9e, 0x29, 0x9b, 0x95, 0x67, 0xa2,
	0xd6, 0xb1, 0xe5, 0xdd, 0x9e, 0x91, 0xba, 0x3f, 0x17, 0x60, 0x11, 0xaf, 0xce, 0x05, 0xf6, 0x92,
	0x0e, 0x5d, 0x87, 0x4a, 0x2a, 0x28, 0x17, 0xdd, 0xc7, 0x6c, 0x88, 0x2e, 0x2d, 0x74, 0x9c, 0xf3,
	0xb3, 0x96, 0xed, 0xdd, 0x63, 0x43, 0xcf, 0x41, 0xd3, 0x3d, 0x36, 0x24, 0xcb, 0x50, 0x66, 0x71,
	0x80, 0xa4, 0xe2, 0x14, 0x69, 0x9e, 0xc5, 0x81, 0xa4, 0xdc, 0x05, 0x47, 0xfb, 0x97, 0xd6, 0xed,
	0xa5, 0xe2, 0x05, 0xdf, 0x96, 0x69, 0xc9, 0x47, 0xb0, 0x18, 0xb3, 0x63, 0xd1, 0xcd, 0x25, 0xaf,
	0x84, 0xc9, 0x73, 0xf5, 0x7b, 0xaa, 0x0f, 0xd8, 0xb1, 0x78, 0x4e, 0x02, 0xab, 0x71, 0xce, 0x16,
	0x90, 0x26, 0x40, 0x8f, 0xc5, 0x8c, 0x63, 0x2f, 0xd4, 0xe7, 0x65, 0x58, 0xbc, 0x1c, 0x32, 0x95,
	0xe4, 0xa7, 0x16, 0x5c, 0xd9, 0x65, 0xdc, 0x67, 0xb1, 0x08, 0x23, 0x96, 0x92, 0x6b, 0x50, 0xec,
	0xdf, 0x5c, 0xc3, 0x68, 0x5a, 0xda, 0x4d, 0x09, 0x20, 0xbe, 0xde, 0xc6, 0x68, 0x8d, 0xf1, 0xf5,
	0x36, 0xe2, 0xed, 0x35, 0x0c, 0xd0, 0x18, 0x6f, 0x2b, 0xfe, 0xad, 0x76, 0xdd, 0x9e, 0xc0, 0x6f,
	0x29, 0xfe, 0xc6, 0x1a, 0xbe, 0x6e, 0x8c, 0x6f, 0xac, 0x91, 0x3a, 0xd8, 0xfd, 0xfb, 0xf4, 0x18,
	0xfd, 0x35, 0x06, 0x44, 0x74, 0x8f, 0x9f, 0x17, 0xa1, 0x8a, 0xe5, 0x7e, 0x87, 0xf6, 0xa9, 0x1f,
	0x8a, 0x21, 0x59, 0x02, 0xc7, 0xd7, 0x67, 0x9d, 0x7c, 0x1d, 0x55, 0x83, 0x12, 0x17, 0x2a, 0xf4,
	0x88, 0x86, 0x11, 0x3d, 0x88, 0x18, 0x7a, 0x6e, 0x28, 0x63, 0x98, 0x5c, 0x87, 0x2b, 0xaa, 0x84,
	0xfc, 0x64, 0x10, 0x0b, 0xdd, 0x32, 0x8a, 0x05, 0x68, 0xb8, 0x23, 0x71, 0x49, 0x8b, 0x18, 0x4d,
	0x0d, 0xcd, 0xce, 0xd3, 0xd0, 0xa0, 0x68, 0x6b, 0x50, 0x7b, 0xc2, 0x43, 0xc1, 0xd2, 0x6e, 0x9f,
	0xf1, 0x6e, 0xca, 0xfc, 0x24, 0x0e, 0x26, 0xde, 0xba, 0xa8, 0xcc, 0xbb, 0x8c, 0xef, 0xa1, 0x91,
	0xec, 0x42, 0xed, 0x60, 0x68, 0x04, 0xa6, 0x4d, 0xe6, 0xb1, 0x4d, 0x9a, 0x33, 0x4a, 0x29, 0x97,
	0x2a, 0x73, 0x23, 0xca, 0x77, 0x19, 0xd7, 0x15, 0x40, 0x3c, 0x20, 0x39, 0x1f, 0xcc, 0x95, 0xe5,
	0x0b, 0x5c, 0x79, 0x35, 0x73, 0xd2, 0xdc, 0x59, 0x07, 0x7b, 0x90, 0xb2, 0xa0, 0xee, 0xe4, 0x82,
	0x88, 0x08, 0x79, 0x03, 0xaa, 0x51, 0xd2, 0x0b, 0x7d, 0x1a, 0x75, 0xd1, 0x91, 0x7a, 0x25, 0x47,
	0x59, 0xd0, 0xa6, 0x8e, 0xb4, 0x90, 0x75, 0x20, 0x5f, 0x0c, 0x18, 0x0f, 0x27, 0xa3, 0x03, 0xb9,
	0xe8, 0x5c, 0xd5, 0xf6, 0x2c, 0x3c, 0x3a, 0xf9, 0xa3, 0x22, 0xbc, 0x20, 0x07, 0xe4, 0x7f, 0x9b,
	0xa9, 0xef, 0x41, 0x59, 0xee, 0x22, 0x96, 0xa6, 0x7a, 0x0e, 0xe5, 0xa3, 0x21, 0xb7, 0xd6, 0xca,
	0x27, 0xd9, 0xd6, 0xda, 0x0a, 0x82, 0x6c, 0x02, 0x69, 0x11, 0xd9, 0x30, 0x9b, 0xa9, 0x88, 0xea,
	0x57, 0x67, 0xc4, 0x72, 0xbc, 0xc7, 0xb4, 0x58, 0x29, 0xc8, 0x6d, 0x70, 0xa2, 0xc4, 0xa7, 0x91,
	0xac, 0x55, 0x1b, 0xd5, 0xaf, 0xcc, 0x50, 0x7f, 0xac, 0x29, 0xa6, 0x90, 0x8d, 0x84, 0xdc, 0x85,
	0xea, 0x1e, 0xe3, 0x47, 0x8c, 0x3f, 0x64, 0x3c, 0x95, 0x5d, 0x5d, 0xc2, 0x3b, 0x1a, 0x33, 0xee,
	0xd0, 0x0c, 0x7d, 0xc5, 0xa4, 0x8c, 0x2c, 0x43, 0xe5, 0x60, 0x10, 0x46, 0x41, 0x57, 0xd0, 0x1e,
	0x16, 0x59, 0xc5, 0x7c, 0x0a, 0xe1, 0x7d, 0xda, 0x23, 0xaf, 0x01, 0xe0, 0x00, 0x94, 0x8b, 0x5b,
	0x60, 0xd5, 0x64, 0x4d, 0xa3, 0xf1, 0x2d, 0x41, 0xf6, 0xe0, 0xaa, 0xf1, 0xad, 0x6b, 0x42, 0xea,
	0xe0, 0xf8, 0x73, 0xff, 0xe6, 0x59, 0x5b, 0x8a, 0x69, 0xea, 0x36, 0x9a, 0x84, 0xdd, 0xef, 0x2c,
	0x58, 0x9c, 0xa2, 0xe6, 0x53, 0x66, 0x5d, 0x26, 0x65, 0x1d, 0x59, 0x9d, 0xda, 0x51, 0x11, 0x32,
	0xae, 0x13, 0xff, 0xf2, 0x0c, 0x2f, 0xf7, 0x43, 0xc6, 0xc7, 0x65, 0xab, 0x34, 0x12, 0x73, 0xbf,
	0x2c, 0xc0, 0x22, 0x4e, 0x9e, 0xc9, 0xc5, 0x93, 0xad, 0x67, 0xeb, 0xdf, 0xaf, 0xe7, 0xac, 0x82,
	0x0a, 0x17, 0xae, 0xa0, 0x77, 0xc1, 0x96, 0x65, 0xac, 0x6b, 0x6f, 0x79, 0x86, 0x72, 0xb2, 0x41,
	0x4c, 0x93, 0x4a, 0x11, 0xe9, 0xe4, 0x46, 0xa5, 0x2a, 0xbf, 0xa5, 0x19, 0x17, 0x4c, 0x8c, 0xd7,
	0xe9, 0x61, 0xea, 0x7e, 0x63, 0x41, 0x4d, 0x87, 0x81, 0x06, 0x9e, 0x59, 0x5c, 0x97, 0x0c, 0xc4,
	0x56, 0x6e, 0x6f, 0x16, 0xb0, 0x70, 0x5a, 0xcf, 0xdf, 0x9b, 0xf8, 0xe7, 0x63, 0x7a, 0x65, 0xba,
	0x1f, 0x82, 0x63, 0xaa, 0x85, 0xbc, 0x03, 0x25, 0x99, 0x5d, 0xf5, 0x9f, 0xf1, 0x1f, 0xd3, 0xab,
	0xb8, 0x7a, 0xb4, 0x7c, 0x00, 0xb6, 0x34, 0xc9, 0xbd, 0x24, 0x17, 0xbd, 0x95, 0x6b, 0x0a, 0x09,
	0x90, 0x06, 0x94, 0x8e, 0x68, 0x34, 0x50, 0xfb, 0xc3, 0x58, 0x14, 0xa4, 0x6f, 0x78, 0x6a, 0x41,
	0xd9, 0x34, 0xd8, 0x9b, 0x50, 0x39, 0xa4, 0x9f, 0x27, 0xbc, 0x7b, 0x44, 0x23, 0x1d, 0x8f, 0xaa,
	0x8e, 0x47, 0xe9, 0xbe, 0x34, 0x78, 0x0e, 0xda, 0x1f, 0xd2, 0x08, 0xb9, 0x61, 0xac, 0xb9, 0x85,
	0x29, 0xae, 0x34, 0x78, 0x0e, 0xda, 0x25, 0xb7, 0x01, 0xa5, 0x3e, 0x15, 0xfe, 0xa3, 0x89, 0xfd,
	0xa4, 0x20, 0xb9, 0x07, 0x07, 0x71, 0x2a, 0x70, 0xc9, 0xe5, 0xf7, 0x52, 0x86, 0x2a, 0x3f, 0x3b,
	0xcb, 0xa7, 0xbf, 0x35, 0xe7, 0x4e, 0x47, 0x4d, 0xeb, 0xa7, 0x51, 0xd3, 0xfa, 0x65, 0xd4, 0xb4,
	0x7e, 0x1d, 0x35, 0xad, 0x6f, 0x7f, 0x6f, 0xce, 0x7d, 0x5a, 0xd6, 0x41, 0xfa, 0x2b, 0x00, 0x00,
	0xff, 0xff, 0x02, 0x42, 0x1d, 0xdf, 0xe7, 0x0b, 0x00, 0x00,
}
