// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct UpdateShardCountInput {
    /// <p>The name of the stream.</p>
    pub stream_name: ::std::option::Option<::std::string::String>,
    /// <p>The new number of shards. This value has the following default limits. By default, you cannot do the following:</p>
    /// <ul>
    /// <li>
    /// <p>Set this value to more than double your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value below half your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value to more than 10000 shards in a stream (the default limit for shard count per stream is 10000 per account per region), unless you request a limit increase.</p></li>
    /// <li>
    /// <p>Scale a stream with more than 10000 shards down unless you set this value to less than 10000 shards.</p></li>
    /// </ul>
    pub target_shard_count: ::std::option::Option<i32>,
    /// <p>The scaling type. Uniform scaling creates shards of equal size.</p>
    pub scaling_type: ::std::option::Option<crate::types::ScalingType>,
    /// <p>The ARN of the stream.</p>
    pub stream_arn: ::std::option::Option<::std::string::String>,
}
impl UpdateShardCountInput {
    /// <p>The name of the stream.</p>
    pub fn stream_name(&self) -> ::std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The new number of shards. This value has the following default limits. By default, you cannot do the following:</p>
    /// <ul>
    /// <li>
    /// <p>Set this value to more than double your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value below half your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value to more than 10000 shards in a stream (the default limit for shard count per stream is 10000 per account per region), unless you request a limit increase.</p></li>
    /// <li>
    /// <p>Scale a stream with more than 10000 shards down unless you set this value to less than 10000 shards.</p></li>
    /// </ul>
    pub fn target_shard_count(&self) -> ::std::option::Option<i32> {
        self.target_shard_count
    }
    /// <p>The scaling type. Uniform scaling creates shards of equal size.</p>
    pub fn scaling_type(&self) -> ::std::option::Option<&crate::types::ScalingType> {
        self.scaling_type.as_ref()
    }
    /// <p>The ARN of the stream.</p>
    pub fn stream_arn(&self) -> ::std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
}
impl UpdateShardCountInput {
    /// Creates a new builder-style object to manufacture [`UpdateShardCountInput`](crate::operation::update_shard_count::UpdateShardCountInput).
    pub fn builder() -> crate::operation::update_shard_count::builders::UpdateShardCountInputBuilder {
        crate::operation::update_shard_count::builders::UpdateShardCountInputBuilder::default()
    }
}

/// A builder for [`UpdateShardCountInput`](crate::operation::update_shard_count::UpdateShardCountInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct UpdateShardCountInputBuilder {
    pub(crate) stream_name: ::std::option::Option<::std::string::String>,
    pub(crate) target_shard_count: ::std::option::Option<i32>,
    pub(crate) scaling_type: ::std::option::Option<crate::types::ScalingType>,
    pub(crate) stream_arn: ::std::option::Option<::std::string::String>,
}
impl UpdateShardCountInputBuilder {
    /// <p>The name of the stream.</p>
    pub fn stream_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the stream.</p>
    pub fn set_stream_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_name = input;
        self
    }
    /// <p>The name of the stream.</p>
    pub fn get_stream_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_name
    }
    /// <p>The new number of shards. This value has the following default limits. By default, you cannot do the following:</p>
    /// <ul>
    /// <li>
    /// <p>Set this value to more than double your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value below half your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value to more than 10000 shards in a stream (the default limit for shard count per stream is 10000 per account per region), unless you request a limit increase.</p></li>
    /// <li>
    /// <p>Scale a stream with more than 10000 shards down unless you set this value to less than 10000 shards.</p></li>
    /// </ul>
    /// This field is required.
    pub fn target_shard_count(mut self, input: i32) -> Self {
        self.target_shard_count = ::std::option::Option::Some(input);
        self
    }
    /// <p>The new number of shards. This value has the following default limits. By default, you cannot do the following:</p>
    /// <ul>
    /// <li>
    /// <p>Set this value to more than double your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value below half your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value to more than 10000 shards in a stream (the default limit for shard count per stream is 10000 per account per region), unless you request a limit increase.</p></li>
    /// <li>
    /// <p>Scale a stream with more than 10000 shards down unless you set this value to less than 10000 shards.</p></li>
    /// </ul>
    pub fn set_target_shard_count(mut self, input: ::std::option::Option<i32>) -> Self {
        self.target_shard_count = input;
        self
    }
    /// <p>The new number of shards. This value has the following default limits. By default, you cannot do the following:</p>
    /// <ul>
    /// <li>
    /// <p>Set this value to more than double your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value below half your current shard count for a stream.</p></li>
    /// <li>
    /// <p>Set this value to more than 10000 shards in a stream (the default limit for shard count per stream is 10000 per account per region), unless you request a limit increase.</p></li>
    /// <li>
    /// <p>Scale a stream with more than 10000 shards down unless you set this value to less than 10000 shards.</p></li>
    /// </ul>
    pub fn get_target_shard_count(&self) -> &::std::option::Option<i32> {
        &self.target_shard_count
    }
    /// <p>The scaling type. Uniform scaling creates shards of equal size.</p>
    /// This field is required.
    pub fn scaling_type(mut self, input: crate::types::ScalingType) -> Self {
        self.scaling_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The scaling type. Uniform scaling creates shards of equal size.</p>
    pub fn set_scaling_type(mut self, input: ::std::option::Option<crate::types::ScalingType>) -> Self {
        self.scaling_type = input;
        self
    }
    /// <p>The scaling type. Uniform scaling creates shards of equal size.</p>
    pub fn get_scaling_type(&self) -> &::std::option::Option<crate::types::ScalingType> {
        &self.scaling_type
    }
    /// <p>The ARN of the stream.</p>
    pub fn stream_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ARN of the stream.</p>
    pub fn set_stream_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_arn = input;
        self
    }
    /// <p>The ARN of the stream.</p>
    pub fn get_stream_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_arn
    }
    /// Consumes the builder and constructs a [`UpdateShardCountInput`](crate::operation::update_shard_count::UpdateShardCountInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::update_shard_count::UpdateShardCountInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::update_shard_count::UpdateShardCountInput {
            stream_name: self.stream_name,
            target_shard_count: self.target_shard_count,
            scaling_type: self.scaling_type,
            stream_arn: self.stream_arn,
        })
    }
}
