/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Sha2$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr, bitLength) - Returns a checksum of SHA-2 family as a hex string of `expr`.\n      SHA-224, SHA-256, SHA-384, and SHA-512 are supported. Bit length of 0 is equivalent to 256.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', 256);\n       529bc3b07127ecb7e53a4dcf1991d9152c24537d919178022b2c42657f79a26b\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u000e\u001d\u0001&B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005I\u0001\tE\t\u0015!\u0003D\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015A\u0007\u0001\"\u0015j\u0011\u0015\t\b\u0001\"\u0011s\u0011%\t\t\u0001AA\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\n\u0001\t\n\u0011\"\u0001\u0002\f!I\u0011\u0011\u0005\u0001\u0012\u0002\u0013\u0005\u00111\u0002\u0005\n\u0003G\u0001\u0011\u0011!C!\u0003KA\u0011\"a\u000e\u0001\u0003\u0003%\t!!\u000f\t\u0013\u0005\u0005\u0003!!A\u0005\u0002\u0005\r\u0003\"CA%\u0001\u0005\u0005I\u0011IA&\u0011%\tI\u0006AA\u0001\n\u0003\tY\u0006C\u0005\u0002`\u0001\t\t\u0011\"\u0011\u0002b\u001dI\u0011q\u0010\u000f\u0002\u0002#\u0005\u0011\u0011\u0011\u0004\t7q\t\t\u0011#\u0001\u0002\u0004\"1\u0011*\u0006C\u0001\u0003#C\u0011\"a%\u0016\u0003\u0003%)%!&\t\u0013\u0005]U#!A\u0005\u0002\u0006e\u0005\"CAP+\u0005\u0005I\u0011QAQ\u0011%\t\u0019,FA\u0001\n\u0013\t)L\u0001\u0003TQ\u0006\u0014$BA\u000f\u001f\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005}\u0001\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0005\u0012\u0013aA:rY*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001Qc&\r\u001d?!\tYC&D\u0001\u001d\u0013\tiCD\u0001\tCS:\f'/_#yaJ,7o]5p]B\u00111fL\u0005\u0003aq\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003eUr!aK\u001a\n\u0005Qb\u0012a\u00029bG.\fw-Z\u0005\u0003m]\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u000259A\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0011hP\u0005\u0003\u0001j\u0012q\u0001\u0015:pIV\u001cG/\u0001\u0003mK\u001a$X#A\"\u0011\u0005-\"\u0015BA#\u001d\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\rYE*\u0014\t\u0003W\u0001AQ!Q\u0003A\u0002\rCQaR\u0003A\u0002\r\u000b\u0001\u0002Z1uCRK\b/Z\u000b\u0002!B\u0011\u0011\u000bV\u0007\u0002%*\u00111\u000bI\u0001\u0006if\u0004Xm]\u0005\u0003+J\u0013\u0001\u0002R1uCRK\b/Z\u0001\t]VdG.\u00192mKV\t\u0001\f\u0005\u0002:3&\u0011!L\u000f\u0002\b\u0005>|G.Z1o\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002;B\u0019a,\u001a)\u000f\u0005}#gB\u00011d\u001b\u0005\t'B\u00012)\u0003\u0019a$o\\8u}%\t1(\u0003\u00025u%\u0011am\u001a\u0002\u0004'\u0016\f(B\u0001\u001b;\u00031qW\u000f\u001c7TC\u001a,WI^1m)\rQWn\u001c\t\u0003s-L!\u0001\u001c\u001e\u0003\u0007\u0005s\u0017\u0010C\u0003o\u0013\u0001\u0007!.\u0001\u0004j]B,H/\r\u0005\u0006a&\u0001\rA[\u0001\u0007S:\u0004X\u000f\u001e\u001a\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA:z}B\u0011Ao^\u0007\u0002k*\u0011a\u000fH\u0001\bG>$WmZ3o\u0013\tAXO\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015Q(\u00021\u0001|\u0003\r\u0019G\u000f\u001f\t\u0003irL!!`;\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")qP\u0003a\u0001g\u0006\u0011QM^\u0001\u0005G>\u0004\u0018\u0010F\u0003L\u0003\u000b\t9\u0001C\u0004B\u0017A\u0005\t\u0019A\"\t\u000f\u001d[\u0001\u0013!a\u0001\u0007\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0007U\r\u0019\u0015qB\u0016\u0003\u0003#\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0004\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002 \u0005U!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002(A!\u0011\u0011FA\u001a\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012\u0001\u00027b]\u001eT!!!\r\u0002\t)\fg/Y\u0005\u0005\u0003k\tYC\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003w\u00012!OA\u001f\u0013\r\tyD\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004U\u0006\u0015\u0003\"CA$!\u0005\u0005\t\u0019AA\u001e\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\n\t\u0006\u0003\u001f\n)F[\u0007\u0003\u0003#R1!a\u0015;\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003/\n\tF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001-\u0002^!A\u0011q\t\n\u0002\u0002\u0003\u0007!.\u0001\u0004fcV\fGn\u001d\u000b\u00041\u0006\r\u0004\u0002CA$'\u0005\u0005\t\u0019\u00016)\u001f\u0001\t9'!\u001c\u0002p\u0005M\u0014QOA=\u0003w\u00022aKA5\u0013\r\tY\u0007\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t(AAB\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK3yaJd\u0003EY5u\u0019\u0016tw\r\u001e5*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011dQ\u0016\u001c7n];nA=4\u0007e\u0015%B[I\u0002c-Y7jYf\u0004\u0013m\u001d\u0011bA!,\u0007\u0010I:ue&tw\rI8gA\u0001,\u0007\u0010\u001d:a])\u0001\u0003\u0005\t\u0011!AMC\u0015)\f\u001a3i1\u00023\u000bS!.eU2D\u0006I*I\u00036\u001a\u0004\b\u000e\u0017!C:$\u0007e\u0015%B[U\n$\u0007I1sK\u0002\u001aX\u000f\u001d9peR,GM\f\u0011CSR\u0004C.\u001a8hi\"\u0004sN\u001a\u00111A%\u001c\b%Z9vSZ\fG.\u001a8uAQ|\u0007EM\u001b7])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t9(\u0001@\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u001a\u0006/\u0019:lO1\u0002#'\u000e\u001c*w)\u0001\u0003\u0005\t\u0011!A\u0001*$'\u000f2dg\t\u0004t'\r\u001a8K\u000e\u0014w'Z\u001b4CR\"7MZ\u0019:sE\"\u0017(M\u001b3GJ\"TgM\u001cesEJ\u0014g\u000e\u001d1eI\u0012'g\u0019\u001b3mU:dmN\u001dbeY\u0012'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005u\u0014!B\u0019/k9\u0002\u0014\u0001B*iCJ\u0002\"aK\u000b\u0014\tU\t)\t\u000f\t\b\u0003\u000f\u000biiQ\"L\u001b\t\tIIC\u0002\u0002\fj\nqA];oi&lW-\u0003\u0003\u0002\u0010\u0006%%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011\u0011Q\u0001\ti>\u001cFO]5oOR\u0011\u0011qE\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0017\u0006m\u0015Q\u0014\u0005\u0006\u0003b\u0001\ra\u0011\u0005\u0006\u000fb\u0001\raQ\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u0019+a,\u0011\u000be\n)+!+\n\u0007\u0005\u001d&H\u0001\u0004PaRLwN\u001c\t\u0006s\u0005-6iQ\u0005\u0004\u0003[S$A\u0002+va2,'\u0007\u0003\u0005\u00022f\t\t\u00111\u0001L\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u00028B!\u0011\u0011FA]\u0013\u0011\tY,a\u000b\u0003\r=\u0013'.Z2u\u0001")
public class Sha2
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Sha2 sha2) {
        return Sha2$.MODULE$.unapply(sha2);
    }

    public static Function1<Tuple2<Expression, Expression>, Sha2> tupled() {
        return Sha2$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Sha2>> curried() {
        return Sha2$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{BinaryType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        UTF8String uTF8String;
        int bitLength = BoxesRunTime.unboxToInt((Object)input2);
        byte[] input = (byte[])input1;
        int n = bitLength;
        switch (n) {
            case 224: {
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA-224");
                    md.update(input);
                    uTF8String = UTF8String.fromBytes((byte[])md.digest());
                }
                catch (NoSuchAlgorithmException noa) {
                    uTF8String = null;
                }
                break;
            }
            case 0: 
            case 256: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha256Hex((byte[])input));
                break;
            }
            case 384: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha384Hex((byte[])input));
                break;
            }
            case 512: {
                uTF8String = UTF8String.fromString((String)DigestUtils.sha512Hex((byte[])input));
                break;
            }
            default: {
                uTF8String = null;
                break;
            }
        }
        return uTF8String;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String digestUtils = DigestUtils.class.getName();
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(645).append("\n        if (").append((String)eval2).append(" == 224) {\n          try {\n            java.security.MessageDigest md = java.security.MessageDigest.getInstance(\"SHA-224\");\n            md.update(").append((String)eval1).append(");\n            ").append(ev.value()).append(" = UTF8String.fromBytes(md.digest());\n          } catch (java.security.NoSuchAlgorithmException e) {\n            ").append(ev.isNull()).append(" = true;\n          }\n        } else if (").append((String)eval2).append(" == 256 || ").append((String)eval2).append(" == 0) {\n          ").append(ev.value()).append(" =\n            UTF8String.fromString(").append(digestUtils).append(".sha256Hex(").append((String)eval1).append("));\n        } else if (").append((String)eval2).append(" == 384) {\n          ").append(ev.value()).append(" =\n            UTF8String.fromString(").append(digestUtils).append(".sha384Hex(").append((String)eval1).append("));\n        } else if (").append((String)eval2).append(" == 512) {\n          ").append(ev.value()).append(" =\n            UTF8String.fromString(").append(digestUtils).append(".sha512Hex(").append((String)eval1).append("));\n        } else {\n          ").append(ev.isNull()).append(" = true;\n        }\n      ").toString());
    }

    public Sha2 copy(Expression left, Expression right) {
        return new Sha2(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Sha2";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sha2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sha2)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sha2 sha2 = (Sha2)x$1;
        Expression expression = this.left();
        Expression expression2 = sha2.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = sha2.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sha2.canEqual(this)) return false;
        return true;
    }

    public Sha2(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

