/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.PercentRank$;
import org.apache.spark.sql.catalyst.expressions.RankLike;
import org.apache.spark.sql.catalyst.expressions.SizeBasedWindowFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_() - Computes the percentage ranking of a value in a group of values.\n  ", arguments="\n    Arguments:\n      * children - this is to base the rank on; a change in the value of one the children will\n          trigger a change in rank. This is an internal parameter and will be assigned by the\n          Analyser.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t0.0\n       A1\t1\t0.0\n       A1\t2\t1.0\n       A2\t3\t0.0\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\r\u001b\u0001\u001eB\u0001\u0002\u000f\u0001\u0003\u0016\u0004%\t!\u000f\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005u!)!\n\u0001C\u0001\u0017\")!\n\u0001C\u0001\u001d\")q\n\u0001C!!\")1\u000b\u0001C!)\"91\f\u0001b\u0001\n\u0003b\u0006B\u00021\u0001A\u0003%Q\fC\u0003b\u0001\u0011\u0005#\rC\u0004l\u0001\u0005\u0005I\u0011\u00017\t\u000f9\u0004\u0011\u0013!C\u0001_\"9!\u0010AA\u0001\n\u0003Z\b\"CA\u0004\u0001\u0005\u0005I\u0011AA\u0005\u0011%\t\t\u0002AA\u0001\n\u0003\t\u0019\u0002C\u0005\u0002 \u0001\t\t\u0011\"\u0011\u0002\"!I\u0011q\u0006\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0007\u0005\n\u0003w\u0001\u0011\u0011!C!\u0003{9\u0011\"a\u001a\u001b\u0003\u0003E\t!!\u001b\u0007\u0011eQ\u0012\u0011!E\u0001\u0003WBaAS\n\u0005\u0002\u0005e\u0004\"CA>'\u0005\u0005IQIA?\u0011%\tyhEA\u0001\n\u0003\u000b\t\tC\u0005\u0002\u0006N\t\t\u0011\"!\u0002\b\"I\u00111S\n\u0002\u0002\u0013%\u0011Q\u0013\u0002\f!\u0016\u00148-\u001a8u%\u0006t7N\u0003\u0002\u001c9\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tib$\u0001\u0005dCR\fG._:u\u0015\ty\u0002%A\u0002tc2T!!\t\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\r\"\u0013AB1qC\u000eDWMC\u0001&\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0006L\u00186!\tI#&D\u0001\u001b\u0013\tY#D\u0001\u0005SC:\\G*[6f!\tIS&\u0003\u0002/5\t92+\u001b>f\u0005\u0006\u001cX\rZ,j]\u0012|wOR;oGRLwN\u001c\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\b!J|G-^2u!\t\u0001d'\u0003\u00028c\ta1+\u001a:jC2L'0\u00192mK\u0006A1\r[5mIJ,g.F\u0001;!\rY4I\u0012\b\u0003y\u0005s!!\u0010!\u000e\u0003yR!a\u0010\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0014B\u0001\"2\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001R#\u0003\u0007M+\u0017O\u0003\u0002CcA\u0011\u0011fR\u0005\u0003\u0011j\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003%\u0019\u0007.\u001b7ee\u0016t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u00196\u0003\"!\u000b\u0001\t\u000ba\u001a\u0001\u0019\u0001\u001e\u0015\u00031\u000b\u0011b^5uQ>\u0013H-\u001a:\u0015\u00051\u000b\u0006\"\u0002*\u0006\u0001\u0004Q\u0014!B8sI\u0016\u0014\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003U\u0003\"AV-\u000e\u0003]S!\u0001\u0017\u0010\u0002\u000bQL\b/Z:\n\u0005i;&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002%\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\\\u000b\u0002;B\u0011\u0011FX\u0005\u0003?j\u0011!!\u00134\u0002'\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0011\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001d!\t!\u0007N\u0004\u0002fMB\u0011Q(M\u0005\u0003OF\na\u0001\u0015:fI\u00164\u0017BA5k\u0005\u0019\u0019FO]5oO*\u0011q-M\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002M[\"9\u0001H\u0003I\u0001\u0002\u0004Q\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0002a*\u0012!(]\u0016\u0002eB\u00111\u000f_\u0007\u0002i*\u0011QO^\u0001\nk:\u001c\u0007.Z2lK\u0012T!a^\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002zi\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005a\bcA?\u0002\u00065\taPC\u0002\u0000\u0003\u0003\tA\u0001\\1oO*\u0011\u00111A\u0001\u0005U\u00064\u0018-\u0003\u0002j}\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0002\t\u0004a\u00055\u0011bAA\bc\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QCA\u000e!\r\u0001\u0014qC\u0005\u0004\u00033\t$aA!os\"I\u0011Q\u0004\b\u0002\u0002\u0003\u0007\u00111B\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0002CBA\u0013\u0003W\t)\"\u0004\u0002\u0002()\u0019\u0011\u0011F\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002.\u0005\u001d\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\r\u0002:A\u0019\u0001'!\u000e\n\u0007\u0005]\u0012GA\u0004C_>dW-\u00198\t\u0013\u0005u\u0001#!AA\u0002\u0005U\u0011AB3rk\u0006d7\u000f\u0006\u0003\u00024\u0005}\u0002\"CA\u000f#\u0005\u0005\t\u0019AA\u000bQ]\u0001\u00111IA%\u0003\u0017\ny%!\u0015\u0002V\u0005]\u00131LA/\u0003C\n\u0019\u0007E\u0002*\u0003\u000bJ1!a\u0012\u001b\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u0014\u0002'*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015*A5\u00023i\\7qkR,7\u000f\t;iK\u0002\u0002XM]2f]R\fw-\u001a\u0011sC:\\\u0017N\\4!_\u001a\u0004\u0013\r\t<bYV,\u0007%\u001b8!C\u0002:'o\\;qA=4\u0007E^1mk\u0016\u001chF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002T\u0005\t9M\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!G\"LG\u000e\u001a:f]\u0002j\u0003\u0005\u001e5jg\u0002J7\u000f\t;pA\t\f7/\u001a\u0011uQ\u0016\u0004#/\u00198lA=t7\bI1!G\"\fgnZ3!S:\u0004C\u000f[3!m\u0006dW/\u001a\u0011pM\u0002zg.\u001a\u0011uQ\u0016\u00043\r[5mIJ,g\u000eI<jY2T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011ue&<w-\u001a:!C\u0002\u001a\u0007.\u00198hK\u0002Jg\u000e\t:b].t\u0003\u0005\u00165jg\u0002J7\u000fI1oA%tG/\u001a:oC2\u0004\u0003/\u0019:b[\u0016$XM\u001d\u0011b]\u0012\u0004s/\u001b7mA\t,\u0007%Y:tS\u001etW\r\u001a\u0011cs\u0002\"\b.\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\ne.\u00197zg\u0016\u0014hF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA-\u0003\u0005\u001d&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI1-A\td\u0003e\u0018$V\u001d\u000e{\u0006FY\u0015!\u001fZ+%\u000b\t\u0015Q\u0003J#\u0016\nV%P\u001d\u0002\u0012\u0015\fI1!\u001fJ#UI\u0015\u0011C3\u0002\u0012\u0017\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003fJ!2O1\u0002#'\u000b\u0017!Q\u001d\n\u0015g\n\u0017!c%b\u0003\u0005K\u0014Be\u001db\u0003eM\u0015-A!:\u0013)M\u0014-AEJ\u0003\u0005^1cQ\u0005d\u0003EY\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u000b\u0014\"M\u00051]AR\u0001\u0005\t\u0011!A\u0001\u0002\u0013)M\u00052\u0013Ar\u0003G\u0003\u0011!A\u0001\u0002\u0003\u0005I!2\u0013IJ\u0011G\f\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u0003JJ1'\u0003\u0019/a)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002`\u0005)!G\f\u0019/a\u0005)qM]8va\u0006\u0012\u0011QM\u0001\ro&tGm\\<`MVt7m]\u0001\f!\u0016\u00148-\u001a8u%\u0006t7\u000e\u0005\u0002*'M!1#!\u001c6!\u0019\ty'!\u001e;\u00196\u0011\u0011\u0011\u000f\u0006\u0004\u0003g\n\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003o\n\tHA\tBEN$(/Y2u\rVt7\r^5p]F\"\"!!\u001b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001`\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u0019\u0006\r\u0005\"\u0002\u001d\u0017\u0001\u0004Q\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0013\u000by\t\u0005\u00031\u0003\u0017S\u0014bAAGc\t1q\n\u001d;j_:D\u0001\"!%\u0018\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a&\u0011\u0007u\fI*C\u0002\u0002\u001cz\u0014aa\u00142kK\u000e$\b")
public class PercentRank
extends RankLike
implements SizeBasedWindowFunction {
    private final Seq<Expression> children;
    private final If evaluateExpression;
    private final AttributeReference n;

    public static Option<Seq<Expression>> unapply(PercentRank percentRank) {
        return PercentRank$.MODULE$.unapply(percentRank);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<PercentRank, A> function1) {
        return PercentRank$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, PercentRank> compose(Function1<A, Seq<Expression>> function1) {
        return PercentRank$.MODULE$.compose(function1);
    }

    @Override
    public AttributeReference n() {
        return this.n;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$SizeBasedWindowFunction$_setter_$n_$eq(AttributeReference x$1) {
        this.n = x$1;
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public PercentRank withOrder(Seq<Expression> order) {
        return new PercentRank(order);
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public If evaluateExpression() {
        return this.evaluateExpression;
    }

    @Override
    public String prettyName() {
        return "percent_rank";
    }

    public PercentRank copy(Seq<Expression> children2) {
        return new PercentRank(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "PercentRank";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PercentRank;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PercentRank)) return false;
        boolean bl = true;
        if (!bl) return false;
        PercentRank percentRank = (PercentRank)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = percentRank.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!percentRank.canEqual(this)) return false;
        return true;
    }

    public PercentRank(Seq<Expression> children2) {
        this.children = children2;
        SizeBasedWindowFunction.$init$(this);
        this.evaluateExpression = new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.n()).$greater(this.one())), package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.rank()).$minus(this.one())).cast(DoubleType$.MODULE$)).$div(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.n()).$minus(this.one())).cast(DoubleType$.MODULE$)), package$expressions$.MODULE$.doubleToLiteral(0.0));
    }

    public PercentRank() {
        this((Seq<Expression>)Nil$.MODULE$);
    }
}

