/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyUtils;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.manager.FederationPolicyManager;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterPolicyFacade {
    private static final Logger LOG = LoggerFactory.getLogger(RouterPolicyFacade.class);
    private final SubClusterResolver subClusterResolver;
    private final FederationStateStoreFacade federationFacade;
    private Map<String, SubClusterPolicyConfiguration> globalConfMap;
    @VisibleForTesting
    Map<String, FederationRouterPolicy> globalPolicyMap;

    public RouterPolicyFacade(Configuration conf, FederationStateStoreFacade facade, SubClusterResolver resolver, SubClusterId homeSubcluster) throws FederationPolicyInitializationException {
        this.federationFacade = facade;
        this.subClusterResolver = resolver;
        this.globalConfMap = new ConcurrentHashMap<String, SubClusterPolicyConfiguration>();
        this.globalPolicyMap = new ConcurrentHashMap<String, FederationRouterPolicy>();
        String defaultKey = "*";
        SubClusterPolicyConfiguration configuration = null;
        try {
            configuration = this.federationFacade.getPolicyConfiguration(defaultKey);
        }
        catch (YarnException e) {
            LOG.warn("No fallback behavior defined in store, defaulting to XML configuration fallback behavior.");
        }
        if (configuration == null) {
            String defaultFederationPolicyManager = conf.get("yarn.federation.policy-manager", "org.apache.hadoop.yarn.server.federation.policies.manager.UniformBroadcastPolicyManager");
            String defaultPolicyParamString = conf.get("yarn.federation.policy-manager-params", "");
            ByteBuffer defaultPolicyParam = ByteBuffer.wrap(defaultPolicyParamString.getBytes(StandardCharsets.UTF_8));
            configuration = SubClusterPolicyConfiguration.newInstance(defaultKey, defaultFederationPolicyManager, defaultPolicyParam);
        }
        FederationPolicyInitializationContext fallbackContext = new FederationPolicyInitializationContext(configuration, this.subClusterResolver, this.federationFacade, homeSubcluster);
        FederationPolicyManager fallbackPolicyManager = FederationPolicyUtils.instantiatePolicyManager(configuration.getType());
        fallbackPolicyManager.setQueue(defaultKey);
        this.globalConfMap.put(defaultKey, fallbackContext.getSubClusterPolicyConfiguration());
        this.globalPolicyMap.put(defaultKey, fallbackPolicyManager.getRouterPolicy(fallbackContext, null));
    }

    public SubClusterId getHomeSubcluster(ApplicationSubmissionContext appSubmissionContext, List<SubClusterId> blackListSubClusters) throws YarnException {
        FederationRouterPolicy policy;
        String errMsg;
        Map<String, SubClusterPolicyConfiguration> cachedConfs = this.globalConfMap;
        Map<String, FederationRouterPolicy> policyMap = this.globalPolicyMap;
        if (appSubmissionContext == null) {
            throw new FederationPolicyException("The ApplicationSubmissionContext cannot be null.");
        }
        String queue = appSubmissionContext.getQueue();
        if (queue == null) {
            queue = "default";
        }
        SubClusterPolicyConfiguration configuration = null;
        try {
            configuration = this.federationFacade.getPolicyConfiguration(queue);
        }
        catch (YarnException e) {
            errMsg = "There is no policy configured for the queue: " + queue + ", falling back to defaults.";
            LOG.warn(errMsg, (Throwable)e);
        }
        if (configuration == null) {
            LOG.warn("There is no policies configured for queue: " + queue + " we fallback to default policy for: " + "*");
            queue = "*";
            try {
                configuration = this.federationFacade.getPolicyConfiguration(queue);
            }
            catch (YarnException e) {
                errMsg = "Cannot retrieve policy configured for the queue: " + queue + ", falling back to defaults.";
                LOG.warn(errMsg, (Throwable)e);
            }
        }
        if (configuration == null) {
            configuration = cachedConfs.get("*");
        }
        if (!cachedConfs.containsKey(queue) || !cachedConfs.get(queue).equals(configuration)) {
            this.singlePolicyReinit(policyMap, cachedConfs, queue, configuration);
        }
        if ((policy = policyMap.get(queue)) == null) {
            throw new FederationPolicyException("No FederationRouterPolicy found for queue: " + appSubmissionContext.getQueue() + " (for application: " + appSubmissionContext.getApplicationId() + ") and no default specified.");
        }
        return policy.getHomeSubcluster(appSubmissionContext, blackListSubClusters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void singlePolicyReinit(Map<String, FederationRouterPolicy> policyMap, Map<String, SubClusterPolicyConfiguration> cachedConfs, String queue, SubClusterPolicyConfiguration conf) throws FederationPolicyInitializationException {
        FederationPolicyInitializationContext context = new FederationPolicyInitializationContext(conf, this.subClusterResolver, this.federationFacade, null);
        String newType = context.getSubClusterPolicyConfiguration().getType();
        FederationRouterPolicy routerPolicy = policyMap.get(queue);
        FederationPolicyManager federationPolicyManager = FederationPolicyUtils.instantiatePolicyManager(newType);
        federationPolicyManager.setQueue(queue);
        routerPolicy = federationPolicyManager.getRouterPolicy(context, routerPolicy);
        RouterPolicyFacade routerPolicyFacade = this;
        synchronized (routerPolicyFacade) {
            policyMap.put(queue, routerPolicy);
            cachedConfs.put(queue, conf);
        }
    }

    public synchronized void reset() {
        SubClusterPolicyConfiguration conf = this.globalConfMap.get("*");
        FederationRouterPolicy policy = this.globalPolicyMap.get("*");
        this.globalConfMap = new ConcurrentHashMap<String, SubClusterPolicyConfiguration>();
        this.globalPolicyMap = new ConcurrentHashMap<String, FederationRouterPolicy>();
        this.globalConfMap.put("*", conf);
        this.globalPolicyMap.put("*", policy);
    }
}

