/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.logging;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.util.logging.FileAppender;
import org.apache.spark.util.logging.RollingFileAppender$;
import org.apache.spark.util.logging.RollingPolicy;
import org.sparkproject.guava.io.Files;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd!\u0002\u000f\u001e\u0001\u0005:\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011Y\u0002!\u0011!Q\u0001\n]B\u0001B\u000f\u0001\u0003\u0006\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005y!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u001d!\u0006A1A\u0005\nUCaA\u0016\u0001!\u0002\u00131\u0005bB,\u0001\u0005\u0004%I\u0001\u0017\u0005\u00079\u0002\u0001\u000b\u0011B-\t\u000bu\u0003A\u0011\t0\t\u000b\t\u0004A\u0011K2\t\u000b9\u0004A\u0011\u00020\t\u000b=\u0004A\u0011\u00029\t\u000bQ\u0004A\u0011B;\t\u000ba\u0004A\u0011\u00020\t\re\u0004A\u0011A\u0010_\u000f\u0019QX\u0004#\u0001\"w\u001a1A$\bE\u0001CqDa\u0001\u0014\u000b\u0005\u0002\u0005\u0005\u0001\u0002CA\u0002)\t\u0007I\u0011A+\t\u000f\u0005\u0015A\u0003)A\u0005\r\"I\u0011q\u0001\u000bC\u0002\u0013\u0005\u0011\u0011\u0002\u0005\t\u0003/!\u0002\u0015!\u0003\u0002\f!9\u0011\u0011\u0004\u000b\u0005\u0002\u0005m\u0001\"CA&)E\u0005I\u0011AA'\u0005M\u0011v\u000e\u001c7j]\u001e4\u0015\u000e\\3BaB,g\u000eZ3s\u0015\tqr$A\u0004m_\u001e<\u0017N\\4\u000b\u0005\u0001\n\u0013\u0001B;uS2T!AI\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\n\u0003\u0001!\u0002\"!\u000b\u0016\u000e\u0003uI!aK\u000f\u0003\u0019\u0019KG.Z!qa\u0016tG-\u001a:\u0002\u0017%t\u0007/\u001e;TiJ,\u0017-\\\u0002\u0001!\tyC'D\u00011\u0015\t\t$'\u0001\u0002j_*\t1'\u0001\u0003kCZ\f\u0017BA\u001b1\u0005-Ie\u000e];u'R\u0014X-Y7\u0002\u0015\u0005\u001cG/\u001b<f\r&dW\r\u0005\u00020q%\u0011\u0011\b\r\u0002\u0005\r&dW-A\u0007s_2d\u0017N\\4Q_2L7-_\u000b\u0002yA\u0011\u0011&P\u0005\u0003}u\u0011QBU8mY&tw\rU8mS\u000eL\u0018A\u0004:pY2Lgn\u001a)pY&\u001c\u0017\u0010I\u0001\u0005G>tg\r\u0005\u0002C\u00076\t\u0011%\u0003\u0002EC\tI1\u000b]1sW\u000e{gNZ\u0001\u000bEV4g-\u001a:TSj,\u0007CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%aA%oi\u00061A(\u001b8jiz\"bAT(Q#J\u001b\u0006CA\u0015\u0001\u0011\u0015as\u00011\u0001/\u0011\u00151t\u00011\u00018\u0011\u0015Qt\u00011\u0001=\u0011\u0015\u0001u\u00011\u0001B\u0011\u001d)u\u0001%AA\u0002\u0019\u000b\u0001#\\1y%\u0016$\u0018-\u001b8fI\u001aKG.Z:\u0016\u0003\u0019\u000b\u0011#\\1y%\u0016$\u0018-\u001b8fI\u001aKG.Z:!\u0003E)g.\u00192mK\u000e{W\u000e\u001d:fgNLwN\\\u000b\u00023B\u0011qIW\u0005\u00037\"\u0013qAQ8pY\u0016\fg.\u0001\nf]\u0006\u0014G.Z\"p[B\u0014Xm]:j_:\u0004\u0013\u0001B:u_B$\u0012a\u0018\t\u0003\u000f\u0002L!!\u0019%\u0003\tUs\u0017\u000e^\u0001\rCB\u0004XM\u001c3U_\u001aKG.\u001a\u000b\u0004?\u0012d\u0007\"B3\u000e\u0001\u00041\u0017!\u00022zi\u0016\u001c\bcA$hS&\u0011\u0001\u000e\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u000f*L!a\u001b%\u0003\t\tKH/\u001a\u0005\u0006[6\u0001\rAR\u0001\u0004Y\u0016t\u0017\u0001\u0003:pY2|g/\u001a:\u0002\u0015I|G/\u0019;f\r&dW\rF\u0002`cJDQAN\bA\u0002]BQa]\bA\u0002]\nAB]8mY>4XM\u001d$jY\u0016\f\u0011C]8mY>4XM\u001d$jY\u0016,\u00050[:u)\tIf\u000fC\u0003x!\u0001\u0007q'\u0001\u0003gS2,\u0017\u0001C7pm\u00164\u0015\u000e\\3\u0002\u001d\u0011,G.\u001a;f\u001f2$g)\u001b7fg\u0006\u0019\"k\u001c7mS:<g)\u001b7f\u0003B\u0004XM\u001c3feB\u0011\u0011\u0006F\n\u0003)u\u0004\"a\u0012@\n\u0005}D%AB!osJ+g\rF\u0001|\u0003M!UIR!V\u0019R{&)\u0016$G\u000bJ{6+\u0013.F\u0003Q!UIR!V\u0019R{&)\u0016$G\u000bJ{6+\u0013.FA\u0005yqIW%Q?2{uiX*V\r\u001aK\u0005,\u0006\u0002\u0002\fA!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012I\nA\u0001\\1oO&!\u0011QCA\b\u0005\u0019\u0019FO]5oO\u0006\u0001rIW%Q?2{uiX*V\r\u001aK\u0005\fI\u0001\u0019O\u0016$8k\u001c:uK\u0012\u0014v\u000e\u001c7fI>3XM\u001d$jY\u0016\u001cHCBA\u000f\u0003k\t9\u0005E\u0003\u0002 \u0005=rG\u0004\u0003\u0002\"\u0005-b\u0002BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001dR&\u0001\u0004=e>|GOP\u0005\u0002\u0013&\u0019\u0011Q\u0006%\u0002\u000fA\f7m[1hK&!\u0011\u0011GA\u001a\u0005\r\u0019V-\u001d\u0006\u0004\u0003[A\u0005bBA\u001c5\u0001\u0007\u0011\u0011H\u0001\nI&\u0014Xm\u0019;pef\u0004B!a\u000f\u0002D9!\u0011QHA !\r\t\u0019\u0003S\u0005\u0004\u0003\u0003B\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0016\u0005\u0015#bAA!\u0011\"9\u0011\u0011\n\u000eA\u0002\u0005e\u0012AD1di&4XMR5mK:\u000bW.Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005=#f\u0001$\u0002R-\u0012\u00111\u000b\t\u0005\u0003+\ny&\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003%)hn\u00195fG.,GMC\u0002\u0002^!\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t'a\u0016\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class RollingFileAppender
extends FileAppender {
    public final File org$apache$spark$util$logging$RollingFileAppender$$activeFile;
    private final RollingPolicy rollingPolicy;
    private final int maxRetainedFiles;
    private final boolean enableCompression;

    public static int $lessinit$greater$default$5() {
        return RollingFileAppender$.MODULE$.$lessinit$greater$default$5();
    }

    public static Seq<File> getSortedRolledOverFiles(String string, String string2) {
        return RollingFileAppender$.MODULE$.getSortedRolledOverFiles(string, string2);
    }

    public static String GZIP_LOG_SUFFIX() {
        return RollingFileAppender$.MODULE$.GZIP_LOG_SUFFIX();
    }

    public static int DEFAULT_BUFFER_SIZE() {
        return RollingFileAppender$.MODULE$.DEFAULT_BUFFER_SIZE();
    }

    public RollingPolicy rollingPolicy() {
        return this.rollingPolicy;
    }

    private int maxRetainedFiles() {
        return this.maxRetainedFiles;
    }

    private boolean enableCompression() {
        return this.enableCompression;
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public void appendToFile(byte[] bytes, int len) {
        if (this.rollingPolicy().shouldRollover(len)) {
            this.rollover();
            this.rollingPolicy().rolledOver();
        }
        super.appendToFile(bytes, len);
        this.rollingPolicy().bytesWritten(len);
    }

    private void rollover() {
        try {
            this.closeFile();
            this.moveFile();
            this.openFile();
            if (this.maxRetainedFiles() > 0) {
                this.deleteOldFiles();
            }
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Error rolling over ").append($this.org$apache$spark$util$logging$RollingFileAppender$$activeFile).toString(), e);
        }
    }

    private void rotateFile(File activeFile, File rolloverFile) {
        if (this.enableCompression()) {
            File gzFile = new File(new StringBuilder(0).append(rolloverFile.getAbsolutePath()).append(RollingFileAppender$.MODULE$.GZIP_LOG_SUFFIX()).toString());
            GZIPOutputStream gzOutputStream = null;
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(activeFile);
                gzOutputStream = new GZIPOutputStream(new FileOutputStream(gzFile));
                IOUtils.copy((InputStream)inputStream, (OutputStream)gzOutputStream);
                ((InputStream)inputStream).close();
                gzOutputStream.close();
                activeFile.delete();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(gzOutputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)gzOutputStream);
        } else {
            Files.move((File)activeFile, (File)rolloverFile);
        }
    }

    private boolean rolloverFileExist(File file) {
        return file.exists() || new File(new StringBuilder(0).append(file.getAbsolutePath()).append(RollingFileAppender$.MODULE$.GZIP_LOG_SUFFIX()).toString()).exists();
    }

    private void moveFile() {
        String rolloverSuffix = this.rollingPolicy().generateRolledOverFileSuffix();
        File rolloverFile = new File(this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getParentFile(), new StringBuilder(0).append(this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getName()).append(rolloverSuffix).toString()).getAbsoluteFile();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Attempting to rollover file ").append($this.org$apache$spark$util$logging$RollingFileAppender$$activeFile).append(" to file ").append(rolloverFile).toString());
        if (this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.exists()) {
            if (!this.rolloverFileExist(rolloverFile)) {
                this.rotateFile(this.org$apache$spark$util$logging$RollingFileAppender$$activeFile, rolloverFile);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Rolled over ").append($this.org$apache$spark$util$logging$RollingFileAppender$$activeFile).append(" to ").append(rolloverFile).toString());
            } else {
                int i = 0;
                ObjectRef altRolloverFile = ObjectRef.create(null);
                do {
                    altRolloverFile.elem = new File(this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getParent(), new StringBuilder(2).append(this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getName()).append(rolloverSuffix).append("--").append(i).toString()).getAbsoluteFile();
                } while (++i < 10000 && this.rolloverFileExist((File)altRolloverFile.elem));
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Rollover file ").append(rolloverFile).append(" already exists, ").append("rolled over ").append($this.org$apache$spark$util$logging$RollingFileAppender$$activeFile).append(" to file ").append((File)altRolloverFile$1.elem).toString());
                this.rotateFile(this.org$apache$spark$util$logging$RollingFileAppender$$activeFile, (File)altRolloverFile.elem);
            }
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("File ").append($this.org$apache$spark$util$logging$RollingFileAppender$$activeFile).append(" does not exist").toString());
        }
    }

    public void deleteOldFiles() {
        try {
            File[] rolledoverFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getParentFile().listFiles(new FileFilter(this){
                private final /* synthetic */ RollingFileAppender $outer;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean accept(File f) {
                    if (!f.getName().startsWith(this.$outer.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getName())) return false;
                    File file = f;
                    File file2 = this.$outer.org$apache$spark$util$logging$RollingFileAppender$$activeFile;
                    if (file == null) {
                        if (file2 == null) return false;
                        return true;
                    } else if (((Object)file).equals(file2)) return false;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }))).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            File[] filesToBeDeleted = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rolledoverFiles)).take(package$.MODULE$.max(0, rolledoverFiles.length - this.maxRetainedFiles()));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesToBeDeleted)).foreach((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)RollingFileAppender.$anonfun$deleteOldFiles$1(this, file)));
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Error cleaning logs in directory ").append($this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getParentFile().getAbsolutePath()).toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteOldFiles$1(RollingFileAppender $this, File file) {
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Deleting file executor log file ").append(file.getAbsolutePath()).toString());
        return file.delete();
    }

    public RollingFileAppender(InputStream inputStream, File activeFile, RollingPolicy rollingPolicy, SparkConf conf, int bufferSize) {
        this.org$apache$spark$util$logging$RollingFileAppender$$activeFile = activeFile;
        this.rollingPolicy = rollingPolicy;
        super(inputStream, activeFile, bufferSize);
        this.maxRetainedFiles = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_LOGS_ROLLING_MAX_RETAINED_FILES()));
        this.enableCompression = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_LOGS_ROLLING_ENABLE_COMPRESSION()));
    }
}

