/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.storage;

import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.RDDPartitionInfo;
import org.apache.spark.ui.PagedTable;
import org.apache.spark.ui.storage.BlockDataSource;
import org.apache.spark.ui.storage.BlockTableRowData;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

@ScalaSignature(bytes="\u0006\u0001\u0005]b!\u0002\r\u001a\u0001m\u0019\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011y\u0002!\u0011!Q\u0001\n}B\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"Aq\f\u0001B\u0001B\u0003%\u0001\rC\u0003e\u0001\u0011\u0005Q\r\u0003\u0006m\u0001A\u0005\t1!Q\u0001\n5DqA\u001e\u0001C\u0002\u0013%q\u000f\u0003\u0004y\u0001\u0001\u0006Ia\u0010\u0005\bs\u0002\u0011\r\u0011\"\u0003{\u0011\u0019Y\b\u0001)A\u0005a\"9A\u0010\u0001b\u0001\n\u0013i\bB\u0002@\u0001A\u0003%1\u000fC\u0003\u0000\u0001\u0011\u0005s\u000f\u0003\u0004\u0002\u0002\u0001!\te\u001e\u0005\u0007\u0003\u0007\u0001A\u0011I<\t\r\u0005\u0015\u0001\u0001\"\u0011x\u0011%\t9\u0001\u0001b\u0001\n\u0003\nI\u0001\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0006\u0011\u001d\t\u0019\u0002\u0001C!\u0003+Aa!a\u0007\u0001\t\u0003:\bbBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003_\u0001A\u0011IA\u0019\u0005=\u0011En\\2l!\u0006<W\r\u001a+bE2,'B\u0001\u000e\u001c\u0003\u001d\u0019Ho\u001c:bO\u0016T!\u0001H\u000f\u0002\u0005UL'B\u0001\u0010 \u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0013%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0005\u0019qN]4\u0014\u0007\u0001!#\u0006\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VM\u001a\t\u0004W1rS\"A\u000e\n\u00055Z\"A\u0003)bO\u0016$G+\u00192mKB\u0011q\u0006M\u0007\u00023%\u0011\u0011'\u0007\u0002\u0012\u00052|7m\u001b+bE2,'k\\<ECR\f\u0017a\u0002:fcV,7\u000f^\u0002\u0001!\t)D(D\u00017\u0015\t9\u0004(\u0001\u0003iiR\u0004(BA\u001d;\u0003\u001d\u0019XM\u001d<mKRT\u0011aO\u0001\u0006U\u00064\u0018\r_\u0005\u0003{Y\u0012!\u0003\u0013;uaN+'O\u001e7fiJ+\u0017/^3ti\u00061!\u000f\u001a3UC\u001e\u0004\"\u0001Q$\u000f\u0005\u0005+\u0005C\u0001\"'\u001b\u0005\u0019%B\u0001#4\u0003\u0019a$o\\8u}%\u0011aIJ\u0001\u0007!J,G-\u001a4\n\u0005!K%AB*ue&twM\u0003\u0002GM\u0005A!-Y:f!\u0006$\b.A\u0007sI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004\u001bJ+fB\u0001(Q\u001d\t\u0011u*C\u0001(\u0013\t\tf%A\u0004qC\u000e\\\u0017mZ3\n\u0005M#&aA*fc*\u0011\u0011K\n\t\u0003-vk\u0011a\u0016\u0006\u00031f\u000b!A^\u0019\u000b\u0005i[\u0016aA1qS*\u0011A,H\u0001\u0007gR\fG/^:\n\u0005y;&\u0001\u0005*E\tB\u000b'\u000f^5uS>t\u0017J\u001c4p\u0003E)\u00070Z2vi>\u00148+^7nCJLWm\u001d\t\u0004\u001bJ\u000b\u0007C\u0001,c\u0013\t\u0019wKA\bFq\u0016\u001cW\u000f^8s'VlW.\u0019:z\u0003\u0019a\u0014N\\5u}Q1am\u001a5jU.\u0004\"a\f\u0001\t\u000bI2\u0001\u0019\u0001\u001b\t\u000by2\u0001\u0019A \t\u000b)3\u0001\u0019A \t\u000b-3\u0001\u0019\u0001'\t\u000b}3\u0001\u0019\u00011\u0002\u0007a$\u0013\bE\u0003&]~\u00028/\u0003\u0002pM\t1A+\u001e9mKN\u0002\"!J9\n\u0005I4#a\u0002\"p_2,\u0017M\u001c\t\u0003KQL!!\u001e\u0014\u0003\u0007%sG/\u0001\u0006t_J$8i\u001c7v[:,\u0012aP\u0001\fg>\u0014HoQ8mk6t\u0007%\u0001\u0003eKN\u001cW#\u00019\u0002\u000b\u0011,7o\u0019\u0011\u0002\u0011A\fw-Z*ju\u0016,\u0012a]\u0001\na\u0006<WmU5{K\u0002\nq\u0001^1cY\u0016LE-A\u0007uC\ndWmQ:t\u00072\f7o]\u0001\u0012a\u0006<WmU5{K\u001a{'/\u001c$jK2$\u0017a\u00059bO\u0016tU/\u001c2fe\u001a{'/\u001c$jK2$\u0017A\u00033bi\u0006\u001cv.\u001e:dKV\u0011\u00111\u0002\t\u0004_\u00055\u0011bAA\b3\ty!\t\\8dW\u0012\u000bG/Y*pkJ\u001cW-A\u0006eCR\f7k\\;sG\u0016\u0004\u0013\u0001\u00039bO\u0016d\u0015N\\6\u0015\u0007}\n9\u0002\u0003\u0004\u0002\u001aQ\u0001\ra]\u0001\u0005a\u0006<W-\u0001\th_\n+H\u000f^8o\r>\u0014X\u000eU1uQ\u00069\u0001.Z1eKJ\u001cXCAA\u0011!\u0011i%+a\t\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b'\u0003\rAX\u000e\\\u0005\u0005\u0003[\t9C\u0001\u0003O_\u0012,\u0017a\u0001:poR!\u0011\u0011EA\u001a\u0011\u0019\t)d\u0006a\u0001]\u0005)!\r\\8dW\u0002")
public class BlockPagedTable
implements PagedTable<BlockTableRowData> {
    private final String rddTag;
    private final String basePath;
    private final /* synthetic */ Tuple3 x$9;
    private final String sortColumn;
    private final boolean desc;
    private final int pageSize;
    private final BlockDataSource dataSource;

    @Override
    public Seq<Node> table(int page) {
        return PagedTable.table$(this, page);
    }

    @Override
    public Seq<Node> pageNavigation(int page, int pageSize, int totalPages, String navigationId) {
        return PagedTable.pageNavigation$(this, page, pageSize, totalPages, navigationId);
    }

    @Override
    public String pageNavigation$default$4() {
        return PagedTable.pageNavigation$default$4$(this);
    }

    @Override
    public String getParameterOtherTable(HttpServletRequest request, String tableTag) {
        return PagedTable.getParameterOtherTable$(this, request, tableTag);
    }

    @Override
    public Tuple3<String, Object, Object> getTableParameters(HttpServletRequest request, String tableTag, String defaultSortColumn) {
        return PagedTable.getTableParameters$(this, request, tableTag, defaultSortColumn);
    }

    @Override
    public void isSortColumnValid(Seq<Tuple3<String, Object, Option<String>>> headerInfo, String sortColumn) {
        PagedTable.isSortColumnValid$(this, headerInfo, sortColumn);
    }

    @Override
    public Seq<Node> headerRow(Seq<Tuple3<String, Object, Option<String>>> headerInfo, boolean desc, int pageSize, String sortColumn, String parameterPath, String tableTag, String headerId) {
        return PagedTable.headerRow$(this, headerInfo, desc, pageSize, sortColumn, parameterPath, tableTag, headerId);
    }

    private String sortColumn() {
        return this.sortColumn;
    }

    private boolean desc() {
        return this.desc;
    }

    private int pageSize() {
        return this.pageSize;
    }

    @Override
    public String tableId() {
        return "rdd-storage-by-block-table";
    }

    @Override
    public String tableCssClass() {
        return "table table-bordered table-sm table-striped table-head-clickable";
    }

    @Override
    public String pageSizeFormField() {
        return new StringBuilder(9).append(this.rddTag).append(".pageSize").toString();
    }

    @Override
    public String pageNumberFormField() {
        return new StringBuilder(5).append(this.rddTag).append(".page").toString();
    }

    public BlockDataSource dataSource() {
        return this.dataSource;
    }

    @Override
    public String pageLink(int page) {
        String encodedSortColumn = URLEncoder.encode(this.sortColumn(), StandardCharsets.UTF_8.name());
        return new StringBuilder(28).append(this.basePath).append("&").append(this.pageNumberFormField()).append("=").append(page).append("&block.sort=").append(encodedSortColumn).append("&block.desc=").append(this.desc()).append("&").append(this.pageSizeFormField()).append("=").append(this.pageSize()).toString();
    }

    @Override
    public String goButtonFormPath() {
        String encodedSortColumn = URLEncoder.encode(this.sortColumn(), StandardCharsets.UTF_8.name());
        return new StringBuilder(24).append(this.basePath).append("&block.sort=").append(encodedSortColumn).append("&block.desc=").append(this.desc()).toString();
    }

    @Override
    public Seq<Node> headers() {
        Seq blockHeaders = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Block Name", "Storage Level", "Size in Memory", "Size on Disk", "Executors"}))).map((Function1 & Serializable & scala.Serializable)x -> new Tuple3(x, (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), Seq$.MODULE$.canBuildFrom());
        this.isSortColumnValid((Seq<Tuple3<String, Object, Option<String>>>)blockHeaders, this.sortColumn());
        return this.headerRow((Seq<Tuple3<String, Object, Option<String>>>)blockHeaders, this.desc(), this.pageSize(), this.sortColumn(), this.basePath, this.rddTag, "block");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<Node> row(BlockTableRowData block) {
        void var2_2;
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)block.blockName());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)block.storageLevel());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)Utils$.MODULE$.bytesToString(block.memoryUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)Utils$.MODULE$.bytesToString(block.diskUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)block.executors());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    public BlockPagedTable(HttpServletRequest request, String rddTag, String basePath, Seq<RDDPartitionInfo> rddPartitions, Seq<ExecutorSummary> executorSummaries) {
        this.rddTag = rddTag;
        this.basePath = basePath;
        PagedTable.$init$(this);
        Tuple3<String, Object, Object> tuple3 = this.getTableParameters(request, rddTag, "Block Name");
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String sortColumn = (String)tuple3._1();
        boolean desc = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        int pageSize = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)sortColumn, (Object)BoxesRunTime.boxToBoolean((boolean)desc), (Object)BoxesRunTime.boxToInteger((int)pageSize));
        this.x$9 = tuple32;
        this.sortColumn = (String)this.x$9._1();
        this.desc = BoxesRunTime.unboxToBoolean((Object)this.x$9._2());
        this.pageSize = BoxesRunTime.unboxToInt((Object)this.x$9._3());
        this.dataSource = new BlockDataSource(rddPartitions, this.pageSize(), this.sortColumn(), this.desc(), (Map<String, String>)((TraversableOnce)executorSummaries.map((Function1 & Serializable & scala.Serializable)ex -> new Tuple2((Object)ex.id(), (Object)ex.hostPort()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }
}

