/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.ui.PagedTable;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.jobs.JobDataSource;
import org.apache.spark.ui.jobs.JobTableRowData;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u0005=d!\u0002\u0011\"\u0001\rZ\u0003\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\tE\u0002\u0011\t\u0011)A\u0005G\"A1\u000e\u0001B\u0001B\u0003%1\r\u0003\u0005m\u0001\t\u0005\t\u0015!\u0003d\u0011!i\u0007A!A!\u0002\u0013\u0019\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B8\t\u0011I\u0004!\u0011!Q\u0001\n\rDQa\u001d\u0001\u0005\u0002QD1b \u0001\u0011\u0002\u0003\r\t\u0015!\u0003\u0002\u0002!I\u0011Q\u0002\u0001C\u0002\u0013%\u0011q\u0002\u0005\b\u0003#\u0001\u0001\u0015!\u0003d\u0011%\t\u0019\u0002\u0001b\u0001\n\u0013\t)\u0002C\u0004\u0002\u0018\u0001\u0001\u000b\u0011B8\t\u0013\u0005e\u0001A1A\u0005\n\u0005m\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0002\t\u0013\u0005}\u0001A1A\u0005\n\u0005\u0005\u0002\u0002CA\u0019\u0001\u0001\u0006I!a\t\t\u0013\u0005M\u0002A1A\u0005\n\u0005\u0005\u0002\u0002CA\u001b\u0001\u0001\u0006I!a\t\t\u000f\u0005]\u0002\u0001\"\u0011\u0002\u0010!9\u0011\u0011\b\u0001\u0005B\u0005=\u0001bBA\u001e\u0001\u0011\u0005\u0013q\u0002\u0005\b\u0003{\u0001A\u0011IA\b\u0011%\ty\u0004\u0001b\u0001\n\u0003\n\t\u0005\u0003\u0005\u0002J\u0001\u0001\u000b\u0011BA\"\u0011\u001d\tY\u0005\u0001C!\u0003\u001bBq!a\u0015\u0001\t\u0003\ny\u0001C\u0004\u0002V\u0001!\t%a\u0016\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j\ti!j\u001c2QC\u001e,G\rV1cY\u0016T!AI\u0012\u0002\t)|'m\u001d\u0006\u0003I\u0015\n!!^5\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c2\u0001\u0001\u00173!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019\te.\u001f*fMB\u00191\u0007\u000e\u001c\u000e\u0003\rJ!!N\u0012\u0003\u0015A\u000bw-\u001a3UC\ndW\r\u0005\u00028q5\t\u0011%\u0003\u0002:C\ty!j\u001c2UC\ndWMU8x\t\u0006$\u0018-A\u0004sKF,Xm\u001d;\u0004\u0001A\u0011Q\bR\u0007\u0002})\u0011q\bQ\u0001\u0005QR$\bO\u0003\u0002B\u0005\u000691/\u001a:wY\u0016$(\"A\"\u0002\u000b)\fg/\u0019=\n\u0005\u0015s$A\u0005%uiB\u001cVM\u001d<mKR\u0014V-];fgR\fQa\u001d;pe\u0016\u0004\"\u0001S&\u000e\u0003%S!AS\u0013\u0002\rM$\u0018\r^;t\u0013\ta\u0015J\u0001\bBaB\u001cF/\u0019;vgN#xN]3\u0002\t\u0011\fG/\u0019\t\u0004\u001f^SfB\u0001)V\u001d\t\tF+D\u0001S\u0015\t\u00196(\u0001\u0004=e>|GOP\u0005\u0002_%\u0011aKL\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0016LA\u0002TKFT!A\u0016\u0018\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016A\u0001<2\u0015\ty\u0016*A\u0002ba&L!!\u0019/\u0003\u000f){'\rR1uC\u0006iA/\u00192mK\"+\u0017\rZ3s\u0013\u0012\u0004\"\u0001\u001a5\u000f\u0005\u00154\u0007CA)/\u0013\t9g&\u0001\u0004Qe\u0016$WMZ\u0005\u0003S*\u0014aa\u0015;sS:<'BA4/\u0003\u0019QwN\u0019+bO\u0006A!-Y:f!\u0006$\b.A\u0004tk\n\u0004\u0016\r\u001e5\u0002\u0017-LG\u000e\\#oC\ndW\r\u001a\t\u0003[AL!!\u001d\u0018\u0003\u000f\t{w\u000e\\3b]\u0006Q!n\u001c2JIRKG\u000f\\3\u0002\rqJg.\u001b;?)))ho\u001e=zundXP \t\u0003o\u0001AQA\u000f\u0006A\u0002qBQA\u0012\u0006A\u0002\u001dCQ!\u0014\u0006A\u00029CQA\u0019\u0006A\u0002\rDQa\u001b\u0006A\u0002\rDQ\u0001\u001c\u0006A\u0002\rDQ!\u001c\u0006A\u0002\rDQA\u001c\u0006A\u0002=DQA\u001d\u0006A\u0002\r\fA\u0001\u001f\u00132cA9Q&a\u0001d_\u0006\u001d\u0011bAA\u0003]\t1A+\u001e9mKN\u00022!LA\u0005\u0013\r\tYA\f\u0002\u0004\u0013:$\u0018AC:peR\u001cu\u000e\\;n]V\t1-A\u0006t_J$8i\u001c7v[:\u0004\u0013\u0001\u00023fg\u000e,\u0012a\\\u0001\u0006I\u0016\u001c8\rI\u0001\ta\u0006<WmU5{KV\u0011\u0011qA\u0001\na\u0006<WmU5{K\u0002\nQ\u0002]1sC6,G/\u001a:QCRDWCAA\u0012!\u0011\t)#a\f\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\tA\u0001\\1oO*\u0011\u0011QF\u0001\u0005U\u00064\u0018-C\u0002j\u0003O\ta\u0002]1sC6,G/\u001a:QCRD\u0007%A\tf]\u000e|G-\u001a3T_J$8i\u001c7v[:\f!#\u001a8d_\u0012,GmU8si\u000e{G.^7oA\u00059A/\u00192mK&#\u0017!\u0004;bE2,7i]:DY\u0006\u001c8/A\tqC\u001e,7+\u001b>f\r>\u0014XNR5fY\u0012\f1\u0003]1hK:+XNY3s\r>\u0014XNR5fY\u0012\f!\u0002Z1uCN{WO]2f+\t\t\u0019\u0005E\u00028\u0003\u000bJ1!a\u0012\"\u00055QuN\u0019#bi\u0006\u001cv.\u001e:dK\u0006YA-\u0019;b'>,(oY3!\u0003!\u0001\u0018mZ3MS:\\GcA2\u0002P!9\u0011\u0011\u000b\u000fA\u0002\u0005\u001d\u0011\u0001\u00029bO\u0016\f\u0001cZ8CkR$xN\u001c$pe6\u0004\u0016\r\u001e5\u0002\u000f!,\u0017\rZ3sgV\u0011\u0011\u0011\f\t\u0005\u001f^\u000bY\u0006\u0005\u0003\u0002^\u0005\rTBAA0\u0015\r\t\tGL\u0001\u0004q6d\u0017\u0002BA3\u0003?\u0012AAT8eK\u0006\u0019!o\\<\u0015\t\u0005e\u00131\u000e\u0005\u0007\u0003[z\u0002\u0019\u0001\u001c\u0002\u0017)|'\rV1cY\u0016\u0014vn\u001e")
public class JobPagedTable
implements PagedTable<JobTableRowData> {
    private final String tableHeaderId;
    private final String jobTag;
    private final String basePath;
    private final boolean killEnabled;
    private final String jobIdTitle;
    private final /* synthetic */ Tuple3 x$11;
    private final String sortColumn;
    private final boolean desc;
    private final int pageSize;
    private final String parameterPath;
    private final String encodedSortColumn;
    private final JobDataSource dataSource;

    @Override
    public Seq<Node> table(int page) {
        return PagedTable.table$(this, page);
    }

    @Override
    public Seq<Node> pageNavigation(int page, int pageSize, int totalPages, String navigationId) {
        return PagedTable.pageNavigation$(this, page, pageSize, totalPages, navigationId);
    }

    @Override
    public String pageNavigation$default$4() {
        return PagedTable.pageNavigation$default$4$(this);
    }

    @Override
    public String getParameterOtherTable(HttpServletRequest request, String tableTag) {
        return PagedTable.getParameterOtherTable$(this, request, tableTag);
    }

    @Override
    public Tuple3<String, Object, Object> getTableParameters(HttpServletRequest request, String tableTag, String defaultSortColumn) {
        return PagedTable.getTableParameters$(this, request, tableTag, defaultSortColumn);
    }

    @Override
    public void isSortColumnValid(Seq<Tuple3<String, Object, Option<String>>> headerInfo, String sortColumn) {
        PagedTable.isSortColumnValid$(this, headerInfo, sortColumn);
    }

    @Override
    public Seq<Node> headerRow(Seq<Tuple3<String, Object, Option<String>>> headerInfo, boolean desc, int pageSize, String sortColumn, String parameterPath, String tableTag, String headerId) {
        return PagedTable.headerRow$(this, headerInfo, desc, pageSize, sortColumn, parameterPath, tableTag, headerId);
    }

    private String sortColumn() {
        return this.sortColumn;
    }

    private boolean desc() {
        return this.desc;
    }

    private int pageSize() {
        return this.pageSize;
    }

    private String parameterPath() {
        return this.parameterPath;
    }

    private String encodedSortColumn() {
        return this.encodedSortColumn;
    }

    @Override
    public String tableId() {
        return new StringBuilder(6).append(this.jobTag).append("-table").toString();
    }

    @Override
    public String tableCssClass() {
        return "table table-bordered table-sm table-striped table-head-clickable table-cell-width-limited";
    }

    @Override
    public String pageSizeFormField() {
        return new StringBuilder(9).append(this.jobTag).append(".pageSize").toString();
    }

    @Override
    public String pageNumberFormField() {
        return new StringBuilder(5).append(this.jobTag).append(".page").toString();
    }

    public JobDataSource dataSource() {
        return this.dataSource;
    }

    @Override
    public String pageLink(int page) {
        return new StringBuilder(19).append(this.parameterPath()).append("&").append(this.pageNumberFormField()).append("=").append(page).append("&").append(this.jobTag).append(".sort=").append(this.encodedSortColumn()).append("&").append(this.jobTag).append(".desc=").append(this.desc()).append("&").append(this.pageSizeFormField()).append("=").append(this.pageSize()).append("#").append(this.tableHeaderId).toString();
    }

    @Override
    public String goButtonFormPath() {
        return new StringBuilder(15).append(this.parameterPath()).append("&").append(this.jobTag).append(".sort=").append(this.encodedSortColumn()).append("&").append(this.jobTag).append(".desc=").append(this.desc()).append("#").append(this.tableHeaderId).toString();
    }

    @Override
    public Seq<Node> headers() {
        Seq jobHeadersAndCssClasses = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)this.jobIdTitle, (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Description", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Submitted", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$), new Tuple3((Object)"Duration", (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Some((Object)"Elapsed time since the job was submitted until execution completion of all its stages.")), new Tuple3((Object)"Stages: Succeeded/Total", (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)None$.MODULE$), new Tuple3((Object)"Tasks (for all stages): Succeeded/Total", (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)None$.MODULE$)}));
        this.isSortColumnValid((Seq<Tuple3<String, Object, Option<String>>>)jobHeadersAndCssClasses, this.sortColumn());
        return this.headerRow((Seq<Tuple3<String, Object, Option<String>>>)jobHeadersAndCssClasses, this.desc(), this.pageSize(), this.sortColumn(), this.parameterPath(), this.jobTag, this.tableHeaderId);
    }

    @Override
    public Seq<Node> row(JobTableRowData jobTableRow) {
        Seq seq;
        JobData job = jobTableRow.jobData();
        if (this.killEnabled) {
            String confirm = new StringBuilder(125).append("if (window.confirm('Are you sure you want to kill job ").append(job.jobId()).append(" ?')) ").append("{ this.parentNode.submit(); return true; } else { return false; }").toString();
            String killLinkUri = new StringBuilder(19).append(this.basePath).append("/jobs/job/kill/?id=").append(job.jobId()).toString();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("kill-link"), (MetaData)$md);
            $md = new UnprefixedAttribute("onclick", confirm, (MetaData)$md);
            $md = new UnprefixedAttribute("href", killLinkUri, (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("(kill)"));
            Elem elem = new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            seq = elem;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        Seq killLink = seq;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("id", new StringBuilder(4).append("job-").append(job.jobId()).toString(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)job.jobId()));
        $buf2.$amp$plus((Object)new Text(" "));
        $buf2.$amp$plus(job.jobGroup().map((Function1 & Serializable & scala.Serializable)id -> new StringBuilder(2).append("(").append((String)id).append(")").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)jobTableRow.jobDescription());
        $buf3.$amp$plus((Object)new Text(" "));
        $buf3.$amp$plus((Object)killLink);
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("name-link"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("href", jobTableRow.detailUrl(), (MetaData)$md2);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)jobTableRow.lastStageName());
        $buf3.$amp$plus((Object)new Elem(null, "a", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)jobTableRow.formattedSubmissionTime());
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)jobTableRow.formattedDuration());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("stage-progress-cell"), (MetaData)$md3);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf7.$amp$plus((Object)BoxesRunTime.boxToInteger((int)job.numCompletedStages()));
        $buf7.$amp$plus((Object)new Text("/"));
        $buf7.$amp$plus((Object)BoxesRunTime.boxToInteger((int)(job.stageIds().size() - job.numSkippedStages())));
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf7.$amp$plus((Object)(job.numFailedStages() > 0 ? new StringBuilder(9).append("(").append(job.numFailedStages()).append(" failed)").toString() : BoxedUnit.UNIT));
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf7.$amp$plus((Object)(job.numSkippedStages() > 0 ? new StringBuilder(10).append("(").append(job.numSkippedStages()).append(" skipped)").toString() : BoxedUnit.UNIT));
        $buf7.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("progress-cell"), (MetaData)$md4);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus(UIUtils$.MODULE$.makeProgressBar(job.numActiveTasks(), job.numCompletedIndices(), job.numFailedTasks(), job.numSkippedTasks(), job.killedTasksSummary(), job.numTasks() - job.numSkippedTasks()));
        $buf8.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public JobPagedTable(HttpServletRequest request, AppStatusStore store, Seq<JobData> data, String tableHeaderId, String jobTag, String basePath, String subPath, boolean killEnabled, String jobIdTitle) {
        this.tableHeaderId = tableHeaderId;
        this.jobTag = jobTag;
        this.basePath = basePath;
        this.killEnabled = killEnabled;
        this.jobIdTitle = jobIdTitle;
        PagedTable.$init$(this);
        Tuple3<String, Object, Object> tuple3 = this.getTableParameters(request, jobTag, jobIdTitle);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String sortColumn = (String)tuple3._1();
        boolean desc = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
        int pageSize = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)sortColumn, (Object)BoxesRunTime.boxToBoolean((boolean)desc), (Object)BoxesRunTime.boxToInteger((int)pageSize));
        this.x$11 = tuple32;
        this.sortColumn = (String)this.x$11._1();
        this.desc = BoxesRunTime.unboxToBoolean((Object)this.x$11._2());
        this.pageSize = BoxesRunTime.unboxToInt((Object)this.x$11._3());
        this.parameterPath = new StringBuilder(3).append(basePath).append("/").append(subPath).append("/?").append(this.getParameterOtherTable(request, jobTag)).toString();
        this.encodedSortColumn = URLEncoder.encode(this.sortColumn(), StandardCharsets.UTF_8.name());
        this.dataSource = new JobDataSource(store, data, basePath, this.pageSize(), this.sortColumn(), this.desc());
    }
}

