/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public class UploadBlock
extends BlockTransferMessage {
    public final String appId;
    public final String execId;
    public final String blockId;
    public final byte[] metadata;
    public final byte[] blockData;

    public UploadBlock(String appId, String execId, String blockId, byte[] metadata, byte[] blockData) {
        this.appId = appId;
        this.execId = execId;
        this.blockId = blockId;
        this.metadata = metadata;
        this.blockData = blockData;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.UPLOAD_BLOCK;
    }

    public int hashCode() {
        int objectsHashCode = Objects.hash(this.appId, this.execId, this.blockId);
        return (objectsHashCode * 41 + Arrays.hashCode(this.metadata)) * 41 + Arrays.hashCode(this.blockData);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("appId", (Object)this.appId).append("execId", (Object)this.execId).append("blockId", (Object)this.blockId).append("metadata size", this.metadata.length).append("block size", this.blockData.length).toString();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof UploadBlock) {
            UploadBlock o = (UploadBlock)other;
            return Objects.equals(this.appId, o.appId) && Objects.equals(this.execId, o.execId) && Objects.equals(this.blockId, o.blockId) && Arrays.equals(this.metadata, o.metadata) && Arrays.equals(this.blockData, o.blockData);
        }
        return false;
    }

    public int encodedLength() {
        return Encoders.Strings.encodedLength((String)this.appId) + Encoders.Strings.encodedLength((String)this.execId) + Encoders.Strings.encodedLength((String)this.blockId) + Encoders.ByteArrays.encodedLength((byte[])this.metadata) + Encoders.ByteArrays.encodedLength((byte[])this.blockData);
    }

    public void encode(ByteBuf buf) {
        Encoders.Strings.encode((ByteBuf)buf, (String)this.appId);
        Encoders.Strings.encode((ByteBuf)buf, (String)this.execId);
        Encoders.Strings.encode((ByteBuf)buf, (String)this.blockId);
        Encoders.ByteArrays.encode((ByteBuf)buf, (byte[])this.metadata);
        Encoders.ByteArrays.encode((ByteBuf)buf, (byte[])this.blockData);
    }

    public static UploadBlock decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode((ByteBuf)buf);
        String execId = Encoders.Strings.decode((ByteBuf)buf);
        String blockId = Encoders.Strings.decode((ByteBuf)buf);
        byte[] metadata = Encoders.ByteArrays.decode((ByteBuf)buf);
        byte[] blockData = Encoders.ByteArrays.decode((ByteBuf)buf);
        return new UploadBlock(appId, execId, blockId, metadata, blockData);
    }
}

