/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public class FetchShuffleBlocks
extends BlockTransferMessage {
    public final String appId;
    public final String execId;
    public final int shuffleId;
    public final long[] mapIds;
    public final int[][] reduceIds;
    public final boolean batchFetchEnabled;

    public FetchShuffleBlocks(String appId, String execId, int shuffleId, long[] mapIds, int[][] reduceIds, boolean batchFetchEnabled) {
        this.appId = appId;
        this.execId = execId;
        this.shuffleId = shuffleId;
        this.mapIds = mapIds;
        this.reduceIds = reduceIds;
        assert (mapIds.length == reduceIds.length);
        this.batchFetchEnabled = batchFetchEnabled;
        if (batchFetchEnabled) {
            for (int[] ids : reduceIds) {
                assert (ids.length == 2);
            }
        }
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.FETCH_SHUFFLE_BLOCKS;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("appId", (Object)this.appId).append("execId", (Object)this.execId).append("shuffleId", this.shuffleId).append("mapIds", (Object)Arrays.toString(this.mapIds)).append("reduceIds", (Object)Arrays.deepToString((Object[])this.reduceIds)).append("batchFetchEnabled", this.batchFetchEnabled).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchShuffleBlocks that = (FetchShuffleBlocks)o;
        if (this.shuffleId != that.shuffleId) {
            return false;
        }
        if (this.batchFetchEnabled != that.batchFetchEnabled) {
            return false;
        }
        if (!this.appId.equals(that.appId)) {
            return false;
        }
        if (!this.execId.equals(that.execId)) {
            return false;
        }
        if (!Arrays.equals(this.mapIds, that.mapIds)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.reduceIds, (Object[])that.reduceIds);
    }

    public int hashCode() {
        int result = this.appId.hashCode();
        result = 31 * result + this.execId.hashCode();
        result = 31 * result + this.shuffleId;
        result = 31 * result + Arrays.hashCode(this.mapIds);
        result = 31 * result + Arrays.deepHashCode((Object[])this.reduceIds);
        result = 31 * result + (this.batchFetchEnabled ? 1 : 0);
        return result;
    }

    public int encodedLength() {
        int encodedLengthOfReduceIds = 0;
        for (int[] ids : this.reduceIds) {
            encodedLengthOfReduceIds += Encoders.IntArrays.encodedLength((int[])ids);
        }
        return Encoders.Strings.encodedLength((String)this.appId) + Encoders.Strings.encodedLength((String)this.execId) + 4 + Encoders.LongArrays.encodedLength((long[])this.mapIds) + 4 + encodedLengthOfReduceIds + 1;
    }

    public void encode(ByteBuf buf) {
        Encoders.Strings.encode((ByteBuf)buf, (String)this.appId);
        Encoders.Strings.encode((ByteBuf)buf, (String)this.execId);
        buf.writeInt(this.shuffleId);
        Encoders.LongArrays.encode((ByteBuf)buf, (long[])this.mapIds);
        buf.writeInt(this.reduceIds.length);
        for (int[] ids : this.reduceIds) {
            Encoders.IntArrays.encode((ByteBuf)buf, (int[])ids);
        }
        buf.writeBoolean(this.batchFetchEnabled);
    }

    public static FetchShuffleBlocks decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode((ByteBuf)buf);
        String execId = Encoders.Strings.decode((ByteBuf)buf);
        int shuffleId = buf.readInt();
        long[] mapIds = Encoders.LongArrays.decode((ByteBuf)buf);
        int reduceIdsSize = buf.readInt();
        int[][] reduceIds = new int[reduceIdsSize][];
        for (int i = 0; i < reduceIdsSize; ++i) {
            reduceIds[i] = Encoders.IntArrays.decode((ByteBuf)buf);
        }
        boolean batchFetchEnabled = buf.readBoolean();
        return new FetchShuffleBlocks(appId, execId, shuffleId, mapIds, reduceIds, batchFetchEnabled);
    }
}

