/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import java.net.ConnectException;
import org.apache.spark.annotation.Evolving;
import org.sparkproject.guava.base.Throwables;

@Evolving
public interface ErrorHandler {
    public static final ErrorHandler NOOP_ERROR_HANDLER = t -> true;

    public boolean shouldRetryError(Throwable var1);

    default public boolean shouldLogError(Throwable t) {
        return true;
    }

    public static class BlockPushErrorHandler
    implements ErrorHandler {
        public static final String TOO_LATE_MESSAGE_SUFFIX = "received after merged shuffle is finalized";
        public static final String BLOCK_APPEND_COLLISION_DETECTED_MSG_PREFIX = "Couldn't find an opportunity to write block";
        public static final String IOEXCEPTIONS_EXCEEDED_THRESHOLD_PREFIX = "IOExceptions exceeded the threshold";

        @Override
        public boolean shouldRetryError(Throwable t) {
            if (t.getCause() != null && t.getCause() instanceof ConnectException) {
                return false;
            }
            return !Throwables.getStackTraceAsString((Throwable)t).contains(TOO_LATE_MESSAGE_SUFFIX);
        }

        @Override
        public boolean shouldLogError(Throwable t) {
            String errorStackTrace = Throwables.getStackTraceAsString((Throwable)t);
            return !errorStackTrace.contains(BLOCK_APPEND_COLLISION_DETECTED_MSG_PREFIX) && !errorStackTrace.contains(TOO_LATE_MESSAGE_SUFFIX);
        }
    }
}

