/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.streaming.InternalOutputModes$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.catalog.V2TableWithV1Fallback;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.sources.ForeachBatchSink;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterTable;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterTable$;
import org.apache.spark.sql.execution.streaming.sources.MemoryPlan;
import org.apache.spark.sql.execution.streaming.sources.MemorySink;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.DataStreamWriter$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Evolving
@ScalaSignature(bytes="\u0006\u0001\r%d\u0001B$I\u0005MC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\u0007W\u0002!\tA\u00137\t\u000fA\u0004!\u0019!C\u0005c\"1\u0011\u0010\u0001Q\u0001\nIDQA\u001f\u0001\u0005\u0002mDaA\u001f\u0001\u0005\u0002\u0005\u0005\u0001bBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!!\u000e\u0001\t\u0003\t9\u0004C\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005E\u0003\u0001\"\u0001\u0002^!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005%\u0004bBA)\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003\u0003\u0003A\u0011AAB\u0011\u001d\t\t\t\u0001C\u0001\u0003'Cq!!*\u0001\t\u0003\t9\u000bC\u0004\u0002&\u0002!\t!a-\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9!Q\u0003\u0001\u0005\n\t]\u0001b\u0002B\u0011\u0001\u0011%!1\u0005\u0005\n\u0005\u001f\u0002\u0011\u0013!C\u0005\u0005#BqAa\u0019\u0001\t\u0013\u0011)\u0007C\u0004\u0003z\u0001!\tAa\u001f\t\u000f\t\u001d\u0005\u0001\"\u0001\u0003\n\"9!q\u0011\u0001\u0005\u0002\tu\u0005b\u0002B_\u0001\u0011%!q\u0018\u0005\b\u0005\u001f\u0004A\u0011\u0002Bi\u0011\u001d\u0011Y\u000e\u0001C\u0005\u0005;D\u0011\"a\r\u0001\u0001\u0004%I!a4\t\u0013\t\r\b\u00011A\u0005\n\t\u0015\b\u0002\u0003Bv\u0001\u0001\u0006K!!\u0002\t\u0013\u0005m\b\u00011A\u0005\n\u0005=\u0007\"\u0003Bw\u0001\u0001\u0007I\u0011\u0002Bx\u0011!\u0011\u0019\u0010\u0001Q!\n\u0005\u0015\u0001\u0002\u0003>\u0001\u0001\u0004%IA!>\t\u0013\t]\b\u00011A\u0005\n\te\bb\u0002B\u007f\u0001\u0001\u0006K! \u0005\n\u00037\u0001\u0001\u0019!C\u0005\u0005\u007fD\u0011b!\u0001\u0001\u0001\u0004%Iaa\u0001\t\u0011\r\u001d\u0001\u0001)Q\u0005\u0003CA\u0011b!\u0003\u0001\u0001\u0004%Iaa\u0003\t\u0013\r5\u0001\u00011A\u0005\n\r=\u0001\u0002CB\n\u0001\u0001\u0006KA!\u0010\t\u0013\rU\u0001\u00011A\u0005\n\r]\u0001\"CB\r\u0001\u0001\u0007I\u0011BB\u000e\u0011!\u0019y\u0002\u0001Q!\n\t\u0005\u0005\"CB\u0011\u0001\u0001\u0007I\u0011BB\u0012\u0011%\u0019)\u0003\u0001a\u0001\n\u0013\u00199\u0003\u0003\u0005\u0004,\u0001\u0001\u000b\u0015\u0002BH\u0011%\u0019i\u0003\u0001a\u0001\n\u0013\u0011y\fC\u0005\u00040\u0001\u0001\r\u0011\"\u0003\u00042!A1Q\u0007\u0001!B\u0013\u0011\tmB\u0004\u0004:!C\taa\u000f\u0007\r\u001dC\u0005\u0012AB\u001f\u0011\u0019Yw\u0007\"\u0001\u0004@!I1\u0011I\u001cC\u0002\u0013\u000511\t\u0005\t\u0007\u0013:\u0004\u0015!\u0003\u0004F!I11J\u001cC\u0002\u0013\u000511\t\u0005\t\u0007\u001b:\u0004\u0015!\u0003\u0004F!I1qJ\u001cC\u0002\u0013\u000511\t\u0005\t\u0007#:\u0004\u0015!\u0003\u0004F!I11K\u001cC\u0002\u0013\u000511\t\u0005\t\u0007+:\u0004\u0015!\u0003\u0004F!I1qK\u001cC\u0002\u0013\u000511\t\u0005\t\u00073:\u0004\u0015!\u0003\u0004F!I11L\u001cC\u0002\u0013\u000511\t\u0005\t\u0007;:\u0004\u0015!\u0003\u0004F!I1qL\u001cC\u0002\u0013\u00051\u0011\r\u0005\t\u0007O:\u0004\u0015!\u0003\u0004d\t\u0001B)\u0019;b'R\u0014X-Y7Xe&$XM\u001d\u0006\u0003\u0013*\u000b\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005-c\u0015aA:rY*\u0011QJT\u0001\u0006gB\f'o\u001b\u0006\u0003\u001fB\u000ba!\u00199bG\",'\"A)\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005Q\u00137C\u0001\u0001V!\t1\u0016,D\u0001X\u0015\u0005A\u0016!B:dC2\f\u0017B\u0001.X\u0005\u0019\te.\u001f*fM\u0006\u0011Am\u001d\t\u0004;z\u0003W\"\u0001&\n\u0005}S%a\u0002#bi\u0006\u001cX\r\u001e\t\u0003C\nd\u0001\u0001B\u0003d\u0001\t\u0007AMA\u0001U#\t)\u0007\u000e\u0005\u0002WM&\u0011qm\u0016\u0002\b\u001d>$\b.\u001b8h!\t1\u0016.\u0003\u0002k/\n\u0019\u0011I\\=\u0002\rqJg.\u001b;?)\tiw\u000eE\u0002o\u0001\u0001l\u0011\u0001\u0013\u0005\u00067\n\u0001\r\u0001X\u0001\u0003I\u001a,\u0012A\u001d\t\u0003gZt!!\u0018;\n\u0005UT\u0015a\u00029bG.\fw-Z\u0005\u0003ob\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005UT\u0015a\u00013gA\u0005Qq.\u001e;qkRlu\u000eZ3\u0015\u00055d\b\"\u0002>\u0006\u0001\u0004i\bC\u00018\u007f\u0013\ty\bJ\u0001\u0006PkR\u0004X\u000f^'pI\u0016$2!\\A\u0002\u0011\u0019Qh\u00011\u0001\u0002\u0006A!\u0011qAA\u000b\u001d\u0011\tI!!\u0005\u0011\u0007\u0005-q+\u0004\u0002\u0002\u000e)\u0019\u0011q\u0002*\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019bV\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0011\u0011\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Mq+A\u0004ue&<w-\u001a:\u0015\u00075\fy\u0002C\u0004\u0002\u001c\u001d\u0001\r!!\t\u0011\u00079\f\u0019#C\u0002\u0002&!\u0013q\u0001\u0016:jO\u001e,'/A\u0005rk\u0016\u0014\u0018PT1nKR\u0019Q.a\u000b\t\u000f\u0005\u001d\u0002\u00021\u0001\u0002\u0006\u00051am\u001c:nCR$2!\\A\u0019\u0011\u001d\t\u0019$\u0003a\u0001\u0003\u000b\taa]8ve\u000e,\u0017a\u00039beRLG/[8o\u0005f$2!\\A\u001d\u0011\u001d\tYD\u0003a\u0001\u0003{\t\u0001bY8m\u001d\u0006lWm\u001d\t\u0006-\u0006}\u0012QA\u0005\u0004\u0003\u0003:&A\u0003\u001fsKB,\u0017\r^3e}!\u001a!\"!\u0012\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013X\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\nIEA\u0004wCJ\f'oZ:\u0002\r=\u0004H/[8o)\u0015i\u0017QKA-\u0011\u001d\t9f\u0003a\u0001\u0003\u000b\t1a[3z\u0011\u001d\tYf\u0003a\u0001\u0003\u000b\tQA^1mk\u0016$R!\\A0\u0003CBq!a\u0016\r\u0001\u0004\t)\u0001C\u0004\u0002\\1\u0001\r!a\u0019\u0011\u0007Y\u000b)'C\u0002\u0002h]\u0013qAQ8pY\u0016\fg\u000eF\u0003n\u0003W\ni\u0007C\u0004\u0002X5\u0001\r!!\u0002\t\u000f\u0005mS\u00021\u0001\u0002pA\u0019a+!\u001d\n\u0007\u0005MtK\u0001\u0003M_:<G#B7\u0002x\u0005e\u0004bBA,\u001d\u0001\u0007\u0011Q\u0001\u0005\b\u00037r\u0001\u0019AA>!\r1\u0016QP\u0005\u0004\u0003\u007f:&A\u0002#pk\ndW-A\u0004paRLwN\\:\u0015\u00075\f)\tC\u0004\u0002\u0002>\u0001\r!a\"\u0011\u0011\u0005%\u0015qRA\u0003\u0003\u000bi!!a#\u000b\u0007\u00055u+\u0001\u0006d_2dWm\u0019;j_:LA!!%\u0002\f\n\u0019Q*\u00199\u0015\u00075\f)\nC\u0004\u0002\u0002B\u0001\r!a&\u0011\u0011\u0005e\u00151UA\u0003\u0003\u000bi!!a'\u000b\t\u0005u\u0015qT\u0001\u0005kRLGN\u0003\u0002\u0002\"\u0006!!.\u0019<b\u0013\u0011\t\t*a'\u0002\u000bM$\u0018M\u001d;\u0015\t\u0005%\u0016q\u0016\t\u0004]\u0006-\u0016bAAW\u0011\nq1\u000b\u001e:fC6LgnZ)vKJL\bbBAY#\u0001\u0007\u0011QA\u0001\u0005a\u0006$\b\u000e\u0006\u0002\u0002*\"*!#a.\u0002JB)a+!/\u0002>&\u0019\u00111X,\u0003\rQD'o\\<t!\u0011\ty,!2\u000e\u0005\u0005\u0005'\u0002BAb\u00037\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\t9-!1\u0003!QKW.Z8vi\u0016C8-\u001a9uS>t\u0017g\u0002\u0010\u0002\u0006\u0005-\u00171_\u0019\nG\u00055\u00171[Au\u0003+,B!a4\u0002RV\u0011\u0011Q\u0001\u0003\u0007GJ\u0013\r!a7\n\t\u0005U\u0017q[\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0007\u0005ew+\u0001\u0004uQJ|wo]\t\u0004K\u0006u\u0007\u0003BAp\u0003Gt1AVAq\u0013\t)x+\u0003\u0003\u0002f\u0006\u001d(!\u0003+ie><\u0018M\u00197f\u0015\t)x+M\u0005$\u0003W\fi/a<\u0002Z:\u0019a+!<\n\u0007\u0005ew+M\u0003#-^\u000b\tPA\u0003tG\u0006d\u0017-M\u0002'\u0003{\u000bq\u0001^8UC\ndW\r\u0006\u0003\u0002*\u0006e\bbBA~'\u0001\u0007\u0011QA\u0001\ni\u0006\u0014G.\u001a(b[\u0016DSaEA\\\u0003\u007f\ftAHA\u0003\u0005\u0003\u00119!M\u0005$\u0003\u001b\f\u0019Na\u0001\u0002VFJ1%a;\u0002n\n\u0015\u0011\u0011\\\u0019\u0006EY;\u0016\u0011_\u0019\u0004M\u0005u\u0006fA\n\u0003\fA!!Q\u0002B\t\u001b\t\u0011yAC\u0002\u0002L1KAAa\u0005\u0003\u0010\tAQI^8mm&tw-A\u0007ti\u0006\u0014H/\u00138uKJt\u0017\r\u001c\u000b\u0005\u0003S\u0013I\u0002C\u0004\u00022R\u0001\rAa\u0007\u0011\u000bY\u0013i\"!\u0002\n\u0007\t}qK\u0001\u0004PaRLwN\\\u0001\u000bgR\f'\u000f^)vKJLH\u0003CAU\u0005K\u0011IDa\u0013\t\u000f\t\u001dR\u00031\u0001\u0003*\u0005!1/\u001b8l!\u0011\u0011YC!\u000e\u000e\u0005\t5\"\u0002\u0002B\u0018\u0005c\tqaY1uC2|wMC\u0002\u00034)\u000b\u0011bY8o]\u0016\u001cGo\u001c:\n\t\t]\"Q\u0006\u0002\u0006)\u0006\u0014G.\u001a\u0005\b\u0005w)\u0002\u0019\u0001B\u001f\u0003)qWm^(qi&|gn\u001d\t\u0007\u0005\u007f\u00119%!\u0002\u000e\u0005\t\u0005#\u0002BAO\u0005\u0007R1A!\u0012K\u0003!\u0019\u0017\r^1msN$\u0018\u0002\u0002B%\u0005\u0003\u0012!cQ1tK&s7/\u001a8tSRLg/Z'ba\"I!QJ\u000b\u0011\u0002\u0003\u0007\u00111M\u0001\u0016e\u0016\u001cwN^3s\rJ|Wn\u00115fG.\u0004x.\u001b8u\u0003Q\u0019H/\u0019:u#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u000b\u0016\u0005\u0003G\u0012)f\u000b\u0002\u0003XA!!\u0011\fB0\u001b\t\u0011YF\u0003\u0003\u0003^\u0005%\u0013!C;oG\",7m[3e\u0013\u0011\u0011\tGa\u0017\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0007de\u0016\fG/\u001a,2'&t7\u000e\u0006\u0003\u0003h\tU\u0004\u0003\u0002B5\u0005cj!Aa\u001b\u000b\u0007%\u0013iGC\u0002\u0003p)\u000b\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\tM$1\u000e\u0002\u0005'&t7\u000eC\u0004\u0003x]\u0001\rA!\u0010\u0002\u001f=\u0004H/[8og^KG\u000f\u001b)bi\"\fqAZ8sK\u0006\u001c\u0007\u000eF\u0002n\u0005{BqAa \u0019\u0001\u0004\u0011\t)\u0001\u0004xe&$XM\u001d\t\u0005;\n\r\u0005-C\u0002\u0003\u0006*\u0013QBR8sK\u0006\u001c\u0007n\u0016:ji\u0016\u0014\u0018\u0001\u00044pe\u0016\f7\r\u001b\"bi\u000eDGcA7\u0003\f\"9!QR\rA\u0002\t=\u0015\u0001\u00034v]\u000e$\u0018n\u001c8\u0011\u0011Y\u0013\t\nXA8\u0005+K1Aa%X\u0005%1UO\\2uS>t'\u0007E\u0002W\u0005/K1A!'X\u0005\u0011)f.\u001b;)\u0007e\u0011Y\u0001F\u0002n\u0005?CqA!$\u001b\u0001\u0004\u0011\t\u000bE\u0004\u0003$\n5FL!-\u000e\u0005\t\u0015&\u0002\u0002BG\u0005OSA!!)\u0003**\u0019!1\u0016'\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u00030\n\u0015&!\u0004,pS\u00124UO\\2uS>t'\u0007\u0005\u0003\u00034\neVB\u0001B[\u0015\u0011\u00119,a(\u0002\t1\fgnZ\u0005\u0005\u0003g\u0012)\fK\u0002\u001b\u0005\u0017\t\u0011C\\8s[\u0006d\u0017N_3e!\u0006\u00148i\u001c7t+\t\u0011\t\rE\u0003W\u0005;\u0011\u0019\r\u0005\u0004\u0003F\n-\u0017Q\u0001\b\u0005\u0005\u000f\f\tO\u0004\u0003\u0002\f\t%\u0017\"\u0001-\n\t\t5\u0017q\u001d\u0002\u0004'\u0016\f\u0018!\u00038pe6\fG.\u001b>f)\u0019\t)Aa5\u0003X\"9!Q\u001b\u000fA\u0002\u0005\u0015\u0011AC2pYVlgNT1nK\"9!\u0011\u001c\u000fA\u0002\u0005\u0015\u0011AC2pYVlg\u000eV=qK\u0006!\u0012m]:feRtu\u000e\u001e)beRLG/[8oK\u0012$BA!&\u0003`\"9!\u0011]\u000fA\u0002\u0005\u0015\u0011!C8qKJ\fG/[8o\u0003)\u0019x.\u001e:dK~#S-\u001d\u000b\u0005\u0005+\u00139\u000fC\u0005\u0003j~\t\t\u00111\u0001\u0002\u0006\u0005\u0019\u0001\u0010J\u0019\u0002\u000fM|WO]2fA\u0005iA/\u00192mK:\u000bW.Z0%KF$BA!&\u0003r\"I!\u0011\u001e\u0012\u0002\u0002\u0003\u0007\u0011QA\u0001\u000bi\u0006\u0014G.\u001a(b[\u0016\u0004S#A?\u0002\u001d=,H\u000f];u\u001b>$Wm\u0018\u0013fcR!!Q\u0013B~\u0011!\u0011I/JA\u0001\u0002\u0004i\u0018aC8viB,H/T8eK\u0002*\"!!\t\u0002\u0017Q\u0014\u0018nZ4fe~#S-\u001d\u000b\u0005\u0005+\u001b)\u0001C\u0005\u0003j\"\n\t\u00111\u0001\u0002\"\u0005AAO]5hO\u0016\u0014\b%\u0001\u0007fqR\u0014\u0018m\u00149uS>t7/\u0006\u0002\u0003>\u0005\u0001R\r\u001f;sC>\u0003H/[8og~#S-\u001d\u000b\u0005\u0005+\u001b\t\u0002C\u0005\u0003j.\n\t\u00111\u0001\u0003>\u0005iQ\r\u001f;sC>\u0003H/[8og\u0002\nQBZ8sK\u0006\u001c\u0007n\u0016:ji\u0016\u0014XC\u0001BA\u0003E1wN]3bG\"<&/\u001b;fe~#S-\u001d\u000b\u0005\u0005+\u001bi\u0002C\u0005\u0003j:\n\t\u00111\u0001\u0003\u0002\u0006qam\u001c:fC\u000eDwK]5uKJ\u0004\u0013A\u00054pe\u0016\f7\r\u001b\"bi\u000eDwK]5uKJ,\"Aa$\u0002-\u0019|'/Z1dQ\n\u000bGo\u00195Xe&$XM]0%KF$BA!&\u0004*!I!\u0011^\u0019\u0002\u0002\u0003\u0007!qR\u0001\u0014M>\u0014X-Y2i\u0005\u0006$8\r[,sSR,'\u000fI\u0001\u0014a\u0006\u0014H/\u001b;j_:LgnZ\"pYVlgn]\u0001\u0018a\u0006\u0014H/\u001b;j_:LgnZ\"pYVlgn]0%KF$BA!&\u00044!I!\u0011\u001e\u001b\u0002\u0002\u0003\u0007!\u0011Y\u0001\u0015a\u0006\u0014H/\u001b;j_:LgnZ\"pYVlgn\u001d\u0011)\u0007\u0001\u0011Y!\u0001\tECR\f7\u000b\u001e:fC6<&/\u001b;feB\u0011anN\n\u0003oU#\"aa\u000f\u0002%M{UKU\"F?:\u000bU*R0N\u000b6{%+W\u000b\u0003\u0007\u000b\u0002BAa-\u0004H%!\u0011q\u0003B[\u0003M\u0019v*\u0016*D\u000b~s\u0015)T#`\u001b\u0016kuJU-!\u0003M\u0019v*\u0016*D\u000b~s\u0015)T#`\r>\u0013V)Q\"I\u0003Q\u0019v*\u0016*D\u000b~s\u0015)T#`\r>\u0013V)Q\"IA\u0005I2kT+S\u0007\u0016{f*Q'F?\u001a{%+R!D\u0011~\u0013\u0015\tV\"I\u0003i\u0019v*\u0016*D\u000b~s\u0015)T#`\r>\u0013V)Q\"I?\n\u000bEk\u0011%!\u0003M\u0019v*\u0016*D\u000b~s\u0015)T#`\u0007>s5k\u0014'F\u0003Q\u0019v*\u0016*D\u000b~s\u0015)T#`\u0007>s5k\u0014'FA\u0005\t2kT+S\u0007\u0016{f*Q'F?R\u000b%\tT#\u0002%M{UKU\"F?:\u000bU*R0U\u0003\ncU\tI\u0001\u0011'>+&kQ#`\u001d\u0006kUi\u0018(P\u001fB\u000b\u0011cU(V%\u000e+uLT!N\u000b~suj\u0014)!\u0003q\u0019v*\u0016*D\u000bN{\u0016\t\u0014'P/~{e*R0U\u00136+u,U+F%f+\"aa\u0019\u0011\r\u0005%5QMB#\u0013\u0011\u0011i-a#\u0002;M{UKU\"F'~\u000bE\nT(X?>sUi\u0018+J\u001b\u0016{\u0016+V#S3\u0002\u0002")
public final class DataStreamWriter<T> {
    private final Dataset<T> ds;
    private final Dataset<Row> df;
    private String source;
    private String tableName;
    private OutputMode outputMode;
    private Trigger trigger;
    private CaseInsensitiveMap<String> extraOptions;
    private ForeachWriter<T> foreachWriter;
    private Function2<Dataset<T>, Object, BoxedUnit> foreachBatchWriter;
    private Option<Seq<String>> partitioningColumns;

    public static Seq<String> SOURCES_ALLOW_ONE_TIME_QUERY() {
        return DataStreamWriter$.MODULE$.SOURCES_ALLOW_ONE_TIME_QUERY();
    }

    public static String SOURCE_NAME_NOOP() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_NOOP();
    }

    public static String SOURCE_NAME_TABLE() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_TABLE();
    }

    public static String SOURCE_NAME_CONSOLE() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_CONSOLE();
    }

    public static String SOURCE_NAME_FOREACH_BATCH() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH();
    }

    public static String SOURCE_NAME_FOREACH() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH();
    }

    public static String SOURCE_NAME_MEMORY() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY();
    }

    public DataStreamWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataStreamWriter<T> outputMode(OutputMode outputMode) {
        this.outputMode_$eq(outputMode);
        return this;
    }

    public DataStreamWriter<T> outputMode(String outputMode) {
        this.outputMode_$eq(InternalOutputModes$.MODULE$.apply(outputMode));
        return this;
    }

    public DataStreamWriter<T> trigger(Trigger trigger) {
        this.trigger_$eq(trigger);
        return this;
    }

    public DataStreamWriter<T> queryName(String queryName) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"queryName"), (Object)queryName)));
        return this;
    }

    public DataStreamWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataStreamWriter<T> option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataStreamWriter<T> option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataStreamWriter<T> option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataStreamWriter<T> option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataStreamWriter<T> options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataStreamWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public StreamingQuery start(String path) {
        if (!this.df().sparkSession().sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw new AnalysisException(new StringBuilder(183).append("There is a 'path' option set and start() is called with a path parameter. Either remove the path option, or call start() without the parameter. ").append("To ignore this check, set '").append(SQLConf$.MODULE$.LEGACY_PATH_OPTION_BEHAVIOR().key()).append("' to 'true'.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.startInternal((Option<String>)new Some((Object)path));
    }

    public StreamingQuery start() throws TimeoutException {
        return this.startInternal((Option<String>)None$.MODULE$);
    }

    @Evolving
    public StreamingQuery toTable(String tableName) throws TimeoutException {
        StreamingQuery streamingQuery;
        SupportsWrite supportsWrite;
        Table tableInstance;
        Object object;
        Seq originalMultipartIdentifier;
        this.tableName_$eq(tableName);
        Seq seq = originalMultipartIdentifier = this.df().sparkSession().sessionState().sqlParser().parseMultipartIdentifier(tableName);
        Option option = this.df().sparkSession().sessionState().analyzer().CatalogAndIdentifier().unapply(seq);
        if (option.isEmpty()) {
            throw new MatchError((Object)seq);
        }
        CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option.get())._1();
        Identifier identifier = (Identifier)((Tuple2)option.get())._2();
        Tuple2 tuple2 = new Tuple2((Object)catalog, (Object)identifier);
        Tuple2 tuple22 = tuple2;
        CatalogPlugin catalog2 = (CatalogPlugin)tuple22._1();
        Identifier identifier2 = (Identifier)tuple22._2();
        if (this.df().sparkSession().sessionState().catalog().isTempView(originalMultipartIdentifier)) {
            throw new AnalysisException(new StringBuilder(47).append("Temporary view ").append(tableName).append(" doesn't support streaming write").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (!CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog().tableExists(identifier2)) {
            CreateTableStatement cmd = new CreateTableStatement(originalMultipartIdentifier, this.df().schema().asNullable(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])CatalogV2Implicits$.MODULE$.PartitionTypeHelper((Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).asTransforms())).toSeq(), (Option)None$.MODULE$, Predef$.MODULE$.Map().empty(), (Option)new Some((Object)this.source()), Predef$.MODULE$.Map().empty(), this.extraOptions().get("path"), (Option)None$.MODULE$, (Option)None$.MODULE$, false, false);
            object = Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)cmd);
        } else {
            object = BoxedUnit.UNIT;
        }
        Table table = tableInstance = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog().loadTable(identifier2);
        if (table instanceof SupportsWrite && DataSourceV2Implicits$.MODULE$.TableHelper((Table)(supportsWrite = (SupportsWrite)table)).supports(TableCapability.STREAMING_WRITE)) {
            streamingQuery = this.startQuery((Table)supportsWrite, this.extraOptions(), this.startQuery$default$3());
        } else if (table instanceof V2TableWithV1Fallback) {
            V2TableWithV1Fallback v2TableWithV1Fallback = (V2TableWithV1Fallback)table;
            streamingQuery = this.writeToV1Table$1(v2TableWithV1Fallback.v1Table(), tableName);
        } else if (table instanceof V1Table) {
            V1Table v1Table = (V1Table)table;
            streamingQuery = this.writeToV1Table$1(v1Table.v1Table(), tableName);
        } else {
            throw new AnalysisException(new StringBuilder(41).append("Table ").append(tableName).append(" doesn't support streaming ").append("write - ").append(table).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return streamingQuery;
    }

    private StreamingQuery startInternal(Option<String> path) {
        StreamingQuery streamingQuery;
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not write files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        String string3 = this.source();
        String string4 = DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY());
            if (this.extraOptions().get("queryName").isEmpty()) {
                throw new AnalysisException("queryName must be specified for memory sink", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            MemorySink sink = new MemorySink();
            Dataset<Row> resultDf = Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)new MemoryPlan(sink, (Seq<Attribute>)this.df().schema().toAttributes()));
            OutputMode outputMode = this.outputMode();
            OutputMode outputMode2 = OutputMode.Complete();
            boolean recoverFromCheckpoint = !(outputMode != null ? !outputMode.equals(outputMode2) : outputMode2 != null);
            StreamingQuery query = this.startQuery(sink, this.extraOptions(), recoverFromCheckpoint);
            resultDf.createOrReplaceTempView(query.name());
            streamingQuery = query;
        } else {
            String string5 = this.source();
            String string6 = DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH();
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH());
                ForeachWriterTable<?> sink = ForeachWriterTable$.MODULE$.apply(this.foreachWriter(), this.ds.exprEnc());
                streamingQuery = this.startQuery(sink, this.extraOptions(), this.startQuery$default$3());
            } else {
                String string7 = this.source();
                String string8 = DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH();
                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                    this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH());
                    if (this.trigger() instanceof ContinuousTrigger) {
                        throw new AnalysisException(new StringBuilder(43).append("'").append(this.source()).append("' is not supported with continuous trigger").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    ForeachBatchSink<T> sink = new ForeachBatchSink<T>(this.foreachBatchWriter(), this.ds.exprEnc());
                    streamingQuery = this.startQuery(sink, this.extraOptions(), this.startQuery$default$3());
                } else {
                    Sink sink;
                    CaseInsensitiveMap optionsWithPath;
                    Class<?> cls = DataSource$.MODULE$.lookupDataSource(this.source(), this.df().sparkSession().sessionState().conf());
                    Seq disabledSources = Utils$.MODULE$.stringToSeq(this.df().sparkSession().sqlContext().conf().disabledV2StreamingWriters());
                    boolean useV1Source = disabledSources.contains((Object)cls.getCanonicalName()) || FileDataSourceV2.class.isAssignableFrom(cls);
                    CaseInsensitiveMap caseInsensitiveMap = optionsWithPath = path.isEmpty() ? this.extraOptions() : this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), path.get()));
                    if (TableProvider.class.isAssignableFrom(cls) && !useV1Source) {
                        SupportsWrite supportsWrite;
                        Table table;
                        TableProvider provider = (TableProvider)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                        scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(provider, this.df().sparkSession().sessionState().conf());
                        scala.collection.immutable.Map finalOptions = sessionOptions.filterKeys((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataStreamWriter.$anonfun$startInternal$1(optionsWithPath, x$2))).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)optionsWithPath.originalMap());
                        CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)finalOptions).asJava());
                        None$ outputSchema = provider.supportsExternalMetadata() ? new Some((Object)this.df().schema()) : None$.MODULE$;
                        Table table2 = table = DataSourceV2Utils$.MODULE$.getTableFromProvider(provider, dsOptions, (Option<StructType>)outputSchema);
                        Sink sink2 = table2 instanceof SupportsWrite && DataSourceV2Implicits$.MODULE$.TableHelper((Table)(supportsWrite = (SupportsWrite)table2)).supports(TableCapability.STREAMING_WRITE) ? supportsWrite : this.createV1Sink((CaseInsensitiveMap<String>)optionsWithPath);
                        sink = sink2;
                    } else {
                        sink = this.createV1Sink((CaseInsensitiveMap<String>)optionsWithPath);
                    }
                    Sink sink3 = sink;
                    streamingQuery = this.startQuery(sink3, (CaseInsensitiveMap<String>)optionsWithPath, this.startQuery$default$3());
                }
            }
        }
        return streamingQuery;
    }

    private StreamingQuery startQuery(Table sink, CaseInsensitiveMap<String> newOptions, boolean recoverFromCheckpoint) {
        boolean useTempCheckpointLocation = DataStreamWriter$.MODULE$.SOURCES_ALLOW_ONE_TIME_QUERY().contains((Object)this.source());
        return this.df().sparkSession().sessionState().streamingQueryManager().startQuery((Option<String>)newOptions.get("queryName"), (Option<String>)newOptions.get("checkpointLocation"), this.df(), (scala.collection.immutable.Map<String, String>)newOptions.originalMap(), sink, this.outputMode(), useTempCheckpointLocation, recoverFromCheckpoint, this.trigger(), this.df().sparkSession().sessionState().streamingQueryManager().startQuery$default$10());
    }

    private boolean startQuery$default$3() {
        return true;
    }

    private Sink createV1Sink(CaseInsensitiveMap<String> optionsWithPath) {
        SparkSession x$1 = this.df().sparkSession();
        String x$2 = this.source();
        scala.collection.immutable.Map x$3 = optionsWithPath.originalMap();
        Seq x$4 = (Seq)this.normalizedParCols().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource ds = new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$4, x$7, (scala.collection.immutable.Map<String, String>)x$3, x$8);
        return ds.createSink(this.outputMode());
    }

    public DataStreamWriter<T> foreach(ForeachWriter<T> writer) {
        this.source_$eq(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH());
        if (writer == null) {
            throw new IllegalArgumentException("foreach writer cannot be null");
        }
        this.foreachWriter_$eq((ForeachWriter)this.ds.sparkSession().sparkContext().clean(writer, this.ds.sparkSession().sparkContext().clean$default$2()));
        return this;
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(Function2<Dataset<T>, Object, BoxedUnit> function) {
        this.source_$eq(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH());
        if (function == null) {
            throw new IllegalArgumentException("foreachBatch function cannot be null");
        }
        this.foreachBatchWriter_$eq(function);
        return this;
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(VoidFunction2<Dataset<T>, Long> function) {
        return this.foreachBatch((Function2 & Serializable & scala.Serializable)(batchDs, batchId) -> {
            function.call((Object)batchDs, (Object)Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)batchId)));
            return BoxedUnit.UNIT;
        });
    }

    private Option<Seq<String>> normalizedParCols() {
        return this.partitioningColumns().map((Function1 & Serializable & scala.Serializable)cols -> (Seq)cols.map((Function1 & Serializable & scala.Serializable)x$3 -> this.normalize((String)x$3, "Partition"), Seq$.MODULE$.canBuildFrom()));
    }

    private String normalize(String columnName, String columnType) {
        Seq validColumnNames = (Seq)this.df().logicalPlan().output().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Seq$.MODULE$.canBuildFrom());
        return (String)validColumnNames.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DataStreamWriter.$anonfun$normalize$2(this, columnName, x$5))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AnalysisException(new StringBuilder(41).append(columnType).append(" column ").append(columnName).append(" not found in ").append("existing columns (").append(validColumnNames.mkString(", ")).append(")").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        });
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException(new StringBuilder(32).append("'").append(operation).append("' does not support partitioning").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private String tableName() {
        return this.tableName;
    }

    private void tableName_$eq(String x$1) {
        this.tableName = x$1;
    }

    private OutputMode outputMode() {
        return this.outputMode;
    }

    private void outputMode_$eq(OutputMode x$1) {
        this.outputMode = x$1;
    }

    private Trigger trigger() {
        return this.trigger;
    }

    private void trigger_$eq(Trigger x$1) {
        this.trigger = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    private ForeachWriter<T> foreachWriter() {
        return this.foreachWriter;
    }

    private void foreachWriter_$eq(ForeachWriter<T> x$1) {
        this.foreachWriter = x$1;
    }

    private Function2<Dataset<T>, Object, BoxedUnit> foreachBatchWriter() {
        return this.foreachBatchWriter;
    }

    private void foreachBatchWriter_$eq(Function2<Dataset<T>, Object, BoxedUnit> x$1) {
        this.foreachBatchWriter = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private final StreamingQuery writeToV1Table$1(CatalogTable table, String tableName$1) {
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException(new StringBuilder(39).append("Streaming into views ").append(tableName$1).append(" is not supported.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Predef$.MODULE$.require(table.provider().isDefined());
        String string = this.source();
        Object object = table.provider().get();
        if (string == null ? object != null : !string.equals(object)) {
            throw new AnalysisException(new StringBuilder(73).append("The input source(").append(this.source()).append(") is different from the table ").append(tableName$1).append("'s data source provider(").append(table.provider().get()).append(").").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.format((String)table.provider().get()).option("path", new Path(table.location()).toString()).start();
    }

    public static final /* synthetic */ boolean $anonfun$startInternal$1(CaseInsensitiveMap optionsWithPath$1, String x$2) {
        return !optionsWithPath$1.contains(x$2);
    }

    public static final /* synthetic */ boolean $anonfun$normalize$2(DataStreamWriter $this, String columnName$1, String x$5) {
        return BoxesRunTime.unboxToBoolean((Object)$this.df().sparkSession().sessionState().analyzer().resolver().apply((Object)x$5, (Object)columnName$1));
    }

    public DataStreamWriter(Dataset<T> ds) {
        this.ds = ds;
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.tableName = null;
        this.outputMode = OutputMode.Append();
        this.trigger = Trigger.ProcessingTime(0L);
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        this.foreachWriter = null;
        this.foreachBatchWriter = null;
        this.partitioningColumns = None$.MODULE$;
    }
}

