/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.CommitDeniedException;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.OutputCommitCoordinator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.execution.datasources.v2.DataWritingSparkTaskResult;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.Iterator;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

public final class DataWritingSparkTask$
implements Logging {
    public static DataWritingSparkTask$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DataWritingSparkTask$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DataWritingSparkTaskResult run(DataWriterFactory writerFactory, TaskContext context, Iterator<InternalRow> iter, boolean useCommitCoordinator) {
        int stageId = context.stageId();
        int stageAttempt = context.stageAttemptNumber();
        int partId = context.partitionId();
        long taskId = context.taskAttemptId();
        int attemptId = context.attemptNumber();
        DataWriter dataWriter = writerFactory.createWriter(partId, taskId);
        LongRef count = LongRef.create((long)0L);
        return (DataWritingSparkTaskResult)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0 & java.io.Serializable & Serializable)() -> {
            WriterCommitMessage writerCommitMessage;
            while (iter.hasNext()) {
                ++count$1.elem;
                dataWriter.write(iter.next());
            }
            if (useCommitCoordinator) {
                OutputCommitCoordinator coordinator = SparkEnv$.MODULE$.get().outputCommitCoordinator();
                boolean commitAuthorized = coordinator.canCommit(stageId, stageAttempt, partId, attemptId);
                if (!commitAuthorized) {
                    String message = new StringBuilder(55).append("Commit denied for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString();
                    MODULE$.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> message);
                    throw new CommitDeniedException(message, stageId, partId, attemptId);
                }
                MODULE$.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(59).append("Commit authorized for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString());
                writerCommitMessage = dataWriter.commit();
            } else {
                MODULE$.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(36).append("Writer for partition ").append(context.partitionId()).append(" is committing.").toString());
                writerCommitMessage = dataWriter.commit();
            }
            WriterCommitMessage msg = writerCommitMessage;
            MODULE$.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(47).append("Committed partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString());
            return new DataWritingSparkTaskResult(count$1.elem, msg);
        }, (Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            MODULE$.logError((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(57).append("Aborting commit for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString());
            dataWriter.abort();
            MODULE$.logError((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(56).append("Aborted commit for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString());
        }, (Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> dataWriter.close());
    }

    private DataWritingSparkTask$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

