/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.BooleanBitSet$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t\rqAB\u0015+\u0011\u0003c\u0003H\u0002\u0004;U!\u0005Ef\u000f\u0005\u0006\u0017\u0006!\t!\u0014\u0005\b\u001d\u0006\u0011\r\u0011\"\u0011P\u0011\u0019\u0019\u0016\u0001)A\u0005!\"9A+\u0001b\u0001\n\u0003y\u0005BB+\u0002A\u0003%\u0001\u000bC\u0003W\u0003\u0011\u0005s\u000bC\u0003{\u0003\u0011\u00053\u0010C\u0004\u0002\n\u0005!\t%a\u0003\u0007\u000b}\f\u0001!a\u000b\t\r-SA\u0011AA\u001b\u0011!\tYD\u0003a\u0001\n\u0013y\u0005\"CA\u001f\u0015\u0001\u0007I\u0011BA \u0011\u001d\tYE\u0003Q!\nACq!!\u0014\u000b\t\u0003\ny\u0005C\u0004\u0002f)!\t%a\u001a\t\r\u0005E$\u0002\"\u0011P\u0011\u0019\t\u0019H\u0003C!\u001f\u001a)1,\u0001\u0001\u0002v!A1n\u0005B\u0001B\u0003%A\u000e\u0003\u0004L'\u0011\u0005\u0011\u0011\u0010\u0005\t\u0003\u007f\u001a\"\u0019!C\u0005\u001f\"9\u0011\u0011Q\n!\u0002\u0013\u0001\u0006\"CAB'\u0001\u0007I\u0011BAC\u0011%\tii\u0005a\u0001\n\u0013\ty\t\u0003\u0005\u0002\u0014N\u0001\u000b\u0015BAD\u0011!\t)j\u0005a\u0001\n\u0013y\u0005\"CAL'\u0001\u0007I\u0011BAM\u0011\u001d\tij\u0005Q!\nACq!a(\u0014\t\u0003\n\t\u000bC\u0004\u0002(N!\t%!+\t\u000f\u0005-6\u0003\"\u0011\u0002.\"I\u00111Y\u0001\u0002\u0002\u0013\u0005\u0013Q\u0019\u0005\t\u0003'\f\u0011\u0011!C\u0001\u001f\"I\u0011Q[\u0001\u0002\u0002\u0013\u0005\u0011q\u001b\u0005\n\u00037\f\u0011\u0011!C!\u0003;D\u0011\"a;\u0002\u0003\u0003%\t!!<\t\u0013\u0005E\u0018!!A\u0005B\u0005M\b\"CA{\u0003\u0005\u0005I\u0011IA|\u0011%\tI0AA\u0001\n\u0013\tY0A\u0007C_>dW-\u00198CSR\u001cV\r\u001e\u0006\u0003W1\n1bY8naJ,7o]5p]*\u0011QFL\u0001\tG>dW/\u001c8be*\u0011q\u0006M\u0001\nKb,7-\u001e;j_:T!!\r\u001a\u0002\u0007M\fHN\u0003\u00024i\u0005)1\u000f]1sW*\u0011QGN\u0001\u0007CB\f7\r[3\u000b\u0003]\n1a\u001c:h!\tI\u0014!D\u0001+\u00055\u0011un\u001c7fC:\u0014\u0015\u000e^*fiN)\u0011\u0001\u0010\"F\u0011B\u0011Q\bQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t1\u0011I\\=SK\u001a\u0004\"!O\"\n\u0005\u0011S#!E\"p[B\u0014Xm]:j_:\u001c6\r[3nKB\u0011QHR\u0005\u0003\u000fz\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002>\u0013&\u0011!J\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0001(\u0001\u0004usB,\u0017\nZ\u000b\u0002!B\u0011Q(U\u0005\u0003%z\u00121!\u00138u\u0003\u001d!\u0018\u0010]3JI\u0002\nQBQ%U'~\u0003VIU0M\u001f:;\u0015A\u0004\"J)N{\u0006+\u0012*`\u0019>su\tI\u0001\bI\u0016\u001cw\u000eZ3s+\tAf\fF\u0002ZUR\u00042!\u000f.]\u0013\tY&FA\u0004EK\u000e|G-\u001a:\u0011\u0005usF\u0002\u0001\u0003\u0006?\u001e\u0011\r\u0001\u0019\u0002\u0002)F\u0011\u0011\r\u001a\t\u0003{\tL!a\u0019 \u0003\u000f9{G\u000f[5oOB\u0011Q\r[\u0007\u0002M*\u0011q\rM\u0001\u0006if\u0004Xm]\u0005\u0003S\u001a\u0014!\"\u0011;p[&\u001cG+\u001f9f\u0011\u0015Yw\u00011\u0001m\u0003\u0019\u0011WO\u001a4feB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\u0004]&|'\"A9\u0002\t)\fg/Y\u0005\u0003g:\u0014!BQ=uK\n+hMZ3s\u0011\u0015)x\u00011\u0001w\u0003)\u0019w\u000e\\;n]RK\b/\u001a\t\u0004obdV\"\u0001\u0017\n\u0005ed#\u0001\u0005(bi&4XmQ8mk6tG+\u001f9f\u0003\u001d)gnY8eKJ,2\u0001`A\u0002)\ri\u0018Q\u0001\t\u0005sy\f\t!\u0003\u0002\u0000U\t9QI\\2pI\u0016\u0014\bcA/\u0002\u0004\u0011)q\f\u0003b\u0001A\"1Q\u000f\u0003a\u0001\u0003\u000f\u0001Ba\u001e=\u0002\u0002\u0005A1/\u001e9q_J$8\u000f\u0006\u0003\u0002\u000e\u0005M\u0001cA\u001f\u0002\u0010%\u0019\u0011\u0011\u0003 \u0003\u000f\t{w\u000e\\3b]\"1Q/\u0003a\u0001\u0003+\u0001D!a\u0006\u0002 A)q/!\u0007\u0002\u001e%\u0019\u00111\u0004\u0017\u0003\u0015\r{G.^7o)f\u0004X\rE\u0002^\u0003?!A\"!\t\u0002\u0014\u0005\u0005\t\u0011!B\u0001\u0003G\u00111a\u0018\u00135#\r\t\u0017Q\u0005\t\u0004{\u0005\u001d\u0012bAA\u0015}\t\u0019\u0011I\\=\u0014\t)a\u0014Q\u0006\t\u0005sy\fyCD\u0002f\u0003cI1!a\rg\u0003-\u0011un\u001c7fC:$\u0016\u0010]3\u0015\u0005\u0005]\u0002cAA\u001d\u00155\t\u0011!A\t`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016\fQcX;oG>l\u0007O]3tg\u0016$7+\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u0002B\u0005\u001d\u0003cA\u001f\u0002D%\u0019\u0011Q\t \u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0013j\u0011\u0011!a\u0001!\u0006\u0019\u0001\u0010J\u0019\u0002%}+hnY8naJ,7o]3e'&TX\rI\u0001\u001bO\u0006$\b.\u001a:D_6\u0004(/Z:tS\nLG.\u001b;z'R\fGo\u001d\u000b\u0007\u0003\u0003\n\t&!\u0019\t\u000f\u0005Ms\u00021\u0001\u0002V\u0005\u0019!o\\<\u0011\t\u0005]\u0013QL\u0007\u0003\u00033R1!a\u00171\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA0\u00033\u00121\"\u00138uKJt\u0017\r\u001c*po\"1\u00111M\bA\u0002A\u000bqa\u001c:eS:\fG.\u0001\u0005d_6\u0004(/Z:t)\u0015a\u0017\u0011NA7\u0011\u0019\tY\u0007\u0005a\u0001Y\u0006!aM]8n\u0011\u0019\ty\u0007\u0005a\u0001Y\u0006\u0011Ao\\\u0001\u0011k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016\fabY8naJ,7o]3e'&TXm\u0005\u0003\u0014y\u0005]\u0004\u0003B\u001d[\u0003_!B!a\u001f\u0002~A\u0019\u0011\u0011H\n\t\u000b-,\u0002\u0019\u00017\u0002\u000b\r|WO\u001c;\u0002\r\r|WO\u001c;!\u0003-\u0019WO\u001d:f]R<vN\u001d3\u0016\u0005\u0005\u001d\u0005cA\u001f\u0002\n&\u0019\u00111\u0012 \u0003\t1{gnZ\u0001\u0010GV\u0014(/\u001a8u/>\u0014Hm\u0018\u0013fcR!\u0011\u0011IAI\u0011%\tI%GA\u0001\u0002\u0004\t9)\u0001\u0007dkJ\u0014XM\u001c;X_J$\u0007%A\u0004wSNLG/\u001a3\u0002\u0017YL7/\u001b;fI~#S-\u001d\u000b\u0005\u0003\u0003\nY\n\u0003\u0005\u0002Jq\t\t\u00111\u0001Q\u0003!1\u0018n]5uK\u0012\u0004\u0013\u0001\u00028fqR$b!!\u0011\u0002$\u0006\u0015\u0006bBA*=\u0001\u0007\u0011Q\u000b\u0005\u0007\u0003Gr\u0002\u0019\u0001)\u0002\u000f!\f7OT3yiV\u0011\u0011QB\u0001\u000bI\u0016\u001cw.\u001c9sKN\u001cHCBA!\u0003_\u000by\fC\u0004\u00022\u0002\u0002\r!a-\u0002\u0019\r|G.^7o-\u0016\u001cGo\u001c:\u0011\t\u0005U\u00161X\u0007\u0003\u0003oS1!!//\u0003)1Xm\u0019;pe&TX\rZ\u0005\u0005\u0003{\u000b9L\u0001\u000bXe&$\u0018M\u00197f\u0007>dW/\u001c8WK\u000e$xN\u001d\u0005\u0007\u0003\u0003\u0004\u0003\u0019\u0001)\u0002\u0011\r\f\u0007/Y2jif\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAd!\u0011\tI-a4\u000e\u0005\u0005-'bAAga\u0006!A.\u00198h\u0013\u0011\t\t.a3\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\n\u0002Z\"A\u0011\u0011J\u0012\u0002\u0002\u0003\u0007\u0001+A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u000e\u0005\u0004\u0002b\u0006\u001d\u0018QE\u0007\u0003\u0003GT1!!:?\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003S\f\u0019O\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0007\u0003_D\u0011\"!\u0013&\u0003\u0003\u0005\r!!\n\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001U\u0001\ti>\u001cFO]5oOR\u0011\u0011qY\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002~B!\u0011\u0011ZA\u0000\u0013\u0011\u0011\t!a3\u0003\r=\u0013'.Z2u\u0001")
public final class BooleanBitSet {
    public static String toString() {
        return BooleanBitSet$.MODULE$.toString();
    }

    public static int hashCode() {
        return BooleanBitSet$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return BooleanBitSet$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return BooleanBitSet$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return BooleanBitSet$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return BooleanBitSet$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return BooleanBitSet$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return BooleanBitSet$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.execution.columnar.compression.Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return BooleanBitSet$.MODULE$.encoder(nativeColumnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.execution.columnar.compression.Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return BooleanBitSet$.MODULE$.decoder(byteBuffer, nativeColumnType);
    }

    public static int BITS_PER_LONG() {
        return BooleanBitSet$.MODULE$.BITS_PER_LONG();
    }

    public static int typeId() {
        return BooleanBitSet$.MODULE$.typeId();
    }

    public static class Decoder
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<BooleanType$> {
        private final ByteBuffer buffer;
        private final int count;
        private long currentWord;
        private int visited;

        private int count() {
            return this.count;
        }

        private long currentWord() {
            return this.currentWord;
        }

        private void currentWord_$eq(long x$1) {
            this.currentWord = x$1;
        }

        private int visited() {
            return this.visited;
        }

        private void visited_$eq(int x$1) {
            this.visited = x$1;
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            int bit = this.visited() % BooleanBitSet$.MODULE$.BITS_PER_LONG();
            this.visited_$eq(this.visited() + 1);
            if (bit == 0) {
                this.currentWord_$eq(ByteBufferHelper$.MODULE$.getLong(this.buffer));
            }
            row.setBoolean(ordinal, (this.currentWord() >> bit & 1L) != 0L);
        }

        @Override
        public boolean hasNext() {
            return this.visited() < this.count();
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            long currentWordLocal = 0L;
            int visitedLocal = 0;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            for (int pos = 0; pos < capacity; ++pos) {
                if (pos != nextNullIndex) {
                    int bit = visitedLocal % BooleanBitSet$.MODULE$.BITS_PER_LONG();
                    ++visitedLocal;
                    if (bit == 0) {
                        currentWordLocal = ByteBufferHelper$.MODULE$.getLong(this.buffer);
                    }
                    columnVector.putBoolean(pos, (currentWordLocal >> bit & 1L) != 0L);
                    continue;
                }
                if (++seenNulls < nullCount) {
                    nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                }
                columnVector.putNull(pos);
            }
        }

        public Decoder(ByteBuffer buffer) {
            this.buffer = buffer;
            this.count = ByteBufferHelper$.MODULE$.getInt(buffer);
            this.currentWord = 0L;
            this.visited = 0;
        }
    }

    public static class Encoder
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<BooleanType$> {
        private int _uncompressedSize;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        private int _uncompressedSize() {
            return this._uncompressedSize;
        }

        private void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            this._uncompressedSize_$eq(this._uncompressedSize() + BOOLEAN$.MODULE$.defaultSize());
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            Object object;
            to.putInt(BooleanBitSet$.MODULE$.typeId()).putInt(from.remaining());
            while (from.remaining() >= BooleanBitSet$.MODULE$.BITS_PER_LONG()) {
                long word = 0L;
                for (int i = 0; i < BooleanBitSet$.MODULE$.BITS_PER_LONG(); ++i) {
                    if (!BOOLEAN$.MODULE$.extract(from)) continue;
                    word |= 1L << i;
                }
                to.putLong(word);
            }
            if (from.hasRemaining()) {
                long word = 0L;
                int i = 0;
                while (from.hasRemaining()) {
                    if (BOOLEAN$.MODULE$.extract(from)) {
                        word |= 1L << i;
                    }
                    ++i;
                }
                object = to.putLong(word);
            } else {
                object = BoxedUnit.UNIT;
            }
            to.rewind();
            return to;
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        @Override
        public int compressedSize() {
            int extra = this._uncompressedSize() % BooleanBitSet$.MODULE$.BITS_PER_LONG() == 0 ? 0 : 1;
            return (this._uncompressedSize() / BooleanBitSet$.MODULE$.BITS_PER_LONG() + extra) * 8 + 4;
        }

        public Encoder() {
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._uncompressedSize = 0;
        }
    }
}

