#include "gimme_config_h.h"

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#include "print_help.h"

void printHelp(void)
{
	(void)puts("Usage summary (see README file for full details):\n\n"
		"-V\n"
		"--version          displays version information and then exits\n\n"
       
		"-h\n"
		"--help             displays this usage summary and exits\n\n"
        
		"-R\n"
		"--reset            resets the drive internally.  normally\n"
		"                   requires root privileges\n\n"
       
		"-d /dev/path\n"
		"--drive /dev/path/ overrides the default cdrom drive path of\n"
		"                   /dev/cdrom\n\n"
		
		"-o /path/\n"
		"--outputdir /path/ specifies a directory for file output other\n"
		"                   than the default of the current working\n"
		"                   directory\n\n"
       
		"-t X\n"
		"--retries X        overrides the default number of retries for\n"
		"                   failed reads. Default is 3\n\n"
       
		"-s X\n"
		"--start X          specifies a track to start audio extraction\n"
		"                   from. Default is 1\n\n"
       
		"-S X\n"
		"--stop X           specifies a track to stop audio extraction\n"
		"                   at. Default is last track on cd\n\n"
        
		"-r\n"
		"--readtest\n"
		"--rip              perform a digital audio extraction (rip) of\n"
		"                   tracks. --rip is an alias for --readtest and\n"
		"                   has the same function\n\n"

		"-e <null|raw|wave|lame|oggenc|toolame>\n"
		"--encoder <null|raw|wave|lame|oggenc|toolame>\n"
		"                   specifies which output 'encoder' to use. note\n"
		"                   that not all of these are really encoders in\n"
		"                   the strict sense. null will read all off the\n"
		"                   data from the disc, but then throw it away,\n"
		"                   this is purely intended for test purposes. The\n"
		"                   raw and wave modes are not real encoders, but\n"
		"                   select those modes.\n\n"

		"-E \"<options>\"\n"
		"--encopts \"<options>\"\n"
		"		    options to pass to encoder. Use this to specify\n"
	       	"		    options controlling the behavior of the encoder.\n"
		"		    A quick example would be\n"
		"		    --encopts \"--preset standard -q0\"\n"
		"		    See the encoders man page and help output for\n"
	        "		    more details. Note that the double quotes around\n"
		"		    the arguments to this option are required if you\n"
		"		    want to pass more than one option.\n\n"

		"-b name\n"
		"--basename name    specifies to create file names of the form\n"
		"                   nameXX.wav where XX is the track number,\n"
		"                   instead of the default of trackXX.wav.\n\n"
   
		"-k X\n"
		"--readchunk X      specifies to read X frames of audio data at\n"
		"                   a time, instead of 1 by 1.  this will\n"
		"                   increase performance up to a point.  the\n"
		"                   ideal value is different for every system.\n"
		"                   there is a direct correlation between higher\n"
		"                   values and higher memory usage.  also,\n"
		"                   beyond a certain point there is no\n"
		"                   improvement.  this gives up some of the\n"
		"                   fine-grained error/scratch-detection that\n"
		"                   cdstatus was designed for, so this still\n"
		"                   defaults to 1, but you now have the option.\n\n"
   
		"-c\n"
		"--cddb             instruct cdstatus to calculate the cddb disc\n"
		"                   id and contact the remote cddb database server\n"
		"                   to look up the album information. see --format\n\n"
       
		"-C\n"
		"--no-cddb          overrides user .cdstatus config choice and\n"
		"                   disables cddb lookup\n\n"
        
		"-f\n"
		"--format           used to specify filename format for output files.\n"
		"                   only valid when used with --cddb.  syntax is:\n\n"
		"                   #Artist#      -> Becomes artist name\n"
		"                   #Album#       -> Becomes name of cd\n"
		"                   #TrkNum#      -> Becomes track number, like 01\n"
		"                   #TrkName#     -> Becomes track name\n\n"
		"                   see README for example.  Other characters are \n" 
		"                   allowed freeform.\n\n"

		"-i\n"
		"--identical-reads X    continually re-read successfully read\n"
		"                   sectors up to max-read-sets times until X\n"
		"                   identical sets of data have been read. This is\n"
		"                   intended for secure extraction.\n\n"

		"-m\n"
		"--max-read-sets X  this is the maximum number of times to start\n"
		"                   over on reading sets when the identical count\n"
		"                   is re-set by a differing result.  Setting this\n"
		"                   to 0 will retry forever or until the reads\n"
		"                   succeed. 0 is NOT recommended as this may\n"
		"                   overheat or damage your drive after hours of\n"
		"                   running. I am providing it in the spirit of\n"
		"                   giving the user the choice, as per the UNIX\n"
		"                   philosophy. You have been warned.\n");
}
