#include "gimme_config_h.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#ifdef HAVE_NETDB_H
#include <netdb.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#include "cdstatus_output.h"
#include "cddb_connect_to_server.h"

int cddbConnectToServer(const char * cddb_site)
{
	/* network related */
	int client_sock;
	int lookup_result_code;
	struct addrinfo *results;
	struct addrinfo *res_entry;
	struct addrinfo hints;
	char host_address_text[256] = { '\0' };
	
	memset(&hints, '\0', sizeof(hints));
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = AI_ADDRCONFIG | AI_CANONNAME;

	lookup_result_code = getaddrinfo(cddb_site, CDDB_PORT, &hints, &results);
	if(lookup_result_code != 0) {
		conditional_printf(WARNING, gai_strerror(lookup_result_code));
		conditional_printf(WARNING, "Unable to look up the host address of the CDDB site %s.\n", cddb_site);
		return 0;
	}

	for(res_entry = results; res_entry != NULL; res_entry = res_entry->ai_next) {
		client_sock = socket(res_entry->ai_family, res_entry->ai_socktype, res_entry->ai_protocol);
		if(client_sock == -1) {
			/* local host may not support all address families for which there are entries
			 * it should be save to move along to the next entry */
			conditional_perror(DEBUG, "Unable to bind client socket for connection to CDDB server.\n");
			continue;
		}
		lookup_result_code = getnameinfo(res_entry->ai_addr, res_entry->ai_addrlen, host_address_text, sizeof(host_address_text), NULL, 0, NI_NUMERICHOST);
		if(lookup_result_code != 0) {
			conditional_printf(WARNING, "Failed to call getnameinfo() for returned address in lookup of %s: %s.\n", cddb_site, gai_strerror(lookup_result_code));
			strncpy(host_address_text, "Unavailable", sizeof(host_address_text - 1));
			host_address_text[sizeof(host_address_text)] = '\0';
		} else {
			conditional_printf(VERBOSE_DEBUG, "Got address for %s: %s\n", cddb_site, host_address_text);
		}
		if(connect(client_sock, res_entry->ai_addr, res_entry->ai_addrlen) != -1) {
			/* we connected successfully */
			conditional_printf(DEBUG, "Connected to cddb server %s (%s) successfully using address %s.\n", cddb_site, results->ai_canonname, host_address_text);
			break;
		} else {
			/* we failed to connect, we'll try the next address if there is one */
			conditional_printf(DEBUG, "Failed to connect to %s (%s) using address %s.\n", cddb_site, results->ai_canonname, host_address_text);
		}
	}

	freeaddrinfo(results);

	if(res_entry == NULL) {
		/* connection failed for all addresses we tried */
		conditional_printf(WARNING, "Failed to connect to cddb server %s on any address.\n", cddb_site);
		return 0;
	}

	return client_sock;
}
