#include "cddb_calc_discid.h"

/* based on the sample code on www.freedb.org.  Re-writen to inline
 * the second function and to eliminate a couple useless variables.
 * thank the documentation on that site for my ability to code the
 * cddb lookup code.  it's very well and clearly written,
 * especially the info on the server protocol
 */
unsigned int calcDiscId(unsigned int tracks, const cd_toc_info * cdtocinfo)
{
	unsigned int i;
	unsigned int t = 0;
	unsigned int n = 0;
	unsigned int j = 0;
	unsigned int id;

	for (i = 1; i <= tracks; ++i)
	{
		j = ((cdtocinfo[i].min * 60) + cdtocinfo[i].sec);
		while (j > 0)
		{
			n += (j % 10);
			j /= 10;
		}
	}
	t = ((cdtocinfo[0].min * 60) + cdtocinfo[0].sec) - ((cdtocinfo[1].min * 60) + cdtocinfo[1].sec);

	id = ((n % 0xff) << 24) | t << 8 | tracks;
	return id;
}
