#ifndef _CD_TOC_INFO_H
#define _CD_TOC_INFO_H

/** Structure to hold relevant TOC data for each track 
 *  @see readTOC() */
typedef struct
{
   /** minute within the cd that the track begins at */
    unsigned int min;
   /** second (within the minute) that the track begins at */
    unsigned int sec;
   /** frame (1/75th of a second, within second) that track begins at */
    unsigned int frame_local;
   /** "global" frame position that the track starts at.  This is the total frame offset from start of the cd. */
    unsigned int frame_global;
   /** on/off flag that indicates a data track (for mixed mode cd) */
    unsigned int data;
} cd_toc_info;

#endif
