#ifndef SHARED_H
# define SHARED_H
#include "bool.h"
#include <time.h>

#define MAXLINE 1024

struct HOSTMASK {
	u_char host[4];
	u_char mask[4];
};

struct settings {
	bool debug;
	bool rcfile_must_exist;
	bool staydropped;		/* if commandon dies while we are
					   #Connected, fatal error */
	bool waitpipe;			/* whether we wait for all processes
					   launched in commandon to exit before
					   considering us #Disconnected.
					   Useful for daemons. */
	bool onconnect_wait;		/* Wait until a users' onconnect has
					   been run before sending them
					   "#Connected". This is important if
					   onconnect does something which is
					   necessary to give them net access.
					   (e.g. enables NAT / IP Masquerading
					   for them). */
	long keep_alive_timeout;	/* kick clients who are quiet for
					   this many seconds. */
	long disconnect_wait;		/* wait this many seconds before
					   disconnecting in case someone
					   decides to CONNECT in that time */
	unsigned short port;
	char **bind_ips;
	int num_ips;
	int maxcons;			/* max of sokcount before we refuse
					 connections */
	int max_from_one;		/* max connections from one host */
	int max_redials;		/* times we can run commandon in a row
					   without connecting before err */
	char *authfile;			/* file of authentication data  */
	char *onconnect;		/* e.g. "ipchains -A forward -j MASQ
					   -s %b -i ppp0" */
	char *ondisconnect;
	struct HOSTMASK *hmdata;
	int num_hms;
	char *pidfile;			/* /var/run/dwun.pid */
	char *pre_commandon;		/* run before commandon starts */
	char *post_commandon;		/* run after commandon exits */
	char *commandon;		/* dcommand pon */
	char *commandoff;		/* poff */
	char *command_logfile;		/* redirect stderr/stdout of commandon 
					   and commandoff here */
	char *logfile;			/* usually NULL; syslog */
	char *external;			/* named pipe (optional) */
};

enum {
	MYLOG_STDERR,
	MYLOG_STDERR_DATEPID,
	MYLOG_SYSLOG
} MYLOG_OPTIONS;

#endif
