Cucumber-Ruby 5.0.0 release notes
=================================

This release marks an important milestone for Cucumber-Ruby - the ability
to publish results to the new [Cucumber Reports](https://reports.cucumber.io) service
offered by SmartBear.

For other changes in this release please refer to the full [change log](../CHANGELOG.old.md).

Cucumber Reports
----------------

The purpose of this service is to make it easier for teams using Cucumber to
share living documentation.

Report publishing is disabled by default, and when you run Cucumber, you will see
the following banner printed to `STDERR`:

```
┌──────────────────────────────────────────────────────────────────────────┐
│ Share your Cucumber Report with your team at https://reports.cucumber.io │
│                                                                          │
│ Command line option:    --publish                                        │
│ Environment variable:   CUCUMBER_PUBLISH_ENABLED=true                    │
│ cucumber.yml:           default: --publish                               │
│                                                                          │
│ More information at https://reports.cucumber.io/docs/cucumber-ruby       │
│                                                                          │
│ To disable this message, specify CUCUMBER_PUBLISH_QUIET=true or use the  │
│ --publish-quiet option. You can also add this to your cucumber.yml:      │
│ default: --publish-quiet                                                 │
└──────────────────────────────────────────────────────────────────────────┘
```

When publishing is enabled, Cucumber will issue an `HTTP PUT` request to
`https://messages.cucumber.io/api/reports` at the end of the run. The body of this
request is the [messages](https://github.com/cucumber/cucumber/tree/master/messages)
generated during the run.

The request is handled by an AWS Lambda function which does a `307` redirect to
AWS S3 where the message stream is stored.

Cucumber then prints a URL where the report can be viewed, for example:

```
┌──────────────────────────────────────────────────────────────────────────┐
│ View your Cucumber Report at:                                            │
│ https://reports.cucumber.io/reports/f318d9ec-5a3d-4727-adec-bd7b69e2edd3 │
│                                                                          │
│ This report will self-destruct in 24h unless it is claimed or deleted.   │
└──────────────────────────────────────────────────────────────────────────┘
```

Publishing behaviour can be modified with the following environment variables:

* `CUCUMBER_PUBLISH_ENABLED` - enable publishing
* `CUCUMBER_PUBLISH_TOKEN` - enable publishing using an authentication token
* `CUCUMBER_PUBLISH_URL` - override the URL where messages are published
* `CUCUMBER_PUBLISH_QUIET` - do not print the banner announcing how to publish reports

At the time of this writing, `CUCUMBER_PUBLISH_ENABLED` and `CUCUMBER_PUBLISH_TOKEN` behave
the same. When the Cucumber Reports service supports authentication, the `CUCUMBER_PUBLISH_TOKEN`
environment variable will be the preferred way to publish reports, as it will restrict
access to reports, and allow them to be kept for more than 24h.

The `CUCUMBER_PUBLISH_URL` environment variable allows other vendors to make their own
report service hosted on a different domain. The value of this environment variable can
also contain `-X` and `-H` [curl](https://curl.haxx.se/)-like options to override the HTTP
verb and define HTTP headers for the publishing request, for example:

```
export CUCUMBER_PUBLISH_URL="https://host.com -X POST -H 'Content-Type: application/x-ndjson'"
```

When `CUCUMBER_PUBLISH_TOKEN` is specified, this automatically adds an HTTP header for authentication:

```
Authorization: Bearer ${CUCUMBER_PUBLISH_TOKEN}
```

We would love feedback on this feature, and how we can improve it to meet your team's needs
for living documentation. You will find more information at [Cucumber Reports](https://reports.cucumber.io).
