/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.10.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_adv.h"
        #include <wx/joystick.h>
        #include <wx/window.h>
        #include <wx/gdicmn.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxJoystick : public ::wxJoystick
{
public:
    sipwxJoystick(int);
    sipwxJoystick(const ::wxJoystick&);
    ~sipwxJoystick();

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxJoystick(const sipwxJoystick &);
    sipwxJoystick &operator = (const sipwxJoystick &);
};

sipwxJoystick::sipwxJoystick(int joystick): ::wxJoystick(joystick), sipPySelf(SIP_NULLPTR)
{
}

sipwxJoystick::sipwxJoystick(const ::wxJoystick& a0): ::wxJoystick(a0), sipPySelf(SIP_NULLPTR)
{
}

sipwxJoystick::~sipwxJoystick()
{
    sipInstanceDestroyedEx(&sipPySelf);
}


PyDoc_STRVAR(doc_wxJoystick_GetButtonState, "GetButtonState() -> int\n"
"GetButtonState(id) -> bool\n"
"\n"
"Returns the state of the joystick buttons.\n"
"");

extern "C" {static PyObject *meth_wxJoystick_GetButtonState(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetButtonState(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetButtonState();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    {
        uint id;
        const ::wxJoystick *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bu", &sipSelf, sipType_wxJoystick, &sipCpp, &id))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetButtonState(id);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetButtonState, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetManufacturerId, "GetManufacturerId() -> int\n"
"\n"
"Returns the manufacturer id.");

extern "C" {static PyObject *meth_wxJoystick_GetManufacturerId(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetManufacturerId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetManufacturerId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetManufacturerId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetMovementThreshold, "GetMovementThreshold() -> int\n"
"\n"
"Returns the movement threshold, the number of steps outside which the\n"
"joystick is deemed to have moved.");

extern "C" {static PyObject *meth_wxJoystick_GetMovementThreshold(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetMovementThreshold(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMovementThreshold();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetMovementThreshold, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetNumberAxes, "GetNumberAxes() -> int\n"
"\n"
"Returns the number of axes for this joystick.");

extern "C" {static PyObject *meth_wxJoystick_GetNumberAxes(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetNumberAxes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNumberAxes();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetNumberAxes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetNumberButtons, "GetNumberButtons() -> int\n"
"\n"
"Returns the number of buttons for this joystick.");

extern "C" {static PyObject *meth_wxJoystick_GetNumberButtons(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetNumberButtons(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNumberButtons();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetNumberButtons, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetPOVCTSPosition, "GetPOVCTSPosition() -> int\n"
"\n"
"Returns the point-of-view position, expressed in continuous, one-\n"
"hundredth of a degree units.");

extern "C" {static PyObject *meth_wxJoystick_GetPOVCTSPosition(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetPOVCTSPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPOVCTSPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetPOVCTSPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetPOVPosition, "GetPOVPosition() -> int\n"
"\n"
"Returns the point-of-view position, expressed in continuous, one-\n"
"hundredth of a degree units, but limited to return 0, 9000, 18000 or\n"
"27000.");

extern "C" {static PyObject *meth_wxJoystick_GetPOVPosition(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetPOVPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPOVPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetPOVPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetPollingMax, "GetPollingMax() -> int\n"
"\n"
"Returns the maximum polling frequency.");

extern "C" {static PyObject *meth_wxJoystick_GetPollingMax(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetPollingMax(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPollingMax();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetPollingMax, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetPollingMin, "GetPollingMin() -> int\n"
"\n"
"Returns the minimum polling frequency.");

extern "C" {static PyObject *meth_wxJoystick_GetPollingMin(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetPollingMin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPollingMin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetPollingMin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetPosition, "GetPosition() -> wx.Point\n"
"GetPosition(axis) -> int\n"
"\n"
"Returns the x, y position of the joystick.\n"
"");

extern "C" {static PyObject *meth_wxJoystick_GetPosition(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetPosition(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            ::wxPoint*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPoint(sipCpp->GetPosition());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPoint, SIP_NULLPTR);
        }
    }

    {
        uint axis;
        const ::wxJoystick *sipCpp;

        static const char *sipKwdList[] = {
            sipName_axis,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bu", &sipSelf, sipType_wxJoystick, &sipCpp, &axis))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPosition(axis);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetProductId, "GetProductId() -> int\n"
"\n"
"Returns the product id for the joystick.");

extern "C" {static PyObject *meth_wxJoystick_GetProductId(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetProductId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetProductId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetProductId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetProductName, "GetProductName() -> str\n"
"\n"
"Returns the product name for the joystick.");

extern "C" {static PyObject *meth_wxJoystick_GetProductName(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetProductName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetProductName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetProductName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetRudderMax, "GetRudderMax() -> int\n"
"\n"
"Returns the maximum rudder position.");

extern "C" {static PyObject *meth_wxJoystick_GetRudderMax(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetRudderMax(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRudderMax();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetRudderMax, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetRudderMin, "GetRudderMin() -> int\n"
"\n"
"Returns the minimum rudder position.");

extern "C" {static PyObject *meth_wxJoystick_GetRudderMin(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetRudderMin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRudderMin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetRudderMin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetRudderPosition, "GetRudderPosition() -> int\n"
"\n"
"Returns the rudder position.");

extern "C" {static PyObject *meth_wxJoystick_GetRudderPosition(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetRudderPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRudderPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetRudderPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetUMax, "GetUMax() -> int\n"
"\n"
"Returns the maximum U position.");

extern "C" {static PyObject *meth_wxJoystick_GetUMax(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetUMax(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetUMax();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetUMax, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetUMin, "GetUMin() -> int\n"
"\n"
"Returns the minimum U position.");

extern "C" {static PyObject *meth_wxJoystick_GetUMin(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetUMin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetUMin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetUMin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetUPosition, "GetUPosition() -> int\n"
"\n"
"Gets the position of the fifth axis of the joystick, if it exists.");

extern "C" {static PyObject *meth_wxJoystick_GetUPosition(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetUPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetUPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetUPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetVMax, "GetVMax() -> int\n"
"\n"
"Returns the maximum V position.");

extern "C" {static PyObject *meth_wxJoystick_GetVMax(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetVMax(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetVMax();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetVMax, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetVMin, "GetVMin() -> int\n"
"\n"
"Returns the minimum V position.");

extern "C" {static PyObject *meth_wxJoystick_GetVMin(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetVMin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetVMin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetVMin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetVPosition, "GetVPosition() -> int\n"
"\n"
"Gets the position of the sixth axis of the joystick, if it exists.");

extern "C" {static PyObject *meth_wxJoystick_GetVPosition(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetVPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetVPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetVPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetXMax, "GetXMax() -> int\n"
"\n"
"Returns the maximum x position.");

extern "C" {static PyObject *meth_wxJoystick_GetXMax(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetXMax(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetXMax();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetXMax, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetXMin, "GetXMin() -> int\n"
"\n"
"Returns the minimum x position.");

extern "C" {static PyObject *meth_wxJoystick_GetXMin(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetXMin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetXMin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetXMin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetYMax, "GetYMax() -> int\n"
"\n"
"Returns the maximum y position.");

extern "C" {static PyObject *meth_wxJoystick_GetYMax(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetYMax(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetYMax();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetYMax, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetYMin, "GetYMin() -> int\n"
"\n"
"Returns the minimum y position.");

extern "C" {static PyObject *meth_wxJoystick_GetYMin(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetYMin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetYMin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetYMin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetZMax, "GetZMax() -> int\n"
"\n"
"Returns the maximum z position.");

extern "C" {static PyObject *meth_wxJoystick_GetZMax(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetZMax(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetZMax();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetZMax, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetZMin, "GetZMin() -> int\n"
"\n"
"Returns the minimum z position.");

extern "C" {static PyObject *meth_wxJoystick_GetZMin(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetZMin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetZMin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetZMin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetZPosition, "GetZPosition() -> int\n"
"\n"
"Returns the z position of the joystick.");

extern "C" {static PyObject *meth_wxJoystick_GetZPosition(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetZPosition(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetZPosition();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetZPosition, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_HasPOV, "HasPOV() -> bool\n"
"\n"
"Returns true if the joystick has a point of view control.");

extern "C" {static PyObject *meth_wxJoystick_HasPOV(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_HasPOV(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasPOV();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_HasPOV, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_HasPOV4Dir, "HasPOV4Dir() -> bool\n"
"\n"
"Returns true if the joystick point-of-view supports discrete values\n"
"(centered, forward, backward, left, and right).");

extern "C" {static PyObject *meth_wxJoystick_HasPOV4Dir(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_HasPOV4Dir(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasPOV4Dir();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_HasPOV4Dir, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_HasPOVCTS, "HasPOVCTS() -> bool\n"
"\n"
"Returns true if the joystick point-of-view supports continuous degree\n"
"bearings.");

extern "C" {static PyObject *meth_wxJoystick_HasPOVCTS(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_HasPOVCTS(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasPOVCTS();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_HasPOVCTS, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_HasRudder, "HasRudder() -> bool\n"
"\n"
"Returns true if there is a rudder attached to the computer.");

extern "C" {static PyObject *meth_wxJoystick_HasRudder(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_HasRudder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasRudder();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_HasRudder, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_HasU, "HasU() -> bool\n"
"\n"
"Returns true if the joystick has a U axis.");

extern "C" {static PyObject *meth_wxJoystick_HasU(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_HasU(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasU();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_HasU, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_HasV, "HasV() -> bool\n"
"\n"
"Returns true if the joystick has a V axis.");

extern "C" {static PyObject *meth_wxJoystick_HasV(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_HasV(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasV();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_HasV, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_HasZ, "HasZ() -> bool\n"
"\n"
"Returns true if the joystick has a Z axis.");

extern "C" {static PyObject *meth_wxJoystick_HasZ(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_HasZ(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasZ();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_HasZ, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if the joystick is functioning.");

extern "C" {static PyObject *meth_wxJoystick_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_ReleaseCapture, "ReleaseCapture() -> bool\n"
"\n"
"Releases the capture set by SetCapture.");

extern "C" {static PyObject *meth_wxJoystick_ReleaseCapture(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_ReleaseCapture(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ReleaseCapture();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_ReleaseCapture, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_SetCapture, "SetCapture(win, pollingFreq=0) -> bool\n"
"\n"
"Sets the capture to direct joystick events to win.");

extern "C" {static PyObject *meth_wxJoystick_SetCapture(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_SetCapture(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxWindow* win;
        int pollingFreq = 0;
        ::wxJoystick *sipCpp;

        static const char *sipKwdList[] = {
            sipName_win,
            sipName_pollingFreq,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8|i", &sipSelf, sipType_wxJoystick, &sipCpp, sipType_wxWindow, &win, &pollingFreq))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetCapture(win, pollingFreq);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_SetCapture, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_SetMovementThreshold, "SetMovementThreshold(threshold) -> None\n"
"\n"
"Sets the movement threshold, the number of steps outside which the\n"
"joystick is deemed to have moved.");

extern "C" {static PyObject *meth_wxJoystick_SetMovementThreshold(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_SetMovementThreshold(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int threshold;
        ::wxJoystick *sipCpp;

        static const char *sipKwdList[] = {
            sipName_threshold,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxJoystick, &sipCpp, &threshold))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMovementThreshold(threshold);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_SetMovementThreshold, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetNumberJoysticks, "GetNumberJoysticks() -> int\n"
"\n"
"Returns the number of joysticks currently attached to the computer.");

extern "C" {static PyObject *meth_wxJoystick_GetNumberJoysticks(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetNumberJoysticks(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = ::wxJoystick::GetNumberJoysticks();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetNumberJoysticks, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetMaxButtons, "GetMaxButtons() -> int");

extern "C" {static PyObject *meth_wxJoystick_GetMaxButtons(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetMaxButtons(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMaxButtons();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetMaxButtons, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxJoystick_GetMaxAxes, "GetMaxAxes() -> int");

extern "C" {static PyObject *meth_wxJoystick_GetMaxAxes(PyObject *, PyObject *);}
static PyObject *meth_wxJoystick_GetMaxAxes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxJoystick *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxJoystick, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMaxAxes();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Joystick, sipName_GetMaxAxes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxJoystick(void *, const sipTypeDef *);}
static void *cast_wxJoystick(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxJoystick *sipCpp = reinterpret_cast<::wxJoystick *>(sipCppV);

    if (targetType == sipType_wxJoystick)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast<::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxJoystick(void *, int);}
static void release_wxJoystick(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxJoystick *>(sipCppV);
    else
        delete reinterpret_cast<::wxJoystick *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxJoystick(Py_ssize_t);}
static void *array_wxJoystick(Py_ssize_t sipNrElem)
{
    return new ::wxJoystick[sipNrElem];
}


extern "C" {static void array_delete_wxJoystick(void *);}
static void array_delete_wxJoystick(void *sipCpp)
{
    delete[] reinterpret_cast<::wxJoystick *>(sipCpp);
}


extern "C" {static void assign_wxJoystick(void *, Py_ssize_t, void *);}
static void assign_wxJoystick(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::wxJoystick *>(sipDst)[sipDstIdx] = *reinterpret_cast<::wxJoystick *>(sipSrc);
}


extern "C" {static void *copy_wxJoystick(const void *, Py_ssize_t);}
static void *copy_wxJoystick(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxJoystick(reinterpret_cast<const ::wxJoystick *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxJoystick(sipSimpleWrapper *);}
static void dealloc_wxJoystick(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxJoystick *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxJoystick(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxJoystick(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxJoystick(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxJoystick *sipCpp = SIP_NULLPTR;

    {
        int joystick = wxJOYSTICK1;

        static const char *sipKwdList[] = {
            sipName_joystick,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|i", &joystick))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxJoystick(joystick);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxJoystick* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxJoystick, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxJoystick(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxJoystick[] = {{40, 0, 1}};


static PyMethodDef methods_wxJoystick[] = {
    {sipName_GetButtonState, SIP_MLMETH_CAST(meth_wxJoystick_GetButtonState), METH_VARARGS|METH_KEYWORDS, doc_wxJoystick_GetButtonState},
    {sipName_GetManufacturerId, meth_wxJoystick_GetManufacturerId, METH_VARARGS, doc_wxJoystick_GetManufacturerId},
    {sipName_GetMaxAxes, meth_wxJoystick_GetMaxAxes, METH_VARARGS, doc_wxJoystick_GetMaxAxes},
    {sipName_GetMaxButtons, meth_wxJoystick_GetMaxButtons, METH_VARARGS, doc_wxJoystick_GetMaxButtons},
    {sipName_GetMovementThreshold, meth_wxJoystick_GetMovementThreshold, METH_VARARGS, doc_wxJoystick_GetMovementThreshold},
    {sipName_GetNumberAxes, meth_wxJoystick_GetNumberAxes, METH_VARARGS, doc_wxJoystick_GetNumberAxes},
    {sipName_GetNumberButtons, meth_wxJoystick_GetNumberButtons, METH_VARARGS, doc_wxJoystick_GetNumberButtons},
    {sipName_GetNumberJoysticks, meth_wxJoystick_GetNumberJoysticks, METH_VARARGS, doc_wxJoystick_GetNumberJoysticks},
    {sipName_GetPOVCTSPosition, meth_wxJoystick_GetPOVCTSPosition, METH_VARARGS, doc_wxJoystick_GetPOVCTSPosition},
    {sipName_GetPOVPosition, meth_wxJoystick_GetPOVPosition, METH_VARARGS, doc_wxJoystick_GetPOVPosition},
    {sipName_GetPollingMax, meth_wxJoystick_GetPollingMax, METH_VARARGS, doc_wxJoystick_GetPollingMax},
    {sipName_GetPollingMin, meth_wxJoystick_GetPollingMin, METH_VARARGS, doc_wxJoystick_GetPollingMin},
    {sipName_GetPosition, SIP_MLMETH_CAST(meth_wxJoystick_GetPosition), METH_VARARGS|METH_KEYWORDS, doc_wxJoystick_GetPosition},
    {sipName_GetProductId, meth_wxJoystick_GetProductId, METH_VARARGS, doc_wxJoystick_GetProductId},
    {sipName_GetProductName, meth_wxJoystick_GetProductName, METH_VARARGS, doc_wxJoystick_GetProductName},
    {sipName_GetRudderMax, meth_wxJoystick_GetRudderMax, METH_VARARGS, doc_wxJoystick_GetRudderMax},
    {sipName_GetRudderMin, meth_wxJoystick_GetRudderMin, METH_VARARGS, doc_wxJoystick_GetRudderMin},
    {sipName_GetRudderPosition, meth_wxJoystick_GetRudderPosition, METH_VARARGS, doc_wxJoystick_GetRudderPosition},
    {sipName_GetUMax, meth_wxJoystick_GetUMax, METH_VARARGS, doc_wxJoystick_GetUMax},
    {sipName_GetUMin, meth_wxJoystick_GetUMin, METH_VARARGS, doc_wxJoystick_GetUMin},
    {sipName_GetUPosition, meth_wxJoystick_GetUPosition, METH_VARARGS, doc_wxJoystick_GetUPosition},
    {sipName_GetVMax, meth_wxJoystick_GetVMax, METH_VARARGS, doc_wxJoystick_GetVMax},
    {sipName_GetVMin, meth_wxJoystick_GetVMin, METH_VARARGS, doc_wxJoystick_GetVMin},
    {sipName_GetVPosition, meth_wxJoystick_GetVPosition, METH_VARARGS, doc_wxJoystick_GetVPosition},
    {sipName_GetXMax, meth_wxJoystick_GetXMax, METH_VARARGS, doc_wxJoystick_GetXMax},
    {sipName_GetXMin, meth_wxJoystick_GetXMin, METH_VARARGS, doc_wxJoystick_GetXMin},
    {sipName_GetYMax, meth_wxJoystick_GetYMax, METH_VARARGS, doc_wxJoystick_GetYMax},
    {sipName_GetYMin, meth_wxJoystick_GetYMin, METH_VARARGS, doc_wxJoystick_GetYMin},
    {sipName_GetZMax, meth_wxJoystick_GetZMax, METH_VARARGS, doc_wxJoystick_GetZMax},
    {sipName_GetZMin, meth_wxJoystick_GetZMin, METH_VARARGS, doc_wxJoystick_GetZMin},
    {sipName_GetZPosition, meth_wxJoystick_GetZPosition, METH_VARARGS, doc_wxJoystick_GetZPosition},
    {sipName_HasPOV, meth_wxJoystick_HasPOV, METH_VARARGS, doc_wxJoystick_HasPOV},
    {sipName_HasPOV4Dir, meth_wxJoystick_HasPOV4Dir, METH_VARARGS, doc_wxJoystick_HasPOV4Dir},
    {sipName_HasPOVCTS, meth_wxJoystick_HasPOVCTS, METH_VARARGS, doc_wxJoystick_HasPOVCTS},
    {sipName_HasRudder, meth_wxJoystick_HasRudder, METH_VARARGS, doc_wxJoystick_HasRudder},
    {sipName_HasU, meth_wxJoystick_HasU, METH_VARARGS, doc_wxJoystick_HasU},
    {sipName_HasV, meth_wxJoystick_HasV, METH_VARARGS, doc_wxJoystick_HasV},
    {sipName_HasZ, meth_wxJoystick_HasZ, METH_VARARGS, doc_wxJoystick_HasZ},
    {sipName_IsOk, meth_wxJoystick_IsOk, METH_VARARGS, doc_wxJoystick_IsOk},
    {sipName_ReleaseCapture, meth_wxJoystick_ReleaseCapture, METH_VARARGS, doc_wxJoystick_ReleaseCapture},
    {sipName_SetCapture, SIP_MLMETH_CAST(meth_wxJoystick_SetCapture), METH_VARARGS|METH_KEYWORDS, doc_wxJoystick_SetCapture},
    {sipName_SetMovementThreshold, SIP_MLMETH_CAST(meth_wxJoystick_SetMovementThreshold), METH_VARARGS|METH_KEYWORDS, doc_wxJoystick_SetMovementThreshold}
};

sipVariableDef variables_wxJoystick[] = {
    {PropertyVariable, sipName_ZPosition, &methods_wxJoystick[30], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ZMin, &methods_wxJoystick[29], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ZMax, &methods_wxJoystick[28], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_YMin, &methods_wxJoystick[27], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_YMax, &methods_wxJoystick[26], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_XMin, &methods_wxJoystick[25], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_XMax, &methods_wxJoystick[24], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_VPosition, &methods_wxJoystick[23], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_VMin, &methods_wxJoystick[22], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_VMax, &methods_wxJoystick[21], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_UPosition, &methods_wxJoystick[20], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_UMin, &methods_wxJoystick[19], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_UMax, &methods_wxJoystick[18], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RudderPosition, &methods_wxJoystick[17], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RudderMin, &methods_wxJoystick[16], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RudderMax, &methods_wxJoystick[15], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ProductName, &methods_wxJoystick[14], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ProductId, &methods_wxJoystick[13], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Position, &methods_wxJoystick[12], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PollingMin, &methods_wxJoystick[11], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PollingMax, &methods_wxJoystick[10], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_POVPosition, &methods_wxJoystick[9], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_POVCTSPosition, &methods_wxJoystick[8], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_NumberButtons, &methods_wxJoystick[6], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_NumberAxes, &methods_wxJoystick[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_MovementThreshold, &methods_wxJoystick[4], &methods_wxJoystick[41], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_MaxButtons, &methods_wxJoystick[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_MaxAxes, &methods_wxJoystick[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ManufacturerId, &methods_wxJoystick[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ButtonState, &methods_wxJoystick[0], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxJoystick, "Joystick(joystick=wx.JOYSTICK1) -> None\n"
"\n"
"wxJoystick allows an application to control one or more joysticks.");


sipClassTypeDef sipTypeDef__adv_wxJoystick = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxJoystick,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_Joystick,
        {0, 0, 1},
        42, methods_wxJoystick,
        0, SIP_NULLPTR,
        30, variables_wxJoystick,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxJoystick,
    -1,
    -1,
    supers_wxJoystick,
    SIP_NULLPTR,
    init_type_wxJoystick,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxJoystick,
    assign_wxJoystick,
    array_wxJoystick,
    copy_wxJoystick,
    release_wxJoystick,
    cast_wxJoystick,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxJoystick,
    sizeof (::wxJoystick),
};
