//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfdata?language=objc)
#[repr(C)]
pub struct CFData {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFData {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFData"> for CFData {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmutabledata?language=objc)
#[repr(C)]
pub struct CFMutableData {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFMutableData: CFData {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFData"> for CFMutableData {}
);

unsafe impl ConcreteType for CFData {
    #[doc(alias = "CFDataGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFDataGetTypeID() -> CFTypeID;
        }
        unsafe { CFDataGetTypeID() }
    }
}

impl CFData {
    #[doc(alias = "CFDataCreate")]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        bytes: *const u8,
        length: CFIndex,
    ) -> Option<CFRetained<CFData>> {
        extern "C-unwind" {
            fn CFDataCreate(
                allocator: Option<&CFAllocator>,
                bytes: *const u8,
                length: CFIndex,
            ) -> Option<NonNull<CFData>>;
        }
        let ret = unsafe { CFDataCreate(allocator, bytes, length) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFDataCreateWithBytesNoCopy")]
    #[inline]
    pub unsafe fn with_bytes_no_copy(
        allocator: Option<&CFAllocator>,
        bytes: *const u8,
        length: CFIndex,
        bytes_deallocator: Option<&CFAllocator>,
    ) -> Option<CFRetained<CFData>> {
        extern "C-unwind" {
            fn CFDataCreateWithBytesNoCopy(
                allocator: Option<&CFAllocator>,
                bytes: *const u8,
                length: CFIndex,
                bytes_deallocator: Option<&CFAllocator>,
            ) -> Option<NonNull<CFData>>;
        }
        let ret =
            unsafe { CFDataCreateWithBytesNoCopy(allocator, bytes, length, bytes_deallocator) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFDataCreateCopy")]
    #[inline]
    pub fn new_copy(
        allocator: Option<&CFAllocator>,
        the_data: Option<&CFData>,
    ) -> Option<CFRetained<CFData>> {
        extern "C-unwind" {
            fn CFDataCreateCopy(
                allocator: Option<&CFAllocator>,
                the_data: Option<&CFData>,
            ) -> Option<NonNull<CFData>>;
        }
        let ret = unsafe { CFDataCreateCopy(allocator, the_data) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFMutableData {
    #[doc(alias = "CFDataCreateMutable")]
    #[inline]
    pub fn new(
        allocator: Option<&CFAllocator>,
        capacity: CFIndex,
    ) -> Option<CFRetained<CFMutableData>> {
        extern "C-unwind" {
            fn CFDataCreateMutable(
                allocator: Option<&CFAllocator>,
                capacity: CFIndex,
            ) -> Option<NonNull<CFMutableData>>;
        }
        let ret = unsafe { CFDataCreateMutable(allocator, capacity) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFDataCreateMutableCopy")]
    #[inline]
    pub unsafe fn new_copy(
        allocator: Option<&CFAllocator>,
        capacity: CFIndex,
        the_data: Option<&CFData>,
    ) -> Option<CFRetained<CFMutableData>> {
        extern "C-unwind" {
            fn CFDataCreateMutableCopy(
                allocator: Option<&CFAllocator>,
                capacity: CFIndex,
                the_data: Option<&CFData>,
            ) -> Option<NonNull<CFMutableData>>;
        }
        let ret = unsafe { CFDataCreateMutableCopy(allocator, capacity, the_data) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CFData {
    #[doc(alias = "CFDataGetLength")]
    #[inline]
    pub fn length(self: &CFData) -> CFIndex {
        extern "C-unwind" {
            fn CFDataGetLength(the_data: &CFData) -> CFIndex;
        }
        unsafe { CFDataGetLength(self) }
    }

    #[doc(alias = "CFDataGetBytePtr")]
    #[inline]
    pub fn byte_ptr(self: &CFData) -> *const u8 {
        extern "C-unwind" {
            fn CFDataGetBytePtr(the_data: &CFData) -> *const u8;
        }
        unsafe { CFDataGetBytePtr(self) }
    }
}

impl CFMutableData {
    #[doc(alias = "CFDataGetMutableBytePtr")]
    #[inline]
    pub fn mutable_byte_ptr(the_data: Option<&CFMutableData>) -> *mut u8 {
        extern "C-unwind" {
            fn CFDataGetMutableBytePtr(the_data: Option<&CFMutableData>) -> *mut u8;
        }
        unsafe { CFDataGetMutableBytePtr(the_data) }
    }
}

impl CFData {
    #[doc(alias = "CFDataGetBytes")]
    #[inline]
    pub unsafe fn bytes(self: &CFData, range: CFRange, buffer: *mut u8) {
        extern "C-unwind" {
            fn CFDataGetBytes(the_data: &CFData, range: CFRange, buffer: *mut u8);
        }
        unsafe { CFDataGetBytes(self, range, buffer) }
    }
}

impl CFMutableData {
    #[doc(alias = "CFDataSetLength")]
    #[inline]
    pub fn set_length(the_data: Option<&CFMutableData>, length: CFIndex) {
        extern "C-unwind" {
            fn CFDataSetLength(the_data: Option<&CFMutableData>, length: CFIndex);
        }
        unsafe { CFDataSetLength(the_data, length) }
    }

    #[doc(alias = "CFDataIncreaseLength")]
    #[inline]
    pub fn increase_length(the_data: Option<&CFMutableData>, extra_length: CFIndex) {
        extern "C-unwind" {
            fn CFDataIncreaseLength(the_data: Option<&CFMutableData>, extra_length: CFIndex);
        }
        unsafe { CFDataIncreaseLength(the_data, extra_length) }
    }

    #[doc(alias = "CFDataAppendBytes")]
    #[inline]
    pub unsafe fn append_bytes(
        the_data: Option<&CFMutableData>,
        bytes: *const u8,
        length: CFIndex,
    ) {
        extern "C-unwind" {
            fn CFDataAppendBytes(
                the_data: Option<&CFMutableData>,
                bytes: *const u8,
                length: CFIndex,
            );
        }
        unsafe { CFDataAppendBytes(the_data, bytes, length) }
    }

    #[doc(alias = "CFDataReplaceBytes")]
    #[inline]
    pub unsafe fn replace_bytes(
        the_data: Option<&CFMutableData>,
        range: CFRange,
        new_bytes: *const u8,
        new_length: CFIndex,
    ) {
        extern "C-unwind" {
            fn CFDataReplaceBytes(
                the_data: Option<&CFMutableData>,
                range: CFRange,
                new_bytes: *const u8,
                new_length: CFIndex,
            );
        }
        unsafe { CFDataReplaceBytes(the_data, range, new_bytes, new_length) }
    }

    #[doc(alias = "CFDataDeleteBytes")]
    #[inline]
    pub fn delete_bytes(the_data: Option<&CFMutableData>, range: CFRange) {
        extern "C-unwind" {
            fn CFDataDeleteBytes(the_data: Option<&CFMutableData>, range: CFRange);
        }
        unsafe { CFDataDeleteBytes(the_data, range) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfdatasearchflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFDataSearchFlags(pub CFOptionFlags);
bitflags::bitflags! {
    impl CFDataSearchFlags: CFOptionFlags {
        #[doc(alias = "kCFDataSearchBackwards")]
        const Backwards = 1<<0;
        #[doc(alias = "kCFDataSearchAnchored")]
        const Anchored = 1<<1;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFDataSearchFlags {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFDataSearchFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CFData {
    #[doc(alias = "CFDataFind")]
    #[inline]
    pub unsafe fn find(
        self: &CFData,
        data_to_find: Option<&CFData>,
        search_range: CFRange,
        compare_options: CFDataSearchFlags,
    ) -> CFRange {
        extern "C-unwind" {
            fn CFDataFind(
                the_data: &CFData,
                data_to_find: Option<&CFData>,
                search_range: CFRange,
                compare_options: CFDataSearchFlags,
            ) -> CFRange;
        }
        unsafe { CFDataFind(self, data_to_find, search_range, compare_options) }
    }
}

#[deprecated = "renamed to `CFData::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFDataCreate(
    allocator: Option<&CFAllocator>,
    bytes: *const u8,
    length: CFIndex,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFDataCreate(
            allocator: Option<&CFAllocator>,
            bytes: *const u8,
            length: CFIndex,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CFDataCreate(allocator, bytes, length) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFData::with_bytes_no_copy`"]
#[inline]
pub unsafe extern "C-unwind" fn CFDataCreateWithBytesNoCopy(
    allocator: Option<&CFAllocator>,
    bytes: *const u8,
    length: CFIndex,
    bytes_deallocator: Option<&CFAllocator>,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFDataCreateWithBytesNoCopy(
            allocator: Option<&CFAllocator>,
            bytes: *const u8,
            length: CFIndex,
            bytes_deallocator: Option<&CFAllocator>,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CFDataCreateWithBytesNoCopy(allocator, bytes, length, bytes_deallocator) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFData::new_copy`"]
#[inline]
pub extern "C-unwind" fn CFDataCreateCopy(
    allocator: Option<&CFAllocator>,
    the_data: Option<&CFData>,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFDataCreateCopy(
            allocator: Option<&CFAllocator>,
            the_data: Option<&CFData>,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CFDataCreateCopy(allocator, the_data) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFMutableData::new`"]
#[inline]
pub extern "C-unwind" fn CFDataCreateMutable(
    allocator: Option<&CFAllocator>,
    capacity: CFIndex,
) -> Option<CFRetained<CFMutableData>> {
    extern "C-unwind" {
        fn CFDataCreateMutable(
            allocator: Option<&CFAllocator>,
            capacity: CFIndex,
        ) -> Option<NonNull<CFMutableData>>;
    }
    let ret = unsafe { CFDataCreateMutable(allocator, capacity) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFMutableData::new_copy`"]
#[inline]
pub unsafe extern "C-unwind" fn CFDataCreateMutableCopy(
    allocator: Option<&CFAllocator>,
    capacity: CFIndex,
    the_data: Option<&CFData>,
) -> Option<CFRetained<CFMutableData>> {
    extern "C-unwind" {
        fn CFDataCreateMutableCopy(
            allocator: Option<&CFAllocator>,
            capacity: CFIndex,
            the_data: Option<&CFData>,
        ) -> Option<NonNull<CFMutableData>>;
    }
    let ret = unsafe { CFDataCreateMutableCopy(allocator, capacity, the_data) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFData::length`"]
#[inline]
pub extern "C-unwind" fn CFDataGetLength(the_data: &CFData) -> CFIndex {
    extern "C-unwind" {
        fn CFDataGetLength(the_data: &CFData) -> CFIndex;
    }
    unsafe { CFDataGetLength(the_data) }
}

#[deprecated = "renamed to `CFData::byte_ptr`"]
#[inline]
pub extern "C-unwind" fn CFDataGetBytePtr(the_data: &CFData) -> *const u8 {
    extern "C-unwind" {
        fn CFDataGetBytePtr(the_data: &CFData) -> *const u8;
    }
    unsafe { CFDataGetBytePtr(the_data) }
}

#[deprecated = "renamed to `CFMutableData::mutable_byte_ptr`"]
#[inline]
pub extern "C-unwind" fn CFDataGetMutableBytePtr(the_data: Option<&CFMutableData>) -> *mut u8 {
    extern "C-unwind" {
        fn CFDataGetMutableBytePtr(the_data: Option<&CFMutableData>) -> *mut u8;
    }
    unsafe { CFDataGetMutableBytePtr(the_data) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFData::bytes`"]
    pub fn CFDataGetBytes(the_data: &CFData, range: CFRange, buffer: *mut u8);
}

#[deprecated = "renamed to `CFMutableData::set_length`"]
#[inline]
pub extern "C-unwind" fn CFDataSetLength(the_data: Option<&CFMutableData>, length: CFIndex) {
    extern "C-unwind" {
        fn CFDataSetLength(the_data: Option<&CFMutableData>, length: CFIndex);
    }
    unsafe { CFDataSetLength(the_data, length) }
}

#[deprecated = "renamed to `CFMutableData::increase_length`"]
#[inline]
pub extern "C-unwind" fn CFDataIncreaseLength(
    the_data: Option<&CFMutableData>,
    extra_length: CFIndex,
) {
    extern "C-unwind" {
        fn CFDataIncreaseLength(the_data: Option<&CFMutableData>, extra_length: CFIndex);
    }
    unsafe { CFDataIncreaseLength(the_data, extra_length) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableData::append_bytes`"]
    pub fn CFDataAppendBytes(the_data: Option<&CFMutableData>, bytes: *const u8, length: CFIndex);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFMutableData::replace_bytes`"]
    pub fn CFDataReplaceBytes(
        the_data: Option<&CFMutableData>,
        range: CFRange,
        new_bytes: *const u8,
        new_length: CFIndex,
    );
}

#[deprecated = "renamed to `CFMutableData::delete_bytes`"]
#[inline]
pub extern "C-unwind" fn CFDataDeleteBytes(the_data: Option<&CFMutableData>, range: CFRange) {
    extern "C-unwind" {
        fn CFDataDeleteBytes(the_data: Option<&CFMutableData>, range: CFRange);
    }
    unsafe { CFDataDeleteBytes(the_data, range) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CFData::find`"]
    pub fn CFDataFind(
        the_data: &CFData,
        data_to_find: Option<&CFData>,
        search_range: CFRange,
        compare_options: CFDataSearchFlags,
    ) -> CFRange;
}
