#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 6516
#define LARGE_STATE_COUNT 1257
#define SYMBOL_COUNT 418
#define ALIAS_COUNT 6
#define TOKEN_COUNT 175
#define EXTERNAL_TOKEN_COUNT 10
#define FIELD_COUNT 48
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 404

enum ts_symbol_identifiers {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_type = 6,
  anon_sym_EQ = 7,
  anon_sym_as = 8,
  anon_sym_namespace = 9,
  anon_sym_LBRACE = 10,
  anon_sym_COMMA = 11,
  anon_sym_RBRACE = 12,
  anon_sym_typeof = 13,
  anon_sym_import = 14,
  anon_sym_from = 15,
  anon_sym_with = 16,
  anon_sym_assert = 17,
  anon_sym_var = 18,
  anon_sym_let = 19,
  anon_sym_const = 20,
  anon_sym_BANG = 21,
  anon_sym_else = 22,
  anon_sym_if = 23,
  anon_sym_switch = 24,
  anon_sym_for = 25,
  anon_sym_LPAREN = 26,
  anon_sym_SEMI = 27,
  anon_sym_RPAREN = 28,
  anon_sym_await = 29,
  anon_sym_in = 30,
  anon_sym_of = 31,
  anon_sym_while = 32,
  anon_sym_do = 33,
  anon_sym_try = 34,
  anon_sym_break = 35,
  anon_sym_continue = 36,
  anon_sym_debugger = 37,
  anon_sym_return = 38,
  anon_sym_throw = 39,
  anon_sym_COLON = 40,
  anon_sym_case = 41,
  anon_sym_catch = 42,
  anon_sym_finally = 43,
  anon_sym_yield = 44,
  anon_sym_LBRACK = 45,
  anon_sym_RBRACK = 46,
  anon_sym_DOT = 47,
  anon_sym_class = 48,
  anon_sym_async = 49,
  anon_sym_function = 50,
  anon_sym_EQ_GT = 51,
  anon_sym_QMARK_DOT = 52,
  anon_sym_new = 53,
  anon_sym_using = 54,
  anon_sym_PLUS_EQ = 55,
  anon_sym_DASH_EQ = 56,
  anon_sym_STAR_EQ = 57,
  anon_sym_SLASH_EQ = 58,
  anon_sym_PERCENT_EQ = 59,
  anon_sym_CARET_EQ = 60,
  anon_sym_AMP_EQ = 61,
  anon_sym_PIPE_EQ = 62,
  anon_sym_GT_GT_EQ = 63,
  anon_sym_GT_GT_GT_EQ = 64,
  anon_sym_LT_LT_EQ = 65,
  anon_sym_STAR_STAR_EQ = 66,
  anon_sym_AMP_AMP_EQ = 67,
  anon_sym_PIPE_PIPE_EQ = 68,
  anon_sym_QMARK_QMARK_EQ = 69,
  anon_sym_DOT_DOT_DOT = 70,
  anon_sym_AMP_AMP = 71,
  anon_sym_PIPE_PIPE = 72,
  anon_sym_GT_GT = 73,
  anon_sym_GT_GT_GT = 74,
  anon_sym_LT_LT = 75,
  anon_sym_AMP = 76,
  anon_sym_CARET = 77,
  anon_sym_PIPE = 78,
  anon_sym_PLUS = 79,
  anon_sym_DASH = 80,
  anon_sym_SLASH = 81,
  anon_sym_PERCENT = 82,
  anon_sym_STAR_STAR = 83,
  anon_sym_LT = 84,
  anon_sym_LT_EQ = 85,
  anon_sym_EQ_EQ = 86,
  anon_sym_EQ_EQ_EQ = 87,
  anon_sym_BANG_EQ = 88,
  anon_sym_BANG_EQ_EQ = 89,
  anon_sym_GT_EQ = 90,
  anon_sym_GT = 91,
  anon_sym_QMARK_QMARK = 92,
  anon_sym_instanceof = 93,
  anon_sym_TILDE = 94,
  anon_sym_void = 95,
  anon_sym_delete = 96,
  anon_sym_PLUS_PLUS = 97,
  anon_sym_DASH_DASH = 98,
  anon_sym_DQUOTE = 99,
  anon_sym_SQUOTE = 100,
  sym_unescaped_double_string_fragment = 101,
  sym_unescaped_single_string_fragment = 102,
  sym_escape_sequence = 103,
  sym_comment = 104,
  anon_sym_BQUOTE = 105,
  anon_sym_DOLLAR_LBRACE = 106,
  anon_sym_SLASH2 = 107,
  sym_regex_pattern = 108,
  sym_regex_flags = 109,
  sym_number = 110,
  sym_private_property_identifier = 111,
  anon_sym_target = 112,
  anon_sym_meta = 113,
  sym_this = 114,
  sym_super = 115,
  sym_true = 116,
  sym_false = 117,
  sym_null = 118,
  sym_undefined = 119,
  anon_sym_AT = 120,
  anon_sym_static = 121,
  anon_sym_readonly = 122,
  anon_sym_get = 123,
  anon_sym_set = 124,
  anon_sym_QMARK = 125,
  anon_sym_declare = 126,
  anon_sym_public = 127,
  anon_sym_private = 128,
  anon_sym_protected = 129,
  anon_sym_override = 130,
  anon_sym_module = 131,
  anon_sym_any = 132,
  anon_sym_number = 133,
  anon_sym_boolean = 134,
  anon_sym_string = 135,
  anon_sym_symbol = 136,
  anon_sym_object = 137,
  anon_sym_property = 138,
  anon_sym_signal = 139,
  anon_sym_on = 140,
  anon_sym_required = 141,
  anon_sym_component = 142,
  anon_sym_abstract = 143,
  anon_sym_accessor = 144,
  anon_sym_satisfies = 145,
  anon_sym_require = 146,
  anon_sym_extends = 147,
  anon_sym_implements = 148,
  anon_sym_global = 149,
  anon_sym_interface = 150,
  anon_sym_enum = 151,
  anon_sym_DASH_QMARK_COLON = 152,
  anon_sym_PLUS_QMARK_COLON = 153,
  anon_sym_QMARK_COLON = 154,
  anon_sym_asserts = 155,
  anon_sym_infer = 156,
  anon_sym_is = 157,
  anon_sym_keyof = 158,
  anon_sym_unique = 159,
  anon_sym_unknown = 160,
  anon_sym_never = 161,
  anon_sym_LBRACE_PIPE = 162,
  anon_sym_PIPE_RBRACE = 163,
  anon_sym_pragma = 164,
  aux_sym_ui_version_specifier_token1 = 165,
  anon_sym_list = 166,
  anon_sym_final = 167,
  sym__automatic_semicolon = 168,
  sym__template_chars = 169,
  sym__ternary_qmark = 170,
  sym_html_comment = 171,
  sym_jsx_text = 172,
  sym__function_signature_automatic_semicolon = 173,
  sym___error_recovery = 174,
  sym_program = 175,
  sym_export_statement = 176,
  sym_namespace_export = 177,
  sym_export_clause = 178,
  sym_export_specifier = 179,
  sym__module_export_name = 180,
  sym_declaration = 181,
  sym_import = 182,
  sym_import_statement = 183,
  sym_import_clause = 184,
  sym__from_clause = 185,
  sym_namespace_import = 186,
  sym_named_imports = 187,
  sym_import_specifier = 188,
  sym_import_attribute = 189,
  sym_statement = 190,
  sym_expression_statement = 191,
  sym_variable_declaration = 192,
  sym_lexical_declaration = 193,
  sym_variable_declarator = 194,
  sym_statement_block = 195,
  sym_else_clause = 196,
  sym_if_statement = 197,
  sym_switch_statement = 198,
  sym_for_statement = 199,
  sym_for_in_statement = 200,
  sym__for_header = 201,
  sym_while_statement = 202,
  sym_do_statement = 203,
  sym_try_statement = 204,
  sym_with_statement = 205,
  sym_break_statement = 206,
  sym_continue_statement = 207,
  sym_debugger_statement = 208,
  sym_return_statement = 209,
  sym_throw_statement = 210,
  sym_empty_statement = 211,
  sym_labeled_statement = 212,
  sym_switch_body = 213,
  sym_switch_case = 214,
  sym_switch_default = 215,
  sym_catch_clause = 216,
  sym_finally_clause = 217,
  sym_parenthesized_expression = 218,
  sym_expression = 219,
  sym_primary_expression = 220,
  sym_yield_expression = 221,
  sym_object = 222,
  sym_object_pattern = 223,
  sym_assignment_pattern = 224,
  sym_object_assignment_pattern = 225,
  sym_array = 226,
  sym_array_pattern = 227,
  sym_nested_identifier = 228,
  sym_class = 229,
  sym_class_declaration = 230,
  sym_class_heritage = 231,
  sym_function_expression = 232,
  sym_function_declaration = 233,
  sym_generator_function = 234,
  sym_generator_function_declaration = 235,
  sym_arrow_function = 236,
  sym__call_signature = 237,
  sym__formal_parameter = 238,
  sym_optional_chain = 239,
  sym_call_expression = 240,
  sym_new_expression = 241,
  sym_await_expression = 242,
  sym_member_expression = 243,
  sym_subscript_expression = 244,
  sym_assignment_expression = 245,
  sym__augmented_assignment_lhs = 246,
  sym_augmented_assignment_expression = 247,
  sym__initializer = 248,
  sym__destructuring_pattern = 249,
  sym_spread_element = 250,
  sym_ternary_expression = 251,
  sym_binary_expression = 252,
  sym_unary_expression = 253,
  sym_update_expression = 254,
  sym_sequence_expression = 255,
  sym_string = 256,
  sym_template_string = 257,
  sym_template_substitution = 258,
  sym_regex = 259,
  sym_meta_property = 260,
  sym_arguments = 261,
  sym_decorator = 262,
  sym_decorator_member_expression = 263,
  sym_decorator_call_expression = 264,
  sym_class_body = 265,
  sym_formal_parameters = 266,
  sym_class_static_block = 267,
  sym_pattern = 268,
  sym_rest_pattern = 269,
  sym_method_definition = 270,
  sym_pair = 271,
  sym_pair_pattern = 272,
  sym__property_name = 273,
  sym_computed_property_name = 274,
  sym_public_field_definition = 275,
  sym__import_identifier = 276,
  sym_non_null_expression = 277,
  sym_method_signature = 278,
  sym_abstract_method_signature = 279,
  sym_function_signature = 280,
  sym_decorator_parenthesized_expression = 281,
  sym_type_assertion = 282,
  sym_as_expression = 283,
  sym_satisfies_expression = 284,
  sym_instantiation_expression = 285,
  sym_import_require_clause = 286,
  sym_extends_clause = 287,
  sym__extends_clause_single = 288,
  sym_implements_clause = 289,
  sym_ambient_declaration = 290,
  sym_abstract_class_declaration = 291,
  sym_module = 292,
  sym_internal_module = 293,
  sym__module = 294,
  sym_import_alias = 295,
  sym_nested_type_identifier = 296,
  sym_interface_declaration = 297,
  sym_extends_type_clause = 298,
  sym_enum_declaration = 299,
  sym_enum_body = 300,
  sym_enum_assignment = 301,
  sym_type_alias_declaration = 302,
  sym_accessibility_modifier = 303,
  sym_override_modifier = 304,
  sym_required_parameter = 305,
  sym_optional_parameter = 306,
  sym__parameter_name = 307,
  sym_omitting_type_annotation = 308,
  sym_adding_type_annotation = 309,
  sym_opting_type_annotation = 310,
  sym_type_annotation = 311,
  sym__type_query_member_expression_in_type_annotation = 312,
  sym__type_query_call_expression_in_type_annotation = 313,
  sym_asserts = 314,
  sym_asserts_annotation = 315,
  sym_type = 316,
  sym_tuple_parameter = 317,
  sym_optional_tuple_parameter = 318,
  sym_optional_type = 319,
  sym_rest_type = 320,
  sym__tuple_type_member = 321,
  sym_constructor_type = 322,
  sym_primary_type = 323,
  sym_template_type = 324,
  sym_template_literal_type = 325,
  sym_infer_type = 326,
  sym_conditional_type = 327,
  sym_generic_type = 328,
  sym_type_predicate = 329,
  sym_type_predicate_annotation = 330,
  sym__type_query_member_expression = 331,
  sym__type_query_subscript_expression = 332,
  sym__type_query_call_expression = 333,
  sym__type_query_instantiation_expression = 334,
  sym_type_query = 335,
  sym_index_type_query = 336,
  sym_lookup_type = 337,
  sym_mapped_type_clause = 338,
  sym_literal_type = 339,
  sym__number = 340,
  sym_existential_type = 341,
  sym_flow_maybe_type = 342,
  sym_parenthesized_type = 343,
  sym_predefined_type = 344,
  sym_type_arguments = 345,
  sym_object_type = 346,
  sym_call_signature = 347,
  sym_property_signature = 348,
  sym_type_parameters = 349,
  sym_type_parameter = 350,
  sym_default_type = 351,
  sym_constraint = 352,
  sym_construct_signature = 353,
  sym_index_signature = 354,
  sym_array_type = 355,
  sym_tuple_type = 356,
  sym_readonly_type = 357,
  sym_union_type = 358,
  sym_intersection_type = 359,
  sym_function_type = 360,
  sym_ui_pragma = 361,
  sym_ui_import = 362,
  sym_ui_version_specifier = 363,
  sym_ui_object_definition = 364,
  sym_ui_annotated_object = 365,
  sym_ui_annotation = 366,
  sym_ui_object_initializer = 367,
  sym_ui_annotated_object_member = 368,
  sym_ui_object_definition_binding = 369,
  sym_ui_binding = 370,
  sym_ui_property = 371,
  sym_ui_list_property_type = 372,
  sym_ui_property_modifier = 373,
  sym_ui_object_array = 374,
  sym_ui_required = 375,
  sym_ui_signal = 376,
  sym_ui_signal_parameters = 377,
  sym_ui_signal_parameter = 378,
  sym_ui_inline_component = 379,
  sym__qml_enum_declaration = 380,
  sym__qml_enum_body = 381,
  sym__qml_enum_assignment = 382,
  sym__qml_enum_negative_number = 383,
  sym_ui_nested_identifier = 384,
  sym_ui_simple_nested_identifier = 385,
  aux_sym_program_repeat1 = 386,
  aux_sym_export_statement_repeat1 = 387,
  aux_sym_export_clause_repeat1 = 388,
  aux_sym_named_imports_repeat1 = 389,
  aux_sym_variable_declaration_repeat1 = 390,
  aux_sym_statement_block_repeat1 = 391,
  aux_sym_switch_body_repeat1 = 392,
  aux_sym_object_repeat1 = 393,
  aux_sym_object_pattern_repeat1 = 394,
  aux_sym_array_repeat1 = 395,
  aux_sym_array_pattern_repeat1 = 396,
  aux_sym_sequence_expression_repeat1 = 397,
  aux_sym_string_repeat1 = 398,
  aux_sym_string_repeat2 = 399,
  aux_sym_template_string_repeat1 = 400,
  aux_sym_class_body_repeat1 = 401,
  aux_sym_formal_parameters_repeat1 = 402,
  aux_sym_extends_clause_repeat1 = 403,
  aux_sym_implements_clause_repeat1 = 404,
  aux_sym_extends_type_clause_repeat1 = 405,
  aux_sym_enum_body_repeat1 = 406,
  aux_sym_template_literal_type_repeat1 = 407,
  aux_sym_object_type_repeat1 = 408,
  aux_sym_type_parameters_repeat1 = 409,
  aux_sym_tuple_type_repeat1 = 410,
  aux_sym_ui_pragma_repeat1 = 411,
  aux_sym_ui_annotated_object_repeat1 = 412,
  aux_sym_ui_object_initializer_repeat1 = 413,
  aux_sym_ui_property_repeat1 = 414,
  aux_sym_ui_object_array_repeat1 = 415,
  aux_sym_ui_signal_parameters_repeat1 = 416,
  aux_sym__qml_enum_body_repeat1 = 417,
  alias_sym_interface_body = 418,
  alias_sym_property_identifier = 419,
  alias_sym_shorthand_property_identifier = 420,
  alias_sym_shorthand_property_identifier_pattern = 421,
  alias_sym_statement_identifier = 422,
  alias_sym_this_type = 423,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_type] = "type",
  [anon_sym_EQ] = "=",
  [anon_sym_as] = "as",
  [anon_sym_namespace] = "namespace",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_typeof] = "typeof",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_with] = "with",
  [anon_sym_assert] = "assert",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_BANG] = "!",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_SEMI] = ";",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_QMARK_DOT] = "\?.",
  [anon_sym_new] = "new",
  [anon_sym_using] = "using",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_TILDE] = "~",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [anon_sym_meta] = "meta",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_readonly] = "readonly",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [anon_sym_QMARK] = "\?",
  [anon_sym_declare] = "declare",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_override] = "override",
  [anon_sym_module] = "module",
  [anon_sym_any] = "any",
  [anon_sym_number] = "number",
  [anon_sym_boolean] = "boolean",
  [anon_sym_string] = "string",
  [anon_sym_symbol] = "symbol",
  [anon_sym_object] = "object",
  [anon_sym_property] = "property",
  [anon_sym_signal] = "signal",
  [anon_sym_on] = "on",
  [anon_sym_required] = "required",
  [anon_sym_component] = "component",
  [anon_sym_abstract] = "abstract",
  [anon_sym_accessor] = "accessor",
  [anon_sym_satisfies] = "satisfies",
  [anon_sym_require] = "require",
  [anon_sym_extends] = "extends",
  [anon_sym_implements] = "implements",
  [anon_sym_global] = "global",
  [anon_sym_interface] = "interface",
  [anon_sym_enum] = "enum",
  [anon_sym_DASH_QMARK_COLON] = "-\?:",
  [anon_sym_PLUS_QMARK_COLON] = "+\?:",
  [anon_sym_QMARK_COLON] = "\?:",
  [anon_sym_asserts] = "asserts",
  [anon_sym_infer] = "infer",
  [anon_sym_is] = "is",
  [anon_sym_keyof] = "keyof",
  [anon_sym_unique] = "unique symbol",
  [anon_sym_unknown] = "unknown",
  [anon_sym_never] = "never",
  [anon_sym_LBRACE_PIPE] = "{|",
  [anon_sym_PIPE_RBRACE] = "|}",
  [anon_sym_pragma] = "pragma",
  [aux_sym_ui_version_specifier_token1] = "number",
  [anon_sym_list] = "type_identifier",
  [anon_sym_final] = "final",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "string_fragment",
  [sym__ternary_qmark] = "\?",
  [sym_html_comment] = "html_comment",
  [sym_jsx_text] = "jsx_text",
  [sym__function_signature_automatic_semicolon] = "_function_signature_automatic_semicolon",
  [sym___error_recovery] = "__error_recovery",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_namespace_export] = "namespace_export",
  [sym_export_clause] = "export_clause",
  [sym_export_specifier] = "export_specifier",
  [sym__module_export_name] = "_module_export_name",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_import_specifier] = "import_specifier",
  [sym_import_attribute] = "import_attribute",
  [sym_statement] = "statement",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_nested_identifier] = "nested_identifier",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function_expression] = "function_expression",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym__call_signature] = "_call_signature",
  [sym__formal_parameter] = "_formal_parameter",
  [sym_optional_chain] = "optional_chain",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_formal_parameters] = "formal_parameters",
  [sym_class_static_block] = "class_static_block",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [sym_public_field_definition] = "public_field_definition",
  [sym__import_identifier] = "_import_identifier",
  [sym_non_null_expression] = "non_null_expression",
  [sym_method_signature] = "method_signature",
  [sym_abstract_method_signature] = "abstract_method_signature",
  [sym_function_signature] = "function_signature",
  [sym_decorator_parenthesized_expression] = "parenthesized_expression",
  [sym_type_assertion] = "type_assertion",
  [sym_as_expression] = "as_expression",
  [sym_satisfies_expression] = "satisfies_expression",
  [sym_instantiation_expression] = "instantiation_expression",
  [sym_import_require_clause] = "import_require_clause",
  [sym_extends_clause] = "extends_clause",
  [sym__extends_clause_single] = "_extends_clause_single",
  [sym_implements_clause] = "implements_clause",
  [sym_ambient_declaration] = "ambient_declaration",
  [sym_abstract_class_declaration] = "abstract_class_declaration",
  [sym_module] = "module",
  [sym_internal_module] = "internal_module",
  [sym__module] = "_module",
  [sym_import_alias] = "import_alias",
  [sym_nested_type_identifier] = "nested_type_identifier",
  [sym_interface_declaration] = "interface_declaration",
  [sym_extends_type_clause] = "extends_type_clause",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_enum_assignment] = "enum_assignment",
  [sym_type_alias_declaration] = "type_alias_declaration",
  [sym_accessibility_modifier] = "accessibility_modifier",
  [sym_override_modifier] = "override_modifier",
  [sym_required_parameter] = "required_parameter",
  [sym_optional_parameter] = "optional_parameter",
  [sym__parameter_name] = "_parameter_name",
  [sym_omitting_type_annotation] = "omitting_type_annotation",
  [sym_adding_type_annotation] = "adding_type_annotation",
  [sym_opting_type_annotation] = "opting_type_annotation",
  [sym_type_annotation] = "type_annotation",
  [sym__type_query_member_expression_in_type_annotation] = "member_expression",
  [sym__type_query_call_expression_in_type_annotation] = "call_expression",
  [sym_asserts] = "asserts",
  [sym_asserts_annotation] = "asserts_annotation",
  [sym_type] = "type",
  [sym_tuple_parameter] = "required_parameter",
  [sym_optional_tuple_parameter] = "optional_parameter",
  [sym_optional_type] = "optional_type",
  [sym_rest_type] = "rest_type",
  [sym__tuple_type_member] = "_tuple_type_member",
  [sym_constructor_type] = "constructor_type",
  [sym_primary_type] = "primary_type",
  [sym_template_type] = "template_type",
  [sym_template_literal_type] = "template_literal_type",
  [sym_infer_type] = "infer_type",
  [sym_conditional_type] = "conditional_type",
  [sym_generic_type] = "generic_type",
  [sym_type_predicate] = "type_predicate",
  [sym_type_predicate_annotation] = "type_predicate_annotation",
  [sym__type_query_member_expression] = "member_expression",
  [sym__type_query_subscript_expression] = "subscript_expression",
  [sym__type_query_call_expression] = "call_expression",
  [sym__type_query_instantiation_expression] = "instantiation_expression",
  [sym_type_query] = "type_query",
  [sym_index_type_query] = "index_type_query",
  [sym_lookup_type] = "lookup_type",
  [sym_mapped_type_clause] = "mapped_type_clause",
  [sym_literal_type] = "literal_type",
  [sym__number] = "unary_expression",
  [sym_existential_type] = "existential_type",
  [sym_flow_maybe_type] = "flow_maybe_type",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym_predefined_type] = "predefined_type",
  [sym_type_arguments] = "type_arguments",
  [sym_object_type] = "object_type",
  [sym_call_signature] = "call_signature",
  [sym_property_signature] = "property_signature",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_default_type] = "default_type",
  [sym_constraint] = "constraint",
  [sym_construct_signature] = "construct_signature",
  [sym_index_signature] = "index_signature",
  [sym_array_type] = "array_type",
  [sym_tuple_type] = "tuple_type",
  [sym_readonly_type] = "readonly_type",
  [sym_union_type] = "union_type",
  [sym_intersection_type] = "intersection_type",
  [sym_function_type] = "function_type",
  [sym_ui_pragma] = "ui_pragma",
  [sym_ui_import] = "ui_import",
  [sym_ui_version_specifier] = "ui_version_specifier",
  [sym_ui_object_definition] = "ui_object_definition",
  [sym_ui_annotated_object] = "ui_annotated_object",
  [sym_ui_annotation] = "ui_annotation",
  [sym_ui_object_initializer] = "ui_object_initializer",
  [sym_ui_annotated_object_member] = "ui_annotated_object_member",
  [sym_ui_object_definition_binding] = "ui_object_definition_binding",
  [sym_ui_binding] = "ui_binding",
  [sym_ui_property] = "ui_property",
  [sym_ui_list_property_type] = "ui_list_property_type",
  [sym_ui_property_modifier] = "ui_property_modifier",
  [sym_ui_object_array] = "ui_object_array",
  [sym_ui_required] = "ui_required",
  [sym_ui_signal] = "ui_signal",
  [sym_ui_signal_parameters] = "ui_signal_parameters",
  [sym_ui_signal_parameter] = "ui_signal_parameter",
  [sym_ui_inline_component] = "ui_inline_component",
  [sym__qml_enum_declaration] = "enum_declaration",
  [sym__qml_enum_body] = "enum_body",
  [sym__qml_enum_assignment] = "enum_assignment",
  [sym__qml_enum_negative_number] = "unary_expression",
  [sym_ui_nested_identifier] = "nested_identifier",
  [sym_ui_simple_nested_identifier] = "nested_identifier",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_statement_block_repeat1] = "statement_block_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_sequence_expression_repeat1] = "sequence_expression_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [aux_sym_extends_clause_repeat1] = "extends_clause_repeat1",
  [aux_sym_implements_clause_repeat1] = "implements_clause_repeat1",
  [aux_sym_extends_type_clause_repeat1] = "extends_type_clause_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_template_literal_type_repeat1] = "template_literal_type_repeat1",
  [aux_sym_object_type_repeat1] = "object_type_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_tuple_type_repeat1] = "tuple_type_repeat1",
  [aux_sym_ui_pragma_repeat1] = "ui_pragma_repeat1",
  [aux_sym_ui_annotated_object_repeat1] = "ui_annotated_object_repeat1",
  [aux_sym_ui_object_initializer_repeat1] = "ui_object_initializer_repeat1",
  [aux_sym_ui_property_repeat1] = "ui_property_repeat1",
  [aux_sym_ui_object_array_repeat1] = "ui_object_array_repeat1",
  [aux_sym_ui_signal_parameters_repeat1] = "ui_signal_parameters_repeat1",
  [aux_sym__qml_enum_body_repeat1] = "_qml_enum_body_repeat1",
  [alias_sym_interface_body] = "interface_body",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
  [alias_sym_this_type] = "this_type",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_QMARK_DOT] = anon_sym_QMARK_DOT,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_string_fragment] = sym__template_chars,
  [sym_unescaped_single_string_fragment] = sym__template_chars,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [anon_sym_meta] = anon_sym_meta,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_readonly] = anon_sym_readonly,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_declare] = anon_sym_declare,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_symbol] = anon_sym_symbol,
  [anon_sym_object] = anon_sym_object,
  [anon_sym_property] = anon_sym_property,
  [anon_sym_signal] = anon_sym_signal,
  [anon_sym_on] = anon_sym_on,
  [anon_sym_required] = anon_sym_required,
  [anon_sym_component] = anon_sym_component,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_accessor] = anon_sym_accessor,
  [anon_sym_satisfies] = anon_sym_satisfies,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_DASH_QMARK_COLON] = anon_sym_DASH_QMARK_COLON,
  [anon_sym_PLUS_QMARK_COLON] = anon_sym_PLUS_QMARK_COLON,
  [anon_sym_QMARK_COLON] = anon_sym_QMARK_COLON,
  [anon_sym_asserts] = anon_sym_asserts,
  [anon_sym_infer] = anon_sym_infer,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_keyof] = anon_sym_keyof,
  [anon_sym_unique] = anon_sym_unique,
  [anon_sym_unknown] = anon_sym_unknown,
  [anon_sym_never] = anon_sym_never,
  [anon_sym_LBRACE_PIPE] = anon_sym_LBRACE_PIPE,
  [anon_sym_PIPE_RBRACE] = anon_sym_PIPE_RBRACE,
  [anon_sym_pragma] = anon_sym_pragma,
  [aux_sym_ui_version_specifier_token1] = sym_number,
  [anon_sym_list] = anon_sym_list,
  [anon_sym_final] = anon_sym_final,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__ternary_qmark] = anon_sym_QMARK,
  [sym_html_comment] = sym_html_comment,
  [sym_jsx_text] = sym_jsx_text,
  [sym__function_signature_automatic_semicolon] = sym__function_signature_automatic_semicolon,
  [sym___error_recovery] = sym___error_recovery,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_namespace_export] = sym_namespace_export,
  [sym_export_clause] = sym_export_clause,
  [sym_export_specifier] = sym_export_specifier,
  [sym__module_export_name] = sym__module_export_name,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_import_specifier] = sym_import_specifier,
  [sym_import_attribute] = sym_import_attribute,
  [sym_statement] = sym_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function_expression] = sym_function_expression,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym__call_signature] = sym__call_signature,
  [sym__formal_parameter] = sym__formal_parameter,
  [sym_optional_chain] = sym_optional_chain,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_class_static_block] = sym_class_static_block,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [sym_public_field_definition] = sym_public_field_definition,
  [sym__import_identifier] = sym__import_identifier,
  [sym_non_null_expression] = sym_non_null_expression,
  [sym_method_signature] = sym_method_signature,
  [sym_abstract_method_signature] = sym_abstract_method_signature,
  [sym_function_signature] = sym_function_signature,
  [sym_decorator_parenthesized_expression] = sym_parenthesized_expression,
  [sym_type_assertion] = sym_type_assertion,
  [sym_as_expression] = sym_as_expression,
  [sym_satisfies_expression] = sym_satisfies_expression,
  [sym_instantiation_expression] = sym_instantiation_expression,
  [sym_import_require_clause] = sym_import_require_clause,
  [sym_extends_clause] = sym_extends_clause,
  [sym__extends_clause_single] = sym__extends_clause_single,
  [sym_implements_clause] = sym_implements_clause,
  [sym_ambient_declaration] = sym_ambient_declaration,
  [sym_abstract_class_declaration] = sym_abstract_class_declaration,
  [sym_module] = sym_module,
  [sym_internal_module] = sym_internal_module,
  [sym__module] = sym__module,
  [sym_import_alias] = sym_import_alias,
  [sym_nested_type_identifier] = sym_nested_type_identifier,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_extends_type_clause] = sym_extends_type_clause,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_assignment] = sym_enum_assignment,
  [sym_type_alias_declaration] = sym_type_alias_declaration,
  [sym_accessibility_modifier] = sym_accessibility_modifier,
  [sym_override_modifier] = sym_override_modifier,
  [sym_required_parameter] = sym_required_parameter,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym__parameter_name] = sym__parameter_name,
  [sym_omitting_type_annotation] = sym_omitting_type_annotation,
  [sym_adding_type_annotation] = sym_adding_type_annotation,
  [sym_opting_type_annotation] = sym_opting_type_annotation,
  [sym_type_annotation] = sym_type_annotation,
  [sym__type_query_member_expression_in_type_annotation] = sym_member_expression,
  [sym__type_query_call_expression_in_type_annotation] = sym_call_expression,
  [sym_asserts] = sym_asserts,
  [sym_asserts_annotation] = sym_asserts_annotation,
  [sym_type] = sym_type,
  [sym_tuple_parameter] = sym_required_parameter,
  [sym_optional_tuple_parameter] = sym_optional_parameter,
  [sym_optional_type] = sym_optional_type,
  [sym_rest_type] = sym_rest_type,
  [sym__tuple_type_member] = sym__tuple_type_member,
  [sym_constructor_type] = sym_constructor_type,
  [sym_primary_type] = sym_primary_type,
  [sym_template_type] = sym_template_type,
  [sym_template_literal_type] = sym_template_literal_type,
  [sym_infer_type] = sym_infer_type,
  [sym_conditional_type] = sym_conditional_type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_predicate] = sym_type_predicate,
  [sym_type_predicate_annotation] = sym_type_predicate_annotation,
  [sym__type_query_member_expression] = sym_member_expression,
  [sym__type_query_subscript_expression] = sym_subscript_expression,
  [sym__type_query_call_expression] = sym_call_expression,
  [sym__type_query_instantiation_expression] = sym_instantiation_expression,
  [sym_type_query] = sym_type_query,
  [sym_index_type_query] = sym_index_type_query,
  [sym_lookup_type] = sym_lookup_type,
  [sym_mapped_type_clause] = sym_mapped_type_clause,
  [sym_literal_type] = sym_literal_type,
  [sym__number] = sym_unary_expression,
  [sym_existential_type] = sym_existential_type,
  [sym_flow_maybe_type] = sym_flow_maybe_type,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym_predefined_type] = sym_predefined_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_object_type] = sym_object_type,
  [sym_call_signature] = sym_call_signature,
  [sym_property_signature] = sym_property_signature,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_default_type] = sym_default_type,
  [sym_constraint] = sym_constraint,
  [sym_construct_signature] = sym_construct_signature,
  [sym_index_signature] = sym_index_signature,
  [sym_array_type] = sym_array_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_readonly_type] = sym_readonly_type,
  [sym_union_type] = sym_union_type,
  [sym_intersection_type] = sym_intersection_type,
  [sym_function_type] = sym_function_type,
  [sym_ui_pragma] = sym_ui_pragma,
  [sym_ui_import] = sym_ui_import,
  [sym_ui_version_specifier] = sym_ui_version_specifier,
  [sym_ui_object_definition] = sym_ui_object_definition,
  [sym_ui_annotated_object] = sym_ui_annotated_object,
  [sym_ui_annotation] = sym_ui_annotation,
  [sym_ui_object_initializer] = sym_ui_object_initializer,
  [sym_ui_annotated_object_member] = sym_ui_annotated_object_member,
  [sym_ui_object_definition_binding] = sym_ui_object_definition_binding,
  [sym_ui_binding] = sym_ui_binding,
  [sym_ui_property] = sym_ui_property,
  [sym_ui_list_property_type] = sym_ui_list_property_type,
  [sym_ui_property_modifier] = sym_ui_property_modifier,
  [sym_ui_object_array] = sym_ui_object_array,
  [sym_ui_required] = sym_ui_required,
  [sym_ui_signal] = sym_ui_signal,
  [sym_ui_signal_parameters] = sym_ui_signal_parameters,
  [sym_ui_signal_parameter] = sym_ui_signal_parameter,
  [sym_ui_inline_component] = sym_ui_inline_component,
  [sym__qml_enum_declaration] = sym_enum_declaration,
  [sym__qml_enum_body] = sym_enum_body,
  [sym__qml_enum_assignment] = sym_enum_assignment,
  [sym__qml_enum_negative_number] = sym_unary_expression,
  [sym_ui_nested_identifier] = sym_nested_identifier,
  [sym_ui_simple_nested_identifier] = sym_nested_identifier,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_statement_block_repeat1] = aux_sym_statement_block_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_sequence_expression_repeat1] = aux_sym_sequence_expression_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [aux_sym_extends_clause_repeat1] = aux_sym_extends_clause_repeat1,
  [aux_sym_implements_clause_repeat1] = aux_sym_implements_clause_repeat1,
  [aux_sym_extends_type_clause_repeat1] = aux_sym_extends_type_clause_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_template_literal_type_repeat1] = aux_sym_template_literal_type_repeat1,
  [aux_sym_object_type_repeat1] = aux_sym_object_type_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_tuple_type_repeat1] = aux_sym_tuple_type_repeat1,
  [aux_sym_ui_pragma_repeat1] = aux_sym_ui_pragma_repeat1,
  [aux_sym_ui_annotated_object_repeat1] = aux_sym_ui_annotated_object_repeat1,
  [aux_sym_ui_object_initializer_repeat1] = aux_sym_ui_object_initializer_repeat1,
  [aux_sym_ui_property_repeat1] = aux_sym_ui_property_repeat1,
  [aux_sym_ui_object_array_repeat1] = aux_sym_ui_object_array_repeat1,
  [aux_sym_ui_signal_parameters_repeat1] = aux_sym_ui_signal_parameters_repeat1,
  [aux_sym__qml_enum_body_repeat1] = aux_sym__qml_enum_body_repeat1,
  [alias_sym_interface_body] = alias_sym_interface_body,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
  [alias_sym_this_type] = alias_sym_this_type,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_meta] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_symbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_object] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_property] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_on] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_required] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_component] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_accessor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_satisfies] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asserts] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_infer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keyof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unique] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unknown] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_never] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pragma] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_ui_version_specifier_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_list] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_final] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = true,
    .named = true,
  },
  [sym__ternary_qmark] = {
    .visible = true,
    .named = false,
  },
  [sym_html_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym__function_signature_automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym___error_recovery] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_export] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym__module_export_name] = {
    .visible = false,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_import_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym__call_signature] = {
    .visible = false,
    .named = true,
  },
  [sym__formal_parameter] = {
    .visible = false,
    .named = true,
  },
  [sym_optional_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_class_static_block] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [sym_public_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__import_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_non_null_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_method_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_assertion] = {
    .visible = true,
    .named = true,
  },
  [sym_as_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_satisfies_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_instantiation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_import_require_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__extends_clause_single] = {
    .visible = false,
    .named = true,
  },
  [sym_implements_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_ambient_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_abstract_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_internal_module] = {
    .visible = true,
    .named = true,
  },
  [sym__module] = {
    .visible = false,
    .named = true,
  },
  [sym_import_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_accessibility_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_override_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_required_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_name] = {
    .visible = false,
    .named = true,
  },
  [sym_omitting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_adding_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_opting_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_member_expression_in_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_call_expression_in_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts] = {
    .visible = true,
    .named = true,
  },
  [sym_asserts_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_tuple_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_type] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_type_member] = {
    .visible = false,
    .named = true,
  },
  [sym_constructor_type] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_template_type] = {
    .visible = true,
    .named = true,
  },
  [sym_template_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym_infer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_type_predicate_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type_query_instantiation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_index_type_query] = {
    .visible = true,
    .named = true,
  },
  [sym_lookup_type] = {
    .visible = true,
    .named = true,
  },
  [sym_mapped_type_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_type] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = true,
    .named = true,
  },
  [sym_existential_type] = {
    .visible = true,
    .named = true,
  },
  [sym_flow_maybe_type] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym_predefined_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_object_type] = {
    .visible = true,
    .named = true,
  },
  [sym_call_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_property_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_default_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_construct_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_index_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_readonly_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_pragma] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_import] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_version_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_object_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_annotated_object] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_object_initializer] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_annotated_object_member] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_object_definition_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_property] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_list_property_type] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_property_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_object_array] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_required] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_signal] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_signal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_signal_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_inline_component] = {
    .visible = true,
    .named = true,
  },
  [sym__qml_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__qml_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym__qml_enum_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym__qml_enum_negative_number] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_ui_simple_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_implements_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_type_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_literal_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_pragma_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_annotated_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_object_initializer_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_property_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_object_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_ui_signal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__qml_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_this_type] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_annotation = 3,
  field_argument = 4,
  field_arguments = 5,
  field_body = 6,
  field_component = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constraint = 10,
  field_constructor = 11,
  field_declaration = 12,
  field_decorator = 13,
  field_definition = 14,
  field_finalizer = 15,
  field_flags = 16,
  field_function = 17,
  field_handler = 18,
  field_increment = 19,
  field_index = 20,
  field_index_type = 21,
  field_initializer = 22,
  field_key = 23,
  field_kind = 24,
  field_label = 25,
  field_left = 26,
  field_major = 27,
  field_minor = 28,
  field_module = 29,
  field_name = 30,
  field_object = 31,
  field_operator = 32,
  field_optional_chain = 33,
  field_parameter = 34,
  field_parameters = 35,
  field_pattern = 36,
  field_property = 37,
  field_return_type = 38,
  field_right = 39,
  field_root = 40,
  field_sign = 41,
  field_source = 42,
  field_type = 43,
  field_type_arguments = 44,
  field_type_name = 45,
  field_type_parameters = 46,
  field_value = 47,
  field_version = 48,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_annotation] = "annotation",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_component] = "component",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constraint] = "constraint",
  [field_constructor] = "constructor",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_definition] = "definition",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_index_type] = "index_type",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_kind] = "kind",
  [field_label] = "label",
  [field_left] = "left",
  [field_major] = "major",
  [field_minor] = "minor",
  [field_module] = "module",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_optional_chain] = "optional_chain",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_root] = "root",
  [field_sign] = "sign",
  [field_source] = "source",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_name] = "type_name",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
  [field_version] = "version",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 3, .length = 2},
  [6] = {.index = 5, .length = 2},
  [7] = {.index = 7, .length = 2},
  [8] = {.index = 9, .length = 1},
  [9] = {.index = 10, .length = 2},
  [11] = {.index = 12, .length = 1},
  [12] = {.index = 13, .length = 1},
  [13] = {.index = 12, .length = 1},
  [14] = {.index = 14, .length = 2},
  [15] = {.index = 16, .length = 1},
  [16] = {.index = 17, .length = 1},
  [17] = {.index = 18, .length = 4},
  [18] = {.index = 22, .length = 2},
  [19] = {.index = 22, .length = 2},
  [20] = {.index = 24, .length = 2},
  [21] = {.index = 26, .length = 1},
  [22] = {.index = 27, .length = 1},
  [24] = {.index = 28, .length = 2},
  [25] = {.index = 30, .length = 2},
  [26] = {.index = 24, .length = 2},
  [27] = {.index = 16, .length = 1},
  [28] = {.index = 32, .length = 3},
  [29] = {.index = 35, .length = 2},
  [30] = {.index = 37, .length = 2},
  [31] = {.index = 35, .length = 2},
  [32] = {.index = 39, .length = 2},
  [33] = {.index = 41, .length = 2},
  [34] = {.index = 43, .length = 2},
  [35] = {.index = 45, .length = 1},
  [36] = {.index = 46, .length = 2},
  [37] = {.index = 48, .length = 1},
  [38] = {.index = 49, .length = 1},
  [40] = {.index = 17, .length = 1},
  [42] = {.index = 50, .length = 2},
  [43] = {.index = 52, .length = 2},
  [44] = {.index = 54, .length = 2},
  [45] = {.index = 56, .length = 2},
  [46] = {.index = 58, .length = 2},
  [47] = {.index = 60, .length = 1},
  [48] = {.index = 61, .length = 2},
  [49] = {.index = 63, .length = 2},
  [50] = {.index = 65, .length = 2},
  [51] = {.index = 67, .length = 3},
  [52] = {.index = 67, .length = 3},
  [55] = {.index = 70, .length = 1},
  [56] = {.index = 71, .length = 2},
  [57] = {.index = 73, .length = 3},
  [58] = {.index = 76, .length = 5},
  [59] = {.index = 67, .length = 3},
  [60] = {.index = 67, .length = 3},
  [61] = {.index = 81, .length = 2},
  [62] = {.index = 83, .length = 2},
  [63] = {.index = 85, .length = 2},
  [64] = {.index = 81, .length = 2},
  [65] = {.index = 83, .length = 2},
  [66] = {.index = 81, .length = 2},
  [67] = {.index = 81, .length = 2},
  [68] = {.index = 87, .length = 2},
  [69] = {.index = 89, .length = 2},
  [70] = {.index = 91, .length = 3},
  [71] = {.index = 91, .length = 3},
  [72] = {.index = 94, .length = 3},
  [73] = {.index = 97, .length = 2},
  [74] = {.index = 99, .length = 2},
  [75] = {.index = 101, .length = 2},
  [76] = {.index = 103, .length = 2},
  [78] = {.index = 105, .length = 1},
  [79] = {.index = 106, .length = 2},
  [80] = {.index = 108, .length = 2},
  [81] = {.index = 110, .length = 2},
  [82] = {.index = 112, .length = 1},
  [83] = {.index = 113, .length = 3},
  [84] = {.index = 116, .length = 3},
  [85] = {.index = 119, .length = 2},
  [86] = {.index = 121, .length = 2},
  [87] = {.index = 123, .length = 2},
  [88] = {.index = 125, .length = 2},
  [89] = {.index = 127, .length = 1},
  [90] = {.index = 128, .length = 2},
  [91] = {.index = 130, .length = 1},
  [92] = {.index = 131, .length = 2},
  [93] = {.index = 133, .length = 4},
  [94] = {.index = 137, .length = 2},
  [95] = {.index = 139, .length = 2},
  [96] = {.index = 141, .length = 3},
  [97] = {.index = 144, .length = 2},
  [98] = {.index = 146, .length = 2},
  [99] = {.index = 148, .length = 2},
  [100] = {.index = 150, .length = 2},
  [101] = {.index = 16, .length = 1},
  [102] = {.index = 152, .length = 2},
  [103] = {.index = 154, .length = 2},
  [104] = {.index = 156, .length = 2},
  [107] = {.index = 152, .length = 2},
  [108] = {.index = 158, .length = 4},
  [109] = {.index = 99, .length = 2},
  [110] = {.index = 101, .length = 2},
  [111] = {.index = 162, .length = 3},
  [112] = {.index = 83, .length = 2},
  [113] = {.index = 165, .length = 3},
  [114] = {.index = 165, .length = 3},
  [115] = {.index = 168, .length = 3},
  [116] = {.index = 171, .length = 2},
  [117] = {.index = 173, .length = 4},
  [118] = {.index = 177, .length = 3},
  [119] = {.index = 180, .length = 2},
  [120] = {.index = 99, .length = 2},
  [121] = {.index = 182, .length = 2},
  [122] = {.index = 184, .length = 5},
  [123] = {.index = 189, .length = 3},
  [124] = {.index = 189, .length = 3},
  [126] = {.index = 189, .length = 3},
  [127] = {.index = 189, .length = 3},
  [128] = {.index = 192, .length = 2},
  [129] = {.index = 192, .length = 2},
  [130] = {.index = 194, .length = 2},
  [131] = {.index = 196, .length = 2},
  [132] = {.index = 196, .length = 2},
  [133] = {.index = 196, .length = 2},
  [134] = {.index = 196, .length = 2},
  [135] = {.index = 198, .length = 1},
  [136] = {.index = 199, .length = 2},
  [137] = {.index = 201, .length = 1},
  [138] = {.index = 202, .length = 6},
  [139] = {.index = 208, .length = 2},
  [140] = {.index = 210, .length = 1},
  [141] = {.index = 125, .length = 2},
  [142] = {.index = 125, .length = 2},
  [143] = {.index = 211, .length = 5},
  [144] = {.index = 216, .length = 2},
  [145] = {.index = 218, .length = 3},
  [146] = {.index = 221, .length = 1},
  [147] = {.index = 222, .length = 1},
  [148] = {.index = 223, .length = 3},
  [149] = {.index = 226, .length = 3},
  [150] = {.index = 229, .length = 4},
  [151] = {.index = 233, .length = 2},
  [152] = {.index = 235, .length = 3},
  [153] = {.index = 238, .length = 4},
  [154] = {.index = 242, .length = 1},
  [155] = {.index = 243, .length = 2},
  [156] = {.index = 245, .length = 1},
  [157] = {.index = 246, .length = 2},
  [158] = {.index = 248, .length = 3},
  [159] = {.index = 251, .length = 2},
  [160] = {.index = 253, .length = 4},
  [161] = {.index = 257, .length = 2},
  [162] = {.index = 259, .length = 2},
  [163] = {.index = 261, .length = 4},
  [164] = {.index = 259, .length = 2},
  [165] = {.index = 265, .length = 4},
  [166] = {.index = 269, .length = 3},
  [167] = {.index = 272, .length = 2},
  [168] = {.index = 272, .length = 2},
  [169] = {.index = 274, .length = 2},
  [170] = {.index = 276, .length = 1},
  [171] = {.index = 277, .length = 2},
  [172] = {.index = 279, .length = 4},
  [173] = {.index = 283, .length = 4},
  [174] = {.index = 287, .length = 4},
  [175] = {.index = 291, .length = 2},
  [176] = {.index = 293, .length = 2},
  [177] = {.index = 295, .length = 3},
  [178] = {.index = 298, .length = 2},
  [179] = {.index = 300, .length = 4},
  [180] = {.index = 300, .length = 4},
  [181] = {.index = 304, .length = 4},
  [182] = {.index = 304, .length = 4},
  [183] = {.index = 308, .length = 2},
  [184] = {.index = 310, .length = 3},
  [185] = {.index = 313, .length = 3},
  [186] = {.index = 316, .length = 2},
  [187] = {.index = 318, .length = 3},
  [188] = {.index = 321, .length = 5},
  [189] = {.index = 326, .length = 4},
  [190] = {.index = 326, .length = 4},
  [191] = {.index = 326, .length = 4},
  [192] = {.index = 326, .length = 4},
  [193] = {.index = 71, .length = 2},
  [194] = {.index = 330, .length = 4},
  [195] = {.index = 334, .length = 2},
  [196] = {.index = 336, .length = 2},
  [197] = {.index = 338, .length = 3},
  [198] = {.index = 341, .length = 3},
  [199] = {.index = 341, .length = 3},
  [200] = {.index = 341, .length = 3},
  [201] = {.index = 341, .length = 3},
  [202] = {.index = 344, .length = 1},
  [203] = {.index = 345, .length = 1},
  [204] = {.index = 346, .length = 1},
  [205] = {.index = 347, .length = 2},
  [206] = {.index = 349, .length = 6},
  [207] = {.index = 355, .length = 2},
  [208] = {.index = 357, .length = 4},
  [209] = {.index = 347, .length = 2},
  [210] = {.index = 361, .length = 1},
  [211] = {.index = 361, .length = 1},
  [212] = {.index = 246, .length = 2},
  [213] = {.index = 248, .length = 3},
  [214] = {.index = 362, .length = 5},
  [215] = {.index = 367, .length = 2},
  [216] = {.index = 369, .length = 1},
  [217] = {.index = 370, .length = 4},
  [218] = {.index = 374, .length = 2},
  [219] = {.index = 376, .length = 1},
  [220] = {.index = 377, .length = 2},
  [221] = {.index = 379, .length = 2},
  [222] = {.index = 381, .length = 2},
  [223] = {.index = 383, .length = 4},
  [224] = {.index = 387, .length = 2},
  [225] = {.index = 389, .length = 3},
  [226] = {.index = 392, .length = 3},
  [227] = {.index = 395, .length = 3},
  [228] = {.index = 398, .length = 4},
  [229] = {.index = 402, .length = 4},
  [230] = {.index = 406, .length = 2},
  [231] = {.index = 408, .length = 2},
  [232] = {.index = 410, .length = 1},
  [233] = {.index = 411, .length = 4},
  [234] = {.index = 411, .length = 4},
  [235] = {.index = 415, .length = 3},
  [236] = {.index = 418, .length = 2},
  [237] = {.index = 420, .length = 3},
  [238] = {.index = 423, .length = 3},
  [239] = {.index = 426, .length = 3},
  [240] = {.index = 71, .length = 2},
  [241] = {.index = 429, .length = 3},
  [242] = {.index = 432, .length = 4},
  [243] = {.index = 436, .length = 3},
  [244] = {.index = 439, .length = 4},
  [245] = {.index = 439, .length = 4},
  [246] = {.index = 439, .length = 4},
  [247] = {.index = 439, .length = 4},
  [248] = {.index = 443, .length = 1},
  [249] = {.index = 444, .length = 2},
  [250] = {.index = 446, .length = 5},
  [251] = {.index = 39, .length = 2},
  [252] = {.index = 444, .length = 2},
  [253] = {.index = 451, .length = 4},
  [254] = {.index = 455, .length = 2},
  [255] = {.index = 457, .length = 3},
  [256] = {.index = 460, .length = 2},
  [257] = {.index = 460, .length = 2},
  [258] = {.index = 395, .length = 3},
  [259] = {.index = 462, .length = 2},
  [260] = {.index = 464, .length = 3},
  [261] = {.index = 467, .length = 2},
  [262] = {.index = 469, .length = 4},
  [263] = {.index = 71, .length = 2},
  [264] = {.index = 473, .length = 1},
  [265] = {.index = 474, .length = 2},
  [266] = {.index = 476, .length = 2},
  [267] = {.index = 478, .length = 2},
  [268] = {.index = 480, .length = 2},
  [269] = {.index = 482, .length = 3},
  [270] = {.index = 485, .length = 1},
  [271] = {.index = 486, .length = 3},
  [272] = {.index = 489, .length = 2},
  [273] = {.index = 491, .length = 3},
  [274] = {.index = 494, .length = 3},
  [275] = {.index = 497, .length = 3},
  [276] = {.index = 500, .length = 3},
  [277] = {.index = 503, .length = 4},
  [278] = {.index = 507, .length = 3},
  [279] = {.index = 510, .length = 2},
  [280] = {.index = 512, .length = 2},
  [281] = {.index = 514, .length = 4},
  [282] = {.index = 518, .length = 4},
  [283] = {.index = 522, .length = 4},
  [284] = {.index = 526, .length = 3},
  [285] = {.index = 529, .length = 2},
  [286] = {.index = 531, .length = 4},
  [287] = {.index = 535, .length = 2},
  [288] = {.index = 537, .length = 3},
  [289] = {.index = 535, .length = 2},
  [290] = {.index = 540, .length = 3},
  [291] = {.index = 540, .length = 3},
  [292] = {.index = 543, .length = 3},
  [293] = {.index = 546, .length = 5},
  [294] = {.index = 551, .length = 3},
  [295] = {.index = 554, .length = 2},
  [296] = {.index = 556, .length = 1},
  [297] = {.index = 557, .length = 3},
  [298] = {.index = 560, .length = 4},
  [299] = {.index = 564, .length = 2},
  [300] = {.index = 566, .length = 2},
  [301] = {.index = 568, .length = 4},
  [302] = {.index = 572, .length = 4},
  [303] = {.index = 576, .length = 2},
  [304] = {.index = 578, .length = 2},
  [305] = {.index = 580, .length = 3},
  [306] = {.index = 583, .length = 3},
  [307] = {.index = 586, .length = 2},
  [308] = {.index = 588, .length = 2},
  [309] = {.index = 590, .length = 1},
  [310] = {.index = 591, .length = 1},
  [311] = {.index = 592, .length = 3},
  [312] = {.index = 595, .length = 3},
  [313] = {.index = 598, .length = 3},
  [314] = {.index = 601, .length = 3},
  [315] = {.index = 604, .length = 4},
  [316] = {.index = 608, .length = 2},
  [317] = {.index = 610, .length = 4},
  [318] = {.index = 614, .length = 3},
  [319] = {.index = 617, .length = 2},
  [320] = {.index = 619, .length = 4},
  [321] = {.index = 623, .length = 4},
  [322] = {.index = 627, .length = 4},
  [323] = {.index = 631, .length = 3},
  [324] = {.index = 634, .length = 1},
  [325] = {.index = 635, .length = 4},
  [326] = {.index = 639, .length = 4},
  [327] = {.index = 643, .length = 4},
  [328] = {.index = 647, .length = 3},
  [329] = {.index = 650, .length = 5},
  [330] = {.index = 655, .length = 5},
  [332] = {.index = 660, .length = 4},
  [333] = {.index = 664, .length = 3},
  [334] = {.index = 667, .length = 3},
  [335] = {.index = 670, .length = 3},
  [336] = {.index = 667, .length = 3},
  [337] = {.index = 673, .length = 2},
  [338] = {.index = 675, .length = 4},
  [339] = {.index = 679, .length = 4},
  [340] = {.index = 683, .length = 3},
  [341] = {.index = 686, .length = 2},
  [342] = {.index = 688, .length = 2},
  [343] = {.index = 690, .length = 3},
  [344] = {.index = 693, .length = 2},
  [345] = {.index = 695, .length = 2},
  [346] = {.index = 697, .length = 1},
  [347] = {.index = 698, .length = 3},
  [348] = {.index = 701, .length = 3},
  [349] = {.index = 704, .length = 4},
  [350] = {.index = 708, .length = 4},
  [351] = {.index = 712, .length = 3},
  [352] = {.index = 715, .length = 3},
  [353] = {.index = 718, .length = 2},
  [354] = {.index = 720, .length = 4},
  [355] = {.index = 724, .length = 5},
  [356] = {.index = 729, .length = 4},
  [357] = {.index = 733, .length = 5},
  [358] = {.index = 738, .length = 4},
  [359] = {.index = 742, .length = 4},
  [360] = {.index = 746, .length = 5},
  [361] = {.index = 751, .length = 5},
  [362] = {.index = 756, .length = 4},
  [363] = {.index = 760, .length = 4},
  [364] = {.index = 764, .length = 3},
  [365] = {.index = 767, .length = 3},
  [366] = {.index = 767, .length = 3},
  [367] = {.index = 770, .length = 2},
  [368] = {.index = 772, .length = 2},
  [369] = {.index = 774, .length = 3},
  [370] = {.index = 777, .length = 2},
  [371] = {.index = 779, .length = 2},
  [372] = {.index = 781, .length = 4},
  [373] = {.index = 785, .length = 3},
  [374] = {.index = 788, .length = 3},
  [375] = {.index = 791, .length = 4},
  [376] = {.index = 795, .length = 3},
  [377] = {.index = 798, .length = 3},
  [378] = {.index = 801, .length = 2},
  [379] = {.index = 803, .length = 5},
  [380] = {.index = 808, .length = 5},
  [381] = {.index = 813, .length = 5},
  [382] = {.index = 818, .length = 4},
  [383] = {.index = 818, .length = 4},
  [384] = {.index = 822, .length = 4},
  [385] = {.index = 826, .length = 3},
  [386] = {.index = 829, .length = 2},
  [387] = {.index = 831, .length = 2},
  [388] = {.index = 833, .length = 3},
  [389] = {.index = 836, .length = 4},
  [390] = {.index = 840, .length = 4},
  [391] = {.index = 844, .length = 3},
  [392] = {.index = 847, .length = 3},
  [393] = {.index = 850, .length = 4},
  [394] = {.index = 854, .length = 3},
  [395] = {.index = 857, .length = 3},
  [396] = {.index = 860, .length = 5},
  [397] = {.index = 865, .length = 3},
  [398] = {.index = 868, .length = 4},
  [399] = {.index = 872, .length = 4},
  [400] = {.index = 876, .length = 3},
  [401] = {.index = 879, .length = 3},
  [402] = {.index = 882, .length = 4},
  [403] = {.index = 886, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_root, 0},
  [1] =
    {field_annotation, 0},
  [2] =
    {field_root, 1},
  [3] =
    {field_initializer, 1},
    {field_type_name, 0},
  [5] =
    {field_annotation, 0, .inherited = true},
    {field_definition, 1},
  [7] =
    {field_annotation, 0, .inherited = true},
    {field_annotation, 1, .inherited = true},
  [9] =
    {field_root, 2},
  [10] =
    {field_body, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [12] =
    {field_source, 1},
  [13] =
    {field_major, 0},
  [14] =
    {field_initializer, 2},
    {field_type_name, 1},
  [16] =
    {field_name, 1},
  [17] =
    {field_name, 0},
  [18] =
    {field_annotation, 0, .inherited = true},
    {field_body, 1, .inherited = true},
    {field_definition, 1},
    {field_name, 1, .inherited = true},
  [22] =
    {field_source, 1},
    {field_version, 2},
  [24] =
    {field_name, 0},
    {field_value, 2},
  [26] =
    {field_decorator, 0},
  [27] =
    {field_parameters, 0},
  [28] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [30] =
    {field_name, 0},
    {field_type, 1},
  [32] =
    {field_body, 2},
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [35] =
    {field_alias, 3},
    {field_source, 1},
  [37] =
    {field_major, 0},
    {field_minor, 2},
  [39] =
    {field_name, 1},
    {field_value, 3},
  [41] =
    {field_body, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [43] =
    {field_argument, 1},
    {field_operator, 0},
  [45] =
    {field_pattern, 0},
  [46] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
  [48] =
    {field_body, 1},
  [49] =
    {field_constructor, 1},
  [50] =
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [52] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
  [54] =
    {field_argument, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
  [56] =
    {field_arguments, 1},
    {field_function, 0},
  [58] =
    {field_argument, 0},
    {field_operator, 1},
  [60] =
    {field_type_arguments, 1},
  [61] =
    {field_parameters, 0},
    {field_return_type, 1},
  [63] =
    {field_parameters, 1},
    {field_type_parameters, 0},
  [65] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [67] =
    {field_initializer, 3},
    {field_name, 2},
    {field_type_name, 0},
  [70] =
    {field_value, 1},
  [71] =
    {field_name, 0},
    {field_type, 2},
  [73] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [76] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [81] =
    {field_name, 2},
    {field_type, 1},
  [83] =
    {field_object, 0},
    {field_property, 2},
  [85] =
    {field_module, 0},
    {field_name, 2},
  [87] =
    {field_name, 1},
    {field_parameters, 2},
  [89] =
    {field_component, 3},
    {field_name, 1},
  [91] =
    {field_alias, 4},
    {field_source, 1},
    {field_version, 2},
  [94] =
    {field_name, 1},
    {field_value, 3},
    {field_value, 4, .inherited = true},
  [97] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [99] =
    {field_left, 0},
    {field_right, 2},
  [101] =
    {field_body, 2},
    {field_parameter, 0},
  [103] =
    {field_body, 1},
    {field_name, 0},
  [105] =
    {field_declaration, 1},
  [106] =
    {field_body, 2},
    {field_object, 1},
  [108] =
    {field_condition, 1},
    {field_consequence, 2},
  [110] =
    {field_body, 2},
    {field_value, 1},
  [112] =
    {field_pattern, 1},
  [113] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [116] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
  [119] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 1},
  [121] =
    {field_body, 1},
    {field_handler, 2},
  [123] =
    {field_body, 1},
    {field_finalizer, 2},
  [125] =
    {field_body, 2},
    {field_name, 1},
  [127] =
    {field_value, 0},
  [128] =
    {field_type_arguments, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [130] =
    {field_body, 2},
  [131] =
    {field_body, 2},
    {field_type_parameters, 1},
  [133] =
    {field_body, 2},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [137] =
    {field_arguments, 2},
    {field_constructor, 1},
  [139] =
    {field_constructor, 1},
    {field_type_arguments, 2},
  [141] =
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [144] =
    {field_object, 1, .inherited = true},
    {field_property, 1, .inherited = true},
  [146] =
    {field_index, 1, .inherited = true},
    {field_object, 1, .inherited = true},
  [148] =
    {field_arguments, 1, .inherited = true},
    {field_function, 1, .inherited = true},
  [150] =
    {field_function, 1, .inherited = true},
    {field_type_arguments, 1, .inherited = true},
  [152] =
    {field_name, 0},
    {field_type_arguments, 1},
  [154] =
    {field_name, 0},
    {field_value, 1},
  [156] =
    {field_constraint, 1},
    {field_name, 0},
  [158] =
    {field_arguments, 1},
    {field_function, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [162] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [165] =
    {field_object, 0},
    {field_optional_chain, 1},
    {field_property, 2},
  [168] =
    {field_arguments, 2},
    {field_function, 0},
    {field_type_arguments, 1},
  [171] =
    {field_arguments, 2},
    {field_function, 0},
  [173] =
    {field_body, 2},
    {field_parameters, 0, .inherited = true},
    {field_return_type, 0, .inherited = true},
    {field_type_parameters, 0, .inherited = true},
  [177] =
    {field_parameters, 1},
    {field_return_type, 2},
    {field_type_parameters, 0},
  [180] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [182] =
    {field_key, 0},
    {field_value, 2},
  [184] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [189] =
    {field_name, 2},
    {field_type, 1},
    {field_value, 4},
  [192] =
    {field_name, 1},
    {field_type, 0},
  [194] =
    {field_name, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [196] =
    {field_name, 3},
    {field_type, 2},
  [198] =
    {field_declaration, 2},
  [199] =
    {field_body, 2},
    {field_label, 0},
  [201] =
    {field_kind, 0},
  [202] =
    {field_body, 2},
    {field_kind, 1, .inherited = true},
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [208] =
    {field_body, 2},
    {field_condition, 1},
  [210] =
    {field_label, 1},
  [211] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [216] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [218] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [221] =
    {field_type, 2},
  [222] =
    {field_pattern, 2},
  [223] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_value, 2, .inherited = true},
  [226] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
  [229] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 1},
    {field_value, 2, .inherited = true},
  [233] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 2},
  [235] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [238] =
    {field_name, 0},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [242] =
    {field_decorator, 0, .inherited = true},
  [243] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
  [245] =
    {field_decorator, 1, .inherited = true},
  [246] =
    {field_body, 3},
    {field_name, 1},
  [248] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [251] =
    {field_type_arguments, 1},
    {field_value, 0},
  [253] =
    {field_type_arguments, 1, .inherited = true},
    {field_type_arguments, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [257] =
    {field_body, 3},
    {field_type_parameters, 1},
  [259] =
    {field_body, 3},
    {field_parameter, 1},
  [261] =
    {field_body, 3},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [265] =
    {field_body, 3},
    {field_parameters, 1, .inherited = true},
    {field_return_type, 1, .inherited = true},
    {field_type_parameters, 1, .inherited = true},
  [269] =
    {field_arguments, 3},
    {field_constructor, 1},
    {field_type_arguments, 2},
  [272] =
    {field_left, 1},
    {field_right, 3},
  [274] =
    {field_flags, 3},
    {field_pattern, 1},
  [276] =
    {field_parameters, 1},
  [277] =
    {field_function, 0},
    {field_type_arguments, 1},
  [279] =
    {field_function, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_type_arguments, 1},
  [283] =
    {field_arguments, 1},
    {field_function, 0},
    {field_index, 0, .inherited = true},
    {field_object, 0, .inherited = true},
  [287] =
    {field_function, 0},
    {field_index, 0, .inherited = true},
    {field_object, 0, .inherited = true},
    {field_type_arguments, 1},
  [291] =
    {field_name, 1},
    {field_value, 2},
  [293] =
    {field_constraint, 2},
    {field_name, 1},
  [295] =
    {field_constraint, 1},
    {field_name, 0},
    {field_value, 2},
  [298] =
    {field_parameters, 0},
    {field_return_type, 2},
  [300] =
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_property, 2},
  [304] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_object, 0},
    {field_property, 2},
  [308] =
    {field_index, 2},
    {field_object, 0},
  [310] =
    {field_arguments, 3},
    {field_function, 0},
    {field_type_arguments, 2},
  [313] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [316] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [318] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [321] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [326] =
    {field_name, 2},
    {field_type, 1},
    {field_value, 4},
    {field_value, 5},
  [330] =
    {field_argument, 2, .inherited = true},
    {field_name, 0},
    {field_operator, 2, .inherited = true},
    {field_value, 2},
  [334] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [336] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [338] =
    {field_name, 1, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_value, 1, .inherited = true},
  [341] =
    {field_name, 3},
    {field_type, 2},
    {field_value, 5},
  [344] =
    {field_source, 2, .inherited = true},
  [345] =
    {field_value, 2},
  [346] =
    {field_source, 2},
  [347] =
    {field_body, 3},
    {field_name, 2},
  [349] =
    {field_body, 3},
    {field_kind, 2, .inherited = true},
    {field_left, 2, .inherited = true},
    {field_operator, 2, .inherited = true},
    {field_right, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [355] =
    {field_body, 1},
    {field_condition, 3},
  [357] =
    {field_name, 1},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [361] =
    {field_type, 1},
  [362] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [367] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [369] =
    {field_pattern, 3},
  [370] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 0, .inherited = true},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [374] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 3},
  [376] =
    {field_name, 2},
  [377] =
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [379] =
    {field_name, 1},
    {field_type, 2},
  [381] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [383] =
    {field_name, 0},
    {field_parameters, 2, .inherited = true},
    {field_return_type, 2, .inherited = true},
    {field_type_parameters, 2, .inherited = true},
  [387] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [389] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [392] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 2},
  [395] =
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [398] =
    {field_type_arguments, 0, .inherited = true},
    {field_type_arguments, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [402] =
    {field_body, 4},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [406] =
    {field_parameters, 1},
    {field_type, 2},
  [408] =
    {field_parameters, 2},
    {field_type_parameters, 1},
  [410] =
    {field_parameters, 2},
  [411] =
    {field_index, 0, .inherited = true},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 2},
  [415] =
    {field_constraint, 2},
    {field_name, 1},
    {field_value, 3},
  [418] =
    {field_parameters, 1},
    {field_type, 3},
  [420] =
    {field_parameters, 1},
    {field_return_type, 3},
    {field_type_parameters, 0},
  [423] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [426] =
    {field_index, 3},
    {field_object, 0},
    {field_optional_chain, 1},
  [429] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [432] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [436] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_type_parameters, 2},
  [439] =
    {field_name, 3},
    {field_type, 2},
    {field_value, 5},
    {field_value, 6},
  [443] =
    {field_source, 3, .inherited = true},
  [444] =
    {field_alias, 2},
    {field_name, 0},
  [446] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [451] =
    {field_name, 2},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [455] =
    {field_body, 4},
    {field_name, 2},
  [457] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
  [460] =
    {field_type, 1},
    {field_type, 2, .inherited = true},
  [462] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [464] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [467] =
    {field_decorator, 0, .inherited = true},
    {field_pattern, 4},
  [469] =
    {field_name, 1},
    {field_parameters, 3, .inherited = true},
    {field_return_type, 3, .inherited = true},
    {field_type_parameters, 3, .inherited = true},
  [473] =
    {field_type, 3},
  [474] =
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [476] =
    {field_name, 2},
    {field_type, 3},
  [478] =
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [480] =
    {field_name, 1},
    {field_type, 3},
  [482] =
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [485] =
    {field_name, 3},
  [486] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [489] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [491] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [494] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 3},
  [497] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_value, 3, .inherited = true},
  [500] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 3},
  [503] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 2},
    {field_value, 3, .inherited = true},
  [507] =
    {field_parameters, 2},
    {field_type, 3},
    {field_type_parameters, 1},
  [510] =
    {field_parameters, 2},
    {field_type, 3},
  [512] =
    {field_parameters, 3},
    {field_type_parameters, 2},
  [514] =
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [518] =
    {field_index, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [522] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 2},
    {field_object, 0},
  [526] =
    {field_parameters, 2},
    {field_type, 4},
    {field_type_parameters, 1},
  [529] =
    {field_parameters, 2},
    {field_type, 4},
  [531] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type_parameters, 3},
  [535] =
    {field_alias, 3},
    {field_name, 1},
  [537] =
    {field_name, 1},
    {field_type_parameters, 2},
    {field_value, 4},
  [540] =
    {field_left, 1},
    {field_operator, 2},
    {field_right, 3},
  [543] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [546] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [551] =
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
  [554] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [556] =
    {field_name, 2, .inherited = true},
  [557] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
  [560] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [564] =
    {field_body, 3},
    {field_value, 1},
  [566] =
    {field_body, 4},
    {field_parameter, 2},
  [568] =
    {field_name, 2},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [572] =
    {field_name, 3},
    {field_parameters, 4, .inherited = true},
    {field_return_type, 4, .inherited = true},
    {field_type_parameters, 4, .inherited = true},
  [576] =
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [578] =
    {field_name, 2},
    {field_type, 4},
  [580] =
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [583] =
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [586] =
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [588] =
    {field_name, 3},
    {field_type, 4},
  [590] =
    {field_type, 4},
  [591] =
    {field_name, 4},
  [592] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_value, 4, .inherited = true},
  [595] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 4},
  [598] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_value, 4, .inherited = true},
  [601] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 4},
  [604] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [608] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
  [610] =
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_type, 3},
    {field_value, 4, .inherited = true},
  [614] =
    {field_parameters, 3},
    {field_type, 4},
    {field_type_parameters, 2},
  [617] =
    {field_index, 3},
    {field_object, 0},
  [619] =
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
    {field_property, 0, .inherited = true},
  [623] =
    {field_index, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
    {field_object, 0, .inherited = true},
  [627] =
    {field_arguments, 0, .inherited = true},
    {field_function, 0, .inherited = true},
    {field_index, 3},
    {field_object, 0},
  [631] =
    {field_parameters, 3},
    {field_type, 5},
    {field_type_parameters, 2},
  [634] =
    {field_source, 4},
  [635] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 3},
    {field_right, 4},
  [639] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [643] =
    {field_body, 6},
    {field_condition, 3},
    {field_condition, 4},
    {field_initializer, 2},
  [647] =
    {field_body, 6},
    {field_condition, 4},
    {field_initializer, 2},
  [650] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [655] =
    {field_body, 6},
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [660] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type_parameters, 4},
  [664] =
    {field_body, 5},
    {field_parameter, 2},
    {field_type, 3},
  [667] =
    {field_index_type, 3},
    {field_name, 1},
    {field_type, 5},
  [670] =
    {field_alias, 4},
    {field_name, 0},
    {field_type, 2},
  [673] =
    {field_sign, 0},
    {field_type, 5},
  [675] =
    {field_name, 3},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [679] =
    {field_name, 4},
    {field_parameters, 5, .inherited = true},
    {field_return_type, 5, .inherited = true},
    {field_type_parameters, 5, .inherited = true},
  [683] =
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [686] =
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [688] =
    {field_name, 3},
    {field_type, 5},
  [690] =
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [693] =
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [695] =
    {field_name, 4},
    {field_type, 5},
  [697] =
    {field_name, 5},
  [698] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_value, 5, .inherited = true},
  [701] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 5},
  [704] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [708] =
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_type, 4},
    {field_value, 5, .inherited = true},
  [712] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_value, 5, .inherited = true},
  [715] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 5},
  [718] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
  [720] =
    {field_alternative, 6},
    {field_consequence, 4},
    {field_left, 0},
    {field_right, 2},
  [724] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
    {field_value, 3, .inherited = true},
  [729] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
  [733] =
    {field_body, 7},
    {field_condition, 3},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [738] =
    {field_body, 7},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [742] =
    {field_body, 7},
    {field_condition, 4},
    {field_condition, 5},
    {field_initializer, 2},
  [746] =
    {field_body, 7},
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [751] =
    {field_body, 7},
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [756] =
    {field_name, 4},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [760] =
    {field_name, 5},
    {field_parameters, 6, .inherited = true},
    {field_return_type, 6, .inherited = true},
    {field_type_parameters, 6, .inherited = true},
  [764] =
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [767] =
    {field_index_type, 4},
    {field_name, 2},
    {field_type, 6},
  [770] =
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [772] =
    {field_name, 4},
    {field_type, 6},
  [774] =
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [777] =
    {field_name, 5},
    {field_value, 6, .inherited = true},
  [779] =
    {field_name, 5},
    {field_type, 6},
  [781] =
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [785] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_value, 6, .inherited = true},
  [788] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 6},
  [791] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 5},
    {field_value, 6, .inherited = true},
  [795] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_value, 6, .inherited = true},
  [798] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 6},
  [801] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
  [803] =
    {field_body, 8},
    {field_condition, 4},
    {field_condition, 5},
    {field_increment, 6},
    {field_initializer, 2},
  [808] =
    {field_body, 8},
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [813] =
    {field_body, 8},
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [818] =
    {field_index_type, 5},
    {field_name, 3},
    {field_sign, 0},
    {field_type, 7},
  [822] =
    {field_name, 5},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [826] =
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [829] =
    {field_name, 5},
    {field_value, 7, .inherited = true},
  [831] =
    {field_name, 5},
    {field_type, 7},
  [833] =
    {field_name, 5},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [836] =
    {field_name, 6},
    {field_parameters, 7, .inherited = true},
    {field_return_type, 7, .inherited = true},
    {field_type_parameters, 7, .inherited = true},
  [840] =
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [844] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_value, 7, .inherited = true},
  [847] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 7},
  [850] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 6},
    {field_value, 7, .inherited = true},
  [854] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_value, 7, .inherited = true},
  [857] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 7},
  [860] =
    {field_body, 9},
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [865] =
    {field_name, 5},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [868] =
    {field_name, 6},
    {field_parameters, 8, .inherited = true},
    {field_return_type, 8, .inherited = true},
    {field_type_parameters, 8, .inherited = true},
  [872] =
    {field_decorator, 0, .inherited = true},
    {field_name, 5},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [876] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_value, 8, .inherited = true},
  [879] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 8},
  [882] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 7},
    {field_value, 8, .inherited = true},
  [886] =
    {field_decorator, 0, .inherited = true},
    {field_name, 6},
    {field_type, 8},
    {field_value, 9, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [4] = {
    [0] = sym_identifier,
  },
  [10] = {
    [0] = sym_identifier,
  },
  [11] = {
    [1] = sym_identifier,
  },
  [18] = {
    [1] = sym_identifier,
  },
  [20] = {
    [0] = sym_identifier,
  },
  [23] = {
    [0] = alias_sym_property_identifier,
  },
  [27] = {
    [1] = sym_identifier,
  },
  [29] = {
    [1] = sym_identifier,
  },
  [39] = {
    [0] = anon_sym_list,
  },
  [40] = {
    [0] = anon_sym_list,
  },
  [41] = {
    [0] = alias_sym_this_type,
  },
  [51] = {
    [0] = sym_identifier,
    [2] = sym_identifier,
  },
  [52] = {
    [0] = sym_identifier,
  },
  [53] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [54] = {
    [1] = sym_identifier,
  },
  [59] = {
    [2] = sym_identifier,
  },
  [61] = {
    [1] = anon_sym_list,
    [2] = sym_identifier,
  },
  [62] = {
    [2] = alias_sym_property_identifier,
  },
  [63] = {
    [2] = anon_sym_list,
  },
  [64] = {
    [1] = anon_sym_list,
  },
  [65] = {
    [0] = sym_member_expression,
    [2] = alias_sym_property_identifier,
  },
  [66] = {
    [2] = sym_identifier,
  },
  [70] = {
    [1] = sym_identifier,
  },
  [74] = {
    [0] = sym_identifier,
  },
  [75] = {
    [0] = sym_identifier,
  },
  [77] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [88] = {
    [1] = anon_sym_list,
  },
  [101] = {
    [1] = anon_sym_list,
  },
  [102] = {
    [0] = anon_sym_list,
  },
  [103] = {
    [0] = anon_sym_list,
  },
  [104] = {
    [0] = anon_sym_list,
  },
  [105] = {
    [1] = anon_sym_list,
  },
  [106] = {
    [1] = anon_sym_unique,
  },
  [113] = {
    [2] = alias_sym_property_identifier,
  },
  [120] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [123] = {
    [1] = anon_sym_list,
    [2] = sym_identifier,
  },
  [124] = {
    [1] = anon_sym_list,
  },
  [125] = {
    [2] = anon_sym_list,
  },
  [126] = {
    [2] = sym_identifier,
  },
  [128] = {
    [0] = anon_sym_list,
  },
  [131] = {
    [2] = anon_sym_list,
    [3] = sym_identifier,
  },
  [132] = {
    [2] = anon_sym_list,
  },
  [133] = {
    [3] = sym_identifier,
  },
  [136] = {
    [0] = alias_sym_statement_identifier,
  },
  [140] = {
    [1] = alias_sym_statement_identifier,
  },
  [141] = {
    [1] = anon_sym_list,
    [2] = alias_sym_interface_body,
  },
  [157] = {
    [1] = anon_sym_list,
  },
  [158] = {
    [1] = anon_sym_list,
  },
  [162] = {
    [1] = sym_identifier,
  },
  [167] = {
    [1] = sym_identifier,
  },
  [175] = {
    [1] = anon_sym_list,
  },
  [176] = {
    [1] = anon_sym_list,
  },
  [177] = {
    [0] = anon_sym_list,
  },
  [179] = {
    [2] = alias_sym_property_identifier,
  },
  [181] = {
    [2] = alias_sym_property_identifier,
  },
  [185] = {
    [2] = anon_sym_list,
  },
  [189] = {
    [1] = anon_sym_list,
    [2] = sym_identifier,
  },
  [190] = {
    [1] = anon_sym_list,
  },
  [191] = {
    [2] = sym_identifier,
  },
  [193] = {
    [2] = anon_sym_list,
  },
  [198] = {
    [2] = anon_sym_list,
    [3] = sym_identifier,
  },
  [199] = {
    [2] = anon_sym_list,
  },
  [200] = {
    [3] = sym_identifier,
  },
  [209] = {
    [2] = anon_sym_list,
  },
  [210] = {
    [1] = anon_sym_list,
  },
  [212] = {
    [1] = anon_sym_list,
    [3] = alias_sym_interface_body,
  },
  [213] = {
    [1] = anon_sym_list,
    [3] = alias_sym_interface_body,
  },
  [227] = {
    [1] = anon_sym_list,
  },
  [233] = {
    [2] = alias_sym_property_identifier,
  },
  [235] = {
    [1] = anon_sym_list,
  },
  [240] = {
    [0] = sym_identifier,
  },
  [241] = {
    [2] = anon_sym_list,
  },
  [242] = {
    [2] = anon_sym_list,
  },
  [244] = {
    [2] = anon_sym_list,
    [3] = sym_identifier,
  },
  [245] = {
    [2] = anon_sym_list,
  },
  [246] = {
    [3] = sym_identifier,
  },
  [251] = {
    [1] = anon_sym_list,
  },
  [252] = {
    [0] = sym_identifier,
  },
  [254] = {
    [2] = anon_sym_list,
  },
  [255] = {
    [2] = anon_sym_list,
  },
  [256] = {
    [1] = anon_sym_list,
  },
  [258] = {
    [1] = anon_sym_list,
    [4] = alias_sym_interface_body,
  },
  [260] = {
    [3] = anon_sym_list,
  },
  [263] = {
    [0] = anon_sym_list,
  },
  [286] = {
    [2] = anon_sym_list,
  },
  [288] = {
    [1] = anon_sym_list,
  },
  [289] = {
    [1] = sym_identifier,
  },
  [290] = {
    [1] = sym_identifier,
  },
  [294] = {
    [2] = anon_sym_list,
  },
  [297] = {
    [3] = anon_sym_list,
  },
  [298] = {
    [3] = anon_sym_list,
  },
  [331] = {
    [3] = alias_sym_property_identifier,
  },
  [332] = {
    [3] = anon_sym_list,
  },
  [334] = {
    [1] = sym_identifier,
  },
  [335] = {
    [0] = anon_sym_list,
  },
  [365] = {
    [2] = sym_identifier,
  },
  [382] = {
    [3] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_nested_identifier, 2,
    sym_nested_identifier,
    sym_member_expression,
  sym_predefined_type, 2,
    sym_predefined_type,
    sym_identifier,
  sym_object_type, 2,
    sym_object_type,
    alias_sym_interface_body,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 4,
  [6] = 4,
  [7] = 4,
  [8] = 4,
  [9] = 4,
  [10] = 4,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 17,
  [19] = 16,
  [20] = 17,
  [21] = 17,
  [22] = 16,
  [23] = 16,
  [24] = 17,
  [25] = 17,
  [26] = 16,
  [27] = 16,
  [28] = 17,
  [29] = 16,
  [30] = 16,
  [31] = 17,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 32,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 35,
  [48] = 33,
  [49] = 34,
  [50] = 50,
  [51] = 36,
  [52] = 37,
  [53] = 38,
  [54] = 41,
  [55] = 55,
  [56] = 43,
  [57] = 44,
  [58] = 45,
  [59] = 46,
  [60] = 35,
  [61] = 33,
  [62] = 34,
  [63] = 50,
  [64] = 36,
  [65] = 37,
  [66] = 38,
  [67] = 41,
  [68] = 32,
  [69] = 39,
  [70] = 40,
  [71] = 43,
  [72] = 72,
  [73] = 72,
  [74] = 39,
  [75] = 72,
  [76] = 72,
  [77] = 40,
  [78] = 44,
  [79] = 45,
  [80] = 72,
  [81] = 72,
  [82] = 46,
  [83] = 72,
  [84] = 55,
  [85] = 72,
  [86] = 72,
  [87] = 72,
  [88] = 50,
  [89] = 89,
  [90] = 89,
  [91] = 89,
  [92] = 89,
  [93] = 93,
  [94] = 94,
  [95] = 94,
  [96] = 93,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 94,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 104,
  [108] = 108,
  [109] = 109,
  [110] = 109,
  [111] = 106,
  [112] = 109,
  [113] = 109,
  [114] = 109,
  [115] = 106,
  [116] = 116,
  [117] = 117,
  [118] = 106,
  [119] = 116,
  [120] = 117,
  [121] = 105,
  [122] = 117,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 105,
  [127] = 106,
  [128] = 108,
  [129] = 106,
  [130] = 130,
  [131] = 116,
  [132] = 106,
  [133] = 133,
  [134] = 104,
  [135] = 135,
  [136] = 105,
  [137] = 116,
  [138] = 106,
  [139] = 105,
  [140] = 106,
  [141] = 106,
  [142] = 106,
  [143] = 105,
  [144] = 105,
  [145] = 106,
  [146] = 106,
  [147] = 123,
  [148] = 124,
  [149] = 106,
  [150] = 150,
  [151] = 105,
  [152] = 150,
  [153] = 153,
  [154] = 133,
  [155] = 150,
  [156] = 105,
  [157] = 150,
  [158] = 150,
  [159] = 150,
  [160] = 150,
  [161] = 106,
  [162] = 150,
  [163] = 106,
  [164] = 150,
  [165] = 106,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 169,
  [171] = 169,
  [172] = 169,
  [173] = 169,
  [174] = 169,
  [175] = 169,
  [176] = 169,
  [177] = 169,
  [178] = 178,
  [179] = 178,
  [180] = 178,
  [181] = 178,
  [182] = 178,
  [183] = 178,
  [184] = 178,
  [185] = 178,
  [186] = 178,
  [187] = 187,
  [188] = 187,
  [189] = 189,
  [190] = 187,
  [191] = 189,
  [192] = 189,
  [193] = 187,
  [194] = 189,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 204,
  [207] = 204,
  [208] = 208,
  [209] = 209,
  [210] = 209,
  [211] = 209,
  [212] = 204,
  [213] = 204,
  [214] = 214,
  [215] = 215,
  [216] = 214,
  [217] = 204,
  [218] = 215,
  [219] = 208,
  [220] = 204,
  [221] = 204,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 224,
  [226] = 222,
  [227] = 223,
  [228] = 222,
  [229] = 224,
  [230] = 223,
  [231] = 204,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 233,
  [239] = 233,
  [240] = 233,
  [241] = 241,
  [242] = 242,
  [243] = 233,
  [244] = 233,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 232,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 272,
  [274] = 274,
  [275] = 275,
  [276] = 232,
  [277] = 277,
  [278] = 278,
  [279] = 274,
  [280] = 278,
  [281] = 274,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 284,
  [286] = 283,
  [287] = 287,
  [288] = 287,
  [289] = 287,
  [290] = 287,
  [291] = 291,
  [292] = 287,
  [293] = 287,
  [294] = 232,
  [295] = 232,
  [296] = 232,
  [297] = 232,
  [298] = 287,
  [299] = 287,
  [300] = 300,
  [301] = 232,
  [302] = 232,
  [303] = 232,
  [304] = 304,
  [305] = 305,
  [306] = 305,
  [307] = 305,
  [308] = 305,
  [309] = 305,
  [310] = 305,
  [311] = 305,
  [312] = 312,
  [313] = 305,
  [314] = 314,
  [315] = 305,
  [316] = 305,
  [317] = 305,
  [318] = 305,
  [319] = 305,
  [320] = 320,
  [321] = 305,
  [322] = 322,
  [323] = 323,
  [324] = 322,
  [325] = 323,
  [326] = 322,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 329,
  [332] = 332,
  [333] = 323,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 337,
  [339] = 339,
  [340] = 339,
  [341] = 336,
  [342] = 335,
  [343] = 337,
  [344] = 335,
  [345] = 336,
  [346] = 346,
  [347] = 339,
  [348] = 346,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 350,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 350,
  [365] = 350,
  [366] = 363,
  [367] = 367,
  [368] = 359,
  [369] = 360,
  [370] = 361,
  [371] = 371,
  [372] = 363,
  [373] = 373,
  [374] = 367,
  [375] = 350,
  [376] = 363,
  [377] = 367,
  [378] = 359,
  [379] = 360,
  [380] = 361,
  [381] = 359,
  [382] = 360,
  [383] = 361,
  [384] = 384,
  [385] = 367,
  [386] = 386,
  [387] = 387,
  [388] = 350,
  [389] = 389,
  [390] = 390,
  [391] = 363,
  [392] = 363,
  [393] = 373,
  [394] = 367,
  [395] = 359,
  [396] = 360,
  [397] = 361,
  [398] = 371,
  [399] = 367,
  [400] = 350,
  [401] = 363,
  [402] = 367,
  [403] = 359,
  [404] = 360,
  [405] = 361,
  [406] = 390,
  [407] = 407,
  [408] = 359,
  [409] = 360,
  [410] = 350,
  [411] = 363,
  [412] = 367,
  [413] = 359,
  [414] = 360,
  [415] = 361,
  [416] = 361,
  [417] = 417,
  [418] = 390,
  [419] = 350,
  [420] = 363,
  [421] = 367,
  [422] = 359,
  [423] = 360,
  [424] = 361,
  [425] = 351,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 426,
  [433] = 433,
  [434] = 434,
  [435] = 426,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 437,
  [446] = 438,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 427,
  [456] = 429,
  [457] = 430,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 442,
  [462] = 443,
  [463] = 444,
  [464] = 437,
  [465] = 447,
  [466] = 448,
  [467] = 449,
  [468] = 450,
  [469] = 452,
  [470] = 453,
  [471] = 454,
  [472] = 427,
  [473] = 431,
  [474] = 429,
  [475] = 430,
  [476] = 459,
  [477] = 431,
  [478] = 440,
  [479] = 441,
  [480] = 441,
  [481] = 433,
  [482] = 434,
  [483] = 447,
  [484] = 439,
  [485] = 448,
  [486] = 440,
  [487] = 441,
  [488] = 449,
  [489] = 489,
  [490] = 451,
  [491] = 458,
  [492] = 433,
  [493] = 440,
  [494] = 441,
  [495] = 434,
  [496] = 450,
  [497] = 452,
  [498] = 451,
  [499] = 453,
  [500] = 454,
  [501] = 501,
  [502] = 451,
  [503] = 427,
  [504] = 429,
  [505] = 505,
  [506] = 430,
  [507] = 439,
  [508] = 431,
  [509] = 451,
  [510] = 510,
  [511] = 459,
  [512] = 451,
  [513] = 513,
  [514] = 451,
  [515] = 515,
  [516] = 442,
  [517] = 517,
  [518] = 459,
  [519] = 460,
  [520] = 442,
  [521] = 443,
  [522] = 433,
  [523] = 442,
  [524] = 434,
  [525] = 443,
  [526] = 451,
  [527] = 444,
  [528] = 437,
  [529] = 447,
  [530] = 448,
  [531] = 449,
  [532] = 450,
  [533] = 452,
  [534] = 453,
  [535] = 454,
  [536] = 427,
  [537] = 429,
  [538] = 430,
  [539] = 431,
  [540] = 540,
  [541] = 433,
  [542] = 434,
  [543] = 444,
  [544] = 437,
  [545] = 447,
  [546] = 501,
  [547] = 448,
  [548] = 449,
  [549] = 439,
  [550] = 450,
  [551] = 452,
  [552] = 453,
  [553] = 454,
  [554] = 427,
  [555] = 451,
  [556] = 556,
  [557] = 429,
  [558] = 430,
  [559] = 454,
  [560] = 431,
  [561] = 458,
  [562] = 459,
  [563] = 460,
  [564] = 564,
  [565] = 442,
  [566] = 443,
  [567] = 451,
  [568] = 444,
  [569] = 437,
  [570] = 447,
  [571] = 448,
  [572] = 449,
  [573] = 450,
  [574] = 452,
  [575] = 453,
  [576] = 454,
  [577] = 427,
  [578] = 429,
  [579] = 430,
  [580] = 458,
  [581] = 431,
  [582] = 459,
  [583] = 444,
  [584] = 433,
  [585] = 434,
  [586] = 439,
  [587] = 440,
  [588] = 441,
  [589] = 440,
  [590] = 439,
  [591] = 451,
  [592] = 517,
  [593] = 540,
  [594] = 426,
  [595] = 460,
  [596] = 460,
  [597] = 458,
  [598] = 459,
  [599] = 460,
  [600] = 459,
  [601] = 442,
  [602] = 443,
  [603] = 540,
  [604] = 444,
  [605] = 437,
  [606] = 447,
  [607] = 448,
  [608] = 449,
  [609] = 450,
  [610] = 452,
  [611] = 453,
  [612] = 454,
  [613] = 427,
  [614] = 429,
  [615] = 430,
  [616] = 460,
  [617] = 431,
  [618] = 442,
  [619] = 443,
  [620] = 433,
  [621] = 434,
  [622] = 433,
  [623] = 439,
  [624] = 440,
  [625] = 441,
  [626] = 434,
  [627] = 451,
  [628] = 517,
  [629] = 426,
  [630] = 451,
  [631] = 517,
  [632] = 426,
  [633] = 444,
  [634] = 517,
  [635] = 426,
  [636] = 517,
  [637] = 426,
  [638] = 440,
  [639] = 441,
  [640] = 640,
  [641] = 437,
  [642] = 458,
  [643] = 505,
  [644] = 644,
  [645] = 517,
  [646] = 439,
  [647] = 647,
  [648] = 540,
  [649] = 458,
  [650] = 458,
  [651] = 459,
  [652] = 460,
  [653] = 447,
  [654] = 442,
  [655] = 443,
  [656] = 448,
  [657] = 444,
  [658] = 437,
  [659] = 447,
  [660] = 448,
  [661] = 449,
  [662] = 450,
  [663] = 452,
  [664] = 453,
  [665] = 454,
  [666] = 427,
  [667] = 429,
  [668] = 430,
  [669] = 449,
  [670] = 431,
  [671] = 450,
  [672] = 452,
  [673] = 453,
  [674] = 433,
  [675] = 434,
  [676] = 439,
  [677] = 440,
  [678] = 441,
  [679] = 460,
  [680] = 451,
  [681] = 517,
  [682] = 426,
  [683] = 683,
  [684] = 684,
  [685] = 458,
  [686] = 517,
  [687] = 443,
  [688] = 688,
  [689] = 688,
  [690] = 688,
  [691] = 688,
  [692] = 692,
  [693] = 692,
  [694] = 692,
  [695] = 692,
  [696] = 696,
  [697] = 696,
  [698] = 698,
  [699] = 698,
  [700] = 696,
  [701] = 696,
  [702] = 698,
  [703] = 698,
  [704] = 704,
  [705] = 704,
  [706] = 704,
  [707] = 704,
  [708] = 708,
  [709] = 709,
  [710] = 710,
  [711] = 709,
  [712] = 710,
  [713] = 710,
  [714] = 714,
  [715] = 710,
  [716] = 716,
  [717] = 717,
  [718] = 709,
  [719] = 719,
  [720] = 709,
  [721] = 248,
  [722] = 249,
  [723] = 723,
  [724] = 723,
  [725] = 723,
  [726] = 723,
  [727] = 727,
  [728] = 728,
  [729] = 727,
  [730] = 730,
  [731] = 727,
  [732] = 732,
  [733] = 728,
  [734] = 730,
  [735] = 735,
  [736] = 735,
  [737] = 737,
  [738] = 728,
  [739] = 728,
  [740] = 737,
  [741] = 741,
  [742] = 732,
  [743] = 737,
  [744] = 744,
  [745] = 728,
  [746] = 728,
  [747] = 747,
  [748] = 728,
  [749] = 728,
  [750] = 747,
  [751] = 747,
  [752] = 728,
  [753] = 753,
  [754] = 728,
  [755] = 755,
  [756] = 756,
  [757] = 756,
  [758] = 756,
  [759] = 759,
  [760] = 756,
  [761] = 730,
  [762] = 762,
  [763] = 763,
  [764] = 763,
  [765] = 728,
  [766] = 763,
  [767] = 728,
  [768] = 728,
  [769] = 763,
  [770] = 728,
  [771] = 771,
  [772] = 771,
  [773] = 250,
  [774] = 268,
  [775] = 271,
  [776] = 728,
  [777] = 771,
  [778] = 728,
  [779] = 771,
  [780] = 771,
  [781] = 771,
  [782] = 771,
  [783] = 247,
  [784] = 759,
  [785] = 771,
  [786] = 728,
  [787] = 771,
  [788] = 235,
  [789] = 234,
  [790] = 251,
  [791] = 252,
  [792] = 792,
  [793] = 793,
  [794] = 247,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 270,
  [799] = 245,
  [800] = 800,
  [801] = 801,
  [802] = 802,
  [803] = 242,
  [804] = 804,
  [805] = 805,
  [806] = 250,
  [807] = 251,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 252,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 264,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 265,
  [857] = 857,
  [858] = 858,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 863,
  [864] = 864,
  [865] = 865,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 908,
  [909] = 268,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 271,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 919,
  [920] = 920,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 804,
  [947] = 947,
  [948] = 948,
  [949] = 949,
  [950] = 802,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 957,
  [959] = 957,
  [960] = 957,
  [961] = 957,
  [962] = 962,
  [963] = 962,
  [964] = 964,
  [965] = 964,
  [966] = 962,
  [967] = 962,
  [968] = 964,
  [969] = 962,
  [970] = 964,
  [971] = 964,
  [972] = 242,
  [973] = 234,
  [974] = 974,
  [975] = 235,
  [976] = 241,
  [977] = 258,
  [978] = 262,
  [979] = 247,
  [980] = 267,
  [981] = 250,
  [982] = 266,
  [983] = 270,
  [984] = 245,
  [985] = 271,
  [986] = 248,
  [987] = 249,
  [988] = 251,
  [989] = 252,
  [990] = 263,
  [991] = 253,
  [992] = 254,
  [993] = 255,
  [994] = 256,
  [995] = 259,
  [996] = 260,
  [997] = 261,
  [998] = 268,
  [999] = 999,
  [1000] = 999,
  [1001] = 999,
  [1002] = 257,
  [1003] = 999,
  [1004] = 265,
  [1005] = 999,
  [1006] = 999,
  [1007] = 999,
  [1008] = 999,
  [1009] = 999,
  [1010] = 999,
  [1011] = 999,
  [1012] = 264,
  [1013] = 999,
  [1014] = 999,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 1018,
  [1019] = 1018,
  [1020] = 1020,
  [1021] = 1020,
  [1022] = 1018,
  [1023] = 1020,
  [1024] = 1024,
  [1025] = 1018,
  [1026] = 1024,
  [1027] = 1020,
  [1028] = 1018,
  [1029] = 1020,
  [1030] = 1018,
  [1031] = 1018,
  [1032] = 1020,
  [1033] = 1020,
  [1034] = 1024,
  [1035] = 1035,
  [1036] = 1036,
  [1037] = 1035,
  [1038] = 1036,
  [1039] = 1039,
  [1040] = 1039,
  [1041] = 1036,
  [1042] = 1042,
  [1043] = 1036,
  [1044] = 1039,
  [1045] = 1035,
  [1046] = 1039,
  [1047] = 1035,
  [1048] = 1036,
  [1049] = 1042,
  [1050] = 1035,
  [1051] = 1039,
  [1052] = 1035,
  [1053] = 1053,
  [1054] = 1036,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1057,
  [1059] = 1059,
  [1060] = 1059,
  [1061] = 1061,
  [1062] = 1061,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 1061,
  [1070] = 1070,
  [1071] = 1065,
  [1072] = 1066,
  [1073] = 1073,
  [1074] = 1065,
  [1075] = 1066,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1065,
  [1079] = 1066,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1077,
  [1083] = 1083,
  [1084] = 1083,
  [1085] = 1085,
  [1086] = 1081,
  [1087] = 1056,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1085,
  [1091] = 1057,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1070,
  [1096] = 1059,
  [1097] = 1088,
  [1098] = 1061,
  [1099] = 1065,
  [1100] = 1066,
  [1101] = 1076,
  [1102] = 1068,
  [1103] = 1089,
  [1104] = 1065,
  [1105] = 1066,
  [1106] = 1083,
  [1107] = 1085,
  [1108] = 1088,
  [1109] = 1089,
  [1110] = 1110,
  [1111] = 1092,
  [1112] = 1093,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1094,
  [1116] = 1070,
  [1117] = 1092,
  [1118] = 1093,
  [1119] = 1080,
  [1120] = 1094,
  [1121] = 1114,
  [1122] = 1070,
  [1123] = 1056,
  [1124] = 1057,
  [1125] = 1083,
  [1126] = 1085,
  [1127] = 1127,
  [1128] = 1081,
  [1129] = 1088,
  [1130] = 1089,
  [1131] = 1059,
  [1132] = 1083,
  [1133] = 1080,
  [1134] = 1092,
  [1135] = 1093,
  [1136] = 1056,
  [1137] = 1070,
  [1138] = 1068,
  [1139] = 1110,
  [1140] = 1092,
  [1141] = 1055,
  [1142] = 1114,
  [1143] = 1070,
  [1144] = 1144,
  [1145] = 1145,
  [1146] = 1146,
  [1147] = 1057,
  [1148] = 1093,
  [1149] = 1149,
  [1150] = 1080,
  [1151] = 1081,
  [1152] = 1056,
  [1153] = 1057,
  [1154] = 1059,
  [1155] = 1059,
  [1156] = 1085,
  [1157] = 1157,
  [1158] = 1158,
  [1159] = 1055,
  [1160] = 1160,
  [1161] = 1083,
  [1162] = 1085,
  [1163] = 1055,
  [1164] = 1055,
  [1165] = 1165,
  [1166] = 1088,
  [1167] = 1080,
  [1168] = 1081,
  [1169] = 1056,
  [1170] = 1057,
  [1171] = 1059,
  [1172] = 1089,
  [1173] = 1094,
  [1174] = 1055,
  [1175] = 1065,
  [1176] = 1066,
  [1177] = 1088,
  [1178] = 1110,
  [1179] = 1089,
  [1180] = 1180,
  [1181] = 1127,
  [1182] = 1083,
  [1183] = 1085,
  [1184] = 1088,
  [1185] = 1089,
  [1186] = 1080,
  [1187] = 1061,
  [1188] = 1061,
  [1189] = 1092,
  [1190] = 1092,
  [1191] = 1093,
  [1192] = 1093,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1081,
  [1196] = 1094,
  [1197] = 1056,
  [1198] = 1198,
  [1199] = 1080,
  [1200] = 1081,
  [1201] = 1070,
  [1202] = 1094,
  [1203] = 1146,
  [1204] = 1055,
  [1205] = 1146,
  [1206] = 1146,
  [1207] = 1146,
  [1208] = 1146,
  [1209] = 1146,
  [1210] = 1094,
  [1211] = 1211,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1212,
  [1215] = 1212,
  [1216] = 1213,
  [1217] = 1211,
  [1218] = 1211,
  [1219] = 1212,
  [1220] = 1213,
  [1221] = 1213,
  [1222] = 1211,
  [1223] = 1223,
  [1224] = 1224,
  [1225] = 1225,
  [1226] = 1226,
  [1227] = 1227,
  [1228] = 1228,
  [1229] = 1226,
  [1230] = 1230,
  [1231] = 1230,
  [1232] = 1232,
  [1233] = 1233,
  [1234] = 1234,
  [1235] = 1235,
  [1236] = 1236,
  [1237] = 1237,
  [1238] = 1237,
  [1239] = 1239,
  [1240] = 1240,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 1240,
  [1244] = 1241,
  [1245] = 1245,
  [1246] = 1240,
  [1247] = 1224,
  [1248] = 1230,
  [1249] = 1249,
  [1250] = 1230,
  [1251] = 1242,
  [1252] = 1241,
  [1253] = 1242,
  [1254] = 1254,
  [1255] = 1230,
  [1256] = 1230,
  [1257] = 1257,
  [1258] = 1258,
  [1259] = 1259,
  [1260] = 1260,
  [1261] = 1261,
  [1262] = 1259,
  [1263] = 1230,
  [1264] = 1259,
  [1265] = 1265,
  [1266] = 1259,
  [1267] = 1267,
  [1268] = 1268,
  [1269] = 1259,
  [1270] = 1267,
  [1271] = 1271,
  [1272] = 1259,
  [1273] = 1267,
  [1274] = 1274,
  [1275] = 1275,
  [1276] = 1276,
  [1277] = 1267,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1230,
  [1281] = 1259,
  [1282] = 1282,
  [1283] = 1230,
  [1284] = 1284,
  [1285] = 1230,
  [1286] = 1230,
  [1287] = 804,
  [1288] = 1288,
  [1289] = 1271,
  [1290] = 1288,
  [1291] = 1291,
  [1292] = 1292,
  [1293] = 1230,
  [1294] = 1294,
  [1295] = 1288,
  [1296] = 802,
  [1297] = 1297,
  [1298] = 1294,
  [1299] = 1284,
  [1300] = 1300,
  [1301] = 1294,
  [1302] = 1226,
  [1303] = 1300,
  [1304] = 1300,
  [1305] = 1284,
  [1306] = 1288,
  [1307] = 1294,
  [1308] = 1300,
  [1309] = 1309,
  [1310] = 1310,
  [1311] = 1271,
  [1312] = 1312,
  [1313] = 1313,
  [1314] = 1230,
  [1315] = 1230,
  [1316] = 1265,
  [1317] = 1271,
  [1318] = 1310,
  [1319] = 1312,
  [1320] = 1312,
  [1321] = 1230,
  [1322] = 1313,
  [1323] = 1323,
  [1324] = 1312,
  [1325] = 1230,
  [1326] = 1313,
  [1327] = 1310,
  [1328] = 1310,
  [1329] = 1310,
  [1330] = 1330,
  [1331] = 1331,
  [1332] = 1313,
  [1333] = 1312,
  [1334] = 1230,
  [1335] = 1271,
  [1336] = 1310,
  [1337] = 1313,
  [1338] = 1312,
  [1339] = 1313,
  [1340] = 1310,
  [1341] = 1313,
  [1342] = 1312,
  [1343] = 1230,
  [1344] = 1344,
  [1345] = 1345,
  [1346] = 1346,
  [1347] = 1344,
  [1348] = 1330,
  [1349] = 1349,
  [1350] = 1344,
  [1351] = 1351,
  [1352] = 1346,
  [1353] = 1353,
  [1354] = 1354,
  [1355] = 1271,
  [1356] = 1309,
  [1357] = 1357,
  [1358] = 1309,
  [1359] = 1230,
  [1360] = 1344,
  [1361] = 1351,
  [1362] = 1271,
  [1363] = 1344,
  [1364] = 1344,
  [1365] = 1344,
  [1366] = 1344,
  [1367] = 1344,
  [1368] = 1368,
  [1369] = 1330,
  [1370] = 1271,
  [1371] = 1357,
  [1372] = 1368,
  [1373] = 1373,
  [1374] = 1374,
  [1375] = 1375,
  [1376] = 1376,
  [1377] = 1373,
  [1378] = 1331,
  [1379] = 1271,
  [1380] = 1278,
  [1381] = 1274,
  [1382] = 1271,
  [1383] = 1331,
  [1384] = 1373,
  [1385] = 1385,
  [1386] = 1278,
  [1387] = 1385,
  [1388] = 1385,
  [1389] = 1309,
  [1390] = 1274,
  [1391] = 1349,
  [1392] = 1374,
  [1393] = 1271,
  [1394] = 1376,
  [1395] = 1375,
  [1396] = 1385,
  [1397] = 1385,
  [1398] = 1385,
  [1399] = 1385,
  [1400] = 1309,
  [1401] = 1349,
  [1402] = 1402,
  [1403] = 1271,
  [1404] = 1404,
  [1405] = 1292,
  [1406] = 1404,
  [1407] = 1407,
  [1408] = 1408,
  [1409] = 1346,
  [1410] = 1271,
  [1411] = 1357,
  [1412] = 1408,
  [1413] = 1309,
  [1414] = 1357,
  [1415] = 1346,
  [1416] = 1416,
  [1417] = 1417,
  [1418] = 1417,
  [1419] = 1416,
  [1420] = 1420,
  [1421] = 1276,
  [1422] = 1279,
  [1423] = 802,
  [1424] = 1420,
  [1425] = 1260,
  [1426] = 1354,
  [1427] = 1357,
  [1428] = 1428,
  [1429] = 1331,
  [1430] = 1416,
  [1431] = 1431,
  [1432] = 1420,
  [1433] = 1309,
  [1434] = 1434,
  [1435] = 1349,
  [1436] = 1258,
  [1437] = 1434,
  [1438] = 1309,
  [1439] = 1420,
  [1440] = 1357,
  [1441] = 1271,
  [1442] = 1408,
  [1443] = 1346,
  [1444] = 1444,
  [1445] = 1420,
  [1446] = 1416,
  [1447] = 1309,
  [1448] = 1420,
  [1449] = 1278,
  [1450] = 1274,
  [1451] = 1292,
  [1452] = 1261,
  [1453] = 1416,
  [1454] = 1268,
  [1455] = 1420,
  [1456] = 1416,
  [1457] = 804,
  [1458] = 1416,
  [1459] = 1282,
  [1460] = 1434,
  [1461] = 1331,
  [1462] = 1420,
  [1463] = 1416,
  [1464] = 1346,
  [1465] = 1465,
  [1466] = 1466,
  [1467] = 1467,
  [1468] = 1274,
  [1469] = 1467,
  [1470] = 1292,
  [1471] = 1467,
  [1472] = 1331,
  [1473] = 1278,
  [1474] = 1407,
  [1475] = 1331,
  [1476] = 1292,
  [1477] = 1357,
  [1478] = 1274,
  [1479] = 1331,
  [1480] = 1357,
  [1481] = 1309,
  [1482] = 1482,
  [1483] = 1483,
  [1484] = 1346,
  [1485] = 1467,
  [1486] = 1346,
  [1487] = 1487,
  [1488] = 1467,
  [1489] = 1353,
  [1490] = 1487,
  [1491] = 1467,
  [1492] = 1278,
  [1493] = 1487,
  [1494] = 1331,
  [1495] = 1346,
  [1496] = 1357,
  [1497] = 1357,
  [1498] = 1498,
  [1499] = 1346,
  [1500] = 1351,
  [1501] = 1292,
  [1502] = 1331,
  [1503] = 1278,
  [1504] = 1504,
  [1505] = 1368,
  [1506] = 1506,
  [1507] = 1507,
  [1508] = 1508,
  [1509] = 1274,
  [1510] = 1346,
  [1511] = 1346,
  [1512] = 1292,
  [1513] = 1513,
  [1514] = 1514,
  [1515] = 250,
  [1516] = 1357,
  [1517] = 1357,
  [1518] = 1357,
  [1519] = 1482,
  [1520] = 1376,
  [1521] = 1514,
  [1522] = 1357,
  [1523] = 1465,
  [1524] = 1357,
  [1525] = 247,
  [1526] = 1526,
  [1527] = 1346,
  [1528] = 1528,
  [1529] = 1346,
  [1530] = 1526,
  [1531] = 1357,
  [1532] = 1346,
  [1533] = 1346,
  [1534] = 1534,
  [1535] = 251,
  [1536] = 1534,
  [1537] = 1537,
  [1538] = 247,
  [1539] = 252,
  [1540] = 1537,
  [1541] = 1346,
  [1542] = 1537,
  [1543] = 1537,
  [1544] = 1534,
  [1545] = 1534,
  [1546] = 250,
  [1547] = 1537,
  [1548] = 1357,
  [1549] = 1537,
  [1550] = 1537,
  [1551] = 1292,
  [1552] = 1534,
  [1553] = 1292,
  [1554] = 1506,
  [1555] = 1534,
  [1556] = 1292,
  [1557] = 1534,
  [1558] = 1534,
  [1559] = 1537,
  [1560] = 251,
  [1561] = 1537,
  [1562] = 1534,
  [1563] = 252,
  [1564] = 1564,
  [1565] = 1565,
  [1566] = 1565,
  [1567] = 1565,
  [1568] = 1564,
  [1569] = 1564,
  [1570] = 1564,
  [1571] = 1565,
  [1572] = 1564,
  [1573] = 1564,
  [1574] = 1565,
  [1575] = 1564,
  [1576] = 1564,
  [1577] = 1565,
  [1578] = 1564,
  [1579] = 1579,
  [1580] = 1579,
  [1581] = 1581,
  [1582] = 1582,
  [1583] = 1583,
  [1584] = 1582,
  [1585] = 1582,
  [1586] = 1582,
  [1587] = 1579,
  [1588] = 1579,
  [1589] = 1579,
  [1590] = 1582,
  [1591] = 1579,
  [1592] = 1592,
  [1593] = 1582,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 1595,
  [1597] = 1597,
  [1598] = 1597,
  [1599] = 1599,
  [1600] = 1597,
  [1601] = 1595,
  [1602] = 1602,
  [1603] = 1603,
  [1604] = 1597,
  [1605] = 1595,
  [1606] = 1595,
  [1607] = 1597,
  [1608] = 1597,
  [1609] = 1595,
  [1610] = 1610,
  [1611] = 1610,
  [1612] = 1612,
  [1613] = 1613,
  [1614] = 1614,
  [1615] = 1615,
  [1616] = 1610,
  [1617] = 1610,
  [1618] = 1610,
  [1619] = 1619,
  [1620] = 1620,
  [1621] = 1610,
  [1622] = 1622,
  [1623] = 1623,
  [1624] = 1624,
  [1625] = 1625,
  [1626] = 1626,
  [1627] = 1627,
  [1628] = 1628,
  [1629] = 1629,
  [1630] = 1630,
  [1631] = 1614,
  [1632] = 1632,
  [1633] = 1633,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1636,
  [1637] = 1637,
  [1638] = 1638,
  [1639] = 1639,
  [1640] = 1640,
  [1641] = 1641,
  [1642] = 1642,
  [1643] = 1633,
  [1644] = 1635,
  [1645] = 1636,
  [1646] = 1642,
  [1647] = 1633,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1635,
  [1651] = 1636,
  [1652] = 248,
  [1653] = 249,
  [1654] = 1642,
  [1655] = 1633,
  [1656] = 1635,
  [1657] = 1636,
  [1658] = 1658,
  [1659] = 1642,
  [1660] = 1660,
  [1661] = 1633,
  [1662] = 1635,
  [1663] = 1636,
  [1664] = 1664,
  [1665] = 1642,
  [1666] = 1633,
  [1667] = 1667,
  [1668] = 1668,
  [1669] = 1669,
  [1670] = 1670,
  [1671] = 1671,
  [1672] = 1672,
  [1673] = 1673,
  [1674] = 1674,
  [1675] = 1675,
  [1676] = 1676,
  [1677] = 1672,
  [1678] = 1678,
  [1679] = 1679,
  [1680] = 1648,
  [1681] = 1681,
  [1682] = 1682,
  [1683] = 1634,
  [1684] = 1684,
  [1685] = 1635,
  [1686] = 1636,
  [1687] = 1687,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1682,
  [1692] = 1692,
  [1693] = 1693,
  [1694] = 1694,
  [1695] = 1695,
  [1696] = 1696,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1699,
  [1700] = 1642,
  [1701] = 1701,
  [1702] = 1702,
  [1703] = 1703,
  [1704] = 1704,
  [1705] = 1702,
  [1706] = 1702,
  [1707] = 1707,
  [1708] = 1708,
  [1709] = 1709,
  [1710] = 1710,
  [1711] = 1711,
  [1712] = 1712,
  [1713] = 1713,
  [1714] = 1711,
  [1715] = 1715,
  [1716] = 1716,
  [1717] = 1717,
  [1718] = 1718,
  [1719] = 1719,
  [1720] = 1720,
  [1721] = 1716,
  [1722] = 1722,
  [1723] = 1723,
  [1724] = 1724,
  [1725] = 1725,
  [1726] = 1726,
  [1727] = 1254,
  [1728] = 1728,
  [1729] = 1729,
  [1730] = 1730,
  [1731] = 1731,
  [1732] = 1732,
  [1733] = 1702,
  [1734] = 1734,
  [1735] = 248,
  [1736] = 1239,
  [1737] = 249,
  [1738] = 241,
  [1739] = 1702,
  [1740] = 1740,
  [1741] = 1741,
  [1742] = 1742,
  [1743] = 1249,
  [1744] = 1744,
  [1745] = 1703,
  [1746] = 1746,
  [1747] = 1747,
  [1748] = 1718,
  [1749] = 1749,
  [1750] = 1702,
  [1751] = 1751,
  [1752] = 1752,
  [1753] = 1015,
  [1754] = 234,
  [1755] = 1755,
  [1756] = 1756,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1759,
  [1760] = 1016,
  [1761] = 1761,
  [1762] = 1762,
  [1763] = 1763,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1017,
  [1767] = 235,
  [1768] = 234,
  [1769] = 242,
  [1770] = 242,
  [1771] = 1771,
  [1772] = 1772,
  [1773] = 1773,
  [1774] = 1774,
  [1775] = 1775,
  [1776] = 1776,
  [1777] = 1777,
  [1778] = 1778,
  [1779] = 1779,
  [1780] = 1780,
  [1781] = 714,
  [1782] = 1782,
  [1783] = 1783,
  [1784] = 1784,
  [1785] = 1785,
  [1786] = 1786,
  [1787] = 1787,
  [1788] = 1788,
  [1789] = 1789,
  [1790] = 1790,
  [1791] = 1791,
  [1792] = 1792,
  [1793] = 1793,
  [1794] = 1794,
  [1795] = 1795,
  [1796] = 1796,
  [1797] = 1797,
  [1798] = 1798,
  [1799] = 1799,
  [1800] = 716,
  [1801] = 1801,
  [1802] = 1802,
  [1803] = 1803,
  [1804] = 1804,
  [1805] = 1805,
  [1806] = 1806,
  [1807] = 1807,
  [1808] = 1808,
  [1809] = 1809,
  [1810] = 1810,
  [1811] = 1811,
  [1812] = 1812,
  [1813] = 1813,
  [1814] = 1814,
  [1815] = 1815,
  [1816] = 1816,
  [1817] = 1817,
  [1818] = 1818,
  [1819] = 1819,
  [1820] = 1820,
  [1821] = 1821,
  [1822] = 1822,
  [1823] = 1823,
  [1824] = 1824,
  [1825] = 717,
  [1826] = 1826,
  [1827] = 1827,
  [1828] = 1828,
  [1829] = 1829,
  [1830] = 1830,
  [1831] = 1831,
  [1832] = 1832,
  [1833] = 1833,
  [1834] = 1834,
  [1835] = 1835,
  [1836] = 1836,
  [1837] = 1837,
  [1838] = 1838,
  [1839] = 1839,
  [1840] = 1840,
  [1841] = 1841,
  [1842] = 1842,
  [1843] = 1843,
  [1844] = 1844,
  [1845] = 1845,
  [1846] = 1846,
  [1847] = 1847,
  [1848] = 719,
  [1849] = 1849,
  [1850] = 1850,
  [1851] = 1851,
  [1852] = 1852,
  [1853] = 1853,
  [1854] = 1854,
  [1855] = 1855,
  [1856] = 1856,
  [1857] = 1857,
  [1858] = 1858,
  [1859] = 1859,
  [1860] = 1860,
  [1861] = 1861,
  [1862] = 708,
  [1863] = 1863,
  [1864] = 1864,
  [1865] = 1865,
  [1866] = 1866,
  [1867] = 1867,
  [1868] = 1868,
  [1869] = 1869,
  [1870] = 1870,
  [1871] = 1871,
  [1872] = 1872,
  [1873] = 1873,
  [1874] = 1874,
  [1875] = 1875,
  [1876] = 1876,
  [1877] = 1877,
  [1878] = 1878,
  [1879] = 1879,
  [1880] = 1880,
  [1881] = 1881,
  [1882] = 1882,
  [1883] = 1883,
  [1884] = 1884,
  [1885] = 1885,
  [1886] = 1886,
  [1887] = 247,
  [1888] = 250,
  [1889] = 235,
  [1890] = 1890,
  [1891] = 1891,
  [1892] = 1635,
  [1893] = 1893,
  [1894] = 1635,
  [1895] = 1636,
  [1896] = 1896,
  [1897] = 1897,
  [1898] = 1898,
  [1899] = 1899,
  [1900] = 1635,
  [1901] = 1636,
  [1902] = 1635,
  [1903] = 1903,
  [1904] = 1904,
  [1905] = 264,
  [1906] = 1906,
  [1907] = 1907,
  [1908] = 1635,
  [1909] = 1636,
  [1910] = 1910,
  [1911] = 1911,
  [1912] = 1912,
  [1913] = 1913,
  [1914] = 1780,
  [1915] = 1915,
  [1916] = 1916,
  [1917] = 1917,
  [1918] = 1918,
  [1919] = 1919,
  [1920] = 1920,
  [1921] = 1921,
  [1922] = 1922,
  [1923] = 1923,
  [1924] = 1924,
  [1925] = 1925,
  [1926] = 1636,
  [1927] = 1927,
  [1928] = 1928,
  [1929] = 1929,
  [1930] = 1635,
  [1931] = 1636,
  [1932] = 1932,
  [1933] = 1933,
  [1934] = 1934,
  [1935] = 1935,
  [1936] = 1936,
  [1937] = 1937,
  [1938] = 1938,
  [1939] = 1939,
  [1940] = 1940,
  [1941] = 1941,
  [1942] = 1942,
  [1943] = 1943,
  [1944] = 1944,
  [1945] = 1945,
  [1946] = 1946,
  [1947] = 1947,
  [1948] = 1948,
  [1949] = 1949,
  [1950] = 1950,
  [1951] = 1951,
  [1952] = 1952,
  [1953] = 1636,
  [1954] = 1954,
  [1955] = 1955,
  [1956] = 1956,
  [1957] = 1957,
  [1958] = 1958,
  [1959] = 1959,
  [1960] = 1960,
  [1961] = 1961,
  [1962] = 1962,
  [1963] = 265,
  [1964] = 1964,
  [1965] = 1965,
  [1966] = 251,
  [1967] = 1751,
  [1968] = 252,
  [1969] = 1969,
  [1970] = 1970,
  [1971] = 1971,
  [1972] = 1972,
  [1973] = 1973,
  [1974] = 1974,
  [1975] = 1975,
  [1976] = 268,
  [1977] = 1977,
  [1978] = 1978,
  [1979] = 1979,
  [1980] = 1980,
  [1981] = 1981,
  [1982] = 1982,
  [1983] = 1983,
  [1984] = 1984,
  [1985] = 1985,
  [1986] = 1986,
  [1987] = 1987,
  [1988] = 270,
  [1989] = 245,
  [1990] = 1990,
  [1991] = 1991,
  [1992] = 1992,
  [1993] = 1993,
  [1994] = 1994,
  [1995] = 1995,
  [1996] = 1996,
  [1997] = 1997,
  [1998] = 1998,
  [1999] = 270,
  [2000] = 245,
  [2001] = 2001,
  [2002] = 2002,
  [2003] = 2003,
  [2004] = 2004,
  [2005] = 2005,
  [2006] = 2006,
  [2007] = 2007,
  [2008] = 271,
  [2009] = 2009,
  [2010] = 2010,
  [2011] = 2011,
  [2012] = 2012,
  [2013] = 2013,
  [2014] = 2014,
  [2015] = 2015,
  [2016] = 2016,
  [2017] = 2017,
  [2018] = 2018,
  [2019] = 2019,
  [2020] = 1624,
  [2021] = 2021,
  [2022] = 2022,
  [2023] = 2023,
  [2024] = 1223,
  [2025] = 2025,
  [2026] = 252,
  [2027] = 2027,
  [2028] = 265,
  [2029] = 2029,
  [2030] = 2030,
  [2031] = 2031,
  [2032] = 2032,
  [2033] = 2033,
  [2034] = 2034,
  [2035] = 2035,
  [2036] = 2036,
  [2037] = 2037,
  [2038] = 2038,
  [2039] = 251,
  [2040] = 247,
  [2041] = 2041,
  [2042] = 2042,
  [2043] = 250,
  [2044] = 2044,
  [2045] = 2045,
  [2046] = 2046,
  [2047] = 2047,
  [2048] = 2048,
  [2049] = 2049,
  [2050] = 2050,
  [2051] = 2051,
  [2052] = 1674,
  [2053] = 1675,
  [2054] = 2054,
  [2055] = 1676,
  [2056] = 2056,
  [2057] = 2057,
  [2058] = 2058,
  [2059] = 2059,
  [2060] = 268,
  [2061] = 2061,
  [2062] = 2062,
  [2063] = 2063,
  [2064] = 271,
  [2065] = 2065,
  [2066] = 2066,
  [2067] = 2067,
  [2068] = 1960,
  [2069] = 1964,
  [2070] = 2070,
  [2071] = 2071,
  [2072] = 2072,
  [2073] = 2073,
  [2074] = 2074,
  [2075] = 1678,
  [2076] = 2076,
  [2077] = 2077,
  [2078] = 2078,
  [2079] = 2079,
  [2080] = 2080,
  [2081] = 264,
  [2082] = 2082,
  [2083] = 2083,
  [2084] = 1965,
  [2085] = 2085,
  [2086] = 1958,
  [2087] = 1249,
  [2088] = 1995,
  [2089] = 2089,
  [2090] = 1744,
  [2091] = 1747,
  [2092] = 1933,
  [2093] = 1995,
  [2094] = 1965,
  [2095] = 1755,
  [2096] = 2096,
  [2097] = 1922,
  [2098] = 1934,
  [2099] = 1707,
  [2100] = 1932,
  [2101] = 1933,
  [2102] = 1934,
  [2103] = 1935,
  [2104] = 1936,
  [2105] = 1937,
  [2106] = 1938,
  [2107] = 1939,
  [2108] = 1940,
  [2109] = 1942,
  [2110] = 1943,
  [2111] = 1945,
  [2112] = 1918,
  [2113] = 1742,
  [2114] = 1959,
  [2115] = 1969,
  [2116] = 1970,
  [2117] = 1712,
  [2118] = 1713,
  [2119] = 1239,
  [2120] = 2120,
  [2121] = 2121,
  [2122] = 2122,
  [2123] = 1971,
  [2124] = 1972,
  [2125] = 1982,
  [2126] = 1983,
  [2127] = 1985,
  [2128] = 1919,
  [2129] = 2129,
  [2130] = 1722,
  [2131] = 1935,
  [2132] = 1947,
  [2133] = 1936,
  [2134] = 1937,
  [2135] = 1938,
  [2136] = 1939,
  [2137] = 1940,
  [2138] = 1919,
  [2139] = 2139,
  [2140] = 1942,
  [2141] = 1943,
  [2142] = 2142,
  [2143] = 1945,
  [2144] = 1946,
  [2145] = 1807,
  [2146] = 1808,
  [2147] = 2147,
  [2148] = 2148,
  [2149] = 1971,
  [2150] = 1972,
  [2151] = 2147,
  [2152] = 1982,
  [2153] = 1877,
  [2154] = 1949,
  [2155] = 1983,
  [2156] = 2148,
  [2157] = 1922,
  [2158] = 2158,
  [2159] = 1985,
  [2160] = 1932,
  [2161] = 1948,
  [2162] = 1915,
  [2163] = 1964,
  [2164] = 1915,
  [2165] = 1946,
  [2166] = 1958,
  [2167] = 2167,
  [2168] = 2148,
  [2169] = 1947,
  [2170] = 1948,
  [2171] = 1959,
  [2172] = 1734,
  [2173] = 1878,
  [2174] = 1808,
  [2175] = 1749,
  [2176] = 1949,
  [2177] = 2177,
  [2178] = 2148,
  [2179] = 1969,
  [2180] = 1960,
  [2181] = 1918,
  [2182] = 1807,
  [2183] = 1970,
  [2184] = 1254,
  [2185] = 2148,
  [2186] = 1780,
  [2187] = 1864,
  [2188] = 1811,
  [2189] = 1808,
  [2190] = 1812,
  [2191] = 1756,
  [2192] = 1865,
  [2193] = 2193,
  [2194] = 1758,
  [2195] = 1866,
  [2196] = 719,
  [2197] = 1756,
  [2198] = 1867,
  [2199] = 241,
  [2200] = 1964,
  [2201] = 1868,
  [2202] = 1869,
  [2203] = 2167,
  [2204] = 1870,
  [2205] = 1871,
  [2206] = 1872,
  [2207] = 1873,
  [2208] = 2208,
  [2209] = 1822,
  [2210] = 1776,
  [2211] = 1849,
  [2212] = 2212,
  [2213] = 1689,
  [2214] = 1660,
  [2215] = 1874,
  [2216] = 1850,
  [2217] = 1844,
  [2218] = 1851,
  [2219] = 1813,
  [2220] = 1814,
  [2221] = 1815,
  [2222] = 1816,
  [2223] = 2223,
  [2224] = 1817,
  [2225] = 1807,
  [2226] = 1234,
  [2227] = 1808,
  [2228] = 1759,
  [2229] = 1777,
  [2230] = 1823,
  [2231] = 1805,
  [2232] = 762,
  [2233] = 2233,
  [2234] = 1818,
  [2235] = 1765,
  [2236] = 1824,
  [2237] = 241,
  [2238] = 714,
  [2239] = 1852,
  [2240] = 1807,
  [2241] = 1881,
  [2242] = 1882,
  [2243] = 1782,
  [2244] = 1853,
  [2245] = 1684,
  [2246] = 1854,
  [2247] = 1778,
  [2248] = 2248,
  [2249] = 1758,
  [2250] = 2073,
  [2251] = 2193,
  [2252] = 2252,
  [2253] = 1783,
  [2254] = 1855,
  [2255] = 1807,
  [2256] = 1808,
  [2257] = 1808,
  [2258] = 1950,
  [2259] = 1784,
  [2260] = 1879,
  [2261] = 1759,
  [2262] = 1856,
  [2263] = 1857,
  [2264] = 1928,
  [2265] = 1858,
  [2266] = 1950,
  [2267] = 1965,
  [2268] = 2268,
  [2269] = 1759,
  [2270] = 1957,
  [2271] = 1859,
  [2272] = 1860,
  [2273] = 1787,
  [2274] = 1928,
  [2275] = 1788,
  [2276] = 717,
  [2277] = 2277,
  [2278] = 2167,
  [2279] = 1765,
  [2280] = 1957,
  [2281] = 2073,
  [2282] = 1826,
  [2283] = 1890,
  [2284] = 1015,
  [2285] = 1828,
  [2286] = 1789,
  [2287] = 1829,
  [2288] = 1755,
  [2289] = 1830,
  [2290] = 2208,
  [2291] = 1831,
  [2292] = 1832,
  [2293] = 1833,
  [2294] = 1834,
  [2295] = 1790,
  [2296] = 1791,
  [2297] = 1792,
  [2298] = 1863,
  [2299] = 1794,
  [2300] = 1795,
  [2301] = 1796,
  [2302] = 1840,
  [2303] = 2303,
  [2304] = 1861,
  [2305] = 1915,
  [2306] = 1918,
  [2307] = 1919,
  [2308] = 1922,
  [2309] = 1845,
  [2310] = 1797,
  [2311] = 2311,
  [2312] = 2312,
  [2313] = 1806,
  [2314] = 1932,
  [2315] = 1933,
  [2316] = 1934,
  [2317] = 1935,
  [2318] = 1936,
  [2319] = 1937,
  [2320] = 1938,
  [2321] = 1939,
  [2322] = 1940,
  [2323] = 1942,
  [2324] = 1943,
  [2325] = 1945,
  [2326] = 1807,
  [2327] = 1835,
  [2328] = 2328,
  [2329] = 1836,
  [2330] = 1958,
  [2331] = 1959,
  [2332] = 1969,
  [2333] = 1970,
  [2334] = 1971,
  [2335] = 1972,
  [2336] = 1982,
  [2337] = 1983,
  [2338] = 1985,
  [2339] = 2339,
  [2340] = 1995,
  [2341] = 1819,
  [2342] = 1798,
  [2343] = 1799,
  [2344] = 1837,
  [2345] = 2277,
  [2346] = 1775,
  [2347] = 2347,
  [2348] = 1820,
  [2349] = 1773,
  [2350] = 2350,
  [2351] = 2303,
  [2352] = 1016,
  [2353] = 1846,
  [2354] = 1885,
  [2355] = 1842,
  [2356] = 1774,
  [2357] = 716,
  [2358] = 1772,
  [2359] = 1960,
  [2360] = 1017,
  [2361] = 1946,
  [2362] = 1947,
  [2363] = 1948,
  [2364] = 1949,
  [2365] = 1838,
  [2366] = 1839,
  [2367] = 1765,
  [2368] = 2368,
  [2369] = 1809,
  [2370] = 1841,
  [2371] = 1751,
  [2372] = 1847,
  [2373] = 1804,
  [2374] = 2374,
  [2375] = 1801,
  [2376] = 2376,
  [2377] = 1843,
  [2378] = 1771,
  [2379] = 1802,
  [2380] = 1803,
  [2381] = 2381,
  [2382] = 1810,
  [2383] = 1696,
  [2384] = 1821,
  [2385] = 1761,
  [2386] = 708,
  [2387] = 1793,
  [2388] = 1980,
  [2389] = 2389,
  [2390] = 1981,
  [2391] = 2391,
  [2392] = 2142,
  [2393] = 2393,
  [2394] = 1928,
  [2395] = 2395,
  [2396] = 2396,
  [2397] = 1986,
  [2398] = 1987,
  [2399] = 1227,
  [2400] = 2400,
  [2401] = 2395,
  [2402] = 2368,
  [2403] = 1993,
  [2404] = 2054,
  [2405] = 2405,
  [2406] = 2406,
  [2407] = 1996,
  [2408] = 1891,
  [2409] = 1997,
  [2410] = 2410,
  [2411] = 1957,
  [2412] = 1912,
  [2413] = 263,
  [2414] = 2001,
  [2415] = 2415,
  [2416] = 2416,
  [2417] = 253,
  [2418] = 254,
  [2419] = 255,
  [2420] = 256,
  [2421] = 2389,
  [2422] = 2422,
  [2423] = 258,
  [2424] = 259,
  [2425] = 260,
  [2426] = 261,
  [2427] = 262,
  [2428] = 1740,
  [2429] = 266,
  [2430] = 267,
  [2431] = 2004,
  [2432] = 2432,
  [2433] = 2433,
  [2434] = 2434,
  [2435] = 2435,
  [2436] = 2007,
  [2437] = 1917,
  [2438] = 1703,
  [2439] = 2439,
  [2440] = 1924,
  [2441] = 1928,
  [2442] = 2167,
  [2443] = 1992,
  [2444] = 2009,
  [2445] = 2010,
  [2446] = 1755,
  [2447] = 2011,
  [2448] = 2012,
  [2449] = 2013,
  [2450] = 2014,
  [2451] = 2015,
  [2452] = 2016,
  [2453] = 2017,
  [2454] = 2018,
  [2455] = 2019,
  [2456] = 1897,
  [2457] = 1746,
  [2458] = 1951,
  [2459] = 1950,
  [2460] = 1954,
  [2461] = 1756,
  [2462] = 1758,
  [2463] = 1950,
  [2464] = 2415,
  [2465] = 2465,
  [2466] = 1893,
  [2467] = 1903,
  [2468] = 1904,
  [2469] = 1907,
  [2470] = 2142,
  [2471] = 2368,
  [2472] = 263,
  [2473] = 2473,
  [2474] = 2416,
  [2475] = 253,
  [2476] = 254,
  [2477] = 255,
  [2478] = 256,
  [2479] = 1720,
  [2480] = 258,
  [2481] = 259,
  [2482] = 260,
  [2483] = 261,
  [2484] = 262,
  [2485] = 2485,
  [2486] = 2486,
  [2487] = 266,
  [2488] = 267,
  [2489] = 2489,
  [2490] = 2490,
  [2491] = 2491,
  [2492] = 1711,
  [2493] = 1928,
  [2494] = 2073,
  [2495] = 1950,
  [2496] = 1962,
  [2497] = 1719,
  [2498] = 2498,
  [2499] = 1807,
  [2500] = 1808,
  [2501] = 1807,
  [2502] = 1808,
  [2503] = 2073,
  [2504] = 2003,
  [2505] = 2005,
  [2506] = 2006,
  [2507] = 1730,
  [2508] = 2406,
  [2509] = 1915,
  [2510] = 1918,
  [2511] = 1919,
  [2512] = 1922,
  [2513] = 1932,
  [2514] = 1933,
  [2515] = 1934,
  [2516] = 2400,
  [2517] = 1935,
  [2518] = 2405,
  [2519] = 1936,
  [2520] = 1937,
  [2521] = 1938,
  [2522] = 1939,
  [2523] = 1940,
  [2524] = 1942,
  [2525] = 1943,
  [2526] = 1945,
  [2527] = 1952,
  [2528] = 1958,
  [2529] = 1959,
  [2530] = 1969,
  [2531] = 1970,
  [2532] = 1955,
  [2533] = 1956,
  [2534] = 1971,
  [2535] = 1972,
  [2536] = 1982,
  [2537] = 1983,
  [2538] = 1985,
  [2539] = 2465,
  [2540] = 1995,
  [2541] = 2541,
  [2542] = 2542,
  [2543] = 2543,
  [2544] = 2544,
  [2545] = 2545,
  [2546] = 2546,
  [2547] = 2541,
  [2548] = 2548,
  [2549] = 1715,
  [2550] = 2550,
  [2551] = 2551,
  [2552] = 1755,
  [2553] = 1731,
  [2554] = 1716,
  [2555] = 2400,
  [2556] = 2556,
  [2557] = 2541,
  [2558] = 2542,
  [2559] = 2543,
  [2560] = 2544,
  [2561] = 1973,
  [2562] = 1896,
  [2563] = 1729,
  [2564] = 2400,
  [2565] = 1974,
  [2566] = 1898,
  [2567] = 2567,
  [2568] = 2568,
  [2569] = 2400,
  [2570] = 2542,
  [2571] = 2571,
  [2572] = 2543,
  [2573] = 2573,
  [2574] = 2574,
  [2575] = 2400,
  [2576] = 1975,
  [2577] = 2400,
  [2578] = 2400,
  [2579] = 1718,
  [2580] = 1946,
  [2581] = 1947,
  [2582] = 1948,
  [2583] = 1949,
  [2584] = 1703,
  [2585] = 2473,
  [2586] = 1711,
  [2587] = 2548,
  [2588] = 1716,
  [2589] = 1718,
  [2590] = 2590,
  [2591] = 2473,
  [2592] = 2548,
  [2593] = 1725,
  [2594] = 2594,
  [2595] = 2595,
  [2596] = 2596,
  [2597] = 2597,
  [2598] = 2598,
  [2599] = 1977,
  [2600] = 2600,
  [2601] = 2544,
  [2602] = 1978,
  [2603] = 1979,
  [2604] = 1731,
  [2605] = 2389,
  [2606] = 1740,
  [2607] = 1720,
  [2608] = 1715,
  [2609] = 2573,
  [2610] = 2590,
  [2611] = 2002,
  [2612] = 1919,
  [2613] = 2613,
  [2614] = 2614,
  [2615] = 2129,
  [2616] = 2616,
  [2617] = 2617,
  [2618] = 2142,
  [2619] = 2619,
  [2620] = 2620,
  [2621] = 2621,
  [2622] = 2622,
  [2623] = 257,
  [2624] = 1960,
  [2625] = 1964,
  [2626] = 1965,
  [2627] = 1957,
  [2628] = 2073,
  [2629] = 1759,
  [2630] = 1765,
  [2631] = 2631,
  [2632] = 270,
  [2633] = 245,
  [2634] = 1756,
  [2635] = 1758,
  [2636] = 257,
  [2637] = 1960,
  [2638] = 1964,
  [2639] = 1965,
  [2640] = 1928,
  [2641] = 1950,
  [2642] = 1965,
  [2643] = 1957,
  [2644] = 1807,
  [2645] = 1808,
  [2646] = 2646,
  [2647] = 2647,
  [2648] = 2648,
  [2649] = 2648,
  [2650] = 2613,
  [2651] = 2631,
  [2652] = 2652,
  [2653] = 2653,
  [2654] = 2654,
  [2655] = 2655,
  [2656] = 2073,
  [2657] = 2652,
  [2658] = 2653,
  [2659] = 235,
  [2660] = 234,
  [2661] = 2648,
  [2662] = 2613,
  [2663] = 2631,
  [2664] = 2652,
  [2665] = 2653,
  [2666] = 2654,
  [2667] = 2655,
  [2668] = 1915,
  [2669] = 1918,
  [2670] = 1755,
  [2671] = 1922,
  [2672] = 1932,
  [2673] = 1933,
  [2674] = 1934,
  [2675] = 1935,
  [2676] = 1936,
  [2677] = 1937,
  [2678] = 1938,
  [2679] = 1939,
  [2680] = 1940,
  [2681] = 1942,
  [2682] = 1943,
  [2683] = 1945,
  [2684] = 2073,
  [2685] = 1958,
  [2686] = 1959,
  [2687] = 1969,
  [2688] = 1970,
  [2689] = 1971,
  [2690] = 1972,
  [2691] = 1982,
  [2692] = 1983,
  [2693] = 1985,
  [2694] = 1995,
  [2695] = 1915,
  [2696] = 2073,
  [2697] = 1919,
  [2698] = 1922,
  [2699] = 1932,
  [2700] = 1933,
  [2701] = 1934,
  [2702] = 1935,
  [2703] = 1936,
  [2704] = 1937,
  [2705] = 1938,
  [2706] = 1939,
  [2707] = 1940,
  [2708] = 1942,
  [2709] = 1943,
  [2710] = 1945,
  [2711] = 1958,
  [2712] = 1959,
  [2713] = 1969,
  [2714] = 1970,
  [2715] = 1971,
  [2716] = 1972,
  [2717] = 1982,
  [2718] = 1983,
  [2719] = 1985,
  [2720] = 1995,
  [2721] = 2721,
  [2722] = 1915,
  [2723] = 1918,
  [2724] = 1919,
  [2725] = 1922,
  [2726] = 1932,
  [2727] = 1933,
  [2728] = 1934,
  [2729] = 1935,
  [2730] = 1936,
  [2731] = 1937,
  [2732] = 1938,
  [2733] = 1939,
  [2734] = 1940,
  [2735] = 1942,
  [2736] = 1943,
  [2737] = 1945,
  [2738] = 1958,
  [2739] = 1959,
  [2740] = 1969,
  [2741] = 1970,
  [2742] = 1971,
  [2743] = 1972,
  [2744] = 1982,
  [2745] = 1983,
  [2746] = 1985,
  [2747] = 1995,
  [2748] = 2654,
  [2749] = 2655,
  [2750] = 792,
  [2751] = 2751,
  [2752] = 2752,
  [2753] = 1946,
  [2754] = 1947,
  [2755] = 1948,
  [2756] = 1949,
  [2757] = 1946,
  [2758] = 1947,
  [2759] = 1948,
  [2760] = 1949,
  [2761] = 1946,
  [2762] = 1947,
  [2763] = 1948,
  [2764] = 1949,
  [2765] = 2765,
  [2766] = 1918,
  [2767] = 815,
  [2768] = 242,
  [2769] = 1235,
  [2770] = 2770,
  [2771] = 2771,
  [2772] = 1922,
  [2773] = 2773,
  [2774] = 2774,
  [2775] = 1239,
  [2776] = 1957,
  [2777] = 2073,
  [2778] = 2778,
  [2779] = 1759,
  [2780] = 1254,
  [2781] = 2781,
  [2782] = 1765,
  [2783] = 2783,
  [2784] = 1249,
  [2785] = 812,
  [2786] = 2786,
  [2787] = 1958,
  [2788] = 1928,
  [2789] = 1918,
  [2790] = 2790,
  [2791] = 1950,
  [2792] = 1959,
  [2793] = 2793,
  [2794] = 1969,
  [2795] = 1970,
  [2796] = 2368,
  [2797] = 2797,
  [2798] = 2771,
  [2799] = 2799,
  [2800] = 2147,
  [2801] = 2781,
  [2802] = 1946,
  [2803] = 2803,
  [2804] = 1971,
  [2805] = 1972,
  [2806] = 1982,
  [2807] = 1983,
  [2808] = 1985,
  [2809] = 1949,
  [2810] = 2781,
  [2811] = 2811,
  [2812] = 2781,
  [2813] = 2813,
  [2814] = 1233,
  [2815] = 1225,
  [2816] = 1919,
  [2817] = 805,
  [2818] = 808,
  [2819] = 2819,
  [2820] = 2820,
  [2821] = 2821,
  [2822] = 1932,
  [2823] = 1933,
  [2824] = 1934,
  [2825] = 1228,
  [2826] = 2826,
  [2827] = 2827,
  [2828] = 2828,
  [2829] = 1732,
  [2830] = 2830,
  [2831] = 1947,
  [2832] = 2781,
  [2833] = 816,
  [2834] = 1935,
  [2835] = 1936,
  [2836] = 2836,
  [2837] = 1948,
  [2838] = 2838,
  [2839] = 2839,
  [2840] = 1937,
  [2841] = 1938,
  [2842] = 2842,
  [2843] = 814,
  [2844] = 1995,
  [2845] = 1236,
  [2846] = 2781,
  [2847] = 1939,
  [2848] = 1940,
  [2849] = 804,
  [2850] = 1942,
  [2851] = 1957,
  [2852] = 2781,
  [2853] = 2853,
  [2854] = 1943,
  [2855] = 2855,
  [2856] = 2856,
  [2857] = 802,
  [2858] = 2858,
  [2859] = 811,
  [2860] = 1945,
  [2861] = 2861,
  [2862] = 2862,
  [2863] = 1755,
  [2864] = 1915,
  [2865] = 2781,
  [2866] = 2866,
  [2867] = 2867,
  [2868] = 2781,
  [2869] = 809,
  [2870] = 2870,
  [2871] = 248,
  [2872] = 249,
  [2873] = 2873,
  [2874] = 2874,
  [2875] = 2875,
  [2876] = 870,
  [2877] = 795,
  [2878] = 915,
  [2879] = 818,
  [2880] = 2880,
  [2881] = 2881,
  [2882] = 2870,
  [2883] = 910,
  [2884] = 2884,
  [2885] = 2885,
  [2886] = 911,
  [2887] = 2887,
  [2888] = 2888,
  [2889] = 2889,
  [2890] = 2890,
  [2891] = 2891,
  [2892] = 2892,
  [2893] = 796,
  [2894] = 797,
  [2895] = 881,
  [2896] = 904,
  [2897] = 902,
  [2898] = 2898,
  [2899] = 2899,
  [2900] = 905,
  [2901] = 2901,
  [2902] = 2902,
  [2903] = 2903,
  [2904] = 2904,
  [2905] = 912,
  [2906] = 913,
  [2907] = 801,
  [2908] = 907,
  [2909] = 908,
  [2910] = 2910,
  [2911] = 2911,
  [2912] = 2912,
  [2913] = 2142,
  [2914] = 891,
  [2915] = 810,
  [2916] = 892,
  [2917] = 2917,
  [2918] = 2918,
  [2919] = 2919,
  [2920] = 2920,
  [2921] = 2921,
  [2922] = 2922,
  [2923] = 2923,
  [2924] = 873,
  [2925] = 2925,
  [2926] = 2926,
  [2927] = 2927,
  [2928] = 2928,
  [2929] = 2929,
  [2930] = 893,
  [2931] = 2931,
  [2932] = 2932,
  [2933] = 2933,
  [2934] = 2934,
  [2935] = 817,
  [2936] = 819,
  [2937] = 793,
  [2938] = 2934,
  [2939] = 2721,
  [2940] = 2912,
  [2941] = 2910,
  [2942] = 2942,
  [2943] = 2933,
  [2944] = 2944,
  [2945] = 2922,
  [2946] = 2946,
  [2947] = 2947,
  [2948] = 2948,
  [2949] = 1755,
  [2950] = 2950,
  [2951] = 2951,
  [2952] = 2952,
  [2953] = 1755,
  [2954] = 268,
  [2955] = 1755,
  [2956] = 2956,
  [2957] = 271,
  [2958] = 2958,
  [2959] = 800,
  [2960] = 2928,
  [2961] = 2881,
  [2962] = 2962,
  [2963] = 2911,
  [2964] = 2898,
  [2965] = 2880,
  [2966] = 2929,
  [2967] = 2875,
  [2968] = 882,
  [2969] = 837,
  [2970] = 935,
  [2971] = 862,
  [2972] = 820,
  [2973] = 863,
  [2974] = 864,
  [2975] = 936,
  [2976] = 938,
  [2977] = 939,
  [2978] = 838,
  [2979] = 865,
  [2980] = 2980,
  [2981] = 858,
  [2982] = 866,
  [2983] = 867,
  [2984] = 869,
  [2985] = 906,
  [2986] = 868,
  [2987] = 841,
  [2988] = 842,
  [2989] = 885,
  [2990] = 843,
  [2991] = 839,
  [2992] = 2980,
  [2993] = 874,
  [2994] = 840,
  [2995] = 875,
  [2996] = 2980,
  [2997] = 871,
  [2998] = 844,
  [2999] = 876,
  [3000] = 845,
  [3001] = 877,
  [3002] = 942,
  [3003] = 872,
  [3004] = 879,
  [3005] = 880,
  [3006] = 883,
  [3007] = 2980,
  [3008] = 890,
  [3009] = 2980,
  [3010] = 847,
  [3011] = 848,
  [3012] = 884,
  [3013] = 886,
  [3014] = 849,
  [3015] = 887,
  [3016] = 888,
  [3017] = 920,
  [3018] = 850,
  [3019] = 851,
  [3020] = 894,
  [3021] = 852,
  [3022] = 895,
  [3023] = 896,
  [3024] = 264,
  [3025] = 853,
  [3026] = 897,
  [3027] = 265,
  [3028] = 941,
  [3029] = 922,
  [3030] = 714,
  [3031] = 859,
  [3032] = 854,
  [3033] = 821,
  [3034] = 898,
  [3035] = 899,
  [3036] = 716,
  [3037] = 900,
  [3038] = 901,
  [3039] = 903,
  [3040] = 860,
  [3041] = 916,
  [3042] = 917,
  [3043] = 861,
  [3044] = 918,
  [3045] = 919,
  [3046] = 927,
  [3047] = 3047,
  [3048] = 937,
  [3049] = 923,
  [3050] = 878,
  [3051] = 924,
  [3052] = 2980,
  [3053] = 855,
  [3054] = 822,
  [3055] = 823,
  [3056] = 925,
  [3057] = 926,
  [3058] = 717,
  [3059] = 824,
  [3060] = 2980,
  [3061] = 825,
  [3062] = 826,
  [3063] = 940,
  [3064] = 827,
  [3065] = 719,
  [3066] = 708,
  [3067] = 928,
  [3068] = 828,
  [3069] = 929,
  [3070] = 829,
  [3071] = 1761,
  [3072] = 830,
  [3073] = 268,
  [3074] = 930,
  [3075] = 2980,
  [3076] = 831,
  [3077] = 832,
  [3078] = 931,
  [3079] = 833,
  [3080] = 932,
  [3081] = 834,
  [3082] = 933,
  [3083] = 835,
  [3084] = 271,
  [3085] = 921,
  [3086] = 836,
  [3087] = 934,
  [3088] = 2980,
  [3089] = 857,
  [3090] = 889,
  [3091] = 3091,
  [3092] = 3092,
  [3093] = 3093,
  [3094] = 3094,
  [3095] = 3095,
  [3096] = 3096,
  [3097] = 3097,
  [3098] = 3098,
  [3099] = 3099,
  [3100] = 3100,
  [3101] = 3101,
  [3102] = 3102,
  [3103] = 3103,
  [3104] = 3104,
  [3105] = 3105,
  [3106] = 3106,
  [3107] = 3107,
  [3108] = 3108,
  [3109] = 3109,
  [3110] = 3110,
  [3111] = 3111,
  [3112] = 3112,
  [3113] = 3113,
  [3114] = 3114,
  [3115] = 3115,
  [3116] = 3116,
  [3117] = 3117,
  [3118] = 3118,
  [3119] = 3119,
  [3120] = 3120,
  [3121] = 3121,
  [3122] = 3122,
  [3123] = 3123,
  [3124] = 3124,
  [3125] = 3125,
  [3126] = 3126,
  [3127] = 3127,
  [3128] = 3128,
  [3129] = 3129,
  [3130] = 3130,
  [3131] = 3131,
  [3132] = 3132,
  [3133] = 3133,
  [3134] = 3134,
  [3135] = 1823,
  [3136] = 3136,
  [3137] = 3137,
  [3138] = 3138,
  [3139] = 3139,
  [3140] = 3140,
  [3141] = 3141,
  [3142] = 3142,
  [3143] = 3143,
  [3144] = 3144,
  [3145] = 3145,
  [3146] = 3146,
  [3147] = 3147,
  [3148] = 3148,
  [3149] = 3149,
  [3150] = 3150,
  [3151] = 3151,
  [3152] = 3152,
  [3153] = 3153,
  [3154] = 3152,
  [3155] = 3153,
  [3156] = 3152,
  [3157] = 3153,
  [3158] = 3152,
  [3159] = 3159,
  [3160] = 3153,
  [3161] = 3161,
  [3162] = 3162,
  [3163] = 3163,
  [3164] = 3164,
  [3165] = 3165,
  [3166] = 3166,
  [3167] = 3167,
  [3168] = 3168,
  [3169] = 3169,
  [3170] = 3170,
  [3171] = 3171,
  [3172] = 3172,
  [3173] = 3173,
  [3174] = 3169,
  [3175] = 3175,
  [3176] = 3176,
  [3177] = 3172,
  [3178] = 3178,
  [3179] = 3179,
  [3180] = 3180,
  [3181] = 3181,
  [3182] = 3182,
  [3183] = 3183,
  [3184] = 3184,
  [3185] = 3185,
  [3186] = 3186,
  [3187] = 3187,
  [3188] = 3188,
  [3189] = 1249,
  [3190] = 1254,
  [3191] = 1239,
  [3192] = 1676,
  [3193] = 1675,
  [3194] = 1674,
  [3195] = 1829,
  [3196] = 1863,
  [3197] = 1864,
  [3198] = 1865,
  [3199] = 1866,
  [3200] = 1867,
  [3201] = 1868,
  [3202] = 1869,
  [3203] = 1870,
  [3204] = 1871,
  [3205] = 1872,
  [3206] = 1833,
  [3207] = 1850,
  [3208] = 1851,
  [3209] = 1852,
  [3210] = 1853,
  [3211] = 1826,
  [3212] = 1836,
  [3213] = 1854,
  [3214] = 1855,
  [3215] = 1856,
  [3216] = 1834,
  [3217] = 1838,
  [3218] = 1857,
  [3219] = 1858,
  [3220] = 1839,
  [3221] = 1890,
  [3222] = 1830,
  [3223] = 1835,
  [3224] = 1831,
  [3225] = 1832,
  [3226] = 1837,
  [3227] = 1849,
  [3228] = 1828,
  [3229] = 249,
  [3230] = 248,
  [3231] = 1747,
  [3232] = 1819,
  [3233] = 3233,
  [3234] = 1803,
  [3235] = 1813,
  [3236] = 1816,
  [3237] = 1812,
  [3238] = 1805,
  [3239] = 1817,
  [3240] = 1818,
  [3241] = 1676,
  [3242] = 1801,
  [3243] = 1783,
  [3244] = 1678,
  [3245] = 1675,
  [3246] = 1749,
  [3247] = 3233,
  [3248] = 1674,
  [3249] = 1782,
  [3250] = 1774,
  [3251] = 1707,
  [3252] = 1799,
  [3253] = 1797,
  [3254] = 1744,
  [3255] = 1742,
  [3256] = 3256,
  [3257] = 3257,
  [3258] = 1849,
  [3259] = 3257,
  [3260] = 1851,
  [3261] = 1852,
  [3262] = 1853,
  [3263] = 1854,
  [3264] = 1855,
  [3265] = 1856,
  [3266] = 1857,
  [3267] = 1858,
  [3268] = 1772,
  [3269] = 3257,
  [3270] = 3256,
  [3271] = 3271,
  [3272] = 3272,
  [3273] = 3273,
  [3274] = 1773,
  [3275] = 1863,
  [3276] = 1864,
  [3277] = 1865,
  [3278] = 1866,
  [3279] = 1867,
  [3280] = 1868,
  [3281] = 1869,
  [3282] = 1870,
  [3283] = 1871,
  [3284] = 1872,
  [3285] = 1840,
  [3286] = 1841,
  [3287] = 1843,
  [3288] = 1844,
  [3289] = 1784,
  [3290] = 1787,
  [3291] = 1775,
  [3292] = 1776,
  [3293] = 1777,
  [3294] = 1778,
  [3295] = 1788,
  [3296] = 1678,
  [3297] = 3257,
  [3298] = 1790,
  [3299] = 1791,
  [3300] = 1792,
  [3301] = 1794,
  [3302] = 1796,
  [3303] = 1802,
  [3304] = 1804,
  [3305] = 1806,
  [3306] = 3257,
  [3307] = 3257,
  [3308] = 1809,
  [3309] = 1810,
  [3310] = 1811,
  [3311] = 1814,
  [3312] = 1798,
  [3313] = 1820,
  [3314] = 1822,
  [3315] = 1824,
  [3316] = 1859,
  [3317] = 1860,
  [3318] = 1861,
  [3319] = 3257,
  [3320] = 1771,
  [3321] = 3271,
  [3322] = 3272,
  [3323] = 3273,
  [3324] = 1826,
  [3325] = 1890,
  [3326] = 1828,
  [3327] = 1829,
  [3328] = 1830,
  [3329] = 1831,
  [3330] = 1832,
  [3331] = 1833,
  [3332] = 1834,
  [3333] = 3257,
  [3334] = 1835,
  [3335] = 1836,
  [3336] = 1837,
  [3337] = 3256,
  [3338] = 3271,
  [3339] = 3272,
  [3340] = 3273,
  [3341] = 1838,
  [3342] = 1839,
  [3343] = 3257,
  [3344] = 1873,
  [3345] = 3256,
  [3346] = 3271,
  [3347] = 3272,
  [3348] = 3273,
  [3349] = 3256,
  [3350] = 3271,
  [3351] = 3272,
  [3352] = 3273,
  [3353] = 1674,
  [3354] = 1675,
  [3355] = 1676,
  [3356] = 1850,
  [3357] = 3357,
  [3358] = 3358,
  [3359] = 3359,
  [3360] = 3360,
  [3361] = 3361,
  [3362] = 3362,
  [3363] = 3363,
  [3364] = 1712,
  [3365] = 3363,
  [3366] = 3366,
  [3367] = 3367,
  [3368] = 3368,
  [3369] = 3369,
  [3370] = 3370,
  [3371] = 3371,
  [3372] = 3371,
  [3373] = 3363,
  [3374] = 3371,
  [3375] = 3375,
  [3376] = 3376,
  [3377] = 1747,
  [3378] = 3378,
  [3379] = 3371,
  [3380] = 3363,
  [3381] = 1722,
  [3382] = 3382,
  [3383] = 3383,
  [3384] = 3363,
  [3385] = 3385,
  [3386] = 1713,
  [3387] = 3387,
  [3388] = 3371,
  [3389] = 3389,
  [3390] = 3363,
  [3391] = 3391,
  [3392] = 1749,
  [3393] = 3393,
  [3394] = 3394,
  [3395] = 3357,
  [3396] = 3371,
  [3397] = 3397,
  [3398] = 3371,
  [3399] = 3399,
  [3400] = 1836,
  [3401] = 1872,
  [3402] = 1789,
  [3403] = 3403,
  [3404] = 1782,
  [3405] = 1793,
  [3406] = 1795,
  [3407] = 1744,
  [3408] = 1801,
  [3409] = 3409,
  [3410] = 1826,
  [3411] = 1803,
  [3412] = 1805,
  [3413] = 1890,
  [3414] = 1828,
  [3415] = 1829,
  [3416] = 1830,
  [3417] = 1783,
  [3418] = 3418,
  [3419] = 3419,
  [3420] = 1812,
  [3421] = 1813,
  [3422] = 1831,
  [3423] = 3423,
  [3424] = 1816,
  [3425] = 1832,
  [3426] = 1817,
  [3427] = 1818,
  [3428] = 1819,
  [3429] = 3429,
  [3430] = 1815,
  [3431] = 1833,
  [3432] = 1821,
  [3433] = 3433,
  [3434] = 3434,
  [3435] = 1874,
  [3436] = 1834,
  [3437] = 1239,
  [3438] = 1835,
  [3439] = 1751,
  [3440] = 1871,
  [3441] = 1254,
  [3442] = 1249,
  [3443] = 1837,
  [3444] = 1838,
  [3445] = 1839,
  [3446] = 1849,
  [3447] = 1850,
  [3448] = 1851,
  [3449] = 1852,
  [3450] = 3450,
  [3451] = 1853,
  [3452] = 1854,
  [3453] = 1855,
  [3454] = 1856,
  [3455] = 1857,
  [3456] = 1858,
  [3457] = 1863,
  [3458] = 3458,
  [3459] = 3459,
  [3460] = 1842,
  [3461] = 1864,
  [3462] = 1865,
  [3463] = 1845,
  [3464] = 1866,
  [3465] = 1846,
  [3466] = 1847,
  [3467] = 1867,
  [3468] = 1868,
  [3469] = 1869,
  [3470] = 1870,
  [3471] = 1678,
  [3472] = 1780,
  [3473] = 1749,
  [3474] = 1016,
  [3475] = 3475,
  [3476] = 3476,
  [3477] = 3477,
  [3478] = 3478,
  [3479] = 3479,
  [3480] = 1707,
  [3481] = 1017,
  [3482] = 3475,
  [3483] = 3483,
  [3484] = 1774,
  [3485] = 3485,
  [3486] = 3486,
  [3487] = 3487,
  [3488] = 3475,
  [3489] = 3489,
  [3490] = 1712,
  [3491] = 3491,
  [3492] = 3492,
  [3493] = 3493,
  [3494] = 3494,
  [3495] = 3495,
  [3496] = 3496,
  [3497] = 3497,
  [3498] = 3498,
  [3499] = 1713,
  [3500] = 3500,
  [3501] = 3501,
  [3502] = 3502,
  [3503] = 1797,
  [3504] = 1799,
  [3505] = 3505,
  [3506] = 1674,
  [3507] = 3507,
  [3508] = 3508,
  [3509] = 1675,
  [3510] = 3510,
  [3511] = 1676,
  [3512] = 3512,
  [3513] = 3513,
  [3514] = 3514,
  [3515] = 1747,
  [3516] = 3516,
  [3517] = 3517,
  [3518] = 3475,
  [3519] = 3519,
  [3520] = 3520,
  [3521] = 3475,
  [3522] = 3475,
  [3523] = 3523,
  [3524] = 3524,
  [3525] = 1015,
  [3526] = 3526,
  [3527] = 3527,
  [3528] = 3528,
  [3529] = 3529,
  [3530] = 3479,
  [3531] = 1742,
  [3532] = 1722,
  [3533] = 3533,
  [3534] = 1772,
  [3535] = 1809,
  [3536] = 1773,
  [3537] = 3537,
  [3538] = 1794,
  [3539] = 1795,
  [3540] = 1810,
  [3541] = 1796,
  [3542] = 1811,
  [3543] = 1803,
  [3544] = 3544,
  [3545] = 708,
  [3546] = 1784,
  [3547] = 717,
  [3548] = 719,
  [3549] = 1814,
  [3550] = 1815,
  [3551] = 1775,
  [3552] = 1776,
  [3553] = 1777,
  [3554] = 716,
  [3555] = 1816,
  [3556] = 1817,
  [3557] = 1805,
  [3558] = 1802,
  [3559] = 1780,
  [3560] = 1818,
  [3561] = 1820,
  [3562] = 1821,
  [3563] = 1822,
  [3564] = 1873,
  [3565] = 1804,
  [3566] = 1798,
  [3567] = 1254,
  [3568] = 1787,
  [3569] = 1788,
  [3570] = 1840,
  [3571] = 1841,
  [3572] = 1249,
  [3573] = 1824,
  [3574] = 1806,
  [3575] = 1842,
  [3576] = 1789,
  [3577] = 1843,
  [3578] = 1790,
  [3579] = 1812,
  [3580] = 1844,
  [3581] = 1791,
  [3582] = 1744,
  [3583] = 1239,
  [3584] = 1778,
  [3585] = 1819,
  [3586] = 1859,
  [3587] = 1813,
  [3588] = 1751,
  [3589] = 1780,
  [3590] = 1874,
  [3591] = 1792,
  [3592] = 1793,
  [3593] = 1860,
  [3594] = 1845,
  [3595] = 1782,
  [3596] = 1771,
  [3597] = 1861,
  [3598] = 1783,
  [3599] = 1846,
  [3600] = 3600,
  [3601] = 1678,
  [3602] = 1801,
  [3603] = 1847,
  [3604] = 1751,
  [3605] = 714,
  [3606] = 3500,
  [3607] = 3607,
  [3608] = 3608,
  [3609] = 3609,
  [3610] = 3608,
  [3611] = 3611,
  [3612] = 3612,
  [3613] = 3613,
  [3614] = 3614,
  [3615] = 3615,
  [3616] = 1713,
  [3617] = 3617,
  [3618] = 3618,
  [3619] = 1678,
  [3620] = 3620,
  [3621] = 3621,
  [3622] = 3622,
  [3623] = 1774,
  [3624] = 1747,
  [3625] = 3625,
  [3626] = 1742,
  [3627] = 3627,
  [3628] = 3609,
  [3629] = 3608,
  [3630] = 3611,
  [3631] = 1722,
  [3632] = 1707,
  [3633] = 1797,
  [3634] = 3608,
  [3635] = 1799,
  [3636] = 3614,
  [3637] = 3609,
  [3638] = 3638,
  [3639] = 3609,
  [3640] = 1712,
  [3641] = 3641,
  [3642] = 1845,
  [3643] = 1820,
  [3644] = 3644,
  [3645] = 1223,
  [3646] = 1821,
  [3647] = 3647,
  [3648] = 1822,
  [3649] = 3649,
  [3650] = 3650,
  [3651] = 3475,
  [3652] = 3652,
  [3653] = 1859,
  [3654] = 3654,
  [3655] = 3655,
  [3656] = 3656,
  [3657] = 3657,
  [3658] = 1860,
  [3659] = 3659,
  [3660] = 3660,
  [3661] = 3661,
  [3662] = 3662,
  [3663] = 1861,
  [3664] = 708,
  [3665] = 1824,
  [3666] = 3666,
  [3667] = 717,
  [3668] = 3668,
  [3669] = 3669,
  [3670] = 3670,
  [3671] = 3671,
  [3672] = 3672,
  [3673] = 3673,
  [3674] = 3674,
  [3675] = 3655,
  [3676] = 716,
  [3677] = 3656,
  [3678] = 1809,
  [3679] = 1810,
  [3680] = 1811,
  [3681] = 1873,
  [3682] = 3682,
  [3683] = 1874,
  [3684] = 1802,
  [3685] = 3685,
  [3686] = 1814,
  [3687] = 3687,
  [3688] = 3688,
  [3689] = 3689,
  [3690] = 1815,
  [3691] = 3691,
  [3692] = 3475,
  [3693] = 3654,
  [3694] = 1015,
  [3695] = 3657,
  [3696] = 3475,
  [3697] = 3697,
  [3698] = 1840,
  [3699] = 1841,
  [3700] = 1016,
  [3701] = 3654,
  [3702] = 3475,
  [3703] = 3703,
  [3704] = 3704,
  [3705] = 1017,
  [3706] = 3706,
  [3707] = 3707,
  [3708] = 3475,
  [3709] = 1842,
  [3710] = 3710,
  [3711] = 3711,
  [3712] = 3712,
  [3713] = 3661,
  [3714] = 3714,
  [3715] = 3615,
  [3716] = 3716,
  [3717] = 3475,
  [3718] = 3718,
  [3719] = 3719,
  [3720] = 3720,
  [3721] = 1843,
  [3722] = 1844,
  [3723] = 3691,
  [3724] = 3724,
  [3725] = 3725,
  [3726] = 3726,
  [3727] = 3655,
  [3728] = 3728,
  [3729] = 3656,
  [3730] = 3730,
  [3731] = 3657,
  [3732] = 3641,
  [3733] = 3733,
  [3734] = 3662,
  [3735] = 3735,
  [3736] = 3657,
  [3737] = 3737,
  [3738] = 3738,
  [3739] = 3739,
  [3740] = 3740,
  [3741] = 3741,
  [3742] = 3742,
  [3743] = 1846,
  [3744] = 3744,
  [3745] = 3745,
  [3746] = 3746,
  [3747] = 3747,
  [3748] = 3748,
  [3749] = 3749,
  [3750] = 1847,
  [3751] = 3751,
  [3752] = 3661,
  [3753] = 3662,
  [3754] = 1771,
  [3755] = 719,
  [3756] = 1772,
  [3757] = 1773,
  [3758] = 1804,
  [3759] = 1775,
  [3760] = 3760,
  [3761] = 1776,
  [3762] = 1777,
  [3763] = 1778,
  [3764] = 1806,
  [3765] = 3765,
  [3766] = 714,
  [3767] = 1749,
  [3768] = 1784,
  [3769] = 248,
  [3770] = 1787,
  [3771] = 1788,
  [3772] = 1789,
  [3773] = 1790,
  [3774] = 1791,
  [3775] = 1792,
  [3776] = 249,
  [3777] = 1793,
  [3778] = 1794,
  [3779] = 1795,
  [3780] = 1796,
  [3781] = 3689,
  [3782] = 1798,
  [3783] = 3654,
  [3784] = 3784,
  [3785] = 1015,
  [3786] = 1016,
  [3787] = 3787,
  [3788] = 3617,
  [3789] = 3789,
  [3790] = 3790,
  [3791] = 3791,
  [3792] = 3792,
  [3793] = 1017,
  [3794] = 3794,
  [3795] = 1744,
  [3796] = 3796,
  [3797] = 1254,
  [3798] = 3798,
  [3799] = 3798,
  [3800] = 3798,
  [3801] = 1249,
  [3802] = 235,
  [3803] = 3798,
  [3804] = 248,
  [3805] = 1722,
  [3806] = 249,
  [3807] = 3807,
  [3808] = 3796,
  [3809] = 3809,
  [3810] = 3810,
  [3811] = 1234,
  [3812] = 3796,
  [3813] = 3500,
  [3814] = 3814,
  [3815] = 3615,
  [3816] = 3796,
  [3817] = 1712,
  [3818] = 3798,
  [3819] = 1713,
  [3820] = 3798,
  [3821] = 3821,
  [3822] = 3822,
  [3823] = 3823,
  [3824] = 3824,
  [3825] = 3825,
  [3826] = 3826,
  [3827] = 3827,
  [3828] = 3828,
  [3829] = 3798,
  [3830] = 3830,
  [3831] = 3821,
  [3832] = 3798,
  [3833] = 1239,
  [3834] = 3834,
  [3835] = 3821,
  [3836] = 3796,
  [3837] = 3796,
  [3838] = 234,
  [3839] = 3839,
  [3840] = 3644,
  [3841] = 3841,
  [3842] = 3842,
  [3843] = 3843,
  [3844] = 3844,
  [3845] = 3620,
  [3846] = 3846,
  [3847] = 3847,
  [3848] = 3848,
  [3849] = 3849,
  [3850] = 3850,
  [3851] = 3710,
  [3852] = 3852,
  [3853] = 3853,
  [3854] = 3854,
  [3855] = 3544,
  [3856] = 3856,
  [3857] = 3857,
  [3858] = 3858,
  [3859] = 3859,
  [3860] = 3860,
  [3861] = 3861,
  [3862] = 3862,
  [3863] = 3863,
  [3864] = 3864,
  [3865] = 3865,
  [3866] = 3866,
  [3867] = 3867,
  [3868] = 3868,
  [3869] = 3869,
  [3870] = 3870,
  [3871] = 3869,
  [3872] = 3872,
  [3873] = 3873,
  [3874] = 3874,
  [3875] = 3875,
  [3876] = 3876,
  [3877] = 3877,
  [3878] = 3878,
  [3879] = 3879,
  [3880] = 3848,
  [3881] = 3850,
  [3882] = 3882,
  [3883] = 3883,
  [3884] = 3711,
  [3885] = 3850,
  [3886] = 3886,
  [3887] = 3887,
  [3888] = 3888,
  [3889] = 3889,
  [3890] = 3890,
  [3891] = 3891,
  [3892] = 3892,
  [3893] = 3893,
  [3894] = 3894,
  [3895] = 3895,
  [3896] = 3896,
  [3897] = 242,
  [3898] = 3898,
  [3899] = 3899,
  [3900] = 3900,
  [3901] = 3869,
  [3902] = 3902,
  [3903] = 3874,
  [3904] = 3904,
  [3905] = 3905,
  [3906] = 3906,
  [3907] = 3907,
  [3908] = 3908,
  [3909] = 3909,
  [3910] = 3910,
  [3911] = 3869,
  [3912] = 3912,
  [3913] = 3913,
  [3914] = 3914,
  [3915] = 3895,
  [3916] = 3916,
  [3917] = 3917,
  [3918] = 3918,
  [3919] = 3919,
  [3920] = 3920,
  [3921] = 3882,
  [3922] = 3922,
  [3923] = 3923,
  [3924] = 3924,
  [3925] = 3925,
  [3926] = 3926,
  [3927] = 3927,
  [3928] = 3928,
  [3929] = 3929,
  [3930] = 3930,
  [3931] = 3913,
  [3932] = 3932,
  [3933] = 3844,
  [3934] = 3934,
  [3935] = 3935,
  [3936] = 3936,
  [3937] = 3937,
  [3938] = 3869,
  [3939] = 3939,
  [3940] = 3940,
  [3941] = 3941,
  [3942] = 3942,
  [3943] = 3943,
  [3944] = 3869,
  [3945] = 3945,
  [3946] = 1712,
  [3947] = 3947,
  [3948] = 1713,
  [3949] = 3949,
  [3950] = 3939,
  [3951] = 3951,
  [3952] = 3952,
  [3953] = 3953,
  [3954] = 3954,
  [3955] = 3955,
  [3956] = 3956,
  [3957] = 1815,
  [3958] = 1821,
  [3959] = 3959,
  [3960] = 3960,
  [3961] = 3961,
  [3962] = 3962,
  [3963] = 3963,
  [3964] = 3964,
  [3965] = 3965,
  [3966] = 3966,
  [3967] = 3967,
  [3968] = 1842,
  [3969] = 1845,
  [3970] = 1846,
  [3971] = 1847,
  [3972] = 3972,
  [3973] = 3973,
  [3974] = 3974,
  [3975] = 3847,
  [3976] = 3976,
  [3977] = 3977,
  [3978] = 3978,
  [3979] = 1874,
  [3980] = 3963,
  [3981] = 3981,
  [3982] = 3982,
  [3983] = 3983,
  [3984] = 3984,
  [3985] = 3985,
  [3986] = 3986,
  [3987] = 3987,
  [3988] = 3869,
  [3989] = 3989,
  [3990] = 3990,
  [3991] = 3991,
  [3992] = 3992,
  [3993] = 3993,
  [3994] = 3994,
  [3995] = 3995,
  [3996] = 3922,
  [3997] = 3963,
  [3998] = 3998,
  [3999] = 3999,
  [4000] = 270,
  [4001] = 4001,
  [4002] = 4002,
  [4003] = 4003,
  [4004] = 245,
  [4005] = 4005,
  [4006] = 4006,
  [4007] = 3882,
  [4008] = 4008,
  [4009] = 3874,
  [4010] = 3939,
  [4011] = 4011,
  [4012] = 4012,
  [4013] = 4013,
  [4014] = 1722,
  [4015] = 3858,
  [4016] = 3883,
  [4017] = 4017,
  [4018] = 3844,
  [4019] = 4019,
  [4020] = 4020,
  [4021] = 3847,
  [4022] = 4022,
  [4023] = 4023,
  [4024] = 3909,
  [4025] = 3860,
  [4026] = 4026,
  [4027] = 4027,
  [4028] = 4028,
  [4029] = 4029,
  [4030] = 4030,
  [4031] = 3860,
  [4032] = 3864,
  [4033] = 3923,
  [4034] = 4034,
  [4035] = 4035,
  [4036] = 3647,
  [4037] = 4037,
  [4038] = 4038,
  [4039] = 4039,
  [4040] = 4040,
  [4041] = 4041,
  [4042] = 4042,
  [4043] = 4043,
  [4044] = 4044,
  [4045] = 3859,
  [4046] = 4046,
  [4047] = 3874,
  [4048] = 4048,
  [4049] = 4049,
  [4050] = 3872,
  [4051] = 3848,
  [4052] = 3940,
  [4053] = 4053,
  [4054] = 4054,
  [4055] = 1789,
  [4056] = 1793,
  [4057] = 1795,
  [4058] = 4058,
  [4059] = 3874,
  [4060] = 3869,
  [4061] = 3991,
  [4062] = 3848,
  [4063] = 3963,
  [4064] = 4064,
  [4065] = 4065,
  [4066] = 4066,
  [4067] = 4067,
  [4068] = 4054,
  [4069] = 4069,
  [4070] = 4070,
  [4071] = 4071,
  [4072] = 3883,
  [4073] = 4073,
  [4074] = 4074,
  [4075] = 4075,
  [4076] = 4076,
  [4077] = 4077,
  [4078] = 4078,
  [4079] = 4079,
  [4080] = 4080,
  [4081] = 4081,
  [4082] = 3874,
  [4083] = 4083,
  [4084] = 4084,
  [4085] = 3847,
  [4086] = 3872,
  [4087] = 4054,
  [4088] = 4088,
  [4089] = 4089,
  [4090] = 3719,
  [4091] = 4091,
  [4092] = 3872,
  [4093] = 4054,
  [4094] = 4094,
  [4095] = 4095,
  [4096] = 4096,
  [4097] = 3864,
  [4098] = 4098,
  [4099] = 4099,
  [4100] = 4100,
  [4101] = 4101,
  [4102] = 4102,
  [4103] = 4103,
  [4104] = 3951,
  [4105] = 4105,
  [4106] = 4106,
  [4107] = 4107,
  [4108] = 3857,
  [4109] = 4109,
  [4110] = 4110,
  [4111] = 4111,
  [4112] = 4112,
  [4113] = 1815,
  [4114] = 1821,
  [4115] = 3932,
  [4116] = 4116,
  [4117] = 4117,
  [4118] = 4110,
  [4119] = 1789,
  [4120] = 4100,
  [4121] = 1793,
  [4122] = 716,
  [4123] = 1795,
  [4124] = 4102,
  [4125] = 4125,
  [4126] = 3983,
  [4127] = 4127,
  [4128] = 3846,
  [4129] = 4129,
  [4130] = 4130,
  [4131] = 4102,
  [4132] = 4132,
  [4133] = 4133,
  [4134] = 3617,
  [4135] = 1842,
  [4136] = 4105,
  [4137] = 3917,
  [4138] = 3954,
  [4139] = 4139,
  [4140] = 4129,
  [4141] = 1845,
  [4142] = 4102,
  [4143] = 1846,
  [4144] = 3924,
  [4145] = 4133,
  [4146] = 1847,
  [4147] = 4147,
  [4148] = 4148,
  [4149] = 4149,
  [4150] = 3976,
  [4151] = 3935,
  [4152] = 4152,
  [4153] = 4133,
  [4154] = 4154,
  [4155] = 4155,
  [4156] = 4109,
  [4157] = 4100,
  [4158] = 4158,
  [4159] = 717,
  [4160] = 4160,
  [4161] = 4105,
  [4162] = 3930,
  [4163] = 4163,
  [4164] = 1874,
  [4165] = 4127,
  [4166] = 4166,
  [4167] = 4167,
  [4168] = 4168,
  [4169] = 4110,
  [4170] = 4170,
  [4171] = 4001,
  [4172] = 4172,
  [4173] = 4173,
  [4174] = 3927,
  [4175] = 4110,
  [4176] = 719,
  [4177] = 4177,
  [4178] = 4178,
  [4179] = 4179,
  [4180] = 4167,
  [4181] = 4181,
  [4182] = 4182,
  [4183] = 708,
  [4184] = 4184,
  [4185] = 4185,
  [4186] = 1227,
  [4187] = 4181,
  [4188] = 4188,
  [4189] = 4102,
  [4190] = 4190,
  [4191] = 4191,
  [4192] = 4166,
  [4193] = 3892,
  [4194] = 4105,
  [4195] = 4160,
  [4196] = 4133,
  [4197] = 4012,
  [4198] = 4198,
  [4199] = 4110,
  [4200] = 4148,
  [4201] = 4184,
  [4202] = 4158,
  [4203] = 3641,
  [4204] = 4204,
  [4205] = 4105,
  [4206] = 4206,
  [4207] = 4013,
  [4208] = 3893,
  [4209] = 4100,
  [4210] = 4149,
  [4211] = 4181,
  [4212] = 4212,
  [4213] = 4179,
  [4214] = 4100,
  [4215] = 4206,
  [4216] = 4216,
  [4217] = 3916,
  [4218] = 4218,
  [4219] = 714,
  [4220] = 4098,
  [4221] = 4102,
  [4222] = 4167,
  [4223] = 4105,
  [4224] = 3920,
  [4225] = 4107,
  [4226] = 4212,
  [4227] = 3894,
  [4228] = 4185,
  [4229] = 4152,
  [4230] = 4116,
  [4231] = 4231,
  [4232] = 4168,
  [4233] = 4233,
  [4234] = 4110,
  [4235] = 4028,
  [4236] = 4167,
  [4237] = 4237,
  [4238] = 4147,
  [4239] = 4155,
  [4240] = 4133,
  [4241] = 3537,
  [4242] = 4173,
  [4243] = 3929,
  [4244] = 4133,
  [4245] = 4109,
  [4246] = 4102,
  [4247] = 4247,
  [4248] = 3967,
  [4249] = 4249,
  [4250] = 4133,
  [4251] = 4105,
  [4252] = 4198,
  [4253] = 4181,
  [4254] = 4110,
  [4255] = 4198,
  [4256] = 4149,
  [4257] = 4100,
  [4258] = 4258,
  [4259] = 4259,
  [4260] = 4259,
  [4261] = 4198,
  [4262] = 4262,
  [4263] = 4149,
  [4264] = 3856,
  [4265] = 4218,
  [4266] = 4266,
  [4267] = 3891,
  [4268] = 4268,
  [4269] = 4269,
  [4270] = 4270,
  [4271] = 4271,
  [4272] = 4272,
  [4273] = 4273,
  [4274] = 4274,
  [4275] = 4275,
  [4276] = 4276,
  [4277] = 4277,
  [4278] = 4278,
  [4279] = 4279,
  [4280] = 4280,
  [4281] = 4281,
  [4282] = 4282,
  [4283] = 4283,
  [4284] = 4284,
  [4285] = 4285,
  [4286] = 4286,
  [4287] = 4287,
  [4288] = 4288,
  [4289] = 4289,
  [4290] = 264,
  [4291] = 265,
  [4292] = 4292,
  [4293] = 4293,
  [4294] = 4294,
  [4295] = 4295,
  [4296] = 4296,
  [4297] = 4297,
  [4298] = 4298,
  [4299] = 4299,
  [4300] = 4300,
  [4301] = 4301,
  [4302] = 4302,
  [4303] = 4303,
  [4304] = 4304,
  [4305] = 4305,
  [4306] = 4306,
  [4307] = 4307,
  [4308] = 4308,
  [4309] = 4309,
  [4310] = 4310,
  [4311] = 4311,
  [4312] = 4312,
  [4313] = 4313,
  [4314] = 4314,
  [4315] = 4315,
  [4316] = 4316,
  [4317] = 4317,
  [4318] = 4318,
  [4319] = 4319,
  [4320] = 4320,
  [4321] = 4321,
  [4322] = 4322,
  [4323] = 4323,
  [4324] = 4324,
  [4325] = 4325,
  [4326] = 4326,
  [4327] = 4327,
  [4328] = 4328,
  [4329] = 4329,
  [4330] = 805,
  [4331] = 4331,
  [4332] = 4332,
  [4333] = 4324,
  [4334] = 4334,
  [4335] = 4335,
  [4336] = 4336,
  [4337] = 4337,
  [4338] = 4338,
  [4339] = 4339,
  [4340] = 4340,
  [4341] = 4341,
  [4342] = 4342,
  [4343] = 4343,
  [4344] = 4344,
  [4345] = 4345,
  [4346] = 4346,
  [4347] = 4347,
  [4348] = 4348,
  [4349] = 4349,
  [4350] = 4350,
  [4351] = 808,
  [4352] = 809,
  [4353] = 4353,
  [4354] = 4354,
  [4355] = 4272,
  [4356] = 4321,
  [4357] = 4349,
  [4358] = 4358,
  [4359] = 4359,
  [4360] = 4360,
  [4361] = 4361,
  [4362] = 4362,
  [4363] = 4363,
  [4364] = 4364,
  [4365] = 812,
  [4366] = 4366,
  [4367] = 4367,
  [4368] = 4368,
  [4369] = 4369,
  [4370] = 4370,
  [4371] = 4371,
  [4372] = 870,
  [4373] = 4373,
  [4374] = 4374,
  [4375] = 4336,
  [4376] = 4376,
  [4377] = 885,
  [4378] = 4378,
  [4379] = 4364,
  [4380] = 4376,
  [4381] = 4334,
  [4382] = 4382,
  [4383] = 4383,
  [4384] = 4335,
  [4385] = 4385,
  [4386] = 4386,
  [4387] = 4387,
  [4388] = 4388,
  [4389] = 4389,
  [4390] = 4390,
  [4391] = 4288,
  [4392] = 4392,
  [4393] = 4393,
  [4394] = 4394,
  [4395] = 4395,
  [4396] = 4396,
  [4397] = 4397,
  [4398] = 3853,
  [4399] = 4399,
  [4400] = 4400,
  [4401] = 3918,
  [4402] = 4402,
  [4403] = 4403,
  [4404] = 4342,
  [4405] = 4405,
  [4406] = 4249,
  [4407] = 4407,
  [4408] = 4408,
  [4409] = 4307,
  [4410] = 4410,
  [4411] = 881,
  [4412] = 4412,
  [4413] = 4413,
  [4414] = 4382,
  [4415] = 4415,
  [4416] = 898,
  [4417] = 899,
  [4418] = 4343,
  [4419] = 4419,
  [4420] = 4420,
  [4421] = 4421,
  [4422] = 4422,
  [4423] = 4423,
  [4424] = 941,
  [4425] = 821,
  [4426] = 4324,
  [4427] = 4427,
  [4428] = 4428,
  [4429] = 4429,
  [4430] = 4430,
  [4431] = 4431,
  [4432] = 4432,
  [4433] = 4343,
  [4434] = 4434,
  [4435] = 4435,
  [4436] = 4436,
  [4437] = 4437,
  [4438] = 4321,
  [4439] = 4349,
  [4440] = 4440,
  [4441] = 4441,
  [4442] = 4307,
  [4443] = 4443,
  [4444] = 4366,
  [4445] = 4445,
  [4446] = 4367,
  [4447] = 4369,
  [4448] = 4370,
  [4449] = 4449,
  [4450] = 4364,
  [4451] = 4376,
  [4452] = 4452,
  [4453] = 4453,
  [4454] = 4386,
  [4455] = 4455,
  [4456] = 4188,
  [4457] = 4204,
  [4458] = 4458,
  [4459] = 4216,
  [4460] = 902,
  [4461] = 874,
  [4462] = 876,
  [4463] = 4463,
  [4464] = 879,
  [4465] = 894,
  [4466] = 895,
  [4467] = 896,
  [4468] = 4468,
  [4469] = 4469,
  [4470] = 4470,
  [4471] = 897,
  [4472] = 4472,
  [4473] = 4473,
  [4474] = 4474,
  [4475] = 4390,
  [4476] = 4476,
  [4477] = 4477,
  [4478] = 4478,
  [4479] = 4058,
  [4480] = 4480,
  [4481] = 4481,
  [4482] = 4482,
  [4483] = 4483,
  [4484] = 4484,
  [4485] = 4485,
  [4486] = 4486,
  [4487] = 4487,
  [4488] = 4488,
  [4489] = 4489,
  [4490] = 4361,
  [4491] = 4491,
  [4492] = 4492,
  [4493] = 4493,
  [4494] = 4494,
  [4495] = 4495,
  [4496] = 4324,
  [4497] = 910,
  [4498] = 911,
  [4499] = 923,
  [4500] = 4500,
  [4501] = 924,
  [4502] = 925,
  [4503] = 926,
  [4504] = 818,
  [4505] = 928,
  [4506] = 929,
  [4507] = 930,
  [4508] = 931,
  [4509] = 938,
  [4510] = 939,
  [4511] = 906,
  [4512] = 839,
  [4513] = 840,
  [4514] = 4343,
  [4515] = 871,
  [4516] = 872,
  [4517] = 880,
  [4518] = 882,
  [4519] = 890,
  [4520] = 4321,
  [4521] = 4521,
  [4522] = 4362,
  [4523] = 4523,
  [4524] = 4366,
  [4525] = 4369,
  [4526] = 4526,
  [4527] = 4364,
  [4528] = 4528,
  [4529] = 4529,
  [4530] = 4309,
  [4531] = 4531,
  [4532] = 915,
  [4533] = 900,
  [4534] = 901,
  [4535] = 903,
  [4536] = 817,
  [4537] = 819,
  [4538] = 793,
  [4539] = 916,
  [4540] = 937,
  [4541] = 4541,
  [4542] = 826,
  [4543] = 827,
  [4544] = 828,
  [4545] = 829,
  [4546] = 830,
  [4547] = 831,
  [4548] = 832,
  [4549] = 4549,
  [4550] = 833,
  [4551] = 834,
  [4552] = 4324,
  [4553] = 835,
  [4554] = 837,
  [4555] = 4555,
  [4556] = 4556,
  [4557] = 4343,
  [4558] = 4558,
  [4559] = 4559,
  [4560] = 795,
  [4561] = 796,
  [4562] = 797,
  [4563] = 4563,
  [4564] = 841,
  [4565] = 4565,
  [4566] = 4566,
  [4567] = 847,
  [4568] = 848,
  [4569] = 849,
  [4570] = 850,
  [4571] = 851,
  [4572] = 854,
  [4573] = 855,
  [4574] = 4574,
  [4575] = 4575,
  [4576] = 4576,
  [4577] = 800,
  [4578] = 4578,
  [4579] = 4386,
  [4580] = 4580,
  [4581] = 4581,
  [4582] = 860,
  [4583] = 861,
  [4584] = 862,
  [4585] = 864,
  [4586] = 4586,
  [4587] = 4587,
  [4588] = 4387,
  [4589] = 4589,
  [4590] = 4590,
  [4591] = 4591,
  [4592] = 4592,
  [4593] = 4593,
  [4594] = 4594,
  [4595] = 4394,
  [4596] = 4596,
  [4597] = 4366,
  [4598] = 4598,
  [4599] = 4367,
  [4600] = 4600,
  [4601] = 4368,
  [4602] = 4602,
  [4603] = 4603,
  [4604] = 4604,
  [4605] = 4605,
  [4606] = 3849,
  [4607] = 4607,
  [4608] = 4407,
  [4609] = 4609,
  [4610] = 4521,
  [4611] = 4611,
  [4612] = 4612,
  [4613] = 4613,
  [4614] = 4614,
  [4615] = 4615,
  [4616] = 4616,
  [4617] = 4617,
  [4618] = 4618,
  [4619] = 4619,
  [4620] = 4318,
  [4621] = 4320,
  [4622] = 4622,
  [4623] = 4445,
  [4624] = 4624,
  [4625] = 4607,
  [4626] = 4626,
  [4627] = 4627,
  [4628] = 4596,
  [4629] = 4629,
  [4630] = 4630,
  [4631] = 4631,
  [4632] = 4632,
  [4633] = 4633,
  [4634] = 4634,
  [4635] = 4635,
  [4636] = 4636,
  [4637] = 4630,
  [4638] = 4403,
  [4639] = 4631,
  [4640] = 4369,
  [4641] = 4641,
  [4642] = 4566,
  [4643] = 4643,
  [4644] = 4644,
  [4645] = 4645,
  [4646] = 4646,
  [4647] = 4453,
  [4648] = 4648,
  [4649] = 4649,
  [4650] = 4650,
  [4651] = 4651,
  [4652] = 4652,
  [4653] = 4653,
  [4654] = 4654,
  [4655] = 4655,
  [4656] = 4656,
  [4657] = 4657,
  [4658] = 4658,
  [4659] = 4659,
  [4660] = 4370,
  [4661] = 4661,
  [4662] = 4662,
  [4663] = 4663,
  [4664] = 4664,
  [4665] = 4665,
  [4666] = 4666,
  [4667] = 4407,
  [4668] = 4668,
  [4669] = 4615,
  [4670] = 4616,
  [4671] = 4671,
  [4672] = 4318,
  [4673] = 4320,
  [4674] = 4596,
  [4675] = 4631,
  [4676] = 4676,
  [4677] = 4677,
  [4678] = 4678,
  [4679] = 4679,
  [4680] = 4680,
  [4681] = 4681,
  [4682] = 4682,
  [4683] = 4683,
  [4684] = 4684,
  [4685] = 4685,
  [4686] = 4686,
  [4687] = 4687,
  [4688] = 4688,
  [4689] = 4689,
  [4690] = 4690,
  [4691] = 4691,
  [4692] = 4373,
  [4693] = 235,
  [4694] = 234,
  [4695] = 4695,
  [4696] = 4696,
  [4697] = 4697,
  [4698] = 4698,
  [4699] = 4699,
  [4700] = 4700,
  [4701] = 4407,
  [4702] = 4702,
  [4703] = 4615,
  [4704] = 4616,
  [4705] = 4318,
  [4706] = 4320,
  [4707] = 4596,
  [4708] = 4631,
  [4709] = 4709,
  [4710] = 4710,
  [4711] = 4711,
  [4712] = 4712,
  [4713] = 4713,
  [4714] = 4714,
  [4715] = 4715,
  [4716] = 4716,
  [4717] = 4645,
  [4718] = 4718,
  [4719] = 4719,
  [4720] = 4394,
  [4721] = 4721,
  [4722] = 4722,
  [4723] = 4723,
  [4724] = 4724,
  [4725] = 4388,
  [4726] = 4726,
  [4727] = 4607,
  [4728] = 4325,
  [4729] = 4729,
  [4730] = 4730,
  [4731] = 4342,
  [4732] = 4615,
  [4733] = 4733,
  [4734] = 4734,
  [4735] = 4361,
  [4736] = 4362,
  [4737] = 4737,
  [4738] = 4336,
  [4739] = 4739,
  [4740] = 4616,
  [4741] = 4741,
  [4742] = 4600,
  [4743] = 4743,
  [4744] = 4744,
  [4745] = 4745,
  [4746] = 4746,
  [4747] = 4747,
  [4748] = 4748,
  [4749] = 4749,
  [4750] = 4750,
  [4751] = 4751,
  [4752] = 4752,
  [4753] = 4753,
  [4754] = 4609,
  [4755] = 4755,
  [4756] = 4756,
  [4757] = 4757,
  [4758] = 4758,
  [4759] = 4617,
  [4760] = 4760,
  [4761] = 4761,
  [4762] = 4762,
  [4763] = 4763,
  [4764] = 4764,
  [4765] = 4765,
  [4766] = 4766,
  [4767] = 4767,
  [4768] = 4768,
  [4769] = 4769,
  [4770] = 4353,
  [4771] = 4354,
  [4772] = 4325,
  [4773] = 4773,
  [4774] = 4774,
  [4775] = 4775,
  [4776] = 4776,
  [4777] = 4777,
  [4778] = 4778,
  [4779] = 4779,
  [4780] = 4780,
  [4781] = 4722,
  [4782] = 4782,
  [4783] = 4722,
  [4784] = 4784,
  [4785] = 4785,
  [4786] = 4786,
  [4787] = 4787,
  [4788] = 4788,
  [4789] = 4789,
  [4790] = 4790,
  [4791] = 4790,
  [4792] = 4792,
  [4793] = 4793,
  [4794] = 4794,
  [4795] = 249,
  [4796] = 4796,
  [4797] = 4797,
  [4798] = 4798,
  [4799] = 4799,
  [4800] = 4800,
  [4801] = 4793,
  [4802] = 4802,
  [4803] = 4790,
  [4804] = 4804,
  [4805] = 4805,
  [4806] = 4806,
  [4807] = 4807,
  [4808] = 4808,
  [4809] = 4809,
  [4810] = 4799,
  [4811] = 4811,
  [4812] = 4812,
  [4813] = 4813,
  [4814] = 4814,
  [4815] = 4800,
  [4816] = 4809,
  [4817] = 4817,
  [4818] = 4790,
  [4819] = 4819,
  [4820] = 4820,
  [4821] = 4821,
  [4822] = 4800,
  [4823] = 4823,
  [4824] = 4802,
  [4825] = 4825,
  [4826] = 4826,
  [4827] = 4827,
  [4828] = 4828,
  [4829] = 4829,
  [4830] = 4374,
  [4831] = 4793,
  [4832] = 4832,
  [4833] = 4802,
  [4834] = 4834,
  [4835] = 4835,
  [4836] = 4836,
  [4837] = 4837,
  [4838] = 4798,
  [4839] = 4798,
  [4840] = 4840,
  [4841] = 4825,
  [4842] = 4800,
  [4843] = 4802,
  [4844] = 4825,
  [4845] = 4845,
  [4846] = 4846,
  [4847] = 4807,
  [4848] = 4826,
  [4849] = 4042,
  [4850] = 4799,
  [4851] = 4851,
  [4852] = 4825,
  [4853] = 4800,
  [4854] = 4802,
  [4855] = 4825,
  [4856] = 4826,
  [4857] = 242,
  [4858] = 4858,
  [4859] = 4800,
  [4860] = 4802,
  [4861] = 4861,
  [4862] = 4807,
  [4863] = 4799,
  [4864] = 4825,
  [4865] = 4826,
  [4866] = 4800,
  [4867] = 4802,
  [4868] = 4868,
  [4869] = 4825,
  [4870] = 4870,
  [4871] = 4826,
  [4872] = 4790,
  [4873] = 4800,
  [4874] = 4874,
  [4875] = 4874,
  [4876] = 4876,
  [4877] = 4877,
  [4878] = 4371,
  [4879] = 4879,
  [4880] = 4880,
  [4881] = 4825,
  [4882] = 4807,
  [4883] = 4883,
  [4884] = 4805,
  [4885] = 4826,
  [4886] = 4886,
  [4887] = 4887,
  [4888] = 4858,
  [4889] = 4889,
  [4890] = 4806,
  [4891] = 4799,
  [4892] = 4814,
  [4893] = 4794,
  [4894] = 4807,
  [4895] = 4814,
  [4896] = 4793,
  [4897] = 4897,
  [4898] = 4826,
  [4899] = 4899,
  [4900] = 4883,
  [4901] = 4805,
  [4902] = 4817,
  [4903] = 4903,
  [4904] = 4904,
  [4905] = 4805,
  [4906] = 4906,
  [4907] = 4907,
  [4908] = 4897,
  [4909] = 4799,
  [4910] = 4858,
  [4911] = 4826,
  [4912] = 4912,
  [4913] = 4809,
  [4914] = 4914,
  [4915] = 4805,
  [4916] = 4916,
  [4917] = 4917,
  [4918] = 4914,
  [4919] = 4919,
  [4920] = 4920,
  [4921] = 4811,
  [4922] = 4798,
  [4923] = 4807,
  [4924] = 4798,
  [4925] = 4800,
  [4926] = 4802,
  [4927] = 4825,
  [4928] = 4826,
  [4929] = 3866,
  [4930] = 4930,
  [4931] = 4793,
  [4932] = 4805,
  [4933] = 4933,
  [4934] = 4796,
  [4935] = 4817,
  [4936] = 4800,
  [4937] = 4802,
  [4938] = 4897,
  [4939] = 4825,
  [4940] = 4940,
  [4941] = 4826,
  [4942] = 4897,
  [4943] = 4897,
  [4944] = 4807,
  [4945] = 4805,
  [4946] = 4799,
  [4947] = 248,
  [4948] = 4948,
  [4949] = 4897,
  [4950] = 4794,
  [4951] = 4914,
  [4952] = 4798,
  [4953] = 4897,
  [4954] = 4802,
  [4955] = 4955,
  [4956] = 4956,
  [4957] = 4957,
  [4958] = 4958,
  [4959] = 4959,
  [4960] = 4960,
  [4961] = 4961,
  [4962] = 4962,
  [4963] = 4963,
  [4964] = 4959,
  [4965] = 4965,
  [4966] = 4966,
  [4967] = 4967,
  [4968] = 4968,
  [4969] = 4969,
  [4970] = 4970,
  [4971] = 4971,
  [4972] = 4972,
  [4973] = 4973,
  [4974] = 4974,
  [4975] = 4975,
  [4976] = 4976,
  [4977] = 4977,
  [4978] = 4978,
  [4979] = 4979,
  [4980] = 4980,
  [4981] = 4977,
  [4982] = 4982,
  [4983] = 4983,
  [4984] = 4984,
  [4985] = 4985,
  [4986] = 4986,
  [4987] = 4987,
  [4988] = 4988,
  [4989] = 4989,
  [4990] = 4990,
  [4991] = 4991,
  [4992] = 4992,
  [4993] = 4993,
  [4994] = 4994,
  [4995] = 4995,
  [4996] = 4996,
  [4997] = 4997,
  [4998] = 4998,
  [4999] = 4999,
  [5000] = 4988,
  [5001] = 5001,
  [5002] = 5002,
  [5003] = 4989,
  [5004] = 5004,
  [5005] = 5005,
  [5006] = 5006,
  [5007] = 5007,
  [5008] = 5008,
  [5009] = 5009,
  [5010] = 5010,
  [5011] = 5011,
  [5012] = 5012,
  [5013] = 5013,
  [5014] = 5014,
  [5015] = 5015,
  [5016] = 5016,
  [5017] = 4991,
  [5018] = 5018,
  [5019] = 4968,
  [5020] = 5020,
  [5021] = 5009,
  [5022] = 5022,
  [5023] = 5023,
  [5024] = 5024,
  [5025] = 5025,
  [5026] = 5026,
  [5027] = 5027,
  [5028] = 5028,
  [5029] = 5029,
  [5030] = 5030,
  [5031] = 5031,
  [5032] = 5032,
  [5033] = 5033,
  [5034] = 5034,
  [5035] = 5035,
  [5036] = 5036,
  [5037] = 5037,
  [5038] = 5038,
  [5039] = 5039,
  [5040] = 5040,
  [5041] = 5041,
  [5042] = 5042,
  [5043] = 5043,
  [5044] = 5044,
  [5045] = 5045,
  [5046] = 5046,
  [5047] = 5047,
  [5048] = 5048,
  [5049] = 5049,
  [5050] = 5050,
  [5051] = 5051,
  [5052] = 4989,
  [5053] = 4962,
  [5054] = 4965,
  [5055] = 5055,
  [5056] = 5056,
  [5057] = 5022,
  [5058] = 5058,
  [5059] = 5059,
  [5060] = 5060,
  [5061] = 5061,
  [5062] = 5062,
  [5063] = 5063,
  [5064] = 5001,
  [5065] = 5065,
  [5066] = 5066,
  [5067] = 5067,
  [5068] = 5068,
  [5069] = 5069,
  [5070] = 5070,
  [5071] = 5071,
  [5072] = 5072,
  [5073] = 5073,
  [5074] = 4966,
  [5075] = 5075,
  [5076] = 5076,
  [5077] = 5077,
  [5078] = 5070,
  [5079] = 5079,
  [5080] = 5080,
  [5081] = 5081,
  [5082] = 5082,
  [5083] = 5083,
  [5084] = 5084,
  [5085] = 5085,
  [5086] = 5086,
  [5087] = 5087,
  [5088] = 5088,
  [5089] = 5008,
  [5090] = 5090,
  [5091] = 5010,
  [5092] = 5092,
  [5093] = 5093,
  [5094] = 5094,
  [5095] = 5095,
  [5096] = 5096,
  [5097] = 3976,
  [5098] = 5098,
  [5099] = 5099,
  [5100] = 5100,
  [5101] = 5025,
  [5102] = 5102,
  [5103] = 5026,
  [5104] = 5104,
  [5105] = 5105,
  [5106] = 5106,
  [5107] = 5107,
  [5108] = 5108,
  [5109] = 5109,
  [5110] = 5110,
  [5111] = 5111,
  [5112] = 5112,
  [5113] = 5113,
  [5114] = 5114,
  [5115] = 5008,
  [5116] = 5116,
  [5117] = 5117,
  [5118] = 5001,
  [5119] = 5119,
  [5120] = 5120,
  [5121] = 5121,
  [5122] = 5122,
  [5123] = 5123,
  [5124] = 5124,
  [5125] = 5125,
  [5126] = 5126,
  [5127] = 5090,
  [5128] = 5128,
  [5129] = 5129,
  [5130] = 5130,
  [5131] = 5131,
  [5132] = 4968,
  [5133] = 5009,
  [5134] = 5022,
  [5135] = 5010,
  [5136] = 5025,
  [5137] = 5026,
  [5138] = 5138,
  [5139] = 5139,
  [5140] = 810,
  [5141] = 5141,
  [5142] = 5142,
  [5143] = 5143,
  [5144] = 5144,
  [5145] = 5145,
  [5146] = 5146,
  [5147] = 5011,
  [5148] = 5039,
  [5149] = 5149,
  [5150] = 5041,
  [5151] = 5151,
  [5152] = 5152,
  [5153] = 5153,
  [5154] = 5154,
  [5155] = 5155,
  [5156] = 5156,
  [5157] = 5039,
  [5158] = 5158,
  [5159] = 5159,
  [5160] = 5160,
  [5161] = 5161,
  [5162] = 5162,
  [5163] = 5163,
  [5164] = 4991,
  [5165] = 5165,
  [5166] = 5166,
  [5167] = 5167,
  [5168] = 5168,
  [5169] = 5169,
  [5170] = 5170,
  [5171] = 5171,
  [5172] = 5172,
  [5173] = 5173,
  [5174] = 5036,
  [5175] = 5175,
  [5176] = 5176,
  [5177] = 5177,
  [5178] = 4968,
  [5179] = 5179,
  [5180] = 5180,
  [5181] = 5181,
  [5182] = 5182,
  [5183] = 5009,
  [5184] = 5184,
  [5185] = 5185,
  [5186] = 5186,
  [5187] = 5022,
  [5188] = 5001,
  [5189] = 5189,
  [5190] = 5190,
  [5191] = 3983,
  [5192] = 5063,
  [5193] = 5011,
  [5194] = 5194,
  [5195] = 5195,
  [5196] = 5196,
  [5197] = 5197,
  [5198] = 4968,
  [5199] = 5009,
  [5200] = 5022,
  [5201] = 5025,
  [5202] = 5026,
  [5203] = 5025,
  [5204] = 5026,
  [5205] = 5205,
  [5206] = 5206,
  [5207] = 5080,
  [5208] = 5084,
  [5209] = 5086,
  [5210] = 5088,
  [5211] = 5092,
  [5212] = 5212,
  [5213] = 5213,
  [5214] = 5214,
  [5215] = 5039,
  [5216] = 5216,
  [5217] = 5041,
  [5218] = 5218,
  [5219] = 5219,
  [5220] = 5220,
  [5221] = 5221,
  [5222] = 5222,
  [5223] = 5223,
  [5224] = 5041,
  [5225] = 5225,
  [5226] = 5226,
  [5227] = 5227,
  [5228] = 5228,
  [5229] = 5229,
  [5230] = 5230,
  [5231] = 5231,
  [5232] = 5232,
  [5233] = 5233,
  [5234] = 5234,
  [5235] = 5235,
  [5236] = 5236,
  [5237] = 5237,
  [5238] = 5238,
  [5239] = 5239,
  [5240] = 5240,
  [5241] = 5241,
  [5242] = 5242,
  [5243] = 5243,
  [5244] = 5244,
  [5245] = 5245,
  [5246] = 5246,
  [5247] = 5247,
  [5248] = 5248,
  [5249] = 5249,
  [5250] = 5250,
  [5251] = 5251,
  [5252] = 5149,
  [5253] = 5253,
  [5254] = 5254,
  [5255] = 5255,
  [5256] = 5256,
  [5257] = 5022,
  [5258] = 5258,
  [5259] = 5025,
  [5260] = 5026,
  [5261] = 5261,
  [5262] = 5262,
  [5263] = 5041,
  [5264] = 5264,
  [5265] = 5265,
  [5266] = 5266,
  [5267] = 5027,
  [5268] = 5268,
  [5269] = 5269,
  [5270] = 5270,
  [5271] = 5152,
  [5272] = 5030,
  [5273] = 5025,
  [5274] = 5026,
  [5275] = 5275,
  [5276] = 5033,
  [5277] = 5277,
  [5278] = 5041,
  [5279] = 5279,
  [5280] = 4956,
  [5281] = 5281,
  [5282] = 5282,
  [5283] = 5283,
  [5284] = 5284,
  [5285] = 5036,
  [5286] = 5286,
  [5287] = 5287,
  [5288] = 5025,
  [5289] = 5026,
  [5290] = 5041,
  [5291] = 5291,
  [5292] = 5154,
  [5293] = 5293,
  [5294] = 5294,
  [5295] = 4344,
  [5296] = 5296,
  [5297] = 5297,
  [5298] = 5298,
  [5299] = 5299,
  [5300] = 5300,
  [5301] = 5301,
  [5302] = 5001,
  [5303] = 5303,
  [5304] = 5304,
  [5305] = 5305,
  [5306] = 5306,
  [5307] = 5307,
  [5308] = 5308,
  [5309] = 5309,
  [5310] = 5310,
  [5311] = 5311,
  [5312] = 5104,
  [5313] = 5313,
  [5314] = 5314,
  [5315] = 5080,
  [5316] = 5316,
  [5317] = 5001,
  [5318] = 5084,
  [5319] = 5319,
  [5320] = 5320,
  [5321] = 4976,
  [5322] = 5322,
  [5323] = 5323,
  [5324] = 5086,
  [5325] = 5325,
  [5326] = 5326,
  [5327] = 5327,
  [5328] = 5328,
  [5329] = 5329,
  [5330] = 5330,
  [5331] = 5331,
  [5332] = 4986,
  [5333] = 5098,
  [5334] = 5334,
  [5335] = 5335,
  [5336] = 5336,
  [5337] = 5337,
  [5338] = 5338,
  [5339] = 5339,
  [5340] = 5340,
  [5341] = 5341,
  [5342] = 5342,
  [5343] = 5343,
  [5344] = 5344,
  [5345] = 5345,
  [5346] = 5346,
  [5347] = 5044,
  [5348] = 5009,
  [5349] = 5349,
  [5350] = 5350,
  [5351] = 5351,
  [5352] = 5352,
  [5353] = 5045,
  [5354] = 5354,
  [5355] = 5355,
  [5356] = 5356,
  [5357] = 5357,
  [5358] = 5358,
  [5359] = 5220,
  [5360] = 5360,
  [5361] = 5039,
  [5362] = 5362,
  [5363] = 5363,
  [5364] = 5364,
  [5365] = 5114,
  [5366] = 5366,
  [5367] = 5367,
  [5368] = 5368,
  [5369] = 5369,
  [5370] = 5370,
  [5371] = 5371,
  [5372] = 5372,
  [5373] = 5373,
  [5374] = 5041,
  [5375] = 5375,
  [5376] = 5376,
  [5377] = 5377,
  [5378] = 5378,
  [5379] = 5379,
  [5380] = 5380,
  [5381] = 5381,
  [5382] = 5382,
  [5383] = 5383,
  [5384] = 5384,
  [5385] = 5385,
  [5386] = 5386,
  [5387] = 5387,
  [5388] = 5388,
  [5389] = 5389,
  [5390] = 5390,
  [5391] = 5391,
  [5392] = 5392,
  [5393] = 5393,
  [5394] = 5394,
  [5395] = 5395,
  [5396] = 5396,
  [5397] = 5044,
  [5398] = 5045,
  [5399] = 5399,
  [5400] = 5400,
  [5401] = 5401,
  [5402] = 5402,
  [5403] = 5403,
  [5404] = 5032,
  [5405] = 5405,
  [5406] = 5406,
  [5407] = 5407,
  [5408] = 5408,
  [5409] = 5409,
  [5410] = 5410,
  [5411] = 5411,
  [5412] = 5046,
  [5413] = 5413,
  [5414] = 5046,
  [5415] = 5415,
  [5416] = 5416,
  [5417] = 5417,
  [5418] = 5048,
  [5419] = 5048,
  [5420] = 5420,
  [5421] = 5421,
  [5422] = 5422,
  [5423] = 4455,
  [5424] = 4977,
  [5425] = 5425,
  [5426] = 5426,
  [5427] = 5427,
  [5428] = 5428,
  [5429] = 5429,
  [5430] = 5430,
  [5431] = 5431,
  [5432] = 5432,
  [5433] = 5433,
  [5434] = 5434,
  [5435] = 3923,
  [5436] = 5436,
  [5437] = 3916,
  [5438] = 5438,
  [5439] = 5439,
  [5440] = 4986,
  [5441] = 5098,
  [5442] = 5442,
  [5443] = 5443,
  [5444] = 5444,
  [5445] = 5445,
  [5446] = 5446,
  [5447] = 5447,
  [5448] = 5448,
  [5449] = 5449,
  [5450] = 5450,
  [5451] = 5451,
  [5452] = 5452,
  [5453] = 5380,
  [5454] = 5454,
  [5455] = 5455,
  [5456] = 5456,
  [5457] = 5457,
  [5458] = 5458,
  [5459] = 5459,
  [5460] = 5460,
  [5461] = 3920,
  [5462] = 5462,
  [5463] = 5463,
  [5464] = 5464,
  [5465] = 5465,
  [5466] = 5466,
  [5467] = 5467,
  [5468] = 5468,
  [5469] = 5469,
  [5470] = 5470,
  [5471] = 5471,
  [5472] = 5472,
  [5473] = 5473,
  [5474] = 5474,
  [5475] = 5475,
  [5476] = 5476,
  [5477] = 4978,
  [5478] = 4962,
  [5479] = 5479,
  [5480] = 5480,
  [5481] = 5481,
  [5482] = 4965,
  [5483] = 5483,
  [5484] = 5484,
  [5485] = 5485,
  [5486] = 5486,
  [5487] = 5487,
  [5488] = 5488,
  [5489] = 5489,
  [5490] = 5490,
  [5491] = 4983,
  [5492] = 5492,
  [5493] = 5493,
  [5494] = 5494,
  [5495] = 5495,
  [5496] = 5496,
  [5497] = 5497,
  [5498] = 5498,
  [5499] = 5499,
  [5500] = 5500,
  [5501] = 5501,
  [5502] = 5244,
  [5503] = 5503,
  [5504] = 5504,
  [5505] = 5505,
  [5506] = 5506,
  [5507] = 5507,
  [5508] = 5508,
  [5509] = 5509,
  [5510] = 5510,
  [5511] = 5511,
  [5512] = 5512,
  [5513] = 5513,
  [5514] = 5122,
  [5515] = 5373,
  [5516] = 5516,
  [5517] = 5517,
  [5518] = 5518,
  [5519] = 1792,
  [5520] = 5009,
  [5521] = 5521,
  [5522] = 5522,
  [5523] = 5523,
  [5524] = 5524,
  [5525] = 1798,
  [5526] = 5526,
  [5527] = 5527,
  [5528] = 5528,
  [5529] = 5529,
  [5530] = 5530,
  [5531] = 5531,
  [5532] = 5532,
  [5533] = 5533,
  [5534] = 5534,
  [5535] = 5535,
  [5536] = 5536,
  [5537] = 5537,
  [5538] = 5538,
  [5539] = 5539,
  [5540] = 5540,
  [5541] = 5541,
  [5542] = 5542,
  [5543] = 5543,
  [5544] = 5544,
  [5545] = 5545,
  [5546] = 5546,
  [5547] = 5547,
  [5548] = 5548,
  [5549] = 5549,
  [5550] = 5550,
  [5551] = 5551,
  [5552] = 5305,
  [5553] = 5553,
  [5554] = 5554,
  [5555] = 5555,
  [5556] = 5556,
  [5557] = 5557,
  [5558] = 5558,
  [5559] = 5559,
  [5560] = 5560,
  [5561] = 4559,
  [5562] = 5562,
  [5563] = 5563,
  [5564] = 5564,
  [5565] = 5565,
  [5566] = 5566,
  [5567] = 5567,
  [5568] = 5568,
  [5569] = 5569,
  [5570] = 5570,
  [5571] = 5571,
  [5572] = 5572,
  [5573] = 5573,
  [5574] = 5066,
  [5575] = 5575,
  [5576] = 4988,
  [5577] = 5577,
  [5578] = 5578,
  [5579] = 5579,
  [5580] = 5580,
  [5581] = 5581,
  [5582] = 5582,
  [5583] = 5583,
  [5584] = 5584,
  [5585] = 5585,
  [5586] = 5586,
  [5587] = 5587,
  [5588] = 5588,
  [5589] = 5589,
  [5590] = 5590,
  [5591] = 5591,
  [5592] = 5592,
  [5593] = 5593,
  [5594] = 5594,
  [5595] = 5595,
  [5596] = 5596,
  [5597] = 5122,
  [5598] = 5598,
  [5599] = 5599,
  [5600] = 5600,
  [5601] = 5601,
  [5602] = 5602,
  [5603] = 5603,
  [5604] = 5604,
  [5605] = 5605,
  [5606] = 5606,
  [5607] = 5607,
  [5608] = 5608,
  [5609] = 5609,
  [5610] = 5610,
  [5611] = 5611,
  [5612] = 5612,
  [5613] = 5613,
  [5614] = 5614,
  [5615] = 5615,
  [5616] = 5616,
  [5617] = 5236,
  [5618] = 5618,
  [5619] = 5088,
  [5620] = 5620,
  [5621] = 2072,
  [5622] = 5622,
  [5623] = 2078,
  [5624] = 5624,
  [5625] = 5625,
  [5626] = 5626,
  [5627] = 5627,
  [5628] = 5628,
  [5629] = 5629,
  [5630] = 5630,
  [5631] = 5631,
  [5632] = 5632,
  [5633] = 5633,
  [5634] = 5634,
  [5635] = 5635,
  [5636] = 5636,
  [5637] = 5637,
  [5638] = 5638,
  [5639] = 5639,
  [5640] = 5640,
  [5641] = 5641,
  [5642] = 5642,
  [5643] = 5643,
  [5644] = 5644,
  [5645] = 5645,
  [5646] = 5646,
  [5647] = 5647,
  [5648] = 5648,
  [5649] = 5649,
  [5650] = 5650,
  [5651] = 5651,
  [5652] = 5652,
  [5653] = 5653,
  [5654] = 5654,
  [5655] = 5655,
  [5656] = 2047,
  [5657] = 5657,
  [5658] = 5658,
  [5659] = 5659,
  [5660] = 2001,
  [5661] = 5661,
  [5662] = 2046,
  [5663] = 5629,
  [5664] = 5664,
  [5665] = 5665,
  [5666] = 5666,
  [5667] = 5667,
  [5668] = 5668,
  [5669] = 5669,
  [5670] = 5670,
  [5671] = 5671,
  [5672] = 5672,
  [5673] = 2004,
  [5674] = 5674,
  [5675] = 5675,
  [5676] = 5654,
  [5677] = 5677,
  [5678] = 5678,
  [5679] = 5679,
  [5680] = 5680,
  [5681] = 5627,
  [5682] = 5682,
  [5683] = 5683,
  [5684] = 5684,
  [5685] = 5685,
  [5686] = 5647,
  [5687] = 5665,
  [5688] = 5688,
  [5689] = 5670,
  [5690] = 5690,
  [5691] = 2027,
  [5692] = 5692,
  [5693] = 5644,
  [5694] = 5694,
  [5695] = 5679,
  [5696] = 5696,
  [5697] = 5697,
  [5698] = 5698,
  [5699] = 5699,
  [5700] = 5700,
  [5701] = 5701,
  [5702] = 5702,
  [5703] = 5703,
  [5704] = 2031,
  [5705] = 5705,
  [5706] = 5706,
  [5707] = 5707,
  [5708] = 5708,
  [5709] = 5709,
  [5710] = 5710,
  [5711] = 5678,
  [5712] = 5712,
  [5713] = 5713,
  [5714] = 5626,
  [5715] = 5630,
  [5716] = 5716,
  [5717] = 5717,
  [5718] = 5718,
  [5719] = 5719,
  [5720] = 5720,
  [5721] = 5721,
  [5722] = 5722,
  [5723] = 5697,
  [5724] = 5672,
  [5725] = 3112,
  [5726] = 4188,
  [5727] = 2048,
  [5728] = 2049,
  [5729] = 5729,
  [5730] = 4249,
  [5731] = 5731,
  [5732] = 4204,
  [5733] = 5733,
  [5734] = 5734,
  [5735] = 2044,
  [5736] = 5692,
  [5737] = 4216,
  [5738] = 5738,
  [5739] = 5696,
  [5740] = 5707,
  [5741] = 5741,
  [5742] = 5742,
  [5743] = 5743,
  [5744] = 5744,
  [5745] = 5745,
  [5746] = 5700,
  [5747] = 5747,
  [5748] = 5748,
  [5749] = 5706,
  [5750] = 5750,
  [5751] = 5751,
  [5752] = 5752,
  [5753] = 5753,
  [5754] = 5754,
  [5755] = 5755,
  [5756] = 5756,
  [5757] = 5756,
  [5758] = 5758,
  [5759] = 5666,
  [5760] = 5637,
  [5761] = 5761,
  [5762] = 5762,
  [5763] = 5763,
  [5764] = 5764,
  [5765] = 5765,
  [5766] = 5766,
  [5767] = 5767,
  [5768] = 5768,
  [5769] = 5765,
  [5770] = 5770,
  [5771] = 2070,
  [5772] = 5772,
  [5773] = 5738,
  [5774] = 5641,
  [5775] = 5668,
  [5776] = 5776,
  [5777] = 5665,
  [5778] = 5638,
  [5779] = 5779,
  [5780] = 5780,
  [5781] = 5685,
  [5782] = 5782,
  [5783] = 5648,
  [5784] = 5653,
  [5785] = 5785,
  [5786] = 5705,
  [5787] = 5770,
  [5788] = 5788,
  [5789] = 5789,
  [5790] = 5790,
  [5791] = 5756,
  [5792] = 5713,
  [5793] = 5718,
  [5794] = 5794,
  [5795] = 5795,
  [5796] = 5796,
  [5797] = 5678,
  [5798] = 5798,
  [5799] = 5799,
  [5800] = 5800,
  [5801] = 5647,
  [5802] = 5690,
  [5803] = 5638,
  [5804] = 2067,
  [5805] = 5805,
  [5806] = 5806,
  [5807] = 5750,
  [5808] = 5808,
  [5809] = 5632,
  [5810] = 5810,
  [5811] = 5731,
  [5812] = 5812,
  [5813] = 5633,
  [5814] = 5814,
  [5815] = 5690,
  [5816] = 5816,
  [5817] = 5698,
  [5818] = 5699,
  [5819] = 5819,
  [5820] = 5722,
  [5821] = 2778,
  [5822] = 2855,
  [5823] = 5734,
  [5824] = 5647,
  [5825] = 5825,
  [5826] = 5742,
  [5827] = 5620,
  [5828] = 5828,
  [5829] = 5644,
  [5830] = 5750,
  [5831] = 5751,
  [5832] = 5752,
  [5833] = 5833,
  [5834] = 5776,
  [5835] = 5762,
  [5836] = 5812,
  [5837] = 5665,
  [5838] = 5816,
  [5839] = 5712,
  [5840] = 5819,
  [5841] = 5841,
  [5842] = 5748,
  [5843] = 5828,
  [5844] = 5692,
  [5845] = 2803,
  [5846] = 5696,
  [5847] = 5700,
  [5848] = 5690,
  [5849] = 5849,
  [5850] = 5706,
  [5851] = 5851,
  [5852] = 5852,
  [5853] = 5853,
  [5854] = 5692,
  [5855] = 5696,
  [5856] = 5856,
  [5857] = 5700,
  [5858] = 5858,
  [5859] = 5706,
  [5860] = 2029,
  [5861] = 5861,
  [5862] = 5862,
  [5863] = 5862,
  [5864] = 5864,
  [5865] = 5640,
  [5866] = 5697,
  [5867] = 5867,
  [5868] = 5665,
  [5869] = 5869,
  [5870] = 5870,
  [5871] = 5871,
  [5872] = 5872,
  [5873] = 5873,
  [5874] = 5665,
  [5875] = 5651,
  [5876] = 5812,
  [5877] = 5877,
  [5878] = 5741,
  [5879] = 5879,
  [5880] = 5880,
  [5881] = 5819,
  [5882] = 5862,
  [5883] = 5666,
  [5884] = 2856,
  [5885] = 5765,
  [5886] = 5886,
  [5887] = 5789,
  [5888] = 5718,
  [5889] = 5889,
  [5890] = 5890,
  [5891] = 5891,
  [5892] = 5892,
  [5893] = 2077,
  [5894] = 5894,
  [5895] = 5895,
  [5896] = 5671,
  [5897] = 5897,
  [5898] = 5898,
  [5899] = 5642,
  [5900] = 5788,
  [5901] = 5901,
  [5902] = 5806,
  [5903] = 5667,
  [5904] = 5904,
  [5905] = 5905,
  [5906] = 5877,
  [5907] = 5907,
  [5908] = 5908,
  [5909] = 5901,
  [5910] = 5805,
  [5911] = 5911,
  [5912] = 5912,
  [5913] = 5913,
  [5914] = 5914,
  [5915] = 5915,
  [5916] = 5767,
  [5917] = 5917,
  [5918] = 5698,
  [5919] = 5699,
  [5920] = 5920,
  [5921] = 5741,
  [5922] = 5922,
  [5923] = 5923,
  [5924] = 5667,
  [5925] = 5765,
  [5926] = 5701,
  [5927] = 5755,
  [5928] = 5643,
  [5929] = 5722,
  [5930] = 5789,
  [5931] = 5905,
  [5932] = 5932,
  [5933] = 5933,
  [5934] = 5789,
  [5935] = 5935,
  [5936] = 5808,
  [5937] = 5741,
  [5938] = 5765,
  [5939] = 5789,
  [5940] = 5940,
  [5941] = 5743,
  [5942] = 5911,
  [5943] = 5943,
  [5944] = 5716,
  [5945] = 5713,
  [5946] = 5812,
  [5947] = 2041,
  [5948] = 5625,
  [5949] = 2057,
  [5950] = 5950,
  [5951] = 2025,
  [5952] = 5626,
  [5953] = 5953,
  [5954] = 5819,
  [5955] = 5828,
  [5956] = 5717,
  [5957] = 5641,
  [5958] = 5920,
  [5959] = 2079,
  [5960] = 2023,
  [5961] = 5622,
  [5962] = 5635,
  [5963] = 5943,
  [5964] = 5964,
  [5965] = 5965,
  [5966] = 5629,
  [5967] = 5675,
  [5968] = 5968,
  [5969] = 5862,
  [5970] = 5970,
  [5971] = 5741,
  [5972] = 5636,
  [5973] = 5950,
  [5974] = 2038,
  [5975] = 5953,
  [5976] = 5751,
  [5977] = 5977,
  [5978] = 5765,
  [5979] = 5979,
  [5980] = 5980,
  [5981] = 5649,
  [5982] = 3092,
  [5983] = 5980,
  [5984] = 5984,
  [5985] = 5639,
  [5986] = 5789,
  [5987] = 5987,
  [5988] = 5988,
  [5989] = 5750,
  [5990] = 5990,
  [5991] = 5984,
  [5992] = 5625,
  [5993] = 5751,
  [5994] = 5994,
  [5995] = 5648,
  [5996] = 5752,
  [5997] = 5653,
  [5998] = 5998,
  [5999] = 5999,
  [6000] = 6000,
  [6001] = 6001,
  [6002] = 5685,
  [6003] = 6003,
  [6004] = 6004,
  [6005] = 6005,
  [6006] = 6006,
  [6007] = 6007,
  [6008] = 5741,
  [6009] = 6009,
  [6010] = 5788,
  [6011] = 5806,
  [6012] = 5752,
  [6013] = 6013,
  [6014] = 1973,
  [6015] = 6015,
  [6016] = 5655,
  [6017] = 5721,
  [6018] = 5750,
  [6019] = 5751,
  [6020] = 5752,
  [6021] = 6021,
  [6022] = 5738,
  [6023] = 6023,
  [6024] = 2021,
  [6025] = 3093,
  [6026] = 5901,
  [6027] = 5767,
  [6028] = 6028,
  [6029] = 5692,
  [6030] = 2045,
  [6031] = 5696,
  [6032] = 5700,
  [6033] = 5667,
  [6034] = 5780,
  [6035] = 5706,
  [6036] = 5923,
  [6037] = 5701,
  [6038] = 5935,
  [6039] = 5636,
  [6040] = 6040,
  [6041] = 5984,
  [6042] = 5665,
  [6043] = 5636,
  [6044] = 5984,
  [6045] = 5908,
  [6046] = 2056,
  [6047] = 5901,
  [6048] = 6048,
  [6049] = 5798,
  [6050] = 5741,
  [6051] = 5768,
  [6052] = 5765,
  [6053] = 5799,
  [6054] = 5719,
  [6055] = 5770,
  [6056] = 5789,
  [6057] = 5640,
  [6058] = 5914,
  [6059] = 5768,
  [6060] = 6023,
  [6061] = 6061,
  [6062] = 6062,
  [6063] = 6063,
  [6064] = 6064,
  [6065] = 6065,
  [6066] = 6066,
  [6067] = 6067,
  [6068] = 6068,
  [6069] = 6069,
  [6070] = 6070,
  [6071] = 6071,
  [6072] = 6072,
  [6073] = 6073,
  [6074] = 6074,
  [6075] = 6075,
  [6076] = 6076,
  [6077] = 6077,
  [6078] = 6078,
  [6079] = 6070,
  [6080] = 6080,
  [6081] = 6081,
  [6082] = 6082,
  [6083] = 6083,
  [6084] = 6084,
  [6085] = 6085,
  [6086] = 6086,
  [6087] = 6085,
  [6088] = 6088,
  [6089] = 6089,
  [6090] = 6090,
  [6091] = 6091,
  [6092] = 6092,
  [6093] = 6093,
  [6094] = 6094,
  [6095] = 6095,
  [6096] = 6096,
  [6097] = 6097,
  [6098] = 6098,
  [6099] = 6099,
  [6100] = 6100,
  [6101] = 6101,
  [6102] = 6102,
  [6103] = 6103,
  [6104] = 6104,
  [6105] = 6105,
  [6106] = 6106,
  [6107] = 6107,
  [6108] = 6063,
  [6109] = 6109,
  [6110] = 6085,
  [6111] = 6111,
  [6112] = 6112,
  [6113] = 6090,
  [6114] = 6114,
  [6115] = 6091,
  [6116] = 6116,
  [6117] = 6117,
  [6118] = 6093,
  [6119] = 6119,
  [6120] = 6095,
  [6121] = 6097,
  [6122] = 6122,
  [6123] = 6098,
  [6124] = 6124,
  [6125] = 6102,
  [6126] = 6126,
  [6127] = 6107,
  [6128] = 6128,
  [6129] = 6109,
  [6130] = 6130,
  [6131] = 6131,
  [6132] = 6092,
  [6133] = 6122,
  [6134] = 6134,
  [6135] = 6122,
  [6136] = 6136,
  [6137] = 6094,
  [6138] = 6138,
  [6139] = 6139,
  [6140] = 6140,
  [6141] = 6141,
  [6142] = 6064,
  [6143] = 6143,
  [6144] = 6071,
  [6145] = 6145,
  [6146] = 6146,
  [6147] = 6104,
  [6148] = 6148,
  [6149] = 6073,
  [6150] = 6074,
  [6151] = 6112,
  [6152] = 6128,
  [6153] = 6153,
  [6154] = 6154,
  [6155] = 6155,
  [6156] = 6156,
  [6157] = 6066,
  [6158] = 6158,
  [6159] = 6075,
  [6160] = 6103,
  [6161] = 6075,
  [6162] = 6162,
  [6163] = 6163,
  [6164] = 6164,
  [6165] = 6165,
  [6166] = 6102,
  [6167] = 6167,
  [6168] = 6088,
  [6169] = 6063,
  [6170] = 6170,
  [6171] = 6107,
  [6172] = 6100,
  [6173] = 6090,
  [6174] = 6099,
  [6175] = 6065,
  [6176] = 6070,
  [6177] = 6177,
  [6178] = 6065,
  [6179] = 6088,
  [6180] = 6067,
  [6181] = 6141,
  [6182] = 6182,
  [6183] = 6072,
  [6184] = 6184,
  [6185] = 6185,
  [6186] = 6101,
  [6187] = 6154,
  [6188] = 6096,
  [6189] = 6088,
  [6190] = 6063,
  [6191] = 6191,
  [6192] = 6064,
  [6193] = 6155,
  [6194] = 6131,
  [6195] = 6156,
  [6196] = 6196,
  [6197] = 6064,
  [6198] = 6096,
  [6199] = 6063,
  [6200] = 6073,
  [6201] = 6104,
  [6202] = 6202,
  [6203] = 6100,
  [6204] = 6074,
  [6205] = 6205,
  [6206] = 6070,
  [6207] = 6207,
  [6208] = 6112,
  [6209] = 6128,
  [6210] = 6154,
  [6211] = 6065,
  [6212] = 6212,
  [6213] = 6067,
  [6214] = 6105,
  [6215] = 6155,
  [6216] = 6067,
  [6217] = 6217,
  [6218] = 6109,
  [6219] = 6066,
  [6220] = 6156,
  [6221] = 6103,
  [6222] = 6061,
  [6223] = 6158,
  [6224] = 6066,
  [6225] = 6091,
  [6226] = 6156,
  [6227] = 6102,
  [6228] = 6153,
  [6229] = 6093,
  [6230] = 6103,
  [6231] = 6105,
  [6232] = 6106,
  [6233] = 6068,
  [6234] = 6138,
  [6235] = 6065,
  [6236] = 6066,
  [6237] = 6103,
  [6238] = 6078,
  [6239] = 6239,
  [6240] = 6153,
  [6241] = 6081,
  [6242] = 6070,
  [6243] = 6071,
  [6244] = 6244,
  [6245] = 6072,
  [6246] = 6130,
  [6247] = 6116,
  [6248] = 6096,
  [6249] = 6249,
  [6250] = 6250,
  [6251] = 6122,
  [6252] = 6158,
  [6253] = 6100,
  [6254] = 6067,
  [6255] = 6061,
  [6256] = 6256,
  [6257] = 6075,
  [6258] = 6258,
  [6259] = 6104,
  [6260] = 6106,
  [6261] = 6107,
  [6262] = 6262,
  [6263] = 6134,
  [6264] = 6158,
  [6265] = 6162,
  [6266] = 6163,
  [6267] = 6164,
  [6268] = 6061,
  [6269] = 6114,
  [6270] = 6109,
  [6271] = 6098,
  [6272] = 6081,
  [6273] = 6273,
  [6274] = 6274,
  [6275] = 6100,
  [6276] = 6095,
  [6277] = 6143,
  [6278] = 6100,
  [6279] = 6158,
  [6280] = 6162,
  [6281] = 6182,
  [6282] = 6138,
  [6283] = 6061,
  [6284] = 6146,
  [6285] = 6075,
  [6286] = 6286,
  [6287] = 6287,
  [6288] = 6274,
  [6289] = 6078,
  [6290] = 6077,
  [6291] = 6075,
  [6292] = 6073,
  [6293] = 6293,
  [6294] = 6074,
  [6295] = 6163,
  [6296] = 6296,
  [6297] = 6191,
  [6298] = 6177,
  [6299] = 6162,
  [6300] = 6077,
  [6301] = 6301,
  [6302] = 6081,
  [6303] = 6116,
  [6304] = 6146,
  [6305] = 6305,
  [6306] = 6306,
  [6307] = 6101,
  [6308] = 6308,
  [6309] = 6164,
  [6310] = 6092,
  [6311] = 6311,
  [6312] = 6312,
  [6313] = 6097,
  [6314] = 6143,
  [6315] = 6315,
  [6316] = 6076,
  [6317] = 6317,
  [6318] = 6318,
  [6319] = 6136,
  [6320] = 6153,
  [6321] = 6085,
  [6322] = 6090,
  [6323] = 6315,
  [6324] = 6077,
  [6325] = 6162,
  [6326] = 6088,
  [6327] = 6063,
  [6328] = 6328,
  [6329] = 6329,
  [6330] = 6070,
  [6331] = 6163,
  [6332] = 6164,
  [6333] = 6333,
  [6334] = 6138,
  [6335] = 6122,
  [6336] = 6336,
  [6337] = 6333,
  [6338] = 6081,
  [6339] = 6339,
  [6340] = 6116,
  [6341] = 6158,
  [6342] = 6091,
  [6343] = 6097,
  [6344] = 6344,
  [6345] = 6143,
  [6346] = 6116,
  [6347] = 6093,
  [6348] = 6095,
  [6349] = 6100,
  [6350] = 6084,
  [6351] = 6106,
  [6352] = 6352,
  [6353] = 6094,
  [6354] = 6244,
  [6355] = 6112,
  [6356] = 6141,
  [6357] = 6131,
  [6358] = 6158,
  [6359] = 6077,
  [6360] = 6097,
  [6361] = 6361,
  [6362] = 6138,
  [6363] = 6141,
  [6364] = 6098,
  [6365] = 6146,
  [6366] = 6258,
  [6367] = 6077,
  [6368] = 6368,
  [6369] = 6352,
  [6370] = 6370,
  [6371] = 6102,
  [6372] = 6101,
  [6373] = 6373,
  [6374] = 6146,
  [6375] = 6239,
  [6376] = 6101,
  [6377] = 6377,
  [6378] = 6162,
  [6379] = 6107,
  [6380] = 6380,
  [6381] = 6096,
  [6382] = 6104,
  [6383] = 6239,
  [6384] = 6109,
  [6385] = 6385,
  [6386] = 6386,
  [6387] = 6122,
  [6388] = 6388,
  [6389] = 6389,
  [6390] = 6106,
  [6391] = 6287,
  [6392] = 6256,
  [6393] = 6082,
  [6394] = 6083,
  [6395] = 6395,
  [6396] = 6143,
  [6397] = 6146,
  [6398] = 6077,
  [6399] = 6131,
  [6400] = 6146,
  [6401] = 6124,
  [6402] = 6402,
  [6403] = 6096,
  [6404] = 6239,
  [6405] = 6104,
  [6406] = 6122,
  [6407] = 6407,
  [6408] = 6145,
  [6409] = 6128,
  [6410] = 6410,
  [6411] = 6158,
  [6412] = 6061,
  [6413] = 6069,
  [6414] = 6075,
  [6415] = 6162,
  [6416] = 6163,
  [6417] = 6164,
  [6418] = 6101,
  [6419] = 6082,
  [6420] = 6131,
  [6421] = 6239,
  [6422] = 6098,
  [6423] = 6423,
  [6424] = 6061,
  [6425] = 6100,
  [6426] = 6426,
  [6427] = 6061,
  [6428] = 6317,
  [6429] = 6145,
  [6430] = 6138,
  [6431] = 6431,
  [6432] = 6296,
  [6433] = 6433,
  [6434] = 6084,
  [6435] = 6141,
  [6436] = 6154,
  [6437] = 6437,
  [6438] = 6155,
  [6439] = 6439,
  [6440] = 6081,
  [6441] = 6163,
  [6442] = 6442,
  [6443] = 6086,
  [6444] = 6134,
  [6445] = 6182,
  [6446] = 6287,
  [6447] = 6163,
  [6448] = 6114,
  [6449] = 6164,
  [6450] = 6075,
  [6451] = 6244,
  [6452] = 6065,
  [6453] = 6191,
  [6454] = 6177,
  [6455] = 6455,
  [6456] = 6086,
  [6457] = 6315,
  [6458] = 6101,
  [6459] = 6317,
  [6460] = 6460,
  [6461] = 6136,
  [6462] = 6064,
  [6463] = 6116,
  [6464] = 6333,
  [6465] = 6256,
  [6466] = 6439,
  [6467] = 6385,
  [6468] = 6158,
  [6469] = 6073,
  [6470] = 6182,
  [6471] = 6061,
  [6472] = 6074,
  [6473] = 6088,
  [6474] = 6063,
  [6475] = 6124,
  [6476] = 6075,
  [6477] = 6162,
  [6478] = 6182,
  [6479] = 6163,
  [6480] = 6130,
  [6481] = 6164,
  [6482] = 6258,
  [6483] = 6099,
  [6484] = 6182,
  [6485] = 6138,
  [6486] = 6486,
  [6487] = 6112,
  [6488] = 6312,
  [6489] = 6395,
  [6490] = 6153,
  [6491] = 6096,
  [6492] = 6104,
  [6493] = 6156,
  [6494] = 6128,
  [6495] = 6184,
  [6496] = 6162,
  [6497] = 6100,
  [6498] = 6164,
  [6499] = 6070,
  [6500] = 6154,
  [6501] = 6155,
  [6502] = 6163,
  [6503] = 6312,
  [6504] = 6395,
  [6505] = 6085,
  [6506] = 6090,
  [6507] = 6184,
  [6508] = 6395,
  [6509] = 6091,
  [6510] = 6093,
  [6511] = 6182,
  [6512] = 6164,
  [6513] = 6088,
  [6514] = 6095,
  [6515] = 6515,
};

static TSCharacterRange extras_character_set_1[] = {
  {'\t', '\r'}, {' ', ' '}, {0xa0, 0xa0}, {0x1680, 0x1680}, {0x2000, 0x200b}, {0x2028, 0x2029}, {0x202f, 0x202f}, {0x205f, 0x2060},
  {0x3000, 0x3000}, {0xfeff, 0xfeff},
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'$', '$'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f}, {0x1681, 0x1fff},
  {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'$', '$'}, {'0', '9'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f},
  {0x1681, 0x1fff}, {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(78);
      ADVANCE_MAP(
        '!', 91,
        '"', 171,
        '#', 8,
        '$', 208,
        '%', 151,
        '&', 130,
        '\'', 172,
        '(', 92,
        ')', 94,
        '*', 81,
        '+', 143,
        ',', 88,
        '-', 147,
        '.', 99,
        '/', 194,
        '0', 199,
        ':', 95,
        ';', 93,
        '<', 155,
        '=', 84,
        '>', 164,
        '?', 214,
        '@', 211,
        '[', 96,
        '\\', 36,
        ']', 97,
        '^', 133,
        '`', 192,
        '{', 87,
        '|', 136,
        '}', 89,
        '~', 168,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(76);
      if (lookahead > '@') ADVANCE(209);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(27);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '[') ADVANCE(35);
      if (lookahead == '\\') ADVANCE(75);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(195);
      if (lookahead != 0) ADVANCE(196);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 91,
        '"', 171,
        '#', 34,
        '%', 151,
        '&', 130,
        '\'', 172,
        '(', 92,
        ')', 94,
        '*', 81,
        '+', 142,
        ',', 88,
        '-', 146,
        '.', 99,
        '/', 149,
        '0', 199,
        ':', 95,
        ';', 93,
        '<', 155,
        '=', 84,
        '>', 164,
        '?', 214,
        '@', 211,
        '[', 96,
        '\\', 38,
        ']', 97,
        '^', 133,
        '`', 192,
        '{', 86,
        '|', 135,
        '}', 89,
        '~', 168,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(2);
      if (lookahead > '#') ADVANCE(209);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 91,
        '"', 171,
        '#', 34,
        '%', 150,
        '&', 131,
        '\'', 172,
        '(', 92,
        ')', 94,
        '*', 82,
        '+', 141,
        ',', 88,
        '-', 145,
        '.', 100,
        '/', 148,
        '0', 199,
        ':', 95,
        ';', 93,
        '<', 156,
        '=', 83,
        '>', 165,
        '?', 24,
        '@', 211,
        '[', 96,
        '\\', 38,
        ']', 97,
        '^', 132,
        '`', 192,
        '{', 86,
        '|', 137,
        '}', 89,
        '~', 168,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(3);
      if (lookahead > '#') ADVANCE(209);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 91,
        '"', 171,
        '%', 151,
        '&', 130,
        '\'', 172,
        '(', 92,
        ')', 94,
        '*', 81,
        '+', 142,
        ',', 88,
        '-', 146,
        '.', 98,
        '/', 149,
        ':', 95,
        ';', 93,
        '<', 155,
        '=', 84,
        '>', 164,
        '?', 214,
        '@', 211,
        '[', 96,
        '\\', 38,
        ']', 97,
        '^', 133,
        '`', 192,
        '{', 86,
        '|', 136,
        '}', 89,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(221);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(4);
      if (lookahead > '#' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(209);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 91,
        '%', 150,
        '&', 131,
        '(', 92,
        ')', 94,
        '*', 82,
        '+', 141,
        ',', 88,
        '-', 145,
        '.', 98,
        '/', 148,
        ':', 95,
        ';', 93,
        '<', 156,
        '=', 83,
        '>', 165,
        '?', 215,
        '@', 211,
        '[', 96,
        '\\', 38,
        ']', 97,
        '^', 132,
        '`', 192,
        '{', 86,
        '|', 138,
        '}', 89,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(5);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(209);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 91,
        '%', 150,
        '&', 131,
        '(', 92,
        ')', 94,
        '*', 82,
        '+', 141,
        ',', 88,
        '-', 145,
        '.', 98,
        '/', 148,
        ':', 95,
        ';', 93,
        '<', 156,
        '=', 31,
        '>', 165,
        '?', 24,
        '[', 96,
        '\\', 38,
        ']', 97,
        '^', 132,
        '`', 192,
        '{', 86,
        '|', 137,
        '}', 89,
      );
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(197);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(7);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '`' || '~' < lookahead)) ADVANCE(209);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 91,
        '%', 150,
        '&', 131,
        '(', 92,
        ')', 94,
        '*', 82,
        '+', 141,
        ',', 88,
        '-', 145,
        '.', 98,
        '/', 148,
        ':', 95,
        ';', 93,
        '<', 156,
        '=', 31,
        '>', 165,
        '?', 24,
        '[', 96,
        '\\', 38,
        ']', 97,
        '^', 132,
        '`', 192,
        '{', 86,
        '|', 137,
        '}', 89,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(7);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(209);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(79);
      if (lookahead == '\\') ADVANCE(37);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(210);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '!', 90,
        '"', 171,
        '#', 34,
        '&', 129,
        '\'', 172,
        '(', 92,
        ')', 94,
        '*', 80,
        '+', 141,
        ',', 88,
        '-', 145,
        '.', 99,
        '/', 148,
        '0', 199,
        ':', 95,
        ';', 93,
        '<', 154,
        '=', 85,
        '>', 163,
        '?', 212,
        '@', 211,
        '[', 96,
        '\\', 38,
        ']', 97,
        '`', 192,
        '{', 86,
        '|', 139,
        '}', 89,
        '~', 168,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(9);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead)) ADVANCE(209);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '!', 90,
        '"', 171,
        '#', 34,
        '&', 129,
        '\'', 172,
        '(', 92,
        ')', 94,
        '*', 80,
        '+', 141,
        ',', 88,
        '-', 145,
        '.', 23,
        '/', 148,
        '0', 199,
        '<', 154,
        '?', 212,
        '@', 211,
        '[', 96,
        '\\', 38,
        ']', 97,
        '`', 192,
        '{', 87,
        '|', 134,
        '~', 168,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(10);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(209);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '!', 90,
        '&', 129,
        '(', 92,
        ')', 94,
        ',', 88,
        '.', 98,
        '/', 20,
        ':', 95,
        ';', 93,
        '<', 154,
        '=', 85,
        '>', 163,
        '?', 212,
        '@', 211,
        '[', 96,
        '\\', 38,
        ']', 97,
        '{', 86,
        '|', 139,
        '}', 89,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(221);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(11);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(209);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '"', 171,
        '#', 34,
        '&', 129,
        '\'', 172,
        '(', 92,
        '*', 80,
        '+', 140,
        ',', 88,
        '-', 144,
        '.', 23,
        '/', 20,
        '0', 199,
        ';', 93,
        '<', 154,
        '>', 163,
        '?', 212,
        '@', 211,
        '[', 96,
        '\\', 38,
        ']', 97,
        '`', 192,
        '{', 87,
        '|', 139,
        '}', 89,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(12);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(209);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '"', 171,
        '#', 34,
        '\'', 172,
        '(', 92,
        '*', 80,
        '+', 140,
        ',', 88,
        '-', 144,
        '.', 23,
        '/', 20,
        '0', 199,
        ';', 93,
        '<', 154,
        '@', 211,
        '[', 96,
        '\\', 38,
        '{', 86,
        '|', 48,
        '}', 89,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(13);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(209);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        '"', 171,
        '&', 129,
        '\'', 172,
        '(', 92,
        ')', 94,
        '*', 80,
        ',', 88,
        '.', 98,
        '/', 20,
        ':', 95,
        ';', 93,
        '<', 154,
        '=', 85,
        '>', 163,
        '?', 213,
        '@', 211,
        '[', 96,
        '\\', 38,
        ']', 97,
        '{', 86,
        '|', 139,
        '}', 89,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(14);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(209);
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(171);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == '\\') ADVANCE(39);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(176);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 16:
      if (lookahead == '$') ADVANCE(40);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '\\') ADVANCE(39);
      if (lookahead == '`') ADVANCE(192);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(17);
      END_STATE();
    case 17:
      if (lookahead == '$') ADVANCE(40);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '`') ADVANCE(192);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(17);
      END_STATE();
    case 18:
      ADVANCE_MAP(
        '&', 129,
        '+', 32,
        ',', 88,
        '-', 33,
        '.', 98,
        '/', 20,
        ':', 95,
        '<', 154,
        '?', 30,
        '[', 96,
        '\\', 38,
        ']', 97,
        '{', 87,
        '|', 134,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(18);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(209);
      END_STATE();
    case 19:
      if (lookahead == '\'') ADVANCE(172);
      if (lookahead == '/') ADVANCE(179);
      if (lookahead == '\\') ADVANCE(39);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(182);
      if (lookahead != 0) ADVANCE(184);
      END_STATE();
    case 20:
      if (lookahead == '*') ADVANCE(22);
      if (lookahead == '/') ADVANCE(191);
      END_STATE();
    case 21:
      if (lookahead == '*') ADVANCE(21);
      if (lookahead == '/') ADVANCE(190);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 22:
      if (lookahead == '*') ADVANCE(21);
      if (lookahead != 0) ADVANCE(22);
      END_STATE();
    case 23:
      if (lookahead == '.') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 24:
      if (lookahead == '.') ADVANCE(102);
      if (lookahead == '?') ADVANCE(166);
      END_STATE();
    case 25:
      if (lookahead == '.') ADVANCE(118);
      END_STATE();
    case 26:
      if (lookahead == '/') ADVANCE(194);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(27);
      END_STATE();
    case 27:
      if (lookahead == '/') ADVANCE(20);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(27);
      END_STATE();
    case 28:
      if (lookahead == ':') ADVANCE(217);
      END_STATE();
    case 29:
      if (lookahead == ':') ADVANCE(216);
      END_STATE();
    case 30:
      if (lookahead == ':') ADVANCE(218);
      END_STATE();
    case 31:
      if (lookahead == '=') ADVANCE(158);
      END_STATE();
    case 32:
      if (lookahead == '?') ADVANCE(28);
      END_STATE();
    case 33:
      if (lookahead == '?') ADVANCE(29);
      END_STATE();
    case 34:
      if (lookahead == '\\') ADVANCE(37);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(210);
      END_STATE();
    case 35:
      if (lookahead == '\\') ADVANCE(74);
      if (lookahead == ']') ADVANCE(196);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(35);
      END_STATE();
    case 36:
      if (lookahead == 'u') ADVANCE(41);
      if (lookahead == 'x') ADVANCE(66);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(189);
      if (lookahead != 0) ADVANCE(185);
      END_STATE();
    case 37:
      if (lookahead == 'u') ADVANCE(42);
      END_STATE();
    case 38:
      if (lookahead == 'u') ADVANCE(43);
      END_STATE();
    case 39:
      if (lookahead == 'u') ADVANCE(44);
      if (lookahead == 'x') ADVANCE(66);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(189);
      if (lookahead != 0) ADVANCE(185);
      END_STATE();
    case 40:
      if (lookahead == '{') ADVANCE(193);
      END_STATE();
    case 41:
      if (lookahead == '{') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(71);
      END_STATE();
    case 42:
      if (lookahead == '{') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(72);
      END_STATE();
    case 43:
      if (lookahead == '{') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      END_STATE();
    case 44:
      if (lookahead == '{') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 45:
      if (lookahead == '}') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 46:
      if (lookahead == '}') ADVANCE(210);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 47:
      if (lookahead == '}') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 48:
      if (lookahead == '}') ADVANCE(220);
      END_STATE();
    case 49:
      if (lookahead == '}') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 50:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(56);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(206);
      END_STATE();
    case 51:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(202);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(203);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(201);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(206);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(209);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(210);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(185);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(204);
      END_STATE();
    case 61:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 62:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(186);
      END_STATE();
    case 63:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(66);
      END_STATE();
    case 64:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 65:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 66:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(59);
      END_STATE();
    case 67:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 68:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 69:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      END_STATE();
    case 70:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      END_STATE();
    case 71:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(68);
      END_STATE();
    case 72:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      END_STATE();
    case 73:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(70);
      END_STATE();
    case 74:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(35);
      END_STATE();
    case 75:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(196);
      END_STATE();
    case 76:
      if (eof) ADVANCE(78);
      ADVANCE_MAP(
        '!', 91,
        '"', 171,
        '#', 8,
        '$', 208,
        '%', 151,
        '&', 130,
        '\'', 172,
        '(', 92,
        ')', 94,
        '*', 81,
        '+', 143,
        ',', 88,
        '-', 147,
        '.', 99,
        '/', 149,
        '0', 199,
        ':', 95,
        ';', 93,
        '<', 155,
        '=', 84,
        '>', 164,
        '?', 214,
        '@', 211,
        '[', 96,
        '\\', 38,
        ']', 97,
        '^', 133,
        '`', 192,
        '{', 87,
        '|', 136,
        '}', 89,
        '~', 168,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(76);
      if (lookahead > '@') ADVANCE(209);
      END_STATE();
    case 77:
      if (eof) ADVANCE(78);
      ADVANCE_MAP(
        '!', 91,
        '"', 171,
        '#', 8,
        '%', 151,
        '&', 130,
        '\'', 172,
        '(', 92,
        ')', 94,
        '*', 81,
        '+', 142,
        ',', 88,
        '-', 146,
        '.', 99,
        '/', 149,
        '0', 199,
        ':', 95,
        ';', 93,
        '<', 155,
        '=', 84,
        '>', 164,
        '?', 214,
        '@', 211,
        '[', 96,
        '\\', 38,
        ']', 97,
        '^', 133,
        '`', 192,
        '{', 87,
        '|', 136,
        '}', 89,
        '~', 168,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(77);
      if (lookahead > '#') ADVANCE(209);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(79);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(153);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(152);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(158);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(158);
      if (lookahead == '>') ADVANCE(101);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(101);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '|') ADVANCE(219);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(160);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '>') ADVANCE(126);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(125);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(120);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(119);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(110);
      if (lookahead == '|') ADVANCE(122);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(110);
      if (lookahead == '|') ADVANCE(122);
      if (lookahead == '}') ADVANCE(220);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(121);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(121);
      if (lookahead == '}') ADVANCE(220);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '}') ADVANCE(220);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(169);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(169);
      if (lookahead == '=') ADVANCE(103);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(169);
      if (lookahead == '=') ADVANCE(103);
      if (lookahead == '?') ADVANCE(28);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(170);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(170);
      if (lookahead == '=') ADVANCE(104);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(170);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '?') ADVANCE(29);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(22);
      if (lookahead == '/') ADVANCE(191);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(22);
      if (lookahead == '/') ADVANCE(191);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(128);
      if (lookahead == '=') ADVANCE(157);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(127);
      if (lookahead == '=') ADVANCE(157);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(159);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(161);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(123);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(162);
      if (lookahead == '>') ADVANCE(124);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(175);
      if (lookahead == '/') ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(174);
      if (lookahead == '/') ADVANCE(178);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(175);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(175);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(173);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(176);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(177);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(181);
      if (lookahead == '/') ADVANCE(183);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(180);
      if (lookahead == '/') ADVANCE(184);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(181);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(180);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(179);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(182);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(184);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(183);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(38);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(209);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(185);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(185);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(188);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != 0x2028 &&
          lookahead != 0x2029) ADVANCE(191);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(27);
      if (lookahead == '/') ADVANCE(20);
      if (lookahead == '[') ADVANCE(35);
      if (lookahead == '\\') ADVANCE(75);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(195);
      if (lookahead != 0) ADVANCE(196);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(35);
      if (lookahead == '\\') ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(196);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(38);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(197);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(209);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_number);
      ADVANCE_MAP(
        '.', 207,
        '0', 201,
        '_', 55,
        'n', 198,
        'B', 51,
        'b', 51,
        'E', 50,
        'e', 50,
        'O', 52,
        'o', 52,
        'X', 60,
        'x', 60,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(207);
      if (lookahead == '_') ADVANCE(53);
      if (lookahead == 'n') ADVANCE(198);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(55);
      if (lookahead == 'n') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(201);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(51);
      if (lookahead == 'n') ADVANCE(198);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(202);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(203);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(60);
      if (lookahead == 'n') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(204);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(54);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(56);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(206);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(205);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(38);
      if (lookahead == '{') ADVANCE(193);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(209);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(38);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(209);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(37);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(210);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(102);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(102);
      if (lookahead == '?') ADVANCE(167);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '.') ADVANCE(102);
      if (lookahead == '?') ADVANCE(166);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_DASH_QMARK_COLON);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_PLUS_QMARK_COLON);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_QMARK_COLON);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_LBRACE_PIPE);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_PIPE_RBRACE);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(aux_sym_ui_version_specifier_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(221);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'g', 7,
        'i', 8,
        'k', 9,
        'l', 10,
        'm', 11,
        'n', 12,
        'o', 13,
        'p', 14,
        'r', 15,
        's', 16,
        't', 17,
        'u', 18,
        'v', 19,
        'w', 20,
        'y', 21,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(22);
      if (lookahead == 'c') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 's') ADVANCE(25);
      if (lookahead == 'w') ADVANCE(26);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(27);
      if (lookahead == 'r') ADVANCE(28);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'l') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(32);
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(34);
      if (lookahead == 'n') ADVANCE(35);
      if (lookahead == 'x') ADVANCE(36);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(38);
      if (lookahead == 'o') ADVANCE(39);
      if (lookahead == 'r') ADVANCE(40);
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(42);
      if (lookahead == 'l') ADVANCE(43);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(44);
      if (lookahead == 'm') ADVANCE(45);
      if (lookahead == 'n') ADVANCE(46);
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(49);
      if (lookahead == 'i') ADVANCE(50);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(51);
      if (lookahead == 'o') ADVANCE(52);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(53);
      if (lookahead == 'e') ADVANCE(54);
      if (lookahead == 'u') ADVANCE(55);
      END_STATE();
    case 13:
      if (lookahead == 'b') ADVANCE(56);
      if (lookahead == 'f') ADVANCE(57);
      if (lookahead == 'n') ADVANCE(58);
      if (lookahead == 'v') ADVANCE(59);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(60);
      if (lookahead == 'u') ADVANCE(61);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(62);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(63);
      if (lookahead == 'e') ADVANCE(64);
      if (lookahead == 'i') ADVANCE(65);
      if (lookahead == 't') ADVANCE(66);
      if (lookahead == 'u') ADVANCE(67);
      if (lookahead == 'w') ADVANCE(68);
      if (lookahead == 'y') ADVANCE(69);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(70);
      if (lookahead == 'h') ADVANCE(71);
      if (lookahead == 'r') ADVANCE(72);
      if (lookahead == 'y') ADVANCE(73);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(74);
      if (lookahead == 's') ADVANCE(75);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(76);
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(78);
      if (lookahead == 'i') ADVANCE(79);
      END_STATE();
    case 21:
      if (lookahead == 'i') ADVANCE(80);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(81);
      END_STATE();
    case 23:
      if (lookahead == 'c') ADVANCE(82);
      END_STATE();
    case 24:
      if (lookahead == 'y') ADVANCE(83);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(84);
      if (lookahead == 'y') ADVANCE(85);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(86);
      END_STATE();
    case 27:
      if (lookahead == 'o') ADVANCE(87);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(88);
      END_STATE();
    case 29:
      if (lookahead == 's') ADVANCE(89);
      if (lookahead == 't') ADVANCE(90);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(91);
      END_STATE();
    case 31:
      if (lookahead == 'm') ADVANCE(92);
      if (lookahead == 'n') ADVANCE(93);
      END_STATE();
    case 32:
      if (lookahead == 'b') ADVANCE(94);
      if (lookahead == 'c') ADVANCE(95);
      if (lookahead == 'f') ADVANCE(96);
      if (lookahead == 'l') ADVANCE(97);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 34:
      if (lookahead == 's') ADVANCE(98);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(99);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(100);
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(102);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(103);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(104);
      END_STATE();
    case 40:
      if (lookahead == 'o') ADVANCE(105);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(107);
      END_STATE();
    case 43:
      if (lookahead == 'o') ADVANCE(108);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 45:
      if (lookahead == 'p') ADVANCE(109);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'f') ADVANCE(110);
      if (lookahead == 's') ADVANCE(111);
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 48:
      if (lookahead == 'y') ADVANCE(113);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(114);
      END_STATE();
    case 50:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(116);
      END_STATE();
    case 52:
      if (lookahead == 'd') ADVANCE(117);
      END_STATE();
    case 53:
      if (lookahead == 'm') ADVANCE(118);
      END_STATE();
    case 54:
      if (lookahead == 'v') ADVANCE(119);
      if (lookahead == 'w') ADVANCE(120);
      END_STATE();
    case 55:
      if (lookahead == 'l') ADVANCE(121);
      if (lookahead == 'm') ADVANCE(122);
      END_STATE();
    case 56:
      if (lookahead == 'j') ADVANCE(123);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_on);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(124);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(125);
      if (lookahead == 'i') ADVANCE(126);
      if (lookahead == 'o') ADVANCE(127);
      END_STATE();
    case 61:
      if (lookahead == 'b') ADVANCE(128);
      END_STATE();
    case 62:
      if (lookahead == 'a') ADVANCE(129);
      if (lookahead == 'q') ADVANCE(130);
      if (lookahead == 't') ADVANCE(131);
      END_STATE();
    case 63:
      if (lookahead == 't') ADVANCE(132);
      END_STATE();
    case 64:
      if (lookahead == 't') ADVANCE(133);
      END_STATE();
    case 65:
      if (lookahead == 'g') ADVANCE(134);
      END_STATE();
    case 66:
      if (lookahead == 'a') ADVANCE(135);
      if (lookahead == 'r') ADVANCE(136);
      END_STATE();
    case 67:
      if (lookahead == 'p') ADVANCE(137);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(138);
      END_STATE();
    case 69:
      if (lookahead == 'm') ADVANCE(139);
      END_STATE();
    case 70:
      if (lookahead == 'r') ADVANCE(140);
      END_STATE();
    case 71:
      if (lookahead == 'i') ADVANCE(141);
      if (lookahead == 'r') ADVANCE(142);
      END_STATE();
    case 72:
      if (lookahead == 'u') ADVANCE(143);
      if (lookahead == 'y') ADVANCE(144);
      END_STATE();
    case 73:
      if (lookahead == 'p') ADVANCE(145);
      END_STATE();
    case 74:
      if (lookahead == 'd') ADVANCE(146);
      if (lookahead == 'i') ADVANCE(147);
      if (lookahead == 'k') ADVANCE(148);
      END_STATE();
    case 75:
      if (lookahead == 'i') ADVANCE(149);
      END_STATE();
    case 76:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 77:
      if (lookahead == 'i') ADVANCE(151);
      END_STATE();
    case 78:
      if (lookahead == 'i') ADVANCE(152);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(153);
      END_STATE();
    case 80:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 81:
      if (lookahead == 't') ADVANCE(155);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(156);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 85:
      if (lookahead == 'n') ADVANCE(158);
      END_STATE();
    case 86:
      if (lookahead == 'i') ADVANCE(159);
      END_STATE();
    case 87:
      if (lookahead == 'l') ADVANCE(160);
      END_STATE();
    case 88:
      if (lookahead == 'a') ADVANCE(161);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 90:
      if (lookahead == 'c') ADVANCE(163);
      END_STATE();
    case 91:
      if (lookahead == 's') ADVANCE(164);
      END_STATE();
    case 92:
      if (lookahead == 'p') ADVANCE(165);
      END_STATE();
    case 93:
      if (lookahead == 's') ADVANCE(166);
      if (lookahead == 't') ADVANCE(167);
      END_STATE();
    case 94:
      if (lookahead == 'u') ADVANCE(168);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(169);
      END_STATE();
    case 96:
      if (lookahead == 'a') ADVANCE(170);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 98:
      if (lookahead == 'e') ADVANCE(172);
      END_STATE();
    case 99:
      if (lookahead == 'm') ADVANCE(173);
      END_STATE();
    case 100:
      if (lookahead == 'o') ADVANCE(174);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 102:
      if (lookahead == 's') ADVANCE(176);
      END_STATE();
    case 103:
      if (lookahead == 'a') ADVANCE(177);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 105:
      if (lookahead == 'm') ADVANCE(178);
      END_STATE();
    case 106:
      if (lookahead == 'c') ADVANCE(179);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 108:
      if (lookahead == 'b') ADVANCE(180);
      END_STATE();
    case 109:
      if (lookahead == 'l') ADVANCE(181);
      if (lookahead == 'o') ADVANCE(182);
      END_STATE();
    case 110:
      if (lookahead == 'e') ADVANCE(183);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(184);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 113:
      if (lookahead == 'o') ADVANCE(186);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(187);
      END_STATE();
    case 116:
      if (lookahead == 'a') ADVANCE(188);
      END_STATE();
    case 117:
      if (lookahead == 'u') ADVANCE(189);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(190);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 121:
      if (lookahead == 'l') ADVANCE(192);
      END_STATE();
    case 122:
      if (lookahead == 'b') ADVANCE(193);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(194);
      END_STATE();
    case 124:
      if (lookahead == 'r') ADVANCE(195);
      END_STATE();
    case 125:
      if (lookahead == 'g') ADVANCE(196);
      END_STATE();
    case 126:
      if (lookahead == 'v') ADVANCE(197);
      END_STATE();
    case 127:
      if (lookahead == 'p') ADVANCE(198);
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 128:
      if (lookahead == 'l') ADVANCE(200);
      END_STATE();
    case 129:
      if (lookahead == 'd') ADVANCE(201);
      END_STATE();
    case 130:
      if (lookahead == 'u') ADVANCE(202);
      END_STATE();
    case 131:
      if (lookahead == 'u') ADVANCE(203);
      END_STATE();
    case 132:
      if (lookahead == 'i') ADVANCE(204);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 134:
      if (lookahead == 'n') ADVANCE(205);
      END_STATE();
    case 135:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 136:
      if (lookahead == 'i') ADVANCE(207);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(208);
      END_STATE();
    case 138:
      if (lookahead == 't') ADVANCE(209);
      END_STATE();
    case 139:
      if (lookahead == 'b') ADVANCE(210);
      END_STATE();
    case 140:
      if (lookahead == 'g') ADVANCE(211);
      END_STATE();
    case 141:
      if (lookahead == 's') ADVANCE(212);
      END_STATE();
    case 142:
      if (lookahead == 'o') ADVANCE(213);
      END_STATE();
    case 143:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 145:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 146:
      if (lookahead == 'e') ADVANCE(216);
      END_STATE();
    case 147:
      if (lookahead == 'q') ADVANCE(217);
      END_STATE();
    case 148:
      if (lookahead == 'n') ADVANCE(218);
      END_STATE();
    case 149:
      if (lookahead == 'n') ADVANCE(219);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 151:
      if (lookahead == 'd') ADVANCE(220);
      END_STATE();
    case 152:
      if (lookahead == 'l') ADVANCE(221);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(222);
      END_STATE();
    case 154:
      if (lookahead == 'l') ADVANCE(223);
      END_STATE();
    case 155:
      if (lookahead == 'r') ADVANCE(224);
      END_STATE();
    case 156:
      if (lookahead == 's') ADVANCE(225);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(226);
      END_STATE();
    case 158:
      if (lookahead == 'c') ADVANCE(227);
      END_STATE();
    case 159:
      if (lookahead == 't') ADVANCE(228);
      END_STATE();
    case 160:
      if (lookahead == 'e') ADVANCE(229);
      END_STATE();
    case 161:
      if (lookahead == 'k') ADVANCE(230);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 163:
      if (lookahead == 'h') ADVANCE(231);
      END_STATE();
    case 164:
      if (lookahead == 's') ADVANCE(232);
      END_STATE();
    case 165:
      if (lookahead == 'o') ADVANCE(233);
      END_STATE();
    case 166:
      if (lookahead == 't') ADVANCE(234);
      END_STATE();
    case 167:
      if (lookahead == 'i') ADVANCE(235);
      END_STATE();
    case 168:
      if (lookahead == 'g') ADVANCE(236);
      END_STATE();
    case 169:
      if (lookahead == 'a') ADVANCE(237);
      END_STATE();
    case 170:
      if (lookahead == 'u') ADVANCE(238);
      END_STATE();
    case 171:
      if (lookahead == 't') ADVANCE(239);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 174:
      if (lookahead == 'r') ADVANCE(240);
      END_STATE();
    case 175:
      if (lookahead == 'n') ADVANCE(241);
      END_STATE();
    case 176:
      if (lookahead == 'e') ADVANCE(242);
      END_STATE();
    case 177:
      if (lookahead == 'l') ADVANCE(243);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 179:
      if (lookahead == 't') ADVANCE(244);
      END_STATE();
    case 180:
      if (lookahead == 'a') ADVANCE(245);
      END_STATE();
    case 181:
      if (lookahead == 'e') ADVANCE(246);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(247);
      END_STATE();
    case 183:
      if (lookahead == 'r') ADVANCE(248);
      END_STATE();
    case 184:
      if (lookahead == 'a') ADVANCE(249);
      END_STATE();
    case 185:
      if (lookahead == 'r') ADVANCE(250);
      END_STATE();
    case 186:
      if (lookahead == 'f') ADVANCE(251);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_list);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_meta);
      END_STATE();
    case 189:
      if (lookahead == 'l') ADVANCE(252);
      END_STATE();
    case 190:
      if (lookahead == 's') ADVANCE(253);
      END_STATE();
    case 191:
      if (lookahead == 'r') ADVANCE(254);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 193:
      if (lookahead == 'e') ADVANCE(255);
      END_STATE();
    case 194:
      if (lookahead == 'c') ADVANCE(256);
      END_STATE();
    case 195:
      if (lookahead == 'r') ADVANCE(257);
      END_STATE();
    case 196:
      if (lookahead == 'm') ADVANCE(258);
      END_STATE();
    case 197:
      if (lookahead == 'a') ADVANCE(259);
      END_STATE();
    case 198:
      if (lookahead == 'e') ADVANCE(260);
      END_STATE();
    case 199:
      if (lookahead == 'e') ADVANCE(261);
      END_STATE();
    case 200:
      if (lookahead == 'i') ADVANCE(262);
      END_STATE();
    case 201:
      if (lookahead == 'o') ADVANCE(263);
      END_STATE();
    case 202:
      if (lookahead == 'i') ADVANCE(264);
      END_STATE();
    case 203:
      if (lookahead == 'r') ADVANCE(265);
      END_STATE();
    case 204:
      if (lookahead == 's') ADVANCE(266);
      END_STATE();
    case 205:
      if (lookahead == 'a') ADVANCE(267);
      END_STATE();
    case 206:
      if (lookahead == 'i') ADVANCE(268);
      END_STATE();
    case 207:
      if (lookahead == 'n') ADVANCE(269);
      END_STATE();
    case 208:
      if (lookahead == 'r') ADVANCE(270);
      END_STATE();
    case 209:
      if (lookahead == 'c') ADVANCE(271);
      END_STATE();
    case 210:
      if (lookahead == 'o') ADVANCE(272);
      END_STATE();
    case 211:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 213:
      if (lookahead == 'w') ADVANCE(274);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_type);
      if (lookahead == 'o') ADVANCE(275);
      END_STATE();
    case 216:
      if (lookahead == 'f') ADVANCE(276);
      END_STATE();
    case 217:
      if (lookahead == 'u') ADVANCE(277);
      END_STATE();
    case 218:
      if (lookahead == 'o') ADVANCE(278);
      END_STATE();
    case 219:
      if (lookahead == 'g') ADVANCE(279);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 221:
      if (lookahead == 'e') ADVANCE(280);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 223:
      if (lookahead == 'd') ADVANCE(281);
      END_STATE();
    case 224:
      if (lookahead == 'a') ADVANCE(282);
      END_STATE();
    case 225:
      if (lookahead == 's') ADVANCE(283);
      END_STATE();
    case 226:
      if (lookahead == 't') ADVANCE(284);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 229:
      if (lookahead == 'a') ADVANCE(285);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 233:
      if (lookahead == 'n') ADVANCE(286);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 235:
      if (lookahead == 'n') ADVANCE(287);
      END_STATE();
    case 236:
      if (lookahead == 'g') ADVANCE(288);
      END_STATE();
    case 237:
      if (lookahead == 'r') ADVANCE(289);
      END_STATE();
    case 238:
      if (lookahead == 'l') ADVANCE(290);
      END_STATE();
    case 239:
      if (lookahead == 'e') ADVANCE(291);
      END_STATE();
    case 240:
      if (lookahead == 't') ADVANCE(292);
      END_STATE();
    case 241:
      if (lookahead == 'd') ADVANCE(293);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_final);
      if (lookahead == 'l') ADVANCE(294);
      END_STATE();
    case 244:
      if (lookahead == 'i') ADVANCE(295);
      END_STATE();
    case 245:
      if (lookahead == 'l') ADVANCE(296);
      END_STATE();
    case 246:
      if (lookahead == 'm') ADVANCE(297);
      END_STATE();
    case 247:
      if (lookahead == 't') ADVANCE(298);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_infer);
      END_STATE();
    case 249:
      if (lookahead == 'n') ADVANCE(299);
      END_STATE();
    case 250:
      if (lookahead == 'f') ADVANCE(300);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_keyof);
      END_STATE();
    case 252:
      if (lookahead == 'e') ADVANCE(301);
      END_STATE();
    case 253:
      if (lookahead == 'p') ADVANCE(302);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_never);
      END_STATE();
    case 255:
      if (lookahead == 'r') ADVANCE(303);
      END_STATE();
    case 256:
      if (lookahead == 't') ADVANCE(304);
      END_STATE();
    case 257:
      if (lookahead == 'i') ADVANCE(305);
      END_STATE();
    case 258:
      if (lookahead == 'a') ADVANCE(306);
      END_STATE();
    case 259:
      if (lookahead == 't') ADVANCE(307);
      END_STATE();
    case 260:
      if (lookahead == 'r') ADVANCE(308);
      END_STATE();
    case 261:
      if (lookahead == 'c') ADVANCE(309);
      END_STATE();
    case 262:
      if (lookahead == 'c') ADVANCE(310);
      END_STATE();
    case 263:
      if (lookahead == 'n') ADVANCE(311);
      END_STATE();
    case 264:
      if (lookahead == 'r') ADVANCE(312);
      END_STATE();
    case 265:
      if (lookahead == 'n') ADVANCE(313);
      END_STATE();
    case 266:
      if (lookahead == 'f') ADVANCE(314);
      END_STATE();
    case 267:
      if (lookahead == 'l') ADVANCE(315);
      END_STATE();
    case 268:
      if (lookahead == 'c') ADVANCE(316);
      END_STATE();
    case 269:
      if (lookahead == 'g') ADVANCE(317);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 271:
      if (lookahead == 'h') ADVANCE(318);
      END_STATE();
    case 272:
      if (lookahead == 'l') ADVANCE(319);
      END_STATE();
    case 273:
      if (lookahead == 't') ADVANCE(320);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 275:
      if (lookahead == 'f') ADVANCE(321);
      END_STATE();
    case 276:
      if (lookahead == 'i') ADVANCE(322);
      END_STATE();
    case 277:
      if (lookahead == 'e') ADVANCE(323);
      END_STATE();
    case 278:
      if (lookahead == 'w') ADVANCE(324);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 282:
      if (lookahead == 'c') ADVANCE(325);
      END_STATE();
    case 283:
      if (lookahead == 'o') ADVANCE(326);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_assert);
      if (lookahead == 's') ADVANCE(327);
      END_STATE();
    case 285:
      if (lookahead == 'n') ADVANCE(328);
      END_STATE();
    case 286:
      if (lookahead == 'e') ADVANCE(329);
      END_STATE();
    case 287:
      if (lookahead == 'u') ADVANCE(330);
      END_STATE();
    case 288:
      if (lookahead == 'e') ADVANCE(331);
      END_STATE();
    case 289:
      if (lookahead == 'e') ADVANCE(332);
      END_STATE();
    case 290:
      if (lookahead == 't') ADVANCE(333);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 293:
      if (lookahead == 's') ADVANCE(334);
      END_STATE();
    case 294:
      if (lookahead == 'y') ADVANCE(335);
      END_STATE();
    case 295:
      if (lookahead == 'o') ADVANCE(336);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 297:
      if (lookahead == 'e') ADVANCE(337);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 299:
      if (lookahead == 'c') ADVANCE(338);
      END_STATE();
    case 300:
      if (lookahead == 'a') ADVANCE(339);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 302:
      if (lookahead == 'a') ADVANCE(340);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_number);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_object);
      END_STATE();
    case 305:
      if (lookahead == 'd') ADVANCE(341);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_pragma);
      END_STATE();
    case 307:
      if (lookahead == 'e') ADVANCE(342);
      END_STATE();
    case 308:
      if (lookahead == 't') ADVANCE(343);
      END_STATE();
    case 309:
      if (lookahead == 't') ADVANCE(344);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 311:
      if (lookahead == 'l') ADVANCE(345);
      END_STATE();
    case 312:
      if (lookahead == 'e') ADVANCE(346);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 314:
      if (lookahead == 'i') ADVANCE(347);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(anon_sym_signal);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_symbol);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 322:
      if (lookahead == 'n') ADVANCE(348);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_unique);
      END_STATE();
    case 324:
      if (lookahead == 'n') ADVANCE(349);
      END_STATE();
    case 325:
      if (lookahead == 't') ADVANCE(350);
      END_STATE();
    case 326:
      if (lookahead == 'r') ADVANCE(351);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_asserts);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 329:
      if (lookahead == 'n') ADVANCE(352);
      END_STATE();
    case 330:
      if (lookahead == 'e') ADVANCE(353);
      END_STATE();
    case 331:
      if (lookahead == 'r') ADVANCE(354);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 336:
      if (lookahead == 'n') ADVANCE(355);
      END_STATE();
    case 337:
      if (lookahead == 'n') ADVANCE(356);
      END_STATE();
    case 338:
      if (lookahead == 'e') ADVANCE(357);
      END_STATE();
    case 339:
      if (lookahead == 'c') ADVANCE(358);
      END_STATE();
    case 340:
      if (lookahead == 'c') ADVANCE(359);
      END_STATE();
    case 341:
      if (lookahead == 'e') ADVANCE(360);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 343:
      if (lookahead == 'y') ADVANCE(361);
      END_STATE();
    case 344:
      if (lookahead == 'e') ADVANCE(362);
      END_STATE();
    case 345:
      if (lookahead == 'y') ADVANCE(363);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_require);
      if (lookahead == 'd') ADVANCE(364);
      END_STATE();
    case 347:
      if (lookahead == 'e') ADVANCE(365);
      END_STATE();
    case 348:
      if (lookahead == 'e') ADVANCE(366);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_unknown);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_accessor);
      END_STATE();
    case 352:
      if (lookahead == 't') ADVANCE(367);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 356:
      if (lookahead == 't') ADVANCE(368);
      END_STATE();
    case 357:
      if (lookahead == 'o') ADVANCE(369);
      END_STATE();
    case 358:
      if (lookahead == 'e') ADVANCE(370);
      END_STATE();
    case 359:
      if (lookahead == 'e') ADVANCE(371);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_property);
      END_STATE();
    case 362:
      if (lookahead == 'd') ADVANCE(372);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_required);
      END_STATE();
    case 365:
      if (lookahead == 's') ADVANCE(373);
      END_STATE();
    case 366:
      if (lookahead == 'd') ADVANCE(374);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_component);
      END_STATE();
    case 368:
      if (lookahead == 's') ADVANCE(375);
      END_STATE();
    case 369:
      if (lookahead == 'f') ADVANCE(376);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_satisfies);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 77, .external_lex_state = 2},
  [2] = {.lex_state = 77, .external_lex_state = 3},
  [3] = {.lex_state = 77, .external_lex_state = 3},
  [4] = {.lex_state = 9, .external_lex_state = 2},
  [5] = {.lex_state = 9, .external_lex_state = 2},
  [6] = {.lex_state = 9, .external_lex_state = 2},
  [7] = {.lex_state = 9, .external_lex_state = 2},
  [8] = {.lex_state = 9, .external_lex_state = 2},
  [9] = {.lex_state = 9, .external_lex_state = 2},
  [10] = {.lex_state = 9, .external_lex_state = 2},
  [11] = {.lex_state = 9, .external_lex_state = 2},
  [12] = {.lex_state = 9, .external_lex_state = 2},
  [13] = {.lex_state = 9, .external_lex_state = 2},
  [14] = {.lex_state = 9, .external_lex_state = 2},
  [15] = {.lex_state = 9, .external_lex_state = 2},
  [16] = {.lex_state = 9, .external_lex_state = 2},
  [17] = {.lex_state = 9, .external_lex_state = 2},
  [18] = {.lex_state = 9, .external_lex_state = 2},
  [19] = {.lex_state = 9, .external_lex_state = 2},
  [20] = {.lex_state = 9, .external_lex_state = 2},
  [21] = {.lex_state = 9, .external_lex_state = 2},
  [22] = {.lex_state = 9, .external_lex_state = 2},
  [23] = {.lex_state = 9, .external_lex_state = 2},
  [24] = {.lex_state = 9, .external_lex_state = 2},
  [25] = {.lex_state = 9, .external_lex_state = 2},
  [26] = {.lex_state = 9, .external_lex_state = 2},
  [27] = {.lex_state = 9, .external_lex_state = 2},
  [28] = {.lex_state = 9, .external_lex_state = 2},
  [29] = {.lex_state = 9, .external_lex_state = 2},
  [30] = {.lex_state = 9, .external_lex_state = 2},
  [31] = {.lex_state = 9, .external_lex_state = 2},
  [32] = {.lex_state = 9, .external_lex_state = 2},
  [33] = {.lex_state = 9, .external_lex_state = 2},
  [34] = {.lex_state = 9, .external_lex_state = 2},
  [35] = {.lex_state = 9, .external_lex_state = 2},
  [36] = {.lex_state = 9, .external_lex_state = 2},
  [37] = {.lex_state = 9, .external_lex_state = 2},
  [38] = {.lex_state = 9, .external_lex_state = 2},
  [39] = {.lex_state = 9, .external_lex_state = 2},
  [40] = {.lex_state = 9, .external_lex_state = 2},
  [41] = {.lex_state = 9, .external_lex_state = 2},
  [42] = {.lex_state = 9, .external_lex_state = 2},
  [43] = {.lex_state = 9, .external_lex_state = 2},
  [44] = {.lex_state = 9, .external_lex_state = 2},
  [45] = {.lex_state = 9, .external_lex_state = 2},
  [46] = {.lex_state = 9, .external_lex_state = 2},
  [47] = {.lex_state = 9, .external_lex_state = 2},
  [48] = {.lex_state = 9, .external_lex_state = 2},
  [49] = {.lex_state = 9, .external_lex_state = 2},
  [50] = {.lex_state = 9, .external_lex_state = 2},
  [51] = {.lex_state = 9, .external_lex_state = 2},
  [52] = {.lex_state = 9, .external_lex_state = 2},
  [53] = {.lex_state = 9, .external_lex_state = 2},
  [54] = {.lex_state = 9, .external_lex_state = 2},
  [55] = {.lex_state = 9, .external_lex_state = 2},
  [56] = {.lex_state = 9, .external_lex_state = 2},
  [57] = {.lex_state = 9, .external_lex_state = 2},
  [58] = {.lex_state = 9, .external_lex_state = 2},
  [59] = {.lex_state = 9, .external_lex_state = 2},
  [60] = {.lex_state = 9, .external_lex_state = 2},
  [61] = {.lex_state = 9, .external_lex_state = 2},
  [62] = {.lex_state = 9, .external_lex_state = 2},
  [63] = {.lex_state = 9, .external_lex_state = 2},
  [64] = {.lex_state = 9, .external_lex_state = 2},
  [65] = {.lex_state = 9, .external_lex_state = 2},
  [66] = {.lex_state = 9, .external_lex_state = 2},
  [67] = {.lex_state = 9, .external_lex_state = 2},
  [68] = {.lex_state = 9, .external_lex_state = 2},
  [69] = {.lex_state = 9, .external_lex_state = 2},
  [70] = {.lex_state = 9, .external_lex_state = 2},
  [71] = {.lex_state = 9, .external_lex_state = 2},
  [72] = {.lex_state = 10, .external_lex_state = 2},
  [73] = {.lex_state = 10, .external_lex_state = 2},
  [74] = {.lex_state = 9, .external_lex_state = 2},
  [75] = {.lex_state = 10, .external_lex_state = 2},
  [76] = {.lex_state = 10, .external_lex_state = 2},
  [77] = {.lex_state = 9, .external_lex_state = 2},
  [78] = {.lex_state = 9, .external_lex_state = 2},
  [79] = {.lex_state = 9, .external_lex_state = 2},
  [80] = {.lex_state = 10, .external_lex_state = 2},
  [81] = {.lex_state = 10, .external_lex_state = 2},
  [82] = {.lex_state = 9, .external_lex_state = 2},
  [83] = {.lex_state = 10, .external_lex_state = 2},
  [84] = {.lex_state = 9, .external_lex_state = 2},
  [85] = {.lex_state = 10, .external_lex_state = 2},
  [86] = {.lex_state = 10, .external_lex_state = 2},
  [87] = {.lex_state = 10, .external_lex_state = 2},
  [88] = {.lex_state = 9, .external_lex_state = 2},
  [89] = {.lex_state = 2, .external_lex_state = 4},
  [90] = {.lex_state = 2, .external_lex_state = 4},
  [91] = {.lex_state = 2, .external_lex_state = 4},
  [92] = {.lex_state = 2, .external_lex_state = 4},
  [93] = {.lex_state = 2, .external_lex_state = 3},
  [94] = {.lex_state = 10, .external_lex_state = 2},
  [95] = {.lex_state = 10, .external_lex_state = 2},
  [96] = {.lex_state = 2, .external_lex_state = 3},
  [97] = {.lex_state = 2, .external_lex_state = 3},
  [98] = {.lex_state = 2, .external_lex_state = 3},
  [99] = {.lex_state = 2, .external_lex_state = 3},
  [100] = {.lex_state = 2, .external_lex_state = 3},
  [101] = {.lex_state = 2, .external_lex_state = 3},
  [102] = {.lex_state = 10, .external_lex_state = 2},
  [103] = {.lex_state = 2, .external_lex_state = 3},
  [104] = {.lex_state = 2, .external_lex_state = 3},
  [105] = {.lex_state = 2, .external_lex_state = 3},
  [106] = {.lex_state = 2, .external_lex_state = 3},
  [107] = {.lex_state = 2, .external_lex_state = 3},
  [108] = {.lex_state = 2, .external_lex_state = 3},
  [109] = {.lex_state = 10, .external_lex_state = 2},
  [110] = {.lex_state = 10, .external_lex_state = 2},
  [111] = {.lex_state = 2, .external_lex_state = 3},
  [112] = {.lex_state = 10, .external_lex_state = 2},
  [113] = {.lex_state = 10, .external_lex_state = 2},
  [114] = {.lex_state = 10, .external_lex_state = 2},
  [115] = {.lex_state = 2, .external_lex_state = 4},
  [116] = {.lex_state = 2, .external_lex_state = 3},
  [117] = {.lex_state = 2, .external_lex_state = 4},
  [118] = {.lex_state = 2, .external_lex_state = 4},
  [119] = {.lex_state = 2, .external_lex_state = 3},
  [120] = {.lex_state = 2, .external_lex_state = 4},
  [121] = {.lex_state = 2, .external_lex_state = 4},
  [122] = {.lex_state = 2, .external_lex_state = 4},
  [123] = {.lex_state = 2, .external_lex_state = 3},
  [124] = {.lex_state = 2, .external_lex_state = 3},
  [125] = {.lex_state = 2, .external_lex_state = 3},
  [126] = {.lex_state = 2, .external_lex_state = 4},
  [127] = {.lex_state = 2, .external_lex_state = 4},
  [128] = {.lex_state = 2, .external_lex_state = 3},
  [129] = {.lex_state = 2, .external_lex_state = 4},
  [130] = {.lex_state = 2, .external_lex_state = 3},
  [131] = {.lex_state = 2, .external_lex_state = 3},
  [132] = {.lex_state = 2, .external_lex_state = 3},
  [133] = {.lex_state = 2, .external_lex_state = 3},
  [134] = {.lex_state = 2, .external_lex_state = 3},
  [135] = {.lex_state = 2, .external_lex_state = 3},
  [136] = {.lex_state = 2, .external_lex_state = 4},
  [137] = {.lex_state = 2, .external_lex_state = 3},
  [138] = {.lex_state = 2, .external_lex_state = 4},
  [139] = {.lex_state = 2, .external_lex_state = 3},
  [140] = {.lex_state = 2, .external_lex_state = 4},
  [141] = {.lex_state = 2, .external_lex_state = 3},
  [142] = {.lex_state = 2, .external_lex_state = 3},
  [143] = {.lex_state = 2, .external_lex_state = 3},
  [144] = {.lex_state = 2, .external_lex_state = 3},
  [145] = {.lex_state = 2, .external_lex_state = 3},
  [146] = {.lex_state = 2, .external_lex_state = 3},
  [147] = {.lex_state = 2, .external_lex_state = 3},
  [148] = {.lex_state = 2, .external_lex_state = 3},
  [149] = {.lex_state = 2, .external_lex_state = 3},
  [150] = {.lex_state = 2, .external_lex_state = 3},
  [151] = {.lex_state = 2, .external_lex_state = 3},
  [152] = {.lex_state = 2, .external_lex_state = 3},
  [153] = {.lex_state = 10, .external_lex_state = 2},
  [154] = {.lex_state = 2, .external_lex_state = 3},
  [155] = {.lex_state = 2, .external_lex_state = 3},
  [156] = {.lex_state = 2, .external_lex_state = 3},
  [157] = {.lex_state = 2, .external_lex_state = 3},
  [158] = {.lex_state = 2, .external_lex_state = 3},
  [159] = {.lex_state = 2, .external_lex_state = 3},
  [160] = {.lex_state = 2, .external_lex_state = 3},
  [161] = {.lex_state = 2, .external_lex_state = 3},
  [162] = {.lex_state = 2, .external_lex_state = 3},
  [163] = {.lex_state = 2, .external_lex_state = 3},
  [164] = {.lex_state = 2, .external_lex_state = 3},
  [165] = {.lex_state = 2, .external_lex_state = 3},
  [166] = {.lex_state = 10, .external_lex_state = 2},
  [167] = {.lex_state = 10, .external_lex_state = 2},
  [168] = {.lex_state = 10, .external_lex_state = 2},
  [169] = {.lex_state = 10, .external_lex_state = 2},
  [170] = {.lex_state = 10, .external_lex_state = 2},
  [171] = {.lex_state = 10, .external_lex_state = 2},
  [172] = {.lex_state = 10, .external_lex_state = 2},
  [173] = {.lex_state = 10, .external_lex_state = 2},
  [174] = {.lex_state = 10, .external_lex_state = 2},
  [175] = {.lex_state = 10, .external_lex_state = 2},
  [176] = {.lex_state = 10, .external_lex_state = 2},
  [177] = {.lex_state = 10, .external_lex_state = 2},
  [178] = {.lex_state = 3, .external_lex_state = 3},
  [179] = {.lex_state = 3, .external_lex_state = 4},
  [180] = {.lex_state = 3, .external_lex_state = 4},
  [181] = {.lex_state = 3, .external_lex_state = 4},
  [182] = {.lex_state = 3, .external_lex_state = 3},
  [183] = {.lex_state = 3, .external_lex_state = 3},
  [184] = {.lex_state = 3, .external_lex_state = 3},
  [185] = {.lex_state = 3, .external_lex_state = 3},
  [186] = {.lex_state = 3, .external_lex_state = 3},
  [187] = {.lex_state = 9, .external_lex_state = 2},
  [188] = {.lex_state = 9, .external_lex_state = 2},
  [189] = {.lex_state = 9, .external_lex_state = 2},
  [190] = {.lex_state = 9, .external_lex_state = 2},
  [191] = {.lex_state = 9, .external_lex_state = 2},
  [192] = {.lex_state = 9, .external_lex_state = 2},
  [193] = {.lex_state = 9, .external_lex_state = 2},
  [194] = {.lex_state = 9, .external_lex_state = 2},
  [195] = {.lex_state = 9, .external_lex_state = 2},
  [196] = {.lex_state = 9, .external_lex_state = 2},
  [197] = {.lex_state = 9, .external_lex_state = 2},
  [198] = {.lex_state = 9, .external_lex_state = 2},
  [199] = {.lex_state = 9, .external_lex_state = 2},
  [200] = {.lex_state = 9, .external_lex_state = 2},
  [201] = {.lex_state = 9, .external_lex_state = 2},
  [202] = {.lex_state = 9, .external_lex_state = 2},
  [203] = {.lex_state = 9, .external_lex_state = 2},
  [204] = {.lex_state = 77, .external_lex_state = 3},
  [205] = {.lex_state = 9, .external_lex_state = 2},
  [206] = {.lex_state = 77, .external_lex_state = 4},
  [207] = {.lex_state = 77, .external_lex_state = 4},
  [208] = {.lex_state = 77, .external_lex_state = 3},
  [209] = {.lex_state = 77, .external_lex_state = 3},
  [210] = {.lex_state = 77, .external_lex_state = 3},
  [211] = {.lex_state = 77, .external_lex_state = 3},
  [212] = {.lex_state = 77, .external_lex_state = 3},
  [213] = {.lex_state = 77, .external_lex_state = 4},
  [214] = {.lex_state = 9, .external_lex_state = 2},
  [215] = {.lex_state = 9, .external_lex_state = 2},
  [216] = {.lex_state = 9, .external_lex_state = 2},
  [217] = {.lex_state = 77, .external_lex_state = 3},
  [218] = {.lex_state = 9, .external_lex_state = 2},
  [219] = {.lex_state = 77, .external_lex_state = 3},
  [220] = {.lex_state = 77, .external_lex_state = 3},
  [221] = {.lex_state = 77, .external_lex_state = 3},
  [222] = {.lex_state = 9, .external_lex_state = 2},
  [223] = {.lex_state = 9, .external_lex_state = 2},
  [224] = {.lex_state = 9, .external_lex_state = 2},
  [225] = {.lex_state = 9, .external_lex_state = 2},
  [226] = {.lex_state = 9, .external_lex_state = 2},
  [227] = {.lex_state = 9, .external_lex_state = 2},
  [228] = {.lex_state = 9, .external_lex_state = 2},
  [229] = {.lex_state = 9, .external_lex_state = 2},
  [230] = {.lex_state = 9, .external_lex_state = 2},
  [231] = {.lex_state = 77, .external_lex_state = 3},
  [232] = {.lex_state = 9, .external_lex_state = 2},
  [233] = {.lex_state = 9, .external_lex_state = 2},
  [234] = {.lex_state = 3, .external_lex_state = 4},
  [235] = {.lex_state = 3, .external_lex_state = 4},
  [236] = {.lex_state = 9, .external_lex_state = 2},
  [237] = {.lex_state = 9, .external_lex_state = 2},
  [238] = {.lex_state = 9, .external_lex_state = 2},
  [239] = {.lex_state = 9, .external_lex_state = 2},
  [240] = {.lex_state = 9, .external_lex_state = 2},
  [241] = {.lex_state = 3, .external_lex_state = 4},
  [242] = {.lex_state = 3, .external_lex_state = 4},
  [243] = {.lex_state = 9, .external_lex_state = 2},
  [244] = {.lex_state = 9, .external_lex_state = 2},
  [245] = {.lex_state = 3, .external_lex_state = 4},
  [246] = {.lex_state = 9, .external_lex_state = 2},
  [247] = {.lex_state = 3, .external_lex_state = 4},
  [248] = {.lex_state = 3, .external_lex_state = 4},
  [249] = {.lex_state = 3, .external_lex_state = 4},
  [250] = {.lex_state = 3, .external_lex_state = 4},
  [251] = {.lex_state = 3, .external_lex_state = 4},
  [252] = {.lex_state = 3, .external_lex_state = 4},
  [253] = {.lex_state = 3, .external_lex_state = 4},
  [254] = {.lex_state = 3, .external_lex_state = 4},
  [255] = {.lex_state = 3, .external_lex_state = 4},
  [256] = {.lex_state = 3, .external_lex_state = 4},
  [257] = {.lex_state = 3, .external_lex_state = 4},
  [258] = {.lex_state = 3, .external_lex_state = 4},
  [259] = {.lex_state = 3, .external_lex_state = 4},
  [260] = {.lex_state = 3, .external_lex_state = 4},
  [261] = {.lex_state = 3, .external_lex_state = 4},
  [262] = {.lex_state = 3, .external_lex_state = 4},
  [263] = {.lex_state = 3, .external_lex_state = 4},
  [264] = {.lex_state = 3, .external_lex_state = 4},
  [265] = {.lex_state = 3, .external_lex_state = 4},
  [266] = {.lex_state = 3, .external_lex_state = 4},
  [267] = {.lex_state = 3, .external_lex_state = 4},
  [268] = {.lex_state = 3, .external_lex_state = 4},
  [269] = {.lex_state = 9, .external_lex_state = 5},
  [270] = {.lex_state = 3, .external_lex_state = 4},
  [271] = {.lex_state = 3, .external_lex_state = 4},
  [272] = {.lex_state = 9, .external_lex_state = 2},
  [273] = {.lex_state = 9, .external_lex_state = 2},
  [274] = {.lex_state = 9, .external_lex_state = 2},
  [275] = {.lex_state = 9, .external_lex_state = 2},
  [276] = {.lex_state = 9, .external_lex_state = 2},
  [277] = {.lex_state = 9, .external_lex_state = 2},
  [278] = {.lex_state = 9, .external_lex_state = 2},
  [279] = {.lex_state = 9, .external_lex_state = 2},
  [280] = {.lex_state = 9, .external_lex_state = 2},
  [281] = {.lex_state = 9, .external_lex_state = 2},
  [282] = {.lex_state = 9, .external_lex_state = 2},
  [283] = {.lex_state = 2, .external_lex_state = 3},
  [284] = {.lex_state = 2, .external_lex_state = 3},
  [285] = {.lex_state = 2, .external_lex_state = 3},
  [286] = {.lex_state = 2, .external_lex_state = 3},
  [287] = {.lex_state = 9, .external_lex_state = 2},
  [288] = {.lex_state = 9, .external_lex_state = 2},
  [289] = {.lex_state = 9, .external_lex_state = 2},
  [290] = {.lex_state = 9, .external_lex_state = 2},
  [291] = {.lex_state = 9, .external_lex_state = 2},
  [292] = {.lex_state = 9, .external_lex_state = 2},
  [293] = {.lex_state = 9, .external_lex_state = 2},
  [294] = {.lex_state = 9, .external_lex_state = 2},
  [295] = {.lex_state = 9, .external_lex_state = 2},
  [296] = {.lex_state = 9, .external_lex_state = 2},
  [297] = {.lex_state = 9, .external_lex_state = 2},
  [298] = {.lex_state = 9, .external_lex_state = 2},
  [299] = {.lex_state = 9, .external_lex_state = 2},
  [300] = {.lex_state = 9, .external_lex_state = 2},
  [301] = {.lex_state = 9, .external_lex_state = 2},
  [302] = {.lex_state = 9, .external_lex_state = 2},
  [303] = {.lex_state = 9, .external_lex_state = 2},
  [304] = {.lex_state = 9, .external_lex_state = 2},
  [305] = {.lex_state = 9, .external_lex_state = 2},
  [306] = {.lex_state = 9, .external_lex_state = 2},
  [307] = {.lex_state = 9, .external_lex_state = 2},
  [308] = {.lex_state = 9, .external_lex_state = 2},
  [309] = {.lex_state = 9, .external_lex_state = 2},
  [310] = {.lex_state = 9, .external_lex_state = 2},
  [311] = {.lex_state = 9, .external_lex_state = 2},
  [312] = {.lex_state = 9, .external_lex_state = 2},
  [313] = {.lex_state = 9, .external_lex_state = 2},
  [314] = {.lex_state = 9, .external_lex_state = 2},
  [315] = {.lex_state = 9, .external_lex_state = 2},
  [316] = {.lex_state = 9, .external_lex_state = 2},
  [317] = {.lex_state = 9, .external_lex_state = 2},
  [318] = {.lex_state = 9, .external_lex_state = 2},
  [319] = {.lex_state = 9, .external_lex_state = 2},
  [320] = {.lex_state = 9, .external_lex_state = 2},
  [321] = {.lex_state = 9, .external_lex_state = 2},
  [322] = {.lex_state = 9, .external_lex_state = 2},
  [323] = {.lex_state = 9, .external_lex_state = 2},
  [324] = {.lex_state = 9, .external_lex_state = 2},
  [325] = {.lex_state = 9, .external_lex_state = 2},
  [326] = {.lex_state = 9, .external_lex_state = 2},
  [327] = {.lex_state = 9, .external_lex_state = 2},
  [328] = {.lex_state = 9, .external_lex_state = 2},
  [329] = {.lex_state = 9, .external_lex_state = 5},
  [330] = {.lex_state = 9, .external_lex_state = 2},
  [331] = {.lex_state = 9, .external_lex_state = 5},
  [332] = {.lex_state = 9, .external_lex_state = 2},
  [333] = {.lex_state = 9, .external_lex_state = 2},
  [334] = {.lex_state = 9, .external_lex_state = 2},
  [335] = {.lex_state = 9, .external_lex_state = 2},
  [336] = {.lex_state = 9, .external_lex_state = 2},
  [337] = {.lex_state = 9, .external_lex_state = 2},
  [338] = {.lex_state = 9, .external_lex_state = 2},
  [339] = {.lex_state = 9, .external_lex_state = 2},
  [340] = {.lex_state = 9, .external_lex_state = 2},
  [341] = {.lex_state = 9, .external_lex_state = 2},
  [342] = {.lex_state = 9, .external_lex_state = 2},
  [343] = {.lex_state = 9, .external_lex_state = 2},
  [344] = {.lex_state = 9, .external_lex_state = 2},
  [345] = {.lex_state = 9, .external_lex_state = 2},
  [346] = {.lex_state = 9, .external_lex_state = 2},
  [347] = {.lex_state = 9, .external_lex_state = 2},
  [348] = {.lex_state = 9, .external_lex_state = 2},
  [349] = {.lex_state = 9, .external_lex_state = 2},
  [350] = {.lex_state = 9, .external_lex_state = 2},
  [351] = {.lex_state = 9, .external_lex_state = 2},
  [352] = {.lex_state = 9, .external_lex_state = 2},
  [353] = {.lex_state = 9, .external_lex_state = 2},
  [354] = {.lex_state = 9, .external_lex_state = 2},
  [355] = {.lex_state = 9, .external_lex_state = 2},
  [356] = {.lex_state = 9, .external_lex_state = 2},
  [357] = {.lex_state = 9, .external_lex_state = 2},
  [358] = {.lex_state = 9, .external_lex_state = 2},
  [359] = {.lex_state = 9, .external_lex_state = 2},
  [360] = {.lex_state = 9, .external_lex_state = 2},
  [361] = {.lex_state = 9, .external_lex_state = 2},
  [362] = {.lex_state = 9, .external_lex_state = 2},
  [363] = {.lex_state = 9, .external_lex_state = 2},
  [364] = {.lex_state = 9, .external_lex_state = 2},
  [365] = {.lex_state = 9, .external_lex_state = 2},
  [366] = {.lex_state = 9, .external_lex_state = 2},
  [367] = {.lex_state = 9, .external_lex_state = 2},
  [368] = {.lex_state = 9, .external_lex_state = 2},
  [369] = {.lex_state = 9, .external_lex_state = 2},
  [370] = {.lex_state = 9, .external_lex_state = 2},
  [371] = {.lex_state = 9, .external_lex_state = 2},
  [372] = {.lex_state = 9, .external_lex_state = 2},
  [373] = {.lex_state = 9, .external_lex_state = 2},
  [374] = {.lex_state = 9, .external_lex_state = 2},
  [375] = {.lex_state = 9, .external_lex_state = 2},
  [376] = {.lex_state = 9, .external_lex_state = 2},
  [377] = {.lex_state = 9, .external_lex_state = 2},
  [378] = {.lex_state = 9, .external_lex_state = 2},
  [379] = {.lex_state = 9, .external_lex_state = 2},
  [380] = {.lex_state = 9, .external_lex_state = 2},
  [381] = {.lex_state = 9, .external_lex_state = 2},
  [382] = {.lex_state = 9, .external_lex_state = 2},
  [383] = {.lex_state = 9, .external_lex_state = 2},
  [384] = {.lex_state = 9, .external_lex_state = 2},
  [385] = {.lex_state = 9, .external_lex_state = 2},
  [386] = {.lex_state = 9, .external_lex_state = 2},
  [387] = {.lex_state = 9, .external_lex_state = 2},
  [388] = {.lex_state = 9, .external_lex_state = 2},
  [389] = {.lex_state = 9, .external_lex_state = 2},
  [390] = {.lex_state = 9, .external_lex_state = 2},
  [391] = {.lex_state = 9, .external_lex_state = 2},
  [392] = {.lex_state = 9, .external_lex_state = 2},
  [393] = {.lex_state = 9, .external_lex_state = 2},
  [394] = {.lex_state = 9, .external_lex_state = 2},
  [395] = {.lex_state = 9, .external_lex_state = 2},
  [396] = {.lex_state = 9, .external_lex_state = 2},
  [397] = {.lex_state = 9, .external_lex_state = 2},
  [398] = {.lex_state = 9, .external_lex_state = 2},
  [399] = {.lex_state = 9, .external_lex_state = 2},
  [400] = {.lex_state = 9, .external_lex_state = 2},
  [401] = {.lex_state = 9, .external_lex_state = 2},
  [402] = {.lex_state = 9, .external_lex_state = 2},
  [403] = {.lex_state = 9, .external_lex_state = 2},
  [404] = {.lex_state = 9, .external_lex_state = 2},
  [405] = {.lex_state = 9, .external_lex_state = 2},
  [406] = {.lex_state = 9, .external_lex_state = 2},
  [407] = {.lex_state = 9, .external_lex_state = 2},
  [408] = {.lex_state = 9, .external_lex_state = 2},
  [409] = {.lex_state = 9, .external_lex_state = 2},
  [410] = {.lex_state = 9, .external_lex_state = 2},
  [411] = {.lex_state = 9, .external_lex_state = 2},
  [412] = {.lex_state = 9, .external_lex_state = 2},
  [413] = {.lex_state = 9, .external_lex_state = 2},
  [414] = {.lex_state = 9, .external_lex_state = 2},
  [415] = {.lex_state = 9, .external_lex_state = 2},
  [416] = {.lex_state = 9, .external_lex_state = 2},
  [417] = {.lex_state = 9, .external_lex_state = 2},
  [418] = {.lex_state = 9, .external_lex_state = 2},
  [419] = {.lex_state = 9, .external_lex_state = 2},
  [420] = {.lex_state = 9, .external_lex_state = 2},
  [421] = {.lex_state = 9, .external_lex_state = 2},
  [422] = {.lex_state = 9, .external_lex_state = 2},
  [423] = {.lex_state = 9, .external_lex_state = 2},
  [424] = {.lex_state = 9, .external_lex_state = 2},
  [425] = {.lex_state = 9, .external_lex_state = 2},
  [426] = {.lex_state = 9, .external_lex_state = 2},
  [427] = {.lex_state = 9, .external_lex_state = 2},
  [428] = {.lex_state = 9, .external_lex_state = 2},
  [429] = {.lex_state = 9, .external_lex_state = 2},
  [430] = {.lex_state = 9, .external_lex_state = 2},
  [431] = {.lex_state = 9, .external_lex_state = 2},
  [432] = {.lex_state = 9, .external_lex_state = 2},
  [433] = {.lex_state = 9, .external_lex_state = 2},
  [434] = {.lex_state = 9, .external_lex_state = 2},
  [435] = {.lex_state = 9, .external_lex_state = 2},
  [436] = {.lex_state = 9, .external_lex_state = 2},
  [437] = {.lex_state = 9, .external_lex_state = 2},
  [438] = {.lex_state = 9, .external_lex_state = 2},
  [439] = {.lex_state = 9, .external_lex_state = 2},
  [440] = {.lex_state = 9, .external_lex_state = 2},
  [441] = {.lex_state = 9, .external_lex_state = 2},
  [442] = {.lex_state = 9, .external_lex_state = 2},
  [443] = {.lex_state = 9, .external_lex_state = 2},
  [444] = {.lex_state = 9, .external_lex_state = 2},
  [445] = {.lex_state = 9, .external_lex_state = 2},
  [446] = {.lex_state = 9, .external_lex_state = 2},
  [447] = {.lex_state = 9, .external_lex_state = 2},
  [448] = {.lex_state = 9, .external_lex_state = 2},
  [449] = {.lex_state = 9, .external_lex_state = 2},
  [450] = {.lex_state = 9, .external_lex_state = 2},
  [451] = {.lex_state = 9, .external_lex_state = 2},
  [452] = {.lex_state = 9, .external_lex_state = 2},
  [453] = {.lex_state = 9, .external_lex_state = 2},
  [454] = {.lex_state = 9, .external_lex_state = 2},
  [455] = {.lex_state = 9, .external_lex_state = 2},
  [456] = {.lex_state = 9, .external_lex_state = 2},
  [457] = {.lex_state = 9, .external_lex_state = 2},
  [458] = {.lex_state = 9, .external_lex_state = 2},
  [459] = {.lex_state = 9, .external_lex_state = 2},
  [460] = {.lex_state = 9, .external_lex_state = 2},
  [461] = {.lex_state = 9, .external_lex_state = 2},
  [462] = {.lex_state = 9, .external_lex_state = 2},
  [463] = {.lex_state = 9, .external_lex_state = 2},
  [464] = {.lex_state = 9, .external_lex_state = 2},
  [465] = {.lex_state = 9, .external_lex_state = 2},
  [466] = {.lex_state = 9, .external_lex_state = 2},
  [467] = {.lex_state = 9, .external_lex_state = 2},
  [468] = {.lex_state = 9, .external_lex_state = 2},
  [469] = {.lex_state = 9, .external_lex_state = 2},
  [470] = {.lex_state = 9, .external_lex_state = 2},
  [471] = {.lex_state = 9, .external_lex_state = 2},
  [472] = {.lex_state = 9, .external_lex_state = 2},
  [473] = {.lex_state = 9, .external_lex_state = 2},
  [474] = {.lex_state = 9, .external_lex_state = 2},
  [475] = {.lex_state = 9, .external_lex_state = 2},
  [476] = {.lex_state = 9, .external_lex_state = 2},
  [477] = {.lex_state = 9, .external_lex_state = 2},
  [478] = {.lex_state = 9, .external_lex_state = 2},
  [479] = {.lex_state = 9, .external_lex_state = 2},
  [480] = {.lex_state = 9, .external_lex_state = 2},
  [481] = {.lex_state = 9, .external_lex_state = 2},
  [482] = {.lex_state = 9, .external_lex_state = 2},
  [483] = {.lex_state = 9, .external_lex_state = 2},
  [484] = {.lex_state = 9, .external_lex_state = 2},
  [485] = {.lex_state = 9, .external_lex_state = 2},
  [486] = {.lex_state = 9, .external_lex_state = 2},
  [487] = {.lex_state = 9, .external_lex_state = 2},
  [488] = {.lex_state = 9, .external_lex_state = 2},
  [489] = {.lex_state = 9, .external_lex_state = 2},
  [490] = {.lex_state = 9, .external_lex_state = 2},
  [491] = {.lex_state = 9, .external_lex_state = 2},
  [492] = {.lex_state = 9, .external_lex_state = 2},
  [493] = {.lex_state = 9, .external_lex_state = 2},
  [494] = {.lex_state = 9, .external_lex_state = 2},
  [495] = {.lex_state = 9, .external_lex_state = 2},
  [496] = {.lex_state = 9, .external_lex_state = 2},
  [497] = {.lex_state = 9, .external_lex_state = 2},
  [498] = {.lex_state = 9, .external_lex_state = 2},
  [499] = {.lex_state = 9, .external_lex_state = 2},
  [500] = {.lex_state = 9, .external_lex_state = 2},
  [501] = {.lex_state = 9, .external_lex_state = 2},
  [502] = {.lex_state = 9, .external_lex_state = 2},
  [503] = {.lex_state = 9, .external_lex_state = 2},
  [504] = {.lex_state = 9, .external_lex_state = 2},
  [505] = {.lex_state = 9, .external_lex_state = 2},
  [506] = {.lex_state = 9, .external_lex_state = 2},
  [507] = {.lex_state = 9, .external_lex_state = 2},
  [508] = {.lex_state = 9, .external_lex_state = 2},
  [509] = {.lex_state = 9, .external_lex_state = 2},
  [510] = {.lex_state = 9, .external_lex_state = 2},
  [511] = {.lex_state = 9, .external_lex_state = 2},
  [512] = {.lex_state = 9, .external_lex_state = 2},
  [513] = {.lex_state = 9, .external_lex_state = 2},
  [514] = {.lex_state = 9, .external_lex_state = 2},
  [515] = {.lex_state = 9, .external_lex_state = 2},
  [516] = {.lex_state = 9, .external_lex_state = 2},
  [517] = {.lex_state = 9, .external_lex_state = 2},
  [518] = {.lex_state = 9, .external_lex_state = 2},
  [519] = {.lex_state = 9, .external_lex_state = 2},
  [520] = {.lex_state = 9, .external_lex_state = 2},
  [521] = {.lex_state = 9, .external_lex_state = 2},
  [522] = {.lex_state = 9, .external_lex_state = 2},
  [523] = {.lex_state = 9, .external_lex_state = 2},
  [524] = {.lex_state = 9, .external_lex_state = 2},
  [525] = {.lex_state = 9, .external_lex_state = 2},
  [526] = {.lex_state = 9, .external_lex_state = 2},
  [527] = {.lex_state = 9, .external_lex_state = 2},
  [528] = {.lex_state = 9, .external_lex_state = 2},
  [529] = {.lex_state = 9, .external_lex_state = 2},
  [530] = {.lex_state = 9, .external_lex_state = 2},
  [531] = {.lex_state = 9, .external_lex_state = 2},
  [532] = {.lex_state = 9, .external_lex_state = 2},
  [533] = {.lex_state = 9, .external_lex_state = 2},
  [534] = {.lex_state = 9, .external_lex_state = 2},
  [535] = {.lex_state = 9, .external_lex_state = 2},
  [536] = {.lex_state = 9, .external_lex_state = 2},
  [537] = {.lex_state = 9, .external_lex_state = 2},
  [538] = {.lex_state = 9, .external_lex_state = 2},
  [539] = {.lex_state = 9, .external_lex_state = 2},
  [540] = {.lex_state = 9, .external_lex_state = 2},
  [541] = {.lex_state = 9, .external_lex_state = 2},
  [542] = {.lex_state = 9, .external_lex_state = 2},
  [543] = {.lex_state = 9, .external_lex_state = 2},
  [544] = {.lex_state = 9, .external_lex_state = 2},
  [545] = {.lex_state = 9, .external_lex_state = 2},
  [546] = {.lex_state = 9, .external_lex_state = 2},
  [547] = {.lex_state = 9, .external_lex_state = 2},
  [548] = {.lex_state = 9, .external_lex_state = 2},
  [549] = {.lex_state = 9, .external_lex_state = 2},
  [550] = {.lex_state = 9, .external_lex_state = 2},
  [551] = {.lex_state = 9, .external_lex_state = 2},
  [552] = {.lex_state = 9, .external_lex_state = 2},
  [553] = {.lex_state = 9, .external_lex_state = 2},
  [554] = {.lex_state = 9, .external_lex_state = 2},
  [555] = {.lex_state = 9, .external_lex_state = 2},
  [556] = {.lex_state = 9, .external_lex_state = 2},
  [557] = {.lex_state = 9, .external_lex_state = 2},
  [558] = {.lex_state = 9, .external_lex_state = 2},
  [559] = {.lex_state = 9, .external_lex_state = 2},
  [560] = {.lex_state = 9, .external_lex_state = 2},
  [561] = {.lex_state = 9, .external_lex_state = 2},
  [562] = {.lex_state = 9, .external_lex_state = 2},
  [563] = {.lex_state = 9, .external_lex_state = 2},
  [564] = {.lex_state = 9, .external_lex_state = 2},
  [565] = {.lex_state = 9, .external_lex_state = 2},
  [566] = {.lex_state = 9, .external_lex_state = 2},
  [567] = {.lex_state = 9, .external_lex_state = 2},
  [568] = {.lex_state = 9, .external_lex_state = 2},
  [569] = {.lex_state = 9, .external_lex_state = 2},
  [570] = {.lex_state = 9, .external_lex_state = 2},
  [571] = {.lex_state = 9, .external_lex_state = 2},
  [572] = {.lex_state = 9, .external_lex_state = 2},
  [573] = {.lex_state = 9, .external_lex_state = 2},
  [574] = {.lex_state = 9, .external_lex_state = 2},
  [575] = {.lex_state = 9, .external_lex_state = 2},
  [576] = {.lex_state = 9, .external_lex_state = 2},
  [577] = {.lex_state = 9, .external_lex_state = 2},
  [578] = {.lex_state = 9, .external_lex_state = 2},
  [579] = {.lex_state = 9, .external_lex_state = 2},
  [580] = {.lex_state = 9, .external_lex_state = 2},
  [581] = {.lex_state = 9, .external_lex_state = 2},
  [582] = {.lex_state = 9, .external_lex_state = 2},
  [583] = {.lex_state = 9, .external_lex_state = 2},
  [584] = {.lex_state = 9, .external_lex_state = 2},
  [585] = {.lex_state = 9, .external_lex_state = 2},
  [586] = {.lex_state = 9, .external_lex_state = 2},
  [587] = {.lex_state = 9, .external_lex_state = 2},
  [588] = {.lex_state = 9, .external_lex_state = 2},
  [589] = {.lex_state = 9, .external_lex_state = 2},
  [590] = {.lex_state = 9, .external_lex_state = 2},
  [591] = {.lex_state = 9, .external_lex_state = 2},
  [592] = {.lex_state = 9, .external_lex_state = 2},
  [593] = {.lex_state = 9, .external_lex_state = 2},
  [594] = {.lex_state = 9, .external_lex_state = 2},
  [595] = {.lex_state = 9, .external_lex_state = 2},
  [596] = {.lex_state = 9, .external_lex_state = 2},
  [597] = {.lex_state = 9, .external_lex_state = 2},
  [598] = {.lex_state = 9, .external_lex_state = 2},
  [599] = {.lex_state = 9, .external_lex_state = 2},
  [600] = {.lex_state = 9, .external_lex_state = 2},
  [601] = {.lex_state = 9, .external_lex_state = 2},
  [602] = {.lex_state = 9, .external_lex_state = 2},
  [603] = {.lex_state = 9, .external_lex_state = 2},
  [604] = {.lex_state = 9, .external_lex_state = 2},
  [605] = {.lex_state = 9, .external_lex_state = 2},
  [606] = {.lex_state = 9, .external_lex_state = 2},
  [607] = {.lex_state = 9, .external_lex_state = 2},
  [608] = {.lex_state = 9, .external_lex_state = 2},
  [609] = {.lex_state = 9, .external_lex_state = 2},
  [610] = {.lex_state = 9, .external_lex_state = 2},
  [611] = {.lex_state = 9, .external_lex_state = 2},
  [612] = {.lex_state = 9, .external_lex_state = 2},
  [613] = {.lex_state = 9, .external_lex_state = 2},
  [614] = {.lex_state = 9, .external_lex_state = 2},
  [615] = {.lex_state = 9, .external_lex_state = 2},
  [616] = {.lex_state = 9, .external_lex_state = 2},
  [617] = {.lex_state = 9, .external_lex_state = 2},
  [618] = {.lex_state = 9, .external_lex_state = 2},
  [619] = {.lex_state = 9, .external_lex_state = 2},
  [620] = {.lex_state = 9, .external_lex_state = 2},
  [621] = {.lex_state = 9, .external_lex_state = 2},
  [622] = {.lex_state = 9, .external_lex_state = 2},
  [623] = {.lex_state = 9, .external_lex_state = 2},
  [624] = {.lex_state = 9, .external_lex_state = 2},
  [625] = {.lex_state = 9, .external_lex_state = 2},
  [626] = {.lex_state = 9, .external_lex_state = 2},
  [627] = {.lex_state = 9, .external_lex_state = 2},
  [628] = {.lex_state = 9, .external_lex_state = 2},
  [629] = {.lex_state = 9, .external_lex_state = 2},
  [630] = {.lex_state = 9, .external_lex_state = 2},
  [631] = {.lex_state = 9, .external_lex_state = 2},
  [632] = {.lex_state = 9, .external_lex_state = 2},
  [633] = {.lex_state = 9, .external_lex_state = 2},
  [634] = {.lex_state = 9, .external_lex_state = 2},
  [635] = {.lex_state = 9, .external_lex_state = 2},
  [636] = {.lex_state = 9, .external_lex_state = 2},
  [637] = {.lex_state = 9, .external_lex_state = 2},
  [638] = {.lex_state = 9, .external_lex_state = 2},
  [639] = {.lex_state = 9, .external_lex_state = 2},
  [640] = {.lex_state = 9, .external_lex_state = 2},
  [641] = {.lex_state = 9, .external_lex_state = 2},
  [642] = {.lex_state = 9, .external_lex_state = 2},
  [643] = {.lex_state = 9, .external_lex_state = 2},
  [644] = {.lex_state = 9, .external_lex_state = 2},
  [645] = {.lex_state = 9, .external_lex_state = 2},
  [646] = {.lex_state = 9, .external_lex_state = 2},
  [647] = {.lex_state = 9, .external_lex_state = 2},
  [648] = {.lex_state = 9, .external_lex_state = 2},
  [649] = {.lex_state = 9, .external_lex_state = 2},
  [650] = {.lex_state = 9, .external_lex_state = 2},
  [651] = {.lex_state = 9, .external_lex_state = 2},
  [652] = {.lex_state = 9, .external_lex_state = 2},
  [653] = {.lex_state = 9, .external_lex_state = 2},
  [654] = {.lex_state = 9, .external_lex_state = 2},
  [655] = {.lex_state = 9, .external_lex_state = 2},
  [656] = {.lex_state = 9, .external_lex_state = 2},
  [657] = {.lex_state = 9, .external_lex_state = 2},
  [658] = {.lex_state = 9, .external_lex_state = 2},
  [659] = {.lex_state = 9, .external_lex_state = 2},
  [660] = {.lex_state = 9, .external_lex_state = 2},
  [661] = {.lex_state = 9, .external_lex_state = 2},
  [662] = {.lex_state = 9, .external_lex_state = 2},
  [663] = {.lex_state = 9, .external_lex_state = 2},
  [664] = {.lex_state = 9, .external_lex_state = 2},
  [665] = {.lex_state = 9, .external_lex_state = 2},
  [666] = {.lex_state = 9, .external_lex_state = 2},
  [667] = {.lex_state = 9, .external_lex_state = 2},
  [668] = {.lex_state = 9, .external_lex_state = 2},
  [669] = {.lex_state = 9, .external_lex_state = 2},
  [670] = {.lex_state = 9, .external_lex_state = 2},
  [671] = {.lex_state = 9, .external_lex_state = 2},
  [672] = {.lex_state = 9, .external_lex_state = 2},
  [673] = {.lex_state = 9, .external_lex_state = 2},
  [674] = {.lex_state = 9, .external_lex_state = 2},
  [675] = {.lex_state = 9, .external_lex_state = 2},
  [676] = {.lex_state = 9, .external_lex_state = 2},
  [677] = {.lex_state = 9, .external_lex_state = 2},
  [678] = {.lex_state = 9, .external_lex_state = 2},
  [679] = {.lex_state = 9, .external_lex_state = 2},
  [680] = {.lex_state = 9, .external_lex_state = 2},
  [681] = {.lex_state = 9, .external_lex_state = 2},
  [682] = {.lex_state = 9, .external_lex_state = 2},
  [683] = {.lex_state = 9, .external_lex_state = 2},
  [684] = {.lex_state = 9, .external_lex_state = 2},
  [685] = {.lex_state = 9, .external_lex_state = 2},
  [686] = {.lex_state = 9, .external_lex_state = 2},
  [687] = {.lex_state = 9, .external_lex_state = 2},
  [688] = {.lex_state = 77, .external_lex_state = 4},
  [689] = {.lex_state = 77, .external_lex_state = 4},
  [690] = {.lex_state = 77, .external_lex_state = 4},
  [691] = {.lex_state = 77, .external_lex_state = 4},
  [692] = {.lex_state = 77, .external_lex_state = 4},
  [693] = {.lex_state = 77, .external_lex_state = 4},
  [694] = {.lex_state = 77, .external_lex_state = 4},
  [695] = {.lex_state = 77, .external_lex_state = 4},
  [696] = {.lex_state = 77, .external_lex_state = 4},
  [697] = {.lex_state = 77, .external_lex_state = 4},
  [698] = {.lex_state = 77, .external_lex_state = 4},
  [699] = {.lex_state = 77, .external_lex_state = 4},
  [700] = {.lex_state = 77, .external_lex_state = 4},
  [701] = {.lex_state = 77, .external_lex_state = 4},
  [702] = {.lex_state = 77, .external_lex_state = 4},
  [703] = {.lex_state = 77, .external_lex_state = 4},
  [704] = {.lex_state = 4, .external_lex_state = 4},
  [705] = {.lex_state = 4, .external_lex_state = 4},
  [706] = {.lex_state = 4, .external_lex_state = 4},
  [707] = {.lex_state = 4, .external_lex_state = 4},
  [708] = {.lex_state = 9, .external_lex_state = 2},
  [709] = {.lex_state = 77, .external_lex_state = 4},
  [710] = {.lex_state = 77, .external_lex_state = 4},
  [711] = {.lex_state = 77, .external_lex_state = 4},
  [712] = {.lex_state = 77, .external_lex_state = 4},
  [713] = {.lex_state = 77, .external_lex_state = 4},
  [714] = {.lex_state = 9, .external_lex_state = 2},
  [715] = {.lex_state = 77, .external_lex_state = 4},
  [716] = {.lex_state = 9, .external_lex_state = 2},
  [717] = {.lex_state = 9, .external_lex_state = 2},
  [718] = {.lex_state = 77, .external_lex_state = 4},
  [719] = {.lex_state = 9, .external_lex_state = 2},
  [720] = {.lex_state = 77, .external_lex_state = 4},
  [721] = {.lex_state = 9, .external_lex_state = 2},
  [722] = {.lex_state = 9, .external_lex_state = 2},
  [723] = {.lex_state = 4, .external_lex_state = 4},
  [724] = {.lex_state = 4, .external_lex_state = 4},
  [725] = {.lex_state = 4, .external_lex_state = 4},
  [726] = {.lex_state = 4, .external_lex_state = 4},
  [727] = {.lex_state = 4, .external_lex_state = 4},
  [728] = {.lex_state = 4, .external_lex_state = 3},
  [729] = {.lex_state = 4, .external_lex_state = 4},
  [730] = {.lex_state = 4, .external_lex_state = 3},
  [731] = {.lex_state = 4, .external_lex_state = 4},
  [732] = {.lex_state = 4, .external_lex_state = 3},
  [733] = {.lex_state = 4, .external_lex_state = 3},
  [734] = {.lex_state = 4, .external_lex_state = 3},
  [735] = {.lex_state = 4, .external_lex_state = 4},
  [736] = {.lex_state = 4, .external_lex_state = 4},
  [737] = {.lex_state = 4, .external_lex_state = 4},
  [738] = {.lex_state = 4, .external_lex_state = 4},
  [739] = {.lex_state = 4, .external_lex_state = 4},
  [740] = {.lex_state = 4, .external_lex_state = 4},
  [741] = {.lex_state = 4, .external_lex_state = 3},
  [742] = {.lex_state = 4, .external_lex_state = 3},
  [743] = {.lex_state = 4, .external_lex_state = 4},
  [744] = {.lex_state = 4, .external_lex_state = 3},
  [745] = {.lex_state = 4, .external_lex_state = 4},
  [746] = {.lex_state = 4, .external_lex_state = 3},
  [747] = {.lex_state = 4, .external_lex_state = 4},
  [748] = {.lex_state = 4, .external_lex_state = 3},
  [749] = {.lex_state = 4, .external_lex_state = 4},
  [750] = {.lex_state = 4, .external_lex_state = 4},
  [751] = {.lex_state = 4, .external_lex_state = 4},
  [752] = {.lex_state = 4, .external_lex_state = 4},
  [753] = {.lex_state = 4, .external_lex_state = 3},
  [754] = {.lex_state = 4, .external_lex_state = 4},
  [755] = {.lex_state = 4, .external_lex_state = 3},
  [756] = {.lex_state = 4, .external_lex_state = 4},
  [757] = {.lex_state = 4, .external_lex_state = 4},
  [758] = {.lex_state = 4, .external_lex_state = 4},
  [759] = {.lex_state = 4, .external_lex_state = 3},
  [760] = {.lex_state = 4, .external_lex_state = 4},
  [761] = {.lex_state = 4, .external_lex_state = 3},
  [762] = {.lex_state = 9, .external_lex_state = 2},
  [763] = {.lex_state = 4, .external_lex_state = 4},
  [764] = {.lex_state = 4, .external_lex_state = 4},
  [765] = {.lex_state = 4, .external_lex_state = 3},
  [766] = {.lex_state = 4, .external_lex_state = 4},
  [767] = {.lex_state = 4, .external_lex_state = 3},
  [768] = {.lex_state = 4, .external_lex_state = 3},
  [769] = {.lex_state = 4, .external_lex_state = 4},
  [770] = {.lex_state = 4, .external_lex_state = 3},
  [771] = {.lex_state = 4, .external_lex_state = 3},
  [772] = {.lex_state = 4, .external_lex_state = 3},
  [773] = {.lex_state = 9, .external_lex_state = 5},
  [774] = {.lex_state = 9, .external_lex_state = 5},
  [775] = {.lex_state = 9, .external_lex_state = 5},
  [776] = {.lex_state = 4, .external_lex_state = 3},
  [777] = {.lex_state = 4, .external_lex_state = 3},
  [778] = {.lex_state = 4, .external_lex_state = 3},
  [779] = {.lex_state = 4, .external_lex_state = 3},
  [780] = {.lex_state = 4, .external_lex_state = 3},
  [781] = {.lex_state = 4, .external_lex_state = 3},
  [782] = {.lex_state = 4, .external_lex_state = 3},
  [783] = {.lex_state = 9, .external_lex_state = 5},
  [784] = {.lex_state = 4, .external_lex_state = 3},
  [785] = {.lex_state = 4, .external_lex_state = 3},
  [786] = {.lex_state = 4, .external_lex_state = 3},
  [787] = {.lex_state = 4, .external_lex_state = 3},
  [788] = {.lex_state = 9, .external_lex_state = 2},
  [789] = {.lex_state = 9, .external_lex_state = 2},
  [790] = {.lex_state = 9, .external_lex_state = 2},
  [791] = {.lex_state = 9, .external_lex_state = 2},
  [792] = {.lex_state = 9, .external_lex_state = 2},
  [793] = {.lex_state = 9, .external_lex_state = 5},
  [794] = {.lex_state = 9, .external_lex_state = 5},
  [795] = {.lex_state = 9, .external_lex_state = 5},
  [796] = {.lex_state = 9, .external_lex_state = 5},
  [797] = {.lex_state = 9, .external_lex_state = 5},
  [798] = {.lex_state = 9, .external_lex_state = 2},
  [799] = {.lex_state = 9, .external_lex_state = 2},
  [800] = {.lex_state = 9, .external_lex_state = 5},
  [801] = {.lex_state = 9, .external_lex_state = 2},
  [802] = {.lex_state = 9, .external_lex_state = 5},
  [803] = {.lex_state = 9, .external_lex_state = 2},
  [804] = {.lex_state = 9, .external_lex_state = 5},
  [805] = {.lex_state = 9, .external_lex_state = 5},
  [806] = {.lex_state = 9, .external_lex_state = 5},
  [807] = {.lex_state = 9, .external_lex_state = 5},
  [808] = {.lex_state = 9, .external_lex_state = 5},
  [809] = {.lex_state = 9, .external_lex_state = 5},
  [810] = {.lex_state = 9, .external_lex_state = 2},
  [811] = {.lex_state = 9, .external_lex_state = 2},
  [812] = {.lex_state = 9, .external_lex_state = 5},
  [813] = {.lex_state = 9, .external_lex_state = 5},
  [814] = {.lex_state = 9, .external_lex_state = 2},
  [815] = {.lex_state = 9, .external_lex_state = 2},
  [816] = {.lex_state = 9, .external_lex_state = 5},
  [817] = {.lex_state = 9, .external_lex_state = 5},
  [818] = {.lex_state = 9, .external_lex_state = 5},
  [819] = {.lex_state = 9, .external_lex_state = 5},
  [820] = {.lex_state = 9, .external_lex_state = 2},
  [821] = {.lex_state = 9, .external_lex_state = 2},
  [822] = {.lex_state = 9, .external_lex_state = 2},
  [823] = {.lex_state = 9, .external_lex_state = 2},
  [824] = {.lex_state = 9, .external_lex_state = 2},
  [825] = {.lex_state = 9, .external_lex_state = 2},
  [826] = {.lex_state = 9, .external_lex_state = 2},
  [827] = {.lex_state = 9, .external_lex_state = 2},
  [828] = {.lex_state = 9, .external_lex_state = 2},
  [829] = {.lex_state = 9, .external_lex_state = 2},
  [830] = {.lex_state = 9, .external_lex_state = 2},
  [831] = {.lex_state = 9, .external_lex_state = 2},
  [832] = {.lex_state = 9, .external_lex_state = 2},
  [833] = {.lex_state = 9, .external_lex_state = 2},
  [834] = {.lex_state = 9, .external_lex_state = 2},
  [835] = {.lex_state = 9, .external_lex_state = 2},
  [836] = {.lex_state = 9, .external_lex_state = 2},
  [837] = {.lex_state = 9, .external_lex_state = 2},
  [838] = {.lex_state = 9, .external_lex_state = 2},
  [839] = {.lex_state = 9, .external_lex_state = 2},
  [840] = {.lex_state = 9, .external_lex_state = 2},
  [841] = {.lex_state = 9, .external_lex_state = 2},
  [842] = {.lex_state = 9, .external_lex_state = 2},
  [843] = {.lex_state = 9, .external_lex_state = 2},
  [844] = {.lex_state = 9, .external_lex_state = 2},
  [845] = {.lex_state = 9, .external_lex_state = 2},
  [846] = {.lex_state = 9, .external_lex_state = 2},
  [847] = {.lex_state = 9, .external_lex_state = 2},
  [848] = {.lex_state = 9, .external_lex_state = 2},
  [849] = {.lex_state = 9, .external_lex_state = 2},
  [850] = {.lex_state = 9, .external_lex_state = 2},
  [851] = {.lex_state = 9, .external_lex_state = 2},
  [852] = {.lex_state = 9, .external_lex_state = 2},
  [853] = {.lex_state = 9, .external_lex_state = 2},
  [854] = {.lex_state = 9, .external_lex_state = 2},
  [855] = {.lex_state = 9, .external_lex_state = 2},
  [856] = {.lex_state = 9, .external_lex_state = 2},
  [857] = {.lex_state = 9, .external_lex_state = 2},
  [858] = {.lex_state = 9, .external_lex_state = 2},
  [859] = {.lex_state = 9, .external_lex_state = 2},
  [860] = {.lex_state = 9, .external_lex_state = 2},
  [861] = {.lex_state = 9, .external_lex_state = 2},
  [862] = {.lex_state = 9, .external_lex_state = 2},
  [863] = {.lex_state = 9, .external_lex_state = 2},
  [864] = {.lex_state = 9, .external_lex_state = 2},
  [865] = {.lex_state = 9, .external_lex_state = 2},
  [866] = {.lex_state = 9, .external_lex_state = 2},
  [867] = {.lex_state = 9, .external_lex_state = 2},
  [868] = {.lex_state = 9, .external_lex_state = 2},
  [869] = {.lex_state = 9, .external_lex_state = 2},
  [870] = {.lex_state = 9, .external_lex_state = 2},
  [871] = {.lex_state = 9, .external_lex_state = 2},
  [872] = {.lex_state = 9, .external_lex_state = 2},
  [873] = {.lex_state = 9, .external_lex_state = 2},
  [874] = {.lex_state = 9, .external_lex_state = 2},
  [875] = {.lex_state = 9, .external_lex_state = 2},
  [876] = {.lex_state = 9, .external_lex_state = 2},
  [877] = {.lex_state = 9, .external_lex_state = 2},
  [878] = {.lex_state = 9, .external_lex_state = 2},
  [879] = {.lex_state = 9, .external_lex_state = 2},
  [880] = {.lex_state = 9, .external_lex_state = 2},
  [881] = {.lex_state = 9, .external_lex_state = 2},
  [882] = {.lex_state = 9, .external_lex_state = 2},
  [883] = {.lex_state = 9, .external_lex_state = 2},
  [884] = {.lex_state = 9, .external_lex_state = 2},
  [885] = {.lex_state = 9, .external_lex_state = 2},
  [886] = {.lex_state = 9, .external_lex_state = 2},
  [887] = {.lex_state = 9, .external_lex_state = 2},
  [888] = {.lex_state = 9, .external_lex_state = 2},
  [889] = {.lex_state = 9, .external_lex_state = 2},
  [890] = {.lex_state = 9, .external_lex_state = 2},
  [891] = {.lex_state = 9, .external_lex_state = 2},
  [892] = {.lex_state = 9, .external_lex_state = 2},
  [893] = {.lex_state = 9, .external_lex_state = 2},
  [894] = {.lex_state = 9, .external_lex_state = 2},
  [895] = {.lex_state = 9, .external_lex_state = 2},
  [896] = {.lex_state = 9, .external_lex_state = 2},
  [897] = {.lex_state = 9, .external_lex_state = 2},
  [898] = {.lex_state = 9, .external_lex_state = 2},
  [899] = {.lex_state = 9, .external_lex_state = 2},
  [900] = {.lex_state = 9, .external_lex_state = 2},
  [901] = {.lex_state = 9, .external_lex_state = 2},
  [902] = {.lex_state = 9, .external_lex_state = 2},
  [903] = {.lex_state = 9, .external_lex_state = 2},
  [904] = {.lex_state = 9, .external_lex_state = 2},
  [905] = {.lex_state = 9, .external_lex_state = 2},
  [906] = {.lex_state = 9, .external_lex_state = 2},
  [907] = {.lex_state = 9, .external_lex_state = 2},
  [908] = {.lex_state = 9, .external_lex_state = 2},
  [909] = {.lex_state = 9, .external_lex_state = 2},
  [910] = {.lex_state = 9, .external_lex_state = 2},
  [911] = {.lex_state = 9, .external_lex_state = 2},
  [912] = {.lex_state = 9, .external_lex_state = 2},
  [913] = {.lex_state = 9, .external_lex_state = 2},
  [914] = {.lex_state = 9, .external_lex_state = 2},
  [915] = {.lex_state = 9, .external_lex_state = 2},
  [916] = {.lex_state = 9, .external_lex_state = 2},
  [917] = {.lex_state = 9, .external_lex_state = 2},
  [918] = {.lex_state = 9, .external_lex_state = 2},
  [919] = {.lex_state = 9, .external_lex_state = 2},
  [920] = {.lex_state = 9, .external_lex_state = 2},
  [921] = {.lex_state = 9, .external_lex_state = 2},
  [922] = {.lex_state = 9, .external_lex_state = 2},
  [923] = {.lex_state = 9, .external_lex_state = 2},
  [924] = {.lex_state = 9, .external_lex_state = 2},
  [925] = {.lex_state = 9, .external_lex_state = 2},
  [926] = {.lex_state = 9, .external_lex_state = 2},
  [927] = {.lex_state = 9, .external_lex_state = 2},
  [928] = {.lex_state = 9, .external_lex_state = 2},
  [929] = {.lex_state = 9, .external_lex_state = 2},
  [930] = {.lex_state = 9, .external_lex_state = 2},
  [931] = {.lex_state = 9, .external_lex_state = 2},
  [932] = {.lex_state = 9, .external_lex_state = 2},
  [933] = {.lex_state = 9, .external_lex_state = 2},
  [934] = {.lex_state = 9, .external_lex_state = 2},
  [935] = {.lex_state = 9, .external_lex_state = 2},
  [936] = {.lex_state = 9, .external_lex_state = 2},
  [937] = {.lex_state = 9, .external_lex_state = 2},
  [938] = {.lex_state = 9, .external_lex_state = 2},
  [939] = {.lex_state = 9, .external_lex_state = 2},
  [940] = {.lex_state = 9, .external_lex_state = 2},
  [941] = {.lex_state = 9, .external_lex_state = 2},
  [942] = {.lex_state = 9, .external_lex_state = 2},
  [943] = {.lex_state = 9, .external_lex_state = 2},
  [944] = {.lex_state = 9, .external_lex_state = 2},
  [945] = {.lex_state = 9, .external_lex_state = 2},
  [946] = {.lex_state = 9, .external_lex_state = 2},
  [947] = {.lex_state = 9, .external_lex_state = 2},
  [948] = {.lex_state = 9, .external_lex_state = 2},
  [949] = {.lex_state = 9, .external_lex_state = 2},
  [950] = {.lex_state = 9, .external_lex_state = 2},
  [951] = {.lex_state = 9, .external_lex_state = 2},
  [952] = {.lex_state = 9, .external_lex_state = 2},
  [953] = {.lex_state = 9, .external_lex_state = 2},
  [954] = {.lex_state = 9, .external_lex_state = 2},
  [955] = {.lex_state = 9, .external_lex_state = 2},
  [956] = {.lex_state = 9, .external_lex_state = 2},
  [957] = {.lex_state = 12, .external_lex_state = 2},
  [958] = {.lex_state = 12, .external_lex_state = 2},
  [959] = {.lex_state = 12, .external_lex_state = 2},
  [960] = {.lex_state = 12, .external_lex_state = 2},
  [961] = {.lex_state = 12, .external_lex_state = 2},
  [962] = {.lex_state = 12, .external_lex_state = 2},
  [963] = {.lex_state = 12, .external_lex_state = 2},
  [964] = {.lex_state = 12, .external_lex_state = 2},
  [965] = {.lex_state = 12, .external_lex_state = 2},
  [966] = {.lex_state = 12, .external_lex_state = 2},
  [967] = {.lex_state = 12, .external_lex_state = 2},
  [968] = {.lex_state = 12, .external_lex_state = 2},
  [969] = {.lex_state = 12, .external_lex_state = 2},
  [970] = {.lex_state = 12, .external_lex_state = 2},
  [971] = {.lex_state = 12, .external_lex_state = 2},
  [972] = {.lex_state = 5, .external_lex_state = 4},
  [973] = {.lex_state = 5, .external_lex_state = 4},
  [974] = {.lex_state = 12, .external_lex_state = 2},
  [975] = {.lex_state = 5, .external_lex_state = 4},
  [976] = {.lex_state = 5, .external_lex_state = 4},
  [977] = {.lex_state = 5, .external_lex_state = 4},
  [978] = {.lex_state = 5, .external_lex_state = 4},
  [979] = {.lex_state = 5, .external_lex_state = 4},
  [980] = {.lex_state = 5, .external_lex_state = 4},
  [981] = {.lex_state = 5, .external_lex_state = 4},
  [982] = {.lex_state = 5, .external_lex_state = 4},
  [983] = {.lex_state = 5, .external_lex_state = 4},
  [984] = {.lex_state = 5, .external_lex_state = 4},
  [985] = {.lex_state = 5, .external_lex_state = 4},
  [986] = {.lex_state = 5, .external_lex_state = 4},
  [987] = {.lex_state = 5, .external_lex_state = 4},
  [988] = {.lex_state = 5, .external_lex_state = 4},
  [989] = {.lex_state = 5, .external_lex_state = 4},
  [990] = {.lex_state = 5, .external_lex_state = 4},
  [991] = {.lex_state = 5, .external_lex_state = 4},
  [992] = {.lex_state = 5, .external_lex_state = 4},
  [993] = {.lex_state = 5, .external_lex_state = 4},
  [994] = {.lex_state = 5, .external_lex_state = 4},
  [995] = {.lex_state = 5, .external_lex_state = 4},
  [996] = {.lex_state = 5, .external_lex_state = 4},
  [997] = {.lex_state = 5, .external_lex_state = 4},
  [998] = {.lex_state = 5, .external_lex_state = 4},
  [999] = {.lex_state = 13, .external_lex_state = 2},
  [1000] = {.lex_state = 13, .external_lex_state = 2},
  [1001] = {.lex_state = 13, .external_lex_state = 2},
  [1002] = {.lex_state = 5, .external_lex_state = 4},
  [1003] = {.lex_state = 13, .external_lex_state = 2},
  [1004] = {.lex_state = 5, .external_lex_state = 4},
  [1005] = {.lex_state = 13, .external_lex_state = 2},
  [1006] = {.lex_state = 13, .external_lex_state = 2},
  [1007] = {.lex_state = 13, .external_lex_state = 2},
  [1008] = {.lex_state = 13, .external_lex_state = 2},
  [1009] = {.lex_state = 13, .external_lex_state = 2},
  [1010] = {.lex_state = 13, .external_lex_state = 2},
  [1011] = {.lex_state = 13, .external_lex_state = 2},
  [1012] = {.lex_state = 5, .external_lex_state = 4},
  [1013] = {.lex_state = 13, .external_lex_state = 2},
  [1014] = {.lex_state = 13, .external_lex_state = 2},
  [1015] = {.lex_state = 9, .external_lex_state = 2},
  [1016] = {.lex_state = 9, .external_lex_state = 2},
  [1017] = {.lex_state = 9, .external_lex_state = 2},
  [1018] = {.lex_state = 12, .external_lex_state = 2},
  [1019] = {.lex_state = 12, .external_lex_state = 2},
  [1020] = {.lex_state = 12, .external_lex_state = 2},
  [1021] = {.lex_state = 12, .external_lex_state = 2},
  [1022] = {.lex_state = 12, .external_lex_state = 2},
  [1023] = {.lex_state = 12, .external_lex_state = 2},
  [1024] = {.lex_state = 12, .external_lex_state = 2},
  [1025] = {.lex_state = 12, .external_lex_state = 2},
  [1026] = {.lex_state = 12, .external_lex_state = 2},
  [1027] = {.lex_state = 12, .external_lex_state = 2},
  [1028] = {.lex_state = 12, .external_lex_state = 2},
  [1029] = {.lex_state = 12, .external_lex_state = 2},
  [1030] = {.lex_state = 12, .external_lex_state = 2},
  [1031] = {.lex_state = 12, .external_lex_state = 2},
  [1032] = {.lex_state = 12, .external_lex_state = 2},
  [1033] = {.lex_state = 12, .external_lex_state = 2},
  [1034] = {.lex_state = 12, .external_lex_state = 2},
  [1035] = {.lex_state = 12, .external_lex_state = 2},
  [1036] = {.lex_state = 12, .external_lex_state = 2},
  [1037] = {.lex_state = 12, .external_lex_state = 2},
  [1038] = {.lex_state = 12, .external_lex_state = 2},
  [1039] = {.lex_state = 12, .external_lex_state = 2},
  [1040] = {.lex_state = 12, .external_lex_state = 2},
  [1041] = {.lex_state = 12, .external_lex_state = 2},
  [1042] = {.lex_state = 13, .external_lex_state = 2},
  [1043] = {.lex_state = 12, .external_lex_state = 2},
  [1044] = {.lex_state = 12, .external_lex_state = 2},
  [1045] = {.lex_state = 12, .external_lex_state = 2},
  [1046] = {.lex_state = 12, .external_lex_state = 2},
  [1047] = {.lex_state = 12, .external_lex_state = 2},
  [1048] = {.lex_state = 12, .external_lex_state = 2},
  [1049] = {.lex_state = 13, .external_lex_state = 2},
  [1050] = {.lex_state = 12, .external_lex_state = 2},
  [1051] = {.lex_state = 12, .external_lex_state = 2},
  [1052] = {.lex_state = 12, .external_lex_state = 2},
  [1053] = {.lex_state = 12, .external_lex_state = 2},
  [1054] = {.lex_state = 12, .external_lex_state = 2},
  [1055] = {.lex_state = 12, .external_lex_state = 2},
  [1056] = {.lex_state = 12, .external_lex_state = 2},
  [1057] = {.lex_state = 12, .external_lex_state = 2},
  [1058] = {.lex_state = 12, .external_lex_state = 2},
  [1059] = {.lex_state = 12, .external_lex_state = 2},
  [1060] = {.lex_state = 12, .external_lex_state = 2},
  [1061] = {.lex_state = 12, .external_lex_state = 2},
  [1062] = {.lex_state = 12, .external_lex_state = 2},
  [1063] = {.lex_state = 12, .external_lex_state = 2},
  [1064] = {.lex_state = 12, .external_lex_state = 2},
  [1065] = {.lex_state = 12, .external_lex_state = 2},
  [1066] = {.lex_state = 12, .external_lex_state = 2},
  [1067] = {.lex_state = 12, .external_lex_state = 2},
  [1068] = {.lex_state = 12, .external_lex_state = 2},
  [1069] = {.lex_state = 12, .external_lex_state = 2},
  [1070] = {.lex_state = 12, .external_lex_state = 2},
  [1071] = {.lex_state = 12, .external_lex_state = 2},
  [1072] = {.lex_state = 12, .external_lex_state = 2},
  [1073] = {.lex_state = 12, .external_lex_state = 2},
  [1074] = {.lex_state = 12, .external_lex_state = 2},
  [1075] = {.lex_state = 12, .external_lex_state = 2},
  [1076] = {.lex_state = 12, .external_lex_state = 2},
  [1077] = {.lex_state = 12, .external_lex_state = 2},
  [1078] = {.lex_state = 12, .external_lex_state = 2},
  [1079] = {.lex_state = 12, .external_lex_state = 2},
  [1080] = {.lex_state = 12, .external_lex_state = 2},
  [1081] = {.lex_state = 12, .external_lex_state = 2},
  [1082] = {.lex_state = 12, .external_lex_state = 2},
  [1083] = {.lex_state = 12, .external_lex_state = 2},
  [1084] = {.lex_state = 12, .external_lex_state = 2},
  [1085] = {.lex_state = 12, .external_lex_state = 2},
  [1086] = {.lex_state = 12, .external_lex_state = 2},
  [1087] = {.lex_state = 12, .external_lex_state = 2},
  [1088] = {.lex_state = 12, .external_lex_state = 2},
  [1089] = {.lex_state = 12, .external_lex_state = 2},
  [1090] = {.lex_state = 12, .external_lex_state = 2},
  [1091] = {.lex_state = 12, .external_lex_state = 2},
  [1092] = {.lex_state = 12, .external_lex_state = 2},
  [1093] = {.lex_state = 12, .external_lex_state = 2},
  [1094] = {.lex_state = 12, .external_lex_state = 2},
  [1095] = {.lex_state = 12, .external_lex_state = 2},
  [1096] = {.lex_state = 12, .external_lex_state = 2},
  [1097] = {.lex_state = 12, .external_lex_state = 2},
  [1098] = {.lex_state = 12, .external_lex_state = 2},
  [1099] = {.lex_state = 12, .external_lex_state = 2},
  [1100] = {.lex_state = 12, .external_lex_state = 2},
  [1101] = {.lex_state = 12, .external_lex_state = 2},
  [1102] = {.lex_state = 12, .external_lex_state = 2},
  [1103] = {.lex_state = 12, .external_lex_state = 2},
  [1104] = {.lex_state = 12, .external_lex_state = 2},
  [1105] = {.lex_state = 12, .external_lex_state = 2},
  [1106] = {.lex_state = 12, .external_lex_state = 2},
  [1107] = {.lex_state = 12, .external_lex_state = 2},
  [1108] = {.lex_state = 12, .external_lex_state = 2},
  [1109] = {.lex_state = 12, .external_lex_state = 2},
  [1110] = {.lex_state = 12, .external_lex_state = 2},
  [1111] = {.lex_state = 12, .external_lex_state = 2},
  [1112] = {.lex_state = 12, .external_lex_state = 2},
  [1113] = {.lex_state = 12, .external_lex_state = 2},
  [1114] = {.lex_state = 12, .external_lex_state = 2},
  [1115] = {.lex_state = 12, .external_lex_state = 2},
  [1116] = {.lex_state = 12, .external_lex_state = 2},
  [1117] = {.lex_state = 12, .external_lex_state = 2},
  [1118] = {.lex_state = 12, .external_lex_state = 2},
  [1119] = {.lex_state = 12, .external_lex_state = 2},
  [1120] = {.lex_state = 12, .external_lex_state = 2},
  [1121] = {.lex_state = 12, .external_lex_state = 2},
  [1122] = {.lex_state = 12, .external_lex_state = 2},
  [1123] = {.lex_state = 12, .external_lex_state = 2},
  [1124] = {.lex_state = 12, .external_lex_state = 2},
  [1125] = {.lex_state = 12, .external_lex_state = 2},
  [1126] = {.lex_state = 12, .external_lex_state = 2},
  [1127] = {.lex_state = 12, .external_lex_state = 2},
  [1128] = {.lex_state = 12, .external_lex_state = 2},
  [1129] = {.lex_state = 12, .external_lex_state = 2},
  [1130] = {.lex_state = 12, .external_lex_state = 2},
  [1131] = {.lex_state = 12, .external_lex_state = 2},
  [1132] = {.lex_state = 12, .external_lex_state = 2},
  [1133] = {.lex_state = 12, .external_lex_state = 2},
  [1134] = {.lex_state = 12, .external_lex_state = 2},
  [1135] = {.lex_state = 12, .external_lex_state = 2},
  [1136] = {.lex_state = 12, .external_lex_state = 2},
  [1137] = {.lex_state = 12, .external_lex_state = 2},
  [1138] = {.lex_state = 12, .external_lex_state = 2},
  [1139] = {.lex_state = 12, .external_lex_state = 2},
  [1140] = {.lex_state = 12, .external_lex_state = 2},
  [1141] = {.lex_state = 12, .external_lex_state = 2},
  [1142] = {.lex_state = 12, .external_lex_state = 2},
  [1143] = {.lex_state = 12, .external_lex_state = 2},
  [1144] = {.lex_state = 12, .external_lex_state = 2},
  [1145] = {.lex_state = 12, .external_lex_state = 2},
  [1146] = {.lex_state = 12, .external_lex_state = 2},
  [1147] = {.lex_state = 12, .external_lex_state = 2},
  [1148] = {.lex_state = 12, .external_lex_state = 2},
  [1149] = {.lex_state = 12, .external_lex_state = 2},
  [1150] = {.lex_state = 12, .external_lex_state = 2},
  [1151] = {.lex_state = 12, .external_lex_state = 2},
  [1152] = {.lex_state = 12, .external_lex_state = 2},
  [1153] = {.lex_state = 12, .external_lex_state = 2},
  [1154] = {.lex_state = 12, .external_lex_state = 2},
  [1155] = {.lex_state = 12, .external_lex_state = 2},
  [1156] = {.lex_state = 12, .external_lex_state = 2},
  [1157] = {.lex_state = 12, .external_lex_state = 2},
  [1158] = {.lex_state = 12, .external_lex_state = 2},
  [1159] = {.lex_state = 12, .external_lex_state = 2},
  [1160] = {.lex_state = 12, .external_lex_state = 2},
  [1161] = {.lex_state = 12, .external_lex_state = 2},
  [1162] = {.lex_state = 12, .external_lex_state = 2},
  [1163] = {.lex_state = 12, .external_lex_state = 2},
  [1164] = {.lex_state = 12, .external_lex_state = 2},
  [1165] = {.lex_state = 12, .external_lex_state = 2},
  [1166] = {.lex_state = 12, .external_lex_state = 2},
  [1167] = {.lex_state = 12, .external_lex_state = 2},
  [1168] = {.lex_state = 12, .external_lex_state = 2},
  [1169] = {.lex_state = 12, .external_lex_state = 2},
  [1170] = {.lex_state = 12, .external_lex_state = 2},
  [1171] = {.lex_state = 12, .external_lex_state = 2},
  [1172] = {.lex_state = 12, .external_lex_state = 2},
  [1173] = {.lex_state = 12, .external_lex_state = 2},
  [1174] = {.lex_state = 12, .external_lex_state = 2},
  [1175] = {.lex_state = 12, .external_lex_state = 2},
  [1176] = {.lex_state = 12, .external_lex_state = 2},
  [1177] = {.lex_state = 12, .external_lex_state = 2},
  [1178] = {.lex_state = 12, .external_lex_state = 2},
  [1179] = {.lex_state = 12, .external_lex_state = 2},
  [1180] = {.lex_state = 12, .external_lex_state = 2},
  [1181] = {.lex_state = 12, .external_lex_state = 2},
  [1182] = {.lex_state = 12, .external_lex_state = 2},
  [1183] = {.lex_state = 12, .external_lex_state = 2},
  [1184] = {.lex_state = 12, .external_lex_state = 2},
  [1185] = {.lex_state = 12, .external_lex_state = 2},
  [1186] = {.lex_state = 12, .external_lex_state = 2},
  [1187] = {.lex_state = 12, .external_lex_state = 2},
  [1188] = {.lex_state = 12, .external_lex_state = 2},
  [1189] = {.lex_state = 12, .external_lex_state = 2},
  [1190] = {.lex_state = 12, .external_lex_state = 2},
  [1191] = {.lex_state = 12, .external_lex_state = 2},
  [1192] = {.lex_state = 12, .external_lex_state = 2},
  [1193] = {.lex_state = 12, .external_lex_state = 2},
  [1194] = {.lex_state = 12, .external_lex_state = 2},
  [1195] = {.lex_state = 12, .external_lex_state = 2},
  [1196] = {.lex_state = 12, .external_lex_state = 2},
  [1197] = {.lex_state = 12, .external_lex_state = 2},
  [1198] = {.lex_state = 12, .external_lex_state = 2},
  [1199] = {.lex_state = 12, .external_lex_state = 2},
  [1200] = {.lex_state = 12, .external_lex_state = 2},
  [1201] = {.lex_state = 12, .external_lex_state = 2},
  [1202] = {.lex_state = 12, .external_lex_state = 2},
  [1203] = {.lex_state = 12, .external_lex_state = 2},
  [1204] = {.lex_state = 12, .external_lex_state = 2},
  [1205] = {.lex_state = 12, .external_lex_state = 2},
  [1206] = {.lex_state = 12, .external_lex_state = 2},
  [1207] = {.lex_state = 12, .external_lex_state = 2},
  [1208] = {.lex_state = 12, .external_lex_state = 2},
  [1209] = {.lex_state = 12, .external_lex_state = 2},
  [1210] = {.lex_state = 12, .external_lex_state = 2},
  [1211] = {.lex_state = 4, .external_lex_state = 4},
  [1212] = {.lex_state = 4, .external_lex_state = 4},
  [1213] = {.lex_state = 4, .external_lex_state = 4},
  [1214] = {.lex_state = 4, .external_lex_state = 4},
  [1215] = {.lex_state = 4, .external_lex_state = 4},
  [1216] = {.lex_state = 4, .external_lex_state = 4},
  [1217] = {.lex_state = 4, .external_lex_state = 4},
  [1218] = {.lex_state = 4, .external_lex_state = 4},
  [1219] = {.lex_state = 4, .external_lex_state = 4},
  [1220] = {.lex_state = 4, .external_lex_state = 4},
  [1221] = {.lex_state = 4, .external_lex_state = 4},
  [1222] = {.lex_state = 4, .external_lex_state = 4},
  [1223] = {.lex_state = 9, .external_lex_state = 2},
  [1224] = {.lex_state = 4, .external_lex_state = 3},
  [1225] = {.lex_state = 9, .external_lex_state = 2},
  [1226] = {.lex_state = 4, .external_lex_state = 3},
  [1227] = {.lex_state = 9, .external_lex_state = 2},
  [1228] = {.lex_state = 9, .external_lex_state = 2},
  [1229] = {.lex_state = 4, .external_lex_state = 3},
  [1230] = {.lex_state = 4, .external_lex_state = 3},
  [1231] = {.lex_state = 4, .external_lex_state = 3},
  [1232] = {.lex_state = 9, .external_lex_state = 2},
  [1233] = {.lex_state = 9, .external_lex_state = 2},
  [1234] = {.lex_state = 9, .external_lex_state = 2},
  [1235] = {.lex_state = 9, .external_lex_state = 2},
  [1236] = {.lex_state = 9, .external_lex_state = 2},
  [1237] = {.lex_state = 4, .external_lex_state = 4},
  [1238] = {.lex_state = 4, .external_lex_state = 4},
  [1239] = {.lex_state = 9, .external_lex_state = 2},
  [1240] = {.lex_state = 4, .external_lex_state = 4},
  [1241] = {.lex_state = 4, .external_lex_state = 4},
  [1242] = {.lex_state = 4, .external_lex_state = 4},
  [1243] = {.lex_state = 4, .external_lex_state = 4},
  [1244] = {.lex_state = 4, .external_lex_state = 4},
  [1245] = {.lex_state = 4, .external_lex_state = 3},
  [1246] = {.lex_state = 4, .external_lex_state = 4},
  [1247] = {.lex_state = 4, .external_lex_state = 3},
  [1248] = {.lex_state = 4, .external_lex_state = 4},
  [1249] = {.lex_state = 9, .external_lex_state = 2},
  [1250] = {.lex_state = 4, .external_lex_state = 4},
  [1251] = {.lex_state = 4, .external_lex_state = 4},
  [1252] = {.lex_state = 4, .external_lex_state = 4},
  [1253] = {.lex_state = 4, .external_lex_state = 4},
  [1254] = {.lex_state = 9, .external_lex_state = 2},
  [1255] = {.lex_state = 4, .external_lex_state = 4},
  [1256] = {.lex_state = 4, .external_lex_state = 4},
  [1257] = {.lex_state = 4, .external_lex_state = 3},
  [1258] = {.lex_state = 4, .external_lex_state = 3},
  [1259] = {.lex_state = 12, .external_lex_state = 2},
  [1260] = {.lex_state = 4, .external_lex_state = 3},
  [1261] = {.lex_state = 4, .external_lex_state = 3},
  [1262] = {.lex_state = 12, .external_lex_state = 2},
  [1263] = {.lex_state = 4, .external_lex_state = 3},
  [1264] = {.lex_state = 12, .external_lex_state = 2},
  [1265] = {.lex_state = 4, .external_lex_state = 3},
  [1266] = {.lex_state = 12, .external_lex_state = 2},
  [1267] = {.lex_state = 4, .external_lex_state = 4},
  [1268] = {.lex_state = 4, .external_lex_state = 3},
  [1269] = {.lex_state = 12, .external_lex_state = 2},
  [1270] = {.lex_state = 4, .external_lex_state = 4},
  [1271] = {.lex_state = 4, .external_lex_state = 3},
  [1272] = {.lex_state = 12, .external_lex_state = 2},
  [1273] = {.lex_state = 4, .external_lex_state = 4},
  [1274] = {.lex_state = 4, .external_lex_state = 3},
  [1275] = {.lex_state = 4, .external_lex_state = 3},
  [1276] = {.lex_state = 4, .external_lex_state = 3},
  [1277] = {.lex_state = 4, .external_lex_state = 4},
  [1278] = {.lex_state = 4, .external_lex_state = 3},
  [1279] = {.lex_state = 4, .external_lex_state = 3},
  [1280] = {.lex_state = 4, .external_lex_state = 3},
  [1281] = {.lex_state = 12, .external_lex_state = 2},
  [1282] = {.lex_state = 4, .external_lex_state = 3},
  [1283] = {.lex_state = 4, .external_lex_state = 4},
  [1284] = {.lex_state = 4, .external_lex_state = 4},
  [1285] = {.lex_state = 4, .external_lex_state = 4},
  [1286] = {.lex_state = 4, .external_lex_state = 4},
  [1287] = {.lex_state = 4, .external_lex_state = 3},
  [1288] = {.lex_state = 4, .external_lex_state = 4},
  [1289] = {.lex_state = 4, .external_lex_state = 4},
  [1290] = {.lex_state = 4, .external_lex_state = 4},
  [1291] = {.lex_state = 4, .external_lex_state = 3},
  [1292] = {.lex_state = 4, .external_lex_state = 3},
  [1293] = {.lex_state = 4, .external_lex_state = 4},
  [1294] = {.lex_state = 4, .external_lex_state = 4},
  [1295] = {.lex_state = 4, .external_lex_state = 4},
  [1296] = {.lex_state = 4, .external_lex_state = 3},
  [1297] = {.lex_state = 4, .external_lex_state = 3},
  [1298] = {.lex_state = 4, .external_lex_state = 4},
  [1299] = {.lex_state = 4, .external_lex_state = 4},
  [1300] = {.lex_state = 4, .external_lex_state = 4},
  [1301] = {.lex_state = 4, .external_lex_state = 4},
  [1302] = {.lex_state = 4, .external_lex_state = 3},
  [1303] = {.lex_state = 4, .external_lex_state = 4},
  [1304] = {.lex_state = 4, .external_lex_state = 4},
  [1305] = {.lex_state = 4, .external_lex_state = 4},
  [1306] = {.lex_state = 4, .external_lex_state = 4},
  [1307] = {.lex_state = 4, .external_lex_state = 4},
  [1308] = {.lex_state = 4, .external_lex_state = 4},
  [1309] = {.lex_state = 4, .external_lex_state = 3},
  [1310] = {.lex_state = 12, .external_lex_state = 2},
  [1311] = {.lex_state = 4, .external_lex_state = 4},
  [1312] = {.lex_state = 12, .external_lex_state = 2},
  [1313] = {.lex_state = 12, .external_lex_state = 2},
  [1314] = {.lex_state = 4, .external_lex_state = 3},
  [1315] = {.lex_state = 4, .external_lex_state = 3},
  [1316] = {.lex_state = 4, .external_lex_state = 3},
  [1317] = {.lex_state = 4, .external_lex_state = 3},
  [1318] = {.lex_state = 12, .external_lex_state = 2},
  [1319] = {.lex_state = 12, .external_lex_state = 2},
  [1320] = {.lex_state = 12, .external_lex_state = 2},
  [1321] = {.lex_state = 4, .external_lex_state = 3},
  [1322] = {.lex_state = 12, .external_lex_state = 2},
  [1323] = {.lex_state = 4, .external_lex_state = 3},
  [1324] = {.lex_state = 12, .external_lex_state = 2},
  [1325] = {.lex_state = 4, .external_lex_state = 3},
  [1326] = {.lex_state = 12, .external_lex_state = 2},
  [1327] = {.lex_state = 12, .external_lex_state = 2},
  [1328] = {.lex_state = 12, .external_lex_state = 2},
  [1329] = {.lex_state = 12, .external_lex_state = 2},
  [1330] = {.lex_state = 4, .external_lex_state = 4},
  [1331] = {.lex_state = 4, .external_lex_state = 3},
  [1332] = {.lex_state = 12, .external_lex_state = 2},
  [1333] = {.lex_state = 12, .external_lex_state = 2},
  [1334] = {.lex_state = 4, .external_lex_state = 3},
  [1335] = {.lex_state = 4, .external_lex_state = 4},
  [1336] = {.lex_state = 12, .external_lex_state = 2},
  [1337] = {.lex_state = 12, .external_lex_state = 2},
  [1338] = {.lex_state = 12, .external_lex_state = 2},
  [1339] = {.lex_state = 12, .external_lex_state = 2},
  [1340] = {.lex_state = 12, .external_lex_state = 2},
  [1341] = {.lex_state = 12, .external_lex_state = 2},
  [1342] = {.lex_state = 12, .external_lex_state = 2},
  [1343] = {.lex_state = 4, .external_lex_state = 3},
  [1344] = {.lex_state = 4, .external_lex_state = 3},
  [1345] = {.lex_state = 4, .external_lex_state = 3},
  [1346] = {.lex_state = 4, .external_lex_state = 3},
  [1347] = {.lex_state = 4, .external_lex_state = 3},
  [1348] = {.lex_state = 4, .external_lex_state = 3},
  [1349] = {.lex_state = 4, .external_lex_state = 4},
  [1350] = {.lex_state = 4, .external_lex_state = 3},
  [1351] = {.lex_state = 4, .external_lex_state = 3},
  [1352] = {.lex_state = 4, .external_lex_state = 3},
  [1353] = {.lex_state = 4, .external_lex_state = 3},
  [1354] = {.lex_state = 4, .external_lex_state = 3},
  [1355] = {.lex_state = 4, .external_lex_state = 4},
  [1356] = {.lex_state = 4, .external_lex_state = 4},
  [1357] = {.lex_state = 4, .external_lex_state = 3},
  [1358] = {.lex_state = 4, .external_lex_state = 4},
  [1359] = {.lex_state = 4, .external_lex_state = 3},
  [1360] = {.lex_state = 4, .external_lex_state = 3},
  [1361] = {.lex_state = 4, .external_lex_state = 3},
  [1362] = {.lex_state = 4, .external_lex_state = 3},
  [1363] = {.lex_state = 4, .external_lex_state = 3},
  [1364] = {.lex_state = 4, .external_lex_state = 3},
  [1365] = {.lex_state = 4, .external_lex_state = 3},
  [1366] = {.lex_state = 4, .external_lex_state = 3},
  [1367] = {.lex_state = 4, .external_lex_state = 3},
  [1368] = {.lex_state = 4, .external_lex_state = 3},
  [1369] = {.lex_state = 4, .external_lex_state = 3},
  [1370] = {.lex_state = 4, .external_lex_state = 3},
  [1371] = {.lex_state = 4, .external_lex_state = 3},
  [1372] = {.lex_state = 4, .external_lex_state = 3},
  [1373] = {.lex_state = 4, .external_lex_state = 4},
  [1374] = {.lex_state = 4, .external_lex_state = 4},
  [1375] = {.lex_state = 4, .external_lex_state = 3},
  [1376] = {.lex_state = 4, .external_lex_state = 3},
  [1377] = {.lex_state = 4, .external_lex_state = 4},
  [1378] = {.lex_state = 4, .external_lex_state = 4},
  [1379] = {.lex_state = 4, .external_lex_state = 3},
  [1380] = {.lex_state = 4, .external_lex_state = 4},
  [1381] = {.lex_state = 4, .external_lex_state = 4},
  [1382] = {.lex_state = 4, .external_lex_state = 3},
  [1383] = {.lex_state = 4, .external_lex_state = 4},
  [1384] = {.lex_state = 4, .external_lex_state = 4},
  [1385] = {.lex_state = 12, .external_lex_state = 2},
  [1386] = {.lex_state = 4, .external_lex_state = 4},
  [1387] = {.lex_state = 12, .external_lex_state = 2},
  [1388] = {.lex_state = 12, .external_lex_state = 2},
  [1389] = {.lex_state = 4, .external_lex_state = 3},
  [1390] = {.lex_state = 4, .external_lex_state = 4},
  [1391] = {.lex_state = 4, .external_lex_state = 3},
  [1392] = {.lex_state = 4, .external_lex_state = 4},
  [1393] = {.lex_state = 4, .external_lex_state = 3},
  [1394] = {.lex_state = 4, .external_lex_state = 3},
  [1395] = {.lex_state = 4, .external_lex_state = 3},
  [1396] = {.lex_state = 12, .external_lex_state = 2},
  [1397] = {.lex_state = 12, .external_lex_state = 2},
  [1398] = {.lex_state = 12, .external_lex_state = 2},
  [1399] = {.lex_state = 12, .external_lex_state = 2},
  [1400] = {.lex_state = 4, .external_lex_state = 4},
  [1401] = {.lex_state = 4, .external_lex_state = 3},
  [1402] = {.lex_state = 12, .external_lex_state = 2},
  [1403] = {.lex_state = 4, .external_lex_state = 3},
  [1404] = {.lex_state = 4, .external_lex_state = 4},
  [1405] = {.lex_state = 4, .external_lex_state = 3},
  [1406] = {.lex_state = 4, .external_lex_state = 4},
  [1407] = {.lex_state = 4, .external_lex_state = 3},
  [1408] = {.lex_state = 4, .external_lex_state = 4},
  [1409] = {.lex_state = 4, .external_lex_state = 4},
  [1410] = {.lex_state = 4, .external_lex_state = 3},
  [1411] = {.lex_state = 4, .external_lex_state = 4},
  [1412] = {.lex_state = 4, .external_lex_state = 4},
  [1413] = {.lex_state = 4, .external_lex_state = 3},
  [1414] = {.lex_state = 4, .external_lex_state = 4},
  [1415] = {.lex_state = 4, .external_lex_state = 4},
  [1416] = {.lex_state = 12, .external_lex_state = 2},
  [1417] = {.lex_state = 4, .external_lex_state = 3},
  [1418] = {.lex_state = 4, .external_lex_state = 3},
  [1419] = {.lex_state = 12, .external_lex_state = 2},
  [1420] = {.lex_state = 12, .external_lex_state = 2},
  [1421] = {.lex_state = 4, .external_lex_state = 4},
  [1422] = {.lex_state = 4, .external_lex_state = 4},
  [1423] = {.lex_state = 4, .external_lex_state = 4},
  [1424] = {.lex_state = 12, .external_lex_state = 2},
  [1425] = {.lex_state = 4, .external_lex_state = 4},
  [1426] = {.lex_state = 4, .external_lex_state = 3},
  [1427] = {.lex_state = 4, .external_lex_state = 4},
  [1428] = {.lex_state = 4, .external_lex_state = 3},
  [1429] = {.lex_state = 4, .external_lex_state = 4},
  [1430] = {.lex_state = 12, .external_lex_state = 2},
  [1431] = {.lex_state = 12, .external_lex_state = 2},
  [1432] = {.lex_state = 12, .external_lex_state = 2},
  [1433] = {.lex_state = 4, .external_lex_state = 3},
  [1434] = {.lex_state = 4, .external_lex_state = 4},
  [1435] = {.lex_state = 4, .external_lex_state = 3},
  [1436] = {.lex_state = 4, .external_lex_state = 4},
  [1437] = {.lex_state = 4, .external_lex_state = 4},
  [1438] = {.lex_state = 4, .external_lex_state = 3},
  [1439] = {.lex_state = 12, .external_lex_state = 2},
  [1440] = {.lex_state = 4, .external_lex_state = 4},
  [1441] = {.lex_state = 4, .external_lex_state = 3},
  [1442] = {.lex_state = 4, .external_lex_state = 4},
  [1443] = {.lex_state = 4, .external_lex_state = 4},
  [1444] = {.lex_state = 4, .external_lex_state = 3},
  [1445] = {.lex_state = 12, .external_lex_state = 2},
  [1446] = {.lex_state = 12, .external_lex_state = 2},
  [1447] = {.lex_state = 4, .external_lex_state = 3},
  [1448] = {.lex_state = 12, .external_lex_state = 2},
  [1449] = {.lex_state = 4, .external_lex_state = 3},
  [1450] = {.lex_state = 4, .external_lex_state = 3},
  [1451] = {.lex_state = 4, .external_lex_state = 4},
  [1452] = {.lex_state = 4, .external_lex_state = 4},
  [1453] = {.lex_state = 12, .external_lex_state = 2},
  [1454] = {.lex_state = 4, .external_lex_state = 4},
  [1455] = {.lex_state = 12, .external_lex_state = 2},
  [1456] = {.lex_state = 12, .external_lex_state = 2},
  [1457] = {.lex_state = 4, .external_lex_state = 4},
  [1458] = {.lex_state = 12, .external_lex_state = 2},
  [1459] = {.lex_state = 4, .external_lex_state = 4},
  [1460] = {.lex_state = 4, .external_lex_state = 4},
  [1461] = {.lex_state = 4, .external_lex_state = 3},
  [1462] = {.lex_state = 12, .external_lex_state = 2},
  [1463] = {.lex_state = 12, .external_lex_state = 2},
  [1464] = {.lex_state = 4, .external_lex_state = 4},
  [1465] = {.lex_state = 4, .external_lex_state = 3},
  [1466] = {.lex_state = 4, .external_lex_state = 3},
  [1467] = {.lex_state = 9, .external_lex_state = 2},
  [1468] = {.lex_state = 4, .external_lex_state = 3},
  [1469] = {.lex_state = 9, .external_lex_state = 2},
  [1470] = {.lex_state = 4, .external_lex_state = 4},
  [1471] = {.lex_state = 9, .external_lex_state = 2},
  [1472] = {.lex_state = 4, .external_lex_state = 3},
  [1473] = {.lex_state = 4, .external_lex_state = 4},
  [1474] = {.lex_state = 4, .external_lex_state = 3},
  [1475] = {.lex_state = 4, .external_lex_state = 3},
  [1476] = {.lex_state = 4, .external_lex_state = 4},
  [1477] = {.lex_state = 4, .external_lex_state = 3},
  [1478] = {.lex_state = 4, .external_lex_state = 4},
  [1479] = {.lex_state = 4, .external_lex_state = 3},
  [1480] = {.lex_state = 4, .external_lex_state = 3},
  [1481] = {.lex_state = 4, .external_lex_state = 3},
  [1482] = {.lex_state = 4, .external_lex_state = 3},
  [1483] = {.lex_state = 4, .external_lex_state = 3},
  [1484] = {.lex_state = 4, .external_lex_state = 3},
  [1485] = {.lex_state = 9, .external_lex_state = 2},
  [1486] = {.lex_state = 4, .external_lex_state = 3},
  [1487] = {.lex_state = 4, .external_lex_state = 4},
  [1488] = {.lex_state = 9, .external_lex_state = 2},
  [1489] = {.lex_state = 4, .external_lex_state = 3},
  [1490] = {.lex_state = 4, .external_lex_state = 4},
  [1491] = {.lex_state = 9, .external_lex_state = 2},
  [1492] = {.lex_state = 4, .external_lex_state = 3},
  [1493] = {.lex_state = 4, .external_lex_state = 4},
  [1494] = {.lex_state = 4, .external_lex_state = 3},
  [1495] = {.lex_state = 4, .external_lex_state = 4},
  [1496] = {.lex_state = 4, .external_lex_state = 4},
  [1497] = {.lex_state = 4, .external_lex_state = 4},
  [1498] = {.lex_state = 4, .external_lex_state = 3},
  [1499] = {.lex_state = 4, .external_lex_state = 4},
  [1500] = {.lex_state = 4, .external_lex_state = 3},
  [1501] = {.lex_state = 4, .external_lex_state = 3},
  [1502] = {.lex_state = 4, .external_lex_state = 3},
  [1503] = {.lex_state = 4, .external_lex_state = 3},
  [1504] = {.lex_state = 4, .external_lex_state = 3},
  [1505] = {.lex_state = 4, .external_lex_state = 3},
  [1506] = {.lex_state = 4, .external_lex_state = 3},
  [1507] = {.lex_state = 4, .external_lex_state = 3},
  [1508] = {.lex_state = 4, .external_lex_state = 3},
  [1509] = {.lex_state = 4, .external_lex_state = 3},
  [1510] = {.lex_state = 4, .external_lex_state = 3},
  [1511] = {.lex_state = 4, .external_lex_state = 3},
  [1512] = {.lex_state = 4, .external_lex_state = 4},
  [1513] = {.lex_state = 9, .external_lex_state = 2},
  [1514] = {.lex_state = 77, .external_lex_state = 2},
  [1515] = {.lex_state = 12, .external_lex_state = 5},
  [1516] = {.lex_state = 4, .external_lex_state = 3},
  [1517] = {.lex_state = 4, .external_lex_state = 3},
  [1518] = {.lex_state = 4, .external_lex_state = 3},
  [1519] = {.lex_state = 4, .external_lex_state = 3},
  [1520] = {.lex_state = 4, .external_lex_state = 3},
  [1521] = {.lex_state = 77, .external_lex_state = 2},
  [1522] = {.lex_state = 4, .external_lex_state = 3},
  [1523] = {.lex_state = 4, .external_lex_state = 3},
  [1524] = {.lex_state = 4, .external_lex_state = 3},
  [1525] = {.lex_state = 12, .external_lex_state = 5},
  [1526] = {.lex_state = 77, .external_lex_state = 2},
  [1527] = {.lex_state = 4, .external_lex_state = 3},
  [1528] = {.lex_state = 77, .external_lex_state = 2},
  [1529] = {.lex_state = 4, .external_lex_state = 3},
  [1530] = {.lex_state = 77, .external_lex_state = 2},
  [1531] = {.lex_state = 4, .external_lex_state = 3},
  [1532] = {.lex_state = 4, .external_lex_state = 3},
  [1533] = {.lex_state = 4, .external_lex_state = 3},
  [1534] = {.lex_state = 4, .external_lex_state = 3},
  [1535] = {.lex_state = 12, .external_lex_state = 5},
  [1536] = {.lex_state = 4, .external_lex_state = 3},
  [1537] = {.lex_state = 4, .external_lex_state = 3},
  [1538] = {.lex_state = 12, .external_lex_state = 5},
  [1539] = {.lex_state = 12, .external_lex_state = 5},
  [1540] = {.lex_state = 4, .external_lex_state = 3},
  [1541] = {.lex_state = 4, .external_lex_state = 3},
  [1542] = {.lex_state = 4, .external_lex_state = 3},
  [1543] = {.lex_state = 4, .external_lex_state = 3},
  [1544] = {.lex_state = 4, .external_lex_state = 3},
  [1545] = {.lex_state = 4, .external_lex_state = 3},
  [1546] = {.lex_state = 12, .external_lex_state = 5},
  [1547] = {.lex_state = 4, .external_lex_state = 3},
  [1548] = {.lex_state = 4, .external_lex_state = 3},
  [1549] = {.lex_state = 4, .external_lex_state = 3},
  [1550] = {.lex_state = 4, .external_lex_state = 3},
  [1551] = {.lex_state = 4, .external_lex_state = 3},
  [1552] = {.lex_state = 4, .external_lex_state = 3},
  [1553] = {.lex_state = 4, .external_lex_state = 3},
  [1554] = {.lex_state = 4, .external_lex_state = 3},
  [1555] = {.lex_state = 4, .external_lex_state = 3},
  [1556] = {.lex_state = 4, .external_lex_state = 3},
  [1557] = {.lex_state = 4, .external_lex_state = 3},
  [1558] = {.lex_state = 4, .external_lex_state = 3},
  [1559] = {.lex_state = 4, .external_lex_state = 3},
  [1560] = {.lex_state = 12, .external_lex_state = 2},
  [1561] = {.lex_state = 4, .external_lex_state = 3},
  [1562] = {.lex_state = 4, .external_lex_state = 3},
  [1563] = {.lex_state = 12, .external_lex_state = 2},
  [1564] = {.lex_state = 4, .external_lex_state = 3},
  [1565] = {.lex_state = 9, .external_lex_state = 5},
  [1566] = {.lex_state = 9, .external_lex_state = 5},
  [1567] = {.lex_state = 9, .external_lex_state = 5},
  [1568] = {.lex_state = 4, .external_lex_state = 3},
  [1569] = {.lex_state = 4, .external_lex_state = 3},
  [1570] = {.lex_state = 4, .external_lex_state = 3},
  [1571] = {.lex_state = 9, .external_lex_state = 5},
  [1572] = {.lex_state = 4, .external_lex_state = 3},
  [1573] = {.lex_state = 4, .external_lex_state = 3},
  [1574] = {.lex_state = 9, .external_lex_state = 5},
  [1575] = {.lex_state = 4, .external_lex_state = 3},
  [1576] = {.lex_state = 4, .external_lex_state = 3},
  [1577] = {.lex_state = 9, .external_lex_state = 5},
  [1578] = {.lex_state = 4, .external_lex_state = 3},
  [1579] = {.lex_state = 9, .external_lex_state = 5},
  [1580] = {.lex_state = 9, .external_lex_state = 5},
  [1581] = {.lex_state = 9, .external_lex_state = 5},
  [1582] = {.lex_state = 9, .external_lex_state = 5},
  [1583] = {.lex_state = 77, .external_lex_state = 2},
  [1584] = {.lex_state = 9, .external_lex_state = 5},
  [1585] = {.lex_state = 9, .external_lex_state = 5},
  [1586] = {.lex_state = 9, .external_lex_state = 5},
  [1587] = {.lex_state = 9, .external_lex_state = 5},
  [1588] = {.lex_state = 9, .external_lex_state = 5},
  [1589] = {.lex_state = 9, .external_lex_state = 5},
  [1590] = {.lex_state = 9, .external_lex_state = 5},
  [1591] = {.lex_state = 9, .external_lex_state = 5},
  [1592] = {.lex_state = 9, .external_lex_state = 5},
  [1593] = {.lex_state = 9, .external_lex_state = 5},
  [1594] = {.lex_state = 9, .external_lex_state = 5},
  [1595] = {.lex_state = 9, .external_lex_state = 5},
  [1596] = {.lex_state = 9, .external_lex_state = 5},
  [1597] = {.lex_state = 9, .external_lex_state = 5},
  [1598] = {.lex_state = 9, .external_lex_state = 5},
  [1599] = {.lex_state = 9, .external_lex_state = 5},
  [1600] = {.lex_state = 9, .external_lex_state = 5},
  [1601] = {.lex_state = 9, .external_lex_state = 5},
  [1602] = {.lex_state = 9, .external_lex_state = 5},
  [1603] = {.lex_state = 9, .external_lex_state = 5},
  [1604] = {.lex_state = 9, .external_lex_state = 5},
  [1605] = {.lex_state = 9, .external_lex_state = 5},
  [1606] = {.lex_state = 9, .external_lex_state = 5},
  [1607] = {.lex_state = 9, .external_lex_state = 5},
  [1608] = {.lex_state = 9, .external_lex_state = 5},
  [1609] = {.lex_state = 9, .external_lex_state = 5},
  [1610] = {.lex_state = 9, .external_lex_state = 2},
  [1611] = {.lex_state = 9, .external_lex_state = 2},
  [1612] = {.lex_state = 9, .external_lex_state = 5},
  [1613] = {.lex_state = 9, .external_lex_state = 5},
  [1614] = {.lex_state = 9, .external_lex_state = 2},
  [1615] = {.lex_state = 9, .external_lex_state = 5},
  [1616] = {.lex_state = 9, .external_lex_state = 2},
  [1617] = {.lex_state = 9, .external_lex_state = 2},
  [1618] = {.lex_state = 9, .external_lex_state = 2},
  [1619] = {.lex_state = 9, .external_lex_state = 5},
  [1620] = {.lex_state = 9, .external_lex_state = 5},
  [1621] = {.lex_state = 9, .external_lex_state = 2},
  [1622] = {.lex_state = 9, .external_lex_state = 5},
  [1623] = {.lex_state = 9, .external_lex_state = 5},
  [1624] = {.lex_state = 5, .external_lex_state = 3},
  [1625] = {.lex_state = 9, .external_lex_state = 5},
  [1626] = {.lex_state = 9, .external_lex_state = 5},
  [1627] = {.lex_state = 9, .external_lex_state = 5},
  [1628] = {.lex_state = 9, .external_lex_state = 5},
  [1629] = {.lex_state = 9, .external_lex_state = 5},
  [1630] = {.lex_state = 9, .external_lex_state = 5},
  [1631] = {.lex_state = 9, .external_lex_state = 2},
  [1632] = {.lex_state = 9, .external_lex_state = 5},
  [1633] = {.lex_state = 9, .external_lex_state = 2},
  [1634] = {.lex_state = 9, .external_lex_state = 5},
  [1635] = {.lex_state = 9, .external_lex_state = 5},
  [1636] = {.lex_state = 9, .external_lex_state = 5},
  [1637] = {.lex_state = 9, .external_lex_state = 5},
  [1638] = {.lex_state = 9, .external_lex_state = 5},
  [1639] = {.lex_state = 9, .external_lex_state = 5},
  [1640] = {.lex_state = 9, .external_lex_state = 5},
  [1641] = {.lex_state = 9, .external_lex_state = 5},
  [1642] = {.lex_state = 9, .external_lex_state = 2},
  [1643] = {.lex_state = 9, .external_lex_state = 2},
  [1644] = {.lex_state = 9, .external_lex_state = 5},
  [1645] = {.lex_state = 9, .external_lex_state = 5},
  [1646] = {.lex_state = 9, .external_lex_state = 2},
  [1647] = {.lex_state = 9, .external_lex_state = 2},
  [1648] = {.lex_state = 9, .external_lex_state = 5},
  [1649] = {.lex_state = 9, .external_lex_state = 5},
  [1650] = {.lex_state = 9, .external_lex_state = 5},
  [1651] = {.lex_state = 9, .external_lex_state = 5},
  [1652] = {.lex_state = 5, .external_lex_state = 4},
  [1653] = {.lex_state = 5, .external_lex_state = 4},
  [1654] = {.lex_state = 9, .external_lex_state = 2},
  [1655] = {.lex_state = 9, .external_lex_state = 2},
  [1656] = {.lex_state = 9, .external_lex_state = 5},
  [1657] = {.lex_state = 9, .external_lex_state = 5},
  [1658] = {.lex_state = 9, .external_lex_state = 5},
  [1659] = {.lex_state = 9, .external_lex_state = 2},
  [1660] = {.lex_state = 9, .external_lex_state = 5},
  [1661] = {.lex_state = 9, .external_lex_state = 2},
  [1662] = {.lex_state = 9, .external_lex_state = 5},
  [1663] = {.lex_state = 9, .external_lex_state = 5},
  [1664] = {.lex_state = 9, .external_lex_state = 5},
  [1665] = {.lex_state = 9, .external_lex_state = 2},
  [1666] = {.lex_state = 9, .external_lex_state = 2},
  [1667] = {.lex_state = 9, .external_lex_state = 5},
  [1668] = {.lex_state = 9, .external_lex_state = 2},
  [1669] = {.lex_state = 9, .external_lex_state = 5},
  [1670] = {.lex_state = 9, .external_lex_state = 5},
  [1671] = {.lex_state = 9, .external_lex_state = 5},
  [1672] = {.lex_state = 9, .external_lex_state = 5},
  [1673] = {.lex_state = 9, .external_lex_state = 5},
  [1674] = {.lex_state = 5, .external_lex_state = 3},
  [1675] = {.lex_state = 5, .external_lex_state = 3},
  [1676] = {.lex_state = 5, .external_lex_state = 3},
  [1677] = {.lex_state = 9, .external_lex_state = 5},
  [1678] = {.lex_state = 5, .external_lex_state = 3},
  [1679] = {.lex_state = 9, .external_lex_state = 2},
  [1680] = {.lex_state = 9, .external_lex_state = 5},
  [1681] = {.lex_state = 9, .external_lex_state = 5},
  [1682] = {.lex_state = 9, .external_lex_state = 5},
  [1683] = {.lex_state = 9, .external_lex_state = 5},
  [1684] = {.lex_state = 9, .external_lex_state = 5},
  [1685] = {.lex_state = 9, .external_lex_state = 5},
  [1686] = {.lex_state = 9, .external_lex_state = 5},
  [1687] = {.lex_state = 9, .external_lex_state = 5},
  [1688] = {.lex_state = 9, .external_lex_state = 5},
  [1689] = {.lex_state = 9, .external_lex_state = 5},
  [1690] = {.lex_state = 9, .external_lex_state = 5},
  [1691] = {.lex_state = 9, .external_lex_state = 5},
  [1692] = {.lex_state = 9, .external_lex_state = 5},
  [1693] = {.lex_state = 9, .external_lex_state = 5},
  [1694] = {.lex_state = 9, .external_lex_state = 5},
  [1695] = {.lex_state = 9, .external_lex_state = 5},
  [1696] = {.lex_state = 9, .external_lex_state = 5},
  [1697] = {.lex_state = 9, .external_lex_state = 5},
  [1698] = {.lex_state = 9, .external_lex_state = 5},
  [1699] = {.lex_state = 9, .external_lex_state = 5},
  [1700] = {.lex_state = 9, .external_lex_state = 2},
  [1701] = {.lex_state = 9, .external_lex_state = 5},
  [1702] = {.lex_state = 9, .external_lex_state = 2},
  [1703] = {.lex_state = 9, .external_lex_state = 5},
  [1704] = {.lex_state = 9, .external_lex_state = 5},
  [1705] = {.lex_state = 9, .external_lex_state = 2},
  [1706] = {.lex_state = 9, .external_lex_state = 2},
  [1707] = {.lex_state = 5, .external_lex_state = 3},
  [1708] = {.lex_state = 9, .external_lex_state = 2},
  [1709] = {.lex_state = 9, .external_lex_state = 5},
  [1710] = {.lex_state = 9, .external_lex_state = 5},
  [1711] = {.lex_state = 9, .external_lex_state = 5},
  [1712] = {.lex_state = 5, .external_lex_state = 3},
  [1713] = {.lex_state = 5, .external_lex_state = 3},
  [1714] = {.lex_state = 9, .external_lex_state = 5},
  [1715] = {.lex_state = 9, .external_lex_state = 5},
  [1716] = {.lex_state = 9, .external_lex_state = 5},
  [1717] = {.lex_state = 9, .external_lex_state = 5},
  [1718] = {.lex_state = 9, .external_lex_state = 5},
  [1719] = {.lex_state = 9, .external_lex_state = 5},
  [1720] = {.lex_state = 9, .external_lex_state = 5},
  [1721] = {.lex_state = 9, .external_lex_state = 5},
  [1722] = {.lex_state = 5, .external_lex_state = 3},
  [1723] = {.lex_state = 9, .external_lex_state = 5},
  [1724] = {.lex_state = 9, .external_lex_state = 2},
  [1725] = {.lex_state = 9, .external_lex_state = 5},
  [1726] = {.lex_state = 9, .external_lex_state = 5},
  [1727] = {.lex_state = 5, .external_lex_state = 3},
  [1728] = {.lex_state = 9, .external_lex_state = 2},
  [1729] = {.lex_state = 9, .external_lex_state = 5},
  [1730] = {.lex_state = 9, .external_lex_state = 5},
  [1731] = {.lex_state = 9, .external_lex_state = 5},
  [1732] = {.lex_state = 9, .external_lex_state = 5},
  [1733] = {.lex_state = 9, .external_lex_state = 2},
  [1734] = {.lex_state = 5, .external_lex_state = 3},
  [1735] = {.lex_state = 5, .external_lex_state = 3},
  [1736] = {.lex_state = 5, .external_lex_state = 3},
  [1737] = {.lex_state = 5, .external_lex_state = 3},
  [1738] = {.lex_state = 5, .external_lex_state = 4},
  [1739] = {.lex_state = 9, .external_lex_state = 2},
  [1740] = {.lex_state = 9, .external_lex_state = 5},
  [1741] = {.lex_state = 9, .external_lex_state = 2},
  [1742] = {.lex_state = 5, .external_lex_state = 3},
  [1743] = {.lex_state = 5, .external_lex_state = 3},
  [1744] = {.lex_state = 5, .external_lex_state = 3},
  [1745] = {.lex_state = 9, .external_lex_state = 5},
  [1746] = {.lex_state = 9, .external_lex_state = 5},
  [1747] = {.lex_state = 5, .external_lex_state = 3},
  [1748] = {.lex_state = 9, .external_lex_state = 5},
  [1749] = {.lex_state = 5, .external_lex_state = 3},
  [1750] = {.lex_state = 9, .external_lex_state = 2},
  [1751] = {.lex_state = 5, .external_lex_state = 3},
  [1752] = {.lex_state = 9, .external_lex_state = 2},
  [1753] = {.lex_state = 5, .external_lex_state = 3},
  [1754] = {.lex_state = 5, .external_lex_state = 4},
  [1755] = {.lex_state = 5, .external_lex_state = 3},
  [1756] = {.lex_state = 5, .external_lex_state = 3},
  [1757] = {.lex_state = 9, .external_lex_state = 5},
  [1758] = {.lex_state = 5, .external_lex_state = 3},
  [1759] = {.lex_state = 5, .external_lex_state = 3},
  [1760] = {.lex_state = 5, .external_lex_state = 3},
  [1761] = {.lex_state = 5, .external_lex_state = 3},
  [1762] = {.lex_state = 9, .external_lex_state = 5},
  [1763] = {.lex_state = 9, .external_lex_state = 5},
  [1764] = {.lex_state = 9, .external_lex_state = 5},
  [1765] = {.lex_state = 5, .external_lex_state = 3},
  [1766] = {.lex_state = 5, .external_lex_state = 3},
  [1767] = {.lex_state = 5, .external_lex_state = 3},
  [1768] = {.lex_state = 5, .external_lex_state = 3},
  [1769] = {.lex_state = 5, .external_lex_state = 3},
  [1770] = {.lex_state = 5, .external_lex_state = 4},
  [1771] = {.lex_state = 5, .external_lex_state = 3},
  [1772] = {.lex_state = 5, .external_lex_state = 3},
  [1773] = {.lex_state = 5, .external_lex_state = 3},
  [1774] = {.lex_state = 5, .external_lex_state = 3},
  [1775] = {.lex_state = 5, .external_lex_state = 3},
  [1776] = {.lex_state = 5, .external_lex_state = 3},
  [1777] = {.lex_state = 5, .external_lex_state = 3},
  [1778] = {.lex_state = 5, .external_lex_state = 3},
  [1779] = {.lex_state = 9, .external_lex_state = 2},
  [1780] = {.lex_state = 5, .external_lex_state = 3},
  [1781] = {.lex_state = 5, .external_lex_state = 3},
  [1782] = {.lex_state = 5, .external_lex_state = 3},
  [1783] = {.lex_state = 5, .external_lex_state = 3},
  [1784] = {.lex_state = 5, .external_lex_state = 3},
  [1785] = {.lex_state = 9, .external_lex_state = 5},
  [1786] = {.lex_state = 9, .external_lex_state = 5},
  [1787] = {.lex_state = 5, .external_lex_state = 3},
  [1788] = {.lex_state = 5, .external_lex_state = 3},
  [1789] = {.lex_state = 5, .external_lex_state = 3},
  [1790] = {.lex_state = 5, .external_lex_state = 3},
  [1791] = {.lex_state = 5, .external_lex_state = 3},
  [1792] = {.lex_state = 5, .external_lex_state = 3},
  [1793] = {.lex_state = 5, .external_lex_state = 3},
  [1794] = {.lex_state = 5, .external_lex_state = 3},
  [1795] = {.lex_state = 5, .external_lex_state = 3},
  [1796] = {.lex_state = 5, .external_lex_state = 3},
  [1797] = {.lex_state = 5, .external_lex_state = 3},
  [1798] = {.lex_state = 5, .external_lex_state = 3},
  [1799] = {.lex_state = 5, .external_lex_state = 3},
  [1800] = {.lex_state = 5, .external_lex_state = 3},
  [1801] = {.lex_state = 5, .external_lex_state = 3},
  [1802] = {.lex_state = 5, .external_lex_state = 3},
  [1803] = {.lex_state = 5, .external_lex_state = 3},
  [1804] = {.lex_state = 5, .external_lex_state = 3},
  [1805] = {.lex_state = 5, .external_lex_state = 3},
  [1806] = {.lex_state = 5, .external_lex_state = 3},
  [1807] = {.lex_state = 5, .external_lex_state = 3},
  [1808] = {.lex_state = 5, .external_lex_state = 3},
  [1809] = {.lex_state = 5, .external_lex_state = 3},
  [1810] = {.lex_state = 5, .external_lex_state = 3},
  [1811] = {.lex_state = 5, .external_lex_state = 3},
  [1812] = {.lex_state = 5, .external_lex_state = 3},
  [1813] = {.lex_state = 5, .external_lex_state = 3},
  [1814] = {.lex_state = 5, .external_lex_state = 3},
  [1815] = {.lex_state = 5, .external_lex_state = 3},
  [1816] = {.lex_state = 5, .external_lex_state = 3},
  [1817] = {.lex_state = 5, .external_lex_state = 3},
  [1818] = {.lex_state = 5, .external_lex_state = 3},
  [1819] = {.lex_state = 5, .external_lex_state = 3},
  [1820] = {.lex_state = 5, .external_lex_state = 3},
  [1821] = {.lex_state = 5, .external_lex_state = 3},
  [1822] = {.lex_state = 5, .external_lex_state = 3},
  [1823] = {.lex_state = 5, .external_lex_state = 3},
  [1824] = {.lex_state = 5, .external_lex_state = 3},
  [1825] = {.lex_state = 5, .external_lex_state = 3},
  [1826] = {.lex_state = 5, .external_lex_state = 3},
  [1827] = {.lex_state = 9, .external_lex_state = 2},
  [1828] = {.lex_state = 5, .external_lex_state = 3},
  [1829] = {.lex_state = 5, .external_lex_state = 3},
  [1830] = {.lex_state = 5, .external_lex_state = 3},
  [1831] = {.lex_state = 5, .external_lex_state = 3},
  [1832] = {.lex_state = 5, .external_lex_state = 3},
  [1833] = {.lex_state = 5, .external_lex_state = 3},
  [1834] = {.lex_state = 5, .external_lex_state = 3},
  [1835] = {.lex_state = 5, .external_lex_state = 3},
  [1836] = {.lex_state = 5, .external_lex_state = 3},
  [1837] = {.lex_state = 5, .external_lex_state = 3},
  [1838] = {.lex_state = 5, .external_lex_state = 3},
  [1839] = {.lex_state = 5, .external_lex_state = 3},
  [1840] = {.lex_state = 5, .external_lex_state = 3},
  [1841] = {.lex_state = 5, .external_lex_state = 3},
  [1842] = {.lex_state = 5, .external_lex_state = 3},
  [1843] = {.lex_state = 5, .external_lex_state = 3},
  [1844] = {.lex_state = 5, .external_lex_state = 3},
  [1845] = {.lex_state = 5, .external_lex_state = 3},
  [1846] = {.lex_state = 5, .external_lex_state = 3},
  [1847] = {.lex_state = 5, .external_lex_state = 3},
  [1848] = {.lex_state = 5, .external_lex_state = 3},
  [1849] = {.lex_state = 5, .external_lex_state = 3},
  [1850] = {.lex_state = 5, .external_lex_state = 3},
  [1851] = {.lex_state = 5, .external_lex_state = 3},
  [1852] = {.lex_state = 5, .external_lex_state = 3},
  [1853] = {.lex_state = 5, .external_lex_state = 3},
  [1854] = {.lex_state = 5, .external_lex_state = 3},
  [1855] = {.lex_state = 5, .external_lex_state = 3},
  [1856] = {.lex_state = 5, .external_lex_state = 3},
  [1857] = {.lex_state = 5, .external_lex_state = 3},
  [1858] = {.lex_state = 5, .external_lex_state = 3},
  [1859] = {.lex_state = 5, .external_lex_state = 3},
  [1860] = {.lex_state = 5, .external_lex_state = 3},
  [1861] = {.lex_state = 5, .external_lex_state = 3},
  [1862] = {.lex_state = 5, .external_lex_state = 3},
  [1863] = {.lex_state = 5, .external_lex_state = 3},
  [1864] = {.lex_state = 5, .external_lex_state = 3},
  [1865] = {.lex_state = 5, .external_lex_state = 3},
  [1866] = {.lex_state = 5, .external_lex_state = 3},
  [1867] = {.lex_state = 5, .external_lex_state = 3},
  [1868] = {.lex_state = 5, .external_lex_state = 3},
  [1869] = {.lex_state = 5, .external_lex_state = 3},
  [1870] = {.lex_state = 5, .external_lex_state = 3},
  [1871] = {.lex_state = 5, .external_lex_state = 3},
  [1872] = {.lex_state = 5, .external_lex_state = 3},
  [1873] = {.lex_state = 5, .external_lex_state = 3},
  [1874] = {.lex_state = 5, .external_lex_state = 3},
  [1875] = {.lex_state = 9, .external_lex_state = 2},
  [1876] = {.lex_state = 9, .external_lex_state = 2},
  [1877] = {.lex_state = 9, .external_lex_state = 5},
  [1878] = {.lex_state = 9, .external_lex_state = 5},
  [1879] = {.lex_state = 5, .external_lex_state = 3},
  [1880] = {.lex_state = 9, .external_lex_state = 5},
  [1881] = {.lex_state = 5, .external_lex_state = 3},
  [1882] = {.lex_state = 5, .external_lex_state = 3},
  [1883] = {.lex_state = 9, .external_lex_state = 5},
  [1884] = {.lex_state = 9, .external_lex_state = 5},
  [1885] = {.lex_state = 5, .external_lex_state = 3},
  [1886] = {.lex_state = 9, .external_lex_state = 5},
  [1887] = {.lex_state = 5, .external_lex_state = 4},
  [1888] = {.lex_state = 5, .external_lex_state = 4},
  [1889] = {.lex_state = 5, .external_lex_state = 4},
  [1890] = {.lex_state = 5, .external_lex_state = 3},
  [1891] = {.lex_state = 5, .external_lex_state = 3},
  [1892] = {.lex_state = 9, .external_lex_state = 2},
  [1893] = {.lex_state = 5, .external_lex_state = 3},
  [1894] = {.lex_state = 9, .external_lex_state = 2},
  [1895] = {.lex_state = 9, .external_lex_state = 2},
  [1896] = {.lex_state = 5, .external_lex_state = 3},
  [1897] = {.lex_state = 5, .external_lex_state = 3},
  [1898] = {.lex_state = 5, .external_lex_state = 3},
  [1899] = {.lex_state = 9, .external_lex_state = 5},
  [1900] = {.lex_state = 9, .external_lex_state = 2},
  [1901] = {.lex_state = 9, .external_lex_state = 2},
  [1902] = {.lex_state = 9, .external_lex_state = 2},
  [1903] = {.lex_state = 5, .external_lex_state = 3},
  [1904] = {.lex_state = 5, .external_lex_state = 3},
  [1905] = {.lex_state = 5, .external_lex_state = 3},
  [1906] = {.lex_state = 9, .external_lex_state = 5},
  [1907] = {.lex_state = 5, .external_lex_state = 3},
  [1908] = {.lex_state = 9, .external_lex_state = 2},
  [1909] = {.lex_state = 9, .external_lex_state = 2},
  [1910] = {.lex_state = 9, .external_lex_state = 5},
  [1911] = {.lex_state = 9, .external_lex_state = 5},
  [1912] = {.lex_state = 5, .external_lex_state = 3},
  [1913] = {.lex_state = 9, .external_lex_state = 5},
  [1914] = {.lex_state = 11, .external_lex_state = 2},
  [1915] = {.lex_state = 5, .external_lex_state = 3},
  [1916] = {.lex_state = 9, .external_lex_state = 5},
  [1917] = {.lex_state = 5, .external_lex_state = 3},
  [1918] = {.lex_state = 5, .external_lex_state = 3},
  [1919] = {.lex_state = 5, .external_lex_state = 3},
  [1920] = {.lex_state = 9, .external_lex_state = 5},
  [1921] = {.lex_state = 9, .external_lex_state = 5},
  [1922] = {.lex_state = 5, .external_lex_state = 3},
  [1923] = {.lex_state = 9, .external_lex_state = 5},
  [1924] = {.lex_state = 5, .external_lex_state = 3},
  [1925] = {.lex_state = 9, .external_lex_state = 5},
  [1926] = {.lex_state = 9, .external_lex_state = 2},
  [1927] = {.lex_state = 9, .external_lex_state = 5},
  [1928] = {.lex_state = 5, .external_lex_state = 3},
  [1929] = {.lex_state = 9, .external_lex_state = 2},
  [1930] = {.lex_state = 9, .external_lex_state = 2},
  [1931] = {.lex_state = 9, .external_lex_state = 2},
  [1932] = {.lex_state = 5, .external_lex_state = 3},
  [1933] = {.lex_state = 5, .external_lex_state = 3},
  [1934] = {.lex_state = 5, .external_lex_state = 3},
  [1935] = {.lex_state = 5, .external_lex_state = 3},
  [1936] = {.lex_state = 5, .external_lex_state = 3},
  [1937] = {.lex_state = 5, .external_lex_state = 3},
  [1938] = {.lex_state = 5, .external_lex_state = 3},
  [1939] = {.lex_state = 5, .external_lex_state = 3},
  [1940] = {.lex_state = 5, .external_lex_state = 3},
  [1941] = {.lex_state = 9, .external_lex_state = 2},
  [1942] = {.lex_state = 5, .external_lex_state = 3},
  [1943] = {.lex_state = 5, .external_lex_state = 3},
  [1944] = {.lex_state = 9, .external_lex_state = 2},
  [1945] = {.lex_state = 5, .external_lex_state = 3},
  [1946] = {.lex_state = 5, .external_lex_state = 3},
  [1947] = {.lex_state = 5, .external_lex_state = 3},
  [1948] = {.lex_state = 5, .external_lex_state = 3},
  [1949] = {.lex_state = 5, .external_lex_state = 3},
  [1950] = {.lex_state = 5, .external_lex_state = 3},
  [1951] = {.lex_state = 5, .external_lex_state = 3},
  [1952] = {.lex_state = 5, .external_lex_state = 3},
  [1953] = {.lex_state = 9, .external_lex_state = 2},
  [1954] = {.lex_state = 5, .external_lex_state = 3},
  [1955] = {.lex_state = 5, .external_lex_state = 3},
  [1956] = {.lex_state = 5, .external_lex_state = 3},
  [1957] = {.lex_state = 5, .external_lex_state = 3},
  [1958] = {.lex_state = 5, .external_lex_state = 3},
  [1959] = {.lex_state = 5, .external_lex_state = 3},
  [1960] = {.lex_state = 5, .external_lex_state = 3},
  [1961] = {.lex_state = 9, .external_lex_state = 2},
  [1962] = {.lex_state = 5, .external_lex_state = 3},
  [1963] = {.lex_state = 5, .external_lex_state = 3},
  [1964] = {.lex_state = 5, .external_lex_state = 3},
  [1965] = {.lex_state = 5, .external_lex_state = 3},
  [1966] = {.lex_state = 5, .external_lex_state = 3},
  [1967] = {.lex_state = 11, .external_lex_state = 2},
  [1968] = {.lex_state = 5, .external_lex_state = 3},
  [1969] = {.lex_state = 5, .external_lex_state = 3},
  [1970] = {.lex_state = 5, .external_lex_state = 3},
  [1971] = {.lex_state = 5, .external_lex_state = 3},
  [1972] = {.lex_state = 5, .external_lex_state = 3},
  [1973] = {.lex_state = 5, .external_lex_state = 3},
  [1974] = {.lex_state = 5, .external_lex_state = 3},
  [1975] = {.lex_state = 5, .external_lex_state = 3},
  [1976] = {.lex_state = 5, .external_lex_state = 3},
  [1977] = {.lex_state = 5, .external_lex_state = 3},
  [1978] = {.lex_state = 5, .external_lex_state = 3},
  [1979] = {.lex_state = 5, .external_lex_state = 3},
  [1980] = {.lex_state = 5, .external_lex_state = 3},
  [1981] = {.lex_state = 5, .external_lex_state = 3},
  [1982] = {.lex_state = 5, .external_lex_state = 3},
  [1983] = {.lex_state = 5, .external_lex_state = 3},
  [1984] = {.lex_state = 9, .external_lex_state = 5},
  [1985] = {.lex_state = 5, .external_lex_state = 3},
  [1986] = {.lex_state = 5, .external_lex_state = 3},
  [1987] = {.lex_state = 5, .external_lex_state = 3},
  [1988] = {.lex_state = 5, .external_lex_state = 4},
  [1989] = {.lex_state = 5, .external_lex_state = 4},
  [1990] = {.lex_state = 9, .external_lex_state = 5},
  [1991] = {.lex_state = 9, .external_lex_state = 5},
  [1992] = {.lex_state = 5, .external_lex_state = 3},
  [1993] = {.lex_state = 5, .external_lex_state = 3},
  [1994] = {.lex_state = 9, .external_lex_state = 5},
  [1995] = {.lex_state = 5, .external_lex_state = 3},
  [1996] = {.lex_state = 5, .external_lex_state = 3},
  [1997] = {.lex_state = 5, .external_lex_state = 3},
  [1998] = {.lex_state = 9, .external_lex_state = 5},
  [1999] = {.lex_state = 5, .external_lex_state = 3},
  [2000] = {.lex_state = 5, .external_lex_state = 3},
  [2001] = {.lex_state = 5, .external_lex_state = 3},
  [2002] = {.lex_state = 5, .external_lex_state = 3},
  [2003] = {.lex_state = 5, .external_lex_state = 3},
  [2004] = {.lex_state = 5, .external_lex_state = 3},
  [2005] = {.lex_state = 5, .external_lex_state = 3},
  [2006] = {.lex_state = 5, .external_lex_state = 3},
  [2007] = {.lex_state = 5, .external_lex_state = 3},
  [2008] = {.lex_state = 5, .external_lex_state = 3},
  [2009] = {.lex_state = 5, .external_lex_state = 3},
  [2010] = {.lex_state = 5, .external_lex_state = 3},
  [2011] = {.lex_state = 5, .external_lex_state = 3},
  [2012] = {.lex_state = 5, .external_lex_state = 3},
  [2013] = {.lex_state = 5, .external_lex_state = 3},
  [2014] = {.lex_state = 5, .external_lex_state = 3},
  [2015] = {.lex_state = 5, .external_lex_state = 3},
  [2016] = {.lex_state = 5, .external_lex_state = 3},
  [2017] = {.lex_state = 5, .external_lex_state = 3},
  [2018] = {.lex_state = 5, .external_lex_state = 3},
  [2019] = {.lex_state = 5, .external_lex_state = 3},
  [2020] = {.lex_state = 5, .external_lex_state = 4},
  [2021] = {.lex_state = 12, .external_lex_state = 5},
  [2022] = {.lex_state = 12, .external_lex_state = 5},
  [2023] = {.lex_state = 12, .external_lex_state = 5},
  [2024] = {.lex_state = 9, .external_lex_state = 2},
  [2025] = {.lex_state = 12, .external_lex_state = 5},
  [2026] = {.lex_state = 5, .external_lex_state = 4},
  [2027] = {.lex_state = 12, .external_lex_state = 5},
  [2028] = {.lex_state = 5, .external_lex_state = 4},
  [2029] = {.lex_state = 12, .external_lex_state = 5},
  [2030] = {.lex_state = 12, .external_lex_state = 5},
  [2031] = {.lex_state = 12, .external_lex_state = 5},
  [2032] = {.lex_state = 12, .external_lex_state = 5},
  [2033] = {.lex_state = 12, .external_lex_state = 5},
  [2034] = {.lex_state = 9, .external_lex_state = 2},
  [2035] = {.lex_state = 12, .external_lex_state = 5},
  [2036] = {.lex_state = 12, .external_lex_state = 5},
  [2037] = {.lex_state = 12, .external_lex_state = 5},
  [2038] = {.lex_state = 12, .external_lex_state = 5},
  [2039] = {.lex_state = 5, .external_lex_state = 4},
  [2040] = {.lex_state = 5, .external_lex_state = 4},
  [2041] = {.lex_state = 12, .external_lex_state = 5},
  [2042] = {.lex_state = 12, .external_lex_state = 5},
  [2043] = {.lex_state = 5, .external_lex_state = 4},
  [2044] = {.lex_state = 12, .external_lex_state = 5},
  [2045] = {.lex_state = 12, .external_lex_state = 5},
  [2046] = {.lex_state = 12, .external_lex_state = 5},
  [2047] = {.lex_state = 12, .external_lex_state = 5},
  [2048] = {.lex_state = 12, .external_lex_state = 5},
  [2049] = {.lex_state = 12, .external_lex_state = 5},
  [2050] = {.lex_state = 12, .external_lex_state = 5},
  [2051] = {.lex_state = 12, .external_lex_state = 5},
  [2052] = {.lex_state = 5, .external_lex_state = 4},
  [2053] = {.lex_state = 5, .external_lex_state = 4},
  [2054] = {.lex_state = 5, .external_lex_state = 3},
  [2055] = {.lex_state = 5, .external_lex_state = 4},
  [2056] = {.lex_state = 12, .external_lex_state = 5},
  [2057] = {.lex_state = 12, .external_lex_state = 5},
  [2058] = {.lex_state = 12, .external_lex_state = 5},
  [2059] = {.lex_state = 12, .external_lex_state = 5},
  [2060] = {.lex_state = 5, .external_lex_state = 4},
  [2061] = {.lex_state = 12, .external_lex_state = 5},
  [2062] = {.lex_state = 12, .external_lex_state = 5},
  [2063] = {.lex_state = 12, .external_lex_state = 5},
  [2064] = {.lex_state = 5, .external_lex_state = 4},
  [2065] = {.lex_state = 12, .external_lex_state = 5},
  [2066] = {.lex_state = 12, .external_lex_state = 5},
  [2067] = {.lex_state = 12, .external_lex_state = 5},
  [2068] = {.lex_state = 5, .external_lex_state = 3},
  [2069] = {.lex_state = 5, .external_lex_state = 3},
  [2070] = {.lex_state = 12, .external_lex_state = 5},
  [2071] = {.lex_state = 12, .external_lex_state = 5},
  [2072] = {.lex_state = 12, .external_lex_state = 5},
  [2073] = {.lex_state = 5, .external_lex_state = 3},
  [2074] = {.lex_state = 12, .external_lex_state = 5},
  [2075] = {.lex_state = 5, .external_lex_state = 4},
  [2076] = {.lex_state = 12, .external_lex_state = 5},
  [2077] = {.lex_state = 12, .external_lex_state = 5},
  [2078] = {.lex_state = 12, .external_lex_state = 5},
  [2079] = {.lex_state = 12, .external_lex_state = 5},
  [2080] = {.lex_state = 12, .external_lex_state = 5},
  [2081] = {.lex_state = 5, .external_lex_state = 4},
  [2082] = {.lex_state = 12, .external_lex_state = 5},
  [2083] = {.lex_state = 12, .external_lex_state = 5},
  [2084] = {.lex_state = 5, .external_lex_state = 3},
  [2085] = {.lex_state = 12, .external_lex_state = 5},
  [2086] = {.lex_state = 5, .external_lex_state = 4},
  [2087] = {.lex_state = 5, .external_lex_state = 4},
  [2088] = {.lex_state = 5, .external_lex_state = 4},
  [2089] = {.lex_state = 12, .external_lex_state = 2},
  [2090] = {.lex_state = 5, .external_lex_state = 4},
  [2091] = {.lex_state = 5, .external_lex_state = 4},
  [2092] = {.lex_state = 5, .external_lex_state = 4},
  [2093] = {.lex_state = 5, .external_lex_state = 4},
  [2094] = {.lex_state = 5, .external_lex_state = 3},
  [2095] = {.lex_state = 5, .external_lex_state = 3},
  [2096] = {.lex_state = 12, .external_lex_state = 2},
  [2097] = {.lex_state = 5, .external_lex_state = 4},
  [2098] = {.lex_state = 5, .external_lex_state = 4},
  [2099] = {.lex_state = 5, .external_lex_state = 4},
  [2100] = {.lex_state = 5, .external_lex_state = 4},
  [2101] = {.lex_state = 5, .external_lex_state = 4},
  [2102] = {.lex_state = 5, .external_lex_state = 4},
  [2103] = {.lex_state = 5, .external_lex_state = 4},
  [2104] = {.lex_state = 5, .external_lex_state = 4},
  [2105] = {.lex_state = 5, .external_lex_state = 4},
  [2106] = {.lex_state = 5, .external_lex_state = 4},
  [2107] = {.lex_state = 5, .external_lex_state = 4},
  [2108] = {.lex_state = 5, .external_lex_state = 4},
  [2109] = {.lex_state = 5, .external_lex_state = 4},
  [2110] = {.lex_state = 5, .external_lex_state = 4},
  [2111] = {.lex_state = 5, .external_lex_state = 4},
  [2112] = {.lex_state = 5, .external_lex_state = 4},
  [2113] = {.lex_state = 5, .external_lex_state = 4},
  [2114] = {.lex_state = 5, .external_lex_state = 4},
  [2115] = {.lex_state = 5, .external_lex_state = 4},
  [2116] = {.lex_state = 5, .external_lex_state = 4},
  [2117] = {.lex_state = 5, .external_lex_state = 4},
  [2118] = {.lex_state = 5, .external_lex_state = 4},
  [2119] = {.lex_state = 5, .external_lex_state = 4},
  [2120] = {.lex_state = 9, .external_lex_state = 2},
  [2121] = {.lex_state = 9, .external_lex_state = 2},
  [2122] = {.lex_state = 9, .external_lex_state = 2},
  [2123] = {.lex_state = 5, .external_lex_state = 4},
  [2124] = {.lex_state = 5, .external_lex_state = 4},
  [2125] = {.lex_state = 5, .external_lex_state = 4},
  [2126] = {.lex_state = 5, .external_lex_state = 4},
  [2127] = {.lex_state = 5, .external_lex_state = 4},
  [2128] = {.lex_state = 5, .external_lex_state = 4},
  [2129] = {.lex_state = 5, .external_lex_state = 3},
  [2130] = {.lex_state = 5, .external_lex_state = 4},
  [2131] = {.lex_state = 5, .external_lex_state = 4},
  [2132] = {.lex_state = 5, .external_lex_state = 4},
  [2133] = {.lex_state = 5, .external_lex_state = 4},
  [2134] = {.lex_state = 5, .external_lex_state = 4},
  [2135] = {.lex_state = 5, .external_lex_state = 4},
  [2136] = {.lex_state = 5, .external_lex_state = 4},
  [2137] = {.lex_state = 5, .external_lex_state = 4},
  [2138] = {.lex_state = 5, .external_lex_state = 4},
  [2139] = {.lex_state = 12, .external_lex_state = 2},
  [2140] = {.lex_state = 5, .external_lex_state = 4},
  [2141] = {.lex_state = 5, .external_lex_state = 4},
  [2142] = {.lex_state = 6, .external_lex_state = 3},
  [2143] = {.lex_state = 5, .external_lex_state = 4},
  [2144] = {.lex_state = 5, .external_lex_state = 4},
  [2145] = {.lex_state = 5, .external_lex_state = 4},
  [2146] = {.lex_state = 5, .external_lex_state = 4},
  [2147] = {.lex_state = 5, .external_lex_state = 3},
  [2148] = {.lex_state = 5, .external_lex_state = 3},
  [2149] = {.lex_state = 5, .external_lex_state = 4},
  [2150] = {.lex_state = 5, .external_lex_state = 4},
  [2151] = {.lex_state = 5, .external_lex_state = 3},
  [2152] = {.lex_state = 5, .external_lex_state = 4},
  [2153] = {.lex_state = 9, .external_lex_state = 2},
  [2154] = {.lex_state = 5, .external_lex_state = 4},
  [2155] = {.lex_state = 5, .external_lex_state = 4},
  [2156] = {.lex_state = 5, .external_lex_state = 3},
  [2157] = {.lex_state = 5, .external_lex_state = 4},
  [2158] = {.lex_state = 12, .external_lex_state = 2},
  [2159] = {.lex_state = 5, .external_lex_state = 4},
  [2160] = {.lex_state = 5, .external_lex_state = 4},
  [2161] = {.lex_state = 5, .external_lex_state = 4},
  [2162] = {.lex_state = 5, .external_lex_state = 4},
  [2163] = {.lex_state = 5, .external_lex_state = 3},
  [2164] = {.lex_state = 5, .external_lex_state = 4},
  [2165] = {.lex_state = 5, .external_lex_state = 4},
  [2166] = {.lex_state = 5, .external_lex_state = 4},
  [2167] = {.lex_state = 5, .external_lex_state = 4},
  [2168] = {.lex_state = 5, .external_lex_state = 3},
  [2169] = {.lex_state = 5, .external_lex_state = 4},
  [2170] = {.lex_state = 5, .external_lex_state = 4},
  [2171] = {.lex_state = 5, .external_lex_state = 4},
  [2172] = {.lex_state = 5, .external_lex_state = 4},
  [2173] = {.lex_state = 9, .external_lex_state = 2},
  [2174] = {.lex_state = 5, .external_lex_state = 4},
  [2175] = {.lex_state = 5, .external_lex_state = 4},
  [2176] = {.lex_state = 5, .external_lex_state = 4},
  [2177] = {.lex_state = 12, .external_lex_state = 2},
  [2178] = {.lex_state = 5, .external_lex_state = 3},
  [2179] = {.lex_state = 5, .external_lex_state = 4},
  [2180] = {.lex_state = 5, .external_lex_state = 3},
  [2181] = {.lex_state = 5, .external_lex_state = 4},
  [2182] = {.lex_state = 5, .external_lex_state = 4},
  [2183] = {.lex_state = 5, .external_lex_state = 4},
  [2184] = {.lex_state = 5, .external_lex_state = 4},
  [2185] = {.lex_state = 5, .external_lex_state = 3},
  [2186] = {.lex_state = 5, .external_lex_state = 4},
  [2187] = {.lex_state = 5, .external_lex_state = 4},
  [2188] = {.lex_state = 5, .external_lex_state = 4},
  [2189] = {.lex_state = 5, .external_lex_state = 3},
  [2190] = {.lex_state = 5, .external_lex_state = 4},
  [2191] = {.lex_state = 5, .external_lex_state = 4},
  [2192] = {.lex_state = 5, .external_lex_state = 4},
  [2193] = {.lex_state = 5, .external_lex_state = 4},
  [2194] = {.lex_state = 5, .external_lex_state = 4},
  [2195] = {.lex_state = 5, .external_lex_state = 4},
  [2196] = {.lex_state = 5, .external_lex_state = 4},
  [2197] = {.lex_state = 5, .external_lex_state = 4},
  [2198] = {.lex_state = 5, .external_lex_state = 4},
  [2199] = {.lex_state = 5, .external_lex_state = 4},
  [2200] = {.lex_state = 5, .external_lex_state = 4},
  [2201] = {.lex_state = 5, .external_lex_state = 4},
  [2202] = {.lex_state = 5, .external_lex_state = 4},
  [2203] = {.lex_state = 5, .external_lex_state = 3},
  [2204] = {.lex_state = 5, .external_lex_state = 4},
  [2205] = {.lex_state = 5, .external_lex_state = 4},
  [2206] = {.lex_state = 5, .external_lex_state = 4},
  [2207] = {.lex_state = 5, .external_lex_state = 4},
  [2208] = {.lex_state = 5, .external_lex_state = 4},
  [2209] = {.lex_state = 5, .external_lex_state = 4},
  [2210] = {.lex_state = 5, .external_lex_state = 4},
  [2211] = {.lex_state = 5, .external_lex_state = 4},
  [2212] = {.lex_state = 5, .external_lex_state = 4},
  [2213] = {.lex_state = 9, .external_lex_state = 2},
  [2214] = {.lex_state = 9, .external_lex_state = 2},
  [2215] = {.lex_state = 5, .external_lex_state = 4},
  [2216] = {.lex_state = 5, .external_lex_state = 4},
  [2217] = {.lex_state = 5, .external_lex_state = 4},
  [2218] = {.lex_state = 5, .external_lex_state = 4},
  [2219] = {.lex_state = 5, .external_lex_state = 4},
  [2220] = {.lex_state = 5, .external_lex_state = 4},
  [2221] = {.lex_state = 5, .external_lex_state = 4},
  [2222] = {.lex_state = 5, .external_lex_state = 4},
  [2223] = {.lex_state = 9, .external_lex_state = 2},
  [2224] = {.lex_state = 5, .external_lex_state = 4},
  [2225] = {.lex_state = 5, .external_lex_state = 3},
  [2226] = {.lex_state = 9, .external_lex_state = 2},
  [2227] = {.lex_state = 5, .external_lex_state = 3},
  [2228] = {.lex_state = 5, .external_lex_state = 4},
  [2229] = {.lex_state = 5, .external_lex_state = 4},
  [2230] = {.lex_state = 5, .external_lex_state = 4},
  [2231] = {.lex_state = 5, .external_lex_state = 4},
  [2232] = {.lex_state = 77, .external_lex_state = 2},
  [2233] = {.lex_state = 9, .external_lex_state = 2},
  [2234] = {.lex_state = 5, .external_lex_state = 4},
  [2235] = {.lex_state = 5, .external_lex_state = 4},
  [2236] = {.lex_state = 5, .external_lex_state = 4},
  [2237] = {.lex_state = 5, .external_lex_state = 4},
  [2238] = {.lex_state = 5, .external_lex_state = 4},
  [2239] = {.lex_state = 5, .external_lex_state = 4},
  [2240] = {.lex_state = 5, .external_lex_state = 3},
  [2241] = {.lex_state = 5, .external_lex_state = 4},
  [2242] = {.lex_state = 5, .external_lex_state = 4},
  [2243] = {.lex_state = 5, .external_lex_state = 4},
  [2244] = {.lex_state = 5, .external_lex_state = 4},
  [2245] = {.lex_state = 9, .external_lex_state = 2},
  [2246] = {.lex_state = 5, .external_lex_state = 4},
  [2247] = {.lex_state = 5, .external_lex_state = 4},
  [2248] = {.lex_state = 9, .external_lex_state = 2},
  [2249] = {.lex_state = 5, .external_lex_state = 4},
  [2250] = {.lex_state = 5, .external_lex_state = 4},
  [2251] = {.lex_state = 5, .external_lex_state = 4},
  [2252] = {.lex_state = 5, .external_lex_state = 4},
  [2253] = {.lex_state = 5, .external_lex_state = 4},
  [2254] = {.lex_state = 5, .external_lex_state = 4},
  [2255] = {.lex_state = 5, .external_lex_state = 3},
  [2256] = {.lex_state = 5, .external_lex_state = 3},
  [2257] = {.lex_state = 5, .external_lex_state = 3},
  [2258] = {.lex_state = 5, .external_lex_state = 4},
  [2259] = {.lex_state = 5, .external_lex_state = 4},
  [2260] = {.lex_state = 5, .external_lex_state = 4},
  [2261] = {.lex_state = 5, .external_lex_state = 4},
  [2262] = {.lex_state = 5, .external_lex_state = 4},
  [2263] = {.lex_state = 5, .external_lex_state = 4},
  [2264] = {.lex_state = 5, .external_lex_state = 4},
  [2265] = {.lex_state = 5, .external_lex_state = 4},
  [2266] = {.lex_state = 5, .external_lex_state = 4},
  [2267] = {.lex_state = 5, .external_lex_state = 4},
  [2268] = {.lex_state = 5, .external_lex_state = 3},
  [2269] = {.lex_state = 5, .external_lex_state = 3},
  [2270] = {.lex_state = 5, .external_lex_state = 4},
  [2271] = {.lex_state = 5, .external_lex_state = 4},
  [2272] = {.lex_state = 5, .external_lex_state = 4},
  [2273] = {.lex_state = 5, .external_lex_state = 4},
  [2274] = {.lex_state = 5, .external_lex_state = 4},
  [2275] = {.lex_state = 5, .external_lex_state = 4},
  [2276] = {.lex_state = 5, .external_lex_state = 4},
  [2277] = {.lex_state = 5, .external_lex_state = 3},
  [2278] = {.lex_state = 5, .external_lex_state = 3},
  [2279] = {.lex_state = 5, .external_lex_state = 3},
  [2280] = {.lex_state = 5, .external_lex_state = 4},
  [2281] = {.lex_state = 5, .external_lex_state = 4},
  [2282] = {.lex_state = 5, .external_lex_state = 4},
  [2283] = {.lex_state = 5, .external_lex_state = 4},
  [2284] = {.lex_state = 5, .external_lex_state = 4},
  [2285] = {.lex_state = 5, .external_lex_state = 4},
  [2286] = {.lex_state = 5, .external_lex_state = 4},
  [2287] = {.lex_state = 5, .external_lex_state = 4},
  [2288] = {.lex_state = 5, .external_lex_state = 4},
  [2289] = {.lex_state = 5, .external_lex_state = 4},
  [2290] = {.lex_state = 5, .external_lex_state = 4},
  [2291] = {.lex_state = 5, .external_lex_state = 4},
  [2292] = {.lex_state = 5, .external_lex_state = 4},
  [2293] = {.lex_state = 5, .external_lex_state = 4},
  [2294] = {.lex_state = 5, .external_lex_state = 4},
  [2295] = {.lex_state = 5, .external_lex_state = 4},
  [2296] = {.lex_state = 5, .external_lex_state = 4},
  [2297] = {.lex_state = 5, .external_lex_state = 4},
  [2298] = {.lex_state = 5, .external_lex_state = 4},
  [2299] = {.lex_state = 5, .external_lex_state = 4},
  [2300] = {.lex_state = 5, .external_lex_state = 4},
  [2301] = {.lex_state = 5, .external_lex_state = 4},
  [2302] = {.lex_state = 5, .external_lex_state = 4},
  [2303] = {.lex_state = 5, .external_lex_state = 4},
  [2304] = {.lex_state = 5, .external_lex_state = 4},
  [2305] = {.lex_state = 5, .external_lex_state = 3},
  [2306] = {.lex_state = 5, .external_lex_state = 3},
  [2307] = {.lex_state = 5, .external_lex_state = 3},
  [2308] = {.lex_state = 5, .external_lex_state = 3},
  [2309] = {.lex_state = 5, .external_lex_state = 4},
  [2310] = {.lex_state = 5, .external_lex_state = 4},
  [2311] = {.lex_state = 9, .external_lex_state = 2},
  [2312] = {.lex_state = 9, .external_lex_state = 2},
  [2313] = {.lex_state = 5, .external_lex_state = 4},
  [2314] = {.lex_state = 5, .external_lex_state = 3},
  [2315] = {.lex_state = 5, .external_lex_state = 3},
  [2316] = {.lex_state = 5, .external_lex_state = 3},
  [2317] = {.lex_state = 5, .external_lex_state = 3},
  [2318] = {.lex_state = 5, .external_lex_state = 3},
  [2319] = {.lex_state = 5, .external_lex_state = 3},
  [2320] = {.lex_state = 5, .external_lex_state = 3},
  [2321] = {.lex_state = 5, .external_lex_state = 3},
  [2322] = {.lex_state = 5, .external_lex_state = 3},
  [2323] = {.lex_state = 5, .external_lex_state = 3},
  [2324] = {.lex_state = 5, .external_lex_state = 3},
  [2325] = {.lex_state = 5, .external_lex_state = 3},
  [2326] = {.lex_state = 5, .external_lex_state = 3},
  [2327] = {.lex_state = 5, .external_lex_state = 4},
  [2328] = {.lex_state = 9, .external_lex_state = 2},
  [2329] = {.lex_state = 5, .external_lex_state = 4},
  [2330] = {.lex_state = 5, .external_lex_state = 3},
  [2331] = {.lex_state = 5, .external_lex_state = 3},
  [2332] = {.lex_state = 5, .external_lex_state = 3},
  [2333] = {.lex_state = 5, .external_lex_state = 3},
  [2334] = {.lex_state = 5, .external_lex_state = 3},
  [2335] = {.lex_state = 5, .external_lex_state = 3},
  [2336] = {.lex_state = 5, .external_lex_state = 3},
  [2337] = {.lex_state = 5, .external_lex_state = 3},
  [2338] = {.lex_state = 5, .external_lex_state = 3},
  [2339] = {.lex_state = 5, .external_lex_state = 4},
  [2340] = {.lex_state = 5, .external_lex_state = 3},
  [2341] = {.lex_state = 5, .external_lex_state = 4},
  [2342] = {.lex_state = 5, .external_lex_state = 4},
  [2343] = {.lex_state = 5, .external_lex_state = 4},
  [2344] = {.lex_state = 5, .external_lex_state = 4},
  [2345] = {.lex_state = 5, .external_lex_state = 3},
  [2346] = {.lex_state = 5, .external_lex_state = 4},
  [2347] = {.lex_state = 5, .external_lex_state = 3},
  [2348] = {.lex_state = 5, .external_lex_state = 4},
  [2349] = {.lex_state = 5, .external_lex_state = 4},
  [2350] = {.lex_state = 5, .external_lex_state = 4},
  [2351] = {.lex_state = 5, .external_lex_state = 4},
  [2352] = {.lex_state = 5, .external_lex_state = 4},
  [2353] = {.lex_state = 5, .external_lex_state = 4},
  [2354] = {.lex_state = 5, .external_lex_state = 4},
  [2355] = {.lex_state = 5, .external_lex_state = 4},
  [2356] = {.lex_state = 5, .external_lex_state = 4},
  [2357] = {.lex_state = 5, .external_lex_state = 4},
  [2358] = {.lex_state = 5, .external_lex_state = 4},
  [2359] = {.lex_state = 5, .external_lex_state = 4},
  [2360] = {.lex_state = 5, .external_lex_state = 4},
  [2361] = {.lex_state = 5, .external_lex_state = 3},
  [2362] = {.lex_state = 5, .external_lex_state = 3},
  [2363] = {.lex_state = 5, .external_lex_state = 3},
  [2364] = {.lex_state = 5, .external_lex_state = 3},
  [2365] = {.lex_state = 5, .external_lex_state = 4},
  [2366] = {.lex_state = 5, .external_lex_state = 4},
  [2367] = {.lex_state = 5, .external_lex_state = 4},
  [2368] = {.lex_state = 5, .external_lex_state = 4},
  [2369] = {.lex_state = 5, .external_lex_state = 4},
  [2370] = {.lex_state = 5, .external_lex_state = 4},
  [2371] = {.lex_state = 5, .external_lex_state = 4},
  [2372] = {.lex_state = 5, .external_lex_state = 4},
  [2373] = {.lex_state = 5, .external_lex_state = 4},
  [2374] = {.lex_state = 9, .external_lex_state = 2},
  [2375] = {.lex_state = 5, .external_lex_state = 4},
  [2376] = {.lex_state = 9, .external_lex_state = 2},
  [2377] = {.lex_state = 5, .external_lex_state = 4},
  [2378] = {.lex_state = 5, .external_lex_state = 4},
  [2379] = {.lex_state = 5, .external_lex_state = 4},
  [2380] = {.lex_state = 5, .external_lex_state = 4},
  [2381] = {.lex_state = 5, .external_lex_state = 4},
  [2382] = {.lex_state = 5, .external_lex_state = 4},
  [2383] = {.lex_state = 9, .external_lex_state = 2},
  [2384] = {.lex_state = 5, .external_lex_state = 4},
  [2385] = {.lex_state = 5, .external_lex_state = 4},
  [2386] = {.lex_state = 5, .external_lex_state = 4},
  [2387] = {.lex_state = 5, .external_lex_state = 4},
  [2388] = {.lex_state = 5, .external_lex_state = 4},
  [2389] = {.lex_state = 5, .external_lex_state = 3},
  [2390] = {.lex_state = 5, .external_lex_state = 4},
  [2391] = {.lex_state = 9, .external_lex_state = 2},
  [2392] = {.lex_state = 6, .external_lex_state = 4},
  [2393] = {.lex_state = 5, .external_lex_state = 4},
  [2394] = {.lex_state = 5, .external_lex_state = 3},
  [2395] = {.lex_state = 5, .external_lex_state = 3},
  [2396] = {.lex_state = 5, .external_lex_state = 3},
  [2397] = {.lex_state = 5, .external_lex_state = 4},
  [2398] = {.lex_state = 5, .external_lex_state = 4},
  [2399] = {.lex_state = 9, .external_lex_state = 2},
  [2400] = {.lex_state = 5, .external_lex_state = 3},
  [2401] = {.lex_state = 5, .external_lex_state = 3},
  [2402] = {.lex_state = 5, .external_lex_state = 3},
  [2403] = {.lex_state = 5, .external_lex_state = 4},
  [2404] = {.lex_state = 5, .external_lex_state = 4},
  [2405] = {.lex_state = 5, .external_lex_state = 3},
  [2406] = {.lex_state = 5, .external_lex_state = 3},
  [2407] = {.lex_state = 5, .external_lex_state = 4},
  [2408] = {.lex_state = 5, .external_lex_state = 4},
  [2409] = {.lex_state = 5, .external_lex_state = 4},
  [2410] = {.lex_state = 5, .external_lex_state = 3},
  [2411] = {.lex_state = 5, .external_lex_state = 3},
  [2412] = {.lex_state = 5, .external_lex_state = 4},
  [2413] = {.lex_state = 5, .external_lex_state = 4},
  [2414] = {.lex_state = 5, .external_lex_state = 4},
  [2415] = {.lex_state = 5, .external_lex_state = 3},
  [2416] = {.lex_state = 5, .external_lex_state = 4},
  [2417] = {.lex_state = 5, .external_lex_state = 4},
  [2418] = {.lex_state = 5, .external_lex_state = 4},
  [2419] = {.lex_state = 5, .external_lex_state = 4},
  [2420] = {.lex_state = 5, .external_lex_state = 4},
  [2421] = {.lex_state = 5, .external_lex_state = 3},
  [2422] = {.lex_state = 5, .external_lex_state = 4},
  [2423] = {.lex_state = 5, .external_lex_state = 4},
  [2424] = {.lex_state = 5, .external_lex_state = 4},
  [2425] = {.lex_state = 5, .external_lex_state = 4},
  [2426] = {.lex_state = 5, .external_lex_state = 4},
  [2427] = {.lex_state = 5, .external_lex_state = 4},
  [2428] = {.lex_state = 9, .external_lex_state = 2},
  [2429] = {.lex_state = 5, .external_lex_state = 4},
  [2430] = {.lex_state = 5, .external_lex_state = 4},
  [2431] = {.lex_state = 5, .external_lex_state = 4},
  [2432] = {.lex_state = 5, .external_lex_state = 3},
  [2433] = {.lex_state = 5, .external_lex_state = 3},
  [2434] = {.lex_state = 5, .external_lex_state = 3},
  [2435] = {.lex_state = 5, .external_lex_state = 3},
  [2436] = {.lex_state = 5, .external_lex_state = 4},
  [2437] = {.lex_state = 5, .external_lex_state = 4},
  [2438] = {.lex_state = 9, .external_lex_state = 2},
  [2439] = {.lex_state = 77, .external_lex_state = 2},
  [2440] = {.lex_state = 5, .external_lex_state = 4},
  [2441] = {.lex_state = 5, .external_lex_state = 3},
  [2442] = {.lex_state = 5, .external_lex_state = 3},
  [2443] = {.lex_state = 5, .external_lex_state = 4},
  [2444] = {.lex_state = 5, .external_lex_state = 4},
  [2445] = {.lex_state = 5, .external_lex_state = 4},
  [2446] = {.lex_state = 5, .external_lex_state = 4},
  [2447] = {.lex_state = 5, .external_lex_state = 4},
  [2448] = {.lex_state = 5, .external_lex_state = 4},
  [2449] = {.lex_state = 5, .external_lex_state = 4},
  [2450] = {.lex_state = 5, .external_lex_state = 4},
  [2451] = {.lex_state = 5, .external_lex_state = 4},
  [2452] = {.lex_state = 5, .external_lex_state = 4},
  [2453] = {.lex_state = 5, .external_lex_state = 4},
  [2454] = {.lex_state = 5, .external_lex_state = 4},
  [2455] = {.lex_state = 5, .external_lex_state = 4},
  [2456] = {.lex_state = 5, .external_lex_state = 4},
  [2457] = {.lex_state = 9, .external_lex_state = 2},
  [2458] = {.lex_state = 5, .external_lex_state = 4},
  [2459] = {.lex_state = 5, .external_lex_state = 3},
  [2460] = {.lex_state = 5, .external_lex_state = 4},
  [2461] = {.lex_state = 5, .external_lex_state = 3},
  [2462] = {.lex_state = 5, .external_lex_state = 3},
  [2463] = {.lex_state = 5, .external_lex_state = 3},
  [2464] = {.lex_state = 5, .external_lex_state = 3},
  [2465] = {.lex_state = 5, .external_lex_state = 3},
  [2466] = {.lex_state = 5, .external_lex_state = 4},
  [2467] = {.lex_state = 5, .external_lex_state = 4},
  [2468] = {.lex_state = 5, .external_lex_state = 4},
  [2469] = {.lex_state = 5, .external_lex_state = 4},
  [2470] = {.lex_state = 6, .external_lex_state = 4},
  [2471] = {.lex_state = 5, .external_lex_state = 4},
  [2472] = {.lex_state = 5, .external_lex_state = 4},
  [2473] = {.lex_state = 5, .external_lex_state = 3},
  [2474] = {.lex_state = 5, .external_lex_state = 4},
  [2475] = {.lex_state = 5, .external_lex_state = 4},
  [2476] = {.lex_state = 5, .external_lex_state = 4},
  [2477] = {.lex_state = 5, .external_lex_state = 4},
  [2478] = {.lex_state = 5, .external_lex_state = 4},
  [2479] = {.lex_state = 9, .external_lex_state = 2},
  [2480] = {.lex_state = 5, .external_lex_state = 4},
  [2481] = {.lex_state = 5, .external_lex_state = 4},
  [2482] = {.lex_state = 5, .external_lex_state = 4},
  [2483] = {.lex_state = 5, .external_lex_state = 4},
  [2484] = {.lex_state = 5, .external_lex_state = 4},
  [2485] = {.lex_state = 5, .external_lex_state = 3},
  [2486] = {.lex_state = 5, .external_lex_state = 3},
  [2487] = {.lex_state = 5, .external_lex_state = 4},
  [2488] = {.lex_state = 5, .external_lex_state = 4},
  [2489] = {.lex_state = 5, .external_lex_state = 3},
  [2490] = {.lex_state = 5, .external_lex_state = 3},
  [2491] = {.lex_state = 5, .external_lex_state = 3},
  [2492] = {.lex_state = 9, .external_lex_state = 2},
  [2493] = {.lex_state = 5, .external_lex_state = 3},
  [2494] = {.lex_state = 5, .external_lex_state = 4},
  [2495] = {.lex_state = 5, .external_lex_state = 3},
  [2496] = {.lex_state = 5, .external_lex_state = 4},
  [2497] = {.lex_state = 9, .external_lex_state = 2},
  [2498] = {.lex_state = 77, .external_lex_state = 2},
  [2499] = {.lex_state = 5, .external_lex_state = 3},
  [2500] = {.lex_state = 5, .external_lex_state = 3},
  [2501] = {.lex_state = 5, .external_lex_state = 4},
  [2502] = {.lex_state = 5, .external_lex_state = 4},
  [2503] = {.lex_state = 5, .external_lex_state = 3},
  [2504] = {.lex_state = 5, .external_lex_state = 4},
  [2505] = {.lex_state = 5, .external_lex_state = 4},
  [2506] = {.lex_state = 5, .external_lex_state = 4},
  [2507] = {.lex_state = 9, .external_lex_state = 2},
  [2508] = {.lex_state = 5, .external_lex_state = 3},
  [2509] = {.lex_state = 5, .external_lex_state = 4},
  [2510] = {.lex_state = 5, .external_lex_state = 4},
  [2511] = {.lex_state = 5, .external_lex_state = 4},
  [2512] = {.lex_state = 5, .external_lex_state = 4},
  [2513] = {.lex_state = 5, .external_lex_state = 4},
  [2514] = {.lex_state = 5, .external_lex_state = 4},
  [2515] = {.lex_state = 5, .external_lex_state = 4},
  [2516] = {.lex_state = 5, .external_lex_state = 3},
  [2517] = {.lex_state = 5, .external_lex_state = 4},
  [2518] = {.lex_state = 5, .external_lex_state = 3},
  [2519] = {.lex_state = 5, .external_lex_state = 4},
  [2520] = {.lex_state = 5, .external_lex_state = 4},
  [2521] = {.lex_state = 5, .external_lex_state = 4},
  [2522] = {.lex_state = 5, .external_lex_state = 4},
  [2523] = {.lex_state = 5, .external_lex_state = 4},
  [2524] = {.lex_state = 5, .external_lex_state = 4},
  [2525] = {.lex_state = 5, .external_lex_state = 4},
  [2526] = {.lex_state = 5, .external_lex_state = 4},
  [2527] = {.lex_state = 5, .external_lex_state = 4},
  [2528] = {.lex_state = 5, .external_lex_state = 4},
  [2529] = {.lex_state = 5, .external_lex_state = 4},
  [2530] = {.lex_state = 5, .external_lex_state = 4},
  [2531] = {.lex_state = 5, .external_lex_state = 4},
  [2532] = {.lex_state = 5, .external_lex_state = 4},
  [2533] = {.lex_state = 5, .external_lex_state = 4},
  [2534] = {.lex_state = 5, .external_lex_state = 4},
  [2535] = {.lex_state = 5, .external_lex_state = 4},
  [2536] = {.lex_state = 5, .external_lex_state = 4},
  [2537] = {.lex_state = 5, .external_lex_state = 4},
  [2538] = {.lex_state = 5, .external_lex_state = 4},
  [2539] = {.lex_state = 5, .external_lex_state = 3},
  [2540] = {.lex_state = 5, .external_lex_state = 4},
  [2541] = {.lex_state = 5, .external_lex_state = 3},
  [2542] = {.lex_state = 5, .external_lex_state = 3},
  [2543] = {.lex_state = 5, .external_lex_state = 3},
  [2544] = {.lex_state = 5, .external_lex_state = 3},
  [2545] = {.lex_state = 5, .external_lex_state = 3},
  [2546] = {.lex_state = 5, .external_lex_state = 3},
  [2547] = {.lex_state = 5, .external_lex_state = 3},
  [2548] = {.lex_state = 5, .external_lex_state = 3},
  [2549] = {.lex_state = 9, .external_lex_state = 2},
  [2550] = {.lex_state = 5, .external_lex_state = 3},
  [2551] = {.lex_state = 5, .external_lex_state = 3},
  [2552] = {.lex_state = 5, .external_lex_state = 4},
  [2553] = {.lex_state = 9, .external_lex_state = 2},
  [2554] = {.lex_state = 9, .external_lex_state = 2},
  [2555] = {.lex_state = 5, .external_lex_state = 3},
  [2556] = {.lex_state = 9, .external_lex_state = 2},
  [2557] = {.lex_state = 5, .external_lex_state = 3},
  [2558] = {.lex_state = 5, .external_lex_state = 3},
  [2559] = {.lex_state = 5, .external_lex_state = 3},
  [2560] = {.lex_state = 5, .external_lex_state = 3},
  [2561] = {.lex_state = 5, .external_lex_state = 4},
  [2562] = {.lex_state = 5, .external_lex_state = 4},
  [2563] = {.lex_state = 9, .external_lex_state = 2},
  [2564] = {.lex_state = 5, .external_lex_state = 3},
  [2565] = {.lex_state = 5, .external_lex_state = 4},
  [2566] = {.lex_state = 5, .external_lex_state = 4},
  [2567] = {.lex_state = 5, .external_lex_state = 3},
  [2568] = {.lex_state = 5, .external_lex_state = 3},
  [2569] = {.lex_state = 5, .external_lex_state = 3},
  [2570] = {.lex_state = 5, .external_lex_state = 3},
  [2571] = {.lex_state = 5, .external_lex_state = 3},
  [2572] = {.lex_state = 5, .external_lex_state = 3},
  [2573] = {.lex_state = 9, .external_lex_state = 2},
  [2574] = {.lex_state = 5, .external_lex_state = 3},
  [2575] = {.lex_state = 5, .external_lex_state = 3},
  [2576] = {.lex_state = 5, .external_lex_state = 4},
  [2577] = {.lex_state = 5, .external_lex_state = 3},
  [2578] = {.lex_state = 5, .external_lex_state = 3},
  [2579] = {.lex_state = 9, .external_lex_state = 2},
  [2580] = {.lex_state = 5, .external_lex_state = 4},
  [2581] = {.lex_state = 5, .external_lex_state = 4},
  [2582] = {.lex_state = 5, .external_lex_state = 4},
  [2583] = {.lex_state = 5, .external_lex_state = 4},
  [2584] = {.lex_state = 9, .external_lex_state = 2},
  [2585] = {.lex_state = 5, .external_lex_state = 3},
  [2586] = {.lex_state = 9, .external_lex_state = 2},
  [2587] = {.lex_state = 5, .external_lex_state = 3},
  [2588] = {.lex_state = 9, .external_lex_state = 2},
  [2589] = {.lex_state = 9, .external_lex_state = 2},
  [2590] = {.lex_state = 9, .external_lex_state = 2},
  [2591] = {.lex_state = 5, .external_lex_state = 3},
  [2592] = {.lex_state = 5, .external_lex_state = 3},
  [2593] = {.lex_state = 9, .external_lex_state = 2},
  [2594] = {.lex_state = 5, .external_lex_state = 3},
  [2595] = {.lex_state = 5, .external_lex_state = 3},
  [2596] = {.lex_state = 5, .external_lex_state = 3},
  [2597] = {.lex_state = 5, .external_lex_state = 3},
  [2598] = {.lex_state = 5, .external_lex_state = 3},
  [2599] = {.lex_state = 5, .external_lex_state = 4},
  [2600] = {.lex_state = 5, .external_lex_state = 3},
  [2601] = {.lex_state = 5, .external_lex_state = 3},
  [2602] = {.lex_state = 5, .external_lex_state = 4},
  [2603] = {.lex_state = 5, .external_lex_state = 4},
  [2604] = {.lex_state = 9, .external_lex_state = 2},
  [2605] = {.lex_state = 5, .external_lex_state = 3},
  [2606] = {.lex_state = 9, .external_lex_state = 2},
  [2607] = {.lex_state = 9, .external_lex_state = 2},
  [2608] = {.lex_state = 9, .external_lex_state = 2},
  [2609] = {.lex_state = 9, .external_lex_state = 2},
  [2610] = {.lex_state = 9, .external_lex_state = 2},
  [2611] = {.lex_state = 5, .external_lex_state = 4},
  [2612] = {.lex_state = 5, .external_lex_state = 3},
  [2613] = {.lex_state = 77, .external_lex_state = 2},
  [2614] = {.lex_state = 77, .external_lex_state = 2},
  [2615] = {.lex_state = 5, .external_lex_state = 3},
  [2616] = {.lex_state = 5, .external_lex_state = 3},
  [2617] = {.lex_state = 77, .external_lex_state = 2},
  [2618] = {.lex_state = 6, .external_lex_state = 3},
  [2619] = {.lex_state = 9, .external_lex_state = 2},
  [2620] = {.lex_state = 9, .external_lex_state = 2},
  [2621] = {.lex_state = 5, .external_lex_state = 3},
  [2622] = {.lex_state = 5, .external_lex_state = 3},
  [2623] = {.lex_state = 5, .external_lex_state = 4},
  [2624] = {.lex_state = 5, .external_lex_state = 3},
  [2625] = {.lex_state = 5, .external_lex_state = 3},
  [2626] = {.lex_state = 5, .external_lex_state = 3},
  [2627] = {.lex_state = 5, .external_lex_state = 3},
  [2628] = {.lex_state = 5, .external_lex_state = 3},
  [2629] = {.lex_state = 5, .external_lex_state = 4},
  [2630] = {.lex_state = 5, .external_lex_state = 4},
  [2631] = {.lex_state = 5, .external_lex_state = 4},
  [2632] = {.lex_state = 4, .external_lex_state = 2},
  [2633] = {.lex_state = 4, .external_lex_state = 2},
  [2634] = {.lex_state = 5, .external_lex_state = 3},
  [2635] = {.lex_state = 5, .external_lex_state = 3},
  [2636] = {.lex_state = 5, .external_lex_state = 4},
  [2637] = {.lex_state = 5, .external_lex_state = 3},
  [2638] = {.lex_state = 5, .external_lex_state = 3},
  [2639] = {.lex_state = 5, .external_lex_state = 3},
  [2640] = {.lex_state = 5, .external_lex_state = 4},
  [2641] = {.lex_state = 5, .external_lex_state = 4},
  [2642] = {.lex_state = 5, .external_lex_state = 3},
  [2643] = {.lex_state = 5, .external_lex_state = 4},
  [2644] = {.lex_state = 5, .external_lex_state = 3},
  [2645] = {.lex_state = 5, .external_lex_state = 3},
  [2646] = {.lex_state = 5, .external_lex_state = 4},
  [2647] = {.lex_state = 9, .external_lex_state = 2},
  [2648] = {.lex_state = 5, .external_lex_state = 4},
  [2649] = {.lex_state = 5, .external_lex_state = 4},
  [2650] = {.lex_state = 77, .external_lex_state = 2},
  [2651] = {.lex_state = 5, .external_lex_state = 4},
  [2652] = {.lex_state = 77, .external_lex_state = 2},
  [2653] = {.lex_state = 77, .external_lex_state = 2},
  [2654] = {.lex_state = 77, .external_lex_state = 2},
  [2655] = {.lex_state = 77, .external_lex_state = 2},
  [2656] = {.lex_state = 5, .external_lex_state = 3},
  [2657] = {.lex_state = 77, .external_lex_state = 2},
  [2658] = {.lex_state = 77, .external_lex_state = 2},
  [2659] = {.lex_state = 4, .external_lex_state = 2},
  [2660] = {.lex_state = 4, .external_lex_state = 2},
  [2661] = {.lex_state = 5, .external_lex_state = 4},
  [2662] = {.lex_state = 77, .external_lex_state = 2},
  [2663] = {.lex_state = 5, .external_lex_state = 4},
  [2664] = {.lex_state = 77, .external_lex_state = 2},
  [2665] = {.lex_state = 77, .external_lex_state = 2},
  [2666] = {.lex_state = 77, .external_lex_state = 2},
  [2667] = {.lex_state = 77, .external_lex_state = 2},
  [2668] = {.lex_state = 5, .external_lex_state = 3},
  [2669] = {.lex_state = 5, .external_lex_state = 3},
  [2670] = {.lex_state = 5, .external_lex_state = 3},
  [2671] = {.lex_state = 5, .external_lex_state = 3},
  [2672] = {.lex_state = 5, .external_lex_state = 3},
  [2673] = {.lex_state = 5, .external_lex_state = 3},
  [2674] = {.lex_state = 5, .external_lex_state = 3},
  [2675] = {.lex_state = 5, .external_lex_state = 3},
  [2676] = {.lex_state = 5, .external_lex_state = 3},
  [2677] = {.lex_state = 5, .external_lex_state = 3},
  [2678] = {.lex_state = 5, .external_lex_state = 3},
  [2679] = {.lex_state = 5, .external_lex_state = 3},
  [2680] = {.lex_state = 5, .external_lex_state = 3},
  [2681] = {.lex_state = 5, .external_lex_state = 3},
  [2682] = {.lex_state = 5, .external_lex_state = 3},
  [2683] = {.lex_state = 5, .external_lex_state = 3},
  [2684] = {.lex_state = 5, .external_lex_state = 3},
  [2685] = {.lex_state = 5, .external_lex_state = 3},
  [2686] = {.lex_state = 5, .external_lex_state = 3},
  [2687] = {.lex_state = 5, .external_lex_state = 3},
  [2688] = {.lex_state = 5, .external_lex_state = 3},
  [2689] = {.lex_state = 5, .external_lex_state = 3},
  [2690] = {.lex_state = 5, .external_lex_state = 3},
  [2691] = {.lex_state = 5, .external_lex_state = 3},
  [2692] = {.lex_state = 5, .external_lex_state = 3},
  [2693] = {.lex_state = 5, .external_lex_state = 3},
  [2694] = {.lex_state = 5, .external_lex_state = 3},
  [2695] = {.lex_state = 5, .external_lex_state = 3},
  [2696] = {.lex_state = 5, .external_lex_state = 3},
  [2697] = {.lex_state = 5, .external_lex_state = 3},
  [2698] = {.lex_state = 5, .external_lex_state = 3},
  [2699] = {.lex_state = 5, .external_lex_state = 3},
  [2700] = {.lex_state = 5, .external_lex_state = 3},
  [2701] = {.lex_state = 5, .external_lex_state = 3},
  [2702] = {.lex_state = 5, .external_lex_state = 3},
  [2703] = {.lex_state = 5, .external_lex_state = 3},
  [2704] = {.lex_state = 5, .external_lex_state = 3},
  [2705] = {.lex_state = 5, .external_lex_state = 3},
  [2706] = {.lex_state = 5, .external_lex_state = 3},
  [2707] = {.lex_state = 5, .external_lex_state = 3},
  [2708] = {.lex_state = 5, .external_lex_state = 3},
  [2709] = {.lex_state = 5, .external_lex_state = 3},
  [2710] = {.lex_state = 5, .external_lex_state = 3},
  [2711] = {.lex_state = 5, .external_lex_state = 3},
  [2712] = {.lex_state = 5, .external_lex_state = 3},
  [2713] = {.lex_state = 5, .external_lex_state = 3},
  [2714] = {.lex_state = 5, .external_lex_state = 3},
  [2715] = {.lex_state = 5, .external_lex_state = 3},
  [2716] = {.lex_state = 5, .external_lex_state = 3},
  [2717] = {.lex_state = 5, .external_lex_state = 3},
  [2718] = {.lex_state = 5, .external_lex_state = 3},
  [2719] = {.lex_state = 5, .external_lex_state = 3},
  [2720] = {.lex_state = 5, .external_lex_state = 3},
  [2721] = {.lex_state = 5, .external_lex_state = 3},
  [2722] = {.lex_state = 5, .external_lex_state = 3},
  [2723] = {.lex_state = 5, .external_lex_state = 3},
  [2724] = {.lex_state = 5, .external_lex_state = 3},
  [2725] = {.lex_state = 5, .external_lex_state = 3},
  [2726] = {.lex_state = 5, .external_lex_state = 3},
  [2727] = {.lex_state = 5, .external_lex_state = 3},
  [2728] = {.lex_state = 5, .external_lex_state = 3},
  [2729] = {.lex_state = 5, .external_lex_state = 3},
  [2730] = {.lex_state = 5, .external_lex_state = 3},
  [2731] = {.lex_state = 5, .external_lex_state = 3},
  [2732] = {.lex_state = 5, .external_lex_state = 3},
  [2733] = {.lex_state = 5, .external_lex_state = 3},
  [2734] = {.lex_state = 5, .external_lex_state = 3},
  [2735] = {.lex_state = 5, .external_lex_state = 3},
  [2736] = {.lex_state = 5, .external_lex_state = 3},
  [2737] = {.lex_state = 5, .external_lex_state = 3},
  [2738] = {.lex_state = 5, .external_lex_state = 3},
  [2739] = {.lex_state = 5, .external_lex_state = 3},
  [2740] = {.lex_state = 5, .external_lex_state = 3},
  [2741] = {.lex_state = 5, .external_lex_state = 3},
  [2742] = {.lex_state = 5, .external_lex_state = 3},
  [2743] = {.lex_state = 5, .external_lex_state = 3},
  [2744] = {.lex_state = 5, .external_lex_state = 3},
  [2745] = {.lex_state = 5, .external_lex_state = 3},
  [2746] = {.lex_state = 5, .external_lex_state = 3},
  [2747] = {.lex_state = 5, .external_lex_state = 3},
  [2748] = {.lex_state = 77, .external_lex_state = 2},
  [2749] = {.lex_state = 77, .external_lex_state = 2},
  [2750] = {.lex_state = 77, .external_lex_state = 2},
  [2751] = {.lex_state = 77, .external_lex_state = 2},
  [2752] = {.lex_state = 9, .external_lex_state = 2},
  [2753] = {.lex_state = 5, .external_lex_state = 3},
  [2754] = {.lex_state = 5, .external_lex_state = 3},
  [2755] = {.lex_state = 5, .external_lex_state = 3},
  [2756] = {.lex_state = 5, .external_lex_state = 3},
  [2757] = {.lex_state = 5, .external_lex_state = 3},
  [2758] = {.lex_state = 5, .external_lex_state = 3},
  [2759] = {.lex_state = 5, .external_lex_state = 3},
  [2760] = {.lex_state = 5, .external_lex_state = 3},
  [2761] = {.lex_state = 5, .external_lex_state = 3},
  [2762] = {.lex_state = 5, .external_lex_state = 3},
  [2763] = {.lex_state = 5, .external_lex_state = 3},
  [2764] = {.lex_state = 5, .external_lex_state = 3},
  [2765] = {.lex_state = 9, .external_lex_state = 2},
  [2766] = {.lex_state = 5, .external_lex_state = 3},
  [2767] = {.lex_state = 77, .external_lex_state = 2},
  [2768] = {.lex_state = 9, .external_lex_state = 2},
  [2769] = {.lex_state = 9, .external_lex_state = 2},
  [2770] = {.lex_state = 9, .external_lex_state = 2},
  [2771] = {.lex_state = 5, .external_lex_state = 3},
  [2772] = {.lex_state = 5, .external_lex_state = 3},
  [2773] = {.lex_state = 9, .external_lex_state = 2},
  [2774] = {.lex_state = 9, .external_lex_state = 2},
  [2775] = {.lex_state = 9, .external_lex_state = 2},
  [2776] = {.lex_state = 5, .external_lex_state = 3},
  [2777] = {.lex_state = 5, .external_lex_state = 3},
  [2778] = {.lex_state = 77, .external_lex_state = 2},
  [2779] = {.lex_state = 5, .external_lex_state = 3},
  [2780] = {.lex_state = 9, .external_lex_state = 2},
  [2781] = {.lex_state = 5, .external_lex_state = 3},
  [2782] = {.lex_state = 5, .external_lex_state = 3},
  [2783] = {.lex_state = 9, .external_lex_state = 2},
  [2784] = {.lex_state = 9, .external_lex_state = 2},
  [2785] = {.lex_state = 77, .external_lex_state = 5},
  [2786] = {.lex_state = 9, .external_lex_state = 2},
  [2787] = {.lex_state = 5, .external_lex_state = 3},
  [2788] = {.lex_state = 5, .external_lex_state = 3},
  [2789] = {.lex_state = 5, .external_lex_state = 3},
  [2790] = {.lex_state = 9, .external_lex_state = 2},
  [2791] = {.lex_state = 5, .external_lex_state = 3},
  [2792] = {.lex_state = 5, .external_lex_state = 3},
  [2793] = {.lex_state = 9, .external_lex_state = 2},
  [2794] = {.lex_state = 5, .external_lex_state = 3},
  [2795] = {.lex_state = 5, .external_lex_state = 3},
  [2796] = {.lex_state = 5, .external_lex_state = 3},
  [2797] = {.lex_state = 9, .external_lex_state = 2},
  [2798] = {.lex_state = 5, .external_lex_state = 3},
  [2799] = {.lex_state = 9, .external_lex_state = 2},
  [2800] = {.lex_state = 5, .external_lex_state = 3},
  [2801] = {.lex_state = 5, .external_lex_state = 3},
  [2802] = {.lex_state = 5, .external_lex_state = 3},
  [2803] = {.lex_state = 77, .external_lex_state = 2},
  [2804] = {.lex_state = 5, .external_lex_state = 3},
  [2805] = {.lex_state = 5, .external_lex_state = 3},
  [2806] = {.lex_state = 5, .external_lex_state = 3},
  [2807] = {.lex_state = 5, .external_lex_state = 3},
  [2808] = {.lex_state = 5, .external_lex_state = 3},
  [2809] = {.lex_state = 5, .external_lex_state = 3},
  [2810] = {.lex_state = 5, .external_lex_state = 3},
  [2811] = {.lex_state = 9, .external_lex_state = 2},
  [2812] = {.lex_state = 5, .external_lex_state = 3},
  [2813] = {.lex_state = 5, .external_lex_state = 3},
  [2814] = {.lex_state = 9, .external_lex_state = 2},
  [2815] = {.lex_state = 9, .external_lex_state = 2},
  [2816] = {.lex_state = 5, .external_lex_state = 3},
  [2817] = {.lex_state = 77, .external_lex_state = 5},
  [2818] = {.lex_state = 77, .external_lex_state = 5},
  [2819] = {.lex_state = 9, .external_lex_state = 2},
  [2820] = {.lex_state = 9, .external_lex_state = 2},
  [2821] = {.lex_state = 5, .external_lex_state = 3},
  [2822] = {.lex_state = 5, .external_lex_state = 3},
  [2823] = {.lex_state = 5, .external_lex_state = 3},
  [2824] = {.lex_state = 5, .external_lex_state = 3},
  [2825] = {.lex_state = 9, .external_lex_state = 2},
  [2826] = {.lex_state = 5, .external_lex_state = 3},
  [2827] = {.lex_state = 5, .external_lex_state = 3},
  [2828] = {.lex_state = 5, .external_lex_state = 3},
  [2829] = {.lex_state = 9, .external_lex_state = 2},
  [2830] = {.lex_state = 9, .external_lex_state = 2},
  [2831] = {.lex_state = 5, .external_lex_state = 3},
  [2832] = {.lex_state = 5, .external_lex_state = 3},
  [2833] = {.lex_state = 77, .external_lex_state = 5},
  [2834] = {.lex_state = 5, .external_lex_state = 3},
  [2835] = {.lex_state = 5, .external_lex_state = 3},
  [2836] = {.lex_state = 5, .external_lex_state = 3},
  [2837] = {.lex_state = 5, .external_lex_state = 3},
  [2838] = {.lex_state = 5, .external_lex_state = 3},
  [2839] = {.lex_state = 5, .external_lex_state = 3},
  [2840] = {.lex_state = 5, .external_lex_state = 3},
  [2841] = {.lex_state = 5, .external_lex_state = 3},
  [2842] = {.lex_state = 5, .external_lex_state = 3},
  [2843] = {.lex_state = 77, .external_lex_state = 2},
  [2844] = {.lex_state = 5, .external_lex_state = 3},
  [2845] = {.lex_state = 9, .external_lex_state = 2},
  [2846] = {.lex_state = 5, .external_lex_state = 3},
  [2847] = {.lex_state = 5, .external_lex_state = 3},
  [2848] = {.lex_state = 5, .external_lex_state = 3},
  [2849] = {.lex_state = 77, .external_lex_state = 5},
  [2850] = {.lex_state = 5, .external_lex_state = 3},
  [2851] = {.lex_state = 5, .external_lex_state = 3},
  [2852] = {.lex_state = 5, .external_lex_state = 3},
  [2853] = {.lex_state = 9, .external_lex_state = 2},
  [2854] = {.lex_state = 5, .external_lex_state = 3},
  [2855] = {.lex_state = 77, .external_lex_state = 2},
  [2856] = {.lex_state = 77, .external_lex_state = 2},
  [2857] = {.lex_state = 77, .external_lex_state = 5},
  [2858] = {.lex_state = 9, .external_lex_state = 2},
  [2859] = {.lex_state = 77, .external_lex_state = 2},
  [2860] = {.lex_state = 5, .external_lex_state = 3},
  [2861] = {.lex_state = 9, .external_lex_state = 2},
  [2862] = {.lex_state = 77, .external_lex_state = 2},
  [2863] = {.lex_state = 5, .external_lex_state = 4},
  [2864] = {.lex_state = 5, .external_lex_state = 3},
  [2865] = {.lex_state = 5, .external_lex_state = 3},
  [2866] = {.lex_state = 9, .external_lex_state = 2},
  [2867] = {.lex_state = 9, .external_lex_state = 2},
  [2868] = {.lex_state = 5, .external_lex_state = 3},
  [2869] = {.lex_state = 77, .external_lex_state = 5},
  [2870] = {.lex_state = 77, .external_lex_state = 2},
  [2871] = {.lex_state = 9, .external_lex_state = 2},
  [2872] = {.lex_state = 9, .external_lex_state = 2},
  [2873] = {.lex_state = 77, .external_lex_state = 2},
  [2874] = {.lex_state = 77, .external_lex_state = 2},
  [2875] = {.lex_state = 5, .external_lex_state = 3},
  [2876] = {.lex_state = 77, .external_lex_state = 2},
  [2877] = {.lex_state = 77, .external_lex_state = 5},
  [2878] = {.lex_state = 77, .external_lex_state = 2},
  [2879] = {.lex_state = 77, .external_lex_state = 5},
  [2880] = {.lex_state = 77, .external_lex_state = 2},
  [2881] = {.lex_state = 77, .external_lex_state = 2},
  [2882] = {.lex_state = 77, .external_lex_state = 2},
  [2883] = {.lex_state = 77, .external_lex_state = 2},
  [2884] = {.lex_state = 77, .external_lex_state = 2},
  [2885] = {.lex_state = 77, .external_lex_state = 2},
  [2886] = {.lex_state = 77, .external_lex_state = 2},
  [2887] = {.lex_state = 77, .external_lex_state = 2},
  [2888] = {.lex_state = 77, .external_lex_state = 2},
  [2889] = {.lex_state = 77, .external_lex_state = 2},
  [2890] = {.lex_state = 77, .external_lex_state = 2},
  [2891] = {.lex_state = 77, .external_lex_state = 2},
  [2892] = {.lex_state = 77, .external_lex_state = 2},
  [2893] = {.lex_state = 77, .external_lex_state = 5},
  [2894] = {.lex_state = 77, .external_lex_state = 5},
  [2895] = {.lex_state = 77, .external_lex_state = 2},
  [2896] = {.lex_state = 77, .external_lex_state = 2},
  [2897] = {.lex_state = 77, .external_lex_state = 2},
  [2898] = {.lex_state = 77, .external_lex_state = 2},
  [2899] = {.lex_state = 77, .external_lex_state = 2},
  [2900] = {.lex_state = 77, .external_lex_state = 2},
  [2901] = {.lex_state = 77, .external_lex_state = 2},
  [2902] = {.lex_state = 77, .external_lex_state = 2},
  [2903] = {.lex_state = 77, .external_lex_state = 2},
  [2904] = {.lex_state = 77, .external_lex_state = 2},
  [2905] = {.lex_state = 77, .external_lex_state = 2},
  [2906] = {.lex_state = 77, .external_lex_state = 2},
  [2907] = {.lex_state = 77, .external_lex_state = 2},
  [2908] = {.lex_state = 77, .external_lex_state = 2},
  [2909] = {.lex_state = 77, .external_lex_state = 2},
  [2910] = {.lex_state = 77, .external_lex_state = 2},
  [2911] = {.lex_state = 77, .external_lex_state = 2},
  [2912] = {.lex_state = 77, .external_lex_state = 2},
  [2913] = {.lex_state = 6, .external_lex_state = 3},
  [2914] = {.lex_state = 77, .external_lex_state = 2},
  [2915] = {.lex_state = 77, .external_lex_state = 2},
  [2916] = {.lex_state = 77, .external_lex_state = 2},
  [2917] = {.lex_state = 77, .external_lex_state = 2},
  [2918] = {.lex_state = 77, .external_lex_state = 2},
  [2919] = {.lex_state = 77, .external_lex_state = 2},
  [2920] = {.lex_state = 77, .external_lex_state = 2},
  [2921] = {.lex_state = 77, .external_lex_state = 2},
  [2922] = {.lex_state = 77, .external_lex_state = 2},
  [2923] = {.lex_state = 77, .external_lex_state = 2},
  [2924] = {.lex_state = 77, .external_lex_state = 2},
  [2925] = {.lex_state = 77, .external_lex_state = 2},
  [2926] = {.lex_state = 77, .external_lex_state = 2},
  [2927] = {.lex_state = 77, .external_lex_state = 2},
  [2928] = {.lex_state = 77, .external_lex_state = 2},
  [2929] = {.lex_state = 77, .external_lex_state = 2},
  [2930] = {.lex_state = 77, .external_lex_state = 2},
  [2931] = {.lex_state = 77, .external_lex_state = 2},
  [2932] = {.lex_state = 77, .external_lex_state = 2},
  [2933] = {.lex_state = 77, .external_lex_state = 2},
  [2934] = {.lex_state = 77, .external_lex_state = 2},
  [2935] = {.lex_state = 77, .external_lex_state = 5},
  [2936] = {.lex_state = 77, .external_lex_state = 5},
  [2937] = {.lex_state = 77, .external_lex_state = 5},
  [2938] = {.lex_state = 77, .external_lex_state = 2},
  [2939] = {.lex_state = 5, .external_lex_state = 3},
  [2940] = {.lex_state = 77, .external_lex_state = 2},
  [2941] = {.lex_state = 77, .external_lex_state = 2},
  [2942] = {.lex_state = 77, .external_lex_state = 2},
  [2943] = {.lex_state = 77, .external_lex_state = 2},
  [2944] = {.lex_state = 77, .external_lex_state = 2},
  [2945] = {.lex_state = 77, .external_lex_state = 2},
  [2946] = {.lex_state = 77, .external_lex_state = 2},
  [2947] = {.lex_state = 77, .external_lex_state = 2},
  [2948] = {.lex_state = 77, .external_lex_state = 2},
  [2949] = {.lex_state = 5, .external_lex_state = 3},
  [2950] = {.lex_state = 77, .external_lex_state = 2},
  [2951] = {.lex_state = 77, .external_lex_state = 2},
  [2952] = {.lex_state = 77, .external_lex_state = 2},
  [2953] = {.lex_state = 5, .external_lex_state = 3},
  [2954] = {.lex_state = 77, .external_lex_state = 5},
  [2955] = {.lex_state = 5, .external_lex_state = 3},
  [2956] = {.lex_state = 77, .external_lex_state = 2},
  [2957] = {.lex_state = 77, .external_lex_state = 5},
  [2958] = {.lex_state = 77, .external_lex_state = 2},
  [2959] = {.lex_state = 77, .external_lex_state = 5},
  [2960] = {.lex_state = 77, .external_lex_state = 2},
  [2961] = {.lex_state = 77, .external_lex_state = 2},
  [2962] = {.lex_state = 77, .external_lex_state = 2},
  [2963] = {.lex_state = 77, .external_lex_state = 2},
  [2964] = {.lex_state = 77, .external_lex_state = 2},
  [2965] = {.lex_state = 77, .external_lex_state = 2},
  [2966] = {.lex_state = 77, .external_lex_state = 2},
  [2967] = {.lex_state = 5, .external_lex_state = 3},
  [2968] = {.lex_state = 77, .external_lex_state = 2},
  [2969] = {.lex_state = 77, .external_lex_state = 2},
  [2970] = {.lex_state = 77, .external_lex_state = 2},
  [2971] = {.lex_state = 77, .external_lex_state = 2},
  [2972] = {.lex_state = 77, .external_lex_state = 2},
  [2973] = {.lex_state = 77, .external_lex_state = 2},
  [2974] = {.lex_state = 77, .external_lex_state = 2},
  [2975] = {.lex_state = 77, .external_lex_state = 2},
  [2976] = {.lex_state = 77, .external_lex_state = 2},
  [2977] = {.lex_state = 77, .external_lex_state = 2},
  [2978] = {.lex_state = 77, .external_lex_state = 2},
  [2979] = {.lex_state = 77, .external_lex_state = 2},
  [2980] = {.lex_state = 5, .external_lex_state = 3},
  [2981] = {.lex_state = 77, .external_lex_state = 2},
  [2982] = {.lex_state = 77, .external_lex_state = 2},
  [2983] = {.lex_state = 77, .external_lex_state = 2},
  [2984] = {.lex_state = 77, .external_lex_state = 2},
  [2985] = {.lex_state = 77, .external_lex_state = 2},
  [2986] = {.lex_state = 77, .external_lex_state = 2},
  [2987] = {.lex_state = 77, .external_lex_state = 2},
  [2988] = {.lex_state = 77, .external_lex_state = 2},
  [2989] = {.lex_state = 77, .external_lex_state = 2},
  [2990] = {.lex_state = 77, .external_lex_state = 2},
  [2991] = {.lex_state = 77, .external_lex_state = 2},
  [2992] = {.lex_state = 5, .external_lex_state = 3},
  [2993] = {.lex_state = 77, .external_lex_state = 2},
  [2994] = {.lex_state = 77, .external_lex_state = 2},
  [2995] = {.lex_state = 77, .external_lex_state = 2},
  [2996] = {.lex_state = 5, .external_lex_state = 3},
  [2997] = {.lex_state = 77, .external_lex_state = 2},
  [2998] = {.lex_state = 77, .external_lex_state = 2},
  [2999] = {.lex_state = 77, .external_lex_state = 2},
  [3000] = {.lex_state = 77, .external_lex_state = 2},
  [3001] = {.lex_state = 77, .external_lex_state = 2},
  [3002] = {.lex_state = 77, .external_lex_state = 2},
  [3003] = {.lex_state = 77, .external_lex_state = 2},
  [3004] = {.lex_state = 77, .external_lex_state = 2},
  [3005] = {.lex_state = 77, .external_lex_state = 2},
  [3006] = {.lex_state = 77, .external_lex_state = 2},
  [3007] = {.lex_state = 5, .external_lex_state = 3},
  [3008] = {.lex_state = 77, .external_lex_state = 2},
  [3009] = {.lex_state = 5, .external_lex_state = 3},
  [3010] = {.lex_state = 77, .external_lex_state = 2},
  [3011] = {.lex_state = 77, .external_lex_state = 2},
  [3012] = {.lex_state = 77, .external_lex_state = 2},
  [3013] = {.lex_state = 77, .external_lex_state = 2},
  [3014] = {.lex_state = 77, .external_lex_state = 2},
  [3015] = {.lex_state = 77, .external_lex_state = 2},
  [3016] = {.lex_state = 77, .external_lex_state = 2},
  [3017] = {.lex_state = 77, .external_lex_state = 2},
  [3018] = {.lex_state = 77, .external_lex_state = 2},
  [3019] = {.lex_state = 77, .external_lex_state = 2},
  [3020] = {.lex_state = 77, .external_lex_state = 2},
  [3021] = {.lex_state = 77, .external_lex_state = 2},
  [3022] = {.lex_state = 77, .external_lex_state = 2},
  [3023] = {.lex_state = 77, .external_lex_state = 2},
  [3024] = {.lex_state = 77, .external_lex_state = 2},
  [3025] = {.lex_state = 77, .external_lex_state = 2},
  [3026] = {.lex_state = 77, .external_lex_state = 2},
  [3027] = {.lex_state = 77, .external_lex_state = 2},
  [3028] = {.lex_state = 77, .external_lex_state = 2},
  [3029] = {.lex_state = 77, .external_lex_state = 2},
  [3030] = {.lex_state = 77, .external_lex_state = 2},
  [3031] = {.lex_state = 77, .external_lex_state = 2},
  [3032] = {.lex_state = 77, .external_lex_state = 2},
  [3033] = {.lex_state = 77, .external_lex_state = 2},
  [3034] = {.lex_state = 77, .external_lex_state = 2},
  [3035] = {.lex_state = 77, .external_lex_state = 2},
  [3036] = {.lex_state = 77, .external_lex_state = 2},
  [3037] = {.lex_state = 77, .external_lex_state = 2},
  [3038] = {.lex_state = 77, .external_lex_state = 2},
  [3039] = {.lex_state = 77, .external_lex_state = 2},
  [3040] = {.lex_state = 77, .external_lex_state = 2},
  [3041] = {.lex_state = 77, .external_lex_state = 2},
  [3042] = {.lex_state = 77, .external_lex_state = 2},
  [3043] = {.lex_state = 77, .external_lex_state = 2},
  [3044] = {.lex_state = 77, .external_lex_state = 2},
  [3045] = {.lex_state = 77, .external_lex_state = 2},
  [3046] = {.lex_state = 77, .external_lex_state = 2},
  [3047] = {.lex_state = 77, .external_lex_state = 2},
  [3048] = {.lex_state = 77, .external_lex_state = 2},
  [3049] = {.lex_state = 77, .external_lex_state = 2},
  [3050] = {.lex_state = 77, .external_lex_state = 2},
  [3051] = {.lex_state = 77, .external_lex_state = 2},
  [3052] = {.lex_state = 5, .external_lex_state = 3},
  [3053] = {.lex_state = 77, .external_lex_state = 2},
  [3054] = {.lex_state = 77, .external_lex_state = 2},
  [3055] = {.lex_state = 77, .external_lex_state = 2},
  [3056] = {.lex_state = 77, .external_lex_state = 2},
  [3057] = {.lex_state = 77, .external_lex_state = 2},
  [3058] = {.lex_state = 77, .external_lex_state = 2},
  [3059] = {.lex_state = 77, .external_lex_state = 2},
  [3060] = {.lex_state = 5, .external_lex_state = 3},
  [3061] = {.lex_state = 77, .external_lex_state = 2},
  [3062] = {.lex_state = 77, .external_lex_state = 2},
  [3063] = {.lex_state = 77, .external_lex_state = 2},
  [3064] = {.lex_state = 77, .external_lex_state = 2},
  [3065] = {.lex_state = 77, .external_lex_state = 2},
  [3066] = {.lex_state = 77, .external_lex_state = 2},
  [3067] = {.lex_state = 77, .external_lex_state = 2},
  [3068] = {.lex_state = 77, .external_lex_state = 2},
  [3069] = {.lex_state = 77, .external_lex_state = 2},
  [3070] = {.lex_state = 77, .external_lex_state = 2},
  [3071] = {.lex_state = 5, .external_lex_state = 3},
  [3072] = {.lex_state = 77, .external_lex_state = 2},
  [3073] = {.lex_state = 77, .external_lex_state = 2},
  [3074] = {.lex_state = 77, .external_lex_state = 2},
  [3075] = {.lex_state = 5, .external_lex_state = 3},
  [3076] = {.lex_state = 77, .external_lex_state = 2},
  [3077] = {.lex_state = 77, .external_lex_state = 2},
  [3078] = {.lex_state = 77, .external_lex_state = 2},
  [3079] = {.lex_state = 77, .external_lex_state = 2},
  [3080] = {.lex_state = 77, .external_lex_state = 2},
  [3081] = {.lex_state = 77, .external_lex_state = 2},
  [3082] = {.lex_state = 77, .external_lex_state = 2},
  [3083] = {.lex_state = 77, .external_lex_state = 2},
  [3084] = {.lex_state = 77, .external_lex_state = 2},
  [3085] = {.lex_state = 77, .external_lex_state = 2},
  [3086] = {.lex_state = 77, .external_lex_state = 2},
  [3087] = {.lex_state = 77, .external_lex_state = 2},
  [3088] = {.lex_state = 5, .external_lex_state = 3},
  [3089] = {.lex_state = 77, .external_lex_state = 2},
  [3090] = {.lex_state = 77, .external_lex_state = 2},
  [3091] = {.lex_state = 77, .external_lex_state = 2},
  [3092] = {.lex_state = 77, .external_lex_state = 2},
  [3093] = {.lex_state = 77, .external_lex_state = 2},
  [3094] = {.lex_state = 77, .external_lex_state = 2},
  [3095] = {.lex_state = 77, .external_lex_state = 2},
  [3096] = {.lex_state = 77, .external_lex_state = 2},
  [3097] = {.lex_state = 77, .external_lex_state = 2},
  [3098] = {.lex_state = 77, .external_lex_state = 2},
  [3099] = {.lex_state = 77, .external_lex_state = 2},
  [3100] = {.lex_state = 77, .external_lex_state = 2},
  [3101] = {.lex_state = 77, .external_lex_state = 2},
  [3102] = {.lex_state = 77, .external_lex_state = 2},
  [3103] = {.lex_state = 77, .external_lex_state = 2},
  [3104] = {.lex_state = 77, .external_lex_state = 2},
  [3105] = {.lex_state = 77, .external_lex_state = 2},
  [3106] = {.lex_state = 77, .external_lex_state = 2},
  [3107] = {.lex_state = 77, .external_lex_state = 2},
  [3108] = {.lex_state = 77, .external_lex_state = 2},
  [3109] = {.lex_state = 77, .external_lex_state = 2},
  [3110] = {.lex_state = 77, .external_lex_state = 2},
  [3111] = {.lex_state = 77, .external_lex_state = 2},
  [3112] = {.lex_state = 77, .external_lex_state = 2},
  [3113] = {.lex_state = 77, .external_lex_state = 2},
  [3114] = {.lex_state = 77, .external_lex_state = 2},
  [3115] = {.lex_state = 77, .external_lex_state = 2},
  [3116] = {.lex_state = 77, .external_lex_state = 2},
  [3117] = {.lex_state = 77, .external_lex_state = 2},
  [3118] = {.lex_state = 77, .external_lex_state = 2},
  [3119] = {.lex_state = 77, .external_lex_state = 2},
  [3120] = {.lex_state = 77, .external_lex_state = 2},
  [3121] = {.lex_state = 77, .external_lex_state = 2},
  [3122] = {.lex_state = 77, .external_lex_state = 2},
  [3123] = {.lex_state = 77, .external_lex_state = 2},
  [3124] = {.lex_state = 77, .external_lex_state = 2},
  [3125] = {.lex_state = 77, .external_lex_state = 2},
  [3126] = {.lex_state = 77, .external_lex_state = 2},
  [3127] = {.lex_state = 77, .external_lex_state = 2},
  [3128] = {.lex_state = 77, .external_lex_state = 2},
  [3129] = {.lex_state = 77, .external_lex_state = 2},
  [3130] = {.lex_state = 77, .external_lex_state = 2},
  [3131] = {.lex_state = 77, .external_lex_state = 2},
  [3132] = {.lex_state = 77, .external_lex_state = 2},
  [3133] = {.lex_state = 77, .external_lex_state = 2},
  [3134] = {.lex_state = 77, .external_lex_state = 2},
  [3135] = {.lex_state = 5, .external_lex_state = 3},
  [3136] = {.lex_state = 77, .external_lex_state = 2},
  [3137] = {.lex_state = 77, .external_lex_state = 2},
  [3138] = {.lex_state = 77, .external_lex_state = 2},
  [3139] = {.lex_state = 77, .external_lex_state = 2},
  [3140] = {.lex_state = 77, .external_lex_state = 2},
  [3141] = {.lex_state = 77, .external_lex_state = 2},
  [3142] = {.lex_state = 77, .external_lex_state = 2},
  [3143] = {.lex_state = 77, .external_lex_state = 2},
  [3144] = {.lex_state = 77, .external_lex_state = 2},
  [3145] = {.lex_state = 77, .external_lex_state = 2},
  [3146] = {.lex_state = 77, .external_lex_state = 2},
  [3147] = {.lex_state = 77, .external_lex_state = 2},
  [3148] = {.lex_state = 77, .external_lex_state = 2},
  [3149] = {.lex_state = 4, .external_lex_state = 2},
  [3150] = {.lex_state = 77, .external_lex_state = 2},
  [3151] = {.lex_state = 77, .external_lex_state = 2},
  [3152] = {.lex_state = 77, .external_lex_state = 2},
  [3153] = {.lex_state = 77, .external_lex_state = 2},
  [3154] = {.lex_state = 77, .external_lex_state = 2},
  [3155] = {.lex_state = 77, .external_lex_state = 2},
  [3156] = {.lex_state = 77, .external_lex_state = 2},
  [3157] = {.lex_state = 77, .external_lex_state = 2},
  [3158] = {.lex_state = 77, .external_lex_state = 2},
  [3159] = {.lex_state = 77, .external_lex_state = 2},
  [3160] = {.lex_state = 77, .external_lex_state = 2},
  [3161] = {.lex_state = 77, .external_lex_state = 2},
  [3162] = {.lex_state = 77, .external_lex_state = 2},
  [3163] = {.lex_state = 77, .external_lex_state = 2},
  [3164] = {.lex_state = 77, .external_lex_state = 2},
  [3165] = {.lex_state = 77, .external_lex_state = 2},
  [3166] = {.lex_state = 77, .external_lex_state = 2},
  [3167] = {.lex_state = 77, .external_lex_state = 2},
  [3168] = {.lex_state = 77, .external_lex_state = 2},
  [3169] = {.lex_state = 77, .external_lex_state = 2},
  [3170] = {.lex_state = 77, .external_lex_state = 2},
  [3171] = {.lex_state = 77, .external_lex_state = 2},
  [3172] = {.lex_state = 77, .external_lex_state = 2},
  [3173] = {.lex_state = 77, .external_lex_state = 2},
  [3174] = {.lex_state = 77, .external_lex_state = 2},
  [3175] = {.lex_state = 77, .external_lex_state = 2},
  [3176] = {.lex_state = 77, .external_lex_state = 5},
  [3177] = {.lex_state = 77, .external_lex_state = 2},
  [3178] = {.lex_state = 77, .external_lex_state = 2},
  [3179] = {.lex_state = 77, .external_lex_state = 2},
  [3180] = {.lex_state = 77, .external_lex_state = 2},
  [3181] = {.lex_state = 77, .external_lex_state = 2},
  [3182] = {.lex_state = 4, .external_lex_state = 2},
  [3183] = {.lex_state = 77, .external_lex_state = 2},
  [3184] = {.lex_state = 4, .external_lex_state = 2},
  [3185] = {.lex_state = 77, .external_lex_state = 2},
  [3186] = {.lex_state = 77, .external_lex_state = 2},
  [3187] = {.lex_state = 77, .external_lex_state = 2},
  [3188] = {.lex_state = 77, .external_lex_state = 2},
  [3189] = {.lex_state = 14, .external_lex_state = 2},
  [3190] = {.lex_state = 14, .external_lex_state = 2},
  [3191] = {.lex_state = 14, .external_lex_state = 2},
  [3192] = {.lex_state = 14, .external_lex_state = 2},
  [3193] = {.lex_state = 14, .external_lex_state = 2},
  [3194] = {.lex_state = 14, .external_lex_state = 2},
  [3195] = {.lex_state = 14, .external_lex_state = 2},
  [3196] = {.lex_state = 14, .external_lex_state = 2},
  [3197] = {.lex_state = 14, .external_lex_state = 2},
  [3198] = {.lex_state = 14, .external_lex_state = 2},
  [3199] = {.lex_state = 14, .external_lex_state = 2},
  [3200] = {.lex_state = 14, .external_lex_state = 2},
  [3201] = {.lex_state = 14, .external_lex_state = 2},
  [3202] = {.lex_state = 14, .external_lex_state = 2},
  [3203] = {.lex_state = 14, .external_lex_state = 2},
  [3204] = {.lex_state = 14, .external_lex_state = 2},
  [3205] = {.lex_state = 14, .external_lex_state = 2},
  [3206] = {.lex_state = 14, .external_lex_state = 2},
  [3207] = {.lex_state = 14, .external_lex_state = 2},
  [3208] = {.lex_state = 14, .external_lex_state = 2},
  [3209] = {.lex_state = 14, .external_lex_state = 2},
  [3210] = {.lex_state = 14, .external_lex_state = 2},
  [3211] = {.lex_state = 14, .external_lex_state = 2},
  [3212] = {.lex_state = 14, .external_lex_state = 2},
  [3213] = {.lex_state = 14, .external_lex_state = 2},
  [3214] = {.lex_state = 14, .external_lex_state = 2},
  [3215] = {.lex_state = 14, .external_lex_state = 2},
  [3216] = {.lex_state = 14, .external_lex_state = 2},
  [3217] = {.lex_state = 14, .external_lex_state = 2},
  [3218] = {.lex_state = 14, .external_lex_state = 2},
  [3219] = {.lex_state = 14, .external_lex_state = 2},
  [3220] = {.lex_state = 14, .external_lex_state = 2},
  [3221] = {.lex_state = 14, .external_lex_state = 2},
  [3222] = {.lex_state = 14, .external_lex_state = 2},
  [3223] = {.lex_state = 14, .external_lex_state = 2},
  [3224] = {.lex_state = 14, .external_lex_state = 2},
  [3225] = {.lex_state = 14, .external_lex_state = 2},
  [3226] = {.lex_state = 14, .external_lex_state = 2},
  [3227] = {.lex_state = 14, .external_lex_state = 2},
  [3228] = {.lex_state = 14, .external_lex_state = 2},
  [3229] = {.lex_state = 11, .external_lex_state = 5},
  [3230] = {.lex_state = 11, .external_lex_state = 5},
  [3231] = {.lex_state = 11, .external_lex_state = 2},
  [3232] = {.lex_state = 11, .external_lex_state = 2},
  [3233] = {.lex_state = 14, .external_lex_state = 2},
  [3234] = {.lex_state = 14, .external_lex_state = 2},
  [3235] = {.lex_state = 11, .external_lex_state = 2},
  [3236] = {.lex_state = 11, .external_lex_state = 2},
  [3237] = {.lex_state = 11, .external_lex_state = 2},
  [3238] = {.lex_state = 14, .external_lex_state = 2},
  [3239] = {.lex_state = 11, .external_lex_state = 2},
  [3240] = {.lex_state = 11, .external_lex_state = 2},
  [3241] = {.lex_state = 14, .external_lex_state = 5},
  [3242] = {.lex_state = 14, .external_lex_state = 2},
  [3243] = {.lex_state = 14, .external_lex_state = 2},
  [3244] = {.lex_state = 11, .external_lex_state = 2},
  [3245] = {.lex_state = 14, .external_lex_state = 5},
  [3246] = {.lex_state = 11, .external_lex_state = 2},
  [3247] = {.lex_state = 14, .external_lex_state = 2},
  [3248] = {.lex_state = 14, .external_lex_state = 5},
  [3249] = {.lex_state = 14, .external_lex_state = 2},
  [3250] = {.lex_state = 11, .external_lex_state = 2},
  [3251] = {.lex_state = 9, .external_lex_state = 2},
  [3252] = {.lex_state = 11, .external_lex_state = 2},
  [3253] = {.lex_state = 11, .external_lex_state = 2},
  [3254] = {.lex_state = 9, .external_lex_state = 2},
  [3255] = {.lex_state = 9, .external_lex_state = 2},
  [3256] = {.lex_state = 77, .external_lex_state = 2},
  [3257] = {.lex_state = 77, .external_lex_state = 2},
  [3258] = {.lex_state = 14, .external_lex_state = 5},
  [3259] = {.lex_state = 77, .external_lex_state = 2},
  [3260] = {.lex_state = 14, .external_lex_state = 5},
  [3261] = {.lex_state = 14, .external_lex_state = 5},
  [3262] = {.lex_state = 14, .external_lex_state = 5},
  [3263] = {.lex_state = 14, .external_lex_state = 5},
  [3264] = {.lex_state = 14, .external_lex_state = 5},
  [3265] = {.lex_state = 14, .external_lex_state = 5},
  [3266] = {.lex_state = 14, .external_lex_state = 5},
  [3267] = {.lex_state = 14, .external_lex_state = 5},
  [3268] = {.lex_state = 9, .external_lex_state = 2},
  [3269] = {.lex_state = 77, .external_lex_state = 2},
  [3270] = {.lex_state = 77, .external_lex_state = 2},
  [3271] = {.lex_state = 77, .external_lex_state = 2},
  [3272] = {.lex_state = 77, .external_lex_state = 2},
  [3273] = {.lex_state = 77, .external_lex_state = 2},
  [3274] = {.lex_state = 9, .external_lex_state = 2},
  [3275] = {.lex_state = 14, .external_lex_state = 5},
  [3276] = {.lex_state = 14, .external_lex_state = 5},
  [3277] = {.lex_state = 14, .external_lex_state = 5},
  [3278] = {.lex_state = 14, .external_lex_state = 5},
  [3279] = {.lex_state = 14, .external_lex_state = 5},
  [3280] = {.lex_state = 14, .external_lex_state = 5},
  [3281] = {.lex_state = 14, .external_lex_state = 5},
  [3282] = {.lex_state = 14, .external_lex_state = 5},
  [3283] = {.lex_state = 14, .external_lex_state = 5},
  [3284] = {.lex_state = 14, .external_lex_state = 5},
  [3285] = {.lex_state = 9, .external_lex_state = 2},
  [3286] = {.lex_state = 9, .external_lex_state = 2},
  [3287] = {.lex_state = 9, .external_lex_state = 2},
  [3288] = {.lex_state = 9, .external_lex_state = 2},
  [3289] = {.lex_state = 9, .external_lex_state = 2},
  [3290] = {.lex_state = 9, .external_lex_state = 2},
  [3291] = {.lex_state = 9, .external_lex_state = 2},
  [3292] = {.lex_state = 9, .external_lex_state = 2},
  [3293] = {.lex_state = 9, .external_lex_state = 2},
  [3294] = {.lex_state = 9, .external_lex_state = 2},
  [3295] = {.lex_state = 9, .external_lex_state = 2},
  [3296] = {.lex_state = 11, .external_lex_state = 5},
  [3297] = {.lex_state = 77, .external_lex_state = 2},
  [3298] = {.lex_state = 9, .external_lex_state = 2},
  [3299] = {.lex_state = 9, .external_lex_state = 2},
  [3300] = {.lex_state = 9, .external_lex_state = 2},
  [3301] = {.lex_state = 9, .external_lex_state = 2},
  [3302] = {.lex_state = 9, .external_lex_state = 2},
  [3303] = {.lex_state = 9, .external_lex_state = 2},
  [3304] = {.lex_state = 9, .external_lex_state = 2},
  [3305] = {.lex_state = 9, .external_lex_state = 2},
  [3306] = {.lex_state = 77, .external_lex_state = 2},
  [3307] = {.lex_state = 77, .external_lex_state = 2},
  [3308] = {.lex_state = 9, .external_lex_state = 2},
  [3309] = {.lex_state = 9, .external_lex_state = 2},
  [3310] = {.lex_state = 9, .external_lex_state = 2},
  [3311] = {.lex_state = 9, .external_lex_state = 2},
  [3312] = {.lex_state = 9, .external_lex_state = 2},
  [3313] = {.lex_state = 9, .external_lex_state = 2},
  [3314] = {.lex_state = 9, .external_lex_state = 2},
  [3315] = {.lex_state = 9, .external_lex_state = 2},
  [3316] = {.lex_state = 9, .external_lex_state = 2},
  [3317] = {.lex_state = 9, .external_lex_state = 2},
  [3318] = {.lex_state = 9, .external_lex_state = 2},
  [3319] = {.lex_state = 77, .external_lex_state = 2},
  [3320] = {.lex_state = 9, .external_lex_state = 2},
  [3321] = {.lex_state = 77, .external_lex_state = 2},
  [3322] = {.lex_state = 77, .external_lex_state = 2},
  [3323] = {.lex_state = 77, .external_lex_state = 2},
  [3324] = {.lex_state = 14, .external_lex_state = 5},
  [3325] = {.lex_state = 14, .external_lex_state = 5},
  [3326] = {.lex_state = 14, .external_lex_state = 5},
  [3327] = {.lex_state = 14, .external_lex_state = 5},
  [3328] = {.lex_state = 14, .external_lex_state = 5},
  [3329] = {.lex_state = 14, .external_lex_state = 5},
  [3330] = {.lex_state = 14, .external_lex_state = 5},
  [3331] = {.lex_state = 14, .external_lex_state = 5},
  [3332] = {.lex_state = 14, .external_lex_state = 5},
  [3333] = {.lex_state = 77, .external_lex_state = 2},
  [3334] = {.lex_state = 14, .external_lex_state = 5},
  [3335] = {.lex_state = 14, .external_lex_state = 5},
  [3336] = {.lex_state = 14, .external_lex_state = 5},
  [3337] = {.lex_state = 77, .external_lex_state = 2},
  [3338] = {.lex_state = 77, .external_lex_state = 2},
  [3339] = {.lex_state = 77, .external_lex_state = 2},
  [3340] = {.lex_state = 77, .external_lex_state = 2},
  [3341] = {.lex_state = 14, .external_lex_state = 5},
  [3342] = {.lex_state = 14, .external_lex_state = 5},
  [3343] = {.lex_state = 77, .external_lex_state = 2},
  [3344] = {.lex_state = 9, .external_lex_state = 2},
  [3345] = {.lex_state = 77, .external_lex_state = 2},
  [3346] = {.lex_state = 77, .external_lex_state = 2},
  [3347] = {.lex_state = 77, .external_lex_state = 2},
  [3348] = {.lex_state = 77, .external_lex_state = 2},
  [3349] = {.lex_state = 77, .external_lex_state = 2},
  [3350] = {.lex_state = 77, .external_lex_state = 2},
  [3351] = {.lex_state = 77, .external_lex_state = 2},
  [3352] = {.lex_state = 77, .external_lex_state = 2},
  [3353] = {.lex_state = 14, .external_lex_state = 6},
  [3354] = {.lex_state = 14, .external_lex_state = 6},
  [3355] = {.lex_state = 14, .external_lex_state = 6},
  [3356] = {.lex_state = 14, .external_lex_state = 5},
  [3357] = {.lex_state = 9, .external_lex_state = 2},
  [3358] = {.lex_state = 9, .external_lex_state = 5},
  [3359] = {.lex_state = 9, .external_lex_state = 5},
  [3360] = {.lex_state = 9, .external_lex_state = 5},
  [3361] = {.lex_state = 9, .external_lex_state = 5},
  [3362] = {.lex_state = 9, .external_lex_state = 5},
  [3363] = {.lex_state = 9, .external_lex_state = 5},
  [3364] = {.lex_state = 9, .external_lex_state = 2},
  [3365] = {.lex_state = 9, .external_lex_state = 5},
  [3366] = {.lex_state = 9, .external_lex_state = 5},
  [3367] = {.lex_state = 9, .external_lex_state = 5},
  [3368] = {.lex_state = 9, .external_lex_state = 5},
  [3369] = {.lex_state = 9, .external_lex_state = 5},
  [3370] = {.lex_state = 9, .external_lex_state = 5},
  [3371] = {.lex_state = 77, .external_lex_state = 2},
  [3372] = {.lex_state = 77, .external_lex_state = 2},
  [3373] = {.lex_state = 9, .external_lex_state = 5},
  [3374] = {.lex_state = 77, .external_lex_state = 2},
  [3375] = {.lex_state = 9, .external_lex_state = 5},
  [3376] = {.lex_state = 9, .external_lex_state = 5},
  [3377] = {.lex_state = 11, .external_lex_state = 5},
  [3378] = {.lex_state = 9, .external_lex_state = 5},
  [3379] = {.lex_state = 77, .external_lex_state = 2},
  [3380] = {.lex_state = 9, .external_lex_state = 5},
  [3381] = {.lex_state = 9, .external_lex_state = 2},
  [3382] = {.lex_state = 9, .external_lex_state = 5},
  [3383] = {.lex_state = 9, .external_lex_state = 5},
  [3384] = {.lex_state = 9, .external_lex_state = 5},
  [3385] = {.lex_state = 9, .external_lex_state = 5},
  [3386] = {.lex_state = 9, .external_lex_state = 2},
  [3387] = {.lex_state = 9, .external_lex_state = 5},
  [3388] = {.lex_state = 77, .external_lex_state = 2},
  [3389] = {.lex_state = 9, .external_lex_state = 5},
  [3390] = {.lex_state = 9, .external_lex_state = 5},
  [3391] = {.lex_state = 9, .external_lex_state = 5},
  [3392] = {.lex_state = 11, .external_lex_state = 5},
  [3393] = {.lex_state = 9, .external_lex_state = 5},
  [3394] = {.lex_state = 9, .external_lex_state = 5},
  [3395] = {.lex_state = 9, .external_lex_state = 2},
  [3396] = {.lex_state = 77, .external_lex_state = 2},
  [3397] = {.lex_state = 9, .external_lex_state = 5},
  [3398] = {.lex_state = 77, .external_lex_state = 2},
  [3399] = {.lex_state = 9, .external_lex_state = 5},
  [3400] = {.lex_state = 14, .external_lex_state = 6},
  [3401] = {.lex_state = 14, .external_lex_state = 6},
  [3402] = {.lex_state = 9, .external_lex_state = 2},
  [3403] = {.lex_state = 9, .external_lex_state = 5},
  [3404] = {.lex_state = 14, .external_lex_state = 5},
  [3405] = {.lex_state = 9, .external_lex_state = 2},
  [3406] = {.lex_state = 9, .external_lex_state = 2},
  [3407] = {.lex_state = 9, .external_lex_state = 5},
  [3408] = {.lex_state = 14, .external_lex_state = 5},
  [3409] = {.lex_state = 9, .external_lex_state = 5},
  [3410] = {.lex_state = 14, .external_lex_state = 6},
  [3411] = {.lex_state = 14, .external_lex_state = 5},
  [3412] = {.lex_state = 14, .external_lex_state = 5},
  [3413] = {.lex_state = 14, .external_lex_state = 6},
  [3414] = {.lex_state = 14, .external_lex_state = 6},
  [3415] = {.lex_state = 14, .external_lex_state = 6},
  [3416] = {.lex_state = 14, .external_lex_state = 6},
  [3417] = {.lex_state = 14, .external_lex_state = 5},
  [3418] = {.lex_state = 9, .external_lex_state = 5},
  [3419] = {.lex_state = 9, .external_lex_state = 5},
  [3420] = {.lex_state = 11, .external_lex_state = 5},
  [3421] = {.lex_state = 11, .external_lex_state = 5},
  [3422] = {.lex_state = 14, .external_lex_state = 6},
  [3423] = {.lex_state = 9, .external_lex_state = 5},
  [3424] = {.lex_state = 11, .external_lex_state = 5},
  [3425] = {.lex_state = 14, .external_lex_state = 6},
  [3426] = {.lex_state = 11, .external_lex_state = 5},
  [3427] = {.lex_state = 11, .external_lex_state = 5},
  [3428] = {.lex_state = 11, .external_lex_state = 5},
  [3429] = {.lex_state = 11, .external_lex_state = 2},
  [3430] = {.lex_state = 9, .external_lex_state = 2},
  [3431] = {.lex_state = 14, .external_lex_state = 6},
  [3432] = {.lex_state = 9, .external_lex_state = 2},
  [3433] = {.lex_state = 9, .external_lex_state = 5},
  [3434] = {.lex_state = 9, .external_lex_state = 5},
  [3435] = {.lex_state = 9, .external_lex_state = 2},
  [3436] = {.lex_state = 14, .external_lex_state = 6},
  [3437] = {.lex_state = 14, .external_lex_state = 5},
  [3438] = {.lex_state = 14, .external_lex_state = 6},
  [3439] = {.lex_state = 11, .external_lex_state = 5},
  [3440] = {.lex_state = 14, .external_lex_state = 6},
  [3441] = {.lex_state = 14, .external_lex_state = 5},
  [3442] = {.lex_state = 14, .external_lex_state = 5},
  [3443] = {.lex_state = 14, .external_lex_state = 6},
  [3444] = {.lex_state = 14, .external_lex_state = 6},
  [3445] = {.lex_state = 14, .external_lex_state = 6},
  [3446] = {.lex_state = 14, .external_lex_state = 6},
  [3447] = {.lex_state = 14, .external_lex_state = 6},
  [3448] = {.lex_state = 14, .external_lex_state = 6},
  [3449] = {.lex_state = 14, .external_lex_state = 6},
  [3450] = {.lex_state = 9, .external_lex_state = 5},
  [3451] = {.lex_state = 14, .external_lex_state = 6},
  [3452] = {.lex_state = 14, .external_lex_state = 6},
  [3453] = {.lex_state = 14, .external_lex_state = 6},
  [3454] = {.lex_state = 14, .external_lex_state = 6},
  [3455] = {.lex_state = 14, .external_lex_state = 6},
  [3456] = {.lex_state = 14, .external_lex_state = 6},
  [3457] = {.lex_state = 14, .external_lex_state = 6},
  [3458] = {.lex_state = 9, .external_lex_state = 5},
  [3459] = {.lex_state = 9, .external_lex_state = 5},
  [3460] = {.lex_state = 9, .external_lex_state = 2},
  [3461] = {.lex_state = 14, .external_lex_state = 6},
  [3462] = {.lex_state = 14, .external_lex_state = 6},
  [3463] = {.lex_state = 9, .external_lex_state = 2},
  [3464] = {.lex_state = 14, .external_lex_state = 6},
  [3465] = {.lex_state = 9, .external_lex_state = 2},
  [3466] = {.lex_state = 9, .external_lex_state = 2},
  [3467] = {.lex_state = 14, .external_lex_state = 6},
  [3468] = {.lex_state = 14, .external_lex_state = 6},
  [3469] = {.lex_state = 14, .external_lex_state = 6},
  [3470] = {.lex_state = 14, .external_lex_state = 6},
  [3471] = {.lex_state = 11, .external_lex_state = 6},
  [3472] = {.lex_state = 11, .external_lex_state = 5},
  [3473] = {.lex_state = 11, .external_lex_state = 6},
  [3474] = {.lex_state = 9, .external_lex_state = 5},
  [3475] = {.lex_state = 9, .external_lex_state = 5},
  [3476] = {.lex_state = 9, .external_lex_state = 5},
  [3477] = {.lex_state = 9, .external_lex_state = 5},
  [3478] = {.lex_state = 9, .external_lex_state = 5},
  [3479] = {.lex_state = 9, .external_lex_state = 2},
  [3480] = {.lex_state = 9, .external_lex_state = 5},
  [3481] = {.lex_state = 9, .external_lex_state = 5},
  [3482] = {.lex_state = 9, .external_lex_state = 5},
  [3483] = {.lex_state = 9, .external_lex_state = 5},
  [3484] = {.lex_state = 11, .external_lex_state = 5},
  [3485] = {.lex_state = 9, .external_lex_state = 5},
  [3486] = {.lex_state = 9, .external_lex_state = 5},
  [3487] = {.lex_state = 9, .external_lex_state = 5},
  [3488] = {.lex_state = 9, .external_lex_state = 5},
  [3489] = {.lex_state = 9, .external_lex_state = 5},
  [3490] = {.lex_state = 9, .external_lex_state = 5},
  [3491] = {.lex_state = 9, .external_lex_state = 5},
  [3492] = {.lex_state = 9, .external_lex_state = 5},
  [3493] = {.lex_state = 9, .external_lex_state = 5},
  [3494] = {.lex_state = 9, .external_lex_state = 5},
  [3495] = {.lex_state = 9, .external_lex_state = 5},
  [3496] = {.lex_state = 9, .external_lex_state = 5},
  [3497] = {.lex_state = 9, .external_lex_state = 5},
  [3498] = {.lex_state = 9, .external_lex_state = 5},
  [3499] = {.lex_state = 9, .external_lex_state = 5},
  [3500] = {.lex_state = 9, .external_lex_state = 2},
  [3501] = {.lex_state = 9, .external_lex_state = 5},
  [3502] = {.lex_state = 9, .external_lex_state = 5},
  [3503] = {.lex_state = 11, .external_lex_state = 5},
  [3504] = {.lex_state = 11, .external_lex_state = 5},
  [3505] = {.lex_state = 9, .external_lex_state = 5},
  [3506] = {.lex_state = 14, .external_lex_state = 2},
  [3507] = {.lex_state = 9, .external_lex_state = 5},
  [3508] = {.lex_state = 9, .external_lex_state = 5},
  [3509] = {.lex_state = 14, .external_lex_state = 2},
  [3510] = {.lex_state = 9, .external_lex_state = 5},
  [3511] = {.lex_state = 14, .external_lex_state = 2},
  [3512] = {.lex_state = 9, .external_lex_state = 5},
  [3513] = {.lex_state = 9, .external_lex_state = 5},
  [3514] = {.lex_state = 9, .external_lex_state = 5},
  [3515] = {.lex_state = 11, .external_lex_state = 6},
  [3516] = {.lex_state = 9, .external_lex_state = 5},
  [3517] = {.lex_state = 9, .external_lex_state = 5},
  [3518] = {.lex_state = 9, .external_lex_state = 5},
  [3519] = {.lex_state = 9, .external_lex_state = 5},
  [3520] = {.lex_state = 11, .external_lex_state = 2},
  [3521] = {.lex_state = 9, .external_lex_state = 5},
  [3522] = {.lex_state = 9, .external_lex_state = 5},
  [3523] = {.lex_state = 9, .external_lex_state = 5},
  [3524] = {.lex_state = 9, .external_lex_state = 5},
  [3525] = {.lex_state = 9, .external_lex_state = 5},
  [3526] = {.lex_state = 9, .external_lex_state = 5},
  [3527] = {.lex_state = 9, .external_lex_state = 5},
  [3528] = {.lex_state = 9, .external_lex_state = 5},
  [3529] = {.lex_state = 9, .external_lex_state = 5},
  [3530] = {.lex_state = 9, .external_lex_state = 2},
  [3531] = {.lex_state = 9, .external_lex_state = 5},
  [3532] = {.lex_state = 9, .external_lex_state = 5},
  [3533] = {.lex_state = 77, .external_lex_state = 2},
  [3534] = {.lex_state = 9, .external_lex_state = 5},
  [3535] = {.lex_state = 9, .external_lex_state = 5},
  [3536] = {.lex_state = 9, .external_lex_state = 5},
  [3537] = {.lex_state = 9, .external_lex_state = 5},
  [3538] = {.lex_state = 9, .external_lex_state = 5},
  [3539] = {.lex_state = 9, .external_lex_state = 5},
  [3540] = {.lex_state = 9, .external_lex_state = 5},
  [3541] = {.lex_state = 9, .external_lex_state = 5},
  [3542] = {.lex_state = 9, .external_lex_state = 5},
  [3543] = {.lex_state = 14, .external_lex_state = 6},
  [3544] = {.lex_state = 9, .external_lex_state = 5},
  [3545] = {.lex_state = 9, .external_lex_state = 5},
  [3546] = {.lex_state = 9, .external_lex_state = 5},
  [3547] = {.lex_state = 9, .external_lex_state = 5},
  [3548] = {.lex_state = 9, .external_lex_state = 5},
  [3549] = {.lex_state = 9, .external_lex_state = 5},
  [3550] = {.lex_state = 9, .external_lex_state = 5},
  [3551] = {.lex_state = 9, .external_lex_state = 5},
  [3552] = {.lex_state = 9, .external_lex_state = 5},
  [3553] = {.lex_state = 9, .external_lex_state = 5},
  [3554] = {.lex_state = 9, .external_lex_state = 5},
  [3555] = {.lex_state = 11, .external_lex_state = 6},
  [3556] = {.lex_state = 11, .external_lex_state = 6},
  [3557] = {.lex_state = 14, .external_lex_state = 6},
  [3558] = {.lex_state = 9, .external_lex_state = 5},
  [3559] = {.lex_state = 18, .external_lex_state = 2},
  [3560] = {.lex_state = 11, .external_lex_state = 6},
  [3561] = {.lex_state = 9, .external_lex_state = 5},
  [3562] = {.lex_state = 9, .external_lex_state = 5},
  [3563] = {.lex_state = 9, .external_lex_state = 5},
  [3564] = {.lex_state = 9, .external_lex_state = 5},
  [3565] = {.lex_state = 9, .external_lex_state = 5},
  [3566] = {.lex_state = 9, .external_lex_state = 5},
  [3567] = {.lex_state = 14, .external_lex_state = 6},
  [3568] = {.lex_state = 9, .external_lex_state = 5},
  [3569] = {.lex_state = 9, .external_lex_state = 5},
  [3570] = {.lex_state = 9, .external_lex_state = 5},
  [3571] = {.lex_state = 9, .external_lex_state = 5},
  [3572] = {.lex_state = 14, .external_lex_state = 6},
  [3573] = {.lex_state = 9, .external_lex_state = 5},
  [3574] = {.lex_state = 9, .external_lex_state = 5},
  [3575] = {.lex_state = 9, .external_lex_state = 5},
  [3576] = {.lex_state = 9, .external_lex_state = 5},
  [3577] = {.lex_state = 9, .external_lex_state = 5},
  [3578] = {.lex_state = 9, .external_lex_state = 5},
  [3579] = {.lex_state = 11, .external_lex_state = 6},
  [3580] = {.lex_state = 9, .external_lex_state = 5},
  [3581] = {.lex_state = 9, .external_lex_state = 5},
  [3582] = {.lex_state = 9, .external_lex_state = 6},
  [3583] = {.lex_state = 14, .external_lex_state = 6},
  [3584] = {.lex_state = 9, .external_lex_state = 5},
  [3585] = {.lex_state = 11, .external_lex_state = 6},
  [3586] = {.lex_state = 9, .external_lex_state = 5},
  [3587] = {.lex_state = 11, .external_lex_state = 6},
  [3588] = {.lex_state = 11, .external_lex_state = 6},
  [3589] = {.lex_state = 11, .external_lex_state = 6},
  [3590] = {.lex_state = 9, .external_lex_state = 5},
  [3591] = {.lex_state = 9, .external_lex_state = 5},
  [3592] = {.lex_state = 9, .external_lex_state = 5},
  [3593] = {.lex_state = 9, .external_lex_state = 5},
  [3594] = {.lex_state = 9, .external_lex_state = 5},
  [3595] = {.lex_state = 14, .external_lex_state = 6},
  [3596] = {.lex_state = 9, .external_lex_state = 5},
  [3597] = {.lex_state = 9, .external_lex_state = 5},
  [3598] = {.lex_state = 14, .external_lex_state = 6},
  [3599] = {.lex_state = 9, .external_lex_state = 5},
  [3600] = {.lex_state = 9, .external_lex_state = 5},
  [3601] = {.lex_state = 11, .external_lex_state = 2},
  [3602] = {.lex_state = 14, .external_lex_state = 6},
  [3603] = {.lex_state = 9, .external_lex_state = 5},
  [3604] = {.lex_state = 18, .external_lex_state = 2},
  [3605] = {.lex_state = 9, .external_lex_state = 5},
  [3606] = {.lex_state = 9, .external_lex_state = 5},
  [3607] = {.lex_state = 4, .external_lex_state = 2},
  [3608] = {.lex_state = 9, .external_lex_state = 2},
  [3609] = {.lex_state = 9, .external_lex_state = 2},
  [3610] = {.lex_state = 9, .external_lex_state = 2},
  [3611] = {.lex_state = 9, .external_lex_state = 2},
  [3612] = {.lex_state = 9, .external_lex_state = 5},
  [3613] = {.lex_state = 9, .external_lex_state = 2},
  [3614] = {.lex_state = 9, .external_lex_state = 2},
  [3615] = {.lex_state = 9, .external_lex_state = 5},
  [3616] = {.lex_state = 9, .external_lex_state = 6},
  [3617] = {.lex_state = 9, .external_lex_state = 5},
  [3618] = {.lex_state = 4, .external_lex_state = 2},
  [3619] = {.lex_state = 11, .external_lex_state = 2},
  [3620] = {.lex_state = 9, .external_lex_state = 5},
  [3621] = {.lex_state = 9, .external_lex_state = 5},
  [3622] = {.lex_state = 77, .external_lex_state = 2},
  [3623] = {.lex_state = 11, .external_lex_state = 6},
  [3624] = {.lex_state = 11, .external_lex_state = 2},
  [3625] = {.lex_state = 77, .external_lex_state = 2},
  [3626] = {.lex_state = 9, .external_lex_state = 6},
  [3627] = {.lex_state = 77, .external_lex_state = 2},
  [3628] = {.lex_state = 9, .external_lex_state = 2},
  [3629] = {.lex_state = 9, .external_lex_state = 2},
  [3630] = {.lex_state = 9, .external_lex_state = 2},
  [3631] = {.lex_state = 9, .external_lex_state = 6},
  [3632] = {.lex_state = 9, .external_lex_state = 6},
  [3633] = {.lex_state = 11, .external_lex_state = 6},
  [3634] = {.lex_state = 9, .external_lex_state = 2},
  [3635] = {.lex_state = 11, .external_lex_state = 6},
  [3636] = {.lex_state = 9, .external_lex_state = 2},
  [3637] = {.lex_state = 9, .external_lex_state = 2},
  [3638] = {.lex_state = 77, .external_lex_state = 2},
  [3639] = {.lex_state = 9, .external_lex_state = 2},
  [3640] = {.lex_state = 9, .external_lex_state = 6},
  [3641] = {.lex_state = 9, .external_lex_state = 5},
  [3642] = {.lex_state = 9, .external_lex_state = 6},
  [3643] = {.lex_state = 9, .external_lex_state = 6},
  [3644] = {.lex_state = 9, .external_lex_state = 2},
  [3645] = {.lex_state = 11, .external_lex_state = 2},
  [3646] = {.lex_state = 9, .external_lex_state = 6},
  [3647] = {.lex_state = 9, .external_lex_state = 2},
  [3648] = {.lex_state = 9, .external_lex_state = 6},
  [3649] = {.lex_state = 9, .external_lex_state = 5},
  [3650] = {.lex_state = 9, .external_lex_state = 5},
  [3651] = {.lex_state = 9, .external_lex_state = 2},
  [3652] = {.lex_state = 9, .external_lex_state = 5},
  [3653] = {.lex_state = 9, .external_lex_state = 6},
  [3654] = {.lex_state = 9, .external_lex_state = 2},
  [3655] = {.lex_state = 9, .external_lex_state = 2},
  [3656] = {.lex_state = 9, .external_lex_state = 2},
  [3657] = {.lex_state = 9, .external_lex_state = 2},
  [3658] = {.lex_state = 9, .external_lex_state = 6},
  [3659] = {.lex_state = 9, .external_lex_state = 5},
  [3660] = {.lex_state = 9, .external_lex_state = 5},
  [3661] = {.lex_state = 9, .external_lex_state = 2},
  [3662] = {.lex_state = 9, .external_lex_state = 2},
  [3663] = {.lex_state = 9, .external_lex_state = 6},
  [3664] = {.lex_state = 9, .external_lex_state = 6},
  [3665] = {.lex_state = 9, .external_lex_state = 6},
  [3666] = {.lex_state = 9, .external_lex_state = 5},
  [3667] = {.lex_state = 9, .external_lex_state = 6},
  [3668] = {.lex_state = 9, .external_lex_state = 5},
  [3669] = {.lex_state = 9, .external_lex_state = 5},
  [3670] = {.lex_state = 9, .external_lex_state = 5},
  [3671] = {.lex_state = 9, .external_lex_state = 5},
  [3672] = {.lex_state = 9, .external_lex_state = 5},
  [3673] = {.lex_state = 9, .external_lex_state = 5},
  [3674] = {.lex_state = 9, .external_lex_state = 5},
  [3675] = {.lex_state = 9, .external_lex_state = 2},
  [3676] = {.lex_state = 9, .external_lex_state = 6},
  [3677] = {.lex_state = 9, .external_lex_state = 2},
  [3678] = {.lex_state = 9, .external_lex_state = 6},
  [3679] = {.lex_state = 9, .external_lex_state = 6},
  [3680] = {.lex_state = 9, .external_lex_state = 6},
  [3681] = {.lex_state = 9, .external_lex_state = 6},
  [3682] = {.lex_state = 9, .external_lex_state = 5},
  [3683] = {.lex_state = 9, .external_lex_state = 6},
  [3684] = {.lex_state = 9, .external_lex_state = 6},
  [3685] = {.lex_state = 9, .external_lex_state = 5},
  [3686] = {.lex_state = 9, .external_lex_state = 6},
  [3687] = {.lex_state = 9, .external_lex_state = 5},
  [3688] = {.lex_state = 9, .external_lex_state = 5},
  [3689] = {.lex_state = 9, .external_lex_state = 2},
  [3690] = {.lex_state = 9, .external_lex_state = 6},
  [3691] = {.lex_state = 9, .external_lex_state = 2},
  [3692] = {.lex_state = 9, .external_lex_state = 2},
  [3693] = {.lex_state = 9, .external_lex_state = 2},
  [3694] = {.lex_state = 9, .external_lex_state = 6},
  [3695] = {.lex_state = 9, .external_lex_state = 2},
  [3696] = {.lex_state = 9, .external_lex_state = 2},
  [3697] = {.lex_state = 9, .external_lex_state = 5},
  [3698] = {.lex_state = 9, .external_lex_state = 6},
  [3699] = {.lex_state = 9, .external_lex_state = 6},
  [3700] = {.lex_state = 9, .external_lex_state = 6},
  [3701] = {.lex_state = 9, .external_lex_state = 2},
  [3702] = {.lex_state = 9, .external_lex_state = 2},
  [3703] = {.lex_state = 9, .external_lex_state = 5},
  [3704] = {.lex_state = 9, .external_lex_state = 5},
  [3705] = {.lex_state = 9, .external_lex_state = 6},
  [3706] = {.lex_state = 9, .external_lex_state = 5},
  [3707] = {.lex_state = 77, .external_lex_state = 2},
  [3708] = {.lex_state = 9, .external_lex_state = 2},
  [3709] = {.lex_state = 9, .external_lex_state = 6},
  [3710] = {.lex_state = 9, .external_lex_state = 2},
  [3711] = {.lex_state = 9, .external_lex_state = 2},
  [3712] = {.lex_state = 77, .external_lex_state = 2},
  [3713] = {.lex_state = 9, .external_lex_state = 2},
  [3714] = {.lex_state = 9, .external_lex_state = 5},
  [3715] = {.lex_state = 9, .external_lex_state = 2},
  [3716] = {.lex_state = 77, .external_lex_state = 5},
  [3717] = {.lex_state = 9, .external_lex_state = 2},
  [3718] = {.lex_state = 77, .external_lex_state = 5},
  [3719] = {.lex_state = 9, .external_lex_state = 2},
  [3720] = {.lex_state = 9, .external_lex_state = 5},
  [3721] = {.lex_state = 9, .external_lex_state = 6},
  [3722] = {.lex_state = 9, .external_lex_state = 6},
  [3723] = {.lex_state = 9, .external_lex_state = 2},
  [3724] = {.lex_state = 9, .external_lex_state = 5},
  [3725] = {.lex_state = 9, .external_lex_state = 5},
  [3726] = {.lex_state = 9, .external_lex_state = 5},
  [3727] = {.lex_state = 9, .external_lex_state = 2},
  [3728] = {.lex_state = 9, .external_lex_state = 5},
  [3729] = {.lex_state = 9, .external_lex_state = 2},
  [3730] = {.lex_state = 9, .external_lex_state = 5},
  [3731] = {.lex_state = 9, .external_lex_state = 2},
  [3732] = {.lex_state = 9, .external_lex_state = 6},
  [3733] = {.lex_state = 9, .external_lex_state = 5},
  [3734] = {.lex_state = 9, .external_lex_state = 2},
  [3735] = {.lex_state = 9, .external_lex_state = 5},
  [3736] = {.lex_state = 9, .external_lex_state = 2},
  [3737] = {.lex_state = 9, .external_lex_state = 5},
  [3738] = {.lex_state = 9, .external_lex_state = 5},
  [3739] = {.lex_state = 9, .external_lex_state = 5},
  [3740] = {.lex_state = 9, .external_lex_state = 5},
  [3741] = {.lex_state = 9, .external_lex_state = 5},
  [3742] = {.lex_state = 9, .external_lex_state = 5},
  [3743] = {.lex_state = 9, .external_lex_state = 6},
  [3744] = {.lex_state = 9, .external_lex_state = 5},
  [3745] = {.lex_state = 9, .external_lex_state = 5},
  [3746] = {.lex_state = 9, .external_lex_state = 5},
  [3747] = {.lex_state = 9, .external_lex_state = 5},
  [3748] = {.lex_state = 9, .external_lex_state = 5},
  [3749] = {.lex_state = 77, .external_lex_state = 2},
  [3750] = {.lex_state = 9, .external_lex_state = 6},
  [3751] = {.lex_state = 9, .external_lex_state = 5},
  [3752] = {.lex_state = 9, .external_lex_state = 2},
  [3753] = {.lex_state = 9, .external_lex_state = 2},
  [3754] = {.lex_state = 9, .external_lex_state = 6},
  [3755] = {.lex_state = 9, .external_lex_state = 6},
  [3756] = {.lex_state = 9, .external_lex_state = 6},
  [3757] = {.lex_state = 9, .external_lex_state = 6},
  [3758] = {.lex_state = 9, .external_lex_state = 6},
  [3759] = {.lex_state = 9, .external_lex_state = 6},
  [3760] = {.lex_state = 9, .external_lex_state = 2},
  [3761] = {.lex_state = 9, .external_lex_state = 6},
  [3762] = {.lex_state = 9, .external_lex_state = 6},
  [3763] = {.lex_state = 9, .external_lex_state = 6},
  [3764] = {.lex_state = 9, .external_lex_state = 6},
  [3765] = {.lex_state = 9, .external_lex_state = 5},
  [3766] = {.lex_state = 9, .external_lex_state = 6},
  [3767] = {.lex_state = 11, .external_lex_state = 2},
  [3768] = {.lex_state = 9, .external_lex_state = 6},
  [3769] = {.lex_state = 9, .external_lex_state = 6},
  [3770] = {.lex_state = 9, .external_lex_state = 6},
  [3771] = {.lex_state = 9, .external_lex_state = 6},
  [3772] = {.lex_state = 9, .external_lex_state = 6},
  [3773] = {.lex_state = 9, .external_lex_state = 6},
  [3774] = {.lex_state = 9, .external_lex_state = 6},
  [3775] = {.lex_state = 9, .external_lex_state = 6},
  [3776] = {.lex_state = 9, .external_lex_state = 6},
  [3777] = {.lex_state = 9, .external_lex_state = 6},
  [3778] = {.lex_state = 9, .external_lex_state = 6},
  [3779] = {.lex_state = 9, .external_lex_state = 6},
  [3780] = {.lex_state = 9, .external_lex_state = 6},
  [3781] = {.lex_state = 9, .external_lex_state = 2},
  [3782] = {.lex_state = 9, .external_lex_state = 6},
  [3783] = {.lex_state = 9, .external_lex_state = 2},
  [3784] = {.lex_state = 9, .external_lex_state = 5},
  [3785] = {.lex_state = 10, .external_lex_state = 2},
  [3786] = {.lex_state = 10, .external_lex_state = 2},
  [3787] = {.lex_state = 9, .external_lex_state = 5},
  [3788] = {.lex_state = 9, .external_lex_state = 6},
  [3789] = {.lex_state = 9, .external_lex_state = 5},
  [3790] = {.lex_state = 9, .external_lex_state = 5},
  [3791] = {.lex_state = 9, .external_lex_state = 5},
  [3792] = {.lex_state = 9, .external_lex_state = 5},
  [3793] = {.lex_state = 10, .external_lex_state = 2},
  [3794] = {.lex_state = 18, .external_lex_state = 2},
  [3795] = {.lex_state = 9, .external_lex_state = 2},
  [3796] = {.lex_state = 77, .external_lex_state = 2},
  [3797] = {.lex_state = 11, .external_lex_state = 2},
  [3798] = {.lex_state = 16, .external_lex_state = 7},
  [3799] = {.lex_state = 16, .external_lex_state = 7},
  [3800] = {.lex_state = 16, .external_lex_state = 7},
  [3801] = {.lex_state = 11, .external_lex_state = 2},
  [3802] = {.lex_state = 4, .external_lex_state = 5},
  [3803] = {.lex_state = 16, .external_lex_state = 7},
  [3804] = {.lex_state = 9, .external_lex_state = 2},
  [3805] = {.lex_state = 9, .external_lex_state = 2},
  [3806] = {.lex_state = 9, .external_lex_state = 2},
  [3807] = {.lex_state = 9, .external_lex_state = 5},
  [3808] = {.lex_state = 77, .external_lex_state = 2},
  [3809] = {.lex_state = 18, .external_lex_state = 2},
  [3810] = {.lex_state = 18, .external_lex_state = 2},
  [3811] = {.lex_state = 11, .external_lex_state = 2},
  [3812] = {.lex_state = 77, .external_lex_state = 2},
  [3813] = {.lex_state = 9, .external_lex_state = 2},
  [3814] = {.lex_state = 18, .external_lex_state = 2},
  [3815] = {.lex_state = 9, .external_lex_state = 6},
  [3816] = {.lex_state = 77, .external_lex_state = 2},
  [3817] = {.lex_state = 9, .external_lex_state = 2},
  [3818] = {.lex_state = 16, .external_lex_state = 7},
  [3819] = {.lex_state = 9, .external_lex_state = 2},
  [3820] = {.lex_state = 16, .external_lex_state = 7},
  [3821] = {.lex_state = 9, .external_lex_state = 2},
  [3822] = {.lex_state = 18, .external_lex_state = 2},
  [3823] = {.lex_state = 18, .external_lex_state = 2},
  [3824] = {.lex_state = 9, .external_lex_state = 5},
  [3825] = {.lex_state = 9, .external_lex_state = 5},
  [3826] = {.lex_state = 9, .external_lex_state = 5},
  [3827] = {.lex_state = 18, .external_lex_state = 2},
  [3828] = {.lex_state = 18, .external_lex_state = 2},
  [3829] = {.lex_state = 16, .external_lex_state = 7},
  [3830] = {.lex_state = 18, .external_lex_state = 2},
  [3831] = {.lex_state = 9, .external_lex_state = 2},
  [3832] = {.lex_state = 16, .external_lex_state = 7},
  [3833] = {.lex_state = 11, .external_lex_state = 2},
  [3834] = {.lex_state = 77, .external_lex_state = 2},
  [3835] = {.lex_state = 9, .external_lex_state = 2},
  [3836] = {.lex_state = 77, .external_lex_state = 2},
  [3837] = {.lex_state = 77, .external_lex_state = 2},
  [3838] = {.lex_state = 4, .external_lex_state = 5},
  [3839] = {.lex_state = 77, .external_lex_state = 5},
  [3840] = {.lex_state = 77, .external_lex_state = 5},
  [3841] = {.lex_state = 77, .external_lex_state = 5},
  [3842] = {.lex_state = 77, .external_lex_state = 5},
  [3843] = {.lex_state = 77, .external_lex_state = 5},
  [3844] = {.lex_state = 9, .external_lex_state = 2},
  [3845] = {.lex_state = 9, .external_lex_state = 2},
  [3846] = {.lex_state = 9, .external_lex_state = 5},
  [3847] = {.lex_state = 9, .external_lex_state = 2},
  [3848] = {.lex_state = 4, .external_lex_state = 2},
  [3849] = {.lex_state = 9, .external_lex_state = 2},
  [3850] = {.lex_state = 10, .external_lex_state = 2},
  [3851] = {.lex_state = 77, .external_lex_state = 5},
  [3852] = {.lex_state = 77, .external_lex_state = 5},
  [3853] = {.lex_state = 77, .external_lex_state = 5},
  [3854] = {.lex_state = 77, .external_lex_state = 5},
  [3855] = {.lex_state = 9, .external_lex_state = 2},
  [3856] = {.lex_state = 9, .external_lex_state = 5},
  [3857] = {.lex_state = 9, .external_lex_state = 5},
  [3858] = {.lex_state = 9, .external_lex_state = 2},
  [3859] = {.lex_state = 9, .external_lex_state = 2},
  [3860] = {.lex_state = 9, .external_lex_state = 2},
  [3861] = {.lex_state = 77, .external_lex_state = 5},
  [3862] = {.lex_state = 77, .external_lex_state = 5},
  [3863] = {.lex_state = 9, .external_lex_state = 2},
  [3864] = {.lex_state = 9, .external_lex_state = 2},
  [3865] = {.lex_state = 77, .external_lex_state = 5},
  [3866] = {.lex_state = 77, .external_lex_state = 2},
  [3867] = {.lex_state = 77, .external_lex_state = 2},
  [3868] = {.lex_state = 77, .external_lex_state = 5},
  [3869] = {.lex_state = 14, .external_lex_state = 2},
  [3870] = {.lex_state = 77, .external_lex_state = 5},
  [3871] = {.lex_state = 14, .external_lex_state = 2},
  [3872] = {.lex_state = 9, .external_lex_state = 2},
  [3873] = {.lex_state = 77, .external_lex_state = 5},
  [3874] = {.lex_state = 14, .external_lex_state = 2},
  [3875] = {.lex_state = 77, .external_lex_state = 5},
  [3876] = {.lex_state = 77, .external_lex_state = 5},
  [3877] = {.lex_state = 77, .external_lex_state = 5},
  [3878] = {.lex_state = 77, .external_lex_state = 5},
  [3879] = {.lex_state = 77, .external_lex_state = 5},
  [3880] = {.lex_state = 4, .external_lex_state = 2},
  [3881] = {.lex_state = 10, .external_lex_state = 2},
  [3882] = {.lex_state = 9, .external_lex_state = 2},
  [3883] = {.lex_state = 9, .external_lex_state = 2},
  [3884] = {.lex_state = 77, .external_lex_state = 5},
  [3885] = {.lex_state = 10, .external_lex_state = 2},
  [3886] = {.lex_state = 77, .external_lex_state = 5},
  [3887] = {.lex_state = 77, .external_lex_state = 5},
  [3888] = {.lex_state = 77, .external_lex_state = 5},
  [3889] = {.lex_state = 77, .external_lex_state = 5},
  [3890] = {.lex_state = 77, .external_lex_state = 5},
  [3891] = {.lex_state = 9, .external_lex_state = 5},
  [3892] = {.lex_state = 9, .external_lex_state = 5},
  [3893] = {.lex_state = 9, .external_lex_state = 5},
  [3894] = {.lex_state = 9, .external_lex_state = 5},
  [3895] = {.lex_state = 14, .external_lex_state = 2},
  [3896] = {.lex_state = 9, .external_lex_state = 2},
  [3897] = {.lex_state = 9, .external_lex_state = 5},
  [3898] = {.lex_state = 9, .external_lex_state = 2},
  [3899] = {.lex_state = 77, .external_lex_state = 5},
  [3900] = {.lex_state = 77, .external_lex_state = 5},
  [3901] = {.lex_state = 14, .external_lex_state = 2},
  [3902] = {.lex_state = 9, .external_lex_state = 2},
  [3903] = {.lex_state = 14, .external_lex_state = 2},
  [3904] = {.lex_state = 77, .external_lex_state = 5},
  [3905] = {.lex_state = 77, .external_lex_state = 5},
  [3906] = {.lex_state = 9, .external_lex_state = 2},
  [3907] = {.lex_state = 77, .external_lex_state = 5},
  [3908] = {.lex_state = 77, .external_lex_state = 5},
  [3909] = {.lex_state = 9, .external_lex_state = 2},
  [3910] = {.lex_state = 77, .external_lex_state = 5},
  [3911] = {.lex_state = 14, .external_lex_state = 2},
  [3912] = {.lex_state = 77, .external_lex_state = 5},
  [3913] = {.lex_state = 9, .external_lex_state = 2},
  [3914] = {.lex_state = 77, .external_lex_state = 5},
  [3915] = {.lex_state = 14, .external_lex_state = 2},
  [3916] = {.lex_state = 9, .external_lex_state = 5},
  [3917] = {.lex_state = 9, .external_lex_state = 5},
  [3918] = {.lex_state = 77, .external_lex_state = 5},
  [3919] = {.lex_state = 77, .external_lex_state = 5},
  [3920] = {.lex_state = 9, .external_lex_state = 5},
  [3921] = {.lex_state = 9, .external_lex_state = 2},
  [3922] = {.lex_state = 9, .external_lex_state = 2},
  [3923] = {.lex_state = 9, .external_lex_state = 2},
  [3924] = {.lex_state = 9, .external_lex_state = 5},
  [3925] = {.lex_state = 77, .external_lex_state = 5},
  [3926] = {.lex_state = 77, .external_lex_state = 5},
  [3927] = {.lex_state = 9, .external_lex_state = 5},
  [3928] = {.lex_state = 77, .external_lex_state = 5},
  [3929] = {.lex_state = 9, .external_lex_state = 5},
  [3930] = {.lex_state = 9, .external_lex_state = 5},
  [3931] = {.lex_state = 9, .external_lex_state = 2},
  [3932] = {.lex_state = 9, .external_lex_state = 5},
  [3933] = {.lex_state = 9, .external_lex_state = 2},
  [3934] = {.lex_state = 77, .external_lex_state = 5},
  [3935] = {.lex_state = 9, .external_lex_state = 5},
  [3936] = {.lex_state = 77, .external_lex_state = 5},
  [3937] = {.lex_state = 77, .external_lex_state = 5},
  [3938] = {.lex_state = 14, .external_lex_state = 2},
  [3939] = {.lex_state = 9, .external_lex_state = 2},
  [3940] = {.lex_state = 9, .external_lex_state = 2},
  [3941] = {.lex_state = 18, .external_lex_state = 2},
  [3942] = {.lex_state = 77, .external_lex_state = 5},
  [3943] = {.lex_state = 77, .external_lex_state = 5},
  [3944] = {.lex_state = 14, .external_lex_state = 2},
  [3945] = {.lex_state = 77, .external_lex_state = 5},
  [3946] = {.lex_state = 9, .external_lex_state = 2},
  [3947] = {.lex_state = 9, .external_lex_state = 2},
  [3948] = {.lex_state = 9, .external_lex_state = 2},
  [3949] = {.lex_state = 77, .external_lex_state = 5},
  [3950] = {.lex_state = 9, .external_lex_state = 2},
  [3951] = {.lex_state = 9, .external_lex_state = 5},
  [3952] = {.lex_state = 77, .external_lex_state = 5},
  [3953] = {.lex_state = 77, .external_lex_state = 5},
  [3954] = {.lex_state = 9, .external_lex_state = 5},
  [3955] = {.lex_state = 77, .external_lex_state = 5},
  [3956] = {.lex_state = 77, .external_lex_state = 5},
  [3957] = {.lex_state = 9, .external_lex_state = 2},
  [3958] = {.lex_state = 9, .external_lex_state = 2},
  [3959] = {.lex_state = 77, .external_lex_state = 5},
  [3960] = {.lex_state = 77, .external_lex_state = 5},
  [3961] = {.lex_state = 77, .external_lex_state = 5},
  [3962] = {.lex_state = 77, .external_lex_state = 5},
  [3963] = {.lex_state = 9, .external_lex_state = 2},
  [3964] = {.lex_state = 9, .external_lex_state = 2},
  [3965] = {.lex_state = 77, .external_lex_state = 5},
  [3966] = {.lex_state = 77, .external_lex_state = 5},
  [3967] = {.lex_state = 9, .external_lex_state = 5},
  [3968] = {.lex_state = 9, .external_lex_state = 2},
  [3969] = {.lex_state = 9, .external_lex_state = 2},
  [3970] = {.lex_state = 9, .external_lex_state = 2},
  [3971] = {.lex_state = 9, .external_lex_state = 2},
  [3972] = {.lex_state = 77, .external_lex_state = 5},
  [3973] = {.lex_state = 77, .external_lex_state = 5},
  [3974] = {.lex_state = 77, .external_lex_state = 5},
  [3975] = {.lex_state = 9, .external_lex_state = 2},
  [3976] = {.lex_state = 9, .external_lex_state = 5},
  [3977] = {.lex_state = 9, .external_lex_state = 2},
  [3978] = {.lex_state = 77, .external_lex_state = 5},
  [3979] = {.lex_state = 9, .external_lex_state = 2},
  [3980] = {.lex_state = 9, .external_lex_state = 2},
  [3981] = {.lex_state = 77, .external_lex_state = 5},
  [3982] = {.lex_state = 77, .external_lex_state = 5},
  [3983] = {.lex_state = 9, .external_lex_state = 5},
  [3984] = {.lex_state = 77, .external_lex_state = 5},
  [3985] = {.lex_state = 77, .external_lex_state = 5},
  [3986] = {.lex_state = 77, .external_lex_state = 5},
  [3987] = {.lex_state = 77, .external_lex_state = 5},
  [3988] = {.lex_state = 14, .external_lex_state = 2},
  [3989] = {.lex_state = 77, .external_lex_state = 5},
  [3990] = {.lex_state = 77, .external_lex_state = 5},
  [3991] = {.lex_state = 9, .external_lex_state = 2},
  [3992] = {.lex_state = 77, .external_lex_state = 5},
  [3993] = {.lex_state = 77, .external_lex_state = 5},
  [3994] = {.lex_state = 77, .external_lex_state = 5},
  [3995] = {.lex_state = 77, .external_lex_state = 5},
  [3996] = {.lex_state = 9, .external_lex_state = 2},
  [3997] = {.lex_state = 9, .external_lex_state = 2},
  [3998] = {.lex_state = 77, .external_lex_state = 5},
  [3999] = {.lex_state = 77, .external_lex_state = 5},
  [4000] = {.lex_state = 4, .external_lex_state = 5},
  [4001] = {.lex_state = 9, .external_lex_state = 5},
  [4002] = {.lex_state = 77, .external_lex_state = 5},
  [4003] = {.lex_state = 77, .external_lex_state = 5},
  [4004] = {.lex_state = 4, .external_lex_state = 5},
  [4005] = {.lex_state = 77, .external_lex_state = 5},
  [4006] = {.lex_state = 77, .external_lex_state = 5},
  [4007] = {.lex_state = 9, .external_lex_state = 2},
  [4008] = {.lex_state = 77, .external_lex_state = 5},
  [4009] = {.lex_state = 14, .external_lex_state = 2},
  [4010] = {.lex_state = 9, .external_lex_state = 2},
  [4011] = {.lex_state = 77, .external_lex_state = 5},
  [4012] = {.lex_state = 9, .external_lex_state = 5},
  [4013] = {.lex_state = 9, .external_lex_state = 5},
  [4014] = {.lex_state = 9, .external_lex_state = 2},
  [4015] = {.lex_state = 9, .external_lex_state = 2},
  [4016] = {.lex_state = 9, .external_lex_state = 2},
  [4017] = {.lex_state = 77, .external_lex_state = 5},
  [4018] = {.lex_state = 9, .external_lex_state = 2},
  [4019] = {.lex_state = 9, .external_lex_state = 2},
  [4020] = {.lex_state = 77, .external_lex_state = 5},
  [4021] = {.lex_state = 9, .external_lex_state = 2},
  [4022] = {.lex_state = 77, .external_lex_state = 5},
  [4023] = {.lex_state = 77, .external_lex_state = 5},
  [4024] = {.lex_state = 9, .external_lex_state = 2},
  [4025] = {.lex_state = 9, .external_lex_state = 2},
  [4026] = {.lex_state = 9, .external_lex_state = 2},
  [4027] = {.lex_state = 77, .external_lex_state = 5},
  [4028] = {.lex_state = 9, .external_lex_state = 5},
  [4029] = {.lex_state = 77, .external_lex_state = 5},
  [4030] = {.lex_state = 77, .external_lex_state = 5},
  [4031] = {.lex_state = 9, .external_lex_state = 2},
  [4032] = {.lex_state = 9, .external_lex_state = 2},
  [4033] = {.lex_state = 9, .external_lex_state = 2},
  [4034] = {.lex_state = 77, .external_lex_state = 2},
  [4035] = {.lex_state = 77, .external_lex_state = 5},
  [4036] = {.lex_state = 77, .external_lex_state = 5},
  [4037] = {.lex_state = 77, .external_lex_state = 5},
  [4038] = {.lex_state = 9, .external_lex_state = 2},
  [4039] = {.lex_state = 77, .external_lex_state = 5},
  [4040] = {.lex_state = 9, .external_lex_state = 2},
  [4041] = {.lex_state = 77, .external_lex_state = 5},
  [4042] = {.lex_state = 77, .external_lex_state = 2},
  [4043] = {.lex_state = 77, .external_lex_state = 5},
  [4044] = {.lex_state = 77, .external_lex_state = 5},
  [4045] = {.lex_state = 9, .external_lex_state = 2},
  [4046] = {.lex_state = 77, .external_lex_state = 5},
  [4047] = {.lex_state = 14, .external_lex_state = 2},
  [4048] = {.lex_state = 77, .external_lex_state = 5},
  [4049] = {.lex_state = 77, .external_lex_state = 5},
  [4050] = {.lex_state = 9, .external_lex_state = 2},
  [4051] = {.lex_state = 4, .external_lex_state = 2},
  [4052] = {.lex_state = 9, .external_lex_state = 2},
  [4053] = {.lex_state = 77, .external_lex_state = 2},
  [4054] = {.lex_state = 9, .external_lex_state = 2},
  [4055] = {.lex_state = 9, .external_lex_state = 2},
  [4056] = {.lex_state = 9, .external_lex_state = 2},
  [4057] = {.lex_state = 9, .external_lex_state = 2},
  [4058] = {.lex_state = 77, .external_lex_state = 5},
  [4059] = {.lex_state = 14, .external_lex_state = 2},
  [4060] = {.lex_state = 14, .external_lex_state = 2},
  [4061] = {.lex_state = 9, .external_lex_state = 2},
  [4062] = {.lex_state = 4, .external_lex_state = 2},
  [4063] = {.lex_state = 9, .external_lex_state = 2},
  [4064] = {.lex_state = 77, .external_lex_state = 5},
  [4065] = {.lex_state = 9, .external_lex_state = 2},
  [4066] = {.lex_state = 77, .external_lex_state = 5},
  [4067] = {.lex_state = 77, .external_lex_state = 5},
  [4068] = {.lex_state = 9, .external_lex_state = 2},
  [4069] = {.lex_state = 77, .external_lex_state = 5},
  [4070] = {.lex_state = 77, .external_lex_state = 5},
  [4071] = {.lex_state = 77, .external_lex_state = 5},
  [4072] = {.lex_state = 9, .external_lex_state = 2},
  [4073] = {.lex_state = 77, .external_lex_state = 5},
  [4074] = {.lex_state = 77, .external_lex_state = 5},
  [4075] = {.lex_state = 77, .external_lex_state = 5},
  [4076] = {.lex_state = 77, .external_lex_state = 5},
  [4077] = {.lex_state = 77, .external_lex_state = 5},
  [4078] = {.lex_state = 77, .external_lex_state = 5},
  [4079] = {.lex_state = 77, .external_lex_state = 5},
  [4080] = {.lex_state = 77, .external_lex_state = 5},
  [4081] = {.lex_state = 77, .external_lex_state = 5},
  [4082] = {.lex_state = 14, .external_lex_state = 2},
  [4083] = {.lex_state = 77, .external_lex_state = 5},
  [4084] = {.lex_state = 77, .external_lex_state = 5},
  [4085] = {.lex_state = 9, .external_lex_state = 2},
  [4086] = {.lex_state = 9, .external_lex_state = 2},
  [4087] = {.lex_state = 9, .external_lex_state = 2},
  [4088] = {.lex_state = 77, .external_lex_state = 5},
  [4089] = {.lex_state = 77, .external_lex_state = 5},
  [4090] = {.lex_state = 77, .external_lex_state = 5},
  [4091] = {.lex_state = 77, .external_lex_state = 5},
  [4092] = {.lex_state = 9, .external_lex_state = 2},
  [4093] = {.lex_state = 9, .external_lex_state = 2},
  [4094] = {.lex_state = 77, .external_lex_state = 5},
  [4095] = {.lex_state = 77, .external_lex_state = 5},
  [4096] = {.lex_state = 77, .external_lex_state = 5},
  [4097] = {.lex_state = 9, .external_lex_state = 2},
  [4098] = {.lex_state = 9, .external_lex_state = 5},
  [4099] = {.lex_state = 77, .external_lex_state = 5},
  [4100] = {.lex_state = 9, .external_lex_state = 2},
  [4101] = {.lex_state = 77, .external_lex_state = 2},
  [4102] = {.lex_state = 77, .external_lex_state = 5},
  [4103] = {.lex_state = 9, .external_lex_state = 2},
  [4104] = {.lex_state = 9, .external_lex_state = 6},
  [4105] = {.lex_state = 77, .external_lex_state = 5},
  [4106] = {.lex_state = 9, .external_lex_state = 2},
  [4107] = {.lex_state = 9, .external_lex_state = 2},
  [4108] = {.lex_state = 9, .external_lex_state = 6},
  [4109] = {.lex_state = 77, .external_lex_state = 2},
  [4110] = {.lex_state = 77, .external_lex_state = 5},
  [4111] = {.lex_state = 9, .external_lex_state = 2},
  [4112] = {.lex_state = 9, .external_lex_state = 2},
  [4113] = {.lex_state = 9, .external_lex_state = 2},
  [4114] = {.lex_state = 9, .external_lex_state = 2},
  [4115] = {.lex_state = 9, .external_lex_state = 6},
  [4116] = {.lex_state = 9, .external_lex_state = 2},
  [4117] = {.lex_state = 9, .external_lex_state = 2},
  [4118] = {.lex_state = 77, .external_lex_state = 5},
  [4119] = {.lex_state = 9, .external_lex_state = 2},
  [4120] = {.lex_state = 9, .external_lex_state = 2},
  [4121] = {.lex_state = 9, .external_lex_state = 2},
  [4122] = {.lex_state = 9, .external_lex_state = 2},
  [4123] = {.lex_state = 9, .external_lex_state = 2},
  [4124] = {.lex_state = 77, .external_lex_state = 5},
  [4125] = {.lex_state = 9, .external_lex_state = 2},
  [4126] = {.lex_state = 9, .external_lex_state = 6},
  [4127] = {.lex_state = 9, .external_lex_state = 2},
  [4128] = {.lex_state = 9, .external_lex_state = 6},
  [4129] = {.lex_state = 9, .external_lex_state = 2},
  [4130] = {.lex_state = 9, .external_lex_state = 2},
  [4131] = {.lex_state = 77, .external_lex_state = 5},
  [4132] = {.lex_state = 10, .external_lex_state = 2},
  [4133] = {.lex_state = 77, .external_lex_state = 5},
  [4134] = {.lex_state = 9, .external_lex_state = 2},
  [4135] = {.lex_state = 9, .external_lex_state = 2},
  [4136] = {.lex_state = 77, .external_lex_state = 5},
  [4137] = {.lex_state = 9, .external_lex_state = 6},
  [4138] = {.lex_state = 9, .external_lex_state = 6},
  [4139] = {.lex_state = 9, .external_lex_state = 2},
  [4140] = {.lex_state = 9, .external_lex_state = 2},
  [4141] = {.lex_state = 9, .external_lex_state = 2},
  [4142] = {.lex_state = 77, .external_lex_state = 5},
  [4143] = {.lex_state = 9, .external_lex_state = 2},
  [4144] = {.lex_state = 9, .external_lex_state = 6},
  [4145] = {.lex_state = 77, .external_lex_state = 5},
  [4146] = {.lex_state = 9, .external_lex_state = 2},
  [4147] = {.lex_state = 9, .external_lex_state = 2},
  [4148] = {.lex_state = 77, .external_lex_state = 2},
  [4149] = {.lex_state = 9, .external_lex_state = 2},
  [4150] = {.lex_state = 9, .external_lex_state = 6},
  [4151] = {.lex_state = 9, .external_lex_state = 6},
  [4152] = {.lex_state = 9, .external_lex_state = 2},
  [4153] = {.lex_state = 77, .external_lex_state = 5},
  [4154] = {.lex_state = 9, .external_lex_state = 2},
  [4155] = {.lex_state = 16, .external_lex_state = 7},
  [4156] = {.lex_state = 77, .external_lex_state = 2},
  [4157] = {.lex_state = 9, .external_lex_state = 2},
  [4158] = {.lex_state = 9, .external_lex_state = 2},
  [4159] = {.lex_state = 9, .external_lex_state = 2},
  [4160] = {.lex_state = 9, .external_lex_state = 2},
  [4161] = {.lex_state = 77, .external_lex_state = 5},
  [4162] = {.lex_state = 9, .external_lex_state = 6},
  [4163] = {.lex_state = 9, .external_lex_state = 2},
  [4164] = {.lex_state = 9, .external_lex_state = 2},
  [4165] = {.lex_state = 9, .external_lex_state = 2},
  [4166] = {.lex_state = 77, .external_lex_state = 2},
  [4167] = {.lex_state = 77, .external_lex_state = 2},
  [4168] = {.lex_state = 11, .external_lex_state = 2},
  [4169] = {.lex_state = 77, .external_lex_state = 5},
  [4170] = {.lex_state = 9, .external_lex_state = 2},
  [4171] = {.lex_state = 9, .external_lex_state = 6},
  [4172] = {.lex_state = 4, .external_lex_state = 2},
  [4173] = {.lex_state = 9, .external_lex_state = 2},
  [4174] = {.lex_state = 9, .external_lex_state = 6},
  [4175] = {.lex_state = 77, .external_lex_state = 5},
  [4176] = {.lex_state = 9, .external_lex_state = 2},
  [4177] = {.lex_state = 16, .external_lex_state = 7},
  [4178] = {.lex_state = 9, .external_lex_state = 2},
  [4179] = {.lex_state = 9, .external_lex_state = 2},
  [4180] = {.lex_state = 77, .external_lex_state = 2},
  [4181] = {.lex_state = 77, .external_lex_state = 2},
  [4182] = {.lex_state = 9, .external_lex_state = 2},
  [4183] = {.lex_state = 9, .external_lex_state = 2},
  [4184] = {.lex_state = 9, .external_lex_state = 2},
  [4185] = {.lex_state = 9, .external_lex_state = 2},
  [4186] = {.lex_state = 77, .external_lex_state = 2},
  [4187] = {.lex_state = 77, .external_lex_state = 2},
  [4188] = {.lex_state = 9, .external_lex_state = 5},
  [4189] = {.lex_state = 77, .external_lex_state = 5},
  [4190] = {.lex_state = 9, .external_lex_state = 2},
  [4191] = {.lex_state = 4, .external_lex_state = 5},
  [4192] = {.lex_state = 77, .external_lex_state = 2},
  [4193] = {.lex_state = 9, .external_lex_state = 6},
  [4194] = {.lex_state = 77, .external_lex_state = 5},
  [4195] = {.lex_state = 9, .external_lex_state = 2},
  [4196] = {.lex_state = 77, .external_lex_state = 5},
  [4197] = {.lex_state = 9, .external_lex_state = 6},
  [4198] = {.lex_state = 9, .external_lex_state = 2},
  [4199] = {.lex_state = 77, .external_lex_state = 5},
  [4200] = {.lex_state = 77, .external_lex_state = 2},
  [4201] = {.lex_state = 9, .external_lex_state = 2},
  [4202] = {.lex_state = 9, .external_lex_state = 2},
  [4203] = {.lex_state = 9, .external_lex_state = 2},
  [4204] = {.lex_state = 9, .external_lex_state = 5},
  [4205] = {.lex_state = 77, .external_lex_state = 5},
  [4206] = {.lex_state = 9, .external_lex_state = 2},
  [4207] = {.lex_state = 9, .external_lex_state = 6},
  [4208] = {.lex_state = 9, .external_lex_state = 6},
  [4209] = {.lex_state = 9, .external_lex_state = 2},
  [4210] = {.lex_state = 9, .external_lex_state = 2},
  [4211] = {.lex_state = 77, .external_lex_state = 2},
  [4212] = {.lex_state = 16, .external_lex_state = 7},
  [4213] = {.lex_state = 9, .external_lex_state = 2},
  [4214] = {.lex_state = 9, .external_lex_state = 2},
  [4215] = {.lex_state = 9, .external_lex_state = 2},
  [4216] = {.lex_state = 9, .external_lex_state = 5},
  [4217] = {.lex_state = 9, .external_lex_state = 6},
  [4218] = {.lex_state = 9, .external_lex_state = 2},
  [4219] = {.lex_state = 9, .external_lex_state = 2},
  [4220] = {.lex_state = 9, .external_lex_state = 6},
  [4221] = {.lex_state = 77, .external_lex_state = 5},
  [4222] = {.lex_state = 77, .external_lex_state = 2},
  [4223] = {.lex_state = 77, .external_lex_state = 5},
  [4224] = {.lex_state = 9, .external_lex_state = 6},
  [4225] = {.lex_state = 9, .external_lex_state = 2},
  [4226] = {.lex_state = 16, .external_lex_state = 7},
  [4227] = {.lex_state = 9, .external_lex_state = 6},
  [4228] = {.lex_state = 9, .external_lex_state = 2},
  [4229] = {.lex_state = 9, .external_lex_state = 2},
  [4230] = {.lex_state = 9, .external_lex_state = 2},
  [4231] = {.lex_state = 4, .external_lex_state = 2},
  [4232] = {.lex_state = 11, .external_lex_state = 2},
  [4233] = {.lex_state = 9, .external_lex_state = 2},
  [4234] = {.lex_state = 77, .external_lex_state = 5},
  [4235] = {.lex_state = 9, .external_lex_state = 6},
  [4236] = {.lex_state = 77, .external_lex_state = 2},
  [4237] = {.lex_state = 77, .external_lex_state = 2},
  [4238] = {.lex_state = 9, .external_lex_state = 2},
  [4239] = {.lex_state = 16, .external_lex_state = 7},
  [4240] = {.lex_state = 77, .external_lex_state = 5},
  [4241] = {.lex_state = 9, .external_lex_state = 2},
  [4242] = {.lex_state = 9, .external_lex_state = 2},
  [4243] = {.lex_state = 9, .external_lex_state = 6},
  [4244] = {.lex_state = 77, .external_lex_state = 5},
  [4245] = {.lex_state = 77, .external_lex_state = 2},
  [4246] = {.lex_state = 77, .external_lex_state = 5},
  [4247] = {.lex_state = 9, .external_lex_state = 2},
  [4248] = {.lex_state = 9, .external_lex_state = 6},
  [4249] = {.lex_state = 9, .external_lex_state = 5},
  [4250] = {.lex_state = 77, .external_lex_state = 5},
  [4251] = {.lex_state = 77, .external_lex_state = 5},
  [4252] = {.lex_state = 9, .external_lex_state = 2},
  [4253] = {.lex_state = 77, .external_lex_state = 2},
  [4254] = {.lex_state = 77, .external_lex_state = 5},
  [4255] = {.lex_state = 9, .external_lex_state = 2},
  [4256] = {.lex_state = 9, .external_lex_state = 2},
  [4257] = {.lex_state = 9, .external_lex_state = 2},
  [4258] = {.lex_state = 4, .external_lex_state = 2},
  [4259] = {.lex_state = 9, .external_lex_state = 2},
  [4260] = {.lex_state = 9, .external_lex_state = 2},
  [4261] = {.lex_state = 9, .external_lex_state = 2},
  [4262] = {.lex_state = 4, .external_lex_state = 5},
  [4263] = {.lex_state = 9, .external_lex_state = 2},
  [4264] = {.lex_state = 9, .external_lex_state = 6},
  [4265] = {.lex_state = 9, .external_lex_state = 2},
  [4266] = {.lex_state = 18, .external_lex_state = 2},
  [4267] = {.lex_state = 9, .external_lex_state = 6},
  [4268] = {.lex_state = 77, .external_lex_state = 5},
  [4269] = {.lex_state = 77, .external_lex_state = 5},
  [4270] = {.lex_state = 77, .external_lex_state = 5},
  [4271] = {.lex_state = 77, .external_lex_state = 5},
  [4272] = {.lex_state = 77, .external_lex_state = 5},
  [4273] = {.lex_state = 77, .external_lex_state = 5},
  [4274] = {.lex_state = 77, .external_lex_state = 5},
  [4275] = {.lex_state = 77, .external_lex_state = 5},
  [4276] = {.lex_state = 77, .external_lex_state = 5},
  [4277] = {.lex_state = 77, .external_lex_state = 5},
  [4278] = {.lex_state = 77, .external_lex_state = 5},
  [4279] = {.lex_state = 77, .external_lex_state = 5},
  [4280] = {.lex_state = 9, .external_lex_state = 2},
  [4281] = {.lex_state = 77, .external_lex_state = 5},
  [4282] = {.lex_state = 77, .external_lex_state = 5},
  [4283] = {.lex_state = 77, .external_lex_state = 5},
  [4284] = {.lex_state = 77, .external_lex_state = 5},
  [4285] = {.lex_state = 77, .external_lex_state = 5},
  [4286] = {.lex_state = 77, .external_lex_state = 5},
  [4287] = {.lex_state = 77, .external_lex_state = 5},
  [4288] = {.lex_state = 9, .external_lex_state = 2},
  [4289] = {.lex_state = 77, .external_lex_state = 5},
  [4290] = {.lex_state = 77, .external_lex_state = 5},
  [4291] = {.lex_state = 77, .external_lex_state = 5},
  [4292] = {.lex_state = 77, .external_lex_state = 5},
  [4293] = {.lex_state = 77, .external_lex_state = 5},
  [4294] = {.lex_state = 77, .external_lex_state = 5},
  [4295] = {.lex_state = 77, .external_lex_state = 5},
  [4296] = {.lex_state = 77, .external_lex_state = 5},
  [4297] = {.lex_state = 77, .external_lex_state = 5},
  [4298] = {.lex_state = 77, .external_lex_state = 5},
  [4299] = {.lex_state = 77, .external_lex_state = 5},
  [4300] = {.lex_state = 77, .external_lex_state = 5},
  [4301] = {.lex_state = 77, .external_lex_state = 5},
  [4302] = {.lex_state = 77, .external_lex_state = 5},
  [4303] = {.lex_state = 9, .external_lex_state = 2},
  [4304] = {.lex_state = 77, .external_lex_state = 5},
  [4305] = {.lex_state = 77, .external_lex_state = 5},
  [4306] = {.lex_state = 77, .external_lex_state = 5},
  [4307] = {.lex_state = 77, .external_lex_state = 2},
  [4308] = {.lex_state = 77, .external_lex_state = 5},
  [4309] = {.lex_state = 77, .external_lex_state = 2},
  [4310] = {.lex_state = 77, .external_lex_state = 5},
  [4311] = {.lex_state = 77, .external_lex_state = 5},
  [4312] = {.lex_state = 77, .external_lex_state = 5},
  [4313] = {.lex_state = 77, .external_lex_state = 5},
  [4314] = {.lex_state = 77, .external_lex_state = 5},
  [4315] = {.lex_state = 77, .external_lex_state = 5},
  [4316] = {.lex_state = 77, .external_lex_state = 5},
  [4317] = {.lex_state = 77, .external_lex_state = 5},
  [4318] = {.lex_state = 9, .external_lex_state = 2},
  [4319] = {.lex_state = 77, .external_lex_state = 5},
  [4320] = {.lex_state = 9, .external_lex_state = 2},
  [4321] = {.lex_state = 9, .external_lex_state = 6},
  [4322] = {.lex_state = 77, .external_lex_state = 5},
  [4323] = {.lex_state = 77, .external_lex_state = 5},
  [4324] = {.lex_state = 16, .external_lex_state = 8},
  [4325] = {.lex_state = 77, .external_lex_state = 2},
  [4326] = {.lex_state = 77, .external_lex_state = 5},
  [4327] = {.lex_state = 77, .external_lex_state = 5},
  [4328] = {.lex_state = 77, .external_lex_state = 5},
  [4329] = {.lex_state = 77, .external_lex_state = 5},
  [4330] = {.lex_state = 77, .external_lex_state = 5},
  [4331] = {.lex_state = 77, .external_lex_state = 5},
  [4332] = {.lex_state = 77, .external_lex_state = 5},
  [4333] = {.lex_state = 16, .external_lex_state = 8},
  [4334] = {.lex_state = 77, .external_lex_state = 5},
  [4335] = {.lex_state = 77, .external_lex_state = 5},
  [4336] = {.lex_state = 77, .external_lex_state = 2},
  [4337] = {.lex_state = 77, .external_lex_state = 5},
  [4338] = {.lex_state = 77, .external_lex_state = 5},
  [4339] = {.lex_state = 77, .external_lex_state = 5},
  [4340] = {.lex_state = 77, .external_lex_state = 5},
  [4341] = {.lex_state = 77, .external_lex_state = 5},
  [4342] = {.lex_state = 77, .external_lex_state = 2},
  [4343] = {.lex_state = 16, .external_lex_state = 8},
  [4344] = {.lex_state = 9, .external_lex_state = 2},
  [4345] = {.lex_state = 77, .external_lex_state = 5},
  [4346] = {.lex_state = 9, .external_lex_state = 2},
  [4347] = {.lex_state = 77, .external_lex_state = 5},
  [4348] = {.lex_state = 77, .external_lex_state = 5},
  [4349] = {.lex_state = 77, .external_lex_state = 2},
  [4350] = {.lex_state = 77, .external_lex_state = 5},
  [4351] = {.lex_state = 77, .external_lex_state = 5},
  [4352] = {.lex_state = 77, .external_lex_state = 5},
  [4353] = {.lex_state = 77, .external_lex_state = 5},
  [4354] = {.lex_state = 77, .external_lex_state = 5},
  [4355] = {.lex_state = 77, .external_lex_state = 5},
  [4356] = {.lex_state = 9, .external_lex_state = 6},
  [4357] = {.lex_state = 77, .external_lex_state = 2},
  [4358] = {.lex_state = 77, .external_lex_state = 5},
  [4359] = {.lex_state = 77, .external_lex_state = 5},
  [4360] = {.lex_state = 77, .external_lex_state = 2},
  [4361] = {.lex_state = 77, .external_lex_state = 2},
  [4362] = {.lex_state = 77, .external_lex_state = 2},
  [4363] = {.lex_state = 77, .external_lex_state = 5},
  [4364] = {.lex_state = 9, .external_lex_state = 6},
  [4365] = {.lex_state = 77, .external_lex_state = 5},
  [4366] = {.lex_state = 9, .external_lex_state = 6},
  [4367] = {.lex_state = 9, .external_lex_state = 5},
  [4368] = {.lex_state = 77, .external_lex_state = 5},
  [4369] = {.lex_state = 9, .external_lex_state = 6},
  [4370] = {.lex_state = 77, .external_lex_state = 2},
  [4371] = {.lex_state = 4, .external_lex_state = 5},
  [4372] = {.lex_state = 77, .external_lex_state = 5},
  [4373] = {.lex_state = 9, .external_lex_state = 2},
  [4374] = {.lex_state = 4, .external_lex_state = 5},
  [4375] = {.lex_state = 77, .external_lex_state = 2},
  [4376] = {.lex_state = 9, .external_lex_state = 5},
  [4377] = {.lex_state = 77, .external_lex_state = 5},
  [4378] = {.lex_state = 9, .external_lex_state = 2},
  [4379] = {.lex_state = 9, .external_lex_state = 6},
  [4380] = {.lex_state = 9, .external_lex_state = 5},
  [4381] = {.lex_state = 77, .external_lex_state = 5},
  [4382] = {.lex_state = 9, .external_lex_state = 2},
  [4383] = {.lex_state = 77, .external_lex_state = 5},
  [4384] = {.lex_state = 77, .external_lex_state = 5},
  [4385] = {.lex_state = 9, .external_lex_state = 2},
  [4386] = {.lex_state = 9, .external_lex_state = 5},
  [4387] = {.lex_state = 9, .external_lex_state = 2},
  [4388] = {.lex_state = 9, .external_lex_state = 2},
  [4389] = {.lex_state = 77, .external_lex_state = 5},
  [4390] = {.lex_state = 9, .external_lex_state = 2},
  [4391] = {.lex_state = 9, .external_lex_state = 2},
  [4392] = {.lex_state = 9, .external_lex_state = 2},
  [4393] = {.lex_state = 9, .external_lex_state = 2},
  [4394] = {.lex_state = 9, .external_lex_state = 2},
  [4395] = {.lex_state = 9, .external_lex_state = 2},
  [4396] = {.lex_state = 77, .external_lex_state = 5},
  [4397] = {.lex_state = 77, .external_lex_state = 5},
  [4398] = {.lex_state = 77, .external_lex_state = 2},
  [4399] = {.lex_state = 9, .external_lex_state = 2},
  [4400] = {.lex_state = 77, .external_lex_state = 5},
  [4401] = {.lex_state = 77, .external_lex_state = 2},
  [4402] = {.lex_state = 77, .external_lex_state = 2},
  [4403] = {.lex_state = 9, .external_lex_state = 2},
  [4404] = {.lex_state = 77, .external_lex_state = 2},
  [4405] = {.lex_state = 77, .external_lex_state = 5},
  [4406] = {.lex_state = 9, .external_lex_state = 6},
  [4407] = {.lex_state = 9, .external_lex_state = 2},
  [4408] = {.lex_state = 77, .external_lex_state = 5},
  [4409] = {.lex_state = 77, .external_lex_state = 2},
  [4410] = {.lex_state = 9, .external_lex_state = 2},
  [4411] = {.lex_state = 77, .external_lex_state = 5},
  [4412] = {.lex_state = 9, .external_lex_state = 2},
  [4413] = {.lex_state = 77, .external_lex_state = 5},
  [4414] = {.lex_state = 9, .external_lex_state = 2},
  [4415] = {.lex_state = 77, .external_lex_state = 5},
  [4416] = {.lex_state = 77, .external_lex_state = 5},
  [4417] = {.lex_state = 77, .external_lex_state = 5},
  [4418] = {.lex_state = 16, .external_lex_state = 8},
  [4419] = {.lex_state = 77, .external_lex_state = 5},
  [4420] = {.lex_state = 77, .external_lex_state = 5},
  [4421] = {.lex_state = 9, .external_lex_state = 2},
  [4422] = {.lex_state = 77, .external_lex_state = 5},
  [4423] = {.lex_state = 77, .external_lex_state = 5},
  [4424] = {.lex_state = 77, .external_lex_state = 5},
  [4425] = {.lex_state = 77, .external_lex_state = 5},
  [4426] = {.lex_state = 16, .external_lex_state = 8},
  [4427] = {.lex_state = 77, .external_lex_state = 5},
  [4428] = {.lex_state = 77, .external_lex_state = 5},
  [4429] = {.lex_state = 77, .external_lex_state = 5},
  [4430] = {.lex_state = 77, .external_lex_state = 5},
  [4431] = {.lex_state = 9, .external_lex_state = 2},
  [4432] = {.lex_state = 77, .external_lex_state = 5},
  [4433] = {.lex_state = 16, .external_lex_state = 8},
  [4434] = {.lex_state = 77, .external_lex_state = 5},
  [4435] = {.lex_state = 4, .external_lex_state = 5},
  [4436] = {.lex_state = 77, .external_lex_state = 5},
  [4437] = {.lex_state = 77, .external_lex_state = 5},
  [4438] = {.lex_state = 9, .external_lex_state = 6},
  [4439] = {.lex_state = 77, .external_lex_state = 2},
  [4440] = {.lex_state = 77, .external_lex_state = 5},
  [4441] = {.lex_state = 77, .external_lex_state = 5},
  [4442] = {.lex_state = 77, .external_lex_state = 2},
  [4443] = {.lex_state = 9, .external_lex_state = 2},
  [4444] = {.lex_state = 9, .external_lex_state = 6},
  [4445] = {.lex_state = 9, .external_lex_state = 2},
  [4446] = {.lex_state = 9, .external_lex_state = 5},
  [4447] = {.lex_state = 9, .external_lex_state = 6},
  [4448] = {.lex_state = 77, .external_lex_state = 2},
  [4449] = {.lex_state = 77, .external_lex_state = 5},
  [4450] = {.lex_state = 9, .external_lex_state = 6},
  [4451] = {.lex_state = 9, .external_lex_state = 5},
  [4452] = {.lex_state = 77, .external_lex_state = 5},
  [4453] = {.lex_state = 9, .external_lex_state = 2},
  [4454] = {.lex_state = 9, .external_lex_state = 5},
  [4455] = {.lex_state = 9, .external_lex_state = 2},
  [4456] = {.lex_state = 9, .external_lex_state = 6},
  [4457] = {.lex_state = 9, .external_lex_state = 6},
  [4458] = {.lex_state = 77, .external_lex_state = 5},
  [4459] = {.lex_state = 9, .external_lex_state = 6},
  [4460] = {.lex_state = 77, .external_lex_state = 5},
  [4461] = {.lex_state = 77, .external_lex_state = 5},
  [4462] = {.lex_state = 77, .external_lex_state = 5},
  [4463] = {.lex_state = 77, .external_lex_state = 5},
  [4464] = {.lex_state = 77, .external_lex_state = 5},
  [4465] = {.lex_state = 77, .external_lex_state = 5},
  [4466] = {.lex_state = 77, .external_lex_state = 5},
  [4467] = {.lex_state = 77, .external_lex_state = 5},
  [4468] = {.lex_state = 77, .external_lex_state = 5},
  [4469] = {.lex_state = 77, .external_lex_state = 5},
  [4470] = {.lex_state = 77, .external_lex_state = 5},
  [4471] = {.lex_state = 77, .external_lex_state = 5},
  [4472] = {.lex_state = 77, .external_lex_state = 5},
  [4473] = {.lex_state = 77, .external_lex_state = 5},
  [4474] = {.lex_state = 77, .external_lex_state = 5},
  [4475] = {.lex_state = 9, .external_lex_state = 2},
  [4476] = {.lex_state = 77, .external_lex_state = 5},
  [4477] = {.lex_state = 77, .external_lex_state = 5},
  [4478] = {.lex_state = 9, .external_lex_state = 2},
  [4479] = {.lex_state = 77, .external_lex_state = 2},
  [4480] = {.lex_state = 77, .external_lex_state = 5},
  [4481] = {.lex_state = 77, .external_lex_state = 5},
  [4482] = {.lex_state = 77, .external_lex_state = 5},
  [4483] = {.lex_state = 77, .external_lex_state = 5},
  [4484] = {.lex_state = 77, .external_lex_state = 5},
  [4485] = {.lex_state = 77, .external_lex_state = 5},
  [4486] = {.lex_state = 9, .external_lex_state = 2},
  [4487] = {.lex_state = 77, .external_lex_state = 5},
  [4488] = {.lex_state = 77, .external_lex_state = 5},
  [4489] = {.lex_state = 77, .external_lex_state = 2},
  [4490] = {.lex_state = 77, .external_lex_state = 2},
  [4491] = {.lex_state = 77, .external_lex_state = 5},
  [4492] = {.lex_state = 77, .external_lex_state = 5},
  [4493] = {.lex_state = 77, .external_lex_state = 5},
  [4494] = {.lex_state = 77, .external_lex_state = 5},
  [4495] = {.lex_state = 77, .external_lex_state = 5},
  [4496] = {.lex_state = 16, .external_lex_state = 8},
  [4497] = {.lex_state = 77, .external_lex_state = 5},
  [4498] = {.lex_state = 77, .external_lex_state = 5},
  [4499] = {.lex_state = 77, .external_lex_state = 5},
  [4500] = {.lex_state = 77, .external_lex_state = 5},
  [4501] = {.lex_state = 77, .external_lex_state = 5},
  [4502] = {.lex_state = 77, .external_lex_state = 5},
  [4503] = {.lex_state = 77, .external_lex_state = 5},
  [4504] = {.lex_state = 77, .external_lex_state = 5},
  [4505] = {.lex_state = 77, .external_lex_state = 5},
  [4506] = {.lex_state = 77, .external_lex_state = 5},
  [4507] = {.lex_state = 77, .external_lex_state = 5},
  [4508] = {.lex_state = 77, .external_lex_state = 5},
  [4509] = {.lex_state = 77, .external_lex_state = 5},
  [4510] = {.lex_state = 77, .external_lex_state = 5},
  [4511] = {.lex_state = 77, .external_lex_state = 5},
  [4512] = {.lex_state = 77, .external_lex_state = 5},
  [4513] = {.lex_state = 77, .external_lex_state = 5},
  [4514] = {.lex_state = 16, .external_lex_state = 8},
  [4515] = {.lex_state = 77, .external_lex_state = 5},
  [4516] = {.lex_state = 77, .external_lex_state = 5},
  [4517] = {.lex_state = 77, .external_lex_state = 5},
  [4518] = {.lex_state = 77, .external_lex_state = 5},
  [4519] = {.lex_state = 77, .external_lex_state = 5},
  [4520] = {.lex_state = 9, .external_lex_state = 6},
  [4521] = {.lex_state = 9, .external_lex_state = 2},
  [4522] = {.lex_state = 77, .external_lex_state = 2},
  [4523] = {.lex_state = 77, .external_lex_state = 5},
  [4524] = {.lex_state = 9, .external_lex_state = 6},
  [4525] = {.lex_state = 9, .external_lex_state = 6},
  [4526] = {.lex_state = 9, .external_lex_state = 2},
  [4527] = {.lex_state = 9, .external_lex_state = 6},
  [4528] = {.lex_state = 9, .external_lex_state = 2},
  [4529] = {.lex_state = 9, .external_lex_state = 2},
  [4530] = {.lex_state = 77, .external_lex_state = 2},
  [4531] = {.lex_state = 77, .external_lex_state = 5},
  [4532] = {.lex_state = 77, .external_lex_state = 5},
  [4533] = {.lex_state = 77, .external_lex_state = 5},
  [4534] = {.lex_state = 77, .external_lex_state = 5},
  [4535] = {.lex_state = 77, .external_lex_state = 5},
  [4536] = {.lex_state = 77, .external_lex_state = 5},
  [4537] = {.lex_state = 77, .external_lex_state = 5},
  [4538] = {.lex_state = 77, .external_lex_state = 5},
  [4539] = {.lex_state = 77, .external_lex_state = 5},
  [4540] = {.lex_state = 77, .external_lex_state = 5},
  [4541] = {.lex_state = 77, .external_lex_state = 5},
  [4542] = {.lex_state = 77, .external_lex_state = 5},
  [4543] = {.lex_state = 77, .external_lex_state = 5},
  [4544] = {.lex_state = 77, .external_lex_state = 5},
  [4545] = {.lex_state = 77, .external_lex_state = 5},
  [4546] = {.lex_state = 77, .external_lex_state = 5},
  [4547] = {.lex_state = 77, .external_lex_state = 5},
  [4548] = {.lex_state = 77, .external_lex_state = 5},
  [4549] = {.lex_state = 9, .external_lex_state = 2},
  [4550] = {.lex_state = 77, .external_lex_state = 5},
  [4551] = {.lex_state = 77, .external_lex_state = 5},
  [4552] = {.lex_state = 16, .external_lex_state = 8},
  [4553] = {.lex_state = 77, .external_lex_state = 5},
  [4554] = {.lex_state = 77, .external_lex_state = 5},
  [4555] = {.lex_state = 77, .external_lex_state = 5},
  [4556] = {.lex_state = 9, .external_lex_state = 2},
  [4557] = {.lex_state = 16, .external_lex_state = 8},
  [4558] = {.lex_state = 77, .external_lex_state = 5},
  [4559] = {.lex_state = 9, .external_lex_state = 2},
  [4560] = {.lex_state = 77, .external_lex_state = 5},
  [4561] = {.lex_state = 77, .external_lex_state = 5},
  [4562] = {.lex_state = 77, .external_lex_state = 5},
  [4563] = {.lex_state = 9, .external_lex_state = 2},
  [4564] = {.lex_state = 77, .external_lex_state = 5},
  [4565] = {.lex_state = 4, .external_lex_state = 2},
  [4566] = {.lex_state = 9, .external_lex_state = 2},
  [4567] = {.lex_state = 77, .external_lex_state = 5},
  [4568] = {.lex_state = 77, .external_lex_state = 5},
  [4569] = {.lex_state = 77, .external_lex_state = 5},
  [4570] = {.lex_state = 77, .external_lex_state = 5},
  [4571] = {.lex_state = 77, .external_lex_state = 5},
  [4572] = {.lex_state = 77, .external_lex_state = 5},
  [4573] = {.lex_state = 77, .external_lex_state = 5},
  [4574] = {.lex_state = 77, .external_lex_state = 2},
  [4575] = {.lex_state = 77, .external_lex_state = 5},
  [4576] = {.lex_state = 77, .external_lex_state = 2},
  [4577] = {.lex_state = 77, .external_lex_state = 5},
  [4578] = {.lex_state = 77, .external_lex_state = 5},
  [4579] = {.lex_state = 9, .external_lex_state = 5},
  [4580] = {.lex_state = 77, .external_lex_state = 5},
  [4581] = {.lex_state = 10, .external_lex_state = 2},
  [4582] = {.lex_state = 77, .external_lex_state = 5},
  [4583] = {.lex_state = 77, .external_lex_state = 5},
  [4584] = {.lex_state = 77, .external_lex_state = 5},
  [4585] = {.lex_state = 77, .external_lex_state = 5},
  [4586] = {.lex_state = 77, .external_lex_state = 5},
  [4587] = {.lex_state = 77, .external_lex_state = 5},
  [4588] = {.lex_state = 9, .external_lex_state = 2},
  [4589] = {.lex_state = 77, .external_lex_state = 5},
  [4590] = {.lex_state = 77, .external_lex_state = 5},
  [4591] = {.lex_state = 77, .external_lex_state = 5},
  [4592] = {.lex_state = 77, .external_lex_state = 2},
  [4593] = {.lex_state = 77, .external_lex_state = 5},
  [4594] = {.lex_state = 77, .external_lex_state = 5},
  [4595] = {.lex_state = 9, .external_lex_state = 2},
  [4596] = {.lex_state = 9, .external_lex_state = 2},
  [4597] = {.lex_state = 9, .external_lex_state = 6},
  [4598] = {.lex_state = 9, .external_lex_state = 2},
  [4599] = {.lex_state = 9, .external_lex_state = 5},
  [4600] = {.lex_state = 9, .external_lex_state = 2},
  [4601] = {.lex_state = 77, .external_lex_state = 5},
  [4602] = {.lex_state = 77, .external_lex_state = 5},
  [4603] = {.lex_state = 77, .external_lex_state = 5},
  [4604] = {.lex_state = 77, .external_lex_state = 5},
  [4605] = {.lex_state = 77, .external_lex_state = 5},
  [4606] = {.lex_state = 77, .external_lex_state = 2},
  [4607] = {.lex_state = 9, .external_lex_state = 2},
  [4608] = {.lex_state = 9, .external_lex_state = 2},
  [4609] = {.lex_state = 9, .external_lex_state = 2},
  [4610] = {.lex_state = 9, .external_lex_state = 2},
  [4611] = {.lex_state = 77, .external_lex_state = 5},
  [4612] = {.lex_state = 77, .external_lex_state = 5},
  [4613] = {.lex_state = 77, .external_lex_state = 5},
  [4614] = {.lex_state = 77, .external_lex_state = 5},
  [4615] = {.lex_state = 77, .external_lex_state = 2},
  [4616] = {.lex_state = 9, .external_lex_state = 2},
  [4617] = {.lex_state = 9, .external_lex_state = 2},
  [4618] = {.lex_state = 77, .external_lex_state = 5},
  [4619] = {.lex_state = 77, .external_lex_state = 5},
  [4620] = {.lex_state = 9, .external_lex_state = 2},
  [4621] = {.lex_state = 9, .external_lex_state = 2},
  [4622] = {.lex_state = 77, .external_lex_state = 5},
  [4623] = {.lex_state = 9, .external_lex_state = 2},
  [4624] = {.lex_state = 77, .external_lex_state = 5},
  [4625] = {.lex_state = 9, .external_lex_state = 2},
  [4626] = {.lex_state = 77, .external_lex_state = 5},
  [4627] = {.lex_state = 77, .external_lex_state = 5},
  [4628] = {.lex_state = 9, .external_lex_state = 2},
  [4629] = {.lex_state = 77, .external_lex_state = 5},
  [4630] = {.lex_state = 9, .external_lex_state = 2},
  [4631] = {.lex_state = 9, .external_lex_state = 2},
  [4632] = {.lex_state = 77, .external_lex_state = 5},
  [4633] = {.lex_state = 77, .external_lex_state = 5},
  [4634] = {.lex_state = 77, .external_lex_state = 5},
  [4635] = {.lex_state = 77, .external_lex_state = 5},
  [4636] = {.lex_state = 4, .external_lex_state = 2},
  [4637] = {.lex_state = 9, .external_lex_state = 2},
  [4638] = {.lex_state = 9, .external_lex_state = 2},
  [4639] = {.lex_state = 9, .external_lex_state = 2},
  [4640] = {.lex_state = 9, .external_lex_state = 6},
  [4641] = {.lex_state = 77, .external_lex_state = 5},
  [4642] = {.lex_state = 9, .external_lex_state = 2},
  [4643] = {.lex_state = 77, .external_lex_state = 5},
  [4644] = {.lex_state = 77, .external_lex_state = 5},
  [4645] = {.lex_state = 9, .external_lex_state = 2},
  [4646] = {.lex_state = 77, .external_lex_state = 5},
  [4647] = {.lex_state = 9, .external_lex_state = 2},
  [4648] = {.lex_state = 77, .external_lex_state = 5},
  [4649] = {.lex_state = 77, .external_lex_state = 5},
  [4650] = {.lex_state = 77, .external_lex_state = 5},
  [4651] = {.lex_state = 77, .external_lex_state = 5},
  [4652] = {.lex_state = 77, .external_lex_state = 5},
  [4653] = {.lex_state = 77, .external_lex_state = 5},
  [4654] = {.lex_state = 77, .external_lex_state = 5},
  [4655] = {.lex_state = 77, .external_lex_state = 5},
  [4656] = {.lex_state = 77, .external_lex_state = 5},
  [4657] = {.lex_state = 77, .external_lex_state = 5},
  [4658] = {.lex_state = 77, .external_lex_state = 5},
  [4659] = {.lex_state = 77, .external_lex_state = 5},
  [4660] = {.lex_state = 77, .external_lex_state = 2},
  [4661] = {.lex_state = 77, .external_lex_state = 5},
  [4662] = {.lex_state = 77, .external_lex_state = 5},
  [4663] = {.lex_state = 77, .external_lex_state = 5},
  [4664] = {.lex_state = 77, .external_lex_state = 5},
  [4665] = {.lex_state = 77, .external_lex_state = 5},
  [4666] = {.lex_state = 77, .external_lex_state = 5},
  [4667] = {.lex_state = 9, .external_lex_state = 2},
  [4668] = {.lex_state = 9, .external_lex_state = 2},
  [4669] = {.lex_state = 77, .external_lex_state = 2},
  [4670] = {.lex_state = 9, .external_lex_state = 2},
  [4671] = {.lex_state = 77, .external_lex_state = 5},
  [4672] = {.lex_state = 9, .external_lex_state = 2},
  [4673] = {.lex_state = 9, .external_lex_state = 2},
  [4674] = {.lex_state = 9, .external_lex_state = 2},
  [4675] = {.lex_state = 9, .external_lex_state = 2},
  [4676] = {.lex_state = 77, .external_lex_state = 5},
  [4677] = {.lex_state = 77, .external_lex_state = 5},
  [4678] = {.lex_state = 77, .external_lex_state = 5},
  [4679] = {.lex_state = 9, .external_lex_state = 2},
  [4680] = {.lex_state = 77, .external_lex_state = 5},
  [4681] = {.lex_state = 9, .external_lex_state = 2},
  [4682] = {.lex_state = 9, .external_lex_state = 2},
  [4683] = {.lex_state = 77, .external_lex_state = 5},
  [4684] = {.lex_state = 77, .external_lex_state = 5},
  [4685] = {.lex_state = 77, .external_lex_state = 5},
  [4686] = {.lex_state = 77, .external_lex_state = 5},
  [4687] = {.lex_state = 77, .external_lex_state = 5},
  [4688] = {.lex_state = 9, .external_lex_state = 2},
  [4689] = {.lex_state = 77, .external_lex_state = 5},
  [4690] = {.lex_state = 77, .external_lex_state = 5},
  [4691] = {.lex_state = 77, .external_lex_state = 5},
  [4692] = {.lex_state = 9, .external_lex_state = 2},
  [4693] = {.lex_state = 4, .external_lex_state = 2},
  [4694] = {.lex_state = 4, .external_lex_state = 2},
  [4695] = {.lex_state = 77, .external_lex_state = 5},
  [4696] = {.lex_state = 77, .external_lex_state = 5},
  [4697] = {.lex_state = 77, .external_lex_state = 5},
  [4698] = {.lex_state = 77, .external_lex_state = 5},
  [4699] = {.lex_state = 77, .external_lex_state = 5},
  [4700] = {.lex_state = 77, .external_lex_state = 5},
  [4701] = {.lex_state = 9, .external_lex_state = 2},
  [4702] = {.lex_state = 77, .external_lex_state = 5},
  [4703] = {.lex_state = 77, .external_lex_state = 2},
  [4704] = {.lex_state = 9, .external_lex_state = 2},
  [4705] = {.lex_state = 9, .external_lex_state = 2},
  [4706] = {.lex_state = 9, .external_lex_state = 2},
  [4707] = {.lex_state = 9, .external_lex_state = 2},
  [4708] = {.lex_state = 9, .external_lex_state = 2},
  [4709] = {.lex_state = 77, .external_lex_state = 5},
  [4710] = {.lex_state = 77, .external_lex_state = 5},
  [4711] = {.lex_state = 77, .external_lex_state = 5},
  [4712] = {.lex_state = 77, .external_lex_state = 5},
  [4713] = {.lex_state = 77, .external_lex_state = 5},
  [4714] = {.lex_state = 77, .external_lex_state = 5},
  [4715] = {.lex_state = 77, .external_lex_state = 2},
  [4716] = {.lex_state = 77, .external_lex_state = 5},
  [4717] = {.lex_state = 9, .external_lex_state = 2},
  [4718] = {.lex_state = 77, .external_lex_state = 5},
  [4719] = {.lex_state = 77, .external_lex_state = 5},
  [4720] = {.lex_state = 9, .external_lex_state = 2},
  [4721] = {.lex_state = 77, .external_lex_state = 5},
  [4722] = {.lex_state = 14, .external_lex_state = 2},
  [4723] = {.lex_state = 77, .external_lex_state = 5},
  [4724] = {.lex_state = 77, .external_lex_state = 5},
  [4725] = {.lex_state = 9, .external_lex_state = 2},
  [4726] = {.lex_state = 77, .external_lex_state = 5},
  [4727] = {.lex_state = 9, .external_lex_state = 2},
  [4728] = {.lex_state = 77, .external_lex_state = 2},
  [4729] = {.lex_state = 77, .external_lex_state = 5},
  [4730] = {.lex_state = 77, .external_lex_state = 5},
  [4731] = {.lex_state = 77, .external_lex_state = 2},
  [4732] = {.lex_state = 77, .external_lex_state = 2},
  [4733] = {.lex_state = 77, .external_lex_state = 2},
  [4734] = {.lex_state = 77, .external_lex_state = 5},
  [4735] = {.lex_state = 77, .external_lex_state = 2},
  [4736] = {.lex_state = 77, .external_lex_state = 2},
  [4737] = {.lex_state = 77, .external_lex_state = 5},
  [4738] = {.lex_state = 77, .external_lex_state = 2},
  [4739] = {.lex_state = 77, .external_lex_state = 5},
  [4740] = {.lex_state = 9, .external_lex_state = 2},
  [4741] = {.lex_state = 77, .external_lex_state = 5},
  [4742] = {.lex_state = 9, .external_lex_state = 2},
  [4743] = {.lex_state = 77, .external_lex_state = 5},
  [4744] = {.lex_state = 9, .external_lex_state = 2},
  [4745] = {.lex_state = 77, .external_lex_state = 5},
  [4746] = {.lex_state = 77, .external_lex_state = 5},
  [4747] = {.lex_state = 77, .external_lex_state = 5},
  [4748] = {.lex_state = 77, .external_lex_state = 5},
  [4749] = {.lex_state = 77, .external_lex_state = 5},
  [4750] = {.lex_state = 77, .external_lex_state = 5},
  [4751] = {.lex_state = 77, .external_lex_state = 5},
  [4752] = {.lex_state = 77, .external_lex_state = 5},
  [4753] = {.lex_state = 77, .external_lex_state = 5},
  [4754] = {.lex_state = 9, .external_lex_state = 2},
  [4755] = {.lex_state = 77, .external_lex_state = 5},
  [4756] = {.lex_state = 77, .external_lex_state = 5},
  [4757] = {.lex_state = 77, .external_lex_state = 5},
  [4758] = {.lex_state = 77, .external_lex_state = 5},
  [4759] = {.lex_state = 9, .external_lex_state = 2},
  [4760] = {.lex_state = 77, .external_lex_state = 5},
  [4761] = {.lex_state = 77, .external_lex_state = 5},
  [4762] = {.lex_state = 77, .external_lex_state = 5},
  [4763] = {.lex_state = 77, .external_lex_state = 5},
  [4764] = {.lex_state = 77, .external_lex_state = 5},
  [4765] = {.lex_state = 77, .external_lex_state = 5},
  [4766] = {.lex_state = 77, .external_lex_state = 5},
  [4767] = {.lex_state = 77, .external_lex_state = 5},
  [4768] = {.lex_state = 77, .external_lex_state = 5},
  [4769] = {.lex_state = 77, .external_lex_state = 5},
  [4770] = {.lex_state = 77, .external_lex_state = 5},
  [4771] = {.lex_state = 77, .external_lex_state = 5},
  [4772] = {.lex_state = 77, .external_lex_state = 2},
  [4773] = {.lex_state = 77, .external_lex_state = 5},
  [4774] = {.lex_state = 77, .external_lex_state = 5},
  [4775] = {.lex_state = 77, .external_lex_state = 5},
  [4776] = {.lex_state = 77, .external_lex_state = 5},
  [4777] = {.lex_state = 77, .external_lex_state = 5},
  [4778] = {.lex_state = 77, .external_lex_state = 5},
  [4779] = {.lex_state = 77, .external_lex_state = 5},
  [4780] = {.lex_state = 77, .external_lex_state = 5},
  [4781] = {.lex_state = 14, .external_lex_state = 2},
  [4782] = {.lex_state = 77, .external_lex_state = 5},
  [4783] = {.lex_state = 14, .external_lex_state = 2},
  [4784] = {.lex_state = 77, .external_lex_state = 5},
  [4785] = {.lex_state = 77, .external_lex_state = 5},
  [4786] = {.lex_state = 16, .external_lex_state = 8},
  [4787] = {.lex_state = 9, .external_lex_state = 2},
  [4788] = {.lex_state = 9, .external_lex_state = 2},
  [4789] = {.lex_state = 77, .external_lex_state = 2},
  [4790] = {.lex_state = 9, .external_lex_state = 2},
  [4791] = {.lex_state = 9, .external_lex_state = 2},
  [4792] = {.lex_state = 77, .external_lex_state = 2},
  [4793] = {.lex_state = 9, .external_lex_state = 2},
  [4794] = {.lex_state = 77, .external_lex_state = 5},
  [4795] = {.lex_state = 77, .external_lex_state = 5},
  [4796] = {.lex_state = 9, .external_lex_state = 2},
  [4797] = {.lex_state = 16, .external_lex_state = 7},
  [4798] = {.lex_state = 9, .external_lex_state = 2},
  [4799] = {.lex_state = 9, .external_lex_state = 2},
  [4800] = {.lex_state = 15, .external_lex_state = 9},
  [4801] = {.lex_state = 9, .external_lex_state = 2},
  [4802] = {.lex_state = 19, .external_lex_state = 9},
  [4803] = {.lex_state = 9, .external_lex_state = 2},
  [4804] = {.lex_state = 77, .external_lex_state = 2},
  [4805] = {.lex_state = 9, .external_lex_state = 2},
  [4806] = {.lex_state = 9, .external_lex_state = 2},
  [4807] = {.lex_state = 9, .external_lex_state = 2},
  [4808] = {.lex_state = 77, .external_lex_state = 2},
  [4809] = {.lex_state = 77, .external_lex_state = 5},
  [4810] = {.lex_state = 9, .external_lex_state = 2},
  [4811] = {.lex_state = 77, .external_lex_state = 2},
  [4812] = {.lex_state = 16, .external_lex_state = 7},
  [4813] = {.lex_state = 77, .external_lex_state = 2},
  [4814] = {.lex_state = 77, .external_lex_state = 5},
  [4815] = {.lex_state = 15, .external_lex_state = 9},
  [4816] = {.lex_state = 77, .external_lex_state = 5},
  [4817] = {.lex_state = 77, .external_lex_state = 5},
  [4818] = {.lex_state = 9, .external_lex_state = 2},
  [4819] = {.lex_state = 77, .external_lex_state = 2},
  [4820] = {.lex_state = 9, .external_lex_state = 2},
  [4821] = {.lex_state = 77, .external_lex_state = 2},
  [4822] = {.lex_state = 15, .external_lex_state = 9},
  [4823] = {.lex_state = 77, .external_lex_state = 2},
  [4824] = {.lex_state = 19, .external_lex_state = 9},
  [4825] = {.lex_state = 15, .external_lex_state = 9},
  [4826] = {.lex_state = 19, .external_lex_state = 9},
  [4827] = {.lex_state = 77, .external_lex_state = 2},
  [4828] = {.lex_state = 4, .external_lex_state = 5},
  [4829] = {.lex_state = 77, .external_lex_state = 2},
  [4830] = {.lex_state = 4, .external_lex_state = 2},
  [4831] = {.lex_state = 9, .external_lex_state = 2},
  [4832] = {.lex_state = 77, .external_lex_state = 2},
  [4833] = {.lex_state = 19, .external_lex_state = 9},
  [4834] = {.lex_state = 77, .external_lex_state = 2},
  [4835] = {.lex_state = 9, .external_lex_state = 2},
  [4836] = {.lex_state = 9, .external_lex_state = 2},
  [4837] = {.lex_state = 19, .external_lex_state = 9},
  [4838] = {.lex_state = 9, .external_lex_state = 2},
  [4839] = {.lex_state = 9, .external_lex_state = 2},
  [4840] = {.lex_state = 77, .external_lex_state = 2},
  [4841] = {.lex_state = 15, .external_lex_state = 9},
  [4842] = {.lex_state = 15, .external_lex_state = 9},
  [4843] = {.lex_state = 19, .external_lex_state = 9},
  [4844] = {.lex_state = 15, .external_lex_state = 9},
  [4845] = {.lex_state = 77, .external_lex_state = 6},
  [4846] = {.lex_state = 77, .external_lex_state = 5},
  [4847] = {.lex_state = 9, .external_lex_state = 2},
  [4848] = {.lex_state = 19, .external_lex_state = 9},
  [4849] = {.lex_state = 77, .external_lex_state = 5},
  [4850] = {.lex_state = 9, .external_lex_state = 2},
  [4851] = {.lex_state = 77, .external_lex_state = 5},
  [4852] = {.lex_state = 15, .external_lex_state = 9},
  [4853] = {.lex_state = 15, .external_lex_state = 9},
  [4854] = {.lex_state = 19, .external_lex_state = 9},
  [4855] = {.lex_state = 15, .external_lex_state = 9},
  [4856] = {.lex_state = 19, .external_lex_state = 9},
  [4857] = {.lex_state = 9, .external_lex_state = 2},
  [4858] = {.lex_state = 77, .external_lex_state = 5},
  [4859] = {.lex_state = 15, .external_lex_state = 9},
  [4860] = {.lex_state = 19, .external_lex_state = 9},
  [4861] = {.lex_state = 15, .external_lex_state = 9},
  [4862] = {.lex_state = 9, .external_lex_state = 2},
  [4863] = {.lex_state = 9, .external_lex_state = 2},
  [4864] = {.lex_state = 15, .external_lex_state = 9},
  [4865] = {.lex_state = 19, .external_lex_state = 9},
  [4866] = {.lex_state = 15, .external_lex_state = 9},
  [4867] = {.lex_state = 19, .external_lex_state = 9},
  [4868] = {.lex_state = 77, .external_lex_state = 2},
  [4869] = {.lex_state = 15, .external_lex_state = 9},
  [4870] = {.lex_state = 9, .external_lex_state = 2},
  [4871] = {.lex_state = 19, .external_lex_state = 9},
  [4872] = {.lex_state = 9, .external_lex_state = 2},
  [4873] = {.lex_state = 15, .external_lex_state = 9},
  [4874] = {.lex_state = 14, .external_lex_state = 2},
  [4875] = {.lex_state = 14, .external_lex_state = 2},
  [4876] = {.lex_state = 9, .external_lex_state = 2},
  [4877] = {.lex_state = 9, .external_lex_state = 2},
  [4878] = {.lex_state = 4, .external_lex_state = 2},
  [4879] = {.lex_state = 9, .external_lex_state = 2},
  [4880] = {.lex_state = 9, .external_lex_state = 2},
  [4881] = {.lex_state = 15, .external_lex_state = 9},
  [4882] = {.lex_state = 9, .external_lex_state = 2},
  [4883] = {.lex_state = 77, .external_lex_state = 2},
  [4884] = {.lex_state = 9, .external_lex_state = 2},
  [4885] = {.lex_state = 19, .external_lex_state = 9},
  [4886] = {.lex_state = 77, .external_lex_state = 2},
  [4887] = {.lex_state = 77, .external_lex_state = 5},
  [4888] = {.lex_state = 77, .external_lex_state = 5},
  [4889] = {.lex_state = 77, .external_lex_state = 5},
  [4890] = {.lex_state = 9, .external_lex_state = 2},
  [4891] = {.lex_state = 9, .external_lex_state = 2},
  [4892] = {.lex_state = 77, .external_lex_state = 5},
  [4893] = {.lex_state = 77, .external_lex_state = 5},
  [4894] = {.lex_state = 9, .external_lex_state = 2},
  [4895] = {.lex_state = 77, .external_lex_state = 5},
  [4896] = {.lex_state = 9, .external_lex_state = 2},
  [4897] = {.lex_state = 9, .external_lex_state = 2},
  [4898] = {.lex_state = 19, .external_lex_state = 9},
  [4899] = {.lex_state = 9, .external_lex_state = 2},
  [4900] = {.lex_state = 77, .external_lex_state = 2},
  [4901] = {.lex_state = 9, .external_lex_state = 2},
  [4902] = {.lex_state = 77, .external_lex_state = 5},
  [4903] = {.lex_state = 77, .external_lex_state = 2},
  [4904] = {.lex_state = 9, .external_lex_state = 2},
  [4905] = {.lex_state = 9, .external_lex_state = 2},
  [4906] = {.lex_state = 9, .external_lex_state = 2},
  [4907] = {.lex_state = 9, .external_lex_state = 2},
  [4908] = {.lex_state = 9, .external_lex_state = 2},
  [4909] = {.lex_state = 9, .external_lex_state = 2},
  [4910] = {.lex_state = 77, .external_lex_state = 5},
  [4911] = {.lex_state = 19, .external_lex_state = 9},
  [4912] = {.lex_state = 9, .external_lex_state = 2},
  [4913] = {.lex_state = 77, .external_lex_state = 5},
  [4914] = {.lex_state = 77, .external_lex_state = 5},
  [4915] = {.lex_state = 9, .external_lex_state = 2},
  [4916] = {.lex_state = 77, .external_lex_state = 5},
  [4917] = {.lex_state = 77, .external_lex_state = 5},
  [4918] = {.lex_state = 77, .external_lex_state = 5},
  [4919] = {.lex_state = 9, .external_lex_state = 2},
  [4920] = {.lex_state = 77, .external_lex_state = 2},
  [4921] = {.lex_state = 77, .external_lex_state = 2},
  [4922] = {.lex_state = 9, .external_lex_state = 2},
  [4923] = {.lex_state = 9, .external_lex_state = 2},
  [4924] = {.lex_state = 9, .external_lex_state = 2},
  [4925] = {.lex_state = 15, .external_lex_state = 9},
  [4926] = {.lex_state = 19, .external_lex_state = 9},
  [4927] = {.lex_state = 15, .external_lex_state = 9},
  [4928] = {.lex_state = 19, .external_lex_state = 9},
  [4929] = {.lex_state = 77, .external_lex_state = 5},
  [4930] = {.lex_state = 77, .external_lex_state = 2},
  [4931] = {.lex_state = 9, .external_lex_state = 2},
  [4932] = {.lex_state = 9, .external_lex_state = 2},
  [4933] = {.lex_state = 9, .external_lex_state = 2},
  [4934] = {.lex_state = 9, .external_lex_state = 2},
  [4935] = {.lex_state = 77, .external_lex_state = 5},
  [4936] = {.lex_state = 15, .external_lex_state = 9},
  [4937] = {.lex_state = 19, .external_lex_state = 9},
  [4938] = {.lex_state = 9, .external_lex_state = 2},
  [4939] = {.lex_state = 15, .external_lex_state = 9},
  [4940] = {.lex_state = 77, .external_lex_state = 5},
  [4941] = {.lex_state = 19, .external_lex_state = 9},
  [4942] = {.lex_state = 9, .external_lex_state = 2},
  [4943] = {.lex_state = 9, .external_lex_state = 2},
  [4944] = {.lex_state = 9, .external_lex_state = 2},
  [4945] = {.lex_state = 9, .external_lex_state = 2},
  [4946] = {.lex_state = 9, .external_lex_state = 2},
  [4947] = {.lex_state = 77, .external_lex_state = 5},
  [4948] = {.lex_state = 9, .external_lex_state = 2},
  [4949] = {.lex_state = 9, .external_lex_state = 2},
  [4950] = {.lex_state = 77, .external_lex_state = 5},
  [4951] = {.lex_state = 77, .external_lex_state = 5},
  [4952] = {.lex_state = 9, .external_lex_state = 2},
  [4953] = {.lex_state = 9, .external_lex_state = 2},
  [4954] = {.lex_state = 19, .external_lex_state = 9},
  [4955] = {.lex_state = 77, .external_lex_state = 5},
  [4956] = {.lex_state = 77, .external_lex_state = 2},
  [4957] = {.lex_state = 77, .external_lex_state = 5},
  [4958] = {.lex_state = 77, .external_lex_state = 5},
  [4959] = {.lex_state = 77, .external_lex_state = 2},
  [4960] = {.lex_state = 77, .external_lex_state = 2},
  [4961] = {.lex_state = 77, .external_lex_state = 5},
  [4962] = {.lex_state = 77, .external_lex_state = 2},
  [4963] = {.lex_state = 77, .external_lex_state = 5},
  [4964] = {.lex_state = 77, .external_lex_state = 2},
  [4965] = {.lex_state = 77, .external_lex_state = 2},
  [4966] = {.lex_state = 77, .external_lex_state = 2},
  [4967] = {.lex_state = 77, .external_lex_state = 5},
  [4968] = {.lex_state = 77, .external_lex_state = 2},
  [4969] = {.lex_state = 77, .external_lex_state = 5},
  [4970] = {.lex_state = 77, .external_lex_state = 5},
  [4971] = {.lex_state = 77, .external_lex_state = 5},
  [4972] = {.lex_state = 77, .external_lex_state = 5},
  [4973] = {.lex_state = 77, .external_lex_state = 5},
  [4974] = {.lex_state = 77, .external_lex_state = 5},
  [4975] = {.lex_state = 77, .external_lex_state = 5},
  [4976] = {.lex_state = 77, .external_lex_state = 2},
  [4977] = {.lex_state = 77, .external_lex_state = 2},
  [4978] = {.lex_state = 77, .external_lex_state = 5},
  [4979] = {.lex_state = 77, .external_lex_state = 5},
  [4980] = {.lex_state = 77, .external_lex_state = 5},
  [4981] = {.lex_state = 77, .external_lex_state = 2},
  [4982] = {.lex_state = 77, .external_lex_state = 5},
  [4983] = {.lex_state = 77, .external_lex_state = 5},
  [4984] = {.lex_state = 77, .external_lex_state = 5},
  [4985] = {.lex_state = 77, .external_lex_state = 5},
  [4986] = {.lex_state = 77, .external_lex_state = 2},
  [4987] = {.lex_state = 77, .external_lex_state = 5},
  [4988] = {.lex_state = 77, .external_lex_state = 2},
  [4989] = {.lex_state = 77, .external_lex_state = 2},
  [4990] = {.lex_state = 77, .external_lex_state = 5},
  [4991] = {.lex_state = 77, .external_lex_state = 2},
  [4992] = {.lex_state = 77, .external_lex_state = 5},
  [4993] = {.lex_state = 77, .external_lex_state = 5},
  [4994] = {.lex_state = 77, .external_lex_state = 5},
  [4995] = {.lex_state = 77, .external_lex_state = 5},
  [4996] = {.lex_state = 77, .external_lex_state = 5},
  [4997] = {.lex_state = 77, .external_lex_state = 5},
  [4998] = {.lex_state = 77, .external_lex_state = 5},
  [4999] = {.lex_state = 77, .external_lex_state = 5},
  [5000] = {.lex_state = 77, .external_lex_state = 2},
  [5001] = {.lex_state = 4, .external_lex_state = 2},
  [5002] = {.lex_state = 77, .external_lex_state = 2},
  [5003] = {.lex_state = 77, .external_lex_state = 2},
  [5004] = {.lex_state = 77, .external_lex_state = 5},
  [5005] = {.lex_state = 77, .external_lex_state = 5},
  [5006] = {.lex_state = 77, .external_lex_state = 5},
  [5007] = {.lex_state = 77, .external_lex_state = 5},
  [5008] = {.lex_state = 77, .external_lex_state = 2},
  [5009] = {.lex_state = 9, .external_lex_state = 2},
  [5010] = {.lex_state = 77, .external_lex_state = 2},
  [5011] = {.lex_state = 77, .external_lex_state = 2},
  [5012] = {.lex_state = 77, .external_lex_state = 5},
  [5013] = {.lex_state = 77, .external_lex_state = 5},
  [5014] = {.lex_state = 77, .external_lex_state = 5},
  [5015] = {.lex_state = 77, .external_lex_state = 5},
  [5016] = {.lex_state = 77, .external_lex_state = 5},
  [5017] = {.lex_state = 77, .external_lex_state = 2},
  [5018] = {.lex_state = 77, .external_lex_state = 5},
  [5019] = {.lex_state = 77, .external_lex_state = 2},
  [5020] = {.lex_state = 77, .external_lex_state = 5},
  [5021] = {.lex_state = 9, .external_lex_state = 2},
  [5022] = {.lex_state = 9, .external_lex_state = 2},
  [5023] = {.lex_state = 77, .external_lex_state = 5},
  [5024] = {.lex_state = 77, .external_lex_state = 5},
  [5025] = {.lex_state = 77, .external_lex_state = 2},
  [5026] = {.lex_state = 77, .external_lex_state = 2},
  [5027] = {.lex_state = 77, .external_lex_state = 2},
  [5028] = {.lex_state = 77, .external_lex_state = 5},
  [5029] = {.lex_state = 77, .external_lex_state = 5},
  [5030] = {.lex_state = 77, .external_lex_state = 2},
  [5031] = {.lex_state = 77, .external_lex_state = 5},
  [5032] = {.lex_state = 4, .external_lex_state = 2},
  [5033] = {.lex_state = 77, .external_lex_state = 2},
  [5034] = {.lex_state = 77, .external_lex_state = 5},
  [5035] = {.lex_state = 77, .external_lex_state = 5},
  [5036] = {.lex_state = 77, .external_lex_state = 2},
  [5037] = {.lex_state = 77, .external_lex_state = 5},
  [5038] = {.lex_state = 9, .external_lex_state = 2},
  [5039] = {.lex_state = 77, .external_lex_state = 2},
  [5040] = {.lex_state = 77, .external_lex_state = 5},
  [5041] = {.lex_state = 77, .external_lex_state = 2},
  [5042] = {.lex_state = 77, .external_lex_state = 5},
  [5043] = {.lex_state = 77, .external_lex_state = 5},
  [5044] = {.lex_state = 4, .external_lex_state = 5},
  [5045] = {.lex_state = 4, .external_lex_state = 5},
  [5046] = {.lex_state = 77, .external_lex_state = 2},
  [5047] = {.lex_state = 77, .external_lex_state = 5},
  [5048] = {.lex_state = 77, .external_lex_state = 2},
  [5049] = {.lex_state = 77, .external_lex_state = 5},
  [5050] = {.lex_state = 77, .external_lex_state = 5},
  [5051] = {.lex_state = 77, .external_lex_state = 5},
  [5052] = {.lex_state = 77, .external_lex_state = 2},
  [5053] = {.lex_state = 77, .external_lex_state = 2},
  [5054] = {.lex_state = 77, .external_lex_state = 2},
  [5055] = {.lex_state = 4, .external_lex_state = 2},
  [5056] = {.lex_state = 77, .external_lex_state = 5},
  [5057] = {.lex_state = 9, .external_lex_state = 2},
  [5058] = {.lex_state = 77, .external_lex_state = 5},
  [5059] = {.lex_state = 77, .external_lex_state = 5},
  [5060] = {.lex_state = 77, .external_lex_state = 5},
  [5061] = {.lex_state = 77, .external_lex_state = 5},
  [5062] = {.lex_state = 77, .external_lex_state = 5},
  [5063] = {.lex_state = 9, .external_lex_state = 2},
  [5064] = {.lex_state = 4, .external_lex_state = 2},
  [5065] = {.lex_state = 77, .external_lex_state = 5},
  [5066] = {.lex_state = 9, .external_lex_state = 2},
  [5067] = {.lex_state = 77, .external_lex_state = 5},
  [5068] = {.lex_state = 77, .external_lex_state = 5},
  [5069] = {.lex_state = 77, .external_lex_state = 5},
  [5070] = {.lex_state = 77, .external_lex_state = 2},
  [5071] = {.lex_state = 77, .external_lex_state = 5},
  [5072] = {.lex_state = 77, .external_lex_state = 5},
  [5073] = {.lex_state = 77, .external_lex_state = 5},
  [5074] = {.lex_state = 77, .external_lex_state = 2},
  [5075] = {.lex_state = 77, .external_lex_state = 5},
  [5076] = {.lex_state = 77, .external_lex_state = 5},
  [5077] = {.lex_state = 77, .external_lex_state = 5},
  [5078] = {.lex_state = 77, .external_lex_state = 2},
  [5079] = {.lex_state = 77, .external_lex_state = 5},
  [5080] = {.lex_state = 77, .external_lex_state = 2},
  [5081] = {.lex_state = 77, .external_lex_state = 5},
  [5082] = {.lex_state = 77, .external_lex_state = 5},
  [5083] = {.lex_state = 77, .external_lex_state = 5},
  [5084] = {.lex_state = 77, .external_lex_state = 2},
  [5085] = {.lex_state = 77, .external_lex_state = 5},
  [5086] = {.lex_state = 77, .external_lex_state = 2},
  [5087] = {.lex_state = 77, .external_lex_state = 5},
  [5088] = {.lex_state = 77, .external_lex_state = 2},
  [5089] = {.lex_state = 77, .external_lex_state = 2},
  [5090] = {.lex_state = 77, .external_lex_state = 2},
  [5091] = {.lex_state = 77, .external_lex_state = 2},
  [5092] = {.lex_state = 77, .external_lex_state = 2},
  [5093] = {.lex_state = 77, .external_lex_state = 5},
  [5094] = {.lex_state = 77, .external_lex_state = 5},
  [5095] = {.lex_state = 77, .external_lex_state = 5},
  [5096] = {.lex_state = 77, .external_lex_state = 5},
  [5097] = {.lex_state = 9, .external_lex_state = 2},
  [5098] = {.lex_state = 9, .external_lex_state = 2},
  [5099] = {.lex_state = 77, .external_lex_state = 5},
  [5100] = {.lex_state = 77, .external_lex_state = 5},
  [5101] = {.lex_state = 77, .external_lex_state = 2},
  [5102] = {.lex_state = 77, .external_lex_state = 5},
  [5103] = {.lex_state = 77, .external_lex_state = 2},
  [5104] = {.lex_state = 77, .external_lex_state = 2},
  [5105] = {.lex_state = 77, .external_lex_state = 5},
  [5106] = {.lex_state = 77, .external_lex_state = 5},
  [5107] = {.lex_state = 77, .external_lex_state = 5},
  [5108] = {.lex_state = 77, .external_lex_state = 5},
  [5109] = {.lex_state = 77, .external_lex_state = 5},
  [5110] = {.lex_state = 77, .external_lex_state = 5},
  [5111] = {.lex_state = 77, .external_lex_state = 5},
  [5112] = {.lex_state = 77, .external_lex_state = 5},
  [5113] = {.lex_state = 77, .external_lex_state = 5},
  [5114] = {.lex_state = 77, .external_lex_state = 2},
  [5115] = {.lex_state = 77, .external_lex_state = 2},
  [5116] = {.lex_state = 77, .external_lex_state = 5},
  [5117] = {.lex_state = 77, .external_lex_state = 5},
  [5118] = {.lex_state = 4, .external_lex_state = 2},
  [5119] = {.lex_state = 77, .external_lex_state = 5},
  [5120] = {.lex_state = 77, .external_lex_state = 5},
  [5121] = {.lex_state = 77, .external_lex_state = 5},
  [5122] = {.lex_state = 9, .external_lex_state = 2},
  [5123] = {.lex_state = 77, .external_lex_state = 5},
  [5124] = {.lex_state = 77, .external_lex_state = 5},
  [5125] = {.lex_state = 77, .external_lex_state = 2},
  [5126] = {.lex_state = 77, .external_lex_state = 5},
  [5127] = {.lex_state = 77, .external_lex_state = 2},
  [5128] = {.lex_state = 77, .external_lex_state = 5},
  [5129] = {.lex_state = 77, .external_lex_state = 5},
  [5130] = {.lex_state = 77, .external_lex_state = 5},
  [5131] = {.lex_state = 77, .external_lex_state = 5},
  [5132] = {.lex_state = 77, .external_lex_state = 2},
  [5133] = {.lex_state = 9, .external_lex_state = 2},
  [5134] = {.lex_state = 9, .external_lex_state = 2},
  [5135] = {.lex_state = 77, .external_lex_state = 2},
  [5136] = {.lex_state = 77, .external_lex_state = 2},
  [5137] = {.lex_state = 77, .external_lex_state = 2},
  [5138] = {.lex_state = 77, .external_lex_state = 5},
  [5139] = {.lex_state = 16, .external_lex_state = 8},
  [5140] = {.lex_state = 77, .external_lex_state = 2},
  [5141] = {.lex_state = 77, .external_lex_state = 5},
  [5142] = {.lex_state = 77, .external_lex_state = 5},
  [5143] = {.lex_state = 77, .external_lex_state = 5},
  [5144] = {.lex_state = 77, .external_lex_state = 5},
  [5145] = {.lex_state = 77, .external_lex_state = 5},
  [5146] = {.lex_state = 77, .external_lex_state = 5},
  [5147] = {.lex_state = 77, .external_lex_state = 2},
  [5148] = {.lex_state = 77, .external_lex_state = 2},
  [5149] = {.lex_state = 9, .external_lex_state = 2},
  [5150] = {.lex_state = 77, .external_lex_state = 2},
  [5151] = {.lex_state = 77, .external_lex_state = 5},
  [5152] = {.lex_state = 77, .external_lex_state = 2},
  [5153] = {.lex_state = 77, .external_lex_state = 5},
  [5154] = {.lex_state = 77, .external_lex_state = 2},
  [5155] = {.lex_state = 4, .external_lex_state = 2},
  [5156] = {.lex_state = 77, .external_lex_state = 2},
  [5157] = {.lex_state = 77, .external_lex_state = 2},
  [5158] = {.lex_state = 4, .external_lex_state = 2},
  [5159] = {.lex_state = 77, .external_lex_state = 5},
  [5160] = {.lex_state = 77, .external_lex_state = 5},
  [5161] = {.lex_state = 77, .external_lex_state = 5},
  [5162] = {.lex_state = 77, .external_lex_state = 5},
  [5163] = {.lex_state = 77, .external_lex_state = 5},
  [5164] = {.lex_state = 77, .external_lex_state = 2},
  [5165] = {.lex_state = 77, .external_lex_state = 5},
  [5166] = {.lex_state = 77, .external_lex_state = 5},
  [5167] = {.lex_state = 77, .external_lex_state = 5},
  [5168] = {.lex_state = 77, .external_lex_state = 5},
  [5169] = {.lex_state = 77, .external_lex_state = 5},
  [5170] = {.lex_state = 77, .external_lex_state = 5},
  [5171] = {.lex_state = 77, .external_lex_state = 5},
  [5172] = {.lex_state = 77, .external_lex_state = 5},
  [5173] = {.lex_state = 77, .external_lex_state = 5},
  [5174] = {.lex_state = 77, .external_lex_state = 2},
  [5175] = {.lex_state = 77, .external_lex_state = 5},
  [5176] = {.lex_state = 77, .external_lex_state = 5},
  [5177] = {.lex_state = 77, .external_lex_state = 5},
  [5178] = {.lex_state = 77, .external_lex_state = 2},
  [5179] = {.lex_state = 77, .external_lex_state = 5},
  [5180] = {.lex_state = 77, .external_lex_state = 5},
  [5181] = {.lex_state = 77, .external_lex_state = 5},
  [5182] = {.lex_state = 77, .external_lex_state = 5},
  [5183] = {.lex_state = 9, .external_lex_state = 2},
  [5184] = {.lex_state = 77, .external_lex_state = 5},
  [5185] = {.lex_state = 77, .external_lex_state = 2},
  [5186] = {.lex_state = 77, .external_lex_state = 5},
  [5187] = {.lex_state = 9, .external_lex_state = 2},
  [5188] = {.lex_state = 4, .external_lex_state = 2},
  [5189] = {.lex_state = 77, .external_lex_state = 5},
  [5190] = {.lex_state = 77, .external_lex_state = 5},
  [5191] = {.lex_state = 9, .external_lex_state = 2},
  [5192] = {.lex_state = 9, .external_lex_state = 2},
  [5193] = {.lex_state = 77, .external_lex_state = 2},
  [5194] = {.lex_state = 77, .external_lex_state = 5},
  [5195] = {.lex_state = 77, .external_lex_state = 5},
  [5196] = {.lex_state = 77, .external_lex_state = 5},
  [5197] = {.lex_state = 77, .external_lex_state = 5},
  [5198] = {.lex_state = 77, .external_lex_state = 2},
  [5199] = {.lex_state = 9, .external_lex_state = 2},
  [5200] = {.lex_state = 9, .external_lex_state = 2},
  [5201] = {.lex_state = 77, .external_lex_state = 2},
  [5202] = {.lex_state = 77, .external_lex_state = 2},
  [5203] = {.lex_state = 77, .external_lex_state = 2},
  [5204] = {.lex_state = 77, .external_lex_state = 2},
  [5205] = {.lex_state = 77, .external_lex_state = 5},
  [5206] = {.lex_state = 9, .external_lex_state = 2},
  [5207] = {.lex_state = 77, .external_lex_state = 2},
  [5208] = {.lex_state = 77, .external_lex_state = 2},
  [5209] = {.lex_state = 77, .external_lex_state = 2},
  [5210] = {.lex_state = 77, .external_lex_state = 2},
  [5211] = {.lex_state = 77, .external_lex_state = 2},
  [5212] = {.lex_state = 77, .external_lex_state = 5},
  [5213] = {.lex_state = 77, .external_lex_state = 5},
  [5214] = {.lex_state = 77, .external_lex_state = 5},
  [5215] = {.lex_state = 77, .external_lex_state = 2},
  [5216] = {.lex_state = 77, .external_lex_state = 5},
  [5217] = {.lex_state = 77, .external_lex_state = 2},
  [5218] = {.lex_state = 77, .external_lex_state = 5},
  [5219] = {.lex_state = 77, .external_lex_state = 5},
  [5220] = {.lex_state = 77, .external_lex_state = 2},
  [5221] = {.lex_state = 77, .external_lex_state = 5},
  [5222] = {.lex_state = 77, .external_lex_state = 5},
  [5223] = {.lex_state = 77, .external_lex_state = 5},
  [5224] = {.lex_state = 77, .external_lex_state = 2},
  [5225] = {.lex_state = 77, .external_lex_state = 2},
  [5226] = {.lex_state = 11, .external_lex_state = 2},
  [5227] = {.lex_state = 77, .external_lex_state = 5},
  [5228] = {.lex_state = 77, .external_lex_state = 5},
  [5229] = {.lex_state = 77, .external_lex_state = 5},
  [5230] = {.lex_state = 77, .external_lex_state = 5},
  [5231] = {.lex_state = 77, .external_lex_state = 5},
  [5232] = {.lex_state = 77, .external_lex_state = 5},
  [5233] = {.lex_state = 77, .external_lex_state = 5},
  [5234] = {.lex_state = 77, .external_lex_state = 5},
  [5235] = {.lex_state = 77, .external_lex_state = 5},
  [5236] = {.lex_state = 77, .external_lex_state = 2},
  [5237] = {.lex_state = 77, .external_lex_state = 5},
  [5238] = {.lex_state = 77, .external_lex_state = 5},
  [5239] = {.lex_state = 77, .external_lex_state = 5},
  [5240] = {.lex_state = 77, .external_lex_state = 5},
  [5241] = {.lex_state = 77, .external_lex_state = 5},
  [5242] = {.lex_state = 77, .external_lex_state = 5},
  [5243] = {.lex_state = 77, .external_lex_state = 5},
  [5244] = {.lex_state = 77, .external_lex_state = 2},
  [5245] = {.lex_state = 77, .external_lex_state = 2},
  [5246] = {.lex_state = 77, .external_lex_state = 5},
  [5247] = {.lex_state = 77, .external_lex_state = 5},
  [5248] = {.lex_state = 77, .external_lex_state = 5},
  [5249] = {.lex_state = 77, .external_lex_state = 5},
  [5250] = {.lex_state = 77, .external_lex_state = 5},
  [5251] = {.lex_state = 77, .external_lex_state = 2},
  [5252] = {.lex_state = 9, .external_lex_state = 2},
  [5253] = {.lex_state = 77, .external_lex_state = 5},
  [5254] = {.lex_state = 77, .external_lex_state = 5},
  [5255] = {.lex_state = 4, .external_lex_state = 2},
  [5256] = {.lex_state = 77, .external_lex_state = 5},
  [5257] = {.lex_state = 9, .external_lex_state = 2},
  [5258] = {.lex_state = 77, .external_lex_state = 2},
  [5259] = {.lex_state = 77, .external_lex_state = 2},
  [5260] = {.lex_state = 77, .external_lex_state = 2},
  [5261] = {.lex_state = 77, .external_lex_state = 5},
  [5262] = {.lex_state = 77, .external_lex_state = 2},
  [5263] = {.lex_state = 77, .external_lex_state = 2},
  [5264] = {.lex_state = 77, .external_lex_state = 5},
  [5265] = {.lex_state = 77, .external_lex_state = 2},
  [5266] = {.lex_state = 77, .external_lex_state = 5},
  [5267] = {.lex_state = 77, .external_lex_state = 2},
  [5268] = {.lex_state = 77, .external_lex_state = 2},
  [5269] = {.lex_state = 77, .external_lex_state = 5},
  [5270] = {.lex_state = 77, .external_lex_state = 5},
  [5271] = {.lex_state = 77, .external_lex_state = 2},
  [5272] = {.lex_state = 77, .external_lex_state = 2},
  [5273] = {.lex_state = 77, .external_lex_state = 2},
  [5274] = {.lex_state = 77, .external_lex_state = 2},
  [5275] = {.lex_state = 77, .external_lex_state = 5},
  [5276] = {.lex_state = 77, .external_lex_state = 2},
  [5277] = {.lex_state = 77, .external_lex_state = 5},
  [5278] = {.lex_state = 77, .external_lex_state = 2},
  [5279] = {.lex_state = 77, .external_lex_state = 5},
  [5280] = {.lex_state = 77, .external_lex_state = 2},
  [5281] = {.lex_state = 77, .external_lex_state = 5},
  [5282] = {.lex_state = 77, .external_lex_state = 5},
  [5283] = {.lex_state = 77, .external_lex_state = 5},
  [5284] = {.lex_state = 77, .external_lex_state = 5},
  [5285] = {.lex_state = 77, .external_lex_state = 2},
  [5286] = {.lex_state = 77, .external_lex_state = 5},
  [5287] = {.lex_state = 77, .external_lex_state = 5},
  [5288] = {.lex_state = 77, .external_lex_state = 2},
  [5289] = {.lex_state = 77, .external_lex_state = 2},
  [5290] = {.lex_state = 77, .external_lex_state = 2},
  [5291] = {.lex_state = 77, .external_lex_state = 5},
  [5292] = {.lex_state = 77, .external_lex_state = 2},
  [5293] = {.lex_state = 77, .external_lex_state = 2},
  [5294] = {.lex_state = 77, .external_lex_state = 5},
  [5295] = {.lex_state = 77, .external_lex_state = 2},
  [5296] = {.lex_state = 77, .external_lex_state = 5},
  [5297] = {.lex_state = 77, .external_lex_state = 5},
  [5298] = {.lex_state = 77, .external_lex_state = 5},
  [5299] = {.lex_state = 77, .external_lex_state = 5},
  [5300] = {.lex_state = 77, .external_lex_state = 2},
  [5301] = {.lex_state = 77, .external_lex_state = 5},
  [5302] = {.lex_state = 4, .external_lex_state = 2},
  [5303] = {.lex_state = 77, .external_lex_state = 5},
  [5304] = {.lex_state = 77, .external_lex_state = 5},
  [5305] = {.lex_state = 77, .external_lex_state = 2},
  [5306] = {.lex_state = 77, .external_lex_state = 5},
  [5307] = {.lex_state = 77, .external_lex_state = 5},
  [5308] = {.lex_state = 77, .external_lex_state = 5},
  [5309] = {.lex_state = 77, .external_lex_state = 5},
  [5310] = {.lex_state = 77, .external_lex_state = 5},
  [5311] = {.lex_state = 77, .external_lex_state = 2},
  [5312] = {.lex_state = 77, .external_lex_state = 2},
  [5313] = {.lex_state = 77, .external_lex_state = 5},
  [5314] = {.lex_state = 77, .external_lex_state = 5},
  [5315] = {.lex_state = 77, .external_lex_state = 2},
  [5316] = {.lex_state = 77, .external_lex_state = 5},
  [5317] = {.lex_state = 4, .external_lex_state = 2},
  [5318] = {.lex_state = 77, .external_lex_state = 2},
  [5319] = {.lex_state = 77, .external_lex_state = 2},
  [5320] = {.lex_state = 77, .external_lex_state = 5},
  [5321] = {.lex_state = 77, .external_lex_state = 2},
  [5322] = {.lex_state = 77, .external_lex_state = 5},
  [5323] = {.lex_state = 77, .external_lex_state = 5},
  [5324] = {.lex_state = 77, .external_lex_state = 2},
  [5325] = {.lex_state = 77, .external_lex_state = 5},
  [5326] = {.lex_state = 77, .external_lex_state = 5},
  [5327] = {.lex_state = 77, .external_lex_state = 5},
  [5328] = {.lex_state = 77, .external_lex_state = 2},
  [5329] = {.lex_state = 77, .external_lex_state = 2},
  [5330] = {.lex_state = 77, .external_lex_state = 5},
  [5331] = {.lex_state = 77, .external_lex_state = 5},
  [5332] = {.lex_state = 77, .external_lex_state = 2},
  [5333] = {.lex_state = 9, .external_lex_state = 2},
  [5334] = {.lex_state = 77, .external_lex_state = 5},
  [5335] = {.lex_state = 77, .external_lex_state = 5},
  [5336] = {.lex_state = 77, .external_lex_state = 5},
  [5337] = {.lex_state = 77, .external_lex_state = 5},
  [5338] = {.lex_state = 77, .external_lex_state = 2},
  [5339] = {.lex_state = 77, .external_lex_state = 5},
  [5340] = {.lex_state = 77, .external_lex_state = 5},
  [5341] = {.lex_state = 77, .external_lex_state = 5},
  [5342] = {.lex_state = 77, .external_lex_state = 5},
  [5343] = {.lex_state = 77, .external_lex_state = 5},
  [5344] = {.lex_state = 77, .external_lex_state = 5},
  [5345] = {.lex_state = 77, .external_lex_state = 5},
  [5346] = {.lex_state = 77, .external_lex_state = 2},
  [5347] = {.lex_state = 4, .external_lex_state = 5},
  [5348] = {.lex_state = 9, .external_lex_state = 2},
  [5349] = {.lex_state = 77, .external_lex_state = 5},
  [5350] = {.lex_state = 77, .external_lex_state = 5},
  [5351] = {.lex_state = 77, .external_lex_state = 5},
  [5352] = {.lex_state = 77, .external_lex_state = 5},
  [5353] = {.lex_state = 4, .external_lex_state = 5},
  [5354] = {.lex_state = 77, .external_lex_state = 5},
  [5355] = {.lex_state = 77, .external_lex_state = 5},
  [5356] = {.lex_state = 77, .external_lex_state = 5},
  [5357] = {.lex_state = 77, .external_lex_state = 5},
  [5358] = {.lex_state = 77, .external_lex_state = 2},
  [5359] = {.lex_state = 77, .external_lex_state = 2},
  [5360] = {.lex_state = 77, .external_lex_state = 5},
  [5361] = {.lex_state = 77, .external_lex_state = 2},
  [5362] = {.lex_state = 77, .external_lex_state = 5},
  [5363] = {.lex_state = 77, .external_lex_state = 5},
  [5364] = {.lex_state = 77, .external_lex_state = 5},
  [5365] = {.lex_state = 77, .external_lex_state = 2},
  [5366] = {.lex_state = 77, .external_lex_state = 5},
  [5367] = {.lex_state = 77, .external_lex_state = 5},
  [5368] = {.lex_state = 77, .external_lex_state = 5},
  [5369] = {.lex_state = 77, .external_lex_state = 5},
  [5370] = {.lex_state = 77, .external_lex_state = 5},
  [5371] = {.lex_state = 77, .external_lex_state = 5},
  [5372] = {.lex_state = 77, .external_lex_state = 5},
  [5373] = {.lex_state = 77, .external_lex_state = 2},
  [5374] = {.lex_state = 77, .external_lex_state = 2},
  [5375] = {.lex_state = 77, .external_lex_state = 5},
  [5376] = {.lex_state = 77, .external_lex_state = 5},
  [5377] = {.lex_state = 77, .external_lex_state = 2},
  [5378] = {.lex_state = 77, .external_lex_state = 5},
  [5379] = {.lex_state = 77, .external_lex_state = 5},
  [5380] = {.lex_state = 77, .external_lex_state = 2},
  [5381] = {.lex_state = 77, .external_lex_state = 5},
  [5382] = {.lex_state = 77, .external_lex_state = 5},
  [5383] = {.lex_state = 77, .external_lex_state = 5},
  [5384] = {.lex_state = 77, .external_lex_state = 5},
  [5385] = {.lex_state = 77, .external_lex_state = 5},
  [5386] = {.lex_state = 77, .external_lex_state = 5},
  [5387] = {.lex_state = 77, .external_lex_state = 5},
  [5388] = {.lex_state = 77, .external_lex_state = 5},
  [5389] = {.lex_state = 77, .external_lex_state = 5},
  [5390] = {.lex_state = 77, .external_lex_state = 5},
  [5391] = {.lex_state = 77, .external_lex_state = 5},
  [5392] = {.lex_state = 77, .external_lex_state = 5},
  [5393] = {.lex_state = 77, .external_lex_state = 5},
  [5394] = {.lex_state = 77, .external_lex_state = 5},
  [5395] = {.lex_state = 77, .external_lex_state = 5},
  [5396] = {.lex_state = 77, .external_lex_state = 5},
  [5397] = {.lex_state = 4, .external_lex_state = 5},
  [5398] = {.lex_state = 4, .external_lex_state = 5},
  [5399] = {.lex_state = 77, .external_lex_state = 5},
  [5400] = {.lex_state = 77, .external_lex_state = 5},
  [5401] = {.lex_state = 77, .external_lex_state = 5},
  [5402] = {.lex_state = 77, .external_lex_state = 5},
  [5403] = {.lex_state = 77, .external_lex_state = 5},
  [5404] = {.lex_state = 4, .external_lex_state = 2},
  [5405] = {.lex_state = 77, .external_lex_state = 5},
  [5406] = {.lex_state = 77, .external_lex_state = 5},
  [5407] = {.lex_state = 77, .external_lex_state = 5},
  [5408] = {.lex_state = 77, .external_lex_state = 5},
  [5409] = {.lex_state = 77, .external_lex_state = 5},
  [5410] = {.lex_state = 77, .external_lex_state = 5},
  [5411] = {.lex_state = 77, .external_lex_state = 5},
  [5412] = {.lex_state = 77, .external_lex_state = 2},
  [5413] = {.lex_state = 77, .external_lex_state = 5},
  [5414] = {.lex_state = 77, .external_lex_state = 2},
  [5415] = {.lex_state = 77, .external_lex_state = 5},
  [5416] = {.lex_state = 77, .external_lex_state = 5},
  [5417] = {.lex_state = 77, .external_lex_state = 5},
  [5418] = {.lex_state = 77, .external_lex_state = 2},
  [5419] = {.lex_state = 77, .external_lex_state = 2},
  [5420] = {.lex_state = 77, .external_lex_state = 5},
  [5421] = {.lex_state = 77, .external_lex_state = 5},
  [5422] = {.lex_state = 4, .external_lex_state = 2},
  [5423] = {.lex_state = 77, .external_lex_state = 2},
  [5424] = {.lex_state = 77, .external_lex_state = 2},
  [5425] = {.lex_state = 77, .external_lex_state = 5},
  [5426] = {.lex_state = 77, .external_lex_state = 5},
  [5427] = {.lex_state = 77, .external_lex_state = 5},
  [5428] = {.lex_state = 77, .external_lex_state = 5},
  [5429] = {.lex_state = 77, .external_lex_state = 2},
  [5430] = {.lex_state = 77, .external_lex_state = 2},
  [5431] = {.lex_state = 77, .external_lex_state = 5},
  [5432] = {.lex_state = 77, .external_lex_state = 5},
  [5433] = {.lex_state = 77, .external_lex_state = 5},
  [5434] = {.lex_state = 77, .external_lex_state = 5},
  [5435] = {.lex_state = 77, .external_lex_state = 2},
  [5436] = {.lex_state = 77, .external_lex_state = 5},
  [5437] = {.lex_state = 9, .external_lex_state = 2},
  [5438] = {.lex_state = 77, .external_lex_state = 2},
  [5439] = {.lex_state = 77, .external_lex_state = 5},
  [5440] = {.lex_state = 77, .external_lex_state = 2},
  [5441] = {.lex_state = 9, .external_lex_state = 2},
  [5442] = {.lex_state = 12, .external_lex_state = 2},
  [5443] = {.lex_state = 77, .external_lex_state = 5},
  [5444] = {.lex_state = 77, .external_lex_state = 5},
  [5445] = {.lex_state = 77, .external_lex_state = 5},
  [5446] = {.lex_state = 77, .external_lex_state = 5},
  [5447] = {.lex_state = 77, .external_lex_state = 5},
  [5448] = {.lex_state = 77, .external_lex_state = 5},
  [5449] = {.lex_state = 77, .external_lex_state = 5},
  [5450] = {.lex_state = 77, .external_lex_state = 5},
  [5451] = {.lex_state = 77, .external_lex_state = 5},
  [5452] = {.lex_state = 77, .external_lex_state = 5},
  [5453] = {.lex_state = 77, .external_lex_state = 2},
  [5454] = {.lex_state = 77, .external_lex_state = 5},
  [5455] = {.lex_state = 77, .external_lex_state = 5},
  [5456] = {.lex_state = 77, .external_lex_state = 5},
  [5457] = {.lex_state = 9, .external_lex_state = 2},
  [5458] = {.lex_state = 77, .external_lex_state = 5},
  [5459] = {.lex_state = 77, .external_lex_state = 5},
  [5460] = {.lex_state = 77, .external_lex_state = 2},
  [5461] = {.lex_state = 9, .external_lex_state = 2},
  [5462] = {.lex_state = 77, .external_lex_state = 5},
  [5463] = {.lex_state = 77, .external_lex_state = 5},
  [5464] = {.lex_state = 77, .external_lex_state = 2},
  [5465] = {.lex_state = 77, .external_lex_state = 5},
  [5466] = {.lex_state = 77, .external_lex_state = 5},
  [5467] = {.lex_state = 77, .external_lex_state = 5},
  [5468] = {.lex_state = 77, .external_lex_state = 2},
  [5469] = {.lex_state = 77, .external_lex_state = 5},
  [5470] = {.lex_state = 77, .external_lex_state = 5},
  [5471] = {.lex_state = 77, .external_lex_state = 5},
  [5472] = {.lex_state = 77, .external_lex_state = 5},
  [5473] = {.lex_state = 77, .external_lex_state = 5},
  [5474] = {.lex_state = 77, .external_lex_state = 5},
  [5475] = {.lex_state = 77, .external_lex_state = 5},
  [5476] = {.lex_state = 77, .external_lex_state = 5},
  [5477] = {.lex_state = 77, .external_lex_state = 5},
  [5478] = {.lex_state = 77, .external_lex_state = 2},
  [5479] = {.lex_state = 77, .external_lex_state = 5},
  [5480] = {.lex_state = 77, .external_lex_state = 5},
  [5481] = {.lex_state = 77, .external_lex_state = 5},
  [5482] = {.lex_state = 77, .external_lex_state = 2},
  [5483] = {.lex_state = 77, .external_lex_state = 5},
  [5484] = {.lex_state = 77, .external_lex_state = 2},
  [5485] = {.lex_state = 77, .external_lex_state = 5},
  [5486] = {.lex_state = 77, .external_lex_state = 5},
  [5487] = {.lex_state = 77, .external_lex_state = 5},
  [5488] = {.lex_state = 77, .external_lex_state = 5},
  [5489] = {.lex_state = 77, .external_lex_state = 5},
  [5490] = {.lex_state = 77, .external_lex_state = 5},
  [5491] = {.lex_state = 77, .external_lex_state = 5},
  [5492] = {.lex_state = 77, .external_lex_state = 5},
  [5493] = {.lex_state = 77, .external_lex_state = 5},
  [5494] = {.lex_state = 77, .external_lex_state = 5},
  [5495] = {.lex_state = 77, .external_lex_state = 5},
  [5496] = {.lex_state = 77, .external_lex_state = 5},
  [5497] = {.lex_state = 77, .external_lex_state = 5},
  [5498] = {.lex_state = 77, .external_lex_state = 5},
  [5499] = {.lex_state = 77, .external_lex_state = 5},
  [5500] = {.lex_state = 77, .external_lex_state = 5},
  [5501] = {.lex_state = 77, .external_lex_state = 5},
  [5502] = {.lex_state = 77, .external_lex_state = 2},
  [5503] = {.lex_state = 77, .external_lex_state = 5},
  [5504] = {.lex_state = 77, .external_lex_state = 5},
  [5505] = {.lex_state = 77, .external_lex_state = 5},
  [5506] = {.lex_state = 9, .external_lex_state = 2},
  [5507] = {.lex_state = 77, .external_lex_state = 5},
  [5508] = {.lex_state = 77, .external_lex_state = 5},
  [5509] = {.lex_state = 77, .external_lex_state = 5},
  [5510] = {.lex_state = 77, .external_lex_state = 5},
  [5511] = {.lex_state = 77, .external_lex_state = 5},
  [5512] = {.lex_state = 77, .external_lex_state = 2},
  [5513] = {.lex_state = 77, .external_lex_state = 5},
  [5514] = {.lex_state = 9, .external_lex_state = 2},
  [5515] = {.lex_state = 77, .external_lex_state = 2},
  [5516] = {.lex_state = 77, .external_lex_state = 5},
  [5517] = {.lex_state = 77, .external_lex_state = 5},
  [5518] = {.lex_state = 77, .external_lex_state = 5},
  [5519] = {.lex_state = 77, .external_lex_state = 2},
  [5520] = {.lex_state = 9, .external_lex_state = 2},
  [5521] = {.lex_state = 77, .external_lex_state = 5},
  [5522] = {.lex_state = 77, .external_lex_state = 5},
  [5523] = {.lex_state = 77, .external_lex_state = 2},
  [5524] = {.lex_state = 77, .external_lex_state = 2},
  [5525] = {.lex_state = 77, .external_lex_state = 2},
  [5526] = {.lex_state = 77, .external_lex_state = 5},
  [5527] = {.lex_state = 77, .external_lex_state = 2},
  [5528] = {.lex_state = 77, .external_lex_state = 5},
  [5529] = {.lex_state = 77, .external_lex_state = 5},
  [5530] = {.lex_state = 77, .external_lex_state = 5},
  [5531] = {.lex_state = 77, .external_lex_state = 5},
  [5532] = {.lex_state = 77, .external_lex_state = 5},
  [5533] = {.lex_state = 77, .external_lex_state = 5},
  [5534] = {.lex_state = 77, .external_lex_state = 2},
  [5535] = {.lex_state = 77, .external_lex_state = 5},
  [5536] = {.lex_state = 77, .external_lex_state = 5},
  [5537] = {.lex_state = 77, .external_lex_state = 5},
  [5538] = {.lex_state = 77, .external_lex_state = 2},
  [5539] = {.lex_state = 77, .external_lex_state = 5},
  [5540] = {.lex_state = 77, .external_lex_state = 5},
  [5541] = {.lex_state = 77, .external_lex_state = 5},
  [5542] = {.lex_state = 77, .external_lex_state = 5},
  [5543] = {.lex_state = 77, .external_lex_state = 5},
  [5544] = {.lex_state = 77, .external_lex_state = 5},
  [5545] = {.lex_state = 77, .external_lex_state = 5},
  [5546] = {.lex_state = 77, .external_lex_state = 5},
  [5547] = {.lex_state = 77, .external_lex_state = 5},
  [5548] = {.lex_state = 77, .external_lex_state = 5},
  [5549] = {.lex_state = 77, .external_lex_state = 2},
  [5550] = {.lex_state = 77, .external_lex_state = 5},
  [5551] = {.lex_state = 4, .external_lex_state = 2},
  [5552] = {.lex_state = 77, .external_lex_state = 2},
  [5553] = {.lex_state = 77, .external_lex_state = 5},
  [5554] = {.lex_state = 77, .external_lex_state = 5},
  [5555] = {.lex_state = 77, .external_lex_state = 5},
  [5556] = {.lex_state = 77, .external_lex_state = 5},
  [5557] = {.lex_state = 77, .external_lex_state = 5},
  [5558] = {.lex_state = 4, .external_lex_state = 2},
  [5559] = {.lex_state = 77, .external_lex_state = 5},
  [5560] = {.lex_state = 77, .external_lex_state = 5},
  [5561] = {.lex_state = 77, .external_lex_state = 2},
  [5562] = {.lex_state = 77, .external_lex_state = 5},
  [5563] = {.lex_state = 77, .external_lex_state = 5},
  [5564] = {.lex_state = 4, .external_lex_state = 2},
  [5565] = {.lex_state = 77, .external_lex_state = 5},
  [5566] = {.lex_state = 77, .external_lex_state = 5},
  [5567] = {.lex_state = 77, .external_lex_state = 5},
  [5568] = {.lex_state = 77, .external_lex_state = 5},
  [5569] = {.lex_state = 77, .external_lex_state = 5},
  [5570] = {.lex_state = 77, .external_lex_state = 5},
  [5571] = {.lex_state = 77, .external_lex_state = 5},
  [5572] = {.lex_state = 77, .external_lex_state = 5},
  [5573] = {.lex_state = 77, .external_lex_state = 5},
  [5574] = {.lex_state = 9, .external_lex_state = 2},
  [5575] = {.lex_state = 77, .external_lex_state = 5},
  [5576] = {.lex_state = 77, .external_lex_state = 2},
  [5577] = {.lex_state = 77, .external_lex_state = 5},
  [5578] = {.lex_state = 77, .external_lex_state = 5},
  [5579] = {.lex_state = 77, .external_lex_state = 5},
  [5580] = {.lex_state = 77, .external_lex_state = 5},
  [5581] = {.lex_state = 77, .external_lex_state = 5},
  [5582] = {.lex_state = 77, .external_lex_state = 5},
  [5583] = {.lex_state = 77, .external_lex_state = 5},
  [5584] = {.lex_state = 77, .external_lex_state = 5},
  [5585] = {.lex_state = 77, .external_lex_state = 5},
  [5586] = {.lex_state = 77, .external_lex_state = 5},
  [5587] = {.lex_state = 77, .external_lex_state = 5},
  [5588] = {.lex_state = 77, .external_lex_state = 5},
  [5589] = {.lex_state = 77, .external_lex_state = 5},
  [5590] = {.lex_state = 77, .external_lex_state = 5},
  [5591] = {.lex_state = 77, .external_lex_state = 5},
  [5592] = {.lex_state = 77, .external_lex_state = 5},
  [5593] = {.lex_state = 77, .external_lex_state = 2},
  [5594] = {.lex_state = 77, .external_lex_state = 2},
  [5595] = {.lex_state = 77, .external_lex_state = 5},
  [5596] = {.lex_state = 77, .external_lex_state = 5},
  [5597] = {.lex_state = 9, .external_lex_state = 2},
  [5598] = {.lex_state = 77, .external_lex_state = 5},
  [5599] = {.lex_state = 77, .external_lex_state = 5},
  [5600] = {.lex_state = 77, .external_lex_state = 5},
  [5601] = {.lex_state = 77, .external_lex_state = 2},
  [5602] = {.lex_state = 77, .external_lex_state = 5},
  [5603] = {.lex_state = 77, .external_lex_state = 5},
  [5604] = {.lex_state = 77, .external_lex_state = 2},
  [5605] = {.lex_state = 77, .external_lex_state = 5},
  [5606] = {.lex_state = 77, .external_lex_state = 5},
  [5607] = {.lex_state = 77, .external_lex_state = 5},
  [5608] = {.lex_state = 77, .external_lex_state = 5},
  [5609] = {.lex_state = 77, .external_lex_state = 5},
  [5610] = {.lex_state = 77, .external_lex_state = 5},
  [5611] = {.lex_state = 77, .external_lex_state = 5},
  [5612] = {.lex_state = 77, .external_lex_state = 5},
  [5613] = {.lex_state = 77, .external_lex_state = 5},
  [5614] = {.lex_state = 77, .external_lex_state = 5},
  [5615] = {.lex_state = 77, .external_lex_state = 5},
  [5616] = {.lex_state = 77, .external_lex_state = 5},
  [5617] = {.lex_state = 77, .external_lex_state = 2},
  [5618] = {.lex_state = 77, .external_lex_state = 5},
  [5619] = {.lex_state = 77, .external_lex_state = 2},
  [5620] = {.lex_state = 77, .external_lex_state = 5},
  [5621] = {.lex_state = 77, .external_lex_state = 2},
  [5622] = {.lex_state = 9, .external_lex_state = 2},
  [5623] = {.lex_state = 77, .external_lex_state = 2},
  [5624] = {.lex_state = 9, .external_lex_state = 2},
  [5625] = {.lex_state = 9, .external_lex_state = 2},
  [5626] = {.lex_state = 77, .external_lex_state = 2},
  [5627] = {.lex_state = 77, .external_lex_state = 2},
  [5628] = {.lex_state = 77, .external_lex_state = 5},
  [5629] = {.lex_state = 9, .external_lex_state = 2},
  [5630] = {.lex_state = 77, .external_lex_state = 2},
  [5631] = {.lex_state = 77, .external_lex_state = 5},
  [5632] = {.lex_state = 9, .external_lex_state = 2},
  [5633] = {.lex_state = 9, .external_lex_state = 2},
  [5634] = {.lex_state = 77, .external_lex_state = 2},
  [5635] = {.lex_state = 9, .external_lex_state = 2},
  [5636] = {.lex_state = 9, .external_lex_state = 2},
  [5637] = {.lex_state = 9, .external_lex_state = 2},
  [5638] = {.lex_state = 9, .external_lex_state = 2},
  [5639] = {.lex_state = 9, .external_lex_state = 2},
  [5640] = {.lex_state = 77, .external_lex_state = 2},
  [5641] = {.lex_state = 77, .external_lex_state = 5},
  [5642] = {.lex_state = 9, .external_lex_state = 2},
  [5643] = {.lex_state = 9, .external_lex_state = 2},
  [5644] = {.lex_state = 9, .external_lex_state = 2},
  [5645] = {.lex_state = 9, .external_lex_state = 2},
  [5646] = {.lex_state = 77, .external_lex_state = 2},
  [5647] = {.lex_state = 9, .external_lex_state = 2},
  [5648] = {.lex_state = 77, .external_lex_state = 5},
  [5649] = {.lex_state = 9, .external_lex_state = 2},
  [5650] = {.lex_state = 77, .external_lex_state = 5},
  [5651] = {.lex_state = 9, .external_lex_state = 2},
  [5652] = {.lex_state = 77, .external_lex_state = 5},
  [5653] = {.lex_state = 77, .external_lex_state = 5},
  [5654] = {.lex_state = 77, .external_lex_state = 2},
  [5655] = {.lex_state = 9, .external_lex_state = 2},
  [5656] = {.lex_state = 77, .external_lex_state = 2},
  [5657] = {.lex_state = 77, .external_lex_state = 2},
  [5658] = {.lex_state = 77, .external_lex_state = 2},
  [5659] = {.lex_state = 77, .external_lex_state = 5},
  [5660] = {.lex_state = 77, .external_lex_state = 5},
  [5661] = {.lex_state = 9, .external_lex_state = 2},
  [5662] = {.lex_state = 77, .external_lex_state = 2},
  [5663] = {.lex_state = 9, .external_lex_state = 2},
  [5664] = {.lex_state = 77, .external_lex_state = 2},
  [5665] = {.lex_state = 77, .external_lex_state = 2},
  [5666] = {.lex_state = 77, .external_lex_state = 2},
  [5667] = {.lex_state = 9, .external_lex_state = 2},
  [5668] = {.lex_state = 77, .external_lex_state = 2},
  [5669] = {.lex_state = 77, .external_lex_state = 2},
  [5670] = {.lex_state = 77, .external_lex_state = 2},
  [5671] = {.lex_state = 77, .external_lex_state = 5},
  [5672] = {.lex_state = 77, .external_lex_state = 5},
  [5673] = {.lex_state = 77, .external_lex_state = 5},
  [5674] = {.lex_state = 77, .external_lex_state = 2},
  [5675] = {.lex_state = 9, .external_lex_state = 2},
  [5676] = {.lex_state = 77, .external_lex_state = 2},
  [5677] = {.lex_state = 9, .external_lex_state = 2},
  [5678] = {.lex_state = 9, .external_lex_state = 2},
  [5679] = {.lex_state = 77, .external_lex_state = 2},
  [5680] = {.lex_state = 77, .external_lex_state = 5},
  [5681] = {.lex_state = 77, .external_lex_state = 2},
  [5682] = {.lex_state = 77, .external_lex_state = 5},
  [5683] = {.lex_state = 77, .external_lex_state = 5},
  [5684] = {.lex_state = 77, .external_lex_state = 5},
  [5685] = {.lex_state = 77, .external_lex_state = 2},
  [5686] = {.lex_state = 9, .external_lex_state = 2},
  [5687] = {.lex_state = 77, .external_lex_state = 2},
  [5688] = {.lex_state = 77, .external_lex_state = 2},
  [5689] = {.lex_state = 77, .external_lex_state = 2},
  [5690] = {.lex_state = 9, .external_lex_state = 2},
  [5691] = {.lex_state = 77, .external_lex_state = 2},
  [5692] = {.lex_state = 77, .external_lex_state = 2},
  [5693] = {.lex_state = 9, .external_lex_state = 2},
  [5694] = {.lex_state = 77, .external_lex_state = 2},
  [5695] = {.lex_state = 77, .external_lex_state = 2},
  [5696] = {.lex_state = 77, .external_lex_state = 2},
  [5697] = {.lex_state = 77, .external_lex_state = 2},
  [5698] = {.lex_state = 77, .external_lex_state = 5},
  [5699] = {.lex_state = 77, .external_lex_state = 5},
  [5700] = {.lex_state = 77, .external_lex_state = 2},
  [5701] = {.lex_state = 9, .external_lex_state = 2},
  [5702] = {.lex_state = 77, .external_lex_state = 5},
  [5703] = {.lex_state = 4, .external_lex_state = 2},
  [5704] = {.lex_state = 77, .external_lex_state = 2},
  [5705] = {.lex_state = 9, .external_lex_state = 2},
  [5706] = {.lex_state = 77, .external_lex_state = 2},
  [5707] = {.lex_state = 9, .external_lex_state = 2},
  [5708] = {.lex_state = 9, .external_lex_state = 2},
  [5709] = {.lex_state = 9, .external_lex_state = 2},
  [5710] = {.lex_state = 9, .external_lex_state = 2},
  [5711] = {.lex_state = 9, .external_lex_state = 2},
  [5712] = {.lex_state = 9, .external_lex_state = 2},
  [5713] = {.lex_state = 77, .external_lex_state = 2},
  [5714] = {.lex_state = 77, .external_lex_state = 2},
  [5715] = {.lex_state = 77, .external_lex_state = 2},
  [5716] = {.lex_state = 9, .external_lex_state = 2},
  [5717] = {.lex_state = 9, .external_lex_state = 2},
  [5718] = {.lex_state = 77, .external_lex_state = 2},
  [5719] = {.lex_state = 77, .external_lex_state = 5},
  [5720] = {.lex_state = 77, .external_lex_state = 2},
  [5721] = {.lex_state = 9, .external_lex_state = 2},
  [5722] = {.lex_state = 9, .external_lex_state = 2},
  [5723] = {.lex_state = 77, .external_lex_state = 2},
  [5724] = {.lex_state = 77, .external_lex_state = 5},
  [5725] = {.lex_state = 77, .external_lex_state = 5},
  [5726] = {.lex_state = 9, .external_lex_state = 2},
  [5727] = {.lex_state = 77, .external_lex_state = 2},
  [5728] = {.lex_state = 77, .external_lex_state = 2},
  [5729] = {.lex_state = 77, .external_lex_state = 2},
  [5730] = {.lex_state = 9, .external_lex_state = 2},
  [5731] = {.lex_state = 77, .external_lex_state = 5},
  [5732] = {.lex_state = 9, .external_lex_state = 2},
  [5733] = {.lex_state = 77, .external_lex_state = 2},
  [5734] = {.lex_state = 9, .external_lex_state = 2},
  [5735] = {.lex_state = 77, .external_lex_state = 2},
  [5736] = {.lex_state = 77, .external_lex_state = 2},
  [5737] = {.lex_state = 9, .external_lex_state = 2},
  [5738] = {.lex_state = 77, .external_lex_state = 2},
  [5739] = {.lex_state = 77, .external_lex_state = 2},
  [5740] = {.lex_state = 9, .external_lex_state = 2},
  [5741] = {.lex_state = 77, .external_lex_state = 2},
  [5742] = {.lex_state = 77, .external_lex_state = 5},
  [5743] = {.lex_state = 77, .external_lex_state = 5},
  [5744] = {.lex_state = 9, .external_lex_state = 2},
  [5745] = {.lex_state = 9, .external_lex_state = 2},
  [5746] = {.lex_state = 77, .external_lex_state = 2},
  [5747] = {.lex_state = 9, .external_lex_state = 2},
  [5748] = {.lex_state = 9, .external_lex_state = 2},
  [5749] = {.lex_state = 77, .external_lex_state = 2},
  [5750] = {.lex_state = 77, .external_lex_state = 2},
  [5751] = {.lex_state = 77, .external_lex_state = 2},
  [5752] = {.lex_state = 77, .external_lex_state = 2},
  [5753] = {.lex_state = 9, .external_lex_state = 2},
  [5754] = {.lex_state = 9, .external_lex_state = 2},
  [5755] = {.lex_state = 9, .external_lex_state = 2},
  [5756] = {.lex_state = 9, .external_lex_state = 2},
  [5757] = {.lex_state = 9, .external_lex_state = 2},
  [5758] = {.lex_state = 77, .external_lex_state = 2},
  [5759] = {.lex_state = 77, .external_lex_state = 2},
  [5760] = {.lex_state = 9, .external_lex_state = 2},
  [5761] = {.lex_state = 77, .external_lex_state = 2},
  [5762] = {.lex_state = 77, .external_lex_state = 2},
  [5763] = {.lex_state = 77, .external_lex_state = 5},
  [5764] = {.lex_state = 77, .external_lex_state = 2},
  [5765] = {.lex_state = 77, .external_lex_state = 2},
  [5766] = {.lex_state = 9, .external_lex_state = 2},
  [5767] = {.lex_state = 9, .external_lex_state = 2},
  [5768] = {.lex_state = 77, .external_lex_state = 2},
  [5769] = {.lex_state = 77, .external_lex_state = 2},
  [5770] = {.lex_state = 77, .external_lex_state = 2},
  [5771] = {.lex_state = 77, .external_lex_state = 2},
  [5772] = {.lex_state = 77, .external_lex_state = 2},
  [5773] = {.lex_state = 77, .external_lex_state = 2},
  [5774] = {.lex_state = 77, .external_lex_state = 5},
  [5775] = {.lex_state = 77, .external_lex_state = 2},
  [5776] = {.lex_state = 77, .external_lex_state = 5},
  [5777] = {.lex_state = 77, .external_lex_state = 2},
  [5778] = {.lex_state = 9, .external_lex_state = 2},
  [5779] = {.lex_state = 77, .external_lex_state = 5},
  [5780] = {.lex_state = 77, .external_lex_state = 2},
  [5781] = {.lex_state = 77, .external_lex_state = 2},
  [5782] = {.lex_state = 77, .external_lex_state = 2},
  [5783] = {.lex_state = 77, .external_lex_state = 5},
  [5784] = {.lex_state = 77, .external_lex_state = 5},
  [5785] = {.lex_state = 77, .external_lex_state = 2},
  [5786] = {.lex_state = 9, .external_lex_state = 2},
  [5787] = {.lex_state = 77, .external_lex_state = 2},
  [5788] = {.lex_state = 9, .external_lex_state = 2},
  [5789] = {.lex_state = 77, .external_lex_state = 2},
  [5790] = {.lex_state = 9, .external_lex_state = 2},
  [5791] = {.lex_state = 9, .external_lex_state = 2},
  [5792] = {.lex_state = 77, .external_lex_state = 2},
  [5793] = {.lex_state = 77, .external_lex_state = 2},
  [5794] = {.lex_state = 77, .external_lex_state = 2},
  [5795] = {.lex_state = 77, .external_lex_state = 2},
  [5796] = {.lex_state = 9, .external_lex_state = 2},
  [5797] = {.lex_state = 9, .external_lex_state = 2},
  [5798] = {.lex_state = 77, .external_lex_state = 5},
  [5799] = {.lex_state = 77, .external_lex_state = 5},
  [5800] = {.lex_state = 9, .external_lex_state = 2},
  [5801] = {.lex_state = 9, .external_lex_state = 2},
  [5802] = {.lex_state = 9, .external_lex_state = 2},
  [5803] = {.lex_state = 9, .external_lex_state = 2},
  [5804] = {.lex_state = 77, .external_lex_state = 2},
  [5805] = {.lex_state = 77, .external_lex_state = 5},
  [5806] = {.lex_state = 9, .external_lex_state = 2},
  [5807] = {.lex_state = 77, .external_lex_state = 2},
  [5808] = {.lex_state = 9, .external_lex_state = 2},
  [5809] = {.lex_state = 9, .external_lex_state = 2},
  [5810] = {.lex_state = 9, .external_lex_state = 2},
  [5811] = {.lex_state = 77, .external_lex_state = 5},
  [5812] = {.lex_state = 9, .external_lex_state = 2},
  [5813] = {.lex_state = 9, .external_lex_state = 2},
  [5814] = {.lex_state = 77, .external_lex_state = 5},
  [5815] = {.lex_state = 9, .external_lex_state = 2},
  [5816] = {.lex_state = 9, .external_lex_state = 2},
  [5817] = {.lex_state = 77, .external_lex_state = 5},
  [5818] = {.lex_state = 77, .external_lex_state = 5},
  [5819] = {.lex_state = 9, .external_lex_state = 2},
  [5820] = {.lex_state = 9, .external_lex_state = 2},
  [5821] = {.lex_state = 77, .external_lex_state = 5},
  [5822] = {.lex_state = 77, .external_lex_state = 5},
  [5823] = {.lex_state = 9, .external_lex_state = 2},
  [5824] = {.lex_state = 9, .external_lex_state = 2},
  [5825] = {.lex_state = 11, .external_lex_state = 2},
  [5826] = {.lex_state = 77, .external_lex_state = 5},
  [5827] = {.lex_state = 77, .external_lex_state = 5},
  [5828] = {.lex_state = 9, .external_lex_state = 2},
  [5829] = {.lex_state = 9, .external_lex_state = 2},
  [5830] = {.lex_state = 77, .external_lex_state = 2},
  [5831] = {.lex_state = 77, .external_lex_state = 2},
  [5832] = {.lex_state = 77, .external_lex_state = 2},
  [5833] = {.lex_state = 77, .external_lex_state = 5},
  [5834] = {.lex_state = 77, .external_lex_state = 5},
  [5835] = {.lex_state = 77, .external_lex_state = 2},
  [5836] = {.lex_state = 9, .external_lex_state = 2},
  [5837] = {.lex_state = 77, .external_lex_state = 2},
  [5838] = {.lex_state = 9, .external_lex_state = 2},
  [5839] = {.lex_state = 9, .external_lex_state = 2},
  [5840] = {.lex_state = 9, .external_lex_state = 2},
  [5841] = {.lex_state = 9, .external_lex_state = 2},
  [5842] = {.lex_state = 9, .external_lex_state = 2},
  [5843] = {.lex_state = 9, .external_lex_state = 2},
  [5844] = {.lex_state = 77, .external_lex_state = 2},
  [5845] = {.lex_state = 77, .external_lex_state = 5},
  [5846] = {.lex_state = 77, .external_lex_state = 2},
  [5847] = {.lex_state = 77, .external_lex_state = 2},
  [5848] = {.lex_state = 9, .external_lex_state = 2},
  [5849] = {.lex_state = 77, .external_lex_state = 2},
  [5850] = {.lex_state = 77, .external_lex_state = 2},
  [5851] = {.lex_state = 9, .external_lex_state = 2},
  [5852] = {.lex_state = 77, .external_lex_state = 2},
  [5853] = {.lex_state = 9, .external_lex_state = 2},
  [5854] = {.lex_state = 77, .external_lex_state = 2},
  [5855] = {.lex_state = 77, .external_lex_state = 2},
  [5856] = {.lex_state = 77, .external_lex_state = 5},
  [5857] = {.lex_state = 77, .external_lex_state = 2},
  [5858] = {.lex_state = 9, .external_lex_state = 2},
  [5859] = {.lex_state = 77, .external_lex_state = 2},
  [5860] = {.lex_state = 77, .external_lex_state = 2},
  [5861] = {.lex_state = 77, .external_lex_state = 5},
  [5862] = {.lex_state = 9, .external_lex_state = 2},
  [5863] = {.lex_state = 9, .external_lex_state = 2},
  [5864] = {.lex_state = 77, .external_lex_state = 5},
  [5865] = {.lex_state = 77, .external_lex_state = 2},
  [5866] = {.lex_state = 77, .external_lex_state = 2},
  [5867] = {.lex_state = 9, .external_lex_state = 2},
  [5868] = {.lex_state = 77, .external_lex_state = 2},
  [5869] = {.lex_state = 77, .external_lex_state = 5},
  [5870] = {.lex_state = 77, .external_lex_state = 2},
  [5871] = {.lex_state = 9, .external_lex_state = 2},
  [5872] = {.lex_state = 77, .external_lex_state = 2},
  [5873] = {.lex_state = 77, .external_lex_state = 5},
  [5874] = {.lex_state = 77, .external_lex_state = 2},
  [5875] = {.lex_state = 9, .external_lex_state = 2},
  [5876] = {.lex_state = 9, .external_lex_state = 2},
  [5877] = {.lex_state = 9, .external_lex_state = 2},
  [5878] = {.lex_state = 77, .external_lex_state = 2},
  [5879] = {.lex_state = 9, .external_lex_state = 2},
  [5880] = {.lex_state = 9, .external_lex_state = 2},
  [5881] = {.lex_state = 9, .external_lex_state = 2},
  [5882] = {.lex_state = 9, .external_lex_state = 2},
  [5883] = {.lex_state = 77, .external_lex_state = 2},
  [5884] = {.lex_state = 77, .external_lex_state = 5},
  [5885] = {.lex_state = 77, .external_lex_state = 2},
  [5886] = {.lex_state = 77, .external_lex_state = 2},
  [5887] = {.lex_state = 77, .external_lex_state = 2},
  [5888] = {.lex_state = 77, .external_lex_state = 2},
  [5889] = {.lex_state = 9, .external_lex_state = 2},
  [5890] = {.lex_state = 77, .external_lex_state = 2},
  [5891] = {.lex_state = 9, .external_lex_state = 2},
  [5892] = {.lex_state = 9, .external_lex_state = 2},
  [5893] = {.lex_state = 77, .external_lex_state = 2},
  [5894] = {.lex_state = 9, .external_lex_state = 2},
  [5895] = {.lex_state = 9, .external_lex_state = 2},
  [5896] = {.lex_state = 77, .external_lex_state = 5},
  [5897] = {.lex_state = 9, .external_lex_state = 2},
  [5898] = {.lex_state = 77, .external_lex_state = 2},
  [5899] = {.lex_state = 9, .external_lex_state = 2},
  [5900] = {.lex_state = 9, .external_lex_state = 2},
  [5901] = {.lex_state = 9, .external_lex_state = 2},
  [5902] = {.lex_state = 9, .external_lex_state = 2},
  [5903] = {.lex_state = 9, .external_lex_state = 2},
  [5904] = {.lex_state = 77, .external_lex_state = 2},
  [5905] = {.lex_state = 77, .external_lex_state = 5},
  [5906] = {.lex_state = 9, .external_lex_state = 2},
  [5907] = {.lex_state = 77, .external_lex_state = 2},
  [5908] = {.lex_state = 9, .external_lex_state = 2},
  [5909] = {.lex_state = 9, .external_lex_state = 2},
  [5910] = {.lex_state = 77, .external_lex_state = 5},
  [5911] = {.lex_state = 9, .external_lex_state = 2},
  [5912] = {.lex_state = 77, .external_lex_state = 2},
  [5913] = {.lex_state = 77, .external_lex_state = 2},
  [5914] = {.lex_state = 9, .external_lex_state = 2},
  [5915] = {.lex_state = 9, .external_lex_state = 2},
  [5916] = {.lex_state = 9, .external_lex_state = 2},
  [5917] = {.lex_state = 77, .external_lex_state = 2},
  [5918] = {.lex_state = 77, .external_lex_state = 5},
  [5919] = {.lex_state = 77, .external_lex_state = 5},
  [5920] = {.lex_state = 9, .external_lex_state = 2},
  [5921] = {.lex_state = 77, .external_lex_state = 2},
  [5922] = {.lex_state = 9, .external_lex_state = 2},
  [5923] = {.lex_state = 9, .external_lex_state = 2},
  [5924] = {.lex_state = 9, .external_lex_state = 2},
  [5925] = {.lex_state = 77, .external_lex_state = 2},
  [5926] = {.lex_state = 9, .external_lex_state = 2},
  [5927] = {.lex_state = 9, .external_lex_state = 2},
  [5928] = {.lex_state = 9, .external_lex_state = 2},
  [5929] = {.lex_state = 9, .external_lex_state = 2},
  [5930] = {.lex_state = 77, .external_lex_state = 2},
  [5931] = {.lex_state = 77, .external_lex_state = 5},
  [5932] = {.lex_state = 9, .external_lex_state = 2},
  [5933] = {.lex_state = 9, .external_lex_state = 2},
  [5934] = {.lex_state = 77, .external_lex_state = 2},
  [5935] = {.lex_state = 9, .external_lex_state = 2},
  [5936] = {.lex_state = 9, .external_lex_state = 2},
  [5937] = {.lex_state = 77, .external_lex_state = 2},
  [5938] = {.lex_state = 77, .external_lex_state = 2},
  [5939] = {.lex_state = 77, .external_lex_state = 2},
  [5940] = {.lex_state = 9, .external_lex_state = 2},
  [5941] = {.lex_state = 77, .external_lex_state = 5},
  [5942] = {.lex_state = 9, .external_lex_state = 2},
  [5943] = {.lex_state = 9, .external_lex_state = 2},
  [5944] = {.lex_state = 9, .external_lex_state = 2},
  [5945] = {.lex_state = 77, .external_lex_state = 2},
  [5946] = {.lex_state = 9, .external_lex_state = 2},
  [5947] = {.lex_state = 77, .external_lex_state = 2},
  [5948] = {.lex_state = 9, .external_lex_state = 2},
  [5949] = {.lex_state = 77, .external_lex_state = 2},
  [5950] = {.lex_state = 9, .external_lex_state = 2},
  [5951] = {.lex_state = 77, .external_lex_state = 2},
  [5952] = {.lex_state = 77, .external_lex_state = 2},
  [5953] = {.lex_state = 9, .external_lex_state = 2},
  [5954] = {.lex_state = 9, .external_lex_state = 2},
  [5955] = {.lex_state = 9, .external_lex_state = 2},
  [5956] = {.lex_state = 9, .external_lex_state = 2},
  [5957] = {.lex_state = 77, .external_lex_state = 5},
  [5958] = {.lex_state = 9, .external_lex_state = 2},
  [5959] = {.lex_state = 77, .external_lex_state = 2},
  [5960] = {.lex_state = 77, .external_lex_state = 2},
  [5961] = {.lex_state = 9, .external_lex_state = 2},
  [5962] = {.lex_state = 9, .external_lex_state = 2},
  [5963] = {.lex_state = 9, .external_lex_state = 2},
  [5964] = {.lex_state = 77, .external_lex_state = 2},
  [5965] = {.lex_state = 77, .external_lex_state = 2},
  [5966] = {.lex_state = 9, .external_lex_state = 2},
  [5967] = {.lex_state = 9, .external_lex_state = 2},
  [5968] = {.lex_state = 77, .external_lex_state = 2},
  [5969] = {.lex_state = 9, .external_lex_state = 2},
  [5970] = {.lex_state = 77, .external_lex_state = 2},
  [5971] = {.lex_state = 77, .external_lex_state = 2},
  [5972] = {.lex_state = 9, .external_lex_state = 2},
  [5973] = {.lex_state = 9, .external_lex_state = 2},
  [5974] = {.lex_state = 77, .external_lex_state = 2},
  [5975] = {.lex_state = 9, .external_lex_state = 2},
  [5976] = {.lex_state = 77, .external_lex_state = 2},
  [5977] = {.lex_state = 9, .external_lex_state = 2},
  [5978] = {.lex_state = 77, .external_lex_state = 2},
  [5979] = {.lex_state = 77, .external_lex_state = 2},
  [5980] = {.lex_state = 9, .external_lex_state = 2},
  [5981] = {.lex_state = 9, .external_lex_state = 2},
  [5982] = {.lex_state = 77, .external_lex_state = 5},
  [5983] = {.lex_state = 9, .external_lex_state = 2},
  [5984] = {.lex_state = 9, .external_lex_state = 2},
  [5985] = {.lex_state = 9, .external_lex_state = 2},
  [5986] = {.lex_state = 77, .external_lex_state = 2},
  [5987] = {.lex_state = 77, .external_lex_state = 2},
  [5988] = {.lex_state = 77, .external_lex_state = 2},
  [5989] = {.lex_state = 77, .external_lex_state = 2},
  [5990] = {.lex_state = 9, .external_lex_state = 2},
  [5991] = {.lex_state = 9, .external_lex_state = 2},
  [5992] = {.lex_state = 9, .external_lex_state = 2},
  [5993] = {.lex_state = 77, .external_lex_state = 2},
  [5994] = {.lex_state = 77, .external_lex_state = 2},
  [5995] = {.lex_state = 77, .external_lex_state = 5},
  [5996] = {.lex_state = 77, .external_lex_state = 2},
  [5997] = {.lex_state = 77, .external_lex_state = 5},
  [5998] = {.lex_state = 77, .external_lex_state = 2},
  [5999] = {.lex_state = 77, .external_lex_state = 2},
  [6000] = {.lex_state = 77, .external_lex_state = 2},
  [6001] = {.lex_state = 9, .external_lex_state = 2},
  [6002] = {.lex_state = 77, .external_lex_state = 2},
  [6003] = {.lex_state = 9, .external_lex_state = 2},
  [6004] = {.lex_state = 77, .external_lex_state = 5},
  [6005] = {.lex_state = 9, .external_lex_state = 2},
  [6006] = {.lex_state = 77, .external_lex_state = 5},
  [6007] = {.lex_state = 9, .external_lex_state = 2},
  [6008] = {.lex_state = 77, .external_lex_state = 2},
  [6009] = {.lex_state = 9, .external_lex_state = 2},
  [6010] = {.lex_state = 9, .external_lex_state = 2},
  [6011] = {.lex_state = 9, .external_lex_state = 2},
  [6012] = {.lex_state = 77, .external_lex_state = 2},
  [6013] = {.lex_state = 9, .external_lex_state = 2},
  [6014] = {.lex_state = 77, .external_lex_state = 5},
  [6015] = {.lex_state = 77, .external_lex_state = 2},
  [6016] = {.lex_state = 9, .external_lex_state = 2},
  [6017] = {.lex_state = 9, .external_lex_state = 2},
  [6018] = {.lex_state = 77, .external_lex_state = 2},
  [6019] = {.lex_state = 77, .external_lex_state = 2},
  [6020] = {.lex_state = 77, .external_lex_state = 2},
  [6021] = {.lex_state = 77, .external_lex_state = 2},
  [6022] = {.lex_state = 77, .external_lex_state = 2},
  [6023] = {.lex_state = 9, .external_lex_state = 2},
  [6024] = {.lex_state = 77, .external_lex_state = 2},
  [6025] = {.lex_state = 77, .external_lex_state = 5},
  [6026] = {.lex_state = 9, .external_lex_state = 2},
  [6027] = {.lex_state = 9, .external_lex_state = 2},
  [6028] = {.lex_state = 9, .external_lex_state = 2},
  [6029] = {.lex_state = 77, .external_lex_state = 2},
  [6030] = {.lex_state = 77, .external_lex_state = 2},
  [6031] = {.lex_state = 77, .external_lex_state = 2},
  [6032] = {.lex_state = 77, .external_lex_state = 2},
  [6033] = {.lex_state = 9, .external_lex_state = 2},
  [6034] = {.lex_state = 77, .external_lex_state = 2},
  [6035] = {.lex_state = 77, .external_lex_state = 2},
  [6036] = {.lex_state = 9, .external_lex_state = 2},
  [6037] = {.lex_state = 9, .external_lex_state = 2},
  [6038] = {.lex_state = 9, .external_lex_state = 2},
  [6039] = {.lex_state = 9, .external_lex_state = 2},
  [6040] = {.lex_state = 9, .external_lex_state = 2},
  [6041] = {.lex_state = 9, .external_lex_state = 2},
  [6042] = {.lex_state = 77, .external_lex_state = 2},
  [6043] = {.lex_state = 9, .external_lex_state = 2},
  [6044] = {.lex_state = 9, .external_lex_state = 2},
  [6045] = {.lex_state = 9, .external_lex_state = 2},
  [6046] = {.lex_state = 77, .external_lex_state = 2},
  [6047] = {.lex_state = 9, .external_lex_state = 2},
  [6048] = {.lex_state = 77, .external_lex_state = 2},
  [6049] = {.lex_state = 77, .external_lex_state = 5},
  [6050] = {.lex_state = 77, .external_lex_state = 2},
  [6051] = {.lex_state = 77, .external_lex_state = 2},
  [6052] = {.lex_state = 77, .external_lex_state = 2},
  [6053] = {.lex_state = 77, .external_lex_state = 5},
  [6054] = {.lex_state = 77, .external_lex_state = 5},
  [6055] = {.lex_state = 77, .external_lex_state = 2},
  [6056] = {.lex_state = 77, .external_lex_state = 2},
  [6057] = {.lex_state = 77, .external_lex_state = 2},
  [6058] = {.lex_state = 9, .external_lex_state = 2},
  [6059] = {.lex_state = 77, .external_lex_state = 2},
  [6060] = {.lex_state = 9, .external_lex_state = 2},
  [6061] = {.lex_state = 77, .external_lex_state = 2},
  [6062] = {.lex_state = 77, .external_lex_state = 2},
  [6063] = {.lex_state = 77, .external_lex_state = 2},
  [6064] = {.lex_state = 77, .external_lex_state = 2},
  [6065] = {.lex_state = 4, .external_lex_state = 2},
  [6066] = {.lex_state = 77, .external_lex_state = 2},
  [6067] = {.lex_state = 1, .external_lex_state = 10},
  [6068] = {.lex_state = 77, .external_lex_state = 2},
  [6069] = {.lex_state = 77, .external_lex_state = 2},
  [6070] = {.lex_state = 77, .external_lex_state = 2},
  [6071] = {.lex_state = 77, .external_lex_state = 2},
  [6072] = {.lex_state = 77, .external_lex_state = 2},
  [6073] = {.lex_state = 77, .external_lex_state = 2},
  [6074] = {.lex_state = 77, .external_lex_state = 2},
  [6075] = {.lex_state = 77, .external_lex_state = 2},
  [6076] = {.lex_state = 77, .external_lex_state = 2},
  [6077] = {.lex_state = 77, .external_lex_state = 2},
  [6078] = {.lex_state = 77, .external_lex_state = 2},
  [6079] = {.lex_state = 77, .external_lex_state = 2},
  [6080] = {.lex_state = 77, .external_lex_state = 2},
  [6081] = {.lex_state = 77, .external_lex_state = 2},
  [6082] = {.lex_state = 77, .external_lex_state = 2},
  [6083] = {.lex_state = 77, .external_lex_state = 2},
  [6084] = {.lex_state = 77, .external_lex_state = 2},
  [6085] = {.lex_state = 77, .external_lex_state = 2},
  [6086] = {.lex_state = 77, .external_lex_state = 2},
  [6087] = {.lex_state = 77, .external_lex_state = 2},
  [6088] = {.lex_state = 77, .external_lex_state = 2},
  [6089] = {.lex_state = 77, .external_lex_state = 2},
  [6090] = {.lex_state = 77, .external_lex_state = 2},
  [6091] = {.lex_state = 77, .external_lex_state = 2},
  [6092] = {.lex_state = 77, .external_lex_state = 2},
  [6093] = {.lex_state = 77, .external_lex_state = 2},
  [6094] = {.lex_state = 77, .external_lex_state = 2},
  [6095] = {.lex_state = 77, .external_lex_state = 2},
  [6096] = {.lex_state = 77, .external_lex_state = 2},
  [6097] = {.lex_state = 77, .external_lex_state = 2},
  [6098] = {.lex_state = 77, .external_lex_state = 2},
  [6099] = {.lex_state = 77, .external_lex_state = 2},
  [6100] = {.lex_state = 77, .external_lex_state = 2},
  [6101] = {.lex_state = 77, .external_lex_state = 2},
  [6102] = {.lex_state = 77, .external_lex_state = 2},
  [6103] = {.lex_state = 77, .external_lex_state = 2},
  [6104] = {.lex_state = 77, .external_lex_state = 2},
  [6105] = {.lex_state = 77, .external_lex_state = 2},
  [6106] = {.lex_state = 26, .external_lex_state = 2},
  [6107] = {.lex_state = 77, .external_lex_state = 2},
  [6108] = {.lex_state = 77, .external_lex_state = 2},
  [6109] = {.lex_state = 77, .external_lex_state = 2},
  [6110] = {.lex_state = 77, .external_lex_state = 2},
  [6111] = {.lex_state = 77, .external_lex_state = 2},
  [6112] = {.lex_state = 77, .external_lex_state = 2},
  [6113] = {.lex_state = 77, .external_lex_state = 2},
  [6114] = {.lex_state = 77, .external_lex_state = 2},
  [6115] = {.lex_state = 77, .external_lex_state = 2},
  [6116] = {.lex_state = 77, .external_lex_state = 2},
  [6117] = {.lex_state = 77, .external_lex_state = 2},
  [6118] = {.lex_state = 77, .external_lex_state = 2},
  [6119] = {.lex_state = 77, .external_lex_state = 2},
  [6120] = {.lex_state = 77, .external_lex_state = 2},
  [6121] = {.lex_state = 77, .external_lex_state = 2},
  [6122] = {.lex_state = 77, .external_lex_state = 2},
  [6123] = {.lex_state = 77, .external_lex_state = 2},
  [6124] = {.lex_state = 77, .external_lex_state = 2},
  [6125] = {.lex_state = 77, .external_lex_state = 2},
  [6126] = {.lex_state = 77, .external_lex_state = 2},
  [6127] = {.lex_state = 77, .external_lex_state = 2},
  [6128] = {.lex_state = 77, .external_lex_state = 2},
  [6129] = {.lex_state = 77, .external_lex_state = 2},
  [6130] = {.lex_state = 77, .external_lex_state = 2},
  [6131] = {.lex_state = 77, .external_lex_state = 2},
  [6132] = {.lex_state = 77, .external_lex_state = 2},
  [6133] = {.lex_state = 77, .external_lex_state = 2},
  [6134] = {.lex_state = 77, .external_lex_state = 2},
  [6135] = {.lex_state = 77, .external_lex_state = 2},
  [6136] = {.lex_state = 77, .external_lex_state = 2},
  [6137] = {.lex_state = 77, .external_lex_state = 2},
  [6138] = {.lex_state = 77, .external_lex_state = 2},
  [6139] = {.lex_state = 77, .external_lex_state = 2},
  [6140] = {.lex_state = 77, .external_lex_state = 2},
  [6141] = {.lex_state = 77, .external_lex_state = 2},
  [6142] = {.lex_state = 77, .external_lex_state = 2},
  [6143] = {.lex_state = 77, .external_lex_state = 2},
  [6144] = {.lex_state = 77, .external_lex_state = 2},
  [6145] = {.lex_state = 77, .external_lex_state = 2},
  [6146] = {.lex_state = 77, .external_lex_state = 2},
  [6147] = {.lex_state = 77, .external_lex_state = 2},
  [6148] = {.lex_state = 77, .external_lex_state = 2},
  [6149] = {.lex_state = 77, .external_lex_state = 2},
  [6150] = {.lex_state = 77, .external_lex_state = 2},
  [6151] = {.lex_state = 77, .external_lex_state = 2},
  [6152] = {.lex_state = 77, .external_lex_state = 2},
  [6153] = {.lex_state = 77, .external_lex_state = 2},
  [6154] = {.lex_state = 77, .external_lex_state = 2},
  [6155] = {.lex_state = 77, .external_lex_state = 2},
  [6156] = {.lex_state = 77, .external_lex_state = 2},
  [6157] = {.lex_state = 77, .external_lex_state = 2},
  [6158] = {.lex_state = 77, .external_lex_state = 2},
  [6159] = {.lex_state = 77, .external_lex_state = 2},
  [6160] = {.lex_state = 77, .external_lex_state = 2},
  [6161] = {.lex_state = 77, .external_lex_state = 2},
  [6162] = {.lex_state = 77, .external_lex_state = 2},
  [6163] = {.lex_state = 77, .external_lex_state = 2},
  [6164] = {.lex_state = 77, .external_lex_state = 2},
  [6165] = {.lex_state = 77, .external_lex_state = 2},
  [6166] = {.lex_state = 77, .external_lex_state = 2},
  [6167] = {.lex_state = 77, .external_lex_state = 2},
  [6168] = {.lex_state = 77, .external_lex_state = 2},
  [6169] = {.lex_state = 77, .external_lex_state = 2},
  [6170] = {.lex_state = 77, .external_lex_state = 2},
  [6171] = {.lex_state = 77, .external_lex_state = 2},
  [6172] = {.lex_state = 77, .external_lex_state = 2},
  [6173] = {.lex_state = 77, .external_lex_state = 2},
  [6174] = {.lex_state = 77, .external_lex_state = 2},
  [6175] = {.lex_state = 4, .external_lex_state = 2},
  [6176] = {.lex_state = 77, .external_lex_state = 2},
  [6177] = {.lex_state = 77, .external_lex_state = 2},
  [6178] = {.lex_state = 4, .external_lex_state = 2},
  [6179] = {.lex_state = 77, .external_lex_state = 2},
  [6180] = {.lex_state = 1, .external_lex_state = 10},
  [6181] = {.lex_state = 77, .external_lex_state = 2},
  [6182] = {.lex_state = 77, .external_lex_state = 2},
  [6183] = {.lex_state = 77, .external_lex_state = 2},
  [6184] = {.lex_state = 77, .external_lex_state = 2},
  [6185] = {.lex_state = 77, .external_lex_state = 2},
  [6186] = {.lex_state = 77, .external_lex_state = 2},
  [6187] = {.lex_state = 77, .external_lex_state = 2},
  [6188] = {.lex_state = 77, .external_lex_state = 2},
  [6189] = {.lex_state = 77, .external_lex_state = 2},
  [6190] = {.lex_state = 77, .external_lex_state = 2},
  [6191] = {.lex_state = 77, .external_lex_state = 2},
  [6192] = {.lex_state = 77, .external_lex_state = 2},
  [6193] = {.lex_state = 77, .external_lex_state = 2},
  [6194] = {.lex_state = 77, .external_lex_state = 2},
  [6195] = {.lex_state = 77, .external_lex_state = 2},
  [6196] = {.lex_state = 77, .external_lex_state = 2},
  [6197] = {.lex_state = 77, .external_lex_state = 2},
  [6198] = {.lex_state = 77, .external_lex_state = 2},
  [6199] = {.lex_state = 77, .external_lex_state = 2},
  [6200] = {.lex_state = 77, .external_lex_state = 2},
  [6201] = {.lex_state = 77, .external_lex_state = 2},
  [6202] = {.lex_state = 77, .external_lex_state = 2},
  [6203] = {.lex_state = 77, .external_lex_state = 2},
  [6204] = {.lex_state = 77, .external_lex_state = 2},
  [6205] = {.lex_state = 77, .external_lex_state = 2},
  [6206] = {.lex_state = 77, .external_lex_state = 2},
  [6207] = {.lex_state = 77, .external_lex_state = 2},
  [6208] = {.lex_state = 77, .external_lex_state = 2},
  [6209] = {.lex_state = 77, .external_lex_state = 2},
  [6210] = {.lex_state = 77, .external_lex_state = 2},
  [6211] = {.lex_state = 4, .external_lex_state = 2},
  [6212] = {.lex_state = 77, .external_lex_state = 2},
  [6213] = {.lex_state = 1, .external_lex_state = 10},
  [6214] = {.lex_state = 77, .external_lex_state = 2},
  [6215] = {.lex_state = 77, .external_lex_state = 2},
  [6216] = {.lex_state = 1, .external_lex_state = 10},
  [6217] = {.lex_state = 77, .external_lex_state = 2},
  [6218] = {.lex_state = 77, .external_lex_state = 2},
  [6219] = {.lex_state = 77, .external_lex_state = 2},
  [6220] = {.lex_state = 77, .external_lex_state = 2},
  [6221] = {.lex_state = 77, .external_lex_state = 2},
  [6222] = {.lex_state = 77, .external_lex_state = 2},
  [6223] = {.lex_state = 77, .external_lex_state = 2},
  [6224] = {.lex_state = 77, .external_lex_state = 2},
  [6225] = {.lex_state = 77, .external_lex_state = 2},
  [6226] = {.lex_state = 77, .external_lex_state = 2},
  [6227] = {.lex_state = 77, .external_lex_state = 2},
  [6228] = {.lex_state = 77, .external_lex_state = 2},
  [6229] = {.lex_state = 77, .external_lex_state = 2},
  [6230] = {.lex_state = 77, .external_lex_state = 2},
  [6231] = {.lex_state = 77, .external_lex_state = 2},
  [6232] = {.lex_state = 26, .external_lex_state = 2},
  [6233] = {.lex_state = 77, .external_lex_state = 2},
  [6234] = {.lex_state = 77, .external_lex_state = 2},
  [6235] = {.lex_state = 4, .external_lex_state = 2},
  [6236] = {.lex_state = 77, .external_lex_state = 2},
  [6237] = {.lex_state = 77, .external_lex_state = 2},
  [6238] = {.lex_state = 77, .external_lex_state = 2},
  [6239] = {.lex_state = 77, .external_lex_state = 2},
  [6240] = {.lex_state = 77, .external_lex_state = 2},
  [6241] = {.lex_state = 77, .external_lex_state = 2},
  [6242] = {.lex_state = 77, .external_lex_state = 2},
  [6243] = {.lex_state = 77, .external_lex_state = 2},
  [6244] = {.lex_state = 77, .external_lex_state = 2},
  [6245] = {.lex_state = 77, .external_lex_state = 2},
  [6246] = {.lex_state = 77, .external_lex_state = 2},
  [6247] = {.lex_state = 77, .external_lex_state = 2},
  [6248] = {.lex_state = 77, .external_lex_state = 2},
  [6249] = {.lex_state = 77, .external_lex_state = 2},
  [6250] = {.lex_state = 9, .external_lex_state = 2},
  [6251] = {.lex_state = 77, .external_lex_state = 2},
  [6252] = {.lex_state = 77, .external_lex_state = 2},
  [6253] = {.lex_state = 77, .external_lex_state = 2},
  [6254] = {.lex_state = 1, .external_lex_state = 10},
  [6255] = {.lex_state = 77, .external_lex_state = 2},
  [6256] = {.lex_state = 77, .external_lex_state = 2},
  [6257] = {.lex_state = 77, .external_lex_state = 2},
  [6258] = {.lex_state = 77, .external_lex_state = 2},
  [6259] = {.lex_state = 77, .external_lex_state = 2},
  [6260] = {.lex_state = 26, .external_lex_state = 2},
  [6261] = {.lex_state = 77, .external_lex_state = 2},
  [6262] = {.lex_state = 77, .external_lex_state = 2},
  [6263] = {.lex_state = 77, .external_lex_state = 2},
  [6264] = {.lex_state = 77, .external_lex_state = 2},
  [6265] = {.lex_state = 77, .external_lex_state = 2},
  [6266] = {.lex_state = 77, .external_lex_state = 2},
  [6267] = {.lex_state = 77, .external_lex_state = 2},
  [6268] = {.lex_state = 77, .external_lex_state = 2},
  [6269] = {.lex_state = 77, .external_lex_state = 2},
  [6270] = {.lex_state = 77, .external_lex_state = 2},
  [6271] = {.lex_state = 77, .external_lex_state = 2},
  [6272] = {.lex_state = 77, .external_lex_state = 2},
  [6273] = {.lex_state = 9, .external_lex_state = 2},
  [6274] = {.lex_state = 77, .external_lex_state = 2},
  [6275] = {.lex_state = 77, .external_lex_state = 2},
  [6276] = {.lex_state = 77, .external_lex_state = 2},
  [6277] = {.lex_state = 77, .external_lex_state = 2},
  [6278] = {.lex_state = 77, .external_lex_state = 2},
  [6279] = {.lex_state = 77, .external_lex_state = 2},
  [6280] = {.lex_state = 77, .external_lex_state = 2},
  [6281] = {.lex_state = 77, .external_lex_state = 2},
  [6282] = {.lex_state = 77, .external_lex_state = 2},
  [6283] = {.lex_state = 77, .external_lex_state = 2},
  [6284] = {.lex_state = 77, .external_lex_state = 2},
  [6285] = {.lex_state = 77, .external_lex_state = 2},
  [6286] = {.lex_state = 77, .external_lex_state = 2},
  [6287] = {.lex_state = 77, .external_lex_state = 2},
  [6288] = {.lex_state = 77, .external_lex_state = 2},
  [6289] = {.lex_state = 77, .external_lex_state = 2},
  [6290] = {.lex_state = 77, .external_lex_state = 2},
  [6291] = {.lex_state = 77, .external_lex_state = 2},
  [6292] = {.lex_state = 77, .external_lex_state = 2},
  [6293] = {.lex_state = 77, .external_lex_state = 2},
  [6294] = {.lex_state = 77, .external_lex_state = 2},
  [6295] = {.lex_state = 77, .external_lex_state = 2},
  [6296] = {.lex_state = 77, .external_lex_state = 2},
  [6297] = {.lex_state = 77, .external_lex_state = 2},
  [6298] = {.lex_state = 77, .external_lex_state = 2},
  [6299] = {.lex_state = 77, .external_lex_state = 2},
  [6300] = {.lex_state = 77, .external_lex_state = 2},
  [6301] = {.lex_state = 77, .external_lex_state = 2},
  [6302] = {.lex_state = 77, .external_lex_state = 2},
  [6303] = {.lex_state = 77, .external_lex_state = 2},
  [6304] = {.lex_state = 77, .external_lex_state = 2},
  [6305] = {.lex_state = 77, .external_lex_state = 2},
  [6306] = {.lex_state = 77, .external_lex_state = 2},
  [6307] = {.lex_state = 77, .external_lex_state = 2},
  [6308] = {.lex_state = 77, .external_lex_state = 2},
  [6309] = {.lex_state = 77, .external_lex_state = 2},
  [6310] = {.lex_state = 77, .external_lex_state = 2},
  [6311] = {.lex_state = 9, .external_lex_state = 2},
  [6312] = {.lex_state = 77, .external_lex_state = 2},
  [6313] = {.lex_state = 77, .external_lex_state = 2},
  [6314] = {.lex_state = 77, .external_lex_state = 2},
  [6315] = {.lex_state = 77, .external_lex_state = 2},
  [6316] = {.lex_state = 77, .external_lex_state = 2},
  [6317] = {.lex_state = 77, .external_lex_state = 2},
  [6318] = {.lex_state = 77, .external_lex_state = 2},
  [6319] = {.lex_state = 77, .external_lex_state = 2},
  [6320] = {.lex_state = 77, .external_lex_state = 2},
  [6321] = {.lex_state = 77, .external_lex_state = 2},
  [6322] = {.lex_state = 77, .external_lex_state = 2},
  [6323] = {.lex_state = 77, .external_lex_state = 2},
  [6324] = {.lex_state = 77, .external_lex_state = 2},
  [6325] = {.lex_state = 77, .external_lex_state = 2},
  [6326] = {.lex_state = 77, .external_lex_state = 2},
  [6327] = {.lex_state = 77, .external_lex_state = 2},
  [6328] = {.lex_state = 77, .external_lex_state = 2},
  [6329] = {.lex_state = 77, .external_lex_state = 2},
  [6330] = {.lex_state = 77, .external_lex_state = 2},
  [6331] = {.lex_state = 77, .external_lex_state = 2},
  [6332] = {.lex_state = 77, .external_lex_state = 2},
  [6333] = {.lex_state = 77, .external_lex_state = 2},
  [6334] = {.lex_state = 77, .external_lex_state = 2},
  [6335] = {.lex_state = 77, .external_lex_state = 2},
  [6336] = {.lex_state = 77, .external_lex_state = 2},
  [6337] = {.lex_state = 77, .external_lex_state = 2},
  [6338] = {.lex_state = 77, .external_lex_state = 2},
  [6339] = {.lex_state = 77, .external_lex_state = 2},
  [6340] = {.lex_state = 77, .external_lex_state = 2},
  [6341] = {.lex_state = 77, .external_lex_state = 2},
  [6342] = {.lex_state = 77, .external_lex_state = 2},
  [6343] = {.lex_state = 77, .external_lex_state = 2},
  [6344] = {.lex_state = 77, .external_lex_state = 2},
  [6345] = {.lex_state = 77, .external_lex_state = 2},
  [6346] = {.lex_state = 77, .external_lex_state = 2},
  [6347] = {.lex_state = 77, .external_lex_state = 2},
  [6348] = {.lex_state = 77, .external_lex_state = 2},
  [6349] = {.lex_state = 77, .external_lex_state = 2},
  [6350] = {.lex_state = 77, .external_lex_state = 2},
  [6351] = {.lex_state = 26, .external_lex_state = 2},
  [6352] = {.lex_state = 77, .external_lex_state = 2},
  [6353] = {.lex_state = 77, .external_lex_state = 2},
  [6354] = {.lex_state = 77, .external_lex_state = 2},
  [6355] = {.lex_state = 77, .external_lex_state = 2},
  [6356] = {.lex_state = 77, .external_lex_state = 2},
  [6357] = {.lex_state = 77, .external_lex_state = 2},
  [6358] = {.lex_state = 77, .external_lex_state = 2},
  [6359] = {.lex_state = 77, .external_lex_state = 2},
  [6360] = {.lex_state = 77, .external_lex_state = 2},
  [6361] = {.lex_state = 9, .external_lex_state = 2},
  [6362] = {.lex_state = 77, .external_lex_state = 2},
  [6363] = {.lex_state = 77, .external_lex_state = 2},
  [6364] = {.lex_state = 77, .external_lex_state = 2},
  [6365] = {.lex_state = 77, .external_lex_state = 2},
  [6366] = {.lex_state = 77, .external_lex_state = 2},
  [6367] = {.lex_state = 77, .external_lex_state = 2},
  [6368] = {.lex_state = 77, .external_lex_state = 2},
  [6369] = {.lex_state = 77, .external_lex_state = 2},
  [6370] = {.lex_state = 77, .external_lex_state = 2},
  [6371] = {.lex_state = 77, .external_lex_state = 2},
  [6372] = {.lex_state = 77, .external_lex_state = 2},
  [6373] = {.lex_state = 77, .external_lex_state = 2},
  [6374] = {.lex_state = 77, .external_lex_state = 2},
  [6375] = {.lex_state = 77, .external_lex_state = 2},
  [6376] = {.lex_state = 77, .external_lex_state = 2},
  [6377] = {.lex_state = 77, .external_lex_state = 2},
  [6378] = {.lex_state = 77, .external_lex_state = 2},
  [6379] = {.lex_state = 77, .external_lex_state = 2},
  [6380] = {.lex_state = 77, .external_lex_state = 2},
  [6381] = {.lex_state = 77, .external_lex_state = 2},
  [6382] = {.lex_state = 77, .external_lex_state = 2},
  [6383] = {.lex_state = 77, .external_lex_state = 2},
  [6384] = {.lex_state = 77, .external_lex_state = 2},
  [6385] = {.lex_state = 77, .external_lex_state = 2},
  [6386] = {.lex_state = 77, .external_lex_state = 2},
  [6387] = {.lex_state = 77, .external_lex_state = 2},
  [6388] = {.lex_state = 77, .external_lex_state = 2},
  [6389] = {.lex_state = 77, .external_lex_state = 2},
  [6390] = {.lex_state = 26, .external_lex_state = 2},
  [6391] = {.lex_state = 77, .external_lex_state = 2},
  [6392] = {.lex_state = 77, .external_lex_state = 2},
  [6393] = {.lex_state = 77, .external_lex_state = 2},
  [6394] = {.lex_state = 77, .external_lex_state = 2},
  [6395] = {.lex_state = 77, .external_lex_state = 2},
  [6396] = {.lex_state = 77, .external_lex_state = 2},
  [6397] = {.lex_state = 77, .external_lex_state = 2},
  [6398] = {.lex_state = 77, .external_lex_state = 2},
  [6399] = {.lex_state = 77, .external_lex_state = 2},
  [6400] = {.lex_state = 77, .external_lex_state = 2},
  [6401] = {.lex_state = 77, .external_lex_state = 2},
  [6402] = {.lex_state = 77, .external_lex_state = 2},
  [6403] = {.lex_state = 77, .external_lex_state = 2},
  [6404] = {.lex_state = 77, .external_lex_state = 2},
  [6405] = {.lex_state = 77, .external_lex_state = 2},
  [6406] = {.lex_state = 77, .external_lex_state = 2},
  [6407] = {.lex_state = 77, .external_lex_state = 2},
  [6408] = {.lex_state = 77, .external_lex_state = 2},
  [6409] = {.lex_state = 77, .external_lex_state = 2},
  [6410] = {.lex_state = 77, .external_lex_state = 2},
  [6411] = {.lex_state = 77, .external_lex_state = 2},
  [6412] = {.lex_state = 77, .external_lex_state = 2},
  [6413] = {.lex_state = 77, .external_lex_state = 2},
  [6414] = {.lex_state = 77, .external_lex_state = 2},
  [6415] = {.lex_state = 77, .external_lex_state = 2},
  [6416] = {.lex_state = 77, .external_lex_state = 2},
  [6417] = {.lex_state = 77, .external_lex_state = 2},
  [6418] = {.lex_state = 77, .external_lex_state = 2},
  [6419] = {.lex_state = 77, .external_lex_state = 2},
  [6420] = {.lex_state = 77, .external_lex_state = 2},
  [6421] = {.lex_state = 77, .external_lex_state = 2},
  [6422] = {.lex_state = 77, .external_lex_state = 2},
  [6423] = {.lex_state = 77, .external_lex_state = 2},
  [6424] = {.lex_state = 77, .external_lex_state = 2},
  [6425] = {.lex_state = 77, .external_lex_state = 2},
  [6426] = {.lex_state = 77, .external_lex_state = 2},
  [6427] = {.lex_state = 77, .external_lex_state = 2},
  [6428] = {.lex_state = 77, .external_lex_state = 2},
  [6429] = {.lex_state = 77, .external_lex_state = 2},
  [6430] = {.lex_state = 77, .external_lex_state = 2},
  [6431] = {.lex_state = 4, .external_lex_state = 2},
  [6432] = {.lex_state = 77, .external_lex_state = 2},
  [6433] = {.lex_state = 77, .external_lex_state = 2},
  [6434] = {.lex_state = 77, .external_lex_state = 2},
  [6435] = {.lex_state = 77, .external_lex_state = 2},
  [6436] = {.lex_state = 77, .external_lex_state = 2},
  [6437] = {.lex_state = 77, .external_lex_state = 2},
  [6438] = {.lex_state = 77, .external_lex_state = 2},
  [6439] = {.lex_state = 77, .external_lex_state = 2},
  [6440] = {.lex_state = 77, .external_lex_state = 2},
  [6441] = {.lex_state = 77, .external_lex_state = 2},
  [6442] = {.lex_state = 77, .external_lex_state = 2},
  [6443] = {.lex_state = 77, .external_lex_state = 2},
  [6444] = {.lex_state = 77, .external_lex_state = 2},
  [6445] = {.lex_state = 77, .external_lex_state = 2},
  [6446] = {.lex_state = 77, .external_lex_state = 2},
  [6447] = {.lex_state = 77, .external_lex_state = 2},
  [6448] = {.lex_state = 77, .external_lex_state = 2},
  [6449] = {.lex_state = 77, .external_lex_state = 2},
  [6450] = {.lex_state = 77, .external_lex_state = 2},
  [6451] = {.lex_state = 77, .external_lex_state = 2},
  [6452] = {.lex_state = 4, .external_lex_state = 2},
  [6453] = {.lex_state = 77, .external_lex_state = 2},
  [6454] = {.lex_state = 77, .external_lex_state = 2},
  [6455] = {.lex_state = 77, .external_lex_state = 2},
  [6456] = {.lex_state = 77, .external_lex_state = 2},
  [6457] = {.lex_state = 77, .external_lex_state = 2},
  [6458] = {.lex_state = 77, .external_lex_state = 2},
  [6459] = {.lex_state = 77, .external_lex_state = 2},
  [6460] = {.lex_state = 77, .external_lex_state = 2},
  [6461] = {.lex_state = 77, .external_lex_state = 2},
  [6462] = {.lex_state = 77, .external_lex_state = 2},
  [6463] = {.lex_state = 77, .external_lex_state = 2},
  [6464] = {.lex_state = 77, .external_lex_state = 2},
  [6465] = {.lex_state = 77, .external_lex_state = 2},
  [6466] = {.lex_state = 77, .external_lex_state = 2},
  [6467] = {.lex_state = 77, .external_lex_state = 2},
  [6468] = {.lex_state = 77, .external_lex_state = 2},
  [6469] = {.lex_state = 77, .external_lex_state = 2},
  [6470] = {.lex_state = 77, .external_lex_state = 2},
  [6471] = {.lex_state = 77, .external_lex_state = 2},
  [6472] = {.lex_state = 77, .external_lex_state = 2},
  [6473] = {.lex_state = 77, .external_lex_state = 2},
  [6474] = {.lex_state = 77, .external_lex_state = 2},
  [6475] = {.lex_state = 77, .external_lex_state = 2},
  [6476] = {.lex_state = 77, .external_lex_state = 2},
  [6477] = {.lex_state = 77, .external_lex_state = 2},
  [6478] = {.lex_state = 77, .external_lex_state = 2},
  [6479] = {.lex_state = 77, .external_lex_state = 2},
  [6480] = {.lex_state = 77, .external_lex_state = 2},
  [6481] = {.lex_state = 77, .external_lex_state = 2},
  [6482] = {.lex_state = 77, .external_lex_state = 2},
  [6483] = {.lex_state = 77, .external_lex_state = 2},
  [6484] = {.lex_state = 77, .external_lex_state = 2},
  [6485] = {.lex_state = 77, .external_lex_state = 2},
  [6486] = {.lex_state = 77, .external_lex_state = 2},
  [6487] = {.lex_state = 77, .external_lex_state = 2},
  [6488] = {.lex_state = 77, .external_lex_state = 2},
  [6489] = {.lex_state = 77, .external_lex_state = 2},
  [6490] = {.lex_state = 77, .external_lex_state = 2},
  [6491] = {.lex_state = 77, .external_lex_state = 2},
  [6492] = {.lex_state = 77, .external_lex_state = 2},
  [6493] = {.lex_state = 77, .external_lex_state = 2},
  [6494] = {.lex_state = 77, .external_lex_state = 2},
  [6495] = {.lex_state = 77, .external_lex_state = 2},
  [6496] = {.lex_state = 77, .external_lex_state = 2},
  [6497] = {.lex_state = 77, .external_lex_state = 2},
  [6498] = {.lex_state = 77, .external_lex_state = 2},
  [6499] = {.lex_state = 77, .external_lex_state = 2},
  [6500] = {.lex_state = 77, .external_lex_state = 2},
  [6501] = {.lex_state = 77, .external_lex_state = 2},
  [6502] = {.lex_state = 77, .external_lex_state = 2},
  [6503] = {.lex_state = 77, .external_lex_state = 2},
  [6504] = {.lex_state = 77, .external_lex_state = 2},
  [6505] = {.lex_state = 77, .external_lex_state = 2},
  [6506] = {.lex_state = 77, .external_lex_state = 2},
  [6507] = {.lex_state = 77, .external_lex_state = 2},
  [6508] = {.lex_state = 77, .external_lex_state = 2},
  [6509] = {.lex_state = 77, .external_lex_state = 2},
  [6510] = {.lex_state = 77, .external_lex_state = 2},
  [6511] = {.lex_state = 77, .external_lex_state = 2},
  [6512] = {.lex_state = 77, .external_lex_state = 2},
  [6513] = {.lex_state = 77, .external_lex_state = 2},
  [6514] = {.lex_state = 77, .external_lex_state = 2},
  [6515] = {.lex_state = 77, .external_lex_state = 2},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [anon_sym_meta] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_symbol] = ACTIONS(1),
    [anon_sym_object] = ACTIONS(1),
    [anon_sym_property] = ACTIONS(1),
    [anon_sym_signal] = ACTIONS(1),
    [anon_sym_on] = ACTIONS(1),
    [anon_sym_required] = ACTIONS(1),
    [anon_sym_component] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_accessor] = ACTIONS(1),
    [anon_sym_satisfies] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_DASH_QMARK_COLON] = ACTIONS(1),
    [anon_sym_PLUS_QMARK_COLON] = ACTIONS(1),
    [anon_sym_asserts] = ACTIONS(1),
    [anon_sym_infer] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_keyof] = ACTIONS(1),
    [anon_sym_unique] = ACTIONS(1),
    [anon_sym_unknown] = ACTIONS(1),
    [anon_sym_never] = ACTIONS(1),
    [anon_sym_LBRACE_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_RBRACE] = ACTIONS(1),
    [anon_sym_pragma] = ACTIONS(1),
    [aux_sym_ui_version_specifier_token1] = ACTIONS(1),
    [anon_sym_list] = ACTIONS(1),
    [anon_sym_final] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__ternary_qmark] = ACTIONS(1),
    [sym_html_comment] = ACTIONS(5),
    [sym_jsx_text] = ACTIONS(1),
    [sym__function_signature_automatic_semicolon] = ACTIONS(1),
    [sym___error_recovery] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(6286),
    [sym_ui_pragma] = STATE(2751),
    [sym_ui_import] = STATE(2751),
    [sym_ui_object_definition] = STATE(6165),
    [sym_ui_annotated_object] = STATE(6165),
    [sym_ui_annotation] = STATE(3147),
    [sym_ui_nested_identifier] = STATE(5032),
    [aux_sym_program_repeat1] = STATE(2751),
    [aux_sym_ui_annotated_object_repeat1] = STATE(3151),
    [sym_identifier] = ACTIONS(7),
    [sym_hash_bang_line] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(11),
    [anon_sym_namespace] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_of] = ACTIONS(11),
    [anon_sym_async] = ACTIONS(11),
    [sym_comment] = ACTIONS(5),
    [anon_sym_AT] = ACTIONS(15),
    [anon_sym_static] = ACTIONS(11),
    [anon_sym_readonly] = ACTIONS(11),
    [anon_sym_get] = ACTIONS(11),
    [anon_sym_set] = ACTIONS(11),
    [anon_sym_declare] = ACTIONS(11),
    [anon_sym_public] = ACTIONS(11),
    [anon_sym_private] = ACTIONS(11),
    [anon_sym_protected] = ACTIONS(11),
    [anon_sym_override] = ACTIONS(11),
    [anon_sym_module] = ACTIONS(11),
    [anon_sym_any] = ACTIONS(11),
    [anon_sym_number] = ACTIONS(11),
    [anon_sym_boolean] = ACTIONS(11),
    [anon_sym_string] = ACTIONS(11),
    [anon_sym_symbol] = ACTIONS(11),
    [anon_sym_object] = ACTIONS(11),
    [anon_sym_property] = ACTIONS(11),
    [anon_sym_signal] = ACTIONS(11),
    [anon_sym_on] = ACTIONS(11),
    [anon_sym_required] = ACTIONS(11),
    [anon_sym_component] = ACTIONS(11),
    [anon_sym_pragma] = ACTIONS(17),
    [sym_html_comment] = ACTIONS(5),
  },
  [2] = {
    [sym_import] = STATE(3988),
    [sym_parenthesized_expression] = STATE(1292),
    [sym_expression] = STATE(2967),
    [sym_primary_expression] = STATE(1734),
    [sym_yield_expression] = STATE(1897),
    [sym_object] = STATE(1992),
    [sym_object_pattern] = STATE(4033),
    [sym_array] = STATE(1992),
    [sym_array_pattern] = STATE(4033),
    [sym_nested_identifier] = STATE(6452),
    [sym_class] = STATE(1992),
    [sym_function_expression] = STATE(1992),
    [sym_generator_function] = STATE(1992),
    [sym_arrow_function] = STATE(1992),
    [sym__call_signature] = STATE(6424),
    [sym_call_expression] = STATE(1992),
    [sym_new_expression] = STATE(1761),
    [sym_await_expression] = STATE(1897),
    [sym_member_expression] = STATE(1394),
    [sym_subscript_expression] = STATE(1394),
    [sym_assignment_expression] = STATE(1897),
    [sym__augmented_assignment_lhs] = STATE(3269),
    [sym_augmented_assignment_expression] = STATE(1897),
    [sym__destructuring_pattern] = STATE(4033),
    [sym_ternary_expression] = STATE(1897),
    [sym_binary_expression] = STATE(1897),
    [sym_unary_expression] = STATE(1897),
    [sym_update_expression] = STATE(1897),
    [sym_string] = STATE(2394),
    [sym_template_string] = STATE(1992),
    [sym_regex] = STATE(1992),
    [sym_meta_property] = STATE(1992),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4404),
    [sym_pattern] = STATE(4549),
    [sym_rest_pattern] = STATE(3964),
    [sym_non_null_expression] = STATE(1394),
    [sym_type_assertion] = STATE(1897),
    [sym_as_expression] = STATE(1897),
    [sym_satisfies_expression] = STATE(1897),
    [sym_instantiation_expression] = STATE(1897),
    [sym_internal_module] = STATE(1897),
    [sym_nested_type_identifier] = STATE(3254),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3231),
    [sym__type_query_call_expression_in_type_annotation] = STATE(3250),
    [sym_type] = STATE(3405),
    [sym_constructor_type] = STATE(3291),
    [sym_primary_type] = STATE(3292),
    [sym_template_literal_type] = STATE(3293),
    [sym_infer_type] = STATE(3291),
    [sym_conditional_type] = STATE(3293),
    [sym_generic_type] = STATE(3293),
    [sym_type_query] = STATE(3293),
    [sym_index_type_query] = STATE(3293),
    [sym_lookup_type] = STATE(3293),
    [sym_literal_type] = STATE(3293),
    [sym__number] = STATE(3294),
    [sym_existential_type] = STATE(3293),
    [sym_flow_maybe_type] = STATE(3293),
    [sym_parenthesized_type] = STATE(3293),
    [sym_predefined_type] = STATE(3293),
    [sym_type_arguments] = STATE(582),
    [sym_object_type] = STATE(3293),
    [sym_type_parameters] = STATE(6059),
    [sym_array_type] = STATE(3293),
    [sym_tuple_type] = STATE(3293),
    [sym_readonly_type] = STATE(3291),
    [sym_union_type] = STATE(3293),
    [sym_intersection_type] = STATE(3293),
    [sym_function_type] = STATE(3291),
    [aux_sym_export_statement_repeat1] = STATE(4883),
    [sym_identifier] = ACTIONS(19),
    [anon_sym_export] = ACTIONS(21),
    [anon_sym_STAR] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(21),
    [anon_sym_EQ] = ACTIONS(25),
    [anon_sym_as] = ACTIONS(28),
    [anon_sym_namespace] = ACTIONS(30),
    [anon_sym_LBRACE] = ACTIONS(32),
    [anon_sym_COMMA] = ACTIONS(34),
    [anon_sym_typeof] = ACTIONS(36),
    [anon_sym_import] = ACTIONS(38),
    [anon_sym_from] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(21),
    [anon_sym_const] = ACTIONS(40),
    [anon_sym_BANG] = ACTIONS(42),
    [anon_sym_LPAREN] = ACTIONS(45),
    [anon_sym_RPAREN] = ACTIONS(34),
    [anon_sym_await] = ACTIONS(47),
    [anon_sym_in] = ACTIONS(28),
    [anon_sym_of] = ACTIONS(21),
    [anon_sym_COLON] = ACTIONS(34),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(28),
    [anon_sym_class] = ACTIONS(53),
    [anon_sym_async] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(59),
    [anon_sym_QMARK_DOT] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_using] = ACTIONS(65),
    [anon_sym_PLUS_EQ] = ACTIONS(67),
    [anon_sym_DASH_EQ] = ACTIONS(67),
    [anon_sym_STAR_EQ] = ACTIONS(67),
    [anon_sym_SLASH_EQ] = ACTIONS(67),
    [anon_sym_PERCENT_EQ] = ACTIONS(67),
    [anon_sym_CARET_EQ] = ACTIONS(67),
    [anon_sym_AMP_EQ] = ACTIONS(67),
    [anon_sym_PIPE_EQ] = ACTIONS(67),
    [anon_sym_GT_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(67),
    [anon_sym_LT_LT_EQ] = ACTIONS(67),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(67),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(67),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(67),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(67),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_AMP_AMP] = ACTIONS(28),
    [anon_sym_PIPE_PIPE] = ACTIONS(28),
    [anon_sym_GT_GT] = ACTIONS(28),
    [anon_sym_GT_GT_GT] = ACTIONS(28),
    [anon_sym_LT_LT] = ACTIONS(28),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_CARET] = ACTIONS(28),
    [anon_sym_PIPE] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_PERCENT] = ACTIONS(28),
    [anon_sym_STAR_STAR] = ACTIONS(28),
    [anon_sym_LT] = ACTIONS(80),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(28),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(61),
    [anon_sym_BANG_EQ] = ACTIONS(28),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(61),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(28),
    [anon_sym_QMARK_QMARK] = ACTIONS(28),
    [anon_sym_instanceof] = ACTIONS(28),
    [anon_sym_TILDE] = ACTIONS(82),
    [anon_sym_void] = ACTIONS(84),
    [anon_sym_delete] = ACTIONS(86),
    [anon_sym_PLUS_PLUS] = ACTIONS(88),
    [anon_sym_DASH_DASH] = ACTIONS(88),
    [anon_sym_DQUOTE] = ACTIONS(91),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(95),
    [sym_number] = ACTIONS(97),
    [sym_private_property_identifier] = ACTIONS(99),
    [sym_this] = ACTIONS(101),
    [sym_super] = ACTIONS(103),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_null] = ACTIONS(105),
    [sym_undefined] = ACTIONS(107),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_readonly] = ACTIONS(111),
    [anon_sym_get] = ACTIONS(21),
    [anon_sym_set] = ACTIONS(21),
    [anon_sym_QMARK] = ACTIONS(113),
    [anon_sym_declare] = ACTIONS(21),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_override] = ACTIONS(21),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_any] = ACTIONS(115),
    [anon_sym_number] = ACTIONS(115),
    [anon_sym_boolean] = ACTIONS(115),
    [anon_sym_string] = ACTIONS(115),
    [anon_sym_symbol] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_property] = ACTIONS(21),
    [anon_sym_signal] = ACTIONS(21),
    [anon_sym_on] = ACTIONS(21),
    [anon_sym_required] = ACTIONS(21),
    [anon_sym_component] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(117),
    [anon_sym_satisfies] = ACTIONS(28),
    [anon_sym_infer] = ACTIONS(119),
    [anon_sym_keyof] = ACTIONS(121),
    [anon_sym_unique] = ACTIONS(123),
    [anon_sym_unknown] = ACTIONS(125),
    [anon_sym_never] = ACTIONS(125),
    [anon_sym_LBRACE_PIPE] = ACTIONS(127),
    [sym__ternary_qmark] = ACTIONS(61),
    [sym_html_comment] = ACTIONS(5),
  },
  [3] = {
    [sym_import] = STATE(3988),
    [sym_parenthesized_expression] = STATE(1292),
    [sym_expression] = STATE(2967),
    [sym_primary_expression] = STATE(1734),
    [sym_yield_expression] = STATE(1897),
    [sym_object] = STATE(1992),
    [sym_object_pattern] = STATE(4033),
    [sym_array] = STATE(1992),
    [sym_array_pattern] = STATE(4033),
    [sym_nested_identifier] = STATE(6452),
    [sym_class] = STATE(1992),
    [sym_function_expression] = STATE(1992),
    [sym_generator_function] = STATE(1992),
    [sym_arrow_function] = STATE(1992),
    [sym__call_signature] = STATE(6424),
    [sym_call_expression] = STATE(1992),
    [sym_new_expression] = STATE(1761),
    [sym_await_expression] = STATE(1897),
    [sym_member_expression] = STATE(1394),
    [sym_subscript_expression] = STATE(1394),
    [sym_assignment_expression] = STATE(1897),
    [sym__augmented_assignment_lhs] = STATE(3269),
    [sym_augmented_assignment_expression] = STATE(1897),
    [sym__destructuring_pattern] = STATE(4033),
    [sym_ternary_expression] = STATE(1897),
    [sym_binary_expression] = STATE(1897),
    [sym_unary_expression] = STATE(1897),
    [sym_update_expression] = STATE(1897),
    [sym_string] = STATE(2394),
    [sym_template_string] = STATE(1992),
    [sym_regex] = STATE(1992),
    [sym_meta_property] = STATE(1992),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4404),
    [sym_pattern] = STATE(4549),
    [sym_rest_pattern] = STATE(3964),
    [sym_non_null_expression] = STATE(1394),
    [sym_type_assertion] = STATE(1897),
    [sym_as_expression] = STATE(1897),
    [sym_satisfies_expression] = STATE(1897),
    [sym_instantiation_expression] = STATE(1897),
    [sym_internal_module] = STATE(1897),
    [sym_nested_type_identifier] = STATE(3254),
    [sym__type_query_member_expression_in_type_annotation] = STATE(3231),
    [sym__type_query_call_expression_in_type_annotation] = STATE(3250),
    [sym_type] = STATE(3405),
    [sym_constructor_type] = STATE(3291),
    [sym_primary_type] = STATE(3292),
    [sym_template_literal_type] = STATE(3293),
    [sym_infer_type] = STATE(3291),
    [sym_conditional_type] = STATE(3293),
    [sym_generic_type] = STATE(3293),
    [sym_type_query] = STATE(3293),
    [sym_index_type_query] = STATE(3293),
    [sym_lookup_type] = STATE(3293),
    [sym_literal_type] = STATE(3293),
    [sym__number] = STATE(3294),
    [sym_existential_type] = STATE(3293),
    [sym_flow_maybe_type] = STATE(3293),
    [sym_parenthesized_type] = STATE(3293),
    [sym_predefined_type] = STATE(3293),
    [sym_type_arguments] = STATE(582),
    [sym_object_type] = STATE(3293),
    [sym_type_parameters] = STATE(6059),
    [sym_array_type] = STATE(3293),
    [sym_tuple_type] = STATE(3293),
    [sym_readonly_type] = STATE(3291),
    [sym_union_type] = STATE(3293),
    [sym_intersection_type] = STATE(3293),
    [sym_function_type] = STATE(3291),
    [aux_sym_export_statement_repeat1] = STATE(4883),
    [sym_identifier] = ACTIONS(19),
    [anon_sym_export] = ACTIONS(21),
    [anon_sym_STAR] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(21),
    [anon_sym_EQ] = ACTIONS(129),
    [anon_sym_as] = ACTIONS(28),
    [anon_sym_namespace] = ACTIONS(30),
    [anon_sym_LBRACE] = ACTIONS(32),
    [anon_sym_COMMA] = ACTIONS(132),
    [anon_sym_typeof] = ACTIONS(36),
    [anon_sym_import] = ACTIONS(38),
    [anon_sym_from] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(21),
    [anon_sym_const] = ACTIONS(40),
    [anon_sym_BANG] = ACTIONS(42),
    [anon_sym_LPAREN] = ACTIONS(45),
    [anon_sym_RPAREN] = ACTIONS(132),
    [anon_sym_await] = ACTIONS(47),
    [anon_sym_in] = ACTIONS(28),
    [anon_sym_of] = ACTIONS(21),
    [anon_sym_COLON] = ACTIONS(132),
    [anon_sym_yield] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(28),
    [anon_sym_class] = ACTIONS(53),
    [anon_sym_async] = ACTIONS(55),
    [anon_sym_function] = ACTIONS(57),
    [anon_sym_EQ_GT] = ACTIONS(135),
    [anon_sym_QMARK_DOT] = ACTIONS(61),
    [anon_sym_new] = ACTIONS(63),
    [anon_sym_using] = ACTIONS(65),
    [anon_sym_PLUS_EQ] = ACTIONS(67),
    [anon_sym_DASH_EQ] = ACTIONS(67),
    [anon_sym_STAR_EQ] = ACTIONS(67),
    [anon_sym_SLASH_EQ] = ACTIONS(67),
    [anon_sym_PERCENT_EQ] = ACTIONS(67),
    [anon_sym_CARET_EQ] = ACTIONS(67),
    [anon_sym_AMP_EQ] = ACTIONS(67),
    [anon_sym_PIPE_EQ] = ACTIONS(67),
    [anon_sym_GT_GT_EQ] = ACTIONS(67),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(67),
    [anon_sym_LT_LT_EQ] = ACTIONS(67),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(67),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(67),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(67),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(67),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(69),
    [anon_sym_AMP_AMP] = ACTIONS(28),
    [anon_sym_PIPE_PIPE] = ACTIONS(28),
    [anon_sym_GT_GT] = ACTIONS(28),
    [anon_sym_GT_GT_GT] = ACTIONS(28),
    [anon_sym_LT_LT] = ACTIONS(28),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_CARET] = ACTIONS(28),
    [anon_sym_PIPE] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_PERCENT] = ACTIONS(28),
    [anon_sym_STAR_STAR] = ACTIONS(28),
    [anon_sym_LT] = ACTIONS(80),
    [anon_sym_LT_EQ] = ACTIONS(61),
    [anon_sym_EQ_EQ] = ACTIONS(28),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(61),
    [anon_sym_BANG_EQ] = ACTIONS(28),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(61),
    [anon_sym_GT_EQ] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(28),
    [anon_sym_QMARK_QMARK] = ACTIONS(28),
    [anon_sym_instanceof] = ACTIONS(28),
    [anon_sym_TILDE] = ACTIONS(82),
    [anon_sym_void] = ACTIONS(84),
    [anon_sym_delete] = ACTIONS(86),
    [anon_sym_PLUS_PLUS] = ACTIONS(88),
    [anon_sym_DASH_DASH] = ACTIONS(88),
    [anon_sym_DQUOTE] = ACTIONS(91),
    [anon_sym_SQUOTE] = ACTIONS(93),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(95),
    [sym_number] = ACTIONS(97),
    [sym_private_property_identifier] = ACTIONS(99),
    [sym_this] = ACTIONS(101),
    [sym_super] = ACTIONS(103),
    [sym_true] = ACTIONS(105),
    [sym_false] = ACTIONS(105),
    [sym_null] = ACTIONS(105),
    [sym_undefined] = ACTIONS(107),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(21),
    [anon_sym_readonly] = ACTIONS(111),
    [anon_sym_get] = ACTIONS(21),
    [anon_sym_set] = ACTIONS(21),
    [anon_sym_QMARK] = ACTIONS(113),
    [anon_sym_declare] = ACTIONS(21),
    [anon_sym_public] = ACTIONS(21),
    [anon_sym_private] = ACTIONS(21),
    [anon_sym_protected] = ACTIONS(21),
    [anon_sym_override] = ACTIONS(21),
    [anon_sym_module] = ACTIONS(21),
    [anon_sym_any] = ACTIONS(115),
    [anon_sym_number] = ACTIONS(115),
    [anon_sym_boolean] = ACTIONS(115),
    [anon_sym_string] = ACTIONS(115),
    [anon_sym_symbol] = ACTIONS(115),
    [anon_sym_object] = ACTIONS(115),
    [anon_sym_property] = ACTIONS(21),
    [anon_sym_signal] = ACTIONS(21),
    [anon_sym_on] = ACTIONS(21),
    [anon_sym_required] = ACTIONS(21),
    [anon_sym_component] = ACTIONS(21),
    [anon_sym_abstract] = ACTIONS(117),
    [anon_sym_satisfies] = ACTIONS(28),
    [anon_sym_infer] = ACTIONS(119),
    [anon_sym_keyof] = ACTIONS(121),
    [anon_sym_unique] = ACTIONS(123),
    [anon_sym_unknown] = ACTIONS(125),
    [anon_sym_never] = ACTIONS(125),
    [anon_sym_LBRACE_PIPE] = ACTIONS(127),
    [sym__ternary_qmark] = ACTIONS(61),
    [sym_html_comment] = ACTIONS(5),
  },
  [4] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(18),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6515),
    [sym_object_assignment_pattern] = STATE(5617),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6515),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6515),
    [sym_spread_element] = STATE(5576),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2393),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_rest_pattern] = STATE(5617),
    [sym_method_definition] = STATE(5576),
    [sym_pair] = STATE(5576),
    [sym_pair_pattern] = STATE(5617),
    [sym__property_name] = STATE(3977),
    [sym_computed_property_name] = STATE(3977),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_accessibility_modifier] = STATE(2647),
    [sym_override_modifier] = STATE(2811),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(18),
    [aux_sym_object_repeat1] = STATE(5052),
    [aux_sym_object_pattern_repeat1] = STATE(4956),
    [sym_identifier] = ACTIONS(137),
    [anon_sym_export] = ACTIONS(139),
    [anon_sym_STAR] = ACTIONS(141),
    [anon_sym_type] = ACTIONS(143),
    [anon_sym_namespace] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_COMMA] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(151),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(157),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(163),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(199),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(203),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(207),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(211),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(225),
    [sym_private_property_identifier] = ACTIONS(227),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(233),
    [anon_sym_readonly] = ACTIONS(235),
    [anon_sym_get] = ACTIONS(237),
    [anon_sym_set] = ACTIONS(237),
    [anon_sym_declare] = ACTIONS(239),
    [anon_sym_public] = ACTIONS(241),
    [anon_sym_private] = ACTIONS(241),
    [anon_sym_protected] = ACTIONS(241),
    [anon_sym_override] = ACTIONS(243),
    [anon_sym_module] = ACTIONS(245),
    [anon_sym_any] = ACTIONS(157),
    [anon_sym_number] = ACTIONS(157),
    [anon_sym_boolean] = ACTIONS(157),
    [anon_sym_string] = ACTIONS(157),
    [anon_sym_symbol] = ACTIONS(157),
    [anon_sym_object] = ACTIONS(157),
    [anon_sym_property] = ACTIONS(157),
    [anon_sym_signal] = ACTIONS(157),
    [anon_sym_on] = ACTIONS(157),
    [anon_sym_required] = ACTIONS(157),
    [anon_sym_component] = ACTIONS(157),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [5] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(17),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6515),
    [sym_object_assignment_pattern] = STATE(5617),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6515),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6515),
    [sym_spread_element] = STATE(5576),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2393),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_rest_pattern] = STATE(5617),
    [sym_method_definition] = STATE(5576),
    [sym_pair] = STATE(5576),
    [sym_pair_pattern] = STATE(5617),
    [sym__property_name] = STATE(3977),
    [sym_computed_property_name] = STATE(3977),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_accessibility_modifier] = STATE(2647),
    [sym_override_modifier] = STATE(2811),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(17),
    [aux_sym_object_repeat1] = STATE(5052),
    [aux_sym_object_pattern_repeat1] = STATE(4956),
    [sym_identifier] = ACTIONS(137),
    [anon_sym_export] = ACTIONS(139),
    [anon_sym_STAR] = ACTIONS(141),
    [anon_sym_type] = ACTIONS(143),
    [anon_sym_namespace] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_COMMA] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(253),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(157),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(163),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(199),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(203),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(207),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(211),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(225),
    [sym_private_property_identifier] = ACTIONS(227),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(233),
    [anon_sym_readonly] = ACTIONS(235),
    [anon_sym_get] = ACTIONS(237),
    [anon_sym_set] = ACTIONS(237),
    [anon_sym_declare] = ACTIONS(239),
    [anon_sym_public] = ACTIONS(241),
    [anon_sym_private] = ACTIONS(241),
    [anon_sym_protected] = ACTIONS(241),
    [anon_sym_override] = ACTIONS(243),
    [anon_sym_module] = ACTIONS(245),
    [anon_sym_any] = ACTIONS(157),
    [anon_sym_number] = ACTIONS(157),
    [anon_sym_boolean] = ACTIONS(157),
    [anon_sym_string] = ACTIONS(157),
    [anon_sym_symbol] = ACTIONS(157),
    [anon_sym_object] = ACTIONS(157),
    [anon_sym_property] = ACTIONS(157),
    [anon_sym_signal] = ACTIONS(157),
    [anon_sym_on] = ACTIONS(157),
    [anon_sym_required] = ACTIONS(157),
    [anon_sym_component] = ACTIONS(157),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [6] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(21),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6515),
    [sym_object_assignment_pattern] = STATE(5617),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6515),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6515),
    [sym_spread_element] = STATE(5576),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2393),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_rest_pattern] = STATE(5617),
    [sym_method_definition] = STATE(5576),
    [sym_pair] = STATE(5576),
    [sym_pair_pattern] = STATE(5617),
    [sym__property_name] = STATE(3977),
    [sym_computed_property_name] = STATE(3977),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_accessibility_modifier] = STATE(2647),
    [sym_override_modifier] = STATE(2811),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(21),
    [aux_sym_object_repeat1] = STATE(5052),
    [aux_sym_object_pattern_repeat1] = STATE(4956),
    [sym_identifier] = ACTIONS(137),
    [anon_sym_export] = ACTIONS(139),
    [anon_sym_STAR] = ACTIONS(141),
    [anon_sym_type] = ACTIONS(143),
    [anon_sym_namespace] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_COMMA] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(255),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(157),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(163),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(199),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(203),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(207),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(211),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(225),
    [sym_private_property_identifier] = ACTIONS(227),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(233),
    [anon_sym_readonly] = ACTIONS(235),
    [anon_sym_get] = ACTIONS(237),
    [anon_sym_set] = ACTIONS(237),
    [anon_sym_declare] = ACTIONS(239),
    [anon_sym_public] = ACTIONS(241),
    [anon_sym_private] = ACTIONS(241),
    [anon_sym_protected] = ACTIONS(241),
    [anon_sym_override] = ACTIONS(243),
    [anon_sym_module] = ACTIONS(245),
    [anon_sym_any] = ACTIONS(157),
    [anon_sym_number] = ACTIONS(157),
    [anon_sym_boolean] = ACTIONS(157),
    [anon_sym_string] = ACTIONS(157),
    [anon_sym_symbol] = ACTIONS(157),
    [anon_sym_object] = ACTIONS(157),
    [anon_sym_property] = ACTIONS(157),
    [anon_sym_signal] = ACTIONS(157),
    [anon_sym_on] = ACTIONS(157),
    [anon_sym_required] = ACTIONS(157),
    [anon_sym_component] = ACTIONS(157),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [7] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(20),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6515),
    [sym_object_assignment_pattern] = STATE(5617),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6515),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6515),
    [sym_spread_element] = STATE(5000),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2393),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_rest_pattern] = STATE(5617),
    [sym_method_definition] = STATE(5000),
    [sym_pair] = STATE(5000),
    [sym_pair_pattern] = STATE(5617),
    [sym__property_name] = STATE(3977),
    [sym_computed_property_name] = STATE(3977),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_accessibility_modifier] = STATE(2647),
    [sym_override_modifier] = STATE(2811),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(20),
    [aux_sym_object_repeat1] = STATE(5003),
    [aux_sym_object_pattern_repeat1] = STATE(4956),
    [sym_identifier] = ACTIONS(257),
    [anon_sym_export] = ACTIONS(259),
    [anon_sym_STAR] = ACTIONS(141),
    [anon_sym_type] = ACTIONS(261),
    [anon_sym_namespace] = ACTIONS(263),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_COMMA] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(265),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(267),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(269),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(267),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(199),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(271),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(273),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(211),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(225),
    [sym_private_property_identifier] = ACTIONS(227),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(275),
    [anon_sym_readonly] = ACTIONS(277),
    [anon_sym_get] = ACTIONS(279),
    [anon_sym_set] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_public] = ACTIONS(283),
    [anon_sym_private] = ACTIONS(283),
    [anon_sym_protected] = ACTIONS(283),
    [anon_sym_override] = ACTIONS(285),
    [anon_sym_module] = ACTIONS(287),
    [anon_sym_any] = ACTIONS(267),
    [anon_sym_number] = ACTIONS(267),
    [anon_sym_boolean] = ACTIONS(267),
    [anon_sym_string] = ACTIONS(267),
    [anon_sym_symbol] = ACTIONS(267),
    [anon_sym_object] = ACTIONS(267),
    [anon_sym_property] = ACTIONS(267),
    [anon_sym_signal] = ACTIONS(267),
    [anon_sym_on] = ACTIONS(267),
    [anon_sym_required] = ACTIONS(267),
    [anon_sym_component] = ACTIONS(267),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [8] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(20),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6515),
    [sym_object_assignment_pattern] = STATE(5617),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6515),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6515),
    [sym_spread_element] = STATE(5000),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2393),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_rest_pattern] = STATE(5617),
    [sym_method_definition] = STATE(5000),
    [sym_pair] = STATE(5000),
    [sym_pair_pattern] = STATE(5617),
    [sym__property_name] = STATE(3977),
    [sym_computed_property_name] = STATE(3977),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_accessibility_modifier] = STATE(2647),
    [sym_override_modifier] = STATE(2811),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(20),
    [aux_sym_object_repeat1] = STATE(5003),
    [aux_sym_object_pattern_repeat1] = STATE(4956),
    [sym_identifier] = ACTIONS(289),
    [anon_sym_export] = ACTIONS(291),
    [anon_sym_STAR] = ACTIONS(141),
    [anon_sym_type] = ACTIONS(293),
    [anon_sym_namespace] = ACTIONS(295),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_COMMA] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(265),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(297),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(299),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(297),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(199),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(301),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(303),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(211),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(225),
    [sym_private_property_identifier] = ACTIONS(227),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(305),
    [anon_sym_readonly] = ACTIONS(307),
    [anon_sym_get] = ACTIONS(309),
    [anon_sym_set] = ACTIONS(309),
    [anon_sym_declare] = ACTIONS(311),
    [anon_sym_public] = ACTIONS(313),
    [anon_sym_private] = ACTIONS(313),
    [anon_sym_protected] = ACTIONS(313),
    [anon_sym_override] = ACTIONS(315),
    [anon_sym_module] = ACTIONS(317),
    [anon_sym_any] = ACTIONS(297),
    [anon_sym_number] = ACTIONS(297),
    [anon_sym_boolean] = ACTIONS(297),
    [anon_sym_string] = ACTIONS(297),
    [anon_sym_symbol] = ACTIONS(297),
    [anon_sym_object] = ACTIONS(297),
    [anon_sym_property] = ACTIONS(297),
    [anon_sym_signal] = ACTIONS(297),
    [anon_sym_on] = ACTIONS(297),
    [anon_sym_required] = ACTIONS(297),
    [anon_sym_component] = ACTIONS(297),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [9] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(17),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6515),
    [sym_object_assignment_pattern] = STATE(5617),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6515),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6515),
    [sym_spread_element] = STATE(5576),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2393),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_rest_pattern] = STATE(5617),
    [sym_method_definition] = STATE(5576),
    [sym_pair] = STATE(5576),
    [sym_pair_pattern] = STATE(5617),
    [sym__property_name] = STATE(3977),
    [sym_computed_property_name] = STATE(3977),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_accessibility_modifier] = STATE(2647),
    [sym_override_modifier] = STATE(2811),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(17),
    [aux_sym_object_repeat1] = STATE(5052),
    [aux_sym_object_pattern_repeat1] = STATE(4956),
    [sym_identifier] = ACTIONS(137),
    [anon_sym_export] = ACTIONS(139),
    [anon_sym_STAR] = ACTIONS(141),
    [anon_sym_type] = ACTIONS(143),
    [anon_sym_namespace] = ACTIONS(145),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_COMMA] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(319),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(157),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(163),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(157),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(199),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(203),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(207),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(211),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(225),
    [sym_private_property_identifier] = ACTIONS(227),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(233),
    [anon_sym_readonly] = ACTIONS(235),
    [anon_sym_get] = ACTIONS(237),
    [anon_sym_set] = ACTIONS(237),
    [anon_sym_declare] = ACTIONS(239),
    [anon_sym_public] = ACTIONS(241),
    [anon_sym_private] = ACTIONS(241),
    [anon_sym_protected] = ACTIONS(241),
    [anon_sym_override] = ACTIONS(243),
    [anon_sym_module] = ACTIONS(245),
    [anon_sym_any] = ACTIONS(157),
    [anon_sym_number] = ACTIONS(157),
    [anon_sym_boolean] = ACTIONS(157),
    [anon_sym_string] = ACTIONS(157),
    [anon_sym_symbol] = ACTIONS(157),
    [anon_sym_object] = ACTIONS(157),
    [anon_sym_property] = ACTIONS(157),
    [anon_sym_signal] = ACTIONS(157),
    [anon_sym_on] = ACTIONS(157),
    [anon_sym_required] = ACTIONS(157),
    [anon_sym_component] = ACTIONS(157),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [10] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(20),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6515),
    [sym_object_assignment_pattern] = STATE(5617),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6515),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6515),
    [sym_spread_element] = STATE(5000),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2393),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_rest_pattern] = STATE(5617),
    [sym_method_definition] = STATE(5000),
    [sym_pair] = STATE(5000),
    [sym_pair_pattern] = STATE(5617),
    [sym__property_name] = STATE(3977),
    [sym_computed_property_name] = STATE(3977),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_accessibility_modifier] = STATE(2647),
    [sym_override_modifier] = STATE(2811),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(20),
    [aux_sym_object_repeat1] = STATE(5003),
    [aux_sym_object_pattern_repeat1] = STATE(4956),
    [sym_identifier] = ACTIONS(321),
    [anon_sym_export] = ACTIONS(323),
    [anon_sym_STAR] = ACTIONS(141),
    [anon_sym_type] = ACTIONS(325),
    [anon_sym_namespace] = ACTIONS(327),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_COMMA] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(265),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(329),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(331),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(329),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(199),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(333),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(335),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(211),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(225),
    [sym_private_property_identifier] = ACTIONS(227),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(337),
    [anon_sym_readonly] = ACTIONS(339),
    [anon_sym_get] = ACTIONS(341),
    [anon_sym_set] = ACTIONS(341),
    [anon_sym_declare] = ACTIONS(343),
    [anon_sym_public] = ACTIONS(345),
    [anon_sym_private] = ACTIONS(345),
    [anon_sym_protected] = ACTIONS(345),
    [anon_sym_override] = ACTIONS(347),
    [anon_sym_module] = ACTIONS(349),
    [anon_sym_any] = ACTIONS(329),
    [anon_sym_number] = ACTIONS(329),
    [anon_sym_boolean] = ACTIONS(329),
    [anon_sym_string] = ACTIONS(329),
    [anon_sym_symbol] = ACTIONS(329),
    [anon_sym_object] = ACTIONS(329),
    [anon_sym_property] = ACTIONS(329),
    [anon_sym_signal] = ACTIONS(329),
    [anon_sym_on] = ACTIONS(329),
    [anon_sym_required] = ACTIONS(329),
    [anon_sym_component] = ACTIONS(329),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [11] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_default] = ACTIONS(355),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(361),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_case] = ACTIONS(355),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [12] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(15),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(15),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_default] = ACTIONS(381),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(383),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_case] = ACTIONS(381),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [13] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(11),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(11),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_default] = ACTIONS(385),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(387),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_case] = ACTIONS(385),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [14] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(389),
    [anon_sym_export] = ACTIONS(392),
    [anon_sym_default] = ACTIONS(395),
    [anon_sym_type] = ACTIONS(397),
    [anon_sym_namespace] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(403),
    [anon_sym_RBRACE] = ACTIONS(406),
    [anon_sym_typeof] = ACTIONS(408),
    [anon_sym_import] = ACTIONS(411),
    [anon_sym_from] = ACTIONS(414),
    [anon_sym_with] = ACTIONS(417),
    [anon_sym_var] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(423),
    [anon_sym_const] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(429),
    [anon_sym_if] = ACTIONS(432),
    [anon_sym_switch] = ACTIONS(435),
    [anon_sym_for] = ACTIONS(438),
    [anon_sym_LPAREN] = ACTIONS(441),
    [anon_sym_SEMI] = ACTIONS(444),
    [anon_sym_await] = ACTIONS(447),
    [anon_sym_of] = ACTIONS(414),
    [anon_sym_while] = ACTIONS(450),
    [anon_sym_do] = ACTIONS(453),
    [anon_sym_try] = ACTIONS(456),
    [anon_sym_break] = ACTIONS(459),
    [anon_sym_continue] = ACTIONS(462),
    [anon_sym_debugger] = ACTIONS(465),
    [anon_sym_return] = ACTIONS(468),
    [anon_sym_throw] = ACTIONS(471),
    [anon_sym_case] = ACTIONS(395),
    [anon_sym_yield] = ACTIONS(474),
    [anon_sym_LBRACK] = ACTIONS(477),
    [anon_sym_class] = ACTIONS(480),
    [anon_sym_async] = ACTIONS(483),
    [anon_sym_function] = ACTIONS(486),
    [anon_sym_new] = ACTIONS(489),
    [anon_sym_using] = ACTIONS(492),
    [anon_sym_PLUS] = ACTIONS(408),
    [anon_sym_DASH] = ACTIONS(408),
    [anon_sym_SLASH] = ACTIONS(495),
    [anon_sym_LT] = ACTIONS(498),
    [anon_sym_TILDE] = ACTIONS(429),
    [anon_sym_void] = ACTIONS(408),
    [anon_sym_delete] = ACTIONS(408),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [anon_sym_DQUOTE] = ACTIONS(504),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(510),
    [sym_number] = ACTIONS(513),
    [sym_private_property_identifier] = ACTIONS(516),
    [sym_this] = ACTIONS(519),
    [sym_super] = ACTIONS(519),
    [sym_true] = ACTIONS(519),
    [sym_false] = ACTIONS(519),
    [sym_null] = ACTIONS(519),
    [sym_undefined] = ACTIONS(522),
    [anon_sym_AT] = ACTIONS(525),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_readonly] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [anon_sym_declare] = ACTIONS(528),
    [anon_sym_public] = ACTIONS(414),
    [anon_sym_private] = ACTIONS(414),
    [anon_sym_protected] = ACTIONS(414),
    [anon_sym_override] = ACTIONS(414),
    [anon_sym_module] = ACTIONS(531),
    [anon_sym_any] = ACTIONS(414),
    [anon_sym_number] = ACTIONS(414),
    [anon_sym_boolean] = ACTIONS(414),
    [anon_sym_string] = ACTIONS(414),
    [anon_sym_symbol] = ACTIONS(414),
    [anon_sym_object] = ACTIONS(414),
    [anon_sym_property] = ACTIONS(414),
    [anon_sym_signal] = ACTIONS(414),
    [anon_sym_on] = ACTIONS(414),
    [anon_sym_required] = ACTIONS(414),
    [anon_sym_component] = ACTIONS(414),
    [anon_sym_abstract] = ACTIONS(534),
    [anon_sym_interface] = ACTIONS(537),
    [anon_sym_enum] = ACTIONS(540),
    [sym_html_comment] = ACTIONS(5),
  },
  [15] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_default] = ACTIONS(543),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(545),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_case] = ACTIONS(543),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [16] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(17),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(17),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(547),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [17] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(549),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [18] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(551),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [19] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(31),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(31),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(553),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [20] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(555),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [21] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(557),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [22] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(21),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(21),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(559),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [23] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(20),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(20),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(561),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [24] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(563),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [25] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(565),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [26] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(24),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(24),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(567),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [27] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(18),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(18),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(569),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [28] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(571),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [29] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(25),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(25),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(573),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [30] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(28),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(28),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(575),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [31] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [aux_sym_statement_block_repeat1] = STATE(14),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_RBRACE] = ACTIONS(577),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [32] = {
    [sym_export_statement] = STATE(2972),
    [sym_declaration] = STATE(2972),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(2972),
    [sym_statement] = STATE(3006),
    [sym_expression_statement] = STATE(2972),
    [sym_variable_declaration] = STATE(2989),
    [sym_lexical_declaration] = STATE(2989),
    [sym_statement_block] = STATE(2972),
    [sym_if_statement] = STATE(2972),
    [sym_switch_statement] = STATE(2972),
    [sym_for_statement] = STATE(2972),
    [sym_for_in_statement] = STATE(2972),
    [sym_while_statement] = STATE(2972),
    [sym_do_statement] = STATE(2972),
    [sym_try_statement] = STATE(2972),
    [sym_with_statement] = STATE(2972),
    [sym_break_statement] = STATE(2972),
    [sym_continue_statement] = STATE(2972),
    [sym_debugger_statement] = STATE(2972),
    [sym_return_statement] = STATE(2972),
    [sym_throw_statement] = STATE(2972),
    [sym_empty_statement] = STATE(2972),
    [sym_labeled_statement] = STATE(2972),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2208),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(2989),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(2989),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(2989),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(5719),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(2989),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(2989),
    [sym_abstract_class_declaration] = STATE(2989),
    [sym_module] = STATE(2989),
    [sym_internal_module] = STATE(1002),
    [sym_import_alias] = STATE(2989),
    [sym_interface_declaration] = STATE(2989),
    [sym_enum_declaration] = STATE(2989),
    [sym_type_alias_declaration] = STATE(2989),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4109),
    [sym_identifier] = ACTIONS(579),
    [anon_sym_export] = ACTIONS(581),
    [anon_sym_type] = ACTIONS(583),
    [anon_sym_namespace] = ACTIONS(585),
    [anon_sym_LBRACE] = ACTIONS(587),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(589),
    [anon_sym_from] = ACTIONS(591),
    [anon_sym_with] = ACTIONS(593),
    [anon_sym_var] = ACTIONS(595),
    [anon_sym_let] = ACTIONS(597),
    [anon_sym_const] = ACTIONS(599),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(601),
    [anon_sym_switch] = ACTIONS(603),
    [anon_sym_for] = ACTIONS(605),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(607),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(591),
    [anon_sym_while] = ACTIONS(609),
    [anon_sym_do] = ACTIONS(611),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_break] = ACTIONS(615),
    [anon_sym_continue] = ACTIONS(617),
    [anon_sym_debugger] = ACTIONS(619),
    [anon_sym_return] = ACTIONS(621),
    [anon_sym_throw] = ACTIONS(623),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(625),
    [anon_sym_async] = ACTIONS(627),
    [anon_sym_function] = ACTIONS(629),
    [anon_sym_new] = ACTIONS(631),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(591),
    [anon_sym_readonly] = ACTIONS(591),
    [anon_sym_get] = ACTIONS(591),
    [anon_sym_set] = ACTIONS(591),
    [anon_sym_declare] = ACTIONS(633),
    [anon_sym_public] = ACTIONS(591),
    [anon_sym_private] = ACTIONS(591),
    [anon_sym_protected] = ACTIONS(591),
    [anon_sym_override] = ACTIONS(591),
    [anon_sym_module] = ACTIONS(635),
    [anon_sym_any] = ACTIONS(591),
    [anon_sym_number] = ACTIONS(591),
    [anon_sym_boolean] = ACTIONS(591),
    [anon_sym_string] = ACTIONS(591),
    [anon_sym_symbol] = ACTIONS(591),
    [anon_sym_object] = ACTIONS(591),
    [anon_sym_property] = ACTIONS(591),
    [anon_sym_signal] = ACTIONS(591),
    [anon_sym_on] = ACTIONS(591),
    [anon_sym_required] = ACTIONS(591),
    [anon_sym_component] = ACTIONS(591),
    [anon_sym_abstract] = ACTIONS(637),
    [anon_sym_interface] = ACTIONS(639),
    [anon_sym_enum] = ACTIONS(641),
    [sym_html_comment] = ACTIONS(5),
  },
  [33] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(858),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [34] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(859),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [35] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(857),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [36] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(866),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [37] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(867),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [38] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(868),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [39] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(891),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [40] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(810),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [41] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(875),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2208),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(5719),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(2636),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4245),
    [sym_identifier] = ACTIONS(643),
    [anon_sym_export] = ACTIONS(645),
    [anon_sym_type] = ACTIONS(647),
    [anon_sym_namespace] = ACTIONS(649),
    [anon_sym_LBRACE] = ACTIONS(651),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(653),
    [anon_sym_with] = ACTIONS(655),
    [anon_sym_var] = ACTIONS(595),
    [anon_sym_let] = ACTIONS(657),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(659),
    [anon_sym_switch] = ACTIONS(603),
    [anon_sym_for] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(607),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(653),
    [anon_sym_while] = ACTIONS(663),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(665),
    [anon_sym_async] = ACTIONS(667),
    [anon_sym_function] = ACTIONS(669),
    [anon_sym_new] = ACTIONS(671),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(653),
    [anon_sym_readonly] = ACTIONS(653),
    [anon_sym_get] = ACTIONS(653),
    [anon_sym_set] = ACTIONS(653),
    [anon_sym_declare] = ACTIONS(673),
    [anon_sym_public] = ACTIONS(653),
    [anon_sym_private] = ACTIONS(653),
    [anon_sym_protected] = ACTIONS(653),
    [anon_sym_override] = ACTIONS(653),
    [anon_sym_module] = ACTIONS(675),
    [anon_sym_any] = ACTIONS(653),
    [anon_sym_number] = ACTIONS(653),
    [anon_sym_boolean] = ACTIONS(653),
    [anon_sym_string] = ACTIONS(653),
    [anon_sym_symbol] = ACTIONS(653),
    [anon_sym_object] = ACTIONS(653),
    [anon_sym_property] = ACTIONS(653),
    [anon_sym_signal] = ACTIONS(653),
    [anon_sym_on] = ACTIONS(653),
    [anon_sym_required] = ACTIONS(653),
    [anon_sym_component] = ACTIONS(653),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [42] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(883),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2208),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(5719),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(2636),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4245),
    [sym_identifier] = ACTIONS(643),
    [anon_sym_export] = ACTIONS(645),
    [anon_sym_type] = ACTIONS(647),
    [anon_sym_namespace] = ACTIONS(649),
    [anon_sym_LBRACE] = ACTIONS(651),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(653),
    [anon_sym_with] = ACTIONS(655),
    [anon_sym_var] = ACTIONS(595),
    [anon_sym_let] = ACTIONS(657),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(659),
    [anon_sym_switch] = ACTIONS(603),
    [anon_sym_for] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(607),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(653),
    [anon_sym_while] = ACTIONS(663),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(665),
    [anon_sym_async] = ACTIONS(667),
    [anon_sym_function] = ACTIONS(669),
    [anon_sym_new] = ACTIONS(671),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(653),
    [anon_sym_readonly] = ACTIONS(653),
    [anon_sym_get] = ACTIONS(653),
    [anon_sym_set] = ACTIONS(653),
    [anon_sym_declare] = ACTIONS(673),
    [anon_sym_public] = ACTIONS(653),
    [anon_sym_private] = ACTIONS(653),
    [anon_sym_protected] = ACTIONS(653),
    [anon_sym_override] = ACTIONS(653),
    [anon_sym_module] = ACTIONS(675),
    [anon_sym_any] = ACTIONS(653),
    [anon_sym_number] = ACTIONS(653),
    [anon_sym_boolean] = ACTIONS(653),
    [anon_sym_string] = ACTIONS(653),
    [anon_sym_symbol] = ACTIONS(653),
    [anon_sym_object] = ACTIONS(653),
    [anon_sym_property] = ACTIONS(653),
    [anon_sym_signal] = ACTIONS(653),
    [anon_sym_on] = ACTIONS(653),
    [anon_sym_required] = ACTIONS(653),
    [anon_sym_component] = ACTIONS(653),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [43] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(884),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2208),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(5719),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(2636),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4245),
    [sym_identifier] = ACTIONS(643),
    [anon_sym_export] = ACTIONS(645),
    [anon_sym_type] = ACTIONS(647),
    [anon_sym_namespace] = ACTIONS(649),
    [anon_sym_LBRACE] = ACTIONS(651),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(653),
    [anon_sym_with] = ACTIONS(655),
    [anon_sym_var] = ACTIONS(595),
    [anon_sym_let] = ACTIONS(657),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(659),
    [anon_sym_switch] = ACTIONS(603),
    [anon_sym_for] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(607),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(653),
    [anon_sym_while] = ACTIONS(663),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(665),
    [anon_sym_async] = ACTIONS(667),
    [anon_sym_function] = ACTIONS(669),
    [anon_sym_new] = ACTIONS(671),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(653),
    [anon_sym_readonly] = ACTIONS(653),
    [anon_sym_get] = ACTIONS(653),
    [anon_sym_set] = ACTIONS(653),
    [anon_sym_declare] = ACTIONS(673),
    [anon_sym_public] = ACTIONS(653),
    [anon_sym_private] = ACTIONS(653),
    [anon_sym_protected] = ACTIONS(653),
    [anon_sym_override] = ACTIONS(653),
    [anon_sym_module] = ACTIONS(675),
    [anon_sym_any] = ACTIONS(653),
    [anon_sym_number] = ACTIONS(653),
    [anon_sym_boolean] = ACTIONS(653),
    [anon_sym_string] = ACTIONS(653),
    [anon_sym_symbol] = ACTIONS(653),
    [anon_sym_object] = ACTIONS(653),
    [anon_sym_property] = ACTIONS(653),
    [anon_sym_signal] = ACTIONS(653),
    [anon_sym_on] = ACTIONS(653),
    [anon_sym_required] = ACTIONS(653),
    [anon_sym_component] = ACTIONS(653),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [44] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(838),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2208),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(5719),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(2636),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4245),
    [sym_identifier] = ACTIONS(643),
    [anon_sym_export] = ACTIONS(645),
    [anon_sym_type] = ACTIONS(647),
    [anon_sym_namespace] = ACTIONS(649),
    [anon_sym_LBRACE] = ACTIONS(651),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(653),
    [anon_sym_with] = ACTIONS(655),
    [anon_sym_var] = ACTIONS(595),
    [anon_sym_let] = ACTIONS(657),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(659),
    [anon_sym_switch] = ACTIONS(603),
    [anon_sym_for] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(607),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(653),
    [anon_sym_while] = ACTIONS(663),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(665),
    [anon_sym_async] = ACTIONS(667),
    [anon_sym_function] = ACTIONS(669),
    [anon_sym_new] = ACTIONS(671),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(653),
    [anon_sym_readonly] = ACTIONS(653),
    [anon_sym_get] = ACTIONS(653),
    [anon_sym_set] = ACTIONS(653),
    [anon_sym_declare] = ACTIONS(673),
    [anon_sym_public] = ACTIONS(653),
    [anon_sym_private] = ACTIONS(653),
    [anon_sym_protected] = ACTIONS(653),
    [anon_sym_override] = ACTIONS(653),
    [anon_sym_module] = ACTIONS(675),
    [anon_sym_any] = ACTIONS(653),
    [anon_sym_number] = ACTIONS(653),
    [anon_sym_boolean] = ACTIONS(653),
    [anon_sym_string] = ACTIONS(653),
    [anon_sym_symbol] = ACTIONS(653),
    [anon_sym_object] = ACTIONS(653),
    [anon_sym_property] = ACTIONS(653),
    [anon_sym_signal] = ACTIONS(653),
    [anon_sym_on] = ACTIONS(653),
    [anon_sym_required] = ACTIONS(653),
    [anon_sym_component] = ACTIONS(653),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [45] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(912),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2290),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(6054),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(257),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4156),
    [sym_identifier] = ACTIONS(351),
    [anon_sym_export] = ACTIONS(353),
    [anon_sym_type] = ACTIONS(357),
    [anon_sym_namespace] = ACTIONS(359),
    [anon_sym_LBRACE] = ACTIONS(147),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(363),
    [anon_sym_with] = ACTIONS(159),
    [anon_sym_var] = ACTIONS(161),
    [anon_sym_let] = ACTIONS(365),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(169),
    [anon_sym_switch] = ACTIONS(171),
    [anon_sym_for] = ACTIONS(173),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(177),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(363),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(185),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(201),
    [anon_sym_async] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(363),
    [anon_sym_readonly] = ACTIONS(363),
    [anon_sym_get] = ACTIONS(363),
    [anon_sym_set] = ACTIONS(363),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_public] = ACTIONS(363),
    [anon_sym_private] = ACTIONS(363),
    [anon_sym_protected] = ACTIONS(363),
    [anon_sym_override] = ACTIONS(363),
    [anon_sym_module] = ACTIONS(379),
    [anon_sym_any] = ACTIONS(363),
    [anon_sym_number] = ACTIONS(363),
    [anon_sym_boolean] = ACTIONS(363),
    [anon_sym_string] = ACTIONS(363),
    [anon_sym_symbol] = ACTIONS(363),
    [anon_sym_object] = ACTIONS(363),
    [anon_sym_property] = ACTIONS(363),
    [anon_sym_signal] = ACTIONS(363),
    [anon_sym_on] = ACTIONS(363),
    [anon_sym_required] = ACTIONS(363),
    [anon_sym_component] = ACTIONS(363),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [46] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(844),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2208),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(5719),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(2636),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4245),
    [sym_identifier] = ACTIONS(643),
    [anon_sym_export] = ACTIONS(645),
    [anon_sym_type] = ACTIONS(647),
    [anon_sym_namespace] = ACTIONS(649),
    [anon_sym_LBRACE] = ACTIONS(651),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(653),
    [anon_sym_with] = ACTIONS(655),
    [anon_sym_var] = ACTIONS(595),
    [anon_sym_let] = ACTIONS(657),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(659),
    [anon_sym_switch] = ACTIONS(603),
    [anon_sym_for] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(607),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(653),
    [anon_sym_while] = ACTIONS(663),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(665),
    [anon_sym_async] = ACTIONS(667),
    [anon_sym_function] = ACTIONS(669),
    [anon_sym_new] = ACTIONS(671),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(653),
    [anon_sym_readonly] = ACTIONS(653),
    [anon_sym_get] = ACTIONS(653),
    [anon_sym_set] = ACTIONS(653),
    [anon_sym_declare] = ACTIONS(673),
    [anon_sym_public] = ACTIONS(653),
    [anon_sym_private] = ACTIONS(653),
    [anon_sym_protected] = ACTIONS(653),
    [anon_sym_override] = ACTIONS(653),
    [anon_sym_module] = ACTIONS(675),
    [anon_sym_any] = ACTIONS(653),
    [anon_sym_number] = ACTIONS(653),
    [anon_sym_boolean] = ACTIONS(653),
    [anon_sym_string] = ACTIONS(653),
    [anon_sym_symbol] = ACTIONS(653),
    [anon_sym_object] = ACTIONS(653),
    [anon_sym_property] = ACTIONS(653),
    [anon_sym_signal] = ACTIONS(653),
    [anon_sym_on] = ACTIONS(653),
    [anon_sym_required] = ACTIONS(653),
    [anon_sym_component] = ACTIONS(653),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [47] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(857),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2208),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(5719),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(2636),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4245),
    [sym_identifier] = ACTIONS(643),
    [anon_sym_export] = ACTIONS(645),
    [anon_sym_type] = ACTIONS(647),
    [anon_sym_namespace] = ACTIONS(649),
    [anon_sym_LBRACE] = ACTIONS(651),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(653),
    [anon_sym_with] = ACTIONS(655),
    [anon_sym_var] = ACTIONS(595),
    [anon_sym_let] = ACTIONS(657),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(659),
    [anon_sym_switch] = ACTIONS(603),
    [anon_sym_for] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(607),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(653),
    [anon_sym_while] = ACTIONS(663),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(665),
    [anon_sym_async] = ACTIONS(667),
    [anon_sym_function] = ACTIONS(669),
    [anon_sym_new] = ACTIONS(671),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(653),
    [anon_sym_readonly] = ACTIONS(653),
    [anon_sym_get] = ACTIONS(653),
    [anon_sym_set] = ACTIONS(653),
    [anon_sym_declare] = ACTIONS(673),
    [anon_sym_public] = ACTIONS(653),
    [anon_sym_private] = ACTIONS(653),
    [anon_sym_protected] = ACTIONS(653),
    [anon_sym_override] = ACTIONS(653),
    [anon_sym_module] = ACTIONS(675),
    [anon_sym_any] = ACTIONS(653),
    [anon_sym_number] = ACTIONS(653),
    [anon_sym_boolean] = ACTIONS(653),
    [anon_sym_string] = ACTIONS(653),
    [anon_sym_symbol] = ACTIONS(653),
    [anon_sym_object] = ACTIONS(653),
    [anon_sym_property] = ACTIONS(653),
    [anon_sym_signal] = ACTIONS(653),
    [anon_sym_on] = ACTIONS(653),
    [anon_sym_required] = ACTIONS(653),
    [anon_sym_component] = ACTIONS(653),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [48] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(858),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2208),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(5719),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(2636),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4245),
    [sym_identifier] = ACTIONS(643),
    [anon_sym_export] = ACTIONS(645),
    [anon_sym_type] = ACTIONS(647),
    [anon_sym_namespace] = ACTIONS(649),
    [anon_sym_LBRACE] = ACTIONS(651),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(653),
    [anon_sym_with] = ACTIONS(655),
    [anon_sym_var] = ACTIONS(595),
    [anon_sym_let] = ACTIONS(657),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(659),
    [anon_sym_switch] = ACTIONS(603),
    [anon_sym_for] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(607),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(653),
    [anon_sym_while] = ACTIONS(663),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(665),
    [anon_sym_async] = ACTIONS(667),
    [anon_sym_function] = ACTIONS(669),
    [anon_sym_new] = ACTIONS(671),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(653),
    [anon_sym_readonly] = ACTIONS(653),
    [anon_sym_get] = ACTIONS(653),
    [anon_sym_set] = ACTIONS(653),
    [anon_sym_declare] = ACTIONS(673),
    [anon_sym_public] = ACTIONS(653),
    [anon_sym_private] = ACTIONS(653),
    [anon_sym_protected] = ACTIONS(653),
    [anon_sym_override] = ACTIONS(653),
    [anon_sym_module] = ACTIONS(675),
    [anon_sym_any] = ACTIONS(653),
    [anon_sym_number] = ACTIONS(653),
    [anon_sym_boolean] = ACTIONS(653),
    [anon_sym_string] = ACTIONS(653),
    [anon_sym_symbol] = ACTIONS(653),
    [anon_sym_object] = ACTIONS(653),
    [anon_sym_property] = ACTIONS(653),
    [anon_sym_signal] = ACTIONS(653),
    [anon_sym_on] = ACTIONS(653),
    [anon_sym_required] = ACTIONS(653),
    [anon_sym_component] = ACTIONS(653),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [49] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(859),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2208),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(5719),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(2636),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4245),
    [sym_identifier] = ACTIONS(643),
    [anon_sym_export] = ACTIONS(645),
    [anon_sym_type] = ACTIONS(647),
    [anon_sym_namespace] = ACTIONS(649),
    [anon_sym_LBRACE] = ACTIONS(651),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(653),
    [anon_sym_with] = ACTIONS(655),
    [anon_sym_var] = ACTIONS(595),
    [anon_sym_let] = ACTIONS(657),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(659),
    [anon_sym_switch] = ACTIONS(603),
    [anon_sym_for] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(607),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(653),
    [anon_sym_while] = ACTIONS(663),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(665),
    [anon_sym_async] = ACTIONS(667),
    [anon_sym_function] = ACTIONS(669),
    [anon_sym_new] = ACTIONS(671),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(653),
    [anon_sym_readonly] = ACTIONS(653),
    [anon_sym_get] = ACTIONS(653),
    [anon_sym_set] = ACTIONS(653),
    [anon_sym_declare] = ACTIONS(673),
    [anon_sym_public] = ACTIONS(653),
    [anon_sym_private] = ACTIONS(653),
    [anon_sym_protected] = ACTIONS(653),
    [anon_sym_override] = ACTIONS(653),
    [anon_sym_module] = ACTIONS(675),
    [anon_sym_any] = ACTIONS(653),
    [anon_sym_number] = ACTIONS(653),
    [anon_sym_boolean] = ACTIONS(653),
    [anon_sym_string] = ACTIONS(653),
    [anon_sym_symbol] = ACTIONS(653),
    [anon_sym_object] = ACTIONS(653),
    [anon_sym_property] = ACTIONS(653),
    [anon_sym_signal] = ACTIONS(653),
    [anon_sym_on] = ACTIONS(653),
    [anon_sym_required] = ACTIONS(653),
    [anon_sym_component] = ACTIONS(653),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [50] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(865),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2208),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(5719),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(2636),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4245),
    [sym_identifier] = ACTIONS(643),
    [anon_sym_export] = ACTIONS(645),
    [anon_sym_type] = ACTIONS(647),
    [anon_sym_namespace] = ACTIONS(649),
    [anon_sym_LBRACE] = ACTIONS(651),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(653),
    [anon_sym_with] = ACTIONS(655),
    [anon_sym_var] = ACTIONS(595),
    [anon_sym_let] = ACTIONS(657),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(659),
    [anon_sym_switch] = ACTIONS(603),
    [anon_sym_for] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_sym_SEMI] = ACTIONS(607),
    [anon_sym_await] = ACTIONS(179),
    [anon_sym_of] = ACTIONS(653),
    [anon_sym_while] = ACTIONS(663),
    [anon_sym_do] = ACTIONS(183),
    [anon_sym_try] = ACTIONS(613),
    [anon_sym_break] = ACTIONS(187),
    [anon_sym_continue] = ACTIONS(189),
    [anon_sym_debugger] = ACTIONS(191),
    [anon_sym_return] = ACTIONS(193),
    [anon_sym_throw] = ACTIONS(195),
    [anon_sym_yield] = ACTIONS(197),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_class] = ACTIONS(665),
    [anon_sym_async] = ACTIONS(667),
    [anon_sym_function] = ACTIONS(669),
    [anon_sym_new] = ACTIONS(671),
    [anon_sym_using] = ACTIONS(209),
    [anon_sym_PLUS] = ACTIONS(153),
    [anon_sym_DASH] = ACTIONS(153),
    [anon_sym_SLASH] = ACTIONS(213),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_TILDE] = ACTIONS(167),
    [anon_sym_void] = ACTIONS(153),
    [anon_sym_delete] = ACTIONS(153),
    [anon_sym_PLUS_PLUS] = ACTIONS(217),
    [anon_sym_DASH_DASH] = ACTIONS(217),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_SQUOTE] = ACTIONS(221),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(223),
    [sym_number] = ACTIONS(373),
    [sym_private_property_identifier] = ACTIONS(375),
    [sym_this] = ACTIONS(229),
    [sym_super] = ACTIONS(229),
    [sym_true] = ACTIONS(229),
    [sym_false] = ACTIONS(229),
    [sym_null] = ACTIONS(229),
    [sym_undefined] = ACTIONS(231),
    [anon_sym_AT] = ACTIONS(109),
    [anon_sym_static] = ACTIONS(653),
    [anon_sym_readonly] = ACTIONS(653),
    [anon_sym_get] = ACTIONS(653),
    [anon_sym_set] = ACTIONS(653),
    [anon_sym_declare] = ACTIONS(673),
    [anon_sym_public] = ACTIONS(653),
    [anon_sym_private] = ACTIONS(653),
    [anon_sym_protected] = ACTIONS(653),
    [anon_sym_override] = ACTIONS(653),
    [anon_sym_module] = ACTIONS(675),
    [anon_sym_any] = ACTIONS(653),
    [anon_sym_number] = ACTIONS(653),
    [anon_sym_boolean] = ACTIONS(653),
    [anon_sym_string] = ACTIONS(653),
    [anon_sym_symbol] = ACTIONS(653),
    [anon_sym_object] = ACTIONS(653),
    [anon_sym_property] = ACTIONS(653),
    [anon_sym_signal] = ACTIONS(653),
    [anon_sym_on] = ACTIONS(653),
    [anon_sym_required] = ACTIONS(653),
    [anon_sym_component] = ACTIONS(653),
    [anon_sym_abstract] = ACTIONS(247),
    [anon_sym_interface] = ACTIONS(249),
    [anon_sym_enum] = ACTIONS(251),
    [sym_html_comment] = ACTIONS(5),
  },
  [51] = {
    [sym_export_statement] = STATE(820),
    [sym_declaration] = STATE(820),
    [sym_import] = STATE(3895),
    [sym_import_statement] = STATE(820),
    [sym_statement] = STATE(866),
    [sym_expression_statement] = STATE(820),
    [sym_variable_declaration] = STATE(885),
    [sym_lexical_declaration] = STATE(885),
    [sym_statement_block] = STATE(820),
    [sym_if_statement] = STATE(820),
    [sym_switch_statement] = STATE(820),
    [sym_for_statement] = STATE(820),
    [sym_for_in_statement] = STATE(820),
    [sym_while_statement] = STATE(820),
    [sym_do_statement] = STATE(820),
    [sym_try_statement] = STATE(820),
    [sym_with_statement] = STATE(820),
    [sym_break_statement] = STATE(820),
    [sym_continue_statement] = STATE(820),
    [sym_debugger_statement] = STATE(820),
    [sym_return_statement] = STATE(820),
    [sym_throw_statement] = STATE(820),
    [sym_empty_statement] = STATE(820),
    [sym_labeled_statement] = STATE(820),
    [sym_parenthesized_expression] = STATE(1470),
    [sym_expression] = STATE(2208),
    [sym_primary_expression] = STATE(2172),
    [sym_yield_expression] = STATE(2456),
    [sym_object] = STATE(2443),
    [sym_object_pattern] = STATE(6159),
    [sym_array] = STATE(2443),
    [sym_array_pattern] = STATE(6159),
    [sym_class] = STATE(2443),
    [sym_class_declaration] = STATE(885),
    [sym_function_expression] = STATE(2443),
    [sym_function_declaration] = STATE(885),
    [sym_generator_function] = STATE(2443),
    [sym_generator_function_declaration] = STATE(885),
    [sym_arrow_function] = STATE(2443),
    [sym__call_signature] = STATE(6222),
    [sym_call_expression] = STATE(2443),
    [sym_new_expression] = STATE(2385),
    [sym_await_expression] = STATE(2456),
    [sym_member_expression] = STATE(1470),
    [sym_subscript_expression] = STATE(1470),
    [sym_assignment_expression] = STATE(2456),
    [sym__augmented_assignment_lhs] = STATE(3306),
    [sym_augmented_assignment_expression] = STATE(2456),
    [sym__destructuring_pattern] = STATE(6159),
    [sym_ternary_expression] = STATE(2456),
    [sym_binary_expression] = STATE(2456),
    [sym_unary_expression] = STATE(2456),
    [sym_update_expression] = STATE(2456),
    [sym_sequence_expression] = STATE(5719),
    [sym_string] = STATE(2443),
    [sym_template_string] = STATE(2443),
    [sym_regex] = STATE(2443),
    [sym_meta_property] = STATE(2443),
    [sym_decorator] = STATE(1235),
    [sym_formal_parameters] = STATE(4203),
    [sym_non_null_expression] = STATE(1470),
    [sym_function_signature] = STATE(885),
    [sym_type_assertion] = STATE(2456),
    [sym_as_expression] = STATE(2456),
    [sym_satisfies_expression] = STATE(2456),
    [sym_instantiation_expression] = STATE(2456),
    [sym_ambient_declaration] = STATE(885),
    [sym_abstract_class_declaration] = STATE(885),
    [sym_module] = STATE(885),
    [sym_internal_module] = STATE(2636),
    [sym_import_alias] = STATE(885),
    [sym_interface_declaration] = STATE(885),
    [sym_enum_declaration] = STATE(885),
    [sym_type_alias_declaration] = STATE(885),
    [sym_type_arguments] = STATE(476),
    [sym_type_parameters] = STATE(5865),
    [aux_sym_export_statement_repeat1] = STATE(4245),
    [sym_identifier] = ACTIONS(643),
    [anon_sym_export] = ACTIONS(645),
    [anon_sym_type] = ACTIONS(647),
    [anon_sym_namespace] = ACTIONS(649),
    [anon_sym_LBRACE] = ACTIONS(651),
    [anon_sym_typeof] = ACTIONS(153),
    [anon_sym_import] = ACTIONS(155),
    [anon_sym_from] = ACTIONS(653),
    [anon_sym_with] = ACTIONS(655),
    [anon_sym_var] = ACTIONS(595),
    [anon_sym_let] = ACTIONS(657),
    [anon_sym_const] = ACTIONS(165),
    [anon_sym_BANG] = ACTIONS(167),
    [anon_sym_if] = ACTIONS(659),
    [anon_sym_switch] = ACTIONS(603),
    [anon_sym_for] = ACTIONS(661),
    [anon_sym_LPAREN] = ACTIONS(175),
    [anon_s