#!/bin/sh
# This is TkPasMan version @version@.
# Where do you wish to go today?\
test -z "$DISPLAY" &&\
	exec '@tclsh@' "$0" "$@";\
	exec '@wish@'  "$0" "$@"

package require Tcl 8.3

set state(X) [info exists tk_version]
if {$state(X)} {

  package require Tk 8.3

  # Disable remote control via X
  rename send {}
}

set Version {@version@}
set ConfigFile {@configfile@}

# Default user config. This array is saved.
array set conf {
  file			{@pwdfile@}
  readonly		0
  confirm-save-on-quit	1
  confirm-remove-site	1
  enable-dump-to-stdout	0
  dump-formatstring	{%s	%s	%s}
  show-passwd		0
  show-menu		1
  show-status		1
  save-windowsize	0
  geometry		{}
  skin			{}
  selection-delay	800
  onquit-save-options	0
}

# Command line state init. 
# This array is also used for other purposes. This array is not saved.
array set state {
  enable-dump		0
  enable-selection	1
  use-encryption	0
  readonly		0
  do-dump		0
  old-config		0
}
