/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.install4j.runtime.launcher.WindowChecker;
import com.install4j.runtime.splashscreen.JavaSplashScreen;
import java.awt.Frame;
import java.awt.Window;

public class SwingWindowChecker
extends WindowChecker {
    public SwingWindowChecker(Runnable runnable) {
        super(runnable);
    }

    protected boolean checkExecute() {
        return SwingWindowChecker.hasVisibleWindows();
    }

    public static boolean hasVisibleWindows() {
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            Frame frame = frameArray[i];
            if (frame.isShowing()) {
                return true;
            }
            if (!SwingWindowChecker.checkWindows(frame.getOwnedWindows())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkWindows(Window[] windowArray) {
        for (int i = 0; i < windowArray.length; ++i) {
            Window window = windowArray[i];
            if (!(window instanceof JavaSplashScreen) && window.isShowing()) {
                return true;
            }
            if (!SwingWindowChecker.checkWindows(window.getOwnedWindows())) continue;
            return true;
        }
        return false;
    }
}

