/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.runtime.installer.helper.comm.CommunicationBackend;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class PipeCommunicationBackend
implements CommunicationBackend {
    private static final String SPAWNED_SUFFIX = ".spawned";
    private static final String LISTENER_SUFFIX = ".listener";
    private DataInputStream is;
    private DataOutputStream os;
    private String baseFile;
    private boolean listener = false;

    private String getWriteFilePath() {
        return this.baseFile + (this.listener ? LISTENER_SUFFIX : SPAWNED_SUFFIX);
    }

    private String getReadFilePath() {
        return this.baseFile + (this.listener ? SPAWNED_SUFFIX : LISTENER_SUFFIX);
    }

    public String createListener() {
        try {
            this.listener = true;
            File file = File.createTempFile("i4c", ".com");
            file.deleteOnExit();
            String string = file.getAbsolutePath();
            while (new File(string + LISTENER_SUFFIX).exists() || new File(string + SPAWNED_SUFFIX).exists()) {
                file = File.createTempFile("i4c", ".com");
                file.deleteOnExit();
                string = file.getAbsolutePath();
            }
            this.baseFile = string;
            Execution.executeAndWait(new String[]{"mkfifo", "-m", "0600", this.getReadFilePath(), this.getWriteFilePath()}, null);
            new File(this.getReadFilePath()).deleteOnExit();
            new File(this.getWriteFilePath()).deleteOnExit();
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public boolean connect(String string) {
        if (string == null) {
            if (this.baseFile == null) {
                return false;
            }
        } else {
            this.baseFile = string;
        }
        return true;
    }

    public boolean writeDataBlock(byte[] byArray) {
        try {
            if (this.os == null) {
                this.os = new DataOutputStream(new FileOutputStream(this.getWriteFilePath()));
            }
            this.os.writeInt(byArray.length);
            this.os.flush();
            this.os.write(byArray);
            this.os.flush();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public byte[] readDataBlock() {
        try {
            if (this.is == null) {
                this.is = new DataInputStream(new FileInputStream(this.getReadFilePath()));
            }
            int n = this.is.readInt();
            byte[] byArray = new byte[n];
            this.is.readFully(byArray);
            return byArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

