/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.util.HyperlinkLabel;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class HyperlinkLabelComponent
extends LeadingLabelComponent {
    private String hyperlinkText;
    private String url;
    private HyperlinkLabel label;

    public String getHyperlinkText() {
        return this.hyperlinkText;
    }

    public void setHyperlinkText(String string) {
        this.hyperlinkText = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void initialize() {
        super.initialize();
        this.label.setText(HyperlinkLabelComponent.replaceVariables(this.hyperlinkText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE));
    }

    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.label != null && formEnvironment != null) {
            this.label.setName(formEnvironment.getId(this));
        }
    }

    public JComponent createCenterComponent() {
        this.label = new HyperlinkLabel(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HyperlinkLabelComponent.this.doHyperlink();
            }
        });
        return this.label;
    }

    private void doHyperlink() {
        if (this.getFormEnvironment().isDesignTime()) {
            return;
        }
        String string = HyperlinkLabelComponent.replaceVariables(this.url);
        if (string.length() == 0) {
            return;
        }
        try {
            URL uRL = new URL(string);
            Util.showUrl(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            Util.showErrorMessage("The url '" + string + "' is invalid");
        }
    }

    public boolean isFillCenterHorizontal() {
        return false;
    }

    public Object getConfigurationObject() {
        return this.label;
    }

    public Class getConfigurationObjectClass() {
        return JLabel.class;
    }

    public boolean handleConsole(Console console) {
        String string = HyperlinkLabelComponent.replaceVariables(this.url);
        String string2 = HyperlinkLabelComponent.replaceVariables(this.hyperlinkText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
        if (string2 != null && !string2.equals(string)) {
            console.println(string2 + " " + string);
        } else {
            console.println(string);
        }
        return true;
    }
}

