/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.IOException;

public class BackupFileForRollbackAction
extends SystemInstallAction {
    private File file;
    private boolean delete;
    private boolean failIfRenameDoesntWork = false;
    private boolean fallBackToParentDir = true;
    private File backupFile;
    private long modTime;
    private boolean fileDidNotExist = false;

    public BackupFileForRollbackAction() {
    }

    public BackupFileForRollbackAction(File file, boolean bl) {
        this.file = file;
        this.delete = bl;
    }

    public BackupFileForRollbackAction(File file, boolean bl, boolean bl2) {
        this.file = file;
        this.delete = bl;
        this.failIfRenameDoesntWork = bl2;
    }

    public BackupFileForRollbackAction(File file, boolean bl, boolean bl2, boolean bl3) {
        this.file = file;
        this.delete = bl;
        this.failIfRenameDoesntWork = bl2;
        this.fallBackToParentDir = bl3;
    }

    public File getFile() {
        return BackupFileForRollbackAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean bl) {
        this.delete = bl;
    }

    public boolean isFailIfRenameDoesntWork() {
        return this.failIfRenameDoesntWork;
    }

    public void setFailIfRenameDoesntWork(boolean bl) {
        this.failIfRenameDoesntWork = bl;
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        if (this.getFile() == null || this.getFile().getPath().trim().length() == 0) {
            return false;
        }
        File file = installerContext.getDestinationFile(this.getFile());
        if (!file.exists()) {
            this.fileDidNotExist = true;
            return true;
        }
        Util.logInfo(null, "Backing up " + file.getAbsolutePath());
        try {
            this.modTime = file.lastModified();
            this.backupFile = File.createTempFile("i4b", null);
            if (this.delete) {
                this.backupFile.delete();
                if (!file.renameTo(this.backupFile)) {
                    File file2;
                    if (this.fallBackToParentDir) {
                        try {
                            file2 = File.createTempFile("i4b", null, file.getParentFile());
                            file2.delete();
                        }
                        catch (IOException iOException) {
                            file2 = this.backupFile;
                        }
                    } else {
                        file2 = this.backupFile;
                    }
                    if (file.renameTo(file2)) {
                        this.backupFile = file2;
                    } else {
                        if (this.failIfRenameDoesntWork) {
                            this.backupFile = null;
                            return false;
                        }
                        FileUtil.copyFile(file, this.backupFile);
                        file.delete();
                    }
                }
            } else {
                FileUtil.copyFile(file, this.backupFile);
            }
            FileInstaller.getInstance().registerCleanupFile(this.backupFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.backupFile.delete();
            this.backupFile = null;
            return false;
        }
        return true;
    }

    public void rollback(InstallerContext installerContext) {
        if (this.fileDidNotExist) {
            installerContext.getDestinationFile(this.getFile()).delete();
        } else if (this.backupFile != null && this.backupFile.exists()) {
            File file = installerContext.getDestinationFile(this.getFile());
            try {
                file.delete();
                if (!this.backupFile.renameTo(file) && !this.failIfRenameDoesntWork) {
                    FileUtil.copyFile(this.backupFile, file);
                }
                file.setLastModified(this.modTime);
                this.backupFile.delete();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

