![Polychromatic](.github/logo.svg)

An open source RGB lighting management front-end application to customise
[OpenRazer] peripherals on GNU/Linux.

[![Build Status](https://github.com/polychromatic/polychromatic/actions/workflows/main.yml/badge.svg?branch=master&event=push)](https://github.com/polychromatic/polychromatic/actions?query=branch%3Amaster+event%3Apush)
[![Current Release](https://img.shields.io/github/release/polychromatic/polychromatic.svg)](https://github.com/polychromatic/polychromatic/releases)

![Screenshot of Polychromatic v0.7.0 Controller](.github/controller@2x.webp)

### [https://polychromatic.app](https://polychromatic.app)


## About

Polychromatic is a front-end for managing lighting, RGB effects and device properties
for Razer keyboards, mice, keypads. This project has a long-term
ambition to support peripherals from other brands too.

<!--
The software aims to make it easy to create and co-ordinate lighting effects
that work across all compatible hardware, even if you switch to another brand
also supported by Polychromatic.

Presets and triggers enables you to switch your lighting on-the-fly
to match the application or game that's currently playing.
-->

[View Features](https://polychromatic.app/features/) |
[View Screenshots](https://polychromatic.app/screenshots/) |
[View FAQs and Documentation](https://docs.polychromatic.app/)


## Device Support

Polychromatic on its own is just a frontend, it currently needs [OpenRazer]
installed to provide the actual communication with the hardware. Both projects only
run on Linux distributions.

[View Supported Devices](https://polychromatic.app/devices/)


## Download

Instructions for each supported Linux distro are provided on the website:

* <https://polychromatic.app/download/>

Installing packages from a software repository is recommended as this will keep
the software up-to-date, and your package system will keep track of dependencies.


## Something not working?

Occasionally, issues are caused by an improper [OpenRazer] driver installation.
Polychromatic includes a troubleshooter to identify common problems.
[See our FAQs on OpenRazer](https://docs.polychromatic.app/openrazer/#my-device-is-showing-up-as-unrecognised)
if your device is not showing up or shows an error when changing settings.

For bugs specific to Polychromatic, [please raise an issue here](https://github.com/polychromatic/polychromatic/issues/).


## Contributing

See [DEVELOPMENT.md](DEVELOPMENT.md) for instructions on running
the software locally.


## Translations

The software can speak multiple languages!
[Here's a guide](https://docs.polychromatic.app/translations/) if you'd like to contribute.


## Donations

If you love this software and wish to leave a little something to excite the
developer, you're welcome to do so [via paypal.me](https://www.paypal.me/LukeHorwell).
Thank you for your generosity!

[OpenRazer]: https://openrazer.github.io
