// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/video/transcoder/v1/services.proto

#include "google/cloud/video/transcoder/v1/internal/transcoder_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/video/transcoder/v1/services.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace video_transcoder_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TranscoderServiceMetadata::TranscoderServiceMetadata(
    std::shared_ptr<TranscoderServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::video::transcoder::v1::Job>
TranscoderServiceMetadata::CreateJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::video::transcoder::v1::CreateJobRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateJob(context, options, request);
}

StatusOr<google::cloud::video::transcoder::v1::ListJobsResponse>
TranscoderServiceMetadata::ListJobs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::video::transcoder::v1::ListJobsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListJobs(context, options, request);
}

StatusOr<google::cloud::video::transcoder::v1::Job>
TranscoderServiceMetadata::GetJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::video::transcoder::v1::GetJobRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetJob(context, options, request);
}

Status TranscoderServiceMetadata::DeleteJob(
    grpc::ClientContext& context, Options const& options,
    google::cloud::video::transcoder::v1::DeleteJobRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteJob(context, options, request);
}

StatusOr<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceMetadata::CreateJobTemplate(
    grpc::ClientContext& context, Options const& options,
    google::cloud::video::transcoder::v1::CreateJobTemplateRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateJobTemplate(context, options, request);
}

StatusOr<google::cloud::video::transcoder::v1::ListJobTemplatesResponse>
TranscoderServiceMetadata::ListJobTemplates(
    grpc::ClientContext& context, Options const& options,
    google::cloud::video::transcoder::v1::ListJobTemplatesRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListJobTemplates(context, options, request);
}

StatusOr<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceMetadata::GetJobTemplate(
    grpc::ClientContext& context, Options const& options,
    google::cloud::video::transcoder::v1::GetJobTemplateRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetJobTemplate(context, options, request);
}

Status TranscoderServiceMetadata::DeleteJobTemplate(
    grpc::ClientContext& context, Options const& options,
    google::cloud::video::transcoder::v1::DeleteJobTemplateRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteJobTemplate(context, options, request);
}

void TranscoderServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                            Options const& options,
                                            std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void TranscoderServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                            Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace video_transcoder_v1_internal
}  // namespace cloud
}  // namespace google
