// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudtrace/v1/trace.proto

#include "google/cloud/trace/v1/internal/trace_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace trace_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TraceServiceTracingConnection::TraceServiceTracingConnection(
    std::shared_ptr<trace_v1::TraceServiceConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::devtools::cloudtrace::v1::Trace>
TraceServiceTracingConnection::ListTraces(
    google::devtools::cloudtrace::v1::ListTracesRequest request) {
  auto span =
      internal::MakeSpan("trace_v1::TraceServiceConnection::ListTraces");
  internal::OTelScope scope(span);
  auto sr = child_->ListTraces(std::move(request));
  return internal::MakeTracedStreamRange<
      google::devtools::cloudtrace::v1::Trace>(std::move(span), std::move(sr));
}

StatusOr<google::devtools::cloudtrace::v1::Trace>
TraceServiceTracingConnection::GetTrace(
    google::devtools::cloudtrace::v1::GetTraceRequest const& request) {
  auto span = internal::MakeSpan("trace_v1::TraceServiceConnection::GetTrace");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTrace(request));
}

Status TraceServiceTracingConnection::PatchTraces(
    google::devtools::cloudtrace::v1::PatchTracesRequest const& request) {
  auto span =
      internal::MakeSpan("trace_v1::TraceServiceConnection::PatchTraces");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->PatchTraces(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<trace_v1::TraceServiceConnection>
MakeTraceServiceTracingConnection(
    std::shared_ptr<trace_v1::TraceServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<TraceServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace trace_v1_internal
}  // namespace cloud
}  // namespace google
