// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v1/cloud_speech.proto

#include "google/cloud/speech/v1/speech_connection.h"
#include "google/cloud/speech/v1/internal/speech_connection_impl.h"
#include "google/cloud/speech/v1/internal/speech_option_defaults.h"
#include "google/cloud/speech/v1/internal/speech_stub_factory.h"
#include "google/cloud/speech/v1/internal/speech_tracing_connection.h"
#include "google/cloud/speech/v1/speech_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace speech_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SpeechConnection::~SpeechConnection() = default;

StatusOr<google::cloud::speech::v1::RecognizeResponse>
SpeechConnection::Recognize(
    google::cloud::speech::v1::RecognizeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::speech::v1::LongRunningRecognizeResponse>>
SpeechConnection::LongRunningRecognize(
    google::cloud::speech::v1::LongRunningRecognizeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::speech::v1::LongRunningRecognizeResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> SpeechConnection::LongRunningRecognize(
    NoAwaitTag, google::cloud::speech::v1::LongRunningRecognizeRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::speech::v1::LongRunningRecognizeResponse>>
SpeechConnection::LongRunningRecognize(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::speech::v1::LongRunningRecognizeResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::speech::v1::StreamingRecognizeRequest,
    google::cloud::speech::v1::StreamingRecognizeResponse>>
SpeechConnection::AsyncStreamingRecognize() {
  return std::make_unique<
      ::google::cloud::internal::AsyncStreamingReadWriteRpcError<
          google::cloud::speech::v1::StreamingRecognizeRequest,
          google::cloud::speech::v1::StreamingRecognizeResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<SpeechConnection> MakeSpeechConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 SpeechPolicyOptionList>(options, __func__);
  options = speech_v1_internal::SpeechDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub =
      speech_v1_internal::CreateDefaultSpeechStub(std::move(auth), options);
  return speech_v1_internal::MakeSpeechTracingConnection(
      std::make_shared<speech_v1_internal::SpeechConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v1
}  // namespace cloud
}  // namespace google
