// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/security/privateca/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PRIVATECA_V1_INTERNAL_CERTIFICATE_AUTHORITY_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PRIVATECA_V1_INTERNAL_CERTIFICATE_AUTHORITY_CONNECTION_IMPL_H

#include "google/cloud/privateca/v1/certificate_authority_connection.h"
#include "google/cloud/privateca/v1/certificate_authority_connection_idempotency_policy.h"
#include "google/cloud/privateca/v1/certificate_authority_options.h"
#include "google/cloud/privateca/v1/internal/certificate_authority_retry_traits.h"
#include "google/cloud/privateca/v1/internal/certificate_authority_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace privateca_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class CertificateAuthorityServiceConnectionImpl
    : public privateca_v1::CertificateAuthorityServiceConnection {
 public:
  ~CertificateAuthorityServiceConnectionImpl() override = default;

  CertificateAuthorityServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<privateca_v1_internal::CertificateAuthorityServiceStub>
          stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::security::privateca::v1::Certificate>
  CreateCertificate(
      google::cloud::security::privateca::v1::CreateCertificateRequest const&
          request) override;

  StatusOr<google::cloud::security::privateca::v1::Certificate> GetCertificate(
      google::cloud::security::privateca::v1::GetCertificateRequest const&
          request) override;

  StreamRange<google::cloud::security::privateca::v1::Certificate>
  ListCertificates(
      google::cloud::security::privateca::v1::ListCertificatesRequest request)
      override;

  StatusOr<google::cloud::security::privateca::v1::Certificate>
  RevokeCertificate(
      google::cloud::security::privateca::v1::RevokeCertificateRequest const&
          request) override;

  StatusOr<google::cloud::security::privateca::v1::Certificate>
  UpdateCertificate(
      google::cloud::security::privateca::v1::UpdateCertificateRequest const&
          request) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  ActivateCertificateAuthority(
      google::cloud::security::privateca::v1::
          ActivateCertificateAuthorityRequest const& request) override;

  StatusOr<google::longrunning::Operation> ActivateCertificateAuthority(
      NoAwaitTag,
      google::cloud::security::privateca::v1::
          ActivateCertificateAuthorityRequest const& request) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  ActivateCertificateAuthority(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  CreateCertificateAuthority(
      google::cloud::security::privateca::v1::
          CreateCertificateAuthorityRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateCertificateAuthority(
      NoAwaitTag,
      google::cloud::security::privateca::v1::
          CreateCertificateAuthorityRequest const& request) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  CreateCertificateAuthority(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  DisableCertificateAuthority(
      google::cloud::security::privateca::v1::
          DisableCertificateAuthorityRequest const& request) override;

  StatusOr<google::longrunning::Operation> DisableCertificateAuthority(
      NoAwaitTag,
      google::cloud::security::privateca::v1::
          DisableCertificateAuthorityRequest const& request) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  DisableCertificateAuthority(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  EnableCertificateAuthority(
      google::cloud::security::privateca::v1::
          EnableCertificateAuthorityRequest const& request) override;

  StatusOr<google::longrunning::Operation> EnableCertificateAuthority(
      NoAwaitTag,
      google::cloud::security::privateca::v1::
          EnableCertificateAuthorityRequest const& request) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  EnableCertificateAuthority(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::security::privateca::v1::
               FetchCertificateAuthorityCsrResponse>
  FetchCertificateAuthorityCsr(
      google::cloud::security::privateca::v1::
          FetchCertificateAuthorityCsrRequest const& request) override;

  StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>
  GetCertificateAuthority(
      google::cloud::security::privateca::v1::
          GetCertificateAuthorityRequest const& request) override;

  StreamRange<google::cloud::security::privateca::v1::CertificateAuthority>
  ListCertificateAuthorities(
      google::cloud::security::privateca::v1::ListCertificateAuthoritiesRequest
          request) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  UndeleteCertificateAuthority(
      google::cloud::security::privateca::v1::
          UndeleteCertificateAuthorityRequest const& request) override;

  StatusOr<google::longrunning::Operation> UndeleteCertificateAuthority(
      NoAwaitTag,
      google::cloud::security::privateca::v1::
          UndeleteCertificateAuthorityRequest const& request) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  UndeleteCertificateAuthority(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  DeleteCertificateAuthority(
      google::cloud::security::privateca::v1::
          DeleteCertificateAuthorityRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteCertificateAuthority(
      NoAwaitTag,
      google::cloud::security::privateca::v1::
          DeleteCertificateAuthorityRequest const& request) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  DeleteCertificateAuthority(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  UpdateCertificateAuthority(
      google::cloud::security::privateca::v1::
          UpdateCertificateAuthorityRequest const& request) override;

  StatusOr<google::longrunning::Operation> UpdateCertificateAuthority(
      NoAwaitTag,
      google::cloud::security::privateca::v1::
          UpdateCertificateAuthorityRequest const& request) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
  UpdateCertificateAuthority(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::security::privateca::v1::CaPool>> CreateCaPool(
      google::cloud::security::privateca::v1::CreateCaPoolRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateCaPool(
      NoAwaitTag,
      google::cloud::security::privateca::v1::CreateCaPoolRequest const&
          request) override;

  future<StatusOr<google::cloud::security::privateca::v1::CaPool>> CreateCaPool(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::security::privateca::v1::CaPool>> UpdateCaPool(
      google::cloud::security::privateca::v1::UpdateCaPoolRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> UpdateCaPool(
      NoAwaitTag,
      google::cloud::security::privateca::v1::UpdateCaPoolRequest const&
          request) override;

  future<StatusOr<google::cloud::security::privateca::v1::CaPool>> UpdateCaPool(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::security::privateca::v1::CaPool> GetCaPool(
      google::cloud::security::privateca::v1::GetCaPoolRequest const& request)
      override;

  StreamRange<google::cloud::security::privateca::v1::CaPool> ListCaPools(
      google::cloud::security::privateca::v1::ListCaPoolsRequest request)
      override;

  future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
  DeleteCaPool(
      google::cloud::security::privateca::v1::DeleteCaPoolRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteCaPool(
      NoAwaitTag,
      google::cloud::security::privateca::v1::DeleteCaPoolRequest const&
          request) override;

  future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
  DeleteCaPool(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::security::privateca::v1::FetchCaCertsResponse>
  FetchCaCerts(
      google::cloud::security::privateca::v1::FetchCaCertsRequest const&
          request) override;

  StatusOr<google::cloud::security::privateca::v1::CertificateRevocationList>
  GetCertificateRevocationList(
      google::cloud::security::privateca::v1::
          GetCertificateRevocationListRequest const& request) override;

  StreamRange<google::cloud::security::privateca::v1::CertificateRevocationList>
  ListCertificateRevocationLists(
      google::cloud::security::privateca::v1::
          ListCertificateRevocationListsRequest request) override;

  future<StatusOr<
      google::cloud::security::privateca::v1::CertificateRevocationList>>
  UpdateCertificateRevocationList(
      google::cloud::security::privateca::v1::
          UpdateCertificateRevocationListRequest const& request) override;

  StatusOr<google::longrunning::Operation> UpdateCertificateRevocationList(
      NoAwaitTag,
      google::cloud::security::privateca::v1::
          UpdateCertificateRevocationListRequest const& request) override;

  future<StatusOr<
      google::cloud::security::privateca::v1::CertificateRevocationList>>
  UpdateCertificateRevocationList(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
  CreateCertificateTemplate(
      google::cloud::security::privateca::v1::
          CreateCertificateTemplateRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateCertificateTemplate(
      NoAwaitTag, google::cloud::security::privateca::v1::
                      CreateCertificateTemplateRequest const& request) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
  CreateCertificateTemplate(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
  DeleteCertificateTemplate(
      google::cloud::security::privateca::v1::
          DeleteCertificateTemplateRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteCertificateTemplate(
      NoAwaitTag, google::cloud::security::privateca::v1::
                      DeleteCertificateTemplateRequest const& request) override;

  future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
  DeleteCertificateTemplate(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>
  GetCertificateTemplate(
      google::cloud::security::privateca::v1::
          GetCertificateTemplateRequest const& request) override;

  StreamRange<google::cloud::security::privateca::v1::CertificateTemplate>
  ListCertificateTemplates(
      google::cloud::security::privateca::v1::ListCertificateTemplatesRequest
          request) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
  UpdateCertificateTemplate(
      google::cloud::security::privateca::v1::
          UpdateCertificateTemplateRequest const& request) override;

  StatusOr<google::longrunning::Operation> UpdateCertificateTemplate(
      NoAwaitTag, google::cloud::security::privateca::v1::
                      UpdateCertificateTemplateRequest const& request) override;

  future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
  UpdateCertificateTemplate(
      google::longrunning::Operation const& operation) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<privateca_v1_internal::CertificateAuthorityServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace privateca_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PRIVATECA_V1_INTERNAL_CERTIFICATE_AUTHORITY_CONNECTION_IMPL_H
