// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/security/privateca/v1/service.proto

#include "google/cloud/privateca/v1/certificate_authority_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace privateca_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CertificateAuthorityServiceClient::CertificateAuthorityServiceClient(
    std::shared_ptr<CertificateAuthorityServiceConnection> connection,
    Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
CertificateAuthorityServiceClient::~CertificateAuthorityServiceClient() =
    default;

StatusOr<google::cloud::security::privateca::v1::Certificate>
CertificateAuthorityServiceClient::CreateCertificate(
    std::string const& parent,
    google::cloud::security::privateca::v1::Certificate const& certificate,
    std::string const& certificate_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::CreateCertificateRequest request;
  request.set_parent(parent);
  *request.mutable_certificate() = certificate;
  request.set_certificate_id(certificate_id);
  return connection_->CreateCertificate(request);
}

StatusOr<google::cloud::security::privateca::v1::Certificate>
CertificateAuthorityServiceClient::CreateCertificate(
    google::cloud::security::privateca::v1::CreateCertificateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCertificate(request);
}

StatusOr<google::cloud::security::privateca::v1::Certificate>
CertificateAuthorityServiceClient::GetCertificate(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::GetCertificateRequest request;
  request.set_name(name);
  return connection_->GetCertificate(request);
}

StatusOr<google::cloud::security::privateca::v1::Certificate>
CertificateAuthorityServiceClient::GetCertificate(
    google::cloud::security::privateca::v1::GetCertificateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCertificate(request);
}

StreamRange<google::cloud::security::privateca::v1::Certificate>
CertificateAuthorityServiceClient::ListCertificates(std::string const& parent,
                                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::ListCertificatesRequest request;
  request.set_parent(parent);
  return connection_->ListCertificates(request);
}

StreamRange<google::cloud::security::privateca::v1::Certificate>
CertificateAuthorityServiceClient::ListCertificates(
    google::cloud::security::privateca::v1::ListCertificatesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListCertificates(std::move(request));
}

StatusOr<google::cloud::security::privateca::v1::Certificate>
CertificateAuthorityServiceClient::RevokeCertificate(std::string const& name,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::RevokeCertificateRequest request;
  request.set_name(name);
  return connection_->RevokeCertificate(request);
}

StatusOr<google::cloud::security::privateca::v1::Certificate>
CertificateAuthorityServiceClient::RevokeCertificate(
    google::cloud::security::privateca::v1::RevokeCertificateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RevokeCertificate(request);
}

StatusOr<google::cloud::security::privateca::v1::Certificate>
CertificateAuthorityServiceClient::UpdateCertificate(
    google::cloud::security::privateca::v1::Certificate const& certificate,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::UpdateCertificateRequest request;
  *request.mutable_certificate() = certificate;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCertificate(request);
}

StatusOr<google::cloud::security::privateca::v1::Certificate>
CertificateAuthorityServiceClient::UpdateCertificate(
    google::cloud::security::privateca::v1::UpdateCertificateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCertificate(request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::ActivateCertificateAuthority(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::ActivateCertificateAuthorityRequest
      request;
  request.set_name(name);
  return connection_->ActivateCertificateAuthority(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::ActivateCertificateAuthority(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::ActivateCertificateAuthorityRequest
      request;
  request.set_name(name);
  return connection_->ActivateCertificateAuthority(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::ActivateCertificateAuthority(
    google::cloud::security::privateca::v1::
        ActivateCertificateAuthorityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ActivateCertificateAuthority(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::ActivateCertificateAuthority(
    NoAwaitTag,
    google::cloud::security::privateca::v1::
        ActivateCertificateAuthorityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ActivateCertificateAuthority(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::ActivateCertificateAuthority(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ActivateCertificateAuthority(operation);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::CreateCertificateAuthority(
    std::string const& parent,
    google::cloud::security::privateca::v1::CertificateAuthority const&
        certificate_authority,
    std::string const& certificate_authority_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::CreateCertificateAuthorityRequest
      request;
  request.set_parent(parent);
  *request.mutable_certificate_authority() = certificate_authority;
  request.set_certificate_authority_id(certificate_authority_id);
  return connection_->CreateCertificateAuthority(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::CreateCertificateAuthority(
    NoAwaitTag, std::string const& parent,
    google::cloud::security::privateca::v1::CertificateAuthority const&
        certificate_authority,
    std::string const& certificate_authority_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::CreateCertificateAuthorityRequest
      request;
  request.set_parent(parent);
  *request.mutable_certificate_authority() = certificate_authority;
  request.set_certificate_authority_id(certificate_authority_id);
  return connection_->CreateCertificateAuthority(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::CreateCertificateAuthority(
    google::cloud::security::privateca::v1::
        CreateCertificateAuthorityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCertificateAuthority(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::CreateCertificateAuthority(
    NoAwaitTag,
    google::cloud::security::privateca::v1::
        CreateCertificateAuthorityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCertificateAuthority(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::CreateCertificateAuthority(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCertificateAuthority(operation);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::DisableCertificateAuthority(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::DisableCertificateAuthorityRequest
      request;
  request.set_name(name);
  return connection_->DisableCertificateAuthority(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::DisableCertificateAuthority(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::DisableCertificateAuthorityRequest
      request;
  request.set_name(name);
  return connection_->DisableCertificateAuthority(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::DisableCertificateAuthority(
    google::cloud::security::privateca::v1::
        DisableCertificateAuthorityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DisableCertificateAuthority(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::DisableCertificateAuthority(
    NoAwaitTag,
    google::cloud::security::privateca::v1::
        DisableCertificateAuthorityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DisableCertificateAuthority(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::DisableCertificateAuthority(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DisableCertificateAuthority(operation);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::EnableCertificateAuthority(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::EnableCertificateAuthorityRequest
      request;
  request.set_name(name);
  return connection_->EnableCertificateAuthority(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::EnableCertificateAuthority(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::EnableCertificateAuthorityRequest
      request;
  request.set_name(name);
  return connection_->EnableCertificateAuthority(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::EnableCertificateAuthority(
    google::cloud::security::privateca::v1::
        EnableCertificateAuthorityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->EnableCertificateAuthority(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::EnableCertificateAuthority(
    NoAwaitTag,
    google::cloud::security::privateca::v1::
        EnableCertificateAuthorityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->EnableCertificateAuthority(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::EnableCertificateAuthority(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->EnableCertificateAuthority(operation);
}

StatusOr<google::cloud::security::privateca::v1::
             FetchCertificateAuthorityCsrResponse>
CertificateAuthorityServiceClient::FetchCertificateAuthorityCsr(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::FetchCertificateAuthorityCsrRequest
      request;
  request.set_name(name);
  return connection_->FetchCertificateAuthorityCsr(request);
}

StatusOr<google::cloud::security::privateca::v1::
             FetchCertificateAuthorityCsrResponse>
CertificateAuthorityServiceClient::FetchCertificateAuthorityCsr(
    google::cloud::security::privateca::v1::
        FetchCertificateAuthorityCsrRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->FetchCertificateAuthorityCsr(request);
}

StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>
CertificateAuthorityServiceClient::GetCertificateAuthority(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::GetCertificateAuthorityRequest
      request;
  request.set_name(name);
  return connection_->GetCertificateAuthority(request);
}

StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>
CertificateAuthorityServiceClient::GetCertificateAuthority(
    google::cloud::security::privateca::v1::
        GetCertificateAuthorityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCertificateAuthority(request);
}

StreamRange<google::cloud::security::privateca::v1::CertificateAuthority>
CertificateAuthorityServiceClient::ListCertificateAuthorities(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::ListCertificateAuthoritiesRequest
      request;
  request.set_parent(parent);
  return connection_->ListCertificateAuthorities(request);
}

StreamRange<google::cloud::security::privateca::v1::CertificateAuthority>
CertificateAuthorityServiceClient::ListCertificateAuthorities(
    google::cloud::security::privateca::v1::ListCertificateAuthoritiesRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListCertificateAuthorities(std::move(request));
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::UndeleteCertificateAuthority(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::UndeleteCertificateAuthorityRequest
      request;
  request.set_name(name);
  return connection_->UndeleteCertificateAuthority(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::UndeleteCertificateAuthority(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::UndeleteCertificateAuthorityRequest
      request;
  request.set_name(name);
  return connection_->UndeleteCertificateAuthority(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::UndeleteCertificateAuthority(
    google::cloud::security::privateca::v1::
        UndeleteCertificateAuthorityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeleteCertificateAuthority(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::UndeleteCertificateAuthority(
    NoAwaitTag,
    google::cloud::security::privateca::v1::
        UndeleteCertificateAuthorityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeleteCertificateAuthority(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::UndeleteCertificateAuthority(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeleteCertificateAuthority(operation);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::DeleteCertificateAuthority(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::DeleteCertificateAuthorityRequest
      request;
  request.set_name(name);
  return connection_->DeleteCertificateAuthority(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::DeleteCertificateAuthority(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::DeleteCertificateAuthorityRequest
      request;
  request.set_name(name);
  return connection_->DeleteCertificateAuthority(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::DeleteCertificateAuthority(
    google::cloud::security::privateca::v1::
        DeleteCertificateAuthorityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCertificateAuthority(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::DeleteCertificateAuthority(
    NoAwaitTag,
    google::cloud::security::privateca::v1::
        DeleteCertificateAuthorityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCertificateAuthority(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::DeleteCertificateAuthority(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCertificateAuthority(operation);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::UpdateCertificateAuthority(
    google::cloud::security::privateca::v1::CertificateAuthority const&
        certificate_authority,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::UpdateCertificateAuthorityRequest
      request;
  *request.mutable_certificate_authority() = certificate_authority;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCertificateAuthority(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::UpdateCertificateAuthority(
    NoAwaitTag,
    google::cloud::security::privateca::v1::CertificateAuthority const&
        certificate_authority,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::UpdateCertificateAuthorityRequest
      request;
  *request.mutable_certificate_authority() = certificate_authority;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCertificateAuthority(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::UpdateCertificateAuthority(
    google::cloud::security::privateca::v1::
        UpdateCertificateAuthorityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCertificateAuthority(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::UpdateCertificateAuthority(
    NoAwaitTag,
    google::cloud::security::privateca::v1::
        UpdateCertificateAuthorityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCertificateAuthority(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>>
CertificateAuthorityServiceClient::UpdateCertificateAuthority(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCertificateAuthority(operation);
}

future<StatusOr<google::cloud::security::privateca::v1::CaPool>>
CertificateAuthorityServiceClient::CreateCaPool(
    std::string const& parent,
    google::cloud::security::privateca::v1::CaPool const& ca_pool,
    std::string const& ca_pool_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::CreateCaPoolRequest request;
  request.set_parent(parent);
  *request.mutable_ca_pool() = ca_pool;
  request.set_ca_pool_id(ca_pool_id);
  return connection_->CreateCaPool(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::CreateCaPool(
    NoAwaitTag, std::string const& parent,
    google::cloud::security::privateca::v1::CaPool const& ca_pool,
    std::string const& ca_pool_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::CreateCaPoolRequest request;
  request.set_parent(parent);
  *request.mutable_ca_pool() = ca_pool;
  request.set_ca_pool_id(ca_pool_id);
  return connection_->CreateCaPool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CaPool>>
CertificateAuthorityServiceClient::CreateCaPool(
    google::cloud::security::privateca::v1::CreateCaPoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCaPool(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::CreateCaPool(
    NoAwaitTag,
    google::cloud::security::privateca::v1::CreateCaPoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCaPool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CaPool>>
CertificateAuthorityServiceClient::CreateCaPool(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCaPool(operation);
}

future<StatusOr<google::cloud::security::privateca::v1::CaPool>>
CertificateAuthorityServiceClient::UpdateCaPool(
    google::cloud::security::privateca::v1::CaPool const& ca_pool,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::UpdateCaPoolRequest request;
  *request.mutable_ca_pool() = ca_pool;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCaPool(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::UpdateCaPool(
    NoAwaitTag, google::cloud::security::privateca::v1::CaPool const& ca_pool,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::UpdateCaPoolRequest request;
  *request.mutable_ca_pool() = ca_pool;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCaPool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CaPool>>
CertificateAuthorityServiceClient::UpdateCaPool(
    google::cloud::security::privateca::v1::UpdateCaPoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCaPool(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::UpdateCaPool(
    NoAwaitTag,
    google::cloud::security::privateca::v1::UpdateCaPoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCaPool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CaPool>>
CertificateAuthorityServiceClient::UpdateCaPool(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCaPool(operation);
}

StatusOr<google::cloud::security::privateca::v1::CaPool>
CertificateAuthorityServiceClient::GetCaPool(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::GetCaPoolRequest request;
  request.set_name(name);
  return connection_->GetCaPool(request);
}

StatusOr<google::cloud::security::privateca::v1::CaPool>
CertificateAuthorityServiceClient::GetCaPool(
    google::cloud::security::privateca::v1::GetCaPoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCaPool(request);
}

StreamRange<google::cloud::security::privateca::v1::CaPool>
CertificateAuthorityServiceClient::ListCaPools(std::string const& parent,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::ListCaPoolsRequest request;
  request.set_parent(parent);
  return connection_->ListCaPools(request);
}

StreamRange<google::cloud::security::privateca::v1::CaPool>
CertificateAuthorityServiceClient::ListCaPools(
    google::cloud::security::privateca::v1::ListCaPoolsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListCaPools(std::move(request));
}

future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
CertificateAuthorityServiceClient::DeleteCaPool(std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::DeleteCaPoolRequest request;
  request.set_name(name);
  return connection_->DeleteCaPool(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::DeleteCaPool(NoAwaitTag,
                                                std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::DeleteCaPoolRequest request;
  request.set_name(name);
  return connection_->DeleteCaPool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
CertificateAuthorityServiceClient::DeleteCaPool(
    google::cloud::security::privateca::v1::DeleteCaPoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCaPool(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::DeleteCaPool(
    NoAwaitTag,
    google::cloud::security::privateca::v1::DeleteCaPoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCaPool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
CertificateAuthorityServiceClient::DeleteCaPool(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCaPool(operation);
}

StatusOr<google::cloud::security::privateca::v1::FetchCaCertsResponse>
CertificateAuthorityServiceClient::FetchCaCerts(std::string const& ca_pool,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::FetchCaCertsRequest request;
  request.set_ca_pool(ca_pool);
  return connection_->FetchCaCerts(request);
}

StatusOr<google::cloud::security::privateca::v1::FetchCaCertsResponse>
CertificateAuthorityServiceClient::FetchCaCerts(
    google::cloud::security::privateca::v1::FetchCaCertsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->FetchCaCerts(request);
}

StatusOr<google::cloud::security::privateca::v1::CertificateRevocationList>
CertificateAuthorityServiceClient::GetCertificateRevocationList(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::GetCertificateRevocationListRequest
      request;
  request.set_name(name);
  return connection_->GetCertificateRevocationList(request);
}

StatusOr<google::cloud::security::privateca::v1::CertificateRevocationList>
CertificateAuthorityServiceClient::GetCertificateRevocationList(
    google::cloud::security::privateca::v1::
        GetCertificateRevocationListRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCertificateRevocationList(request);
}

StreamRange<google::cloud::security::privateca::v1::CertificateRevocationList>
CertificateAuthorityServiceClient::ListCertificateRevocationLists(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::ListCertificateRevocationListsRequest
      request;
  request.set_parent(parent);
  return connection_->ListCertificateRevocationLists(request);
}

StreamRange<google::cloud::security::privateca::v1::CertificateRevocationList>
CertificateAuthorityServiceClient::ListCertificateRevocationLists(
    google::cloud::security::privateca::v1::
        ListCertificateRevocationListsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListCertificateRevocationLists(std::move(request));
}

future<
    StatusOr<google::cloud::security::privateca::v1::CertificateRevocationList>>
CertificateAuthorityServiceClient::UpdateCertificateRevocationList(
    google::cloud::security::privateca::v1::CertificateRevocationList const&
        certificate_revocation_list,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::UpdateCertificateRevocationListRequest
      request;
  *request.mutable_certificate_revocation_list() = certificate_revocation_list;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCertificateRevocationList(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::UpdateCertificateRevocationList(
    NoAwaitTag,
    google::cloud::security::privateca::v1::CertificateRevocationList const&
        certificate_revocation_list,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::UpdateCertificateRevocationListRequest
      request;
  *request.mutable_certificate_revocation_list() = certificate_revocation_list;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCertificateRevocationList(NoAwaitTag{}, request);
}

future<
    StatusOr<google::cloud::security::privateca::v1::CertificateRevocationList>>
CertificateAuthorityServiceClient::UpdateCertificateRevocationList(
    google::cloud::security::privateca::v1::
        UpdateCertificateRevocationListRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCertificateRevocationList(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::UpdateCertificateRevocationList(
    NoAwaitTag,
    google::cloud::security::privateca::v1::
        UpdateCertificateRevocationListRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCertificateRevocationList(NoAwaitTag{}, request);
}

future<
    StatusOr<google::cloud::security::privateca::v1::CertificateRevocationList>>
CertificateAuthorityServiceClient::UpdateCertificateRevocationList(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCertificateRevocationList(operation);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
CertificateAuthorityServiceClient::CreateCertificateTemplate(
    std::string const& parent,
    google::cloud::security::privateca::v1::CertificateTemplate const&
        certificate_template,
    std::string const& certificate_template_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::CreateCertificateTemplateRequest
      request;
  request.set_parent(parent);
  *request.mutable_certificate_template() = certificate_template;
  request.set_certificate_template_id(certificate_template_id);
  return connection_->CreateCertificateTemplate(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::CreateCertificateTemplate(
    NoAwaitTag, std::string const& parent,
    google::cloud::security::privateca::v1::CertificateTemplate const&
        certificate_template,
    std::string const& certificate_template_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::CreateCertificateTemplateRequest
      request;
  request.set_parent(parent);
  *request.mutable_certificate_template() = certificate_template;
  request.set_certificate_template_id(certificate_template_id);
  return connection_->CreateCertificateTemplate(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
CertificateAuthorityServiceClient::CreateCertificateTemplate(
    google::cloud::security::privateca::v1::
        CreateCertificateTemplateRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCertificateTemplate(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::CreateCertificateTemplate(
    NoAwaitTag,
    google::cloud::security::privateca::v1::
        CreateCertificateTemplateRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCertificateTemplate(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
CertificateAuthorityServiceClient::CreateCertificateTemplate(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCertificateTemplate(operation);
}

future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
CertificateAuthorityServiceClient::DeleteCertificateTemplate(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::DeleteCertificateTemplateRequest
      request;
  request.set_name(name);
  return connection_->DeleteCertificateTemplate(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::DeleteCertificateTemplate(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::DeleteCertificateTemplateRequest
      request;
  request.set_name(name);
  return connection_->DeleteCertificateTemplate(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
CertificateAuthorityServiceClient::DeleteCertificateTemplate(
    google::cloud::security::privateca::v1::
        DeleteCertificateTemplateRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCertificateTemplate(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::DeleteCertificateTemplate(
    NoAwaitTag,
    google::cloud::security::privateca::v1::
        DeleteCertificateTemplateRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCertificateTemplate(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>
CertificateAuthorityServiceClient::DeleteCertificateTemplate(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCertificateTemplate(operation);
}

StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>
CertificateAuthorityServiceClient::GetCertificateTemplate(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::GetCertificateTemplateRequest request;
  request.set_name(name);
  return connection_->GetCertificateTemplate(request);
}

StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>
CertificateAuthorityServiceClient::GetCertificateTemplate(
    google::cloud::security::privateca::v1::GetCertificateTemplateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCertificateTemplate(request);
}

StreamRange<google::cloud::security::privateca::v1::CertificateTemplate>
CertificateAuthorityServiceClient::ListCertificateTemplates(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::ListCertificateTemplatesRequest
      request;
  request.set_parent(parent);
  return connection_->ListCertificateTemplates(request);
}

StreamRange<google::cloud::security::privateca::v1::CertificateTemplate>
CertificateAuthorityServiceClient::ListCertificateTemplates(
    google::cloud::security::privateca::v1::ListCertificateTemplatesRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListCertificateTemplates(std::move(request));
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
CertificateAuthorityServiceClient::UpdateCertificateTemplate(
    google::cloud::security::privateca::v1::CertificateTemplate const&
        certificate_template,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::UpdateCertificateTemplateRequest
      request;
  *request.mutable_certificate_template() = certificate_template;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCertificateTemplate(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::UpdateCertificateTemplate(
    NoAwaitTag,
    google::cloud::security::privateca::v1::CertificateTemplate const&
        certificate_template,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::security::privateca::v1::UpdateCertificateTemplateRequest
      request;
  *request.mutable_certificate_template() = certificate_template;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCertificateTemplate(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
CertificateAuthorityServiceClient::UpdateCertificateTemplate(
    google::cloud::security::privateca::v1::
        UpdateCertificateTemplateRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCertificateTemplate(request);
}

StatusOr<google::longrunning::Operation>
CertificateAuthorityServiceClient::UpdateCertificateTemplate(
    NoAwaitTag,
    google::cloud::security::privateca::v1::
        UpdateCertificateTemplateRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCertificateTemplate(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>>
CertificateAuthorityServiceClient::UpdateCertificateTemplate(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCertificateTemplate(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace privateca_v1
}  // namespace cloud
}  // namespace google
