// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkehub/v1/service.proto

#include "google/cloud/gkehub/v1/internal/gke_hub_connection_impl.h"
#include "google/cloud/gkehub/v1/internal/gke_hub_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace gkehub_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<gkehub_v1::GkeHubRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<gkehub_v1::GkeHubRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<gkehub_v1::GkeHubBackoffPolicyOption>()->clone();
}

std::unique_ptr<gkehub_v1::GkeHubConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options.get<gkehub_v1::GkeHubConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<gkehub_v1::GkeHubPollingPolicyOption>()->clone();
}

}  // namespace

GkeHubConnectionImpl::GkeHubConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<gkehub_v1_internal::GkeHubStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      GkeHubConnection::options())) {}

StreamRange<google::cloud::gkehub::v1::Membership>
GkeHubConnectionImpl::ListMemberships(
    google::cloud::gkehub::v1::ListMembershipsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListMemberships(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::gkehub::v1::Membership>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<gkehub_v1::GkeHubRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::gkehub::v1::ListMembershipsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::gkehub::v1::ListMembershipsRequest const&
                       request) {
              return stub->ListMemberships(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::gkehub::v1::ListMembershipsResponse r) {
        std::vector<google::cloud::gkehub::v1::Membership> result(
            r.resources().size());
        auto& messages = *r.mutable_resources();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::gkehub::v1::Feature>
GkeHubConnectionImpl::ListFeatures(
    google::cloud::gkehub::v1::ListFeaturesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListFeatures(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::gkehub::v1::Feature>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<gkehub_v1::GkeHubRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::gkehub::v1::ListFeaturesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::gkehub::v1::ListFeaturesRequest const& request) {
              return stub->ListFeatures(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::gkehub::v1::ListFeaturesResponse r) {
        std::vector<google::cloud::gkehub::v1::Feature> result(
            r.resources().size());
        auto& messages = *r.mutable_resources();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::gkehub::v1::Membership>
GkeHubConnectionImpl::GetMembership(
    google::cloud::gkehub::v1::GetMembershipRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetMembership(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkehub::v1::GetMembershipRequest const& request) {
        return stub_->GetMembership(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::gkehub::v1::Feature> GkeHubConnectionImpl::GetFeature(
    google::cloud::gkehub::v1::GetFeatureRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetFeature(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkehub::v1::GetFeatureRequest const& request) {
        return stub_->GetFeature(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::gkehub::v1::Membership>>
GkeHubConnectionImpl::CreateMembership(
    google::cloud::gkehub::v1::CreateMembershipRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateMembership(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::gkehub::v1::Membership>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::gkehub::v1::CreateMembershipRequest const& request) {
        return stub->AsyncCreateMembership(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::gkehub::v1::Membership>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> GkeHubConnectionImpl::CreateMembership(
    NoAwaitTag,
    google::cloud::gkehub::v1::CreateMembershipRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateMembership(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::gkehub::v1::CreateMembershipRequest const& request) {
        return stub_->CreateMembership(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::gkehub::v1::Membership>>
GkeHubConnectionImpl::CreateMembership(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::gkehub::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::gkehub::v1::Membership>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateMembership",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::gkehub::v1::Membership>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::gkehub::v1::Membership>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::gkehub::v1::Feature>>
GkeHubConnectionImpl::CreateFeature(
    google::cloud::gkehub::v1::CreateFeatureRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateFeature(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::gkehub::v1::Feature>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::gkehub::v1::CreateFeatureRequest const& request) {
        return stub->AsyncCreateFeature(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::gkehub::v1::Feature>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> GkeHubConnectionImpl::CreateFeature(
    NoAwaitTag,
    google::cloud::gkehub::v1::CreateFeatureRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateFeature(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkehub::v1::CreateFeatureRequest const& request) {
        return stub_->CreateFeature(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::gkehub::v1::Feature>>
GkeHubConnectionImpl::CreateFeature(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::gkehub::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::gkehub::v1::Feature>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateFeature",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::gkehub::v1::Feature>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::gkehub::v1::Feature>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>>
GkeHubConnectionImpl::DeleteMembership(
    google::cloud::gkehub::v1::DeleteMembershipRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteMembership(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::gkehub::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::gkehub::v1::DeleteMembershipRequest const& request) {
        return stub->AsyncDeleteMembership(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::gkehub::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> GkeHubConnectionImpl::DeleteMembership(
    NoAwaitTag,
    google::cloud::gkehub::v1::DeleteMembershipRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteMembership(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::gkehub::v1::DeleteMembershipRequest const& request) {
        return stub_->DeleteMembership(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>>
GkeHubConnectionImpl::DeleteMembership(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::gkehub::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::gkehub::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteMembership",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::gkehub::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::gkehub::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>>
GkeHubConnectionImpl::DeleteFeature(
    google::cloud::gkehub::v1::DeleteFeatureRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteFeature(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::gkehub::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::gkehub::v1::DeleteFeatureRequest const& request) {
        return stub->AsyncDeleteFeature(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::gkehub::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> GkeHubConnectionImpl::DeleteFeature(
    NoAwaitTag,
    google::cloud::gkehub::v1::DeleteFeatureRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteFeature(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkehub::v1::DeleteFeatureRequest const& request) {
        return stub_->DeleteFeature(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::gkehub::v1::OperationMetadata>>
GkeHubConnectionImpl::DeleteFeature(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::gkehub::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::gkehub::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteFeature",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::gkehub::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::gkehub::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::gkehub::v1::Membership>>
GkeHubConnectionImpl::UpdateMembership(
    google::cloud::gkehub::v1::UpdateMembershipRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateMembership(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::gkehub::v1::Membership>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::gkehub::v1::UpdateMembershipRequest const& request) {
        return stub->AsyncUpdateMembership(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::gkehub::v1::Membership>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> GkeHubConnectionImpl::UpdateMembership(
    NoAwaitTag,
    google::cloud::gkehub::v1::UpdateMembershipRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateMembership(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::gkehub::v1::UpdateMembershipRequest const& request) {
        return stub_->UpdateMembership(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::gkehub::v1::Membership>>
GkeHubConnectionImpl::UpdateMembership(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::gkehub::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::gkehub::v1::Membership>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateMembership",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::gkehub::v1::Membership>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::gkehub::v1::Membership>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::gkehub::v1::Feature>>
GkeHubConnectionImpl::UpdateFeature(
    google::cloud::gkehub::v1::UpdateFeatureRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateFeature(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::gkehub::v1::Feature>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::gkehub::v1::UpdateFeatureRequest const& request) {
        return stub->AsyncUpdateFeature(cq, std::move(context),
                                        std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::gkehub::v1::Feature>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation> GkeHubConnectionImpl::UpdateFeature(
    NoAwaitTag,
    google::cloud::gkehub::v1::UpdateFeatureRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateFeature(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkehub::v1::UpdateFeatureRequest const& request) {
        return stub_->UpdateFeature(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::gkehub::v1::Feature>>
GkeHubConnectionImpl::UpdateFeature(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::gkehub::v1::OperationMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::gkehub::v1::Feature>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateFeature",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::gkehub::v1::Feature>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::gkehub::v1::Feature>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::gkehub::v1::GenerateConnectManifestResponse>
GkeHubConnectionImpl::GenerateConnectManifest(
    google::cloud::gkehub::v1::GenerateConnectManifestRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GenerateConnectManifest(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::gkehub::v1::GenerateConnectManifestRequest const&
                 request) {
        return stub_->GenerateConnectManifest(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkehub_v1_internal
}  // namespace cloud
}  // namespace google
