// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/filestore/v1/cloud_filestore_service.proto

#include "google/cloud/filestore/v1/cloud_filestore_manager_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace filestore_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudFilestoreManagerClient::CloudFilestoreManagerClient(
    std::shared_ptr<CloudFilestoreManagerConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
CloudFilestoreManagerClient::~CloudFilestoreManagerClient() = default;

StreamRange<google::cloud::filestore::v1::Instance>
CloudFilestoreManagerClient::ListInstances(std::string const& parent,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::ListInstancesRequest request;
  request.set_parent(parent);
  return connection_->ListInstances(request);
}

StreamRange<google::cloud::filestore::v1::Instance>
CloudFilestoreManagerClient::ListInstances(
    google::cloud::filestore::v1::ListInstancesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListInstances(std::move(request));
}

StatusOr<google::cloud::filestore::v1::Instance>
CloudFilestoreManagerClient::GetInstance(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::GetInstanceRequest request;
  request.set_name(name);
  return connection_->GetInstance(request);
}

StatusOr<google::cloud::filestore::v1::Instance>
CloudFilestoreManagerClient::GetInstance(
    google::cloud::filestore::v1::GetInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetInstance(request);
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerClient::CreateInstance(
    std::string const& parent,
    google::cloud::filestore::v1::Instance const& instance,
    std::string const& instance_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::CreateInstanceRequest request;
  request.set_parent(parent);
  *request.mutable_instance() = instance;
  request.set_instance_id(instance_id);
  return connection_->CreateInstance(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::CreateInstance(
    NoAwaitTag, std::string const& parent,
    google::cloud::filestore::v1::Instance const& instance,
    std::string const& instance_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::CreateInstanceRequest request;
  request.set_parent(parent);
  *request.mutable_instance() = instance;
  request.set_instance_id(instance_id);
  return connection_->CreateInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerClient::CreateInstance(
    google::cloud::filestore::v1::CreateInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateInstance(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::CreateInstance(
    NoAwaitTag,
    google::cloud::filestore::v1::CreateInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerClient::CreateInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateInstance(operation);
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerClient::UpdateInstance(
    google::cloud::filestore::v1::Instance const& instance,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::UpdateInstanceRequest request;
  *request.mutable_instance() = instance;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateInstance(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::UpdateInstance(
    NoAwaitTag, google::cloud::filestore::v1::Instance const& instance,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::UpdateInstanceRequest request;
  *request.mutable_instance() = instance;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerClient::UpdateInstance(
    google::cloud::filestore::v1::UpdateInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateInstance(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::UpdateInstance(
    NoAwaitTag,
    google::cloud::filestore::v1::UpdateInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerClient::UpdateInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateInstance(operation);
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerClient::RestoreInstance(
    google::cloud::filestore::v1::RestoreInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RestoreInstance(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::RestoreInstance(
    NoAwaitTag,
    google::cloud::filestore::v1::RestoreInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RestoreInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerClient::RestoreInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RestoreInstance(operation);
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerClient::RevertInstance(
    google::cloud::filestore::v1::RevertInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RevertInstance(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::RevertInstance(
    NoAwaitTag,
    google::cloud::filestore::v1::RevertInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RevertInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::filestore::v1::Instance>>
CloudFilestoreManagerClient::RevertInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RevertInstance(operation);
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerClient::DeleteInstance(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::DeleteInstanceRequest request;
  request.set_name(name);
  return connection_->DeleteInstance(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::DeleteInstance(NoAwaitTag, std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::DeleteInstanceRequest request;
  request.set_name(name);
  return connection_->DeleteInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerClient::DeleteInstance(
    google::cloud::filestore::v1::DeleteInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstance(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::DeleteInstance(
    NoAwaitTag,
    google::cloud::filestore::v1::DeleteInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerClient::DeleteInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstance(operation);
}

StreamRange<google::cloud::filestore::v1::Snapshot>
CloudFilestoreManagerClient::ListSnapshots(std::string const& parent,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::ListSnapshotsRequest request;
  request.set_parent(parent);
  return connection_->ListSnapshots(request);
}

StreamRange<google::cloud::filestore::v1::Snapshot>
CloudFilestoreManagerClient::ListSnapshots(
    google::cloud::filestore::v1::ListSnapshotsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSnapshots(std::move(request));
}

StatusOr<google::cloud::filestore::v1::Snapshot>
CloudFilestoreManagerClient::GetSnapshot(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::GetSnapshotRequest request;
  request.set_name(name);
  return connection_->GetSnapshot(request);
}

StatusOr<google::cloud::filestore::v1::Snapshot>
CloudFilestoreManagerClient::GetSnapshot(
    google::cloud::filestore::v1::GetSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSnapshot(request);
}

future<StatusOr<google::cloud::filestore::v1::Snapshot>>
CloudFilestoreManagerClient::CreateSnapshot(
    std::string const& parent,
    google::cloud::filestore::v1::Snapshot const& snapshot,
    std::string const& snapshot_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::CreateSnapshotRequest request;
  request.set_parent(parent);
  *request.mutable_snapshot() = snapshot;
  request.set_snapshot_id(snapshot_id);
  return connection_->CreateSnapshot(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::CreateSnapshot(
    NoAwaitTag, std::string const& parent,
    google::cloud::filestore::v1::Snapshot const& snapshot,
    std::string const& snapshot_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::CreateSnapshotRequest request;
  request.set_parent(parent);
  *request.mutable_snapshot() = snapshot;
  request.set_snapshot_id(snapshot_id);
  return connection_->CreateSnapshot(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::filestore::v1::Snapshot>>
CloudFilestoreManagerClient::CreateSnapshot(
    google::cloud::filestore::v1::CreateSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSnapshot(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::CreateSnapshot(
    NoAwaitTag,
    google::cloud::filestore::v1::CreateSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSnapshot(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::filestore::v1::Snapshot>>
CloudFilestoreManagerClient::CreateSnapshot(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSnapshot(operation);
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerClient::DeleteSnapshot(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::DeleteSnapshotRequest request;
  request.set_name(name);
  return connection_->DeleteSnapshot(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::DeleteSnapshot(NoAwaitTag, std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::DeleteSnapshotRequest request;
  request.set_name(name);
  return connection_->DeleteSnapshot(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerClient::DeleteSnapshot(
    google::cloud::filestore::v1::DeleteSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSnapshot(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::DeleteSnapshot(
    NoAwaitTag,
    google::cloud::filestore::v1::DeleteSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSnapshot(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerClient::DeleteSnapshot(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSnapshot(operation);
}

future<StatusOr<google::cloud::filestore::v1::Snapshot>>
CloudFilestoreManagerClient::UpdateSnapshot(
    google::cloud::filestore::v1::Snapshot const& snapshot,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::UpdateSnapshotRequest request;
  *request.mutable_snapshot() = snapshot;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSnapshot(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::UpdateSnapshot(
    NoAwaitTag, google::cloud::filestore::v1::Snapshot const& snapshot,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::UpdateSnapshotRequest request;
  *request.mutable_snapshot() = snapshot;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSnapshot(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::filestore::v1::Snapshot>>
CloudFilestoreManagerClient::UpdateSnapshot(
    google::cloud::filestore::v1::UpdateSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSnapshot(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::UpdateSnapshot(
    NoAwaitTag,
    google::cloud::filestore::v1::UpdateSnapshotRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSnapshot(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::filestore::v1::Snapshot>>
CloudFilestoreManagerClient::UpdateSnapshot(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSnapshot(operation);
}

StreamRange<google::cloud::filestore::v1::Backup>
CloudFilestoreManagerClient::ListBackups(std::string const& parent,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::ListBackupsRequest request;
  request.set_parent(parent);
  return connection_->ListBackups(request);
}

StreamRange<google::cloud::filestore::v1::Backup>
CloudFilestoreManagerClient::ListBackups(
    google::cloud::filestore::v1::ListBackupsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListBackups(std::move(request));
}

StatusOr<google::cloud::filestore::v1::Backup>
CloudFilestoreManagerClient::GetBackup(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::GetBackupRequest request;
  request.set_name(name);
  return connection_->GetBackup(request);
}

StatusOr<google::cloud::filestore::v1::Backup>
CloudFilestoreManagerClient::GetBackup(
    google::cloud::filestore::v1::GetBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetBackup(request);
}

future<StatusOr<google::cloud::filestore::v1::Backup>>
CloudFilestoreManagerClient::CreateBackup(
    std::string const& parent,
    google::cloud::filestore::v1::Backup const& backup,
    std::string const& backup_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::CreateBackupRequest request;
  request.set_parent(parent);
  *request.mutable_backup() = backup;
  request.set_backup_id(backup_id);
  return connection_->CreateBackup(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::CreateBackup(
    NoAwaitTag, std::string const& parent,
    google::cloud::filestore::v1::Backup const& backup,
    std::string const& backup_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::CreateBackupRequest request;
  request.set_parent(parent);
  *request.mutable_backup() = backup;
  request.set_backup_id(backup_id);
  return connection_->CreateBackup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::filestore::v1::Backup>>
CloudFilestoreManagerClient::CreateBackup(
    google::cloud::filestore::v1::CreateBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateBackup(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::CreateBackup(
    NoAwaitTag,
    google::cloud::filestore::v1::CreateBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateBackup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::filestore::v1::Backup>>
CloudFilestoreManagerClient::CreateBackup(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateBackup(operation);
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerClient::DeleteBackup(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::DeleteBackupRequest request;
  request.set_name(name);
  return connection_->DeleteBackup(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::DeleteBackup(NoAwaitTag, std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::DeleteBackupRequest request;
  request.set_name(name);
  return connection_->DeleteBackup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerClient::DeleteBackup(
    google::cloud::filestore::v1::DeleteBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBackup(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::DeleteBackup(
    NoAwaitTag,
    google::cloud::filestore::v1::DeleteBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBackup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::common::OperationMetadata>>
CloudFilestoreManagerClient::DeleteBackup(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBackup(operation);
}

future<StatusOr<google::cloud::filestore::v1::Backup>>
CloudFilestoreManagerClient::UpdateBackup(
    google::cloud::filestore::v1::Backup const& backup,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::UpdateBackupRequest request;
  *request.mutable_backup() = backup;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateBackup(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::UpdateBackup(
    NoAwaitTag, google::cloud::filestore::v1::Backup const& backup,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::filestore::v1::UpdateBackupRequest request;
  *request.mutable_backup() = backup;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateBackup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::filestore::v1::Backup>>
CloudFilestoreManagerClient::UpdateBackup(
    google::cloud::filestore::v1::UpdateBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateBackup(request);
}

StatusOr<google::longrunning::Operation>
CloudFilestoreManagerClient::UpdateBackup(
    NoAwaitTag,
    google::cloud::filestore::v1::UpdateBackupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateBackup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::filestore::v1::Backup>>
CloudFilestoreManagerClient::UpdateBackup(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateBackup(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace filestore_v1
}  // namespace cloud
}  // namespace google
