// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/edgenetwork/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EDGENETWORK_V1_MOCKS_MOCK_EDGE_NETWORK_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EDGENETWORK_V1_MOCKS_MOCK_EDGE_NETWORK_CONNECTION_H

#include "google/cloud/edgenetwork/v1/edge_network_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace edgenetwork_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `EdgeNetworkConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `EdgeNetworkClient`. To do so,
 * construct an object of type `EdgeNetworkClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockEdgeNetworkConnection : public edgenetwork_v1::EdgeNetworkConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::edgenetwork::v1::InitializeZoneResponse>,
      InitializeZone,
      (google::cloud::edgenetwork::v1::InitializeZoneRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::edgenetwork::v1::Zone>), ListZones,
              (google::cloud::edgenetwork::v1::ListZonesRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::edgenetwork::v1::Zone>, GetZone,
              (google::cloud::edgenetwork::v1::GetZoneRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::edgenetwork::v1::Network>),
              ListNetworks,
              (google::cloud::edgenetwork::v1::ListNetworksRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::edgenetwork::v1::Network>, GetNetwork,
      (google::cloud::edgenetwork::v1::GetNetworkRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::edgenetwork::v1::DiagnoseNetworkResponse>,
      DiagnoseNetwork,
      (google::cloud::edgenetwork::v1::DiagnoseNetworkRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateNetwork(Matcher<google::cloud::edgenetwork::v1::CreateNetworkRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::edgenetwork::v1::Network>>, CreateNetwork,
      (google::cloud::edgenetwork::v1::CreateNetworkRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateNetwork(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateNetwork,
      (NoAwaitTag,
       google::cloud::edgenetwork::v1::CreateNetworkRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateNetwork(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::edgenetwork::v1::Network>>,
              CreateNetwork, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteNetwork(Matcher<google::cloud::edgenetwork::v1::DeleteNetworkRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>,
      DeleteNetwork,
      (google::cloud::edgenetwork::v1::DeleteNetworkRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteNetwork(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteNetwork,
      (NoAwaitTag,
       google::cloud::edgenetwork::v1::DeleteNetworkRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteNetwork(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>,
      DeleteNetwork, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::edgenetwork::v1::Subnet>),
              ListSubnets,
              (google::cloud::edgenetwork::v1::ListSubnetsRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::edgenetwork::v1::Subnet>, GetSubnet,
              (google::cloud::edgenetwork::v1::GetSubnetRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateSubnet(Matcher<google::cloud::edgenetwork::v1::CreateSubnetRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::edgenetwork::v1::Subnet>>, CreateSubnet,
      (google::cloud::edgenetwork::v1::CreateSubnetRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateSubnet(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateSubnet,
      (NoAwaitTag,
       google::cloud::edgenetwork::v1::CreateSubnetRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateSubnet(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::edgenetwork::v1::Subnet>>,
              CreateSubnet, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateSubnet(Matcher<google::cloud::edgenetwork::v1::UpdateSubnetRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::edgenetwork::v1::Subnet>>, UpdateSubnet,
      (google::cloud::edgenetwork::v1::UpdateSubnetRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateSubnet(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateSubnet,
      (NoAwaitTag,
       google::cloud::edgenetwork::v1::UpdateSubnetRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateSubnet(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::edgenetwork::v1::Subnet>>,
              UpdateSubnet, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteSubnet(Matcher<google::cloud::edgenetwork::v1::DeleteSubnetRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>,
      DeleteSubnet,
      (google::cloud::edgenetwork::v1::DeleteSubnetRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteSubnet(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteSubnet,
      (NoAwaitTag,
       google::cloud::edgenetwork::v1::DeleteSubnetRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteSubnet(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>,
      DeleteSubnet, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::edgenetwork::v1::Interconnect>),
      ListInterconnects,
      (google::cloud::edgenetwork::v1::ListInterconnectsRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::edgenetwork::v1::Interconnect>, GetInterconnect,
      (google::cloud::edgenetwork::v1::GetInterconnectRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::edgenetwork::v1::DiagnoseInterconnectResponse>,
      DiagnoseInterconnect,
      (google::cloud::edgenetwork::v1::DiagnoseInterconnectRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::edgenetwork::v1::InterconnectAttachment>),
      ListInterconnectAttachments,
      (google::cloud::edgenetwork::v1::ListInterconnectAttachmentsRequest
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::edgenetwork::v1::InterconnectAttachment>,
      GetInterconnectAttachment,
      (google::cloud::edgenetwork::v1::GetInterconnectAttachmentRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateInterconnectAttachment(Matcher<google::cloud::edgenetwork::v1::CreateInterconnectAttachmentRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::edgenetwork::v1::InterconnectAttachment>>,
      CreateInterconnectAttachment,
      (google::cloud::edgenetwork::v1::
           CreateInterconnectAttachmentRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateInterconnectAttachment(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>,
              CreateInterconnectAttachment,
              (NoAwaitTag,
               google::cloud::edgenetwork::v1::
                   CreateInterconnectAttachmentRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateInterconnectAttachment(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::edgenetwork::v1::InterconnectAttachment>>,
      CreateInterconnectAttachment,
      (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteInterconnectAttachment(Matcher<google::cloud::edgenetwork::v1::DeleteInterconnectAttachmentRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>,
      DeleteInterconnectAttachment,
      (google::cloud::edgenetwork::v1::
           DeleteInterconnectAttachmentRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteInterconnectAttachment(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>,
              DeleteInterconnectAttachment,
              (NoAwaitTag,
               google::cloud::edgenetwork::v1::
                   DeleteInterconnectAttachmentRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteInterconnectAttachment(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>,
      DeleteInterconnectAttachment,
      (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD((StreamRange<google::cloud::edgenetwork::v1::Router>),
              ListRouters,
              (google::cloud::edgenetwork::v1::ListRoutersRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::edgenetwork::v1::Router>, GetRouter,
              (google::cloud::edgenetwork::v1::GetRouterRequest const& request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::edgenetwork::v1::DiagnoseRouterResponse>,
      DiagnoseRouter,
      (google::cloud::edgenetwork::v1::DiagnoseRouterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateRouter(Matcher<google::cloud::edgenetwork::v1::CreateRouterRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::edgenetwork::v1::Router>>, CreateRouter,
      (google::cloud::edgenetwork::v1::CreateRouterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateRouter(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateRouter,
      (NoAwaitTag,
       google::cloud::edgenetwork::v1::CreateRouterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateRouter(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::edgenetwork::v1::Router>>,
              CreateRouter, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateRouter(Matcher<google::cloud::edgenetwork::v1::UpdateRouterRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::edgenetwork::v1::Router>>, UpdateRouter,
      (google::cloud::edgenetwork::v1::UpdateRouterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateRouter(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateRouter,
      (NoAwaitTag,
       google::cloud::edgenetwork::v1::UpdateRouterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateRouter(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::edgenetwork::v1::Router>>,
              UpdateRouter, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteRouter(Matcher<google::cloud::edgenetwork::v1::DeleteRouterRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>,
      DeleteRouter,
      (google::cloud::edgenetwork::v1::DeleteRouterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteRouter(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteRouter,
      (NoAwaitTag,
       google::cloud::edgenetwork::v1::DeleteRouterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteRouter(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::edgenetwork::v1::OperationMetadata>>,
      DeleteRouter, (google::longrunning::Operation const& operation),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace edgenetwork_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EDGENETWORK_V1_MOCKS_MOCK_EDGE_NETWORK_CONNECTION_H
