// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/data_taxonomy.proto

#include "google/cloud/dataplex/v1/internal/data_taxonomy_connection_impl.h"
#include "google/cloud/dataplex/v1/internal/data_taxonomy_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<dataplex_v1::DataTaxonomyServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<dataplex_v1::DataTaxonomyServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<dataplex_v1::DataTaxonomyServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<dataplex_v1::DataTaxonomyServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<dataplex_v1::DataTaxonomyServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<dataplex_v1::DataTaxonomyServicePollingPolicyOption>()
      ->clone();
}

}  // namespace

DataTaxonomyServiceConnectionImpl::DataTaxonomyServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<dataplex_v1_internal::DataTaxonomyServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), DataTaxonomyServiceConnection::options())) {}

future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
DataTaxonomyServiceConnectionImpl::CreateDataTaxonomy(
    google::cloud::dataplex::v1::CreateDataTaxonomyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateDataTaxonomy(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::DataTaxonomy>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::CreateDataTaxonomyRequest const&
              request) {
        return stub->AsyncCreateDataTaxonomy(cq, std::move(context),
                                             std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataTaxonomy>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnectionImpl::CreateDataTaxonomy(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateDataTaxonomyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateDataTaxonomy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::CreateDataTaxonomyRequest const&
                 request) {
        return stub_->CreateDataTaxonomy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
DataTaxonomyServiceConnectionImpl::CreateDataTaxonomy(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateDataTaxonomy",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::DataTaxonomy>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataTaxonomy>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
DataTaxonomyServiceConnectionImpl::UpdateDataTaxonomy(
    google::cloud::dataplex::v1::UpdateDataTaxonomyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateDataTaxonomy(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::DataTaxonomy>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::UpdateDataTaxonomyRequest const&
              request) {
        return stub->AsyncUpdateDataTaxonomy(cq, std::move(context),
                                             std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataTaxonomy>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnectionImpl::UpdateDataTaxonomy(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateDataTaxonomyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateDataTaxonomy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::UpdateDataTaxonomyRequest const&
                 request) {
        return stub_->UpdateDataTaxonomy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>
DataTaxonomyServiceConnectionImpl::UpdateDataTaxonomy(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::dataplex::v1::DataTaxonomy>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateDataTaxonomy",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::DataTaxonomy>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataTaxonomy>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceConnectionImpl::DeleteDataTaxonomy(
    google::cloud::dataplex::v1::DeleteDataTaxonomyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteDataTaxonomy(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::DeleteDataTaxonomyRequest const&
              request) {
        return stub->AsyncDeleteDataTaxonomy(cq, std::move(context),
                                             std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnectionImpl::DeleteDataTaxonomy(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteDataTaxonomyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteDataTaxonomy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::DeleteDataTaxonomyRequest const&
                 request) {
        return stub_->DeleteDataTaxonomy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceConnectionImpl::DeleteDataTaxonomy(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteDataTaxonomy",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::dataplex::v1::DataTaxonomy>
DataTaxonomyServiceConnectionImpl::ListDataTaxonomies(
    google::cloud::dataplex::v1::ListDataTaxonomiesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListDataTaxonomies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::DataTaxonomy>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::DataTaxonomyServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::dataplex::v1::ListDataTaxonomiesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::dataplex::v1::ListDataTaxonomiesRequest const&
                       request) {
              return stub->ListDataTaxonomies(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::dataplex::v1::ListDataTaxonomiesResponse r) {
        std::vector<google::cloud::dataplex::v1::DataTaxonomy> result(
            r.data_taxonomies().size());
        auto& messages = *r.mutable_data_taxonomies();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dataplex::v1::DataTaxonomy>
DataTaxonomyServiceConnectionImpl::GetDataTaxonomy(
    google::cloud::dataplex::v1::GetDataTaxonomyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetDataTaxonomy(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::GetDataTaxonomyRequest const& request) {
        return stub_->GetDataTaxonomy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
DataTaxonomyServiceConnectionImpl::CreateDataAttributeBinding(
    google::cloud::dataplex::v1::CreateDataAttributeBindingRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateDataAttributeBinding(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::DataAttributeBinding>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::CreateDataAttributeBindingRequest const&
              request) {
        return stub->AsyncCreateDataAttributeBinding(
            cq, std::move(context), std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataAttributeBinding>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnectionImpl::CreateDataAttributeBinding(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateDataAttributeBindingRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateDataAttributeBinding(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::CreateDataAttributeBindingRequest const&
              request) {
        return stub_->CreateDataAttributeBinding(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
DataTaxonomyServiceConnectionImpl::CreateDataAttributeBinding(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateDataAttributeBinding",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::DataAttributeBinding>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataAttributeBinding>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
DataTaxonomyServiceConnectionImpl::UpdateDataAttributeBinding(
    google::cloud::dataplex::v1::UpdateDataAttributeBindingRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateDataAttributeBinding(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::DataAttributeBinding>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::UpdateDataAttributeBindingRequest const&
              request) {
        return stub->AsyncUpdateDataAttributeBinding(
            cq, std::move(context), std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataAttributeBinding>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnectionImpl::UpdateDataAttributeBinding(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateDataAttributeBindingRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateDataAttributeBinding(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::UpdateDataAttributeBindingRequest const&
              request) {
        return stub_->UpdateDataAttributeBinding(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>
DataTaxonomyServiceConnectionImpl::UpdateDataAttributeBinding(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateDataAttributeBinding",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::DataAttributeBinding>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataAttributeBinding>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceConnectionImpl::DeleteDataAttributeBinding(
    google::cloud::dataplex::v1::DeleteDataAttributeBindingRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteDataAttributeBinding(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::DeleteDataAttributeBindingRequest const&
              request) {
        return stub->AsyncDeleteDataAttributeBinding(
            cq, std::move(context), std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnectionImpl::DeleteDataAttributeBinding(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteDataAttributeBindingRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteDataAttributeBinding(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::DeleteDataAttributeBindingRequest const&
              request) {
        return stub_->DeleteDataAttributeBinding(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceConnectionImpl::DeleteDataAttributeBinding(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteDataAttributeBinding",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::dataplex::v1::DataAttributeBinding>
DataTaxonomyServiceConnectionImpl::ListDataAttributeBindings(
    google::cloud::dataplex::v1::ListDataAttributeBindingsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListDataAttributeBindings(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::DataAttributeBinding>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::DataTaxonomyServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::dataplex::v1::ListDataAttributeBindingsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::dataplex::v1::
                       ListDataAttributeBindingsRequest const& request) {
              return stub->ListDataAttributeBindings(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::dataplex::v1::ListDataAttributeBindingsResponse r) {
        std::vector<google::cloud::dataplex::v1::DataAttributeBinding> result(
            r.data_attribute_bindings().size());
        auto& messages = *r.mutable_data_attribute_bindings();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dataplex::v1::DataAttributeBinding>
DataTaxonomyServiceConnectionImpl::GetDataAttributeBinding(
    google::cloud::dataplex::v1::GetDataAttributeBindingRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetDataAttributeBinding(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::GetDataAttributeBindingRequest const&
                 request) {
        return stub_->GetDataAttributeBinding(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
DataTaxonomyServiceConnectionImpl::CreateDataAttribute(
    google::cloud::dataplex::v1::CreateDataAttributeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateDataAttribute(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::DataAttribute>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::CreateDataAttributeRequest const&
              request) {
        return stub->AsyncCreateDataAttribute(cq, std::move(context),
                                              std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataAttribute>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnectionImpl::CreateDataAttribute(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateDataAttributeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateDataAttribute(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::CreateDataAttributeRequest const&
                 request) {
        return stub_->CreateDataAttribute(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
DataTaxonomyServiceConnectionImpl::CreateDataAttribute(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::dataplex::v1::DataAttribute>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateDataAttribute",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::DataAttribute>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataAttribute>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
DataTaxonomyServiceConnectionImpl::UpdateDataAttribute(
    google::cloud::dataplex::v1::UpdateDataAttributeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateDataAttribute(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::DataAttribute>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::UpdateDataAttributeRequest const&
              request) {
        return stub->AsyncUpdateDataAttribute(cq, std::move(context),
                                              std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataAttribute>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnectionImpl::UpdateDataAttribute(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateDataAttributeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateDataAttribute(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::UpdateDataAttributeRequest const&
                 request) {
        return stub_->UpdateDataAttribute(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::DataAttribute>>
DataTaxonomyServiceConnectionImpl::UpdateDataAttribute(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::dataplex::v1::DataAttribute>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateDataAttribute",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::DataAttribute>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::DataAttribute>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceConnectionImpl::DeleteDataAttribute(
    google::cloud::dataplex::v1::DeleteDataAttributeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteDataAttribute(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dataplex::v1::DeleteDataAttributeRequest const&
              request) {
        return stub->AsyncDeleteDataAttribute(cq, std::move(context),
                                              std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DataTaxonomyServiceConnectionImpl::DeleteDataAttribute(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteDataAttributeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteDataAttribute(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dataplex::v1::DeleteDataAttributeRequest const&
                 request) {
        return stub_->DeleteDataAttribute(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataTaxonomyServiceConnectionImpl::DeleteDataAttribute(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::dataplex::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::dataplex::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteDataAttribute",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::dataplex::v1::DataAttribute>
DataTaxonomyServiceConnectionImpl::ListDataAttributes(
    google::cloud::dataplex::v1::ListDataAttributesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListDataAttributes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::DataAttribute>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::DataTaxonomyServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::dataplex::v1::ListDataAttributesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::dataplex::v1::ListDataAttributesRequest const&
                       request) {
              return stub->ListDataAttributes(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::dataplex::v1::ListDataAttributesResponse r) {
        std::vector<google::cloud::dataplex::v1::DataAttribute> result(
            r.data_attributes().size());
        auto& messages = *r.mutable_data_attributes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dataplex::v1::DataAttribute>
DataTaxonomyServiceConnectionImpl::GetDataAttribute(
    google::cloud::dataplex::v1::GetDataAttributeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetDataAttribute(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dataplex::v1::GetDataAttributeRequest const& request) {
        return stub_->GetDataAttribute(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google
